/*	
 *	tixml.c
 *
 *	XML DOM parser
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2006 Naoyuki Sawa
 *
 *	* Sat Nov 25 20:20:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	- TinyXml version 1.2.4 QlɂāA쐬܂B
 *	  ȉɁAIWi TinyXml version 1.2.4  Copyright p܂B
 *	  ------------------------------------------------------------------------
 *	  Copyright (c) 2000 Lee Thomason (www.grinninglizard.com)
 *	  
 *	  This software is provided 'as-is', without any express or implied 
 *	  warranty. In no event will the authors be held liable for any 
 *	  damages arising from the use of this software.
 *	  
 *	  Permission is granted to anyone to use this software for any 
 *	  purpose, including commercial applications, and to alter it and 
 *	  redistribute it freely, subject to the following restrictions:
 *	  
 *	  1. The origin of this software must not be misrepresented; you must 
 *	  not claim that you wrote the original software. If you use this 
 *	  software in a product, an acknowledgment in the product documentation 
 *	  would be appreciated but is not required.
 *	  
 *	  2. Altered source versions must be plainly marked as such, and 
 *	  must not be misrepresented as being the original software.
 *	  
 *	  3. This notice may not be removed or altered from any source 
 *	  distribution.
 *	  ------------------------------------------------------------------------
 *	- {Iɂ́ATinyXml ̐݌v̂܂܂ŁAC++CɈڐAłB
 *	  AG[폜ċIɕύX铙A啝Ɋȗ܂B
 *	- TinyXml version 1.2.4 ͂Ȃ苌o[WȂ̂ŁA肪L܂B
 *	  VATinyXml version 2.5.2 ̃\[XQlACt͏C܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

/* 󔒂XLbv܂B
 * [in]
 *	p		Jnʒũ|C^B
 * [out]
 *	߂l		󔒈ȊO̕A܂́AI[nulւ̃|C^B
 */
static const char*
SkipWhiteSpace(const char* p)
{
	while(isspace(*p)) {
		p++;
	}

	return p;
}

/* ^OA܂́Aǂݎ܂B
 * [in]
 *	p		̂̈ꕶڂւ̃|C^B
 *	name		̂i[镶ւ̃|C^B
 * [out]
 *	߂l		̂̒ւ̃|C^B
 *	name		̂i[Ă܂B
 * [note]
 *	* ̊֐Ă΂ꂽAname͋󕶎̏Ԃł邱ƂOłB
 *	  󕶎łȂnamew肵ČĂяoƁAʂƂȂ܂B
 */
static const char*
ReadName(const char* p, /*[out]*/ StdString* name)
{
	int c;

	/* ̂AAt@xbg܂̓A_[XRAŎn܂Ă邱ƂmF܂B */
	c = *p;
	if(isalpha(c) || c == '_') {
		do {
			/* ̂ɁAꕶǉ܂B */
			StdString_append(name, (char*)&c);

			/* |C^̈̕ʒu֐i߁Aꕶ擾܂B */
			c = *++p;

		/* 񕶎ڈȍ~́AAt@xbgAlAA_[XRAAnCtARłB
		 * (TinyXMĹAOԂ̃vtBNX̂Ɋ܂߂Ĉ߁AR܂߂܂B)
		 */
		} while(isalnum(c) || c == '_' || c == '-' || c == ':');

		/* ̈ȊO̕ɏoAÄʒũ|C^Ԃ܂B */
		return p;
	}

	/* At@xbg܂̓A_[XRAwԂŌĂ΂Ȃ΂Ȃ܂B */
	DIE();
}

/* hLg̃m[h{錾,vf,Rg,s}ʂč쐬Ap[X܂B
 * [in]
 *	where		m[h擪́u<vւ̃|C^ւ̃|C^B
 * [out]
 *	where		m[h́u>v̒ւ̃|C^ōXVB
 */
static TiXmlNode*
IdentifyAndParse(const char** where)
{
	TiXmlNode* node;

	/* |C^o܂B */
	const char* p = *where;

	/* u<vwԂŌĂ΂Ȃ΂Ȃ܂B */
	if(*p != '<') {
		DIE();
	}

	/* u<v̌̋󔒂XLbv܂B */
	p = SkipWhiteSpace(p + 1);

	/* u?xmlvȂ΁A錾m[h쐬܂B */
	if(tolower(p[0]) == '?' &&
	   tolower(p[1]) == 'x' &&
	   tolower(p[2]) == 'm' &&
	   tolower(p[3]) == 'l') {
		node = TiXmlDeclaration_super(TiXmlDeclaration_new(NULL, NULL, NULL));

	/* At@xbg܂̓A_[XRAŎn܂^OȂ΁Avfm[h쐬܂B */
	} else if(isalpha(*p) || *p == '_') {
		node = TiXmlElement_super(TiXmlElement_new(NULL));

	/* u!--vȂ΁ARg쐬܂B */
	} else if(p[0] == '!' &&
	          p[1] == '-' &&
	          p[2] == '-') {
		node = TiXmlComment_super(TiXmlComment_new());

	/* ȊÓAsm[h쐬܂B */
	} else {
		node = TiXmlUnknown_super(TiXmlUnknown_new());
	}

	/* m[h̓ep[X܂B */
	p = node->vptr->Parse(node, p);

	/* |C^߂܂B */
	*where = p;

	/* 쐬Ap[Xm[hԂ܂B */
	return node;
}

/* Cfgo͂܂B
 * [in]
 *	fp		o͐Xg[B
 *	depth		Cfg̐[B
 */
static void
Indent(FILE* fp, int depth)
{
	int i;

	for(i = 0; i < depth; i++) {
		fprintf(fp, "\t");
	}
}

/****************************************************************************
 *	StdString
 ****************************************************************************/

/* * Tue Dec 05 00:37:14 JST 2006 Naoyuki Sawa
 * - StdString.buf̃蓖ĒPʂ`܂B
 *   ̒l傫قǃ蓖ĉ񐔂͌A܂AgpȂ܂B
 * - Cӂ(2^N)̒lɒ\łA4ɂ͐ݒ肵ȂłB
 *   P/ECEJ[l̃蓖Ă4oCgPʂɐ؂グ̂ŁA4ɂĂgp͉P܂B
 * - ۂɊi[镶̕ϓIȒɋ߂قǁAxƃgp̃oXǂȂ܂B
 *   8܂16xK؂Ǝv܂A܂́AŒ4ŎĂ݂邱Ƃɂ܂B(2006/12/05)
 */
#define StdString_BufUnit	(1<<2)

/* 쐬܂B
 * [in]
 *	p		̏lւ̃|C^B
 *			NULLw肷ƁA󕶎쐬܂B
 */
StdString*
StdString_new(const char* p/*=NULL*/)
{
	StdString* This = calloc(1, sizeof *This);
	if(!This) {
		DIE();
	}
	_StdString_construct(This, p);
	return This;
}

/* 폜܂B
 */
void
StdString_delete(StdString* This)
{
	if(This) {
		/** no virtual destructor **/
		_StdString_destruct(This);
		free(This);
	}
}

/* ̃RXgN^łB
 * [in]
 *	p		̏lւ̃|C^B
 *			NULLw肷ƁA󕶎ɏ܂B
 */
void
_StdString_construct(StdString* This, const char* p/*=NULL*/)
{
	/** no base class **/
	/** no vptr **/

	StdString_assign(This, p);
}

/* ̃fXgN^łB
 */
/*virtual*/ void
_StdString_destruct(StdString* This)
{
	free(This->buf/*NULLOK*/);

	/** no base class **/
}

/* kI[ւ̃|C^擾܂B
 * [out]
 *	߂l		kI[ւ̃|C^B
 */
const char*
StdString_c_str(StdString* This)
{
	return This->buf ? This->buf : "";
}

/* ݒ肵܂B
 * [in]
 *	p		̐ݒlւ̃|C^B
 *			NULLw肷ƁA󕶎ɐݒ肵܂B
 */
void
StdString_assign(StdString* This, const char* p/*=NULL*/)
{
	int len1;
	int cap1;
	int len2;
	int cap2;

	/* 󕶎̑Ȃ΁Aobt@J܂B */
	if(!p || !*p) {
		free(This->buf/*NULLOK*/);
		This->buf = NULL;
		return; /* ܂ */
	}

	/* ݂̕ƁÃ݂obt@TCY߂܂B */
	if(This->buf) {
		len1 = strlen(This->buf);
		cap1 = ((len1 + 1/*nul*/) + (StdString_BufUnit - 1)) & ~(StdString_BufUnit - 1);
	} else {
		len1 = 0;
		cap1 = 0;
	}

	/* 镶ƁAɕKvȃobt@TCY߂܂B */
	len2 = strlen(p);
	cap2 = ((len2 + 1/*nul*/) + (StdString_BufUnit - 1)) & ~(StdString_BufUnit - 1);

	/* obt@TCYωAĊ蓖Ă܂B */
	if(cap1 != cap2) {
		This->buf = realloc(This->buf/*NULLOK*/, cap2);
		if(!This->buf) {
			DIE();
		}
	}

	/* 镶Rs[܂B */
	memcpy(This->buf, p, len2 + 1/*nul*/);
}

/* ǉ܂B
 * [in]
 *	p		ǉ镶ւ̃|C^B
 *			NULLw肷ƁAs܂B
 */
void
StdString_append(StdString* This, const char* p/*=NULL*/)
{
	int len1;
	int cap1;
	int len2;
	int cap2;

	/* 󕶎̘AȂ΁A܂B */
	if(!p || !*p) {
		return; /* ܂ */
	}

	/* ݂̕ƁÃ݂obt@TCY߂܂B */
	if(This->buf) {
		len1 = strlen(This->buf);
		cap1 = ((len1 + 1/*nul*/) + (StdString_BufUnit - 1)) & ~(StdString_BufUnit - 1);
	} else {
		len1 = 0;
		cap1 = 0;
	}

	/* A镶ƁAAɕKvȃobt@TCY߂܂B */
	len2 = strlen(p);
	cap2 = ((len1 + len2 + 1/*nul*/) + (StdString_BufUnit - 1)) & ~(StdString_BufUnit - 1);

	/* obt@TCYωAĊ蓖Ă܂B */
	if(cap1 != cap2) {
		This->buf = realloc(This->buf/*NULLOK*/, cap2);
		if(!This->buf) {
			DIE();
		}
	}

	/* 镶Rs[܂B */
	memcpy(This->buf + len1, p, len2 + 1/*nul*/);
}

/****************************************************************************
 *	TiXmlBase
 ****************************************************************************/

static const TiXmlBase_vtbl _TiXmlBase_vtbl = {
	_TiXmlBase_destruct,	/*destruct*/
	NULL,			/*Print*/
	/*TiXmlBase_vtbl*/
};

/* XML DOMIuWFNg폜܂B
 */
void
TiXmlBase_delete(TiXmlBase* This)
{
	if(This) {
		This->vptr->destruct(This);
		free(This);
	}
}

/* XML DOMIuWFNg̃RXgN^łB
 */
void
_TiXmlBase_construct(TiXmlBase* This)
{
	/** no base class **/
	This->vptr = &_TiXmlBase_vtbl;
}

/* XML DOMIuWFNg̃fXgN^łB
 */
/*virtual*/ void
_TiXmlBase_destruct(TiXmlBase* This)
{
	/** no base class **/
}

/****************************************************************************
 *	TiXmlNode
 ****************************************************************************/

static const TiXmlNode_vtbl _TiXmlNode_vtbl = {
	_TiXmlNode_destruct,	/*destruct*/
	NULL,			/*Print*/
	/*TiXmlBase_vtbl*/
	NULL,			/*Clone*/
	NULL,			/*Parse*/
	/*TiXmlNode_vtbl*/
};

/* XMLm[h폜܂B
 */
void
TiXmlNode_delete(TiXmlNode* This)
{
	if(This) {
		This->vptr->destruct(This);
		free(This);
	}
}

/* XMLm[h̃RXgN^łB
 */
void
_TiXmlNode_construct(TiXmlNode* This)
{
	_TiXmlBase_construct(TiXmlNode_super(This));
	This->vptr = &_TiXmlNode_vtbl;

	/* l쐬܂B */
	This->value = StdString_new(NULL);
}

/* XMLm[h̃fXgN^łB
 * [note]
 *	- IWi TinyXml version 1.2.4 ƈႢA{Cu͎qm[hǉɃRs[쐬ȂdlłB
 *	  (TiXmlNode_InsertEndChild()̃RgQƂĂB)
 *	  fXgN^ɂẮAIWi TinyXml version 1.2.4 ƓAqm[hSč폜܂B
 *	  ǉ(Rs[쐬Ȃ)Ƃ̑Ώ̐Ɍ܂A֐D悵Ă̂悤ȎdlƂ܂B
 *	- qm[h̒ǉɁA̎qm[h̏Lem[hɈڂ(em[h폜)AƍlĂB
 *	  TiXmlNode_ReplaceChild()A܂́ATiXmlNode_RemoveChild()ŎOƁAem[h珊L߂܂B
 */
/*virtual*/ void
_TiXmlNode_destruct(TiXmlNode* This)
{
	/* qm[hSč폜܂B */
	TiXmlNode_Clear(This);

	/* l폜܂B */
	StdString_delete(This->value);

	_TiXmlBase_destruct(TiXmlNode_super(This));
}

/* l擾܂B
 * [out]
 *	߂l		lB
 * [note]
 *	* l̗pŕAhNXɈقȂ܂B
 */
const char*
TiXmlNode_Value(TiXmlNode* This)
{
	return StdString_c_str(This->value);
}

/* lݒ肵܂B
 * [in]
 *	value		lB
 * [note]
 *	* l̗pŕAhNXɈقȂ܂B
 */
void
TiXmlNode_SetValue(TiXmlNode* This, const char* value)
{
	StdString_assign(This->value, value);
}

/* qm[hSč폜܂B
 */
void
TiXmlNode_Clear(TiXmlNode* This)
{
	TiXmlNode* node = This->firstChild;

	while(node) {
		TiXmlNode* next = node->next;
		TiXmlNode_delete(node);
		node = next;
	}

	This->firstChild = NULL;
	This->lastChild = NULL;
}

/* 擪̎qm[h擾܂B
 * [in]
 *	value		̒lɈvqm[ĥA擪̎qm[h擾܂B
 *			NULLw肵ꍇAPɁA擪̎qm[h擾܂B
 * [out]
 *	߂l		Ɉvqm[hL΁Ã|C^Ԃ܂B
 *			Ɉvqm[h΁ANULLԂ܂B
 */
TiXmlNode*
TiXmlNode_FirstChild(TiXmlNode* This, const char* value/*=NULL*/)
{
	TiXmlNode* node;

	for(node = This->firstChild;
	    node;
	    node = node->next) {
		if(!value ||
		   !strcmp(TiXmlNode_Value(node), value)) {
			return node;
		}
	}

	return NULL;
}

/* ̎qm[h擾܂B
 * [in]
 *	value		̒lɈvqm[ĥA̎qm[h擾܂B
 *			NULLw肵ꍇAPɁA̎qm[h擾܂B
 * [out]
 *	߂l		Ɉvqm[hL΁Ã|C^Ԃ܂B
 *			Ɉvqm[h΁ANULLԂ܂B
 */
TiXmlNode*
TiXmlNode_LastChild(TiXmlNode* This, const char* value/*=NULL*/)
{
	TiXmlNode* node;

	for(node = This->lastChild;
	    node;
	    node = node->prev) {
		if(!value ||
		   !strcmp(TiXmlNode_Value(node), value)) {
			return node;
		}
	}

	return NULL;
}

/* qm[h𑖍܂B
 * [in]
 *	value		̒lɈvqm[h𑖍܂B
 *			NULLw肵ꍇASĂ̎qm[h𑖍܂B
 *	previous	́ANULLw肵ĂB
 *			ڈȍ~́AO̖߂lw肵ĂB
 * [out]
 *	߂l		Ɉvqm[h܂L΁Ã|C^Ԃ܂B
 *			Ɉvqm[hȂANULLԂ܂B
 * [note]
 *	- ȉ̗̂悤ɗpĂB
 *		TiXmlNode* child = NULL;
 *		while((child = TiXmlNode_IterateChildren(parent, value, child) != NULL) {
 *			// childgďs //
 *		}
 */
TiXmlNode*
TiXmlNode_IterateChildren(TiXmlNode* This, const char* value/*=NULL*/, TiXmlNode* previous)
{
	if(!previous) {
		return TiXmlNode_FirstChild(This, value);
	} else {
		return TiXmlNode_NextSibling(previous, value);
	}
}

/* Ɏqm[hǉ܂B
 * [in]
 *	addThis		ǉqm[hB
 * [note]
 *	- IWiTinyXml version 1.2.4́Aw肳ꂽqm[hgłȂARs[쐬ĒǉdlłB
 *	  {Cuł́ARs[łȂAw肳ꂽqm[hgǉ悤AdlύX܂B
 *	  Rs[̃IuWFNgX^bN̒lIuWFNgƂč쐬łC++łƈāA
 *	  Cłł͏Ƀq[v̎QƃIuWFNgƂč쐬̂ŁARs[ӖȂƔf߂łB
 */
void
TiXmlNode_InsertEndChild(TiXmlNode* This, TiXmlNode* addThis)
{
	addThis->prev = This->lastChild;
	addThis->next = NULL;

	if(This->lastChild) {
		This->lastChild->next = addThis;
	} else {
		This->firstChild = addThis;
	}
	This->lastChild = addThis;
}

/* wʒu̒OɁAqm[hǉ܂B
 * [in]
 *	beforeThis	ʒuw肷qm[hB
 *	addThis		ǉqm[hB
 * [note]
 *	- Rs[ł͂ȂAw肳ꂽqm[hgǉ܂B
 *	  TiXmlNode_InsertEndChild()̃RgQƂĂB
 */
void
TiXmlNode_InsertBeforeChild(TiXmlNode* This, TiXmlNode* beforeThis, TiXmlNode* addThis)
{
	addThis->next = beforeThis;
	addThis->prev = beforeThis->prev;

	if(beforeThis->prev) {
		beforeThis->prev->next = addThis;
	} else {
		This->firstChild = addThis;
	}
	beforeThis->prev = addThis;
}

/* wʒu̒ɁAqm[hǉ܂B
 * [in]
 *	afterThis	ʒuw肷qm[hB
 *	addThis		ǉqm[hB
 * [note]
 *	- Rs[ł͂ȂAw肳ꂽqm[hgǉ܂B
 *	  TiXmlNode_InsertEndChild()̃RgQƂĂB
 */
void
TiXmlNode_InsertAfterChild(TiXmlNode* This, TiXmlNode* afterThis, TiXmlNode* addThis)
{
	addThis->prev = afterThis;
	addThis->next = afterThis->next;

	if(afterThis->next) {
		afterThis->next->prev = addThis;
	} else {
		This->lastChild = addThis;
	}
	afterThis->next = addThis;
}

/* w肵qm[hNOAʒuɁAɕʂ̎qm[hN܂B
 * [in]
 *	replaceThis	NOqm[hB
 *	withThis	ɃNqm[hB
 * [note]
 *	- Rs[ł͂ȂAw肳ꂽqm[hgǉ܂B
 *	  TiXmlNode_InsertEndChild()̃RgQƂĂB
 *	- IWiTinyXml version 1.2.4́AOqm[h(replaceThis)͎Iɍ폜dlłB
 *	  {Cuł́AOqm[hIɍ폜ȂdlɕύX܂B
 *	  ǉ(Rs[쐬Ȃ)Ƃ̑Ώ̐ێ邽߂̎dlύXŁA֐Rł͂܂B
 *	  Oqm[h́AsvȂΖIɍ폜悤AӂĂB
 */
void
TiXmlNode_ReplaceChild(TiXmlNode* This, TiXmlNode* replaceThis, TiXmlNode* withThis)
{
	withThis->next = replaceThis->next;
	withThis->prev = replaceThis->prev;

	if(replaceThis->next) {
		replaceThis->next->prev = withThis;
	} else {
		This->lastChild = withThis;
	}
	if(replaceThis->prev) {
		replaceThis->prev->next = withThis;
	} else {
		This->firstChild = withThis;
	}

	replaceThis->next = NULL;
	replaceThis->prev = NULL;
}

/* qm[hNO܂B
 * [in]
 *	removeThis	NOqm[hB
 * [note]
 *	- IWiTinyXml version 1.2.4́AOqm[h(removeThis)͎Iɍ폜dlłB
 *	  {Cuł́AOqm[hIɍ폜ȂdlɕύX܂B
 *	  ǉ(Rs[쐬Ȃ)Ƃ̑Ώ̐ێ邽߂̎dlύXŁA֐Rł͂܂B
 *	  Oqm[h́AsvȂΖIɍ폜悤AӂĂB
 */
void
TiXmlNode_RemoveChild(TiXmlNode* This, TiXmlNode* removeThis)
{
	if(removeThis->next) {
		removeThis->next->prev = removeThis->prev;
	} else {
		This->lastChild = removeThis->prev;
	}
	if(removeThis->prev) {
		removeThis->prev->next = removeThis->next;
	} else {
		This->firstChild = removeThis->next;
	}

	removeThis->next = NULL;
	removeThis->prev = NULL;
}

/* ̌Zm[h擾܂B
 * [in]
 *	value		̒lɈvZm[ĥǍZm[h擾܂B
 *			NULLw肵ꍇAPɁǍZm[h擾܂B
 * [out]
 *	߂l		ɈvZm[hL΁Ã|C^Ԃ܂B
 *			ɈvZm[h΁ANULLԂ܂B
 */
TiXmlNode*
TiXmlNode_NextSibling(TiXmlNode* This, const char* value/*=NULL*/)
{
	TiXmlNode* node;

	for(node = This->next;
	    node;
	    node = node->next) {
		if(!value ||
		   !strcmp(TiXmlNode_Value(node), value)) {
			return node;
		}
	}

	return NULL;
}

/* ǑZm[h擾܂B
 * [in]
 *	value		̒lɈvZm[ĥAǑZm[h擾܂B
 *			NULLw肵ꍇAPɁAǑZm[h擾܂B
 * [out]
 *	߂l		ɈvZm[hL΁Ã|C^Ԃ܂B
 *			ɈvZm[h΁ANULLԂ܂B
 */
TiXmlNode*
TiXmlNode_PreviousSibling(TiXmlNode* This, const char* value/*=NULL*/)
{
	TiXmlNode* node;

	for(node = This->prev;
	    node;
	    node = node->prev) {
		if(!value ||
		   !strcmp(TiXmlNode_Value(node), value)) {
			return node;
		}
	}

	return NULL;
}

/* vfm[hɌ肵āǍZm[h擾܂B
 * [in]
 *	value		̒lɈvZm[ĥǍZm[h擾܂B
 *			NULLw肵ꍇAPɁǍZm[h擾܂B
 * [out]
 *	߂l		ɈvZm[hL΁Ã|C^Ԃ܂B
 *			ɈvZm[h΁ANULLԂ܂B
 */
TiXmlElement*
TiXmlNode_NextSiblingElement(TiXmlNode* This, const char* value/*=NULL*/)
{
	TiXmlNode* node;

	for(node = TiXmlNode_NextSibling(This, value);
	    node;
	    node = TiXmlNode_NextSibling(node, value)) {
		if(TiXmlNode_ToElement(node)) {
			return TiXmlNode_ToElement(node);
		}
	}

	return NULL;
}

/* vfm[hɌ肵āA擪̎qm[h擾܂B
 * [in]
 *	value		̒lɈvqm[ĥA擪̎qm[h擾܂B
 *			NULLw肵ꍇAPɁA擪̎qm[h擾܂B
 * [out]
 *	߂l		Ɉvqm[hL΁Ã|C^Ԃ܂B
 *			Ɉvqm[h΁ANULLԂ܂B
 */
TiXmlElement*
TiXmlNode_FirstChildElement(TiXmlNode* This, const char* value/*=NULL*/)
{
	TiXmlNode* node;

	for(node = TiXmlNode_FirstChild(This, value);
	    node;
	    node = TiXmlNode_NextSibling(node, value)) {
		if(TiXmlNode_ToElement(node)) {
			return TiXmlNode_ToElement(node);
		}
	}

	return NULL;
}

/****************************************************************************
 *	TiXmlElement
 ****************************************************************************/

static const TiXmlElement_vtbl _TiXmlElement_vtbl = {
	_TiXmlElement_destruct,	/*destruct*/
	_TiXmlElement_Print,	/*Print*/
	/*TiXmlBase_vtbl*/
	_TiXmlElement_Clone,	/*Clone*/
	_TiXmlElement_Parse,	/*Parse*/
	/*TiXmlNode_vtbl*/
	/*TiXmlElement_vtbl*/
};

/* vfm[h쐬܂B
 * [in]
 *	value		vfB
 *			NULLw肷ƁA󕶎ƌȂ܂B
 */
TiXmlElement*
TiXmlElement_new(const char* value/*=NULL*/)
{
	TiXmlElement* This = calloc(1, sizeof *This);
	if(!This) {
		DIE();
	}
	_TiXmlElement_construct(This, value);
	return This;
}

/* vfm[h폜܂B
 */
void
TiXmlElement_delete(TiXmlElement* This)
{
	if(This) {
		This->vptr->destruct(This);
		free(This);
	}
}

/* vfm[h̃RXgN^łB
 * [in]
 *	value		vfB
 *			NULLw肷ƁA󕶎ƌȂ܂B
 */
void
_TiXmlElement_construct(TiXmlElement* This, const char* value/*=NULL*/)
{
	_TiXmlNode_construct(TiXmlElement_super(This));
	This->vptr = &_TiXmlElement_vtbl;

	/* Zbg쐬܂B */
	This->attributeSet = TiXmlAttributeSet_new();

	/* vfݒ肵܂B */
	StdString_assign(This->value, value);
}

/* vfm[h̃fXgN^łB
 */
/*virtual*/ void
_TiXmlElement_destruct(TiXmlElement* This)
{
	/* Zbg폜܂B */
	TiXmlAttributeSet_delete(This->attributeSet);

	_TiXmlNode_destruct(TiXmlElement_super(This));
}

/* l擾܂B
 * [in]
 *	name		B
 * [out]
 *	߂l		lB
 *			w肳ꂽɈv鑮ꍇ́ANULLԂ܂B
 */
const char*
TiXmlElement_Attribute(TiXmlElement* This, const char* name)
{
	TiXmlAttribute* attribute = TiXmlAttributeSet_Find(This->attributeSet, name);

	if(attribute) {
		return TiXmlAttribute_Value(attribute);
	}

	return NULL;
}

/* ݒ肵܂B
 * [in]
 *	name		B
 *	value		lB
 * [note]
 *	- ɓ̑ݒ肳Ăꍇ́Alu܂B
 */
void
TiXmlElement_SetAttribute(TiXmlElement* This, const char* name, const char* value)
{
	TiXmlAttribute* attribute = TiXmlAttributeSet_Find(This->attributeSet, name);

	if(attribute) {
		TiXmlAttribute_SetValue(attribute, value);
		return;
	}

	attribute = TiXmlAttribute_new(name, value);
	TiXmlAttributeSet_Add(This->attributeSet, attribute);
}

/* 폜܂B
 * [in]
 *	name		B
 * [note]
 *	- w肳ꂽɈv鑮ꍇ́As܂B
 */
void
TiXmlElement_RemoveAttribute(TiXmlElement* This, const char* name)
{
	TiXmlAttribute* attribute = TiXmlAttributeSet_Find(This->attributeSet, name);

	if(attribute) {
		TiXmlAttributeSet_Remove(This->attributeSet, attribute);
		TiXmlAttribute_delete(attribute);
	}
}

/* 擪̑擾܂B
 * [out]
 *	߂l		̃|C^B
 *			ꍇ́ANULLԂ܂B
 */
TiXmlAttribute*
TiXmlElement_FirstAttribute(TiXmlElement* This)
{
	return TiXmlAttributeSet_First(This->attributeSet);
}

/* ̑擾܂B
 * [out]
 *	߂l		̃|C^B
 *			ꍇ́ANULLԂ܂B
 */
TiXmlAttribute*
TiXmlElement_LastAttribute(TiXmlElement* This)
{
	return TiXmlAttributeSet_Last(This->attributeSet);
}

/* vfm[h𕡐܂B
 * [out]
 *	߂l		vfm[hB
 */
/*virtual*/ TiXmlNode*
_TiXmlElement_Clone(TiXmlElement* This)
{
	TiXmlElement* clone = TiXmlElement_new(StdString_c_str(This->value));	/* vf𕡐 */
	TiXmlAttribute* attribute;
	TiXmlNode* node;

	/* Zbg𕡐 */
	for(attribute = TiXmlAttributeSet_First(This->attributeSet);
	    attribute;
	    attribute = TiXmlAttribute_Next(attribute)) {
		TiXmlElement_SetAttribute(clone, TiXmlAttribute_Name(attribute), TiXmlAttribute_Value(attribute));
	}

	/* qm[h𕡐 */
	for(node = This->firstChild;
	    node;
	    node = TiXmlNode_NextSibling(node, NULL)) {
		TiXmlNode_InsertEndChild(TiXmlElement_super(clone), node->vptr->Clone(node));
	}

	return TiXmlElement_super(clone);
}

/* vfm[ho͂܂B
 * [in]
 *	fp		o͐Xg[B
 *	depth		Cfg̐[B
 */
/*virtual*/ void
_TiXmlElement_Print(TiXmlElement* This, FILE* fp, int depth)
{
	TiXmlAttribute* attribute;
	TiXmlNode* node;

	Indent(fp, depth);
	fprintf(fp, "<%s", StdString_c_str(This->value));

	for(attribute = TiXmlAttributeSet_First(This->attributeSet);
	    attribute;
	    attribute = TiXmlAttribute_Next(attribute)) {
		fprintf(fp, " ");
		attribute->vptr->Print(attribute, fp, 0);
	}

	if(This->firstChild) {
		fprintf(fp, ">");
		for(node = This->firstChild;
		    node;
		    node = TiXmlNode_NextSibling(node, NULL)) {
			if(!TiXmlNode_ToText(node)) {
				fprintf(fp, "\n");
			}
			node->vptr->Print(node, fp, depth + 1);
		}
		fprintf(fp, "\n");
		Indent(fp, depth);
		fprintf(fp, "</%s>", StdString_c_str(This->value));
	} else {
		fprintf(fp, " />");
	}
}

/* vfm[hp[X܂B
 * [in]
 *	p		p[XJnʒuւ̃|C^B
 * [out]
 *	߂l		p[XIʒuւ̃|C^B
 * [note]
 *	- vfm[h쐬ɌĂ΂邱ƂOłB
 *	  ɗvfݒ肳ĂAqm[hǉꂽԂŃp[XƁAʂƂȂ܂B
 */
/*virtual*/ const char*
_TiXmlElement_Parse(TiXmlElement* This, const char* p)
{
	TiXmlAttribute* attribute;
	int len;

	/* vf擾܂B */
	p = ReadName(p, This->value);

	for(;;) {
		/* 󔒂XLbv܂B */
		p = SkipWhiteSpace(p);

		/* u/>vAvf^OłB */
		if(*p == '/') {
			if(p[1] != '>') {
				DIE();
			}

			/* u/>v̒ւ̃|C^Ԃ܂B */
			return p + 2;

		/* u>vAJn^OłB */
		} else if(*p == '>') {
			/* vf̓e擾܂B */
			p = TiXmlElement_ReadValue(This, p + 1);

			/* I^OmF܂B */
			len = strlen(StdString_c_str(This->value));
			if(p[0] != '<' ||
			   p[1] != '/' ||
			   strncmp(p + 2, StdString_c_str(This->value), len) ||
			   p[2 + len] != '>') {
				DIE();
			}

			/* I^O̒ւ̃|C^Ԃ܂B */
			return p + 2/*u</v*/ + len/*value*/ + 1/*u>v*/;

		/* ȊOȂ΁AƌȂĎ擾Ă݂܂B */
		} else {
			attribute = TiXmlAttribute_new(NULL, NULL);
			p = TiXmlAttribute_Parse(attribute, p);
			TiXmlElement_SetAttribute(This, TiXmlAttribute_Name(attribute), TiXmlAttribute_Value(attribute));
			TiXmlAttribute_delete(attribute);
		}
	}
}

/* Jn^OƏI^O̊Ԃp[X܂B
 * [in]
 *	p		Jn^Öʒuւ̃|C^B
 * [out]
 *	߂l		I^O̐擪ʒuւ̃|C^B
 */
const char*
TiXmlElement_ReadValue(TiXmlElement* This, const char* p)
{
	TiXmlText* text;
	TiXmlNode* node;

	for(;;) {
		/* eLXgL΁Aqm[hƂĒǉ܂B */
		text = TiXmlText_new();
		p = text->vptr->Parse(text, p);
		if(*TiXmlNode_Value(TiXmlText_super(text))) {
			TiXmlNode_InsertEndChild(TiXmlElement_super(This), TiXmlText_super(text));
		} else {
			TiXmlText_delete(text);
		}

		/* eLXgȊOȂΎqvf̊Jn^OA܂́Ag̏I^OłB */
		if(p[0] != '<') {
			DIE();
		}
		if(p[1] != '/') {
			/* qvfp[XAqm[hƂĒǉ܂B */
			node = IdentifyAndParse(&p);
			TiXmlNode_InsertEndChild(TiXmlElement_super(This), node);
		} else {
			/* g̏I^O̐擪ʒuւ̃|C^Ԃ܂B */
			return p;
		}
	}
}

/****************************************************************************
 *	TiXmlComment
 ****************************************************************************/

static const TiXmlComment_vtbl _TiXmlComment_vtbl = {
	_TiXmlComment_destruct,	/*destruct*/
	_TiXmlComment_Print,	/*Print*/
	/*TiXmlBase_vtbl*/
	_TiXmlComment_Clone,	/*Clone*/
	_TiXmlComment_Parse,	/*Parse*/
	/*TiXmlNode_vtbl*/
	/*TiXmlComment_vtbl*/
};

/* Rgm[h쐬܂B
 */
TiXmlComment*
TiXmlComment_new()
{
	TiXmlComment* This = calloc(1, sizeof *This);
	if(!This) {
		DIE();
	}
	_TiXmlComment_construct(This);
	return This;
}

/* Rgm[h폜܂B
 */
void
TiXmlComment_delete(TiXmlComment* This)
{
	if(This) {
		This->vptr->destruct(This);
		free(This);
	}
}

/* Rgm[h̃RXgN^łB
 */
void
_TiXmlComment_construct(TiXmlComment* This)
{
	_TiXmlNode_construct(TiXmlComment_super(This));
	This->vptr = &_TiXmlComment_vtbl;
}

/* Rgm[h̃fXgN^łB
 */
/*virtual*/ void
_TiXmlComment_destruct(TiXmlComment* This)
{
	_TiXmlNode_destruct(TiXmlComment_super(This));
}

/* Rgm[h𕡐܂B
 * [out]
 *	߂l		Rgm[hB
 */
/*virtual*/ TiXmlNode*
_TiXmlComment_Clone(TiXmlComment* This)
{
	TiXmlComment* clone = TiXmlComment_new();

	/* e𕡐 */
	StdString_assign(clone->value, StdString_c_str(This->value));

	return TiXmlComment_super(clone);
}

/* Rgm[ho͂܂B
 * [in]
 *	fp		o͐Xg[B
 *	depth		Cfg̐[B
 */
/*virtual*/ void
_TiXmlComment_Print(TiXmlComment* This, FILE* fp, int depth)
{
	Indent(fp, depth);
	fprintf(fp, "<!--%s-->", StdString_c_str(This->value));
}

/* Rgm[hp[X܂B
 * [in]
 *	p		p[XJnʒuւ̃|C^B
 * [out]
 *	߂l		p[XIʒuւ̃|C^B
 * [note]
 *	- Rgm[h쐬ɌĂ΂邱ƂOłB
 *	  ɓeݒ肳ĂƁAʂƂȂ܂B
 */
/*virtual*/ const char*
_TiXmlComment_Parse(TiXmlComment* This, const char* p)
{
	const char* end;
	int c;

	/* u!--vwԂŌĂ΂Ȃ΂Ȃ܂B */
	if(p[0] != '!' ||
	   p[1] != '-' ||
	   p[2] != '-') {
		DIE();
	}

	/* |C^u!--v̒֐i߂܂B */
	p += 3;

	/* u-->vTA΃G[Ƃ܂B */
	end = strstr(p, "-->");
	if(!end) {
		DIE();
	}

	/* u!--v̒ォu-->v̒O܂ł̕Â܂܎擾܂B
	 * - IWiTinyXML1.2.4́AeLXgƓlɘA󔒂ꕶɂ܂Ƃ߂Ă܂A
	 *   IE6XML\Ă݂ƁARg̕͘A󔒂̂܂ܕ\Ă܂B
	 *   ܂ARgs̋󔒂Rg㑱̋󔒂A܂Ƃ߂̂܂ܕ\悤łB
	 *   ́AIE6̎dlɏ]Ƃɂ܂B(ǂ炪̂AvmF)
	 */
	while(p < end) {
		c = *p++;
		StdString_append(This->value, (char*)&c);
	}

	/* u-->v̒ւ̃|C^Ԃ܂B */
	return end + 3;
}

/****************************************************************************
 *	TiXmlText
 ****************************************************************************/

static const TiXmlText_vtbl _TiXmlText_vtbl = {
	_TiXmlText_destruct,	/*destruct*/
	_TiXmlText_Print,	/*Print*/
	/*TiXmlBase_vtbl*/
	_TiXmlText_Clone,	/*Clone*/
	_TiXmlText_Parse,	/*Parse*/
	/*TiXmlNode_vtbl*/
	/*TiXmlText_vtbl*/
};

/* eLXgm[h쐬܂B
 */
TiXmlText*
TiXmlText_new()
{
	TiXmlText* This = calloc(1, sizeof *This);
	if(!This) {
		DIE();
	}
	_TiXmlText_construct(This);
	return This;
}

/* eLXgm[h폜܂B
 */
void
TiXmlText_delete(TiXmlText* This)
{
	if(This) {
		This->vptr->destruct(This);
		free(This);
	}
}

/* eLXgm[h̃RXgN^łB
 */
void
_TiXmlText_construct(TiXmlText* This)
{
	_TiXmlNode_construct(TiXmlText_super(This));
	This->vptr = &_TiXmlText_vtbl;
}

/* eLXgm[h̃fXgN^łB
 */
/*virtual*/ void
_TiXmlText_destruct(TiXmlText* This)
{
	_TiXmlNode_destruct(TiXmlText_super(This));
}

/* eLXgm[h𕡐܂B
 * [out]
 *	߂l		eLXgm[hB
 */
/*virtual*/ TiXmlNode*
_TiXmlText_Clone(TiXmlText* This)
{
	TiXmlText* clone = TiXmlText_new();

	/* e𕡐 */
	StdString_assign(clone->value, StdString_c_str(This->value));

	return TiXmlText_super(clone);
}

/* eLXgm[ho͂܂B
 * [in]
 *	fp		o͐Xg[B
 *	depth		g܂B
 *			eLXg͊Jn^O̒ɕ\܂B
 */
/*virtual*/ void
_TiXmlText_Print(TiXmlText* This, FILE* fp, int depth)
{
	fprintf(fp, "%s", StdString_c_str(This->value));
}

/* eLXgm[hp[X܂B
 * [in]
 *	p		p[XJnʒuւ̃|C^B
 * [out]
 *	߂l		p[XIʒuւ̃|C^B
 * [note]
 *	- eLXgm[h쐬ɌĂ΂邱ƂOłB
 *	  ɓeݒ肳ĂƁAʂƂȂ܂B
 */
/*virtual*/ const char*
_TiXmlText_Parse(TiXmlText* This, const char* p)
{
	int whiteSpace;
	int c;

	/* eLXgs̋󔒂͊i[܂B */
	p = SkipWhiteSpace(p);

	whiteSpace = 0;
	for(;;) {
		/* ꕶ擾܂B */
		c = *p;

		/* I[܂́u<vɒBÄʒuւ̃|C^Ԃ܂B
		 * eLXg㑱̋󔒂͊i[܂B(whiteSpace=1łĂ)
		 * - IWiTinyXML1.2.4́AeLXg㑱̋󔒂ۑ悤łA
		 *   IE6XML\Ă݂ƁAeLXg㑱̋󔒂ێȂ悤Ȃ̂ŁA
		 *   IE6̎dlɏ]Ƃɂ܂B(ǂ炪̂AvmF)
		 */
		if(!c || c == '<') {
			return p;
		}

		/* ꕶǉ܂B
		 * AeLXgr̘A󔒂́AꕶɒuĊi[܂B
		 */
		if(isspace(c)) {
			whiteSpace = 1;
		} else {
			if(whiteSpace) {
				StdString_append(This->value, " ");
				whiteSpace = 0;
			}
			StdString_append(This->value, (char*)&c);
		}

		/* |C^֐i߂܂B */
		p++;
	}
}

/****************************************************************************
 *	TiXmlDeclaration
 ****************************************************************************/

static const TiXmlDeclaration_vtbl _TiXmlDeclaration_vtbl = {
	_TiXmlDeclaration_destruct,	/*destruct*/
	_TiXmlDeclaration_Print,	/*Print*/
	/*TiXmlBase_vtbl*/
	_TiXmlDeclaration_Clone,	/*Clone*/
	_TiXmlDeclaration_Parse,	/*Parse*/
	/*TiXmlNode_vtbl*/
	/*TiXmlDeclaration_vtbl*/
};

/* 錾m[h쐬܂B
 * [in]
 *	version		o[WB
 *			NULLw肷ƁA󕶎ƌȂ܂B
 *	encoding	GR[fBOB
 *			NULLw肷ƁA󕶎ƌȂ܂B
 *	standalone	X^hA[B
 *			NULLw肷ƁA󕶎ƌȂ܂B
 */
TiXmlDeclaration*
TiXmlDeclaration_new(const char* version/*=NULL*/, const char* encoding/*=NULL*/, const char* standalone/*=NULL*/)
{
	TiXmlDeclaration* This = calloc(1, sizeof *This);
	if(!This) {
		DIE();
	}
	_TiXmlDeclaration_construct(This, version, encoding, standalone);
	return This;
}

/* 錾m[h폜܂B
 */
void
TiXmlDeclaration_delete(TiXmlDeclaration* This)
{
	if(This) {
		This->vptr->destruct(This);
		free(This);
	}
}

/* 錾m[h̃RXgN^łB
 * [in]
 *	version		o[WB
 *			NULLw肷ƁA󕶎ƌȂ܂B
 *	encoding	GR[fBOB
 *			NULLw肷ƁA󕶎ƌȂ܂B
 *	standalone	X^hA[B
 *			NULLw肷ƁA󕶎ƌȂ܂B
 */
void
_TiXmlDeclaration_construct(TiXmlDeclaration* This, const char* version/*=NULL*/, const char* encoding/*=NULL*/, const char* standalone/*=NULL*/)
{
	_TiXmlNode_construct(TiXmlDeclaration_super(This));
	This->vptr = &_TiXmlDeclaration_vtbl;

	This->version = StdString_new(version);
	This->encoding = StdString_new(encoding);
	This->standalone = StdString_new(standalone);
}

/* 錾m[h̃fXgN^łB
 */
/*virtual*/ void
_TiXmlDeclaration_destruct(TiXmlDeclaration* This)
{
	StdString_delete(This->version);
	StdString_delete(This->encoding);
	StdString_delete(This->standalone);

	_TiXmlNode_destruct(TiXmlDeclaration_super(This));
}

/* o[W擾܂B
 * [out]
 *	߂l		o[WB
 */
const char*
TiXmlDeclaration_Version(TiXmlDeclaration* This)
{
	return StdString_c_str(This->version);
}

/* GR[fBO擾܂B
 * [out]
 *	߂l		GR[fBOB
 */
const char*
TiXmlDeclaration_Encoding(TiXmlDeclaration* This)
{
	return StdString_c_str(This->encoding);
}

/* X^hA[擾܂B
 * [out]
 *	߂l		X^hA[B
 */
const char*
TiXmlDeclaration_Standalone(TiXmlDeclaration* This)
{
	return StdString_c_str(This->standalone);
}

/* 錾m[h𕡐܂B
 * [out]
 *	߂l		錾m[hB
 */
/*virtual*/ TiXmlNode*
_TiXmlDeclaration_Clone(TiXmlDeclaration* This)
{
	TiXmlDeclaration* clone = TiXmlDeclaration_new(
		StdString_c_str(This->version),		/* o[W𕡐 */
		StdString_c_str(This->encoding),	/* GR[fBO𕡐 */
		StdString_c_str(This->standalone));	/* X^hA[𕡐 */

	/* 錾m[hvaluegĂȂAÔ߂ɕĂB */
	StdString_assign(clone->value, StdString_c_str(This->value));

	return TiXmlDeclaration_super(clone);
}

/* 錾m[ho͂܂B
 * [in]
 *	fp		o͐Xg[B
 *	depth		Cfg̐[B
 */
/*virtual*/ void
_TiXmlDeclaration_Print(TiXmlDeclaration* This, FILE* fp, int depth)
{
	Indent(fp, depth);
	fprintf(fp, "<?xml ");
	if(*StdString_c_str(This->version)) {
		fprintf(fp, "version=\"%s\" ", StdString_c_str(This->version));
	}
	if(*StdString_c_str(This->encoding)) {
		fprintf(fp, "encoding=\"%s\" ", StdString_c_str(This->encoding));
	}
	if(*StdString_c_str(This->standalone)) {
		fprintf(fp, "standalone=\"%s\" ", StdString_c_str(This->standalone));
	}
	fprintf(fp, "?>");
}

/* 錾m[hp[X܂B
 * [in]
 *	p		p[XJnʒuւ̃|C^B
 * [out]
 *	߂l		p[XIʒuւ̃|C^B
 * [note]
 *	- 錾m[h쐬ɌĂ΂邱ƂOłB
 *	  Ƀo[WAGR[fBOAX^hA[ݒ肳ĂƁAʂƂȂ܂B
 */
/*virtual*/ const char*
_TiXmlDeclaration_Parse(TiXmlDeclaration* This, const char* p)
{
	TiXmlAttribute* attribute;
	const char* end;
	const char* pos;

	/* u?xmlvwԂŌĂ΂Ȃ΂Ȃ܂B */
	if(p[0] != '?' ||
	   p[1] != 'x' ||
	   p[2] != 'm' ||
	   p[3] != 'l') {
		DIE();
	}

	/* |C^u?xmlv̒֐i߂܂B */
	p += 4;

	/* u?>vTA΃G[Ƃ܂B */
	end = strstr(p, "?>");
	if(!end) {
		DIE();
	}

	/* 錾^Ȍ́Au<?xml version=... [encoding=...] [standalone=...] ?>vłB
	 * version͕K{Aencoding,standalone͔CӂłAԂւĂ͂܂B
	 */
	pos = strstr(p, "version");
	if(pos && pos < end) {
		attribute = TiXmlAttribute_new(NULL, NULL);
		p = TiXmlAttribute_Parse(attribute, pos);
		StdString_assign(This->version, TiXmlAttribute_Value(attribute));
		TiXmlAttribute_delete(attribute);
	} else {
		DIE(); /* version͕K{ */
	}
	pos = strstr(p, "encoding");
	if(pos && pos < end) {
		attribute = TiXmlAttribute_new(NULL, NULL);
		p = TiXmlAttribute_Parse(attribute, pos);
		StdString_assign(This->encoding, TiXmlAttribute_Value(attribute));
		TiXmlAttribute_delete(attribute);
	}
	pos = strstr(p, "standalone");
	if(pos && pos < end) {
		attribute = TiXmlAttribute_new(NULL, NULL);
		p = TiXmlAttribute_Parse(attribute, pos);
		StdString_assign(This->standalone, TiXmlAttribute_Value(attribute));
		TiXmlAttribute_delete(attribute);
	}

	/* u?>v̒ւ̃|C^Ԃ܂B */
	return end + 2;
}

/****************************************************************************
 *	TiXmlUnknown
 ****************************************************************************/

static const TiXmlUnknown_vtbl _TiXmlUnknown_vtbl = {
	_TiXmlUnknown_destruct,	/*destruct*/
	_TiXmlUnknown_Print,	/*Print*/
	/*TiXmlBase_vtbl*/
	_TiXmlUnknown_Clone,	/*Clone*/
	_TiXmlUnknown_Parse,	/*Parse*/
	/*TiXmlNode_vtbl*/
	/*TiXmlUnknown_vtbl*/
};

/* sȃm[h쐬܂B
 */
TiXmlUnknown*
TiXmlUnknown_new()
{
	TiXmlUnknown* This = calloc(1, sizeof *This);
	if(!This) {
		DIE();
	}
	_TiXmlUnknown_construct(This);
	return This;
}

/* sȃm[h폜܂B
 */
void
TiXmlUnknown_delete(TiXmlUnknown* This)
{
	if(This) {
		This->vptr->destruct(This);
		free(This);
	}
}

/* sȃm[h̃RXgN^łB
 */
void
_TiXmlUnknown_construct(TiXmlUnknown* This)
{
	_TiXmlNode_construct(TiXmlUnknown_super(This));
	This->vptr = &_TiXmlUnknown_vtbl;
}

/* sȃm[h̃fXgN^łB
 */
/*virtual*/ void
_TiXmlUnknown_destruct(TiXmlUnknown* This)
{
	_TiXmlNode_destruct(TiXmlUnknown_super(This));
}

/* sȃm[h𕡐܂B
 * [out]
 *	߂l		sȃm[hB
 */
/*virtual*/ TiXmlNode*
_TiXmlUnknown_Clone(TiXmlUnknown* This)
{
	TiXmlUnknown* clone = TiXmlUnknown_new();

	StdString_assign(clone->value, StdString_c_str(This->value));

	return TiXmlUnknown_super(clone);
}

/* sȃm[ho͂܂B
 * [in]
 *	fp		o͐Xg[B
 *	depth		Cfg̐[B
 */
/*virtual*/ void
_TiXmlUnknown_Print(TiXmlUnknown* This, FILE* fp, int depth)
{
	Indent(fp, depth);
	fprintf(fp, "<%s>", StdString_c_str(This->value));
}

/* sȃm[hp[X܂B
 * [in]
 *	p		p[XJnʒuւ̃|C^B
 * [out]
 *	߂l		p[XIʒuւ̃|C^B
 * [note]
 *	- sȃm[h쐬ɌĂ΂邱ƂOłB
 *	  ɓeݒ肳ĂƁAʂƂȂ܂B
 */
/*virtual*/ const char*
_TiXmlUnknown_Parse(TiXmlUnknown* This, const char* p)
{
	int c;

	for(;;) {
		/* ꕶ擾A|C^֐i߂܂B */
		c = *p++;

		/* u>vOɏI[ɒBAG[Ƃ܂B */
		if(!c) {
			DIE();
		}

		/* u>vAu>v̒ւ̃|C^Ԃ܂B */
		if(c == '>') {
			return p;
		}

		/* ꕶǉ܂B */
		StdString_append(This->value, (char*)&c);
	}
}

/****************************************************************************
 *	TiXmlDocument
 ****************************************************************************/

static const TiXmlDocument_vtbl _TiXmlDocument_vtbl = {
	_TiXmlDocument_destruct,	/*destruct*/
	_TiXmlDocument_Print,		/*Print*/
	/*TiXmlBase_vtbl*/
	_TiXmlDocument_Clone,		/*Clone*/
	_TiXmlDocument_Parse,		/*Parse*/
	/*TiXmlNode_vtbl*/
	/*TiXmlDocument_vtbl*/
};

/* XMLhLg쐬܂B
 * [in]
 *	documentName	t@CB
 *			NULLw肷ƁA󕶎ƌȂ܂B
 */
TiXmlDocument*
TiXmlDocument_new(const char* documentName/*=NULL*/)
{
	TiXmlDocument* This = calloc(1, sizeof *This);
	if(!This) {
		DIE();
	}
	_TiXmlDocument_construct(This, documentName);
	return This;
}

/* XMLhLg폜܂B
 */
void
TiXmlDocument_delete(TiXmlDocument* This)
{
	if(This) {
		This->vptr->destruct(This);
		free(This);
	}
}

/* XMLhLg̃RXgN^łB
 * [in]
 *	documentName	t@CB
 *			NULLw肷ƁA󕶎ƌȂ܂B
 */
void
_TiXmlDocument_construct(TiXmlDocument* This, const char* documentName/*=NULL*/)
{
	_TiXmlNode_construct(TiXmlDocument_super(This));
	This->vptr = &_TiXmlDocument_vtbl;

	/* t@Cݒ肵܂B */
	StdString_assign(This->value, documentName);
}

/* XMLhLg̃fXgN^łB
 */
/*virtual*/ void
_TiXmlDocument_destruct(TiXmlDocument* This)
{
	_TiXmlNode_destruct(TiXmlDocument_super(This));
}

/* XMLt@Cǂݍ݂܂B
 * [in]
 *	filename	t@CB
 *			NULLw肷ƁAɐݒ肳Ăt@Cp܂B
 */
void
TiXmlDocument_LoadFile(TiXmlDocument* This, const char* filename/*=NULL*/)
{
	FILE* fp;
	int size;
	char* buf;

	if(!filename) {
		filename = StdString_c_str(This->value);
	}
	fp = fopen(filename, "rb");	/* P/ECEI/OƂ̌݊̂߂ɁAo͎CR<->CR+LFϊ͍sȂƂɂ܂B */
	if(!fp) {
		DIE();
	}

	fseek(fp, 0, SEEK_END);
	size = ftell(fp);		/* "rb"ŊJĂ邱ƂOłB"rt"ŊJĂƁATCY܂B */
	rewind(fp);

	buf = calloc(1, size + 1/*nul*/);
	if(!buf) {
		DIE();
	}
	fread(buf, 1, size, fp);	/* "rb"ŊJĂ邱ƂOłB"rt"ŊJĂƁATCY܂B */
	This->vptr->Parse(This, buf);
	free(buf);

	fclose(fp);
}

/* XMLt@Co͂܂B
 * [in]
 *	filename	t@CB
 *			NULLw肷ƁAɐݒ肳Ăt@Cp܂B
 */
void
TiXmlDocument_SaveFile(TiXmlDocument* This, const char* filename/*=NULL*/)
{
	FILE* fp;

	if(!filename) {
		filename = StdString_c_str(This->value);
	}
	fp = fopen(filename, "wb");	/* P/ECEI/OƂ̌݊̂߂ɁAo͎CR<->CR+LFϊ͍sȂƂɂ܂B */
	if(!fp) {
		DIE();
	}

	This->vptr->Print(This, fp, 0);

	fclose(fp);
}

/* XMLhLgo͂܂B
 * [in]
 *	fp		o͐Xg[B
 *	depth		Cfg̐[B
 */
/*virtual*/ void
_TiXmlDocument_Print(TiXmlDocument* This, FILE* fp, int depth)
{
	TiXmlNode* node;

	for(node = This->firstChild;
	    node;
	    node = TiXmlNode_NextSibling(node, NULL)) {
		node->vptr->Print(node, fp, 0);
		fprintf(fp, "\n");
	}
}

/* XMLhLg𕡐܂B
 * [out]
 *	߂l		XMLhLgB
 */
/*virtual*/ TiXmlNode*
_TiXmlDocument_Clone(TiXmlDocument* This)
{
	TiXmlDocument* clone = TiXmlDocument_new(StdString_c_str(This->value));	/* t@C𕡐 */
	TiXmlNode* node;

	/* qm[h𕡐 */
	for(node = This->firstChild;
	    node;
	    node = TiXmlNode_NextSibling(node, NULL)) {
		TiXmlNode_InsertEndChild(TiXmlDocument_super(clone), node->vptr->Clone(node));
	}

	return TiXmlDocument_super(clone);
}

/* XMLhLgp[X܂B
 * [in]
 *	p		p[XJnʒuւ̃|C^B
 * [out]
 *	߂l		p[XIʒuւ̃|C^B
 * [note]
 *	- XMLhLg쐬ɌĂ΂邱ƂOłB
 *	  Ɏqm[hǉĂƁAʂƂȂ܂B
 */
/*virtual*/ const char*
_TiXmlDocument_Parse(TiXmlDocument* This, const char* p)
{
	TiXmlNode* node;

	/* m[hɐs󔒂XLbv܂B */
	while(*(p = SkipWhiteSpace(p))) {
		if(*p != '<') {
			DIE();
		}

		/* m[hǂݍ݁Aǉ܂B */
		node = IdentifyAndParse(&p);
		TiXmlNode_InsertEndChild(TiXmlDocument_super(This), node);
	}

	/* m[h΁AG[Ƃ܂B */
	if(!This->firstChild) {
		DIE();
	}

	return p;
}

/****************************************************************************
 *	TiXmlAttribute
 ****************************************************************************/

static const TiXmlAttribute_vtbl _TiXmlAttribute_vtbl = {
	_TiXmlAttribute_destruct,	/*destruct*/
	_TiXmlAttribute_Print,		/*Print*/
	/*TiXmlBase_vtbl*/
	/*TiXmlAttribute_vtbl*/
};

/* 쐬܂B
 * [in]
 *	name		B
 *			NULLw肷ƁA󕶎ƌȂ܂B
 *	value		lB
 *			NULLw肷ƁA󕶎ƌȂ܂B
 */
TiXmlAttribute*
TiXmlAttribute_new(const char* name/*=NULL*/, const char* value/*=NULL*/)
{
	TiXmlAttribute* This = calloc(1, sizeof *This);
	if(!This) {
		DIE();
	}
	_TiXmlAttribute_construct(This, name, value);
	return This;
}

/* 폜܂B
 */
void
TiXmlAttribute_delete(TiXmlAttribute* This)
{
	if(This) {
		This->vptr->destruct(This);
		free(This);
	}
}

/* ̃RXgN^łB
 * [in]
 *	name		B
 *			NULLw肷ƁA󕶎ƌȂ܂B
 *	value		lB
 *			NULLw肷ƁA󕶎ƌȂ܂B
 */
void
_TiXmlAttribute_construct(TiXmlAttribute* This, const char* name/*=NULL*/, const char* value/*=NULL*/)
{
	_TiXmlBase_construct(TiXmlAttribute_super(This));
	This->vptr = &_TiXmlAttribute_vtbl;

	This->name = StdString_new(name);
	This->value = StdString_new(value);
}

/* ̃fXgN^łB
 */
/*virtual*/ void
_TiXmlAttribute_destruct(TiXmlAttribute* This)
{
	StdString_delete(This->name);
	StdString_delete(This->value);

	_TiXmlBase_destruct(TiXmlAttribute_super(This));
}

/* 擾܂B
 * [out]
 *	߂l		B
 */
const char*
TiXmlAttribute_Name(TiXmlAttribute* This)
{
	return StdString_c_str(This->name);
}

/* l擾܂B
 * [out]
 *	߂l		lB
 */
const char*
TiXmlAttribute_Value(TiXmlAttribute* This)
{
	return StdString_c_str(This->value);
}

/* ݒ肵܂B
 * [in]
 *	name		B
 */
void
TiXmlAttribute_SetName(TiXmlAttribute* This, const char* name)
{
	StdString_assign(This->name, name);
}

/* lݒ肵܂B
 * [in]
 *	value		lB
 */
void
TiXmlAttribute_SetValue(TiXmlAttribute* This, const char* value)
{
	StdString_assign(This->value, value);
}

/* ̑擾܂B
 * [out]
 *	߂l		̑B
 *			Zbg̖ꍇ́ANULLԂ܂B
 */
TiXmlAttribute*
TiXmlAttribute_Next(TiXmlAttribute* This)
{
	if(!*StdString_c_str(This->next->name) &&
	   !*StdString_c_str(This->next->value)) {
		return NULL;
	}
	return This->next;
}

/* Ȏ擾܂B
 * [out]
 *	߂l		̑B
 *			Zbg̐擪ꍇ́ANULLԂ܂B
 */
TiXmlAttribute*
TiXmlAttribute_Previous(TiXmlAttribute* This)
{
	if(!*StdString_c_str(This->prev->name) &&
	   !*StdString_c_str(This->prev->value)) {
		return NULL;
	}
	return This->prev;
}

/* o͂܂B
 * [in]
 *	fp		o͐Xg[B
 *	depth		g܂B
 *			͗vf̊Jn^O̒ɕ\܂B
 */
/*virtual*/ void
_TiXmlAttribute_Print(TiXmlAttribute* This, FILE* fp, int depth)
{
	int c = strchr(StdString_c_str(This->value), '"') ? '\'' : '"';

	fprintf(fp, "%s=%c%s%c", StdString_c_str(This->name), c, StdString_c_str(This->value), c);
}

/* p[X܂B
 * [in]
 *	p		p[XJnʒuւ̃|C^B
 * [out]
 *	߂l		p[XIʒuւ̃|C^B
 * [note]
 *	- 쐬ɌĂ΂邱ƂOłB
 *	  ɑAlݒ肳ĂƁAʂƂȂ܂B
 */
const char*
TiXmlAttribute_Parse(TiXmlAttribute* This, const char* p)
{
	int quot;
	int c;

	/* 擾܂B */
	p = ReadName(p, This->name);

	/* Ɓu=v̊Ԃ̋󔒂XLbv܂B */
	p = SkipWhiteSpace(p);

	/* u=v݂邱ƂmFA|C^֐i߂܂B */
	if(*p++ != '=') {
		DIE();
	}

	/* u=vƑl̊Ԃ̋󔒂XLbv܂B */
	p = SkipWhiteSpace(p);

	/* p擾A|C^֐i߂܂B */
	quot = *p++;

	/* pAu'v܂́u"vł邱ƂmF܂B */
	if(quot != '\'' && quot != '"') {
		DIE();
	}

	for(;;) {
		/* ꕶ擾A|C^֐i߂܂B */
		c = *p++;

		/* pOɏI[ɒBAG[Ƃ܂B */
		if(!c) {
			DIE();
		}

		/* pAp̒ւ̃|C^Ԃ܂B */
		if(c == quot) {
			return p;
		}

		/* ꕶǉ܂B */
		StdString_append(This->value, (char*)&c);
	}
}

/****************************************************************************
 *	TiXmlAttributeSet
 ****************************************************************************/

/* Zbg쐬܂B
 */
TiXmlAttributeSet*
TiXmlAttributeSet_new()
{
	TiXmlAttributeSet* This = calloc(1, sizeof *This);
	if(!This) {
		DIE();
	}
	_TiXmlAttributeSet_construct(This);
	return This;
}

/* Zbg폜܂B
 */
void
TiXmlAttributeSet_delete(TiXmlAttributeSet* This)
{
	if(This) {
		/** no virtual destructor **/
		_TiXmlAttributeSet_destruct(This);
		free(This);
	}
}

/* Zbg̃RXgN^łB
 */
void
_TiXmlAttributeSet_construct(TiXmlAttributeSet* This)
{
	/** no base class **/
	/** no vptr **/

	This->sentinel = TiXmlAttribute_new(NULL, NULL);
	This->sentinel->next = This->sentinel;
	This->sentinel->prev = This->sentinel;
}

/* Zbg̃fXgN^łB
 * [note]
 *	- NĂ鑮AIɑSč폜܂B
 */
void
_TiXmlAttributeSet_destruct(TiXmlAttributeSet* This)
{
	TiXmlAttribute* attribute = This->sentinel->next;

	while(attribute != This->sentinel) {
		TiXmlAttribute* next = attribute->next;
		TiXmlAttribute_delete(attribute);
		attribute = next;
	}

	TiXmlAttribute_delete(This->sentinel);

	/** no base class **/
}

/* w肳ꂽNɒǉ܂B
 * [in]
 *	addThis		Nɒǉ鑮B
 * [note]
 *	- ɓ̑Nɑ݂ꍇ́Aǉł܂B
 */
void
TiXmlAttributeSet_Add(TiXmlAttributeSet* This, TiXmlAttribute* addThis)
{
	if(TiXmlAttributeSet_Find(This, TiXmlAttribute_Name(addThis))) {
		DIE();
	}

	addThis->next = This->sentinel;
	addThis->prev = This->sentinel->prev;

	This->sentinel->prev->next = addThis;
	This->sentinel->prev = addThis;
}

/* w肳ꂽNO܂B
 * [in]
 *	removeThis	NOB
 * [note]
 *	- OsvȂ΁ATiXmlAttribute_delete()Ăяoč폜ĂB
 *	  ̊֐́AOIɍ폜܂B
 */
void
TiXmlAttributeSet_Remove(TiXmlAttributeSet* This, TiXmlAttribute* removeThis)
{
	TiXmlAttribute* attribute;

	for(attribute = This->sentinel->next;
	    attribute != This->sentinel;
	    attribute = attribute->next) {
		if(attribute == removeThis) {
			removeThis->prev->next = removeThis->next;
			removeThis->next->prev = removeThis->prev;
			removeThis->next = NULL;
			removeThis->prev = NULL;
			return;
		}
	}

	DIE();
}

/* 擪̑擾܂B
 * [out]
 *	߂l		̃|C^B
 *			ꍇ́ANULLԂ܂B
 */
TiXmlAttribute*
TiXmlAttributeSet_First(TiXmlAttributeSet* This)
{
	if(This->sentinel->next == This->sentinel) {
		return NULL;
	}
	return This->sentinel->next;
}

/* ̑擾܂B
 * [out]
 *	߂l		̃|C^B
 *			ꍇ́ANULLԂ܂B
 */
TiXmlAttribute*
TiXmlAttributeSet_Last(TiXmlAttributeSet* This)
{
	if(This->sentinel->prev == This->sentinel) {
		return NULL;
	}
	return This->sentinel->prev;
}

/* ܂B
 * [in]
 *	name		B
 * [note]
 *	- w肳ꂽɈv鑮ꍇ́ANULLԂ܂B
 */
TiXmlAttribute*
TiXmlAttributeSet_Find(TiXmlAttributeSet* This, const char* name)
{
	TiXmlAttribute* attribute;

	for(attribute = This->sentinel->next;
	    attribute != This->sentinel;
	    attribute = attribute->next) {
		if(!strcmp(TiXmlAttribute_Name(attribute), name)) {
			return attribute;
		}
	}

	return NULL;
}

/****************************************************************************
 *	
 ****************************************************************************/

/* u_TiXml?????_vtblv̑OQƂ邽߂ɁAŌɒ`܂B */
TiXmlDocument   * TiXmlNode_ToDocument   (TiXmlNode* This) { return This->vptr == (TiXmlNode_vtbl*)&_TiXmlDocument_vtbl    ? (TiXmlDocument   *)This : NULL; }
TiXmlElement    * TiXmlNode_ToElement    (TiXmlNode* This) { return This->vptr == (TiXmlNode_vtbl*)&_TiXmlElement_vtbl     ? (TiXmlElement    *)This : NULL; }
TiXmlComment    * TiXmlNode_ToComment    (TiXmlNode* This) { return This->vptr == (TiXmlNode_vtbl*)&_TiXmlComment_vtbl     ? (TiXmlComment    *)This : NULL; }
TiXmlUnknown    * TiXmlNode_ToUnknown    (TiXmlNode* This) { return This->vptr == (TiXmlNode_vtbl*)&_TiXmlUnknown_vtbl     ? (TiXmlUnknown    *)This : NULL; }
TiXmlText       * TiXmlNode_ToText       (TiXmlNode* This) { return This->vptr == (TiXmlNode_vtbl*)&_TiXmlText_vtbl        ? (TiXmlText       *)This : NULL; }
TiXmlDeclaration* TiXmlNode_ToDeclaration(TiXmlNode* This) { return This->vptr == (TiXmlNode_vtbl*)&_TiXmlDeclaration_vtbl ? (TiXmlDeclaration*)This : NULL; }

