;	
;	framuvia.s
;
;	P/ECE Signetics 2637 UVI(Universal Video Interface) Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sat Apr 30 13:14:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
#define UVI_DEFINE_OFFSET
#include "clipuvia.h"
#ifdef UVI_ASM

	.code
	.align	1

;****************************************************************************
;	֐ (Video)
;****************************************************************************

;
;	void uvi_reduce(unsigned char dst[/*88*128*/], const unsigned char src[/*128*208*/])
;
	.global	uvi_reduce
uvi_reduce:
	xld.w	%r4, 8				; %r4 = z = 8
uvi_reduce_DO_Z:				; do {
	xld.w	%r5, 16				;   %r5 = y = 16
	xld.w	%r6, 1				;   %r6 = i = 1
uvi_reduce_DO_Y:				;   do {
	xsub	%r6, %r6, 1			;     if(!--i) {
	xjrne.d	uvi_reduce_DO_X1
	ld.w	%r7, 8				;     %r7 = x = 8 *delay*
	;---------------------------------------;
uvi_reduce_DO_X0:				;       do {
	;
	ld.w	%r10, [%r13]+			;         s      = *src++;				// s = [3][2][1][0]
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ; s >>= 8;	// s =    [3][2][1], out =  [0]
	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =       [3][2], t   =  [1]
	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =          [3], t   =  [1]+[2]
	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 2;		//                   out = ([1]+[2])/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ;		//                   out =  [3]
	;
	ld.w	%r10, [%r13]+			;         s      = *src++;				// s = [7][6][5][4]
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =    [7][6][5], t   =  [4]
	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =       [7][6], t   =  [4]+[5]
	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 2;		//                   out = ([4]+[5])/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ; s >>= 8;	// s =          [7], out =  [6]
	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ;		//                   t   =  [7]
	;
	ld.w	%r10, [%r13]+			;         s      = *src++;				// s = [B][A][9][8]
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =    [B][A][9], t   =  [7]+[8]
	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 2;		//                   out = ([7]+[8])/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ; s >>= 8;	// s =       [B][A], out =  [9]
	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =          [B], t   =  [A]
	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ;		//                   t   =  [A]+[B]
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 2;		//                   out = ([A]+[B])/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	;
	ld.w	%r10, [%r13]+			;         s      = *src++;				// s = [F][E][D][C]
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ; s >>= 8;	// s =    [F][E][D], out =  [C]
	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =       [F][E], t   =  [D]
	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =          [F], t   =  [D]+[E]
	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 2;		//                   out = ([D]+[E])/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ;		//                   out =  [F]
	;
	xsub	%r7, %r7, 1			;       } while(--x)
	xjrne	uvi_reduce_DO_X0
	xjp.d	uvi_reduce_LOOP_Y
	ld.w	%r6, 3				;       i = 3 *delay*
	;---------------------------------------;     } else {
uvi_reduce_DO_X1:				;       do {
	;
	xld.w	%r10, [%r13+128]		;         s      = src[128];
	ld.w	%r9, [%r13]+			;         s     += *src++;				// s = [3][2][1][0]
	add	%r10, %r9		
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2; s >>= 8;	// s =    [3][2][1], out = ([0]    )/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =       [3][2], t   =  [1]
	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =          [3], t   =  [1]+[2]
	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 4;		//                   out = ([1]+[2])/4
	xsrl	%r9, 2
	ld.b	[%r12]+, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2;		//                   out = ([3]    )/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	;
	xld.w	%r10, [%r13+128]		;         s      = src[128];
	ld.w	%r9, [%r13]+			;         s     += *src++;				// s = [7][6][5][4]
	add	%r10, %r9
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =    [7][6][5], t   =  [4]
	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =       [7][6], t   =  [4]+[5]
	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 4;		//                   out = ([4]+[5])/4
	xsrl	%r9, 2
	ld.b	[%r12]+, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2; s >>= 8;	// s =          [7], out = ([6]    )/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	ld.w	%r11, %r10			;         t      =                s    ;		//                   t   =  [7]
	;
	xld.w	%r10, [%r13+128]		;         s      = src[128];
	ld.w	%r9, [%r13]+			;         s     += *src++;				// s = [B][A][9][8]
	add	%r10, %r9
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =    [B][A][9], t   =  [7]+[8]
	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 4;		//                   out = ([7]+[8])/4
	xsrl	%r9, 2
	ld.b	[%r12]+, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2; s >>= 8;	// s =       [B][A], out = ([9]    )/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =          [B], t   =  [A]
	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ;		//                   t   =  [A]+[B]
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 4;		//                   out = ([A]+[B])/4
	xsrl	%r9, 2
	ld.b	[%r12]+, %r9
	;
	xld.w	%r10, [%r13+128]		;         s      = src[128];
	ld.w	%r9, [%r13]+			;         s     += *src++;				// s = [F][E][D][C]
	add	%r10, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2; s >>= 8;	// s =    [F][E][D], out = ([C]    )/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =       [F][E], t   =  [D]
	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =          [F], t   =  [D]+[E]
	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 4;		//                   out = ([D]+[E])/4
	xsrl	%r9, 2
	ld.b	[%r12]+, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2;		//                   out = ([F]    )/2
	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	;
	xsub	%r7, %r7, 1			;       } while(--x)
	xjrne	uvi_reduce_DO_X1
	xadd	%r13, %r13, 128			;       src += 128
	;---------------------------------------;     }
uvi_reduce_LOOP_Y:
	xsub	%r5, %r5, 1			;   } while(--y)
	xjrne	uvi_reduce_DO_Y
	xsub	%r4, %r4, 1			; } while(--z)
	xjrne	uvi_reduce_DO_Z
	ret

;****************************************************************************

;
;	void uvi_draw_chr_8x8(int x, int y, int code, int color)
;
	.global	uvi_draw_chr_8x8
uvi_draw_chr_8x8:
	xld.h	%r4, [uvi+SCAN_START]		; %r4 = uvi.scan_start
	xld.h	%r5, [uvi+SCAN_END]		; %r5 = uvi.scan_end
	;
	sub	%r4, 8				; if(y <= y_min-8) goto EXIT
	cmp	%r13, %r4
	xjrle.d	uvi_draw_chr_8x8_EXIT
	add	%r4, 8				; *delay*
	cmp	%r13, %r5			; if(y >= y_max) goto EXIT
	xjrge	uvi_draw_chr_8x8_EXIT
	xcmp	%r12, 0-8			; if(x <= 0-8) goto EXIT
	xjrle	uvi_draw_chr_8x8_EXIT
	xcmp	%r12, 128			; if(x >= 128) goto EXIT
	xjrge	uvi_draw_chr_8x8_EXIT
	;
	xld.w	%r6, [uvi+VBUFF]		; %r6 = vbuff = &uvi.vbuff[y*128+x]
	xsla	%r13, 7
	add	%r6, %r13
	xsra	%r13, 7
	add	%r6, %r12
	;
	xsll	%r14, 3				; %r14 = font = &uvi_font[code*8]
	ext	uvi_font@ah
	ext	uvi_font@al
	add	%r14, %r14
	;
	xsll	%r15, 1				; %r15[ 7:0] = cs = uvi.color[color][0]
	ext	uvi+COLOR@ah			; %r15[15:8] = cc = uvi.color[color][1]
	ext	uvi+COLOR@al
	ld.uh	%r15, [%r15]
	;
	cmp	%r13, %r4			; if(y < y_min) goto CLIP
	xjrlt	uvi_draw_chr_8x8_CLIP
	sub	%r5, 8				; if(y > y_max-8) goto CLIP
	cmp	%r13, %r5
	xjrgt.d	uvi_draw_chr_8x8_CLIP
	add	%r5, 8				; *delay*
	xcmp	%r12, 128-8			; if((x < 0) || (x > 128-8)) goto CLIP
	xjrugt	uvi_draw_chr_8x8_CLIP
	;--------------------------------------------------------------------
uvi_draw_chr_8x8_FAST:
	xld.w	%r10, 8				; %r10 = iy = 8
uvi_draw_chr_8x8_FAST_DO_Y:			; do {
	ld.ub	%r7, [%r14]+			;   %r7 = v = *font++
	xrr	%r7, 8				;   %r7[31:24] = v
	xld.w	%r11, 8				;   %r11 = ix = 8
uvi_draw_chr_8x8_FAST_DO_X:			;   do {
	;
	add	%r7, %r7			;     %r9[7:0] = c = v[31]?cc:cs, v <<= 1
	jruge.d	3				;     (NonCarry)
	ld.w	%r9, %r15			;     *delay*
	srl	%r9, 8				;     (skip?)
	ld.b	[%r6]+, %r9			;     *vbuff++ = c
	;
	xsub	%r11, %r11, 1			;   } while(--ix)
	xjrne	uvi_draw_chr_8x8_FAST_DO_X
	xadd	%r6, %r6, 128-8			;   vbuff += 128-8
	xsub	%r10, %r10, 1			; } while(--iy)
	xjrne	uvi_draw_chr_8x8_FAST_DO_Y
	xjp	uvi_draw_chr_8x8_EXIT
	;--------------------------------------------------------------------
uvi_draw_chr_8x8_CLIP:
	xld.w	%r10, 8				; %r10 = iy = 8
uvi_draw_chr_8x8_CLIP_DO_Y:			; do {
	cmp	%r13, %r4			;   if(y < y_min) goto SKIP_Y
	xjrlt	uvi_draw_chr_8x8_CLIP_SKIP_Y
	cmp	%r13, %r5			;   if(y >= y_max) goto SKIP_Y
	xjrge	uvi_draw_chr_8x8_CLIP_SKIP_Y
	ld.ub	%r7, [%r14]			;   %r7 = v = *font
	xrr	%r7, 8				;   %r7[31:24] = v
	xld.w	%r11, 8				;   %r11 = ix = 8
uvi_draw_chr_8x8_CLIP_DO_X:			;   do {
	;
	xcmp	%r12, 128			;     if(x < 0 || x >= 128) goto SKIP_X
	xjruge.d uvi_draw_chr_8x8_CLIP_SKIP_X
	add	%r7, %r7			;     %r9[7:0] = c = v[31]?cc:cs, v <<= 1 *delay*
	jruge.d	3				;     (NonCarry)
	ld.w	%r9, %r15			;     *delay*
	srl	%r9, 8				;     (skip?)
	ld.b	[%r6], %r9			;     *vbuff = c
	;
uvi_draw_chr_8x8_CLIP_SKIP_X:
	xadd	%r6, %r6, 1			;     vbuff++
	xsub	%r11, %r11, 1			;   } while(--ix)
	xjrne.d	uvi_draw_chr_8x8_CLIP_DO_X
	add	%r12, 1				;     x++ *delay*
	xsub	%r6, %r6, 8			;   vbuff -= 8
	xsub	%r12, %r12, 8			;   x -= 8
uvi_draw_chr_8x8_CLIP_SKIP_Y:
	xadd	%r6, %r6, 128			;   vbuff += 128
	xadd	%r14, %r14, 1			;   font++
	xsub	%r10, %r10, 1			; } while(--iy)
	xjrne.d	uvi_draw_chr_8x8_CLIP_DO_Y
	add	%r13, 1				;   y++ *delay*
	;--------------------------------------------------------------------
uvi_draw_chr_8x8_EXIT:
	ret

;****************************************************************************

;
;	void uvi_draw_obj_8x8(UVIOBJ* obj)
;
	.global	uvi_draw_obj_8x8
uvi_draw_obj_8x8:
	ld.w	%r15, %r12			; %r15 = obj
	xld.h	%r12, [%r15+OBJ_X]		; %r12 = obj->xx
	xld.h	%r13, [%r15+OBJ_Y]		; %r13 = obj->yy
	xld.h	%r4, [uvi+SCAN_START]		; %r4  = uvi.scan_start
	xld.h	%r5, [uvi+SCAN_END]		; %r5  = uvi.scan_end
	;
	sub	%r4, 8				; if(y <= y_min-8) goto EXIT
	cmp	%r13, %r4
	xjrle.d	uvi_draw_obj_8x8_EXIT
	add	%r4, 8				; *delay*
	cmp	%r13, %r5			; if(y >= y_max) goto EXIT
	xjrge	uvi_draw_obj_8x8_EXIT
	xcmp	%r12, 0-8			; if(x <= 0-8) goto EXIT
	xjrle	uvi_draw_obj_8x8_EXIT
	xcmp	%r12, 128			; if(x >= 128) goto EXIT
	xjrge	uvi_draw_obj_8x8_EXIT
	;
	xld.w	%r6, [uvi+VBUFF]		; %r6 = vbuff = &uvi.vbuff[y*128+x]
	xsla	%r13, 7
	add	%r6, %r13
	xsra	%r13, 7
	add	%r6, %r12
	;
	xld.w	%r14, [%r15+OBJ_FONT]		; %r14 = font = obj->font
	;
	xld.ub	%r15, [%r15+OBJ_COLOR]		; %r15 = cc = obj->color
	;
	cmp	%r13, %r4			; if(y < y_min) goto CLIP
	xjrlt	uvi_draw_obj_8x8_CLIP
	sub	%r5, 8				; if(y > y_max-8) goto CLIP
	cmp	%r13, %r5
	xjrgt.d	uvi_draw_obj_8x8_CLIP
	add	%r5, 8				; *delay*
	xcmp	%r12, 128-8			; if((x < 0) || (x > 128-8)) goto CLIP
	xjrugt	uvi_draw_obj_8x8_CLIP
	;--------------------------------------------------------------------
uvi_draw_obj_8x8_FAST:
	xld.w	%r10, 8				; %r10 = iy = 8
uvi_draw_obj_8x8_FAST_DO_Y:			; do {
	ld.ub	%r7, [%r14]+			;   %r7 = v = *font++
	xrr	%r7, 8				;   %r7[31:24] = v
	xld.w	%r11, 8				;   %r11 = ix = 8
uvi_draw_obj_8x8_FAST_DO_X:			;   do {
	;
	add	%r7, %r7			;     if(v[31]) { *vbuff = cc }, v <<= 1
	xjruge	uvi_draw_obj_8x8_FAST_SKIP_X	;     (NonCarry)
	ld.b	[%r6], %r15
	;
uvi_draw_obj_8x8_FAST_SKIP_X:
	xsub	%r11, %r11, 1			;   } while(--ix)
	xjrne.d	uvi_draw_obj_8x8_FAST_DO_X
	add	%r6, 1				;     vbuff++ *delay*
	xadd	%r6, %r6, 128-8			;   vbuff += 128-8
	xsub	%r10, %r10, 1			; } while(--iy)
	xjrne	uvi_draw_obj_8x8_FAST_DO_Y
	xjp	uvi_draw_obj_8x8_EXIT
	;--------------------------------------------------------------------
uvi_draw_obj_8x8_CLIP:
	xld.w	%r10, 8				; %r10 = iy = 8
uvi_draw_obj_8x8_CLIP_DO_Y:			; do {
	cmp	%r13, %r4			;   if(y < y_min) goto SKIP_Y
	xjrlt	uvi_draw_obj_8x8_CLIP_SKIP_Y
	cmp	%r13, %r5			;   if(y >= y_max) goto SKIP_Y
	xjrge	uvi_draw_obj_8x8_CLIP_SKIP_Y
	ld.ub	%r7, [%r14]			;   %r7 = v = *font
	xrr	%r7, 8				;   %r7[31:24] = v
	xld.w	%r11, 8				;   %r11 = ix = 8
uvi_draw_obj_8x8_CLIP_DO_X:			;   do {
	;
	xcmp	%r12, 128			;     if(x < 0 || x >= 128) goto SKIP_X
	xjruge.d uvi_draw_obj_8x8_CLIP_SKIP_X
	add	%r7, %r7			;     if(v[31]) { *vbuff = cc }, v <<= 1 *delay*
	xjruge	uvi_draw_obj_8x8_CLIP_SKIP_X	;     (NonCarry)
	ld.b	[%r6], %r15
	;
uvi_draw_obj_8x8_CLIP_SKIP_X:
	xadd	%r6, %r6, 1			;     vbuff++
	xsub	%r11, %r11, 1			;   } while(--ix)
	xjrne.d	uvi_draw_obj_8x8_CLIP_DO_X
	add	%r12, 1				;     x++ *delay*
	xsub	%r6, %r6, 8			;   vbuff -= 8
	xsub	%r12, %r12, 8			;   x -= 8
uvi_draw_obj_8x8_CLIP_SKIP_Y:
	xadd	%r6, %r6, 128			;   vbuff += 128
	xadd	%r14, %r14, 1			;   font++
	xsub	%r10, %r10, 1			; } while(--iy)
	xjrne.d	uvi_draw_obj_8x8_CLIP_DO_Y
	add	%r13, 1				;   y++ *delay*
	;--------------------------------------------------------------------
uvi_draw_obj_8x8_EXIT:
	ret

;****************************************************************************
;	
;****************************************************************************

#endif /*UVI_ASM*/
