/*	
 *	cliptask.c
 *
 *	^XNXPW[ (ReLXgXCb`)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2006 Naoyuki Sawa
 *
 *	* Fri Jun 09 22:27:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	  cliptask.ćAkeeptH_ɕۑ܂B
 *	* Wed Jun 14 00:44:00 JST 2006 Naoyuki Sawa
 *	- task_kill()ǉ܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

#if 0

^XNԂɂ

Es\sł^XNAws^XNx(running_task)ƌĂԂƂɂ܂B

Es\ł^XNAws\^XNx(ready_task)ƌĂԂƂɂ܂B
@ws^XNxAws\^XNẍƌȂƂɂ܂B

Eۂ҂Ē~Ă^XNAw^XNx(blocked_task)ƌĂԂƂɂ܂B

EI\[Xł^XNAwI^XNx(stopped_task)ƌĂԂƂɂ܂B
@(UnixvZX́Aw]rvZXx̏Ԃɑ܂B)
@^XN̏I҂ă\[Xɂ́Atask_wait()g܂B
@^XN̏I҂Ƀ\[Xɂ́Atask_kill()g܂B

CxgԂɂ

ECxgZbgĂԂAwVOiԁx(signaled)ƌĂԂƂɂ܂B

ECxgZbgĂԂAwVOiԁx(not_signaled)ƌĂԂƂɂ܂B

Cxg҂ɂ

EwVOiԁxłACxgA݂܂B
@CxgAwVOiԁxɂȂ̂҂Ē~ĂA^XNB݂܂B(w^XNx)
@̂ƂACxgAAw҂CxgxƌĂԂƂɂ܂B

^XNI҂ɂ

EIĂȂA^XNA݂܂B(ws^XNxws\^XNxw^XNx)
@^XNAÎ҂Ē~ĂA^XNB݂܂B(w^XNx)
@̂ƂA^XNAAw҂^XNxƌĂԂƂɂ܂B

^XNIɂ

EIĂȂA܂́AwI^XNxłA^XNA݂܂B
@^XNBtask_kill()ĂяoāAɃ^XNÃ\[X邱Ƃł܂B
@̂ƂA^XNAAwI^XNxƌĂԂƂɂ܂B

EIĂȂA^XNA݂܂B(ws^XNxws\^XNxw^XNx)
@^XNAÎ҂Ē~ĂA^XNB݂܂B(w^XNx)
@̂ƂA^XNAAw҂^XNxƌĂԂƂɂ܂B

^XNԂƁAo^ɂ

Ews\^XNx́Aws\^XNXgx(ready_task_list)ɓo^Ă܂B

Ews^XNx́Aws^XNx(running_task)ɓo^Ă܂B
@ws^XNx́ws\^XNxł̂ŁAws\^XNXgx(ready_task_list)ɂo^Ă܂B

ECxg҂łw^XNx́A҂Cxǵw^XNXgx(blocked_task_list)ɓo^Ă܂B
@Cxǵw^XNXgxɂ́A󂩁A܂́ÃCxg҂Ă镡̃^XNo^Ă܂B

E^XNI҂łw^XNx́A҂^XŃw^XNXgx(blocked_task_list)ɓo^Ă܂B
@^XŃw^XNXgx́A󂩁A܂́Ã^XN̏I҂ĂB̃^XNo^Ă܂B

EwI^XNx́Aǂ̃^XNXgɂo^Ă܂B
@wI^XNxł邱Ƃ߂ɁAIɁuTASK.task_list_entry.Flink=NULL(=Blink=NULL)vƂĂ܂B
@wI^XNx́Ã^XNɂă|C^ێĂ͂łB(Ȃ΁A\[X[NƂȂ܂B)
@̃^XNAtask_wait()A܂́Atask_kill()ĂяoƂɂāAwI^XNx̃\[X܂B

#endif

/****************************************************************************
 *	
 ****************************************************************************/

#define DEFAULT_STACK_SIZE	0x1000	/* ̃X^bNTCY () */

static LIST_ENTRY ready_task_list;	/* s\^XNXg */
static TASK* running_task;		/* s^XN */

static void task_select() __attribute__((unused));
/*static*/ void task_stub() __attribute__((noreturn));	/* x}̂staticȗ */
/*static*/ void task_schedule();			/* x}̂staticȗ */
static void event_set_pulse(EVENT* event, int pulse);

/****************************************************************************
 *	^XN
 ****************************************************************************/

void
task_init()
{
	TASK* task;

	/* s\^XNXg܂B */
	InitializeListHead(&ready_task_list);

	/* ̊֐ĂяoReLXgAVXeACh^XNƂēo^܂B
	 * - running_task->sṕA^XNXCb`Ɋi[̂ŁAsvłB
	 */
	task = calloc(sizeof(TASK), 1);
	if(!task) {
		DIE();
	}
	task->priority = INT_MIN; /* AChDx */
	InsertTailList(&ready_task_list, &task->task_list_entry);

	/* ̊֐ĂяoReLXgÁws^XNxƂȂ܂B */
	running_task = task;
}

TASK*
task_get_current()
{
	/* s^XNԂ܂B
	 * - s^XNNULLɂȂ邱Ƃ́AL蓾܂B
	 *   ŃAT[gꍇ́A炭task_init()̌ĂіYłB
	 */
	if(!running_task) {
		DIE();
	}
	return running_task;
}

TASK*
task_create(int priority, int (*task_proc)(void* param), void* param, int stack_size)
{
	TASK* task;

	/* X^bNTCY肵܂B */
	if(!stack_size) {
		stack_size = DEFAULT_STACK_SIZE;
	}
	stack_size = (stack_size + 3) & ~3; /* X^bNWordP */

	/* ^XN\̂ƃX^bÑmۂ܂B
	 *
	 *	+--------------+ task
	 *	|              |
	 *	| sizeof(TASK) |
	 *	|              |
	 *	+--------------+
	 *	|              |
	 *	|  stack_size  |
	 *	|              |
	 *	+--------------+ task->sp
	 */
	task = calloc(sizeof(TASK) + stack_size, 1);
	if(!task) {
		DIE();
	}
	task->sp = (int*)((int)task + sizeof(TASK) + stack_size);

	/* 쐬^XŃAX^bN܂B */
	/*{{task_stub*/
	*--task->sp = (int)param;	/* popn %r1 -> %r1 */
	*--task->sp = (int)task_proc;	/*          -> %r0 */
	/*}}task_stub*/
	/*{{task_schedule*/
	*--task->sp = (int)task_stub;	/* ret      -> %pc */
	*--task->sp = 0;		/* popn %r3 -> %r3 */
	*--task->sp = 0;		/*          -> %r2 */
	*--task->sp = 0;		/*          -> %r1 */
	*--task->sp = 0;		/*          -> %r0 */
	/*}}task_schedule*/

	/* 쐬^XNɁAsDxi[܂B */
	task->priority = priority;

	/* 쐬^XŃA^XNXg܂B */
	InitializeListHead(&task->blocked_task_list);

	/* 쐬^XNAs\^XNXgɓo^܂B */
	InsertTailList(&ready_task_list, &task->task_list_entry);

	/* ^XNXPW[Os܂B */
	task_schedule();

	return task;
}

void
task_exit(int exit_code) /*__attribute__((noreturn))*/
{
	TASK* current_task = task_get_current();

	/* I^XNɁAIR[hi[܂B */
	current_task->exit_code = exit_code;

	/* I^XNAs\^XNXgo^܂B */
	RemoveEntryList(&current_task->task_list_entry);
	current_task->task_list_entry.Flink = NULL; /* wI^XNxł邱Ƃ܂ */
	current_task->task_list_entry.Blink = NULL; /* ꉞANA(K{ł͂Ȃ) */

	/* I^XNɁA^XNo^ς݂Ȃ... */
	if(!IsListEmpty(&current_task->blocked_task_list)) {
		/* ^XNo^As\^XNXgɓo^܂B(N) */
		InsertTailList(&ready_task_list, RemoveHeadList(&current_task->blocked_task_list));
	}

	/* ^XNXPW[Os܂B */
	task_schedule();

	/* I^XNAs\^XNXgɍēo^邱Ƃ͗L܂B
	 * Ȃ킿Ã^XNXPW[OԂƂ́AL蓾܂B
	 */
	DIE();
}

int
task_wait(TASK* task)
{
	TASK* current_task = task_get_current();
	//
	int exit_code;

	/* g̏I҂Ƃ͂ł܂B */
	if(task == current_task) {
		DIE();
	}

	/* ̃^XN̏IÃ^XN҂Ƃ͂ł܂B */
	if(!IsListEmpty(&task->blocked_task_list)) {
		DIE();
	}

	/* w҂^XNxA܂IĂȂ... */
	if(task->task_list_entry.Flink) {
		/* ݂̃^XNAs\^XNXgo^܂B */
		RemoveEntryList(&current_task->task_list_entry);

		/* ݂̃^XNAw҂^XNx̕^XNXgɓo^܂B */
		InsertTailList(&task->blocked_task_list, &current_task->task_list_entry);

		/* ^XNXPW[Os܂B */
		task_schedule();
	}

	/* ֗_ŁAw҂^XNx͏IĂ܂BȉAłB */

	/* w҂^XNx́AIR[ho܂B */
	exit_code = task->exit_code;

	/* w҂^XNx́A^XN\̂ƃX^bÑJ܂B(\[X) */
	free(task);

	/* w҂^XNx́AIR[hԂ܂B */
	return exit_code;
}

void
task_kill(TASK* task)
{
	TASK* current_task = task_get_current();

	/* gI邱Ƃ͂ł܂B */
	if(task == current_task) {
		DIE();
	}

	/* ^XNI҂́w^XNxo^ĂꍇA^XNI邱Ƃ͂ł܂B */
	if(!IsListEmpty(&task->blocked_task_list)) {
		DIE();
	}

	/* wI^XNxA܂IĂȂ... */
	if(task->task_list_entry.Flink) {
		/* wI^XNxA^XNXgo^܂B
		 * * ܂IĂȂ^XŃÂꂩ̃^XNXgɓo^Ă͂łB
		 *   - s\łꍇAws\^XNXgx(ready_task_list)
		 *   - ^XNI҂łꍇA^XŃw^XNXgx(TASK.blocked_task_list)
		 *   - Cxg҂łꍇACxǵw^XNXgx(EVENT.blocked_task_list)
		 *   ǂ̃^XNXgɓo^ĂĂA@œo^ł܂B
		 */
		RemoveEntryList(&task->task_list_entry);
		//task->task_list_entry.Flink = NULL;
		//task->task_list_entry.Blink = NULL;
		//Ń\[XŝŁAwI^XNxł邱ƂKv͂܂B
	}

	/* wI^XNx́A^XN\̂ƃX^bÑJ܂B(\[X) */
	free(task);
}

void
task_suspend(TASK* task)
{
	/* TXyhINT_MAXāATXyh񐔂𑝂₷Ƃ͂ł܂B */
	if((task->suspend < 0) || (task->suspend > INT_MAX - 1)) {
		DIE();
	}

	/* TXyh񐔂𑝂₵܂B */
	task->suspend++;

	/* ^XNXPW[Os܂B */
	task_schedule();
}

void
task_resume(TASK* task)
{
	/* TXyh0āATXyh񐔂炷Ƃ͂ł܂B */
	if((task->suspend < 0 + 1) || (task->suspend > INT_MAX)) {
		DIE();
	}

	/* TXyh񐔂炵܂B */
	task->suspend--;

	/* ^XNXPW[Os܂B */
	task_schedule();
}

/* Ɏs^XNIAws^XNx(running_task)Ɋi[܂B
 * [note]
 *	* ws\^XNXgx(ready_task_list)AɎs^XN肵܂B
 *	   Ɏs^XŃAs\ȃ^XN̂AłsDx^XNłB
 */
static void
task_select() /*__attribute__((unused))*/
{
	LIST_ENTRY* list_head = &ready_task_list;
	LIST_ENTRY* list_entry = list_head->Flink;
	TASK* next_task = NULL;

	/* s\ȃ^XN̂AłsDx^XN܂B */
	while(list_entry != list_head) {
		TASK* task = CONTAINING_RECORD(list_entry, TASK, task_list_entry);
		if(!task->suspend) {
			if(!next_task ||
			   (task->priority > next_task->priority)) {
				next_task = task;
			}
		}
		list_entry = list_entry->Flink;
	}

	/* Ɏs^XNAws^XNx(running_task)Ɋi[܂B
	 * * s\ȃ^XNꍇ́AAT[g܂B
	 *   AŃAT[gꍇ́Aȉ̂悤Ȍl܂B
	 *   - ăVXeACh^XNIBVXeACh^XNIĂ͂ȂB
	 *   - VXeACh^XNTXyhĂAATXyhvB
	 *   - VXeACh^XNۑ҂ŕĂAAfbhbNԂƂȂĂB
	 *   ̌AAvP[VvÕoOłB
	 */
	if(!next_task) {
		DIE();
	}
	running_task = next_task;
}

/* ^XN֐̌ĂяoƁAÖقtask_exit()Ăяos܂B
 */
/* static void task_stub() __attribute__((noreturn)) */
asm("
	.code
	.align	1
task_stub:
	; ̊֐͏ԂȂ̂ŁA%r0%r1j󂵂ĂvłB
	popn	%r1		; %r0 = task_proc, %r1 = param
	call.d	%r0		; exit_code = task_proc(param)
	ld.w	%r12, %r1	; *delay*
	xjp.d	task_exit	; task_exit(exit_code)
	ld.w	%r12, %r10	; *delay*
");

/* ^XNXPW[Os܂B
 * [note]
 *	* ̊֐́Aȉ̏s܂B
 *		1. ݂́ws^XNx̃ReLXgArunning_task->spɕۑ܂B
 *		2. task_select()ĂяoAɎs^XNrunning_taskɎ擾܂B
 *		3. Vws^XNx̃ReLXgArunning_task->sp畜܂B
 */
/* static void task_schedule() */
asm("
	.code
	.align	1
task_schedule:
	pushn	%r3
	xld.w	%r4, [running_task]	; running_task->sp = %sp
	ld.w	%r5, %sp
	xld.w	[%r4+0], %r5
	;
	xcall	task_select
	;
	xld.w	%r4, [running_task]	; %sp = running_task->sp
	xld.w	%r5, [%r4+0]
	ld.w	%sp, %r5
	popn	%r3
	ret
");

/****************************************************************************
 *	Cxg
 ****************************************************************************/

EVENT*
event_create(int manual_reset)
{
	EVENT* event;

	/* Cxg\̂̃mۂ܂B */
	event = calloc(sizeof(EVENT), 1);
	if(!event) {
		DIE();
	}

	/* 쐬CxgɁAZbg敪i[܂B */
	event->manual_reset = manual_reset;

	/* 쐬CxǵA^XNXg܂B */
	InitializeListHead(&event->blocked_task_list);

	return event;
}

void
event_delete(EVENT* event)
{
	/* Cxg҂́w^XNxcĂꍇACxg폜邱Ƃ͂ł܂B */
	if(!IsListEmpty(&event->blocked_task_list)) {
		DIE();
	}

	/* Cxg\̂̃J܂B */
	free(event);
}

void
event_wait(EVENT* event)
{
	TASK* current_task = task_get_current();

	/* CxgԂwVOiԁxȂ... */
	if(event->signal) {
		/* ZbgCxgȂ΁AwVOiԁxɖ߂܂B */
		if(!event->manual_reset) {
			event->signal = 0;
		}

	/* CxgԂwVOiԁxȂ... */
	} else {
		/* ݂̃^XNAs\^XNXgo^܂B */
		RemoveEntryList(&current_task->task_list_entry);

		/* ݂̃^XNAw҂Cxgx̕^XNXgɓo^܂B */
		InsertTailList(&event->blocked_task_list, &current_task->task_list_entry);
	}

	/* ^XNXPW[Os܂B */
	task_schedule();
}

void
event_set(EVENT* event)
{
	event_set_pulse(event, 0/*Zbg*/);
}

void
event_pulse(EVENT* event)
{
	event_set_pulse(event, 1/*pX*/);
}

void
event_reset(EVENT* event)
{
	/* CxgԂwVOiԁxɕύX܂B */
	event->signal = 0;

	/* CxgZbǵA^XN؂ւ̗vƂȂ蓾Ȃ̂ŁA^XNXPW[O͕svłB */
}

/* Cxg𔭍s܂B(ZbgA܂́ApX)
 * [in]
 *	event		sCxgB
 * [note]
 *	* event_set()Aevent_pulse()痘p܂B
 */
static void
event_set_pulse(EVENT* event, int pulse)
{
	/* CxgԂwVOiԁxɕύX܂B */
	event->signal = 1;

	/* 蓮ZbgCxgȂ΁A^XNׂċNACxgԂwVOiԁx̂܂܂ɂ܂B
	 * ZbgCxgȂ΁A^XNNACxgԂwVOiԁxɖ߂܂B
	 * ZbgCxgłĂA^XN΁ACxgԂwVOiԁx̂܂܂ɂ܂B
	 */
	while(!IsListEmpty(&event->blocked_task_list)) {
		/* ^XNo^As\^XNXgɓo^܂B(N) */
		InsertTailList(&ready_task_list, RemoveHeadList(&event->blocked_task_list));

		/* ZbgCxgȂ΁ACxgԂwVOiԁxɖ߂āA܂B */
		if(!event->manual_reset) {
			event->signal = 0;
			break;
		}
	}

	/* event_pulse()Ȃ΁A蓮ZbgCxgłĂACxgԂwVOiԁxɖ߂܂B */
	if(pulse) {
		event->signal = 0;
	}

	/* ^XNXPW[Os܂B */
	task_schedule();
}

