/*	
 *	clipsid.h
 *
 *	P/ECE SID(MOS6581) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Dec 27 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_SID_H__
#define __CLIP_SID_H__

/****************************************************************************
 *
 ****************************************************************************/

#define SIDBUFLEN 320 /* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

typedef struct _SID SID;

/***** Tone Oscilator *****/
typedef struct _SIDTO {
	int freq;		/* Frequency */
	int progress;		/* isJE^ */
} SIDTO;

int sidto_process(SIDTO* to, int step);

/***** Waveform Generator *****/
typedef struct _SIDWG {
	int pw;			/* Pulse Width */
	int wf;			/* Waveform */
} SIDWG;

/* SIDWG.wf */
#define SIDWG_TRIANGLE		(1 << 0)
#define SIDWG_SAWTOOTH		(1 << 1)
#define SIDWG_PULSE		(1 << 2)
#define SIDWG_NOISE		(1 << 3)

int sidwg_process(SIDWG* wg, int value);

/***** Envelope Generator *****/
typedef struct _SIDEG {
	int atk;		/* Attack rate */
	int dcy;		/* Decay rate */
	int stn;		/* Sustain amplitude */
	int rls;		/* Release rate */
	//
	int cycle;		/* ATTACK/DECAY/SUSTAIN/RELEASE */
	int progress;		/* isJE^ */
} SIDEG;

/* SIDEG.cycle */
#define SIDEG_ATTACK		4
#define SIDEG_DECAY		3
#define SIDEG_SUSTAIN		2
#define SIDEG_RELEASE		1

int sideg_process(SIDEG* eg, int step);

/***** Voice *****/
typedef struct _SIDVOICE {
	SIDTO to;		/* Tone Oscilator */
	SIDWG wg;		/* Waveform Generator */
	SIDEG eg;		/* Envelope Generator */
} SIDVOICE;

int sid_voice_process(SIDVOICE* voice, int step);

/***** SID Chip *****/
/*typedef*/ struct _SID {
	unsigned char reg[32];	/* WX^ */
	SIDVOICE voice[3];	/* {CXx3 */
	int vol;		/* {[ */
	//
	DDA clock;		/* NbNispDDA */
} /*SID*/;

/****************************************************************************
 *
 ****************************************************************************/

extern const char sid_noise_table[256];		/* mCYWFl[^e[u */
extern const int sid_attack_table[16];		/* ATTACK RATE e[u */
extern const int sid_decay_release_table[16];	/* DECAY/RELEASE RATE e[u */

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* SIDRAZbg܂B
 * [in]
 *	sid		SID\́B
 *	clock		̓NbNB
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́ASIDZbgsꍇɁAKvɉČĂяoĂB
 */
void sid_reset(SID* sid, int clock);

/* WX^lǂݍ݂܂B
 * [in]
 *	sid		SID\́B
 *	regno		WX^ԍB(25`28)
 */
unsigned char sid_read(SID* sid, int regno);

/* WX^l݂܂B
 * [in]
 *	sid		SID\́B
 *	regno		WX^ԍB(0`24)
 *	data		WX^lB
 */
void sid_write(SID* sid, int regno, unsigned char data);

/* 1Tṽ~LVOs܂B
 * [in]
 *	sid		SID\́B
 *	pstep		o߂NbNi[ϐւ̃|C^B
 *			NULL͕słB
 * [out]
 *	߂l		o̓TvlB(t17.5bitt16bit~3VOICEZ)
 *			t16bitւ̃XP[OENbsO͍sĂ܂B
 *			KvɉāAĂяoŃNbsOsĂB
 * [note]
 *	* o̓TvlNbsOĂȂŔAgSID̏o̓TvlƂ̉Z܂łB
 *	  ĂяoŁAgSID̏o̓TvlƂ̉ZɁAXP[OENbsOsĂB
 */
int sid_mix1(SID* sid, int* pstep);

/* 1/50b̃~LVOs܂B
 * [in]
 *	sid		SID\́B
 *	wbuff		o̓Tvobt@B
 * [note]
 *	* PSIDhCo̓TvCPUSID邽߂ɁAsid_mix1()g܂B
 *	  PSIDhCosid_mix()g܂B
 *	* AvP[VSID𗘗pۂɁA1/50bPʂ̓ŏ[ȏꍇɂ́A
 *	  sid_mix1()sid_mix()gyȂ܂B
 */
void sid_mix(SID* sid, short wbuff[/*SIDBUFLEN*/]);

#endif /*__CLIP_SID_H__*/
