/*	
 *	clipren3.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2008 Naoyuki Sawa
 *
 *	* Wed Feb 13 06:00:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 *	* Fri Mar  8 07:00:00 JST 2002 Naoyuki Sawa
 *	- render_line()ŏI_NbsOꂽɁA
 *	  ʒ[1sNZԂoĂ܂CB
 *	* Wed Apr 24 10:11:00 JST 2002 Naoyuki Sawa
 *	- render_polygon()ǉB
 *	* Wed Jun  5 13:51:00 JST 2002 Naoyuki Sawa
 *	- render_point()ǉB
 *	* Wed Jun 18 21:39:00 JST 2002 Naoyuki Sawa
 *	- render_fill()ǉB
 *	* Sat Jul  6 08:42:00 JST 2002 Naoyuki Sawa
 *	- surface_point()ǉB
 *	* Sat Jul  6 17:51:00 JST 2002 Naoyuki Sawa
 *	- render_fill()̊֐render_paint()ɕύXB
 *	- render_rectangle()ǉB
 *	* Thu Jul 25 04:07:00 JST 2002 Naoyuki Sawa
 *	- render_rectangle_fill()ǉB
 *	* Sun Jul 28 16:56:00 JST 2002 Naoyuki Sawa
 *	- render_paint()ɖ߂l(hsNZ)ǉB
 *	* Sat Sep 21 23:02:00 JST 2002 Naoyuki Sawa
 *	- render_dashes()ǉB
 *	* Sat Oct 21 15:58:00 JST 2002 Naoyuki Sawa
 *	- render_dashes()ɖ߂lǉB
 *	* Sat Mar  8 06:23:00 JST 2003 Naoyuki Sawa
 *	- `p[N(xformed_vectors[],clip_vertices[]Ȃ)_def_vbuff[]ɊmہB
 *	* Wed Mar 26 05:00:00 JST 2003 Naoyuki Sawa
 *	- Œ菬ύXɂAWIgXe[W啝ɉB
 *	  ł̋\[X keep/ŉZ`R[hۑ ɕۑĂ܂B
 *	  Œ菬łWbN͕łƓŁAǐ͕ł̂̕ŁA
 *	  ł̋\[X͔jȂŉB
 *	* Sun Mar 30 19:00:00 JST 2003 Naoyuki Sawa
 *	- XLC`֐AZuō܂B40%炢Ȃ܂B
 *	  NOASMV{̒`/`ɂāAC[`ƃAZu[`؂ւ܂B
 *	- ܂͎gppx̍AyŕAcolorE2bitE2bitmaskAZu܂B
 *	  ̑̃XLC`֐AKvɉăAZu\łB
 *	  draw_scanline_wz_2bitmaskS@\o[Wł̂ŁAɍOKƎv܂B
 *	* Tue Apr  1 05:13:00 JST 2003 Naoyuki Sawa
 *	- NbsOB
 *	  n_EI_WCfNX̌vZɏ]ZgĂ̂AɕύXB
 *	* Tue Apr  2 05:53:00 JST 2003 Naoyuki Sawa
 *	- XLC`֐̈ꕔRAM]Ƃframds??.c֕B
 *	  ɔA\̂̒`cliprend.hֈړB
 *	  ܂Ac/asm؂芷V{NOASMREND_NOASMɉAcliprend.hֈړB
 *	* Tue Apr  2 08:00:00 JST 2003 Naoyuki Sawa
 *	- clip_z(),clip_xy()ɃNbsOsvǉAB
 *	* Sun Sep 14 18:44:00 JST 2003 Naoyuki Sawa
 *	- cliprend.cclipren2.c(2D`)/clipren3.d(3D`)ɕB
 *	- render_init()render_init_2d()/render_init_3d()ɕB
 *	* Thu Jul  8 06:00:00 JST 2004 Naoyuki Sawa
 *	- fcom()ficom()̈ύXɒǏ]B
 *	* Mon Aug  2 05:00:00 JST 2004 Naoyuki Sawa
 *	- draw_scanline_wz_1bit()framds12.cֈړ܂B
 *	- draw_scanline_wz_1bitmask()framds13.cֈړ܂B
 *	- draw_scanline_woz_color()framds21.cֈړ܂B
 *	- draw_scanline_woz_1bit()framds22.cֈړ܂B
 *	- draw_scanline_woz_1bitmask()framds23.cֈړ܂B
 *	- draw_scanline_woz_2bit()framds24.cֈړ܂B
 *	- draw_scanline_woz_2bitmask()framds25.cֈړ܂B
 *	* Tue Jan 01 21:30:56 JST 2008 Naoyuki Sawa
 *	- select_draw_scanline_wz()select_draw_scanline_woz()ɁAȉ̕ύXs܂B
 *	- colorp[^̉ʃjuOiFAʃjuwiFɓւ܂B
 *	  K{ł͗L܂񂪁ADRW_CLR()̃p[^ƈvāAՂ邽߂łB
 *	- eNX`|S̕`FAwiFłȂAOiFɕύX܂B
 *	  Oq̓ւƑEāAʃjuŕ`Fw肷邱Ƃɕς肠܂B
 *	* Sun Jan 13 13:34:20 JST 2008 Naoyuki Sawa
 *	- draw_primitive_wz()framdp1.cցAdraw_primitive_woz()framdp2.cցAړ܂B
 *	  draw_primitive_wz()draw_primitive_woz()AAAZu邽߂̏łB
 *	- ̕ύXɔAׂ̍ȕύXs܂B
 *	  ύXӏ́Acliprend.hclipren3.cAu2008/01/13vŌĂB
 *	* Mon Jan 14 23:18:06 JST 2008 Naoyuki Sawa
 *	- draw_primitive_woz()draw_primitive_wz()̓ɒǏ]܂B
 *	  ύXӏ́A{W[Au2008/01/14vŌĂB
 */
#include "clip.h"

/*****************************************************************************
 *	RENDER
 *****************************************************************************/

/* ÓIȃ[NGAA_def_vbuff[]Ɋmۂ邽߂̍\̂łB */
#define N_VERTICES_MAX	8				/* 1|S̍ő咸_ */
typedef struct _RENDER_WORK {
	vector xformed_vectors[255];			/* 12*255=3060: ϊςݒ_Wobt@iMESH.nv8rbgȂ̂ŁAő255_łj */
	CLIPVERTEX clip_vertices[2][N_VERTICES_MAX];	/* 20*2*8= 320: NbsOp_obt@         */
	RENDVERTEX rend_vertices[N_VERTICES_MAX];	/* 10*8  =  80: `p_obt@                 */
} RENDER_WORK;						/* v = 3460: _def_vbuff[128*88=11264]̃TCY𒴂ȂƁIi܂3{ȏ]T܂j */
#define render_work	((RENDER_WORK*)_def_vbuff)	/* `pꎞ[ŃA_def_vbuff[]Ɋmۂ܂B */
							/* ̃[N̓[J֐Ԃ̘Â݂ɗpAO[o֐ԂŕێKv͂Ȃ̂ŁA */
							/* {IɃ[U[AvP[VӎKv͂܂B */
							/* A_def_vbuff[]ɕ`悵悤ƂƁA`撆Ƀ[Nj󂳂A삵܂B */
							/* `^[Qbg_def_vbuff[]w肵Ȃ悤AӂB */

/* NbsO */
static int  clip_z(RENDER* render, int nsrc);
static int clip_xy(RENDER* render, int nsrc);

/* XLC`֐̑IƌĂяo */
/* (yRyA) */
//static void draw_primitive_wz(RENDER* render, int n_vertices, int color);		{{2008/01/13:폜->framdp1.cֈړ܂B}}
//static DSLPROC select_draw_scanline_wz(DSLPARAM* param, RENDER* render, int color);	{{2008/01/13:폜->render_mesh()ɏ܂߂܂B}}
/* (yRyAȂ) */
//static void draw_primitive_woz(RENDER* render, int n_vertices, int color);		{{2008/01/13:폜->framdp2.cֈړ܂B}}
//static DSLPROC select_draw_scanline_woz(DSLPARAM* param, RENDER* render, int color);	{{2008/01/13:폜->render_polygon()ɏ܂߂܂B}}

void
render_init_3d(RENDER* render, SURFACE* surface, int x, int y, int width, int height, fixed front, fixed back, fixed fovy)
{
	/* ܂2DpƂď܂B */
	render_init_2d(render, surface, x, y, width, height);

	/* NbsOݒ肵܂B */
	render->front = front;
	render->back = back;

	/* dvIrender_init_2d()ł̏eƏd܂Ał̏KvłI
	 *       YƁÂƕϊs̏ŁA[ZG[܂II
	 */
	if(width == 0) width = surface->w;
	if(height == 0) height = surface->h;

	/* ϊs܂B(ReLXgX^bNrender_init_2d()ŏς) */
	render->context->matrix = MATRIX_I;
	render->context->matrix = mviewportz(render->context->matrix, x, y, width, height);
	render->context->matrix = mperspect (render->context->matrix, fovy, fidiv(fld(width), height), front);
}

/* * |S`͑SĐŏł܂A݂̎ł͂ȂĂ܂B
 *   bV`̃R[h𗬗p߁ANbsOɕgĂ܂B2003/03/25 Œ菬ɂȂ܂
 *   ̕Ǝ̐ɏ΁A啝ɍł͂łB(TODO)
 * * Ǝv܂ANbsỎǂł́A3%xȂȂ悤łB
 *   |S`ł͂yRyAsvȂ̂ŁAȗ25%xȂ܂B
 *   ̂߂ɁAyRyÃXLC`ǉ̂ǂłB
 * * ->Ă݂܂B
 */
void
render_polygon(RENDER* render, const VERTEX* vertices, int n_vertices, int color)
{
	int i;
	const VERTEX* vertex;
	CLIPVERTEX *clip_vertex;
	RENDVERTEX *rend_vertex;

//{{2008/01/13:ǉB܂łselect_draw_scanline_woz()ōsĂłB
	DSLPARAM param;
	DSLPROC draw_scanline;
	SURFACE* surface = render->surface;
	TEXTURE* texture = render->context->texture;
	param.surface_w = surface->w;
	param.surface_h = surface->h;
	param.surface_vbuff = surface->vbuff;
	if(!texture) {
		draw_scanline = draw_scanline_woz_color;
	} else {
		param.texture_w = texture->header.w;
		param.texture_h = texture->header.h;
		param.texture_buf = texture->buf;
		switch(texture->header.bpp) {
		case 1:
			if(!texture->header.mask) {
				draw_scanline = draw_scanline_woz_1bit;
			} else {
				param.texture_mask = texture->mask;
				draw_scanline = draw_scanline_woz_1bitmask;
			}
			break;
		default/*2*/:
			if(!texture->header.mask) {
				draw_scanline = draw_scanline_woz_2bit;
			} else {
				param.texture_mask = texture->mask;
				draw_scanline = draw_scanline_woz_2bitmask;
			}
			break;
		}
	}
//}}2008/01/13:ǉB܂łselect_draw_scanline_woz()ōsĂłB

	/* NbsOp_XggݗĂ܂B */
	if(n_vertices > N_VERTICES_MAX) n_vertices = N_VERTICES_MAX;
	for(i = 0, vertex = vertices, clip_vertex = render_work->clip_vertices[0];
	    i < n_vertices;
	    i++, vertex++, clip_vertex++) {
		clip_vertex->x = fild(vertex->x);
		clip_vertex->y = fild(vertex->y);
		clip_vertex->z = fild(1); /* ʃNbsÔ߂̃_~[B0ȊOȂ牽łOKłB */
		clip_vertex->s = fadd(fild(vertex->s), fld(0.5)); /* eNZ̒S|Cg */
		clip_vertex->t = fadd(fild(vertex->t), fld(0.5)); /* eNZ̒S|Cg */
	}
	if(n_vertices < 3) return;

	/* ʃNbsOs܂B */
	n_vertices = clip_xy(render, n_vertices);
	if(n_vertices < 3) return;

	/* `p_XggݗĂ܂B */
	for(i = 0, clip_vertex = render_work->clip_vertices[0], rend_vertex = render_work->rend_vertices;
	    i < n_vertices;
	    i++, clip_vertex++, rend_vertex++) {
		rend_vertex->x = fist(clip_vertex->x);
		rend_vertex->y = fist(clip_vertex->y);
//{{2008/01/14:draw_primitive_woz()draw_primitive_wz()̓ɒǏ]
//		/* draw_primitive_woz()rend_vertex->zgȂ̂ŁAsl̂܂܂ővłB */
// * Mon Jan 14 23:18:06 JST 2008 Naoyuki Sawa
// - draw_primitive()rend_vertex->zɑ΂DDAŝŁAz=0ݒ肵ĂƂɂ܂B
//   slł`挋ʂɂ͉e܂񂪁ADDȀpXsƂȂAsx΂ꂪ܂B
//   ŁAm̂߂ɁAz=0ƂĂƂɂ܂B
		rend_vertex->z = 0;
//}}2008/01/14:draw_primitive_woz()draw_primitive_wz()̓ɒǏ]
		rend_vertex->s = fist(fimul(clip_vertex->s, 1 << 8)); /* 8.8bit */
		rend_vertex->t = fist(fimul(clip_vertex->t, 1 << 8)); /* 8.8bit */
	}

//{{2008/01/13:ύX
//	/* v~eBu`܂B */
//	draw_primitive_woz(render, n_vertices, color);
//}}2008/01/13:ύX{{
	/* v~eBu`܂B */
	param.fore_color = color      & 15;
	param.back_color = color >> 4 & 15;
	//draw_primitive_woz(render_work->rend_vertices, n_vertices, &param, draw_scanline);
	//2008/01/14:draw_primitive_woz()draw_primitive_wz()̓ɒǏ]
	draw_primitive(render_work->rend_vertices, n_vertices, &param, draw_scanline);
//}}2008/01/13:ύX
}

void
render_mesh(RENDER* render, const MESH* mesh)
{
	int i, j, n_vectors, n_tcoords, n_faces, n_face_vertices, n_vertices;
	fixed s, xN0, yN0, x01, y01;
	struct _vector *vectors, *vector, *vector_src, *vector_dst; /* ϐvectorƂ̏Փˉ̂߁A\̖ɂstruct_vectorgp */
	TCOORD *tcoords, *tcoord;
	FACE *face;
	FACEVERTEX *face_vertices, *face_vertex;
	CLIPVERTEX *clip_vertex;
	RENDVERTEX *rend_vertex;

//{{2008/01/13:ǉB܂łselect_draw_scanline_wz()ōsĂłB
	DSLPARAM param;
	DSLPROC draw_scanline;
	SURFACE* surface = render->surface;
	TEXTURE* texture = render->context->texture;
	param.surface_w = surface->w;
	param.surface_h = surface->h;
	param.surface_vbuff = surface->vbuff;
	param.surface_zbuff = surface->zbuff;
	if(!texture) {
		draw_scanline = draw_scanline_wz_color;
	} else {
		param.texture_w = texture->header.w;
		param.texture_h = texture->header.h;
		param.texture_buf = texture->buf;
		switch(texture->header.bpp) {
		case 1:
			if(!texture->header.mask) {
				draw_scanline = draw_scanline_wz_1bit;
			} else {
				param.texture_mask = texture->mask;
				draw_scanline = draw_scanline_wz_1bitmask;
			}
			break;
		default/*2*/:
			if(!texture->header.mask) {
				draw_scanline = draw_scanline_wz_2bit;
			} else {
				param.texture_mask = texture->mask;
				draw_scanline = draw_scanline_wz_2bitmask;
			}
			break;
		}
	}
//}}2008/01/13:ǉB܂łselect_draw_scanline_wz()ōsĂłB

	/* Xg̐擪AhXvZ܂B */
	n_vectors = mesh->nv;
	n_tcoords = mesh->nc;
	n_faces = mesh->nf;
	vectors = (struct _vector*)(mesh + 1); /* ϐvectorƂ̏Փˉ̂߁A\̖ɂstruct_vectorgp */
	tcoords = (TCOORD*)(vectors + n_vectors);
	face = (FACE*)(tcoords + n_tcoords);

	/* S_Wϊ܂B */
	for(i = 0, vector_src = vectors, vector_dst = render_work->xformed_vectors;
	    i < n_vectors;
	    i++, vector_src++, vector_dst++) {
		*vector_dst = vxform(render->context->matrix, *vector_src);
	}

	/* etFCX`܂B */
	for(i = 0;
	    i < n_faces;
	    i++, face = (FACE*)(face_vertices + n_face_vertices)) {
		n_face_vertices = face->nfv;
		face_vertices = (FACEVERTEX*)(face + 1);

		/* NbsOp_XggݗĂ܂B
		 * * eNX`̏ꍇsĂ܂񂪁AɖȂ͂łB
		 *   eNX`Ȃmesh->nc=0Ȃ̂ŁAtcoords͍ŏ̃tFCXwĂ܂B
		 *   etFCX_face_vertex->ic=0Ȃ̂ŁAeNX`WƂčŏ̃tFCXm,n擾܂B
		 *   mesh->nf=0̏ꍇ̂ݍŏ̃tFCX݂܂񂪁Ȁꍇ͂̃[v̂܂B
		 *   擾eNX`W͕`掞ɖ̂ŁAeNX`Wl͊֌W܂B
		 *   L̒ʂAeNX`W擾ɕsȃ̈ɃANZXȂƂۏ؂܂B
		 *   ]āAeNX`̏ꍇsȂĂAɖ͂ȂƎv܂B
		 */
		n_vertices = 0;
		for(j = 0, face_vertex = face_vertices, clip_vertex = render_work->clip_vertices[0];
		    j < n_face_vertices;
		    j++, face_vertex++, clip_vertex++) {
			vector = &render_work->xformed_vectors[face_vertex->iv];
			tcoord = &tcoords[face_vertex->ic];
			clip_vertex->x = vector->x;
			clip_vertex->y = vector->y;
			clip_vertex->z = vector->z;
			clip_vertex->s = fadd(fild(tcoord->s), fld(0.5)); /* eNZ̒S|Cg */
			clip_vertex->t = fadd(fild(tcoord->t), fld(0.5)); /* eNZ̒S|Cg */
			if(++n_vertices == N_VERTICES_MAX) break;
		}
		if(n_vertices < 3) continue;

		/* yNbsOs܂B */
		n_vertices = clip_z(render, n_vertices);
		if(n_vertices < 3) continue;

		/* ϊ̂߂ x=x/z,y=y/z s܂B */
		for(j = 0, clip_vertex = render_work->clip_vertices[0];
		    j < n_vertices;
		    j++, clip_vertex++) {
			clip_vertex->x = fdiv(clip_vertex->x, clip_vertex->z);
			clip_vertex->y = fdiv(clip_vertex->y, clip_vertex->z);
		}

		/* \s܂B
		 * E(=\)LqȂ̂ŁA(=)Ȃ`܂B
		 */
		xN0 = fsub(render_work->clip_vertices[0][0].x, render_work->clip_vertices[0][n_vertices - 1].x);
		yN0 = fsub(render_work->clip_vertices[0][0].y, render_work->clip_vertices[0][n_vertices - 1].y);
		x01 = fsub(render_work->clip_vertices[0][1].x, render_work->clip_vertices[0][             0].x);
		y01 = fsub(render_work->clip_vertices[0][1].y, render_work->clip_vertices[0][             0].y);
		s = fsub(fmul(xN0, y01), fmul(x01, yN0));
		if(ficom(s, <=, 0)) continue;

		/* ʃNbsOs܂B */
		n_vertices = clip_xy(render, n_vertices);
		if(n_vertices < 3) continue;

		/* `p_XggݗĂ܂B */
		for(j = 0, clip_vertex = render_work->clip_vertices[0], rend_vertex = render_work->rend_vertices;
		    j < n_vertices;
		    j++, clip_vertex++, rend_vertex++) {
			rend_vertex->x = fist(clip_vertex->x);
			rend_vertex->y = fist(clip_vertex->y);
			rend_vertex->z = fist(fimul(fdiv(fmul(fsub(clip_vertex->z, render->front), render->back  ),
							 fmul(fsub(render->back  , render->front), clip_vertex->z)), 0xffff)); /* 8.8bit */
			rend_vertex->s = fist(fimul(clip_vertex->s, 1 << 8)); /* 8.8bit */
			rend_vertex->t = fist(fimul(clip_vertex->t, 1 << 8)); /* 8.8bit */
		}

//{{2008/01/13:ύX
//		/* v~eBu`܂B */
//		draw_primitive_wz(render, n_vertices, face->c);
//}}2008/01/13:ύX{{
		/* v~eBu`܂B */
		param.fore_color = face->c      & 15;
		param.back_color = face->c >> 4 & 15;
		//draw_primitive_wz(render_work->rend_vertices, n_vertices, &param, draw_scanline);
		//2008/01/14:draw_primitive_woz()draw_primitive_wz()̓ɒǏ]
		draw_primitive(render_work->rend_vertices, n_vertices, &param, draw_scanline);
//}}2008/01/13:ύX
	}
}

/* yNbsOs܂B
 * [in]
 *	render				_[ւ̃|C^B
 *	nsrc				NbsO钸_̐B
 *	render_work->clip_vertices[0]	NbsO钸_XgB(O[oϐ)
 * [out]
 *	߂l				NbsO̒_̐B
 *	render_work->clip_vertices[0]	NbsO̒_XgB(O[oϐ)
 * [note]
 *	* Ɨ̈ƂāArender_work->clip_vertices[1]g܂B
 */
static int
clip_z(RENDER* render, int nsrc)
{
#define CLIP(SRC, DST, OP, LIM) \
	src = SRC; \
	dst = DST; \
	ndst = 0; \
	for(i = 0, v0 = src; i < nsrc; i++, v0++) { \
		v1 = i < nsrc - 1 ? v0 + 1 : src; \
		if(fcom(v0->z, OP, LIM)) { \
			*dst = *v0; \
			dst++; \
			ndst++; \
			if(ndst == N_VERTICES_MAX) break; \
			if(fcom(v1->z, OP, LIM)) { \
				continue; \
			} else { \
				/* go clip */ \
			} \
		} else { \
			if(fcom(v1->z, OP, LIM)) { \
				/* go clip */ \
			} else { \
				continue; \
			} \
		} \
		/* do clip */ \
		dst->z = LIM; \
		n0 = fsub(LIM, v0->z); \
		n1 = fsub(v1->z, LIM); \
		n01 = fadd(n0, n1); \
		n001 = fdiv(n0, n01); \
		dst->x = fadd(v0->x, fmul(fsub(v1->x, v0->x), n001)); \
		dst->y = fadd(v0->y, fmul(fsub(v1->y, v0->y), n001)); \
		dst->s = fadd(v0->s, fmul(fsub(v1->s, v0->s), n001)); \
		dst->t = fadd(v0->t, fmul(fsub(v1->t, v0->t), n001)); \
		dst++; \
		ndst++; \
		if(ndst == N_VERTICES_MAX) break; \
	} \
	if(ndst < 3) return 0; \

	CLIPVERTEX *src, *dst;
	CLIPVERTEX *v0, *v1;
	int i, ndst;
	fixed n0, n1, n01, n001;
	fixed front = render->front;
	fixed back  = render->back ;

	/* ۂ̃NbsȎOɁANbsOKvǂ܂ɔ肵܂B
	 * SĂ̒_WɓĂ΁ANbsO͕Kv܂B
	 * ۂ̃NbsOPȔrł̂ŁANbsOsvȂ獂҂ł܂B
	 * ̌ʁANbsOKvA܂Ȕ菈ԂxȂĂ܂܂B
	 * IuWFNgPʂ̃JOsāAȂׂʊÕbV͕`Ȃ悤ɂĂB
	 */
	v0 = render_work->clip_vertices[0];
	v1 = v0 + nsrc;
	while(v0 < v1) {
		if(!fcom(v0->z, >=, front)) break;
		if(!fcom(v0->z, <=, back )) break;
		v0++;
	}
	if(v0 == v1) return nsrc;

	/* TODO: 唼̃bVSɉʓiŔς݁jA܂͊SɉʊOƉ肷ƁA
	 *         ۂ̃NbsOɓOɊSʊO̔fsȂ邩m܂B
	 */

	/* WőlibackjƂ̔ru<vł͂Ȃu<=vł闝RɂĐ܂B
	 * render_mesh()ŕ`p_XggݗĂĂ鏈΂킩悤ɁA
	 * z=back ̒_ Zobt@l=0xffi8.8bitł0xffffj Ƀ}bvĂ܂B
	 * z=back ̒_łB]āAz=back NbsOƂāu<=vŔ肵Ă܂B
	 */
	CLIP(render_work->clip_vertices[0], render_work->clip_vertices[1], >=, front); nsrc = ndst;
	CLIP(render_work->clip_vertices[1], render_work->clip_vertices[0], <=, back );
	return ndst;

#undef CLIP
}

/* ʃNbsOs܂B
 * [in]
 *	render				_[ւ̃|C^B
 *	nsrc				NbsO钸_̐B
 *	render_work->clip_vertices[0]	NbsO钸_XgB(O[oϐ)
 * [out]
 *	߂l				NbsO̒_̐B
 *	render_work->clip_vertices[0]	NbsO̒_XgB(O[oϐ)
 * [note]
 *	* Ɨ̈ƂāArender_work->clip_vertices[1]g܂B
 */
static int
clip_xy(RENDER* render, int nsrc)
{
#define CLIP(SRC, DST, X, Y, OP, LIM) \
	src = SRC; \
	dst = DST; \
	ndst = 0; \
	for(i = 0, v0 = src; i < nsrc; i++, v0++) { \
		v1 = i < nsrc - 1 ? v0 + 1 : src; \
		if(fcom(v0->X, OP, LIM)) { \
			*dst = *v0; \
			dst++; \
			ndst++; \
			if(ndst == N_VERTICES_MAX) break; \
			if(fcom(v1->X, OP, LIM)) { \
				continue; \
			} else { \
				/* go clip */ \
			} \
		} else { \
			if(fcom(v1->X, OP, LIM)) { \
				/* go clip */ \
			} else { \
				continue; \
			} \
		} \
		/* do clip */ \
		dst->X = LIM; \
		n0 = fsub(LIM, v0->X); \
		n1 = fsub(v1->X, LIM); \
		n01 = fadd(n0, n1); \
		n001 = fdiv(n0, n01); \
		dst->Y = fadd(v0->Y, fmul(fsub(v1->Y, v0->Y), n001)); \
		n0 = fmul(n0, v0->z); \
		n1 = fmul(n1, v1->z); \
		n01 = fadd(n0, n1); \
		n001 = fdiv(n0, n01); \
		dst->z = fadd(v0->z, fmul(fsub(v1->z, v0->z), n001)); \
		dst->s = fadd(v0->s, fmul(fsub(v1->s, v0->s), n001)); \
		dst->t = fadd(v0->t, fmul(fsub(v1->t, v0->t), n001)); \
		dst++; \
		ndst++; \
		if(ndst == N_VERTICES_MAX) break; \
	} \
	if(ndst < 3) return 0; \

	CLIPVERTEX *src, *dst;
	CLIPVERTEX *v0, *v1;
	int i, ndst;
	fixed n0, n1, n01, n001;
	fixed left   = fild(render->left  );
	fixed right  = fild(render->right );
	fixed top    = fild(render->top   );
	fixed bottom = fild(render->bottom);

	/* ۂ̃NbsȎOɁANbsOKvǂ܂ɔ肵܂B
	 * SĂ̒_WɓĂ΁ANbsO͕Kv܂B
	 * ۂ̃NbsOPȔrł̂ŁANbsOsvȂ獂҂ł܂B
	 * ̌ʁANbsOKvA܂Ȕ菈ԂxȂĂ܂܂B
	 * IuWFNgPʂ̃JOsāAȂׂʊÕbV͕`Ȃ悤ɂĂB
	 */
	v0 = render_work->clip_vertices[0];
	v1 = v0 + nsrc;
	while(v0 < v1) {
		if(!fcom(v0->x, >=, left  )) break;
		if(!fcom(v0->x, <=, right )) break;
		if(!fcom(v0->y, >=, top   )) break;
		if(!fcom(v0->y, <=, bottom)) break;
		v0++;
	}
	if(v0 == v1) return nsrc;

	/* TODO: 唼̃bVSɉʓiŔς݁jA܂͊SɉʊOƉ肷ƁA
	 *         ۂ̃NbsOɓOɊSʊO̔fsȂ邩m܂B
	 */

	/* Wőliright,bottomjƂ̔ru<vł͂Ȃu<=vł闝RɂĐ܂B
	 * draw_primitive_*()draw_scanline_*_*()̏c[v΂킩悤ɁA
	 * [ƉE[̃sNZ͕`܂B
	 * Ȃ킿Aʏ̃|S_ẂAObhWnŕ\܂B
	 * ]āA[EE[Ƃ̔ŕu<vł͂Ȃu<=vƂȂ܂B
	 */
	CLIP(render_work->clip_vertices[0], render_work->clip_vertices[1], x, y, >=, left  ); nsrc = ndst;
	CLIP(render_work->clip_vertices[1], render_work->clip_vertices[0], x, y, <=, right ); nsrc = ndst;
	CLIP(render_work->clip_vertices[0], render_work->clip_vertices[1], y, x, >=, top   ); nsrc = ndst;
	CLIP(render_work->clip_vertices[1], render_work->clip_vertices[0], y, x, <=, bottom);
	return ndst;

#undef CLIP
}

/****************************************************************************
 *	yRyA
 ****************************************************************************/

//{{2008/01/13:폜->framdp1.cֈړ܂B
///* v~eBu`܂B
// * [in]
// *	render				_[ւ̃|C^B
// *	n_vertices			_̐B
// *	render_work->rend_vertices	_XgB(O[oϐ)
// *	color				J[B
// */
//static void
//draw_primitive_wz(RENDER* render, int n_vertices, int color)
//{
//	struct {
//		int iv;		/* ݂̕ӂ̏I_CfNX            */
//		int ny;		/* ݂̕ӂ̍̕ψ                */
//		int n;		/* ݂̕ӂ̎c胉C              */
//		RENDVERTEX cur;	/* ݒl                              */
//		DDA x, z;	/* _WDDA(y͍Eʂ1Âi) */
//		DDA s, t;	/* eNX`WDDA                   */
//	} sides[2], *side;
//
//	DSLPARAM param;
//	int i, itop, y, top, bottom;
//	DSLPROC draw_scanline;
//	RENDVERTEX *v, *v0, *v1;
//
//	/* XLC`p[^܂B */
//	draw_scanline = select_draw_scanline_wz(&param, render, color);
//
//	/* ㉺[̈ʒuƁA[̒_߂܂B */
//	itop = 0;
//	top = bottom = render_work->rend_vertices[0].y;
//	for(i = 1; i < n_vertices; i++) {
//		v = &render_work->rend_vertices[i];
//		if(v->y < top) {
//			itop = i;
//			top = v->y;
//		}
//		if(v->y > bottom) {
//			bottom = v->y;
//		}
//	}
//	if(top == bottom) return; /* |S͕`܂B */
//
//	/* E̕ӂ܂B */
//	for(i = 0; i < 2; i++) {
//		side = &sides[i];
//		side->iv = itop;
//		side->n = 0; /* ɖ{̏s悤 */
//	}
//
//	/* [AeXLCɂ... */
//	for(y = top; y < bottom; y++) {
//		/* E̕ӂɂ... */
//		for(i = 0; i < 2; i++) {
//			side = &sides[i];
//			/* ̕ӂɒB... */
//			if(side->n == 0) {
//				do {
//					/* ̕ӂ̗[̒_߂܂B */
//					v0 = &render_work->rend_vertices[side->iv];
//					if(i == 0) {
//						side->iv--;
//						if(side->iv == -1) {
//							side->iv = n_vertices - 1;
//						}
//					} else {
//						side->iv++;
//						if(side->iv == n_vertices) {
//							side->iv = 0;
//						}
//					}
//					v1 = &render_work->rend_vertices[side->iv];
//					/* ̕ӂ̍̕ψʂ߂܂B */
//					side->ny = v1->y - v0->y;
//					/* V|SoAc̕`̓LZ܂B */
//					if(side->ny < 0) return;
//				} while(side->ny == 0); /* ȕӂ͖܂B */
//				/* DDAZbgAbvB */
//				DRAW_PRIMITIVE_SETUP(x);
//				DRAW_PRIMITIVE_SETUP(z);
//				DRAW_PRIMITIVE_SETUP(s);
//				DRAW_PRIMITIVE_SETUP(t);
//				/* ̕ӂ܂ł̃JE^B */
//				side->n = side->ny;
//			}
//		}
//		/* E̕ӂ̊ԂɁA`܂B */
//		sides[0].cur.y = sides[1].cur.y = y;
//		draw_scanline(&sides[0].cur, &sides[1].cur, &param);
//		/* E̕ӂɂ... */
//		for(i = 0; i < 2; i++) {
//			side = &sides[i];
//			/* ̕ӂ܂ł̃C炵܂B */
//			side->n--;
//			/* DDAXebvsB */
//			DRAW_PRIMITIVE_STEP(x)
//			DRAW_PRIMITIVE_STEP(z)
//			DRAW_PRIMITIVE_STEP(s)
//			DRAW_PRIMITIVE_STEP(t)
//		}
//	}
//	/* [̃XLC͕`܂B */
//}
//}}2008/01/13:폜->framdp1.cֈړ܂B

//{{2008/01/13:폜->render_mesh()ɏ܂߂܂B
///* XLC`p[^܂B
// * [in]
// *	param		p[^\̂ւ̃|C^B
// *	render		_[ւ̃|C^B
// * [out]
// *	߂l		XLC`֐ւ̃|C^B
// * [note]
// *	* gȂo͏܂Bi[NA܂j
// */
//static DSLPROC
//select_draw_scanline_wz(DSLPARAM* param, RENDER* render, int color)
//{
//	SURFACE* surface = render->surface;
//	TEXTURE* texture = render->context->texture;
//	DSLPROC draw_scanline;
//
//	/* T[tFCX */
//	param->surface_w     = surface->w;
//	param->surface_h     = surface->h;
//	param->surface_vbuff = surface->vbuff;
//	param->surface_zbuff = surface->zbuff;
//
//	/* eNX`EJ[ */
//	if(texture == NULL) {
//		//param->texture_w    = gȂ
//		//param->texture_h    = gȂ
//		//param->texture_buf  = gȂ
//		//param->texture_mask = gȂ
////{{2008/01/01:ύX
////		param->back_color     = color & 15;
////		//param->fore_color   = gȂ
//// * Tue Jan 01 21:30:56 JST 2008 Naoyuki Sawa
//// - colorp[^̉ʃjuOiFAʃjuwiFɓւ܂B
////   K{ł͗L܂񂪁ADRW_CLR()̃p[^ƈvāAՂ邽߂łB
//// - eNX`|S̕`FAwiFłȂAOiFɕύX܂B
////   Oq̓ւƑEāAʃjuŕ`Fw肷邱Ƃɕς肠܂B
//		param->fore_color     = color & 15;
//		//param->back_color   = gȂ
////}}2008/01/01:ύX
//		draw_scanline = draw_scanline_wz_color;
//	} else {
//		param->texture_w   = texture->header.w;
//		param->texture_h   = texture->header.h;
//		param->texture_buf = texture->buf;
//		switch(texture->header.bpp) {
//		case 1:
//			if(!texture->header.mask) {
//				//param->texture_mask = gȂ
//				draw_scanline = draw_scanline_wz_1bit;
//			} else {
//				param->texture_mask = texture->mask;
//				draw_scanline = draw_scanline_wz_1bitmask;
//			}
////{{2008/01/01:ύX
////			param->back_color = color      & 15;
////			param->fore_color = color >> 4 & 15;
//// * Tue Jan 01 21:30:56 JST 2008 Naoyuki Sawa
//// - colorp[^̉ʃjuOiFAʃjuwiFɓւ܂B
////   K{ł͗L܂񂪁ADRW_CLR()̃p[^ƈvāAՂ邽߂łB
//			param->fore_color = color      & 15;
//			param->back_color = color >> 4 & 15;
////}}2008/01/01:ύX
//			break;
//		default/*2*/:
//			if(!texture->header.mask) {
//				//param->texture_mask = gȂ
//				draw_scanline = draw_scanline_wz_2bit;
//			} else {
//				param->texture_mask = texture->mask;
//				draw_scanline = draw_scanline_wz_2bitmask;
//			}
//			//param->fore_color = gȂ
//			//param->back_color = gȂ
//			break;
//		}
//	}
//
//	return draw_scanline;
//}
//}}2008/01/13:폜->render_mesh()ɏ܂߂܂B

/* * Tue Apr  2 05:53:00 JST 2003 Naoyuki Sawa            */
/* - draw_scanline_wz_color()framds11.cֈړ܂B */

/* * Mon Aug  2 05:00:00 JST 2004 Naoyuki Sawa           */
/* - draw_scanline_wz_1bit()framds12.cֈړ܂B */

/* * Mon Aug  2 05:00:00 JST 2004 Naoyuki Sawa               */
/* - draw_scanline_wz_1bitmask()framds13.cֈړ܂B */

/* * Tue Apr  2 05:53:00 JST 2003 Naoyuki Sawa           */
/* - draw_scanline_wz_2bit()framds14.cֈړ܂B */

/* * Tue Apr  2 05:53:00 JST 2003 Naoyuki Sawa               */
/* - draw_scanline_wz_2bitmask()framds15.cֈړ܂B */

/****************************************************************************
 *	yRyAȂ
 ****************************************************************************/

//{{2008/01/13:폜->framdp2.cֈړ܂B
///* v~eBu`܂B
// * [in]
// *	render				_[ւ̃|C^B
// *	n_vertices			_̐B
// *	render_work->rend_vertices	_XgB(O[oϐ)
// *	color				J[B
// */
//static void
//draw_primitive_woz(RENDER* render, int n_vertices, int color)
//{
//	struct {
//		int iv;		/* ݂̕ӂ̏I_CfNX            */
//		int ny;		/* ݂̕ӂ̍̕ψ                */
//		int n;		/* ݂̕ӂ̎c胉C              */
//		RENDVERTEX cur;	/* ݒl                              */
//		DDA x;		/* _WDDA(y͍Eʂ1Âi) */
//		DDA s, t;	/* eNX`WDDA                   */
//	} sides[2], *side;
//
//	int i, itop, y, top, bottom;
//	RENDVERTEX *v, *v0, *v1;
//	DSLPROC draw_scanline;
//	DSLPARAM param;
//
//	/* XLC`p[^܂B */
//	draw_scanline = select_draw_scanline_woz(&param, render, color);
//
//	/* ㉺[̈ʒuƁA[̒_߂܂B */
//	itop = 0;
//	top = bottom = render_work->rend_vertices[0].y;
//	for(i = 1; i < n_vertices; i++) {
//		v = &render_work->rend_vertices[i];
//		if(v->y < top) {
//			itop = i;
//			top = v->y;
//		}
//		if(v->y > bottom) {
//			bottom = v->y;
//		}
//	}
//	if(top == bottom) return; /* |S͕`܂B */
//
//	/* E̕ӂ܂B */
//	for(i = 0; i < 2; i++) {
//		side = &sides[i];
//		side->iv = itop;
//		side->n = 0; /* ɖ{̏s悤 */
//	}
//
//	/* [AeXLCɂ... */
//	for(y = top; y < bottom; y++) {
//		/* E̕ӂɂ... */
//		for(i = 0; i < 2; i++) {
//			side = &sides[i];
//			/* ̕ӂɒB... */
//			if(side->n == 0) {
//				do {
//					/* ̕ӂ̗[̒_߂܂B */
//					v0 = &render_work->rend_vertices[side->iv];
//					if(i == 0) {
//						side->iv--;
//						if(side->iv == -1) {
//							side->iv = n_vertices - 1;
//						}
//					} else {
//						side->iv++;
//						if(side->iv == n_vertices) {
//							side->iv = 0;
//						}
//					}
//					v1 = &render_work->rend_vertices[side->iv];
//					/* ̕ӂ̍̕ψʂ߂܂B */
//					side->ny = v1->y - v0->y;
//					/* V|SoAc̕`̓LZ܂B */
//					if(side->ny < 0) return;
//				} while(side->ny == 0); /* ȕӂ͖܂B */
//				/* DDAZbgAbvB */
//				DRAW_PRIMITIVE_SETUP(x);
//				DRAW_PRIMITIVE_SETUP(s);
//				DRAW_PRIMITIVE_SETUP(t);
//				/* ̕ӂ܂ł̃JE^B */
//				side->n = side->ny;
//			}
//		}
//		/* E̕ӂ̊ԂɁA`܂B */
//		sides[0].cur.y = sides[1].cur.y = y;
//		draw_scanline(&sides[0].cur, &sides[1].cur, &param);
//		/* E̕ӂɂ... */
//		for(i = 0; i < 2; i++) {
//			side = &sides[i];
//			/* ̕ӂ܂ł̃C炵܂B */
//			side->n--;
//			/* DDAXebvsB */
//			DRAW_PRIMITIVE_STEP(x)
//			DRAW_PRIMITIVE_STEP(s)
//			DRAW_PRIMITIVE_STEP(t)
//		}
//	}
//	/* [̃XLC͕`܂B */
//}
//}}2008/01/13:폜->framdp2.cֈړ܂B

//{{2008/01/13:폜->render_polygon()ɏ܂߂܂B
///* XLC`p[^܂B
// * [in]
// *	param		p[^\̂ւ̃|C^B
// *	render		_[ւ̃|C^B
// * [out]
// *	߂l		XLC`֐ւ̃|C^B
// * [note]
// *	* gȂo͏܂Bi[NA܂j
// */
//static DSLPROC
//select_draw_scanline_woz(DSLPARAM* param, RENDER* render, int color)
//{
//	SURFACE* surface = render->surface;
//	TEXTURE* texture = render->context->texture;
//	DSLPROC draw_scanline;
//
//	/* T[tFCX */
//	param->surface_w       = surface->w;
//	param->surface_h       = surface->h;
//	param->surface_vbuff   = surface->vbuff;
//	//param->surface_zbuff = gȂ
//
//	/* eNX`EJ[ */
//	if(texture == NULL) {
//		//param->texture_w    = gȂ
//		//param->texture_h    = gȂ
//		//param->texture_buf  = gȂ
//		//param->texture_mask = gȂ
////{{2008/01/01:ύX
////		param->back_color     = color & 15;
////		//param->fore_color   = gȂ
//// * Tue Jan 01 21:30:56 JST 2008 Naoyuki Sawa
//// - colorp[^̉ʃjuOiFAʃjuwiFɓւ܂B
////   K{ł͗L܂񂪁ADRW_CLR()̃p[^ƈvāAՂ邽߂łB
//// - eNX`|S̕`FAwiFłȂAOiFɕύX܂B
////   Oq̓ւƑEāAʃjuŕ`Fw肷邱Ƃɕς肠܂B
//		param->fore_color     = color & 15;
//		//param->back_color   = gȂ
////}}2008/01/01:ύX
//		draw_scanline = draw_scanline_woz_color;
//	} else {
//		param->texture_w   = texture->header.w;
//		param->texture_h   = texture->header.h;
//		param->texture_buf = texture->buf;
//		switch(texture->header.bpp) {
//		case 1:
//			if(!texture->header.mask) {
//				//param->texture_mask = gȂ
//				draw_scanline = draw_scanline_woz_1bit;
//			} else {
//				param->texture_mask = texture->mask;
//				draw_scanline = draw_scanline_woz_1bitmask;
//			}
////{{2008/01/01:ύX
////			param->back_color = color      & 15;
////			param->fore_color = color >> 4 & 15;
//// * Tue Jan 01 21:30:56 JST 2008 Naoyuki Sawa
//// - colorp[^̉ʃjuOiFAʃjuwiFɓւ܂B
////   K{ł͗L܂񂪁ADRW_CLR()̃p[^ƈvāAՂ邽߂łB
//			param->fore_color = color      & 15;
//			param->back_color = color >> 4 & 15;
////}}2008/01/01:ύX
//			break;
//		default/*2*/:
//			if(!texture->header.mask) {
//				//param->texture_mask = gȂ
//				draw_scanline = draw_scanline_woz_2bit;
//			} else {
//				param->texture_mask = texture->mask;
//				draw_scanline = draw_scanline_woz_2bitmask;
//			}
//			//param->fore_color = gȂ
//			//param->back_color = gȂ
//			break;
//		}
//	}
//
//	return draw_scanline;
//}
//}}2008/01/13:폜->render_polygon()ɏ܂߂܂B

/* * Mon Aug  2 05:00:00 JST 2004 Naoyuki Sawa             */
/* - draw_scanline_woz_color()framds21.cֈړ܂B */

/* * Mon Aug  2 05:00:00 JST 2004 Naoyuki Sawa            */
/* - draw_scanline_woz_1bit()framds22.cֈړ܂B */

/* * Mon Aug  2 05:00:00 JST 2004 Naoyuki Sawa                */
/* - draw_scanline_woz_1bitmask()framds23.cֈړ܂B */

/* * Mon Aug  2 05:00:00 JST 2004 Naoyuki Sawa            */
/* - draw_scanline_woz_2bit()framds24.cֈړ܂B */

/* * Mon Aug  2 05:00:00 JST 2004 Naoyuki Sawa                */
/* - draw_scanline_woz_2bitmask()framds25.cֈړ܂B */

