/*	
 *	clipm65.c
 *
 *	P/ECE MOS6502 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Dec 07 12:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Fri Dec 19 06:00:00 JST 2003 Naoyuki Sawa
 *	- WAI(W65C02g)̃T|[gǉB
 *	* Sat Jan 29 21:23:00 JST 2005 Naoyuki Sawa
 *	- SP̏l$00$FF֕ύX܂B
 *	* Sun Jan 30 07:22:00 JST 2005 Naoyuki Sawa
 *	- PSȐlPSR(R,I)PSR(R,I,Z)֕ύX܂B
 */
#include "clip.h"
#include "clipm65i.h"	/*M6502G~[^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	IyR[h}bv
 */
const M6502OP m6502_op_table[256/*opcode*/] = {
#include "m6502/table.h" /* [m6502.xls]Table */
};

/*
 *	j[jbNe[u
 */
#undef M6502FN_
#define M6502FN_(OP, FN)	OP "\0"
const char m6502_op_name_table[] = {
	"\0" /* ItZbg0̓k */
#include "m6502/list.h" /* [m6502.xls]List!C6 */
};
#undef M6502FN_

/****************************************************************************
 *
 ****************************************************************************/

void
m6502_reset(M6502* m6502, M6502READPROC* read, M6502WRITEPROC* write)
{
	memset(m6502, 0, sizeof(M6502));
	m6502->read  = read  ? read  : m6502_internal_read;
	m6502->write = write ? write : m6502_internal_write;

	//PSR = 0x24;		/* R,I */
	//2005/01/30 PSȐlPSR(R,I)PSR(R,I,Z)֕ύX */
	PSR = 0x26;		/* R,I,Z */
	PC = READ16(0xfffc);
	SP = 0xff;		/* 2005/01/29 SP̏l$00$FF֕ύX */
}

/* * PSR(B)̐U镑ɂ
 * - IRQ/BRKPSR(B)̐U镑́AISRɓnPSR(B)ω̂ł͂ȂAX^bNɐςPSR(B)ω܂B
 *   ISRIRQ/BRK𔻒fɂ́APSR𒲂ׂĂӖŁAX^bNɐς܂ꂽPSR𒼐ڎQƂ邵܂B
 * - Oʂ̃ReLXgBRK߂gƁAPSR(B)=1ɂȂċAĂ܂B
 *   ܂AIRQ/NMIɂA\łȂ^C~OPSR(B)NA܂B
 *   ܂AOʂ̃ReLXgPSR(B)𒲂ׂ邱Ƃɂ͈Ӗ܂B
 * - EEEȎdlłEEEzgɂōĂł傤H
 * 
 * - 悭lAISR̒ł\łȂ^C~ONMIɂPSR(B)NA邩A
 *   PSR(B)ł͂ȂX^bNPSR(B)𒲂ׂdlɂȂĂ̂ł傤H
 *   OʃReLXgPSRɏĂ܂Ƃ̂ȎdlƎv̂łEEE
 */

void
m6502_int(M6502* m6502)
{
	if(PSR & 4) return;
	PUSH(PCH);
	PUSH(PCL);
	PUSH(PSR & ~0x10);	/* B */
	PSR |= 4;		/* I */
	PC = READ16(0xfffe);
	WAIT = 0;
}

void
m6502_brk(M6502* m6502)
{
	PC++; /* BRK1oCĝ͎Ădl */
	PUSH(PCH);
	PUSH(PCL);
	PUSH(PSR | 0x10);	/* B */
	PSR |= 4;		/* I */
	PC = READ16(0xfffe);
}

void
m6502_nmi(M6502* m6502)
{
	PUSH(PCH);
	PUSH(PCL);
	PUSH(PSR & ~0x10);	/* B */
	PSR |= 4;		/* I */
	PC = READ16(0xfffa);
	WAIT = 0;
}

void
m6502_dump(M6502* m6502)
{
#define INDENT	40
	TRACE("%*s", INDENT, "");
	TRACE("A:%02x X:%02x Y:%02x PC:%04x SP:%02x PSR:%c%c%c%c%c%c%c%c\n",
		A, X, Y, PC, SP,
		PSR & (1 << 7) ? 'N' : '-',
		PSR & (1 << 6) ? 'V' : '-',
		PSR & (1 << 5) ? 'R' : '-',
		PSR & (1 << 4) ? 'B' : '-',
		PSR & (1 << 3) ? 'D' : '-',
		PSR & (1 << 2) ? 'I' : '-',
		PSR & (1 << 1) ? 'Z' : '-',
		PSR & (1 << 0) ? 'C' : '-');
#undef INDENT
}

/****************************************************************************
 *
 ****************************************************************************/

#ifdef PIECE

asm("
	.code
	.global m6502_run2
m6502_run2:
	pushn %r0
	ld.w %r0, %sp		; X^bNޔ
	xld.w %r10, 0x1000	; 0x0e00`0x1000ɃX^bNؑ
	ld.w %sp, %r10
	xcall m6502_run
	ld.w %sp, %r0		; X^bN
	popn %r0
	ret
");

#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

