/*	
 *	clipeth.c
 *
 *	P/ECE USB Ethernet (DIX Ethernet Ver2.0)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Tue Aug 23 04:43:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Dec 08 00:00:11 JST 2007 Naoyuki Sawa
 *	- clipusb̎dlύXz܂B
 *	  MI[o[\Ƃ邽߂̎dlύXłA{W[͑ΉĂ܂B
 *	  clipusb̎dlύX{W[ŋẑŁA{W[̋@\͂܂łǂłB
 *	  {W[AMI[o[ւ̕ύX́AAKvƂɍs\łB
 */
#include "clip.h"

/****************************************************************************
 *	fBXNv^`
 ****************************************************************************/

/* foCXfBXNv^ */
static const DEVICE_DESCRIPTOR device_desc = {
	bLength:		sizeof(DEVICE_DESCRIPTOR),
	bDescriptorType:	DEVICE_DESCRIPTOR_TYPE,
	bcdUSB:			0x0110,
	bMaxPacketSize0:	EP0_PACKET_SIZE,
	idVendor:		PCE_VENDOR_ID,
	idProduct:		ETHERNET_PRODUCT_ID,			/* d֎~!! */
	bcdDevice:		0x0001,
	iManufacture:		1,
	iProduct:		2,
	bNumConfigurations:	1,
};

/* RtBM[VfBXNv^ */
static const CONFIGURATION_DESCRIPTOR config_desc = {
	bLength:		sizeof(CONFIGURATION_DESCRIPTOR),
	bDescriptorType:	CONFIGURATION_DESCRIPTOR_TYPE,
	wTotalLength:		sizeof(CONFIGURATION_DESCRIPTOR) +	/* config_desc */
				sizeof(INTERFACE_DESCRIPTOR    ) +	/* interface_desc */
				sizeof(ENDPOINT_DESCRIPTOR     ) +	/* endpoint_desc_ep2in */
				sizeof(ENDPOINT_DESCRIPTOR     ),	/* endpoint_desc_ep2out */
	bNumInterfaces:		1,
	bConfigurationValue:	1,
	iConfiguration:		3,
	bmAttributes:		0x80,					/* Bus-powered */
	MaxPower:		100 / 2,				/* 100[mA] () */
};

/* C^[tFCXfBXNv^ */
static const INTERFACE_DESCRIPTOR interface_desc = {
	bLength:		sizeof(INTERFACE_DESCRIPTOR),
	bDescriptorType:	INTERFACE_DESCRIPTOR_TYPE,
	bNumEndpoints:		2,
	bInterfaceClass:	0xff,					/* Vendor-specific */
	bInterfaceSubClass:	0xff,					/* Vendor-specific */
	bInterfaceProtocol:	0xff,					/* Vendor-specific */
	iInterface:		4,
};

/* Gh|CgfBXNv^
 * * P/ECERpC̕s΍̂߁Aendpoint_desc\̔zɂȂ悤!!
 *   ڂ́Aclip/clipusb.h̃RgQƂĂB
 */
static const ENDPOINT_DESCRIPTOR endpoint_desc_ep2in = {
	bLength:		sizeof(ENDPOINT_DESCRIPTOR),
	bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,
	bEndpointAddress:	0x82,					/* EP2IN */
	bAttributes:		2,					/* Bulk */
	wMaxPacketSize:		EP2_NONISO_PACKET_SIZE,
};
static const ENDPOINT_DESCRIPTOR endpoint_desc_ep2out = {
	bLength:		sizeof(ENDPOINT_DESCRIPTOR),
	bDescriptorType:	ENDPOINT_DESCRIPTOR_TYPE,
	bEndpointAddress:	0x02,					/* EP2OUT */
	bAttributes:		2,					/* Bulk */
	wMaxPacketSize:		EP2_NONISO_PACKET_SIZE,
};

/* XgOfBXNv^
 * * gcćAL"..."`16bit UNICODEg܂B(32bitɂȂĂ܂܂)
 *   Ȃ̂ŁA1oCgÂLq܂B
 * * 񒆂[0-7]܂ނƁA'\0'̑ƌȂ̂ŁAӂĂB
 */
static const char* const string_desc[] = {
//	   ++--- 04 06 08 0a 0c 0e 10 12 14 16 18 1a 1c 1e 20 22 24 26 28 2a 2c 2e 30
//	   ||
//	"\x??\3_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0_\0"
	"\x04\3\x09\x04",								// 0: wLANGID = 0x0409 English (United States)
	"\x16\3P\0i\0e\0c\0e\0 \0L\0a\0b\0.\0",						// 1: iManufacture   = "Piece Lab."
	"\x22\3P\0/\0E\0C\0E\0 \0U\0S\0B\0 \0d\0e\0v\0i\0c\0e\0",			// 2: iProduct       = "P/ECE USB device"
	"\x2e\3E\0t\0h\0e\0r\0n\0e\0t\0 \0c\0o\0n\0f\0i\0g\0u\0r\0a\0t\0i\0o\0n\0",	// 3: iConfiguration = "Ethernet configuration"
	"\x26\3E\0t\0h\0e\0r\0n\0e\0t\0 \0i\0n\0t\0e\0r\0f\0a\0c\0e\0",			// 4: iInterface     = "Ethernet interface"
};

/****************************************************************************
 *	
 ****************************************************************************/

/* hCo\ */
typedef struct _ETHERNETDRIVER {
	unsigned char address[6];		// EthernetAhX (vendor_requestŎݒ)
	//
	unsigned char rxbuf[1514];		// Mt[obt@
	int rxlen;				// Mt[
	//
	QUEUE* txque;				// ML[
	unsigned char txbuf[1514];		// Mt[obt@
	int txlen;				// Mt[
	int txpos;				// Mt[|C^
	int txing;				// M~=0, 쒆=1
	//
	ETHERNETSTAT stat;			// ʐM (fobOp)
	//
	LIST_ENTRY client_list;			// NCAgXg
} ETHERNETDRIVER;
static ETHERNETDRIVER driver;

static void get_descriptor(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_configuration(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_interface(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void vendor_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len);

static void bus_reset();
//{{2007/12/08:clipusb̎dlύXz
//static void ep2_rxdone(const unsigned char dat[/*len*/], int len);
//2007/12/08:clipusb̎dlύXz
static void ep2_rxdone();
static void ep2_rxsub(const unsigned char dat[/*len*/], int len);
//}}2007/12/08:clipusb̎dlύXz
static void ep2_txdone();
static int  ep2_txsub();

static ETHERNETCLIENT* ethernet_find_client(int type);

/* USBtbN */
static const USBINF usb_inf = {
	/* USBC mode */
	mode:			D12_ENDP_NONISO,
	/* USBC raw event */
	bus_reset:		bus_reset,
	ep2_rxdone:		ep2_rxdone,
	ep2_txdone:		ep2_txdone,
	/* Device request */
	get_descriptor:		get_descriptor,
	set_configuration:	set_configuration,
	set_interface:		set_interface,
	vendor_request:		vendor_request,
};

/* x_NGXgR[h (foCXhCo̒`ƈv邱) */
#define SET_DEVICE_ADDRESS	0	/* EthernetAhXݒ肵܂ */

/* AhX */
const unsigned char ethernet_null_address[6]      = { 0x00,0x00,0x00,0x00,0x00,0x00 };

/* u[hLXgAhX */
const unsigned char ethernet_broadcast_address[6] = { 0xff,0xff,0xff,0xff,0xff,0xff };

/****************************************************************************
 *	
 ****************************************************************************/

static void
get_descriptor(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	static unsigned char tmpbuf[sizeof config_desc /* rs`shbłI */
				  + sizeof interface_desc
				  + sizeof endpoint_desc_ep2in
				  + sizeof endpoint_desc_ep2out];
	//
	int type  = HIBYTE(req->wValue);
	int index = LOBYTE(req->wValue);

	/* vꂽfBXNv^ԑ܂B */
	switch(type) {
	case DEVICE_DESCRIPTOR_TYPE:
		usb_ep0_tx(&device_desc, sizeof device_desc);
		return;
	case CONFIGURATION_DESCRIPTOR_TYPE:
		switch(index) {
		case 0:
			len = 0;
			memcpy(&tmpbuf[len], &config_desc         , sizeof config_desc         ); len += sizeof config_desc         ;
			memcpy(&tmpbuf[len], &interface_desc      , sizeof interface_desc      ); len += sizeof interface_desc      ;
			memcpy(&tmpbuf[len], &endpoint_desc_ep2in , sizeof endpoint_desc_ep2in ); len += sizeof endpoint_desc_ep2in ;
			memcpy(&tmpbuf[len], &endpoint_desc_ep2out, sizeof endpoint_desc_ep2out); len += sizeof endpoint_desc_ep2out;
			usb_ep0_tx(tmpbuf, len);
			return;
		}
		break;
	case STRING_DESCRIPTOR_TYPE:
		if(index < ARRAY_SIZE(string_desc)) {
			usb_ep0_tx(string_desc[index], string_desc[index][0]);
			return;
		}
		break;
	}
	usb_ep0_stall(); /* Ή */
}

static void
set_configuration(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	/* RtBO[V#1(ꂵ܂)IꂽACGh|CgLɂ܂B */
	D12_SetEndpointEnable(req->wValue == 1);
	usb_ep0_tx(NULL, 0); /* ACK */
}

static void
set_interface(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	/* C^[tFCX̑֐ݒ͂ЂƂȂ̂ŁA܂B */
	usb_ep0_tx(NULL, 0); /* ACK */
}

static void
vendor_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	switch(req->bRequest) {
	case SET_DEVICE_ADDRESS:
		/* EthernetAhXݒ肵܂B */
		if(len == 6) {
			ethernet_set_address(dat);
			usb_ep0_tx(NULL, 0); /* ACK */
		} else {
			usb_ep0_stall();
		}
		return;
	}
	usb_ep0_stall();
}

/****************************************************************************
 *	
 ****************************************************************************/

static void
bus_reset()
{
	/* USBĐڑꂽƂɃR[obNAMԂNA܂B
	 *
	 * - Windows 2000ɂł́AfoCXhCoɑē񔭐݂łB
	 *   foCXhCoIɂ́A܂B
	 *   Ă΂Kv͂܂񂪁AĂ΂Ă͖肠܂B
	 *
	 * - MԂNA闝ŔÂƂłB
	 *   USBؒfĂԂɁAMvꂽt[AMt[obt@ƃL[ɗ܂Ă܂B
	 *   ML[ςɂȂĂƁAUSBĐڑꂽ̑Mv󂯕t邱Ƃł܂B
	 *   USBĐڑɁAPC̃foCXhCoEthernetAhXݒ肳AGratuitous ARP̑Mv͂łB
	 *   USBĐڑɁAMv𒼂Ɏ󂯕t悤AMvt[j邱Ƃɂ܂B
	 *
	 * - MԂNA闝ŔÂƂłB
	 *   t[MrUSBؒfꍇAr܂ŎMĂt[Mobt@ɎcĂ\܂B
	 *   USBĐڑɁAVMJnt[ƁAr܂ŎMĂt[Ă܂\܂B
	 *   ̂悤ȃP[X͔ɋHłAČĎ邱ƂłAÔߑ΍􂵂ĂƂɂ܂B
	 */

	/* MԂNA܂B */
	clear_queue(driver.txque);	/* ML[ */
	driver.txlen = 0;		/* Mt[obt@ */
	driver.txing = 0;		/* M쒆tO */

	/* MԂNA܂B */
	driver.rxlen = 0;		/* Mt[obt@ */

	/* oXZbg񐔂AJEgAbv܂B */
	driver.stat.reset++;
}

//{{2007/12/08:clipusb̎dlύXz
static void
ep2_rxdone()
{
	int len;
	unsigned char dat[EP2_NONISO_PACKET_SIZE];
	for(;;) { /* _uobt@ɓpPbgSď */
		len = D12_ReadBuffer(EP2OUT, dat, sizeof dat);
		if(len == -1) break;
		D12_ClearBuffer(EP2OUT);
		ep2_rxsub(dat, len);
	}
}
//}}2007/12/08:clipusb̎dlύXz

//{{2007/12/08:clipusb̎dlύXz
//static void
//ep2_rxdone(const unsigned char dat[/*len*/], int len)
//2007/12/08:clipusb̎dlύXz
static void
ep2_rxsub(const unsigned char dat[/*len*/], int len)
//}}2007/12/08:clipusb̎dlύXz
{
	int type;
	ETHERNETCLIENT* client;

	/* Mf[^Mt[obt@֒ǉ܂B
	 * őt[𒴉߂ꍇ́Af[^̂ĂāÂݑ܂B
	 * t[MɁAt[At[𔻒f邽߂łB
	 */
	if(driver.rxlen + len <= 1514) {
		memcpy(driver.rxbuf + driver.rxlen, dat, len);
	}
	driver.rxlen += len;

	/* Gh|CgTCY̎MȂ΁Ã݂t[M܂B
	 * t[Gh|CgTCY̔{łꍇ́A
	 * Ōɋf[^ė͂Ȃ̂ŁAŊ𔻒fł܂B
	 */
	if(len < EP2_NONISO_PACKET_SIZE) {

		/* t[́AG[JEgAPɖ邱Ƃɂ܂B
		 * PChCoAGh|CgTCỸf[^M̌ɁA
		 * ɔOċt[𑗂ė\邩łB
		 */
		if(!driver.rxlen) {
			/** no job **/
			goto L_SKIP;
		}

		/* Mt[́At[܂B */
		if((driver.rxlen < 60) || (driver.rxlen > 1514)) {
			driver.stat.rxerr++; /* t[s */
			goto L_SKIP;
		}

		/* āA܂́Au[hLXgt[ȊÓAj܂B */
		if((memcmp(driver.rxbuf + 0, driver.address,             6) != 0) &&
		   (memcmp(driver.rxbuf + 0, ethernet_broadcast_address, 6) != 0)) {
			/** no job **/
			goto L_SKIP;
		}

		/* Mt[AJEgAbv܂B */
		driver.stat.rxok++;

		/* t[^CvɑΉNCAg֑܂B */
		type = BEHALF(driver.rxbuf + 12);
		client = ethernet_find_client(type);
		if(client) {
			if(client->recv) {
				client->recv(client,
					driver.rxbuf +  6,	/* MEthernetAhX */
					driver.rxbuf + 14,	/* f[^ */
					driver.rxlen - 14);	/* f[^ */
			}
		}
L_SKIP:
		/* Mobt@ɖ߂܂B */
		driver.rxlen = 0;
	}
}

static void
ep2_txdone()
{
	/* Mt[AGh|Cg֏݂܂B
	 * Mt[ȂAtxing=0(M~)ֈڍs܂B
	 */
	ASSERT(driver.txing);
	driver.txing = ep2_txsub();
}

/* M̃t[AGh|Cg֏݂܂B
 * M̃t[΁AL[玟̑Mt[擾AGh|Cg֏݂܂B
 * L[Ȃ΁A܂B
 * Gh|Cgւ݂̏sꍇ́A      1(M쒆)Ԃ܂B
 * Gh|Cgւ݂̏sȂꍇ́A0(M~)Ԃ܂B
 */
/* 荞݋֎~ԂŌĂяoĂ!! */
static int
ep2_txsub()
{
	int len;

	/* M̃t[... */
	if(!driver.txlen) {

		/* ML[玟̑Mt[擾܂B */
		len = read_queue(driver.txque, driver.txbuf, sizeof driver.txbuf);
		if(len < 0) {

			/* ML[Ȃ΁AA܂B */
			return 0; /* M~ */
		}

		/* ŏt[̃t[́Aŏt[܂ŃpfBO܂B
		 * pfBÕf[^͉ł\܂񂪁AfobOՂ̂߂ɁA[NAĂƂɂ܂B(K{ł͂܂)
		 */
		if(len < 60) {
			memset(driver.txbuf + len, 0, 60 - len); /* Ă */
			len = 60;
		}

		/* Mt[ƃ|C^܂B */
		driver.txlen = len;
		driver.txpos = 0;
	}

	/* Mt[AGh|Cg֏݂܂B */
	len = driver.txlen - driver.txpos; /* len=0L蓾܂ */
	if(len > EP2_NONISO_PACKET_SIZE) {
		len = EP2_NONISO_PACKET_SIZE;
	}
//{{2007/12/08:clipusb̎dlύXz
//	D12_WriteEndpoint(EP2IN, driver.txbuf + driver.txpos, len);
//2007/12/08:clipusb̎dlύXz
	D12_WriteBuffer(EP2IN, driver.txbuf + driver.txpos, len);
	D12_ValidateBuffer(EP2IN);
//}}2007/12/08:clipusb̎dlύXz
	driver.txpos += len;

	/* Gh|CgTCY̑MŁAt[I[܂B */
	if(len < EP2_NONISO_PACKET_SIZE) {
		driver.txlen = 0;

		/* Mt[AJEgAbv܂B */
		driver.stat.txok++;
	}

	return 1; /* M쒆 */
}

/****************************************************************************
 *	
 ****************************************************************************/

/* NCAgXgAw肵t[^CvɑΉNCAgT܂B
 * w肵t[^CvɑΉNCAgA|C^Ԃ܂B
 * w肵t[^CvɑΉNCAgȂ΁ANULLԂ܂B
 */
/* 荞݋֎~ԂŌĂяoĂ!! */
static ETHERNETCLIENT*
ethernet_find_client(int type)
{
	LIST_ENTRY* list_head = &driver.client_list;	/* Xg̃[gvf */
	LIST_ENTRY* list_entry = list_head->Flink;	/* 擪̗vf(orI[) */
	ETHERNETCLIENT* client;

	while(list_entry != list_head) {
		if(!list_entry) {
			DIE(); /* A܂́ANCAgXgj */
		}
		client = CONTAINING_RECORD(list_entry, ETHERNETCLIENT, list_entry);
		if(client->type == type) {
			return client;
		}
		list_entry = list_entry->Flink;
	}

	return NULL;
}

void
ethernet_start(int txque_capacity)
{
	/* ܂Amɐؒf܂B */
	ethernet_stop();

	/* hCo\̂NA܂B */
	memset(&driver, 0, sizeof driver);

	/* ML[쐬܂B */
	//if(txque_capacity < (sizeof(int) + 1514)) {
	//	txque_capacity = (sizeof(int) + 1514);
	//}
	//2005/09/16 create_queue()Öقsizeof(int)Z悤dlύXƂɒǏ]܂B
	if(txque_capacity < 1514) {
		txque_capacity = 1514;
	}
	driver.txque = create_queue(txque_capacity);

	/* NCAgXg܂B */
	InitializeListHead(&driver.client_list);

	/* USBtbN܂B */
	usb_start(&usb_inf);
}

void
ethernet_stop()
{
	/* USB̃tbN܂B */
	usb_stop();

	/* ML[폜܂B */
	if(driver.txque) {
		delete_queue(driver.txque);
	}

	/* hCo\̂NA܂B */
	memset(&driver, 0, sizeof driver);
}

void
ethernet_open(ETHERNETCLIENT* client)
{
ENTER_CS;

	if((client->type < 0x0600) || (client->type > 0xffff)) {
		DIE(); /* sȃt[^Cv */
	}

	if(ethernet_find_client(client->type)) {
		DIE(); /* t[^Cvo^ς */
	}

	/* NCAgXgɒǉ܂B */
	InsertTailList(&driver.client_list, &client->list_entry);

LEAVE_CS;
}

void
ethernet_close(ETHERNETCLIENT* client)
{
ENTER_CS;

	if(ethernet_find_client(client->type) != client) {
		DIE(); /* o^̃NCAg */
	}

	/* NCAgXg菜܂B */
	RemoveEntryList(&client->list_entry);

LEAVE_CS;
}

int
ethernet_send(ETHERNETCLIENT* client, const unsigned char* address/*[6]*/, const void* data/*[length]*/, int length)
{
	int retval;
	//
	int tmpbuf_length;
	unsigned char* tmpbuf = NULL; /* vJ */

	if(length < 0) {
		DIE(); /* p[^s */
	}

	/* ŏt[ւ̃pfBÓAML[oɍs܂B */
	if(length < (60 - 14)) {
		/** no job **/
	}

	/* őt[𒴉߂鑗Mv́AG[~Ƃ܂B */
	if(length > (1514 - 14)) {
		DIE();
	}

	/* Ethernett[\zpobt@mۂ܂B */
	tmpbuf_length = 14/*Ethernetwb_*/ + length/*f[^*/;
	tmpbuf = malloc(tmpbuf_length);
	if(!tmpbuf) {
		DIE();
	}

	/* Ethernett[쐬܂B */
	              memcpy(tmpbuf +  0, address, 6);		/* + 0,     6: ĐEthernetAhX */
	ethernet_get_address(tmpbuf +  6);			/* + 6,     6: MEthernetAhX */
	          PUT_BEHALF(tmpbuf + 12, client->type);	/* +12,     2: t[^Cv */
	              memcpy(tmpbuf + 14, data, length);	/* +14,length: f[^ */

ENTER_CS; /*{{荞ݓA荞݊O̗Ă΂邽߁AhCo\̂̔r䂪Kvł*/

	/* Ethernett[AML[֒ǉ܂B */
	retval = write_queue(driver.txque, tmpbuf, 14/*wb_*/ + length/*f[^*/);
	if(retval >= 0) { /* ǉ */

		/* M~Ȃ... */
		if(!driver.txing) {

			/* oJnAtxing=1(M쒆)ֈڍs܂B */
			driver.txing = ep2_txsub();
			ASSERT(driver.txing);
		}

		/* ̖߂ĺAf[^̂܂ܕԂ܂B */
		retval = length;

	} else { /* ǉs */

		driver.stat.txerr++; /* MI[o[ */
	}

LEAVE_CS; /*}}荞ݓA荞݊O̗Ă΂邽߁AhCo\̂̔r䂪Kvł*/

	/* Ethernett[\zpobt@܂B */
	free(tmpbuf);

	return retval;
}

void
ethernet_set_address(const unsigned char* address/*[6]*/)
{
ENTER_CS;

	/* EthernetAhXω... */
	if(memcmp(address, driver.address, 6) != 0) {

		/* VEthernetAhXi[܂B */
		memcpy(driver.address, address, 6);

		/* NCAg̐ݒύXR[obNցAEthernetAhX̕ωʒm܂B
		 * - EthernetNCAgƂāAARPvgRhCoo^ς݂ŁAAlbg[Nݒ̏Ă΁A
		 *   ȉ̏ŌĂяoAARPvgRhCo̐ݒύXR[obNAGratuitous ARP𑗐M͂łB
		 */
		{
			LIST_ENTRY* list_head = &driver.client_list;	/* Xg̃[gvf */
			LIST_ENTRY* list_entry = list_head->Flink;	/* 擪̗vf(orI[) */
			ETHERNETCLIENT* client;

			while(list_entry != list_head) {
				if(!list_entry) {
					DIE(); /* A܂́ANCAgXgj */
				}
				client = CONTAINING_RECORD(list_entry, ETHERNETCLIENT, list_entry);
				if(client->conf) {
					client->conf(client);
				}
				list_entry = list_entry->Flink;
			}
		}
	}

LEAVE_CS;
}

void
ethernet_get_address(unsigned char* address/*[6]*/)
{
ENTER_CS;

	memcpy(address, driver.address, 6);

LEAVE_CS;
}

void
ethernet_stat(ETHERNETSTAT* stat)
{
ENTER_CS;

	*stat = driver.stat;

LEAVE_CS;
}

