/*
 *	dkscan - J[lT[rX[eBeB[
 *
 *	Copyright (C) 2004 Naoyuki Sawa
 *
 *	* Wed Sep 27 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <zlib.h>

#define VERSION		"20041027"

/* [NOTE]
 * * R}hC̃ChJ[hWJ邽߂ɁA
 *   [vWFNg̐ݒ]->[N]->[IuWFNg/CuW[]
 *   usetargv.objvǉĂ܂B
 *   A{vO͕̓̓t@C󂯕tȂ̂ŁA
 *   ChJ[hWJ̓R}h͂̎ԂȂx̖ړIɉ߂܂B
 */

/****************************************************************************
 *
 ****************************************************************************/

/* G[bZ[W\ďI܂B
 */
void
err(const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	 fprintf(stderr, "### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);

	exit(-1);
}

/****************************************************************************
 *
 ****************************************************************************/

/* g\āAI܂B
 */
void
usage()
{
	//		01234567890123456789012345678901234567890123456789012345678901234567890123456789
	fprintf(stderr,"dkscan - J[lT[rX[eBeB (%s)\n", VERSION);
	fprintf(stderr,"Copyright (C) 2004 Naoyuki Sawa\n");
	fprintf(stderr,"\n");
	fprintf(stderr,"g: dkscan filename[.pex]\n");
	fprintf(stderr,"  filename[.pex] Ώۂ́Apext@Cw肵ĂB\n");
	fprintf(stderr,"                 gq.pex͏ȗ\łB\n");
	fprintf(stderr,"\n");
	fprintf(stderr,"IvV:\n");
	fprintf(stderr,"  -d[dump[.bin]] pexWJC[WAwt@C֏o͂܂B\n");
	fprintf(stderr,"                 t@CwȗƁAfilename.bin֏o͂܂B\n");
	fprintf(stderr,"\n");
	fprintf(stderr,"ʂ̏o͐͏ɕWo͂łBKvɉă_CNgĂB\n");
	exit(-1);
}

/****************************************************************************
 *
 ****************************************************************************/

#define KSVECTORTOP	0x20		/* J[lT[rXe[u̐擪AhX */
#define KSMAX		248		/* J[lT[rXgpxN^̍ő吔 */

const char* kstbl[KSMAX];		/* J[lT[rX̃e[u */

/* J[lT[rX̃e[u܂B
 */
void
init_kstbl()
{
	kstbl[  0] = "pceVectorSetTrap";
	kstbl[  1] = "pceVectorSetKs";
	kstbl[  2] = "pceSystemGetInfo";
	kstbl[  3] = "pceDebugSetMon";

	kstbl[  4] = "pceAppSetProcPeriod";
	kstbl[  5] = "pceAppReqExit";
	kstbl[  6] = "pceAppExecFile";
	kstbl[  7] = "pceAppActiveResponse";

	kstbl[  8] = "pceUSBDisconnect";
	kstbl[  9] = "pceUSBReconnect";
	kstbl[ 10] = "pceUSBSetupMode";

	kstbl[ 12] = "pcePadGetDirect";
	kstbl[ 13] = "pcePadGetProc";
	kstbl[ 14] = "pcePadGet";
	kstbl[ 15] = "pcePadSetTrigMode";

	kstbl[ 16] = "pceLCDDispStart";
	kstbl[ 17] = "pceLCDDispStop";
	kstbl[ 18] = "pceLCDTrans";
	kstbl[ 19] = "pceLCDSetBuffer";
	kstbl[ 20] = "pceLCDSetOrientation";
	kstbl[ 21] = "pceLCDSetBright";
	kstbl[ 22] = "pceLCDTransDirect";
	kstbl[ 23] = "pceLCDTransRange";

	kstbl[ 24] = "pceFontGetAdrs";
	kstbl[ 25] = "pceFontPut";
	kstbl[ 26] = "pceFontSetType";
	kstbl[ 27] = "pceFontSetPos";
	kstbl[ 28] = "pceFontPutStr";
	kstbl[ 29] = "pceFontPrintf";
	kstbl[ 30] = "pceFontSetTxColor";
	kstbl[ 31] = "pceFontSetBkColor";

	kstbl[ 32] = "pcesprintf";
	kstbl[ 33] = "pcevsprintf";
	kstbl[ 34] = "pceCRC32";

	kstbl[ 36] = "pceCPUSetSpeed";

	kstbl[ 40] = "pceWaveCheckBuffs";
	kstbl[ 41] = "pceWaveDataOut";
	kstbl[ 42] = "pceWaveSetChAtt";
	kstbl[ 43] = "pceWaveSetMasterAtt";
	kstbl[ 44] = "pceWaveStop";
	kstbl[ 45] = "pceWaveAbort";

	kstbl[ 48] = "pceTimeSet";
	kstbl[ 49] = "pceTimeGet";
	kstbl[ 50] = "pceTimeSetAlarm";
	kstbl[ 51] = "pceTimeGetAlarm";

	kstbl[ 64] = "pceFlashErase";
	kstbl[ 65] = "pceFlashWrite";

	kstbl[ 68] = "pceTimerSetContextSwitcher";
	kstbl[ 69] = "pceTimerAdjustPrecisionCount";
	kstbl[ 70] = "pceTimerSetCallback";
	kstbl[ 71] = "pceTimerGetCount";

	kstbl[ 72] = "pceFileFindOpen";
	kstbl[ 73] = "pceFileFindNext";
	kstbl[ 74] = "pceFileFindClose";
	kstbl[ 75] = "pceFileLoad";
	kstbl[ 76] = "pceFileOpen";
	kstbl[ 77] = "pceFileReadSct";
	kstbl[ 78] = "pceFileWriteSct";
	kstbl[ 79] = "pceFileClose";

	kstbl[ 80] = "pcePowerSetReport";
	kstbl[ 81] = "pcePowerGetStatus";
	kstbl[ 82] = "pcePowerForceBatt";
	kstbl[ 83] = "pcePowerEnterStandby";

	kstbl[ 88] = "pceIRStartRx";
	kstbl[ 89] = "pceIRStartTx";
	kstbl[ 90] = "pceIRGetStat";
	kstbl[ 91] = "pceIRStop";
	kstbl[ 92] = "pceIRStartRxEx";
	kstbl[ 93] = "pceIRStartTxEx";
	kstbl[ 94] = "pceIRStartRxPulse";
	kstbl[ 95] = "pceIRStartTxPulse";

	kstbl[ 96] = "pceLCDPoint";
	kstbl[ 97] = "pceLCDLine";
	kstbl[ 98] = "pceLCDPaint";
	kstbl[ 99] = "pceLCDSetObject";
	kstbl[100] = "pceLCDDrawObject";

	kstbl[104] = "pceUSBCOMSetup";
	kstbl[105] = "pceUSBCOMStartRx";
	kstbl[106] = "pceUSBCOMStartTx";
	kstbl[107] = "pceUSBCOMStop";
	kstbl[108] = "pceUSBCOMGetStat";

	kstbl[112] = "pceHeapAlloc";
	kstbl[113] = "pceHeapFree";
	kstbl[114] = "pceHeapRealloc";
	kstbl[115] = "pceHeapGetMaxFreeSize";

	kstbl[120] = "pceFileCreate";
	kstbl[121] = "pceFileDelete";
	kstbl[122] = "pceFileSetBufferMode";

	/* 192`223 ͓pT[rX */

	/* TODO: pT[rX͌Ăяo菇Ⴄ̂ŁA2004/10/27݂͌oł܂B */
	kstbl[192] = "pceSyncEnterCriticalSection";
	kstbl[193] = "pceSyncLeaveCriticalSection";
	kstbl[194] = "pceSyncSafetyAddition";
	kstbl[195] = "pceSyncSafetySetIL";
	kstbl[196] = "pceTimerGetPrecisionCount";

	/* 224`247 ̓[Ugp */

	/* ȉ224`235MMCpAPIƂėp 2004/05/02 Add by Madoka */
	kstbl[224] = "mmcAppExecFile";
	kstbl[225] = "mmcExit";
	kstbl[226] = "mmcFileClose";
	kstbl[227] = "mmcFileFindClose";
	kstbl[228] = "mmcFileFindNext";
	kstbl[229] = "mmcFileFindOpen";
	kstbl[230] = "mmcFileOpen";
	kstbl[231] = "mmcFileReadMMCSct";
	kstbl[232] = "mmcFileReadSct";
	kstbl[233] = "mmcGetCIDInfo";
	kstbl[234] = "mmcGetCSDInfo";
	kstbl[235] = "mmcInit";
}

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _pffsFileHEADER {
	unsigned char mark;			/* + 0: }[N */
	unsigned char type;			/* + 1: t@C^Cv */
	unsigned short ofs_data;		/* + 2: f[^ւ̃ItZbg */
	unsigned short ofs_name;		/* + 4: LvVւ̃ItZbg */
	unsigned short ofs_icon;		/* + 6: ACRւ̃ItZbg */
	unsigned long resv2;			/* + 8: \ */
	unsigned long top_adrs;			/* +12: 擪̃AhX */
	unsigned long length;			/* +16:  */
	unsigned long crc32;			/* +20: CRC32 */
} pffsFileHEADER;


#define MAX_PROG_SIZE	(256 * 1024)				/* P/ECEvOőTCY */
unsigned  char  pex[MAX_PROG_SIZE / sizeof(unsigned  char)];	/* pext@Cǂݍ݃obt@ */
unsigned short prog[MAX_PROG_SIZE / sizeof(unsigned short)];	/* pexvOWJobt@ */
int prog_size; /* n[t[hPʂȂAoCgPʂł!! */

void
load_pex(const char* path)
{
	int retval;
	FILE* fp;
	int pex_size;
	pffsFileHEADER* fh;

	/* pext@Cǂݍ݂܂B */
	fp = fopen(path, "rb");
	if(!fp) {
		err("%s: t@CJ܂B", path);
	}
	pex_size = fread(pex, 1, sizeof pex, fp);
	fclose(fp);

	/* pext@C܂B */
	if(pex_size < sizeof(pffsFileHEADER)) {
		err("%s: t@CTCYsłB", path);
	}
	fh = (pffsFileHEADER*)pex;
	fh->ofs_data += 8; /* f[^̐擪ɂ{len,crc}܂Bdl!! */
	fh->length   -= 8; /* f[^̐擪ɂ{len,crc}܂Bdl!! */
	if(fh->mark != 'X') {
		err("%s: }[NsłB", path);
	}
	if(fh->ofs_data > pex_size - 1) {
		err("%s: f[^ւ̃ItZbgsłB", path);
	}
	if(fh->ofs_data + fh->length > (unsigned)pex_size) {
		err("%s: f[^ւ̃ItZbg܂͒słB", path);
	}

	/* pexvOWJ܂B */
	prog_size = sizeof prog;
	retval = uncompress((unsigned char*)prog, &prog_size, &pex[fh->ofs_data], fh->length);
	if(retval != Z_OK) {
		err("%s: WJł܂B", path);
	}
}

/****************************************************************************
 *
 ****************************************************************************/

void
scan_ks()
{
	int i;
	int code;
	int ksno;
	int addr;
	const char* ks;

	printf("---------+------+------------------------------\n");
	printf(" Address | Ksno | Name\n");
	printf("---------+------+------------------------------\n");
	//     " $100000 |  100 | pceTimerAdjustPrecisionCount"
#define FMT    " $%06x | %4d | %s\n"

	for(i = 0; i < (int)(prog_size / sizeof(unsigned short) - 3); i++) {
	//                             ~~~~~~~~~~~~~~~~~~~~~~~~YȂ!!
		/* ext߂ŁAIyh4̔{? */
		code = prog[i];
		if((code & 0xe003) != 0xc000) {
			continue;
		}

		/* J[lT[rXԍ0`KSMAX-1? */
		ksno = ((code & ~0xe003) - 0x20) / 4;
		if(ksno < 0 || ksno > KSMAX - 1) {
			continue;
		}

		/* 㑱R[h 3089:"ld.w %r9,[%r8]", 0689:"jp %r9" ? */
		if(prog[i + 1] != 0x3089) {
			continue;
		}
		if(prog[i + 2] != 0x0689) {
			continue;
		}

		/* J[lT[rX̌ĂяołB */
		addr = 0x100000 + i * 2;
		ks = kstbl[ksno];
		if(!ks) ks = "";
		printf(FMT, addr, ksno, ks);
	}
	printf("---------+------+------------------------------\n");

#undef FMT
}

/****************************************************************************
 *
 ****************************************************************************/

int dump; /* -dIvVw 0:/1:L */

char pex_path[_MAX_PATH];
char bin_path[_MAX_PATH];

char drive[_MAX_DRIVE];
char dir[_MAX_DIR];
char fname[_MAX_FNAME];
char ext[_MAX_EXT];

int
main(int argc, char* argv[])
{
	int retval;
	int i;
	FILE* fp;

	/* J[lT[rX̃e[u܂B */
	init_kstbl();

	/* R}hCIvV͂܂B */
	for(i = 1; i < argc; i++) {
		if(argv[i][0] != '-') break;
		switch(argv[i][1]) {
		case 'd':
			if(dump) usage(); /* dw */
			dump = 1;
			strncpy(bin_path, &argv[i][2], sizeof bin_path - 1);
			break;
		default: /* sȃR}hCIvV */
			usage();
		}
	}

	/* pex,bint@C쐬܂B */
	if(i != argc - 1) usage(); /* t@Cw肪s */
	strncpy(pex_path, argv[i], sizeof pex_path - 1);
	_splitpath(pex_path, drive, dir, fname, ext);
	if(!*ext) strcpy(ext, "pex");
	_makepath(pex_path, drive, dir, fname, ext);
	printf("scan: %s\n", pex_path);
	if(dump) {
		if(!*bin_path) { /* _vt@Cw薳 */
			strncpy(bin_path, pex_path, sizeof bin_path);
			_splitpath(bin_path, drive, dir, fname, ext);
			strcpy(ext, "bin"); /* ŊgqύX */
			_makepath(bin_path, drive, dir, fname, ext);
		} else { /* _vt@CwL */
			_splitpath(bin_path, drive, dir, fname, ext);
			if(!*ext) strcpy(ext, "bin");
			_makepath(bin_path, drive, dir, fname, ext);
		}
		printf("dump: %s\n", bin_path);
	}

	/* pext@Cǂݍ݂܂B */
	load_pex(pex_path);

	/* pexWJC[W_vo͂܂B */
	if(dump) {
		fp = fopen(bin_path, "wb");
		if(!fp) {
			err("%s: t@C쐬ł܂B", bin_path);
		}
		retval = fwrite(prog, 1, prog_size, fp);
		if(retval != prog_size) {
			err("%s: t@C݃G[łB", bin_path);
		}
		fclose(fp);
	}

	/* J[lT[rXĂяo܂B */
	scan_ks();

	return 0;
}

