/*
 *	sds.h
 *
 *	Simple Dynamic Strings library for C (SDS)
 *
 *	* Fri Sep 18 21:22:35 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- uSimple Dynamic Strings library for Cv(https://github.com/antirez/sds)݊W[łB
 *	  ֐dlSDSƓŁA͓ƎłB
 *	  IWiłSDS͑x\dĎĂ悤łA͏ȃD悵ĒPɎ܂B
 *	- ֐dlgṕAIWiłSDS̃hLgQƂĂB
 *	  IWiłSDS verison 2A/clip/tool/sds-master.7zɕۑĂ܂B
 *	- e֐̃RǵAIWiłSDS̃Rĝ܂܎cĒ܂B
 *	  A̓Ƃ́AKvĂȂɒӂĂB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __SDS_H__
#define __SDS_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
//==============================================================================
//	
//==============================================================================
typedef char* sds;
//==============================================================================
//	
//==============================================================================
size_t sdslen(sds s);
//size_t sdsavail(sds s);
//void sdssetlen(sds s, size_t newlen);
//void sdsinclen(sds s, size_t inc);
//size_t sdsalloc(sds s);
//void sdssetalloc(sds s, size_t newlen);
sds sdsnewlen(const void* init, size_t initlen);
sds sdsnew(const char* init);
sds sdsempty();
sds sdsdup(sds s);
void sdsfree(sds s);
//sds sdsgrowzero(sds s, size_t len);
sds sdscatlen(sds s, const void* t, size_t len);				//GAXZ[tłB(s=t)łvłB
sds sdscat(sds s, const char* t);						//GAXZ[tłB(s=t)łvłB
sds sdscatsds(sds s, sds t);							//GAXZ[tłB(s=t)łvłB
sds sdscpylen(sds s, const char* t, size_t len);				//GAXZ[tłB(s=t)łvłB
sds sdscpy(sds s, const char* t);						//GAXZ[tłB(s=t)łvłB
sds sdscatvprintf(sds s, const char* fmt, va_list ap);
sds sdscatprintf(sds s, const char* fmt, ...);
//sds sdscatfmt(sds s, char const* fmt, ...);
sds sdstrim(sds s, const char* cset);
void sdsrange(sds s, int start, int end);					//'end'ʒu̕܂ގɒӂB
void sdsupdatelen(sds s);
void sdsclear(sds s);
int sdscmp(sds s1, sds s2);
sds* sdssplitlen(const char* s, int len, const char* sep, int seplen, int* count);
void sdsfreesplitres(sds* tokens, int count);
void sdstolower(sds s);
void sdstoupper(sds s);
sds sdsfromlonglong(int64_t value);
sds sdscatrepr(sds s, const char* p, size_t len);				//GAXZ[tłB(s=p)łvłB
//sds* sdssplitargs(const char* line, int* argc);
sds sdsmapchars(sds s, const char* from, const char* to, size_t setlen);
sds sdsjoin(char** argv, int argc, const char* sep);
sds sdsjoinsds(sds* argv, int argc, const char* sep, size_t seplen);
//==============================================================================
//	Low level functions exposed to the user API
//==============================================================================
sds sdsMakeRoomFor(sds s, size_t addlen);
void sdsIncrLen(sds s, int incr);
sds sdsRemoveFreeSpace(sds s);
//size_t sdsAllocSize(sds s);
//void* sdsAllocPtr(sds s);
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__SDS_H__
