
    /********************************************************/
    /*                                                      */
    /*                                                      */
    /*         Copyright (C), 1993  SEIKO EPSON Corp.       */
    /*         ALL RIGHTS RESERVED                          */
    /*                                                      */
    /*                                                      */
    /*  file name : stdio.h                                 */
    /*                                                      */
    /*  Revision history                                    */
    /*      93/12/17    first release       S.Akaiwa        */
    /*      97/3/17	modified	    T.Katahira	    */
    /*			change function declaration	    */
    /*					to the ANSI style   */
    /*      14/3/10     modify for P/ECE    Naoyuki Sawa    */
    /*                - P/ECEŕsvȕ폜܂B   */
    /*                - sscanf̐錾C܂B        */
    /*                - getchargetc}N܂B   */
    /*                - putcharputc}N܂B   */
    /*      14/8/7      modify for P/ECE    Naoyuki Sawa    */
    /*                - fcloseall̐錾ǉ܂B     */
    /*      14/10/2   - snprintf(),vsnprintf()̐錾clippce.hinclude/stdio.hֈڂ܂B*/
    /*                - scprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B         */
    /*      14/10/23  - vscanf(),vsscanf(),vfscanf()ǉ܂Bclipscan.cɂ܂B */
    /*      14/11/11  - getline(),getdelim()ǉ܂Bgetline.cɂ܂B */
    /*      15/01/07  - fileno(),isatty()̐錾Aclippce.hinclude/stdio.hֈړ܂Bclipio.cɂ܂B                                  */
    /*                  isatty()͖{io.hunistd.hŐ錾ׂȂ̂łAP/ECEɂio.hunistd.ĥinclude/stdio.hŐ錾邱Ƃɂ܂B */
    /*      15/01/20  - size_t̒`unsigned^ɓꂵ܂B */
    /*      15/03/11  - truncate(),ftruncate()ǉ܂Bclipio.cɗL܂B                                             */
    /*                  {unistd.hŐ錾ׂȂ̂łP/ECEɂunistd.ĥőinclude/stdio.hŐ錾鎖ɂ܂B */
    /*      15/11/18  - 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB */
    /*      15/11/24  - STDIN_FILENO,STDOUT_FILENO,STDERR_FILENO̒`,y,isatty(),truncate(),ftruncate()̐錾Astdio.hunistd.hֈړ܂B */
    /*      16/03/19  - /clip/include/sys/types.h(/clip/clipstdw.h)ssize_t̒`ǉɔA܂ssize_t̑intgĂ𐳎ssize_tɏC܂B             */
    /*                  2016/03/19_intssize_tɏCӏ́Agetline(),getdelim(),mq_receive()łB                                                                                   */
    /*                - {́Assize_t̒`/clip/include/sys/types.h(/clip/clipstdw.h)ōŝłA~ނ𓾂ȂRɂ/clip/include/stdio.hł`鎖ɂ܂B */
    /*                  ~ނ𓾂ȂRƂ́A/clip/liblua/lobject.c<sys/types.h>CN[hstdio.hCN[hĂAssize_t̒`Ossize_tgpĂ܂łB        */
    /*                  ̖邽߂ɁAstdio.hCN[hꂽ_ssize_t`Ȃ΁Astdio.hłssize_t`悤ɂ܂B                                          */
    /*                  ssize_t`ǂ𔻒f@́Asize_t_SIZE_T}NgĔfĂ̂ƓlɁA_SSIZE_T}NgĔf悤ɂ܂B                      */
    /*                  Ȃ݂ɁÂ悤ȖړIɎg}NƂẮA'_SSIZE_T''HAVE_SSIZE_T'̗VL悤łA͑O҂̗Vɕ키ɂ܂B                                */
    /*                  ŔAEPSONCuO҂̗Vł悤ł鎖ƁAssize_tǉ鎞ɎQƂSolaris2.8p̃CN[ht@C(?)O҂̗V̂悤łB   */
    /*                  ҂̗VgĂI[v\[X̃\tg悤ŁAƌ(͗)ɂI[v\[X̃\tggɐۂ₷m܂B  */
    /*      16/05/28  - snprintf(),vsnprintf()̈cnť^intsize_tɏC܂B */
    /*                  ڍׂ́Aclipprnt.c̓̃RgQƂĉB             */
    /*                                                      */
    /********************************************************/
                                        
#ifndef _STDIO_H
#define _STDIO_H

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

#ifndef _SIZE_T
#define _SIZE_T
//{{2015/01/20ύX:size_t̒`unsigned^ɓꂵ܂B
//typedef unsigned long   size_t;         /* size of type */
//2015/01/20ύX:size_t̒`unsigned^ɓꂵ܂B
// * Tue Jan 20 23:26:57 JST 2015 Naoyuki Sawa
// - P/ECEJłsize_tunsignedBunsigned longł͂ȂB
//   1:
//   typedef unsigned size_t;
//   extern void* memcpy(void*,const void*,size_t);  xRpCo
//   2:~
//   typedef unsigned long size_t;
//   extern void* memcpy(void*,const void*,size_t);  warning:conflicting types for built-in function `memcpy'
//   P/ECEJ̕WCN[ht@CԈĂ̂ŗvӂłB
//   stddef.hł̒`͐ǁAstdio.h,stdlib.h,string.h,time.hł̒`͊ԈĂ܂B
//   ܂stddef.hŏɃCN[hƑvȂ̂łB
// - ǂ̃wb_t@CŏɃCN[hĂvȂ悤ɁA`𓝈ꂷ邱Ƃɂ܂B
//   P/ECEvOȂ΁Astddef.hŏɃCN[h悤ɂł̂łA
//   I[v\[X̃CuύXRpCɁAstddef.hȊOŏɂȂĂꍇ邩łB
//   ̓Iɂ́A/clip/liblua/RpCƂɌxoāA̖ɋCt܂B
typedef unsigned size_t;
//}}2015/01/20ύX:size_t̒`unsigned^ɓꂵ܂B
#endif

// * Sat Mar 19 21:19:21 JST 2016 Naoyuki Sawa
// - {́Assize_t̒`/clip/include/sys/types.h(/clip/clipstdw.h)ōŝłA~ނ𓾂ȂRɂ/clip/include/stdio.hł`鎖ɂ܂B
//   ~ނ𓾂ȂRƂ́A/clip/liblua/lobject.c<sys/types.h>CN[hstdio.hCN[hĂAssize_t̒`Ossize_tgpĂ܂łB
//   ̖邽߂ɁAstdio.hCN[hꂽ_ssize_t`Ȃ΁Astdio.hłssize_t`悤ɂ܂B
//   ssize_t`ǂ𔻒f@́Asize_t_SIZE_T}NgĔfĂ̂ƓlɁA_SSIZE_T}NgĔf悤ɂ܂B
//   Ȃ݂ɁÂ悤ȖړIɎg}NƂẮA'_SSIZE_T''HAVE_SSIZE_T'̗VL悤łA͑O҂̗Vɕ키ɂ܂B
//   ŔAEPSONCuO҂̗Vł悤ł鎖ƁAssize_tǉ鎞ɎQƂSolaris2.8p̃CN[ht@C(?)O҂̗V̂悤łB
//   ҂̗VgĂI[v\[X̃\tg悤ŁAƌ(͗)ɂI[v\[X̃\tggɐۂ₷m܂B
#ifndef _SSIZE_T
#define _SSIZE_T
typedef int ssize_t;			/* size of something in bytes or -1 */
#endif//_SSIZE_T

typedef long            fpos_t;         /* file type size */


typedef struct  {                       /* FILE structure */
        short           _flg;           /* unget exist flag */
        unsigned char   _buf;           /* unget character */
        int             _fd;            /* file descriptor */  
} FILE;

#if !defined(NULL)
#  define NULL          ((void *)0L)    /* null pointer */
#endif

#define EOF             (-1)            /* eof flag */

#define BUFSIZ          1024

#define SEEK_SET        0               /* seek from beginning */
#define SEEK_CUR        1               /* seek from here */
#define SEEK_END        2               /* seek from end */

#define _NFILE          3
#define FOPEN_MAX       _NFILE

#define FILENAME_MAX    0

#ifdef  UNIX
#define L_tmpnam        25 
#else
#define L_tmpnam        0
#endif

#define TMP_MAX         0

#define _IOFBF          0000            /* fully buffered io */
#define _IOLBF          0000            /* line buffered */
#define _IONBF          0000            /* unbuffered */

extern  FILE            _iob[FOPEN_MAX + 1];

extern	FILE			*stdin;			/* standard input stream */
extern	FILE			*stdout;		/* standard output stream */
extern	FILE			*stderr;		/* standard error stream */

#ifdef va_start
#define _VA_LIST va_list
#else
#define _VA_LIST char *
#endif

/* prototype definition */

extern  FILE    *tmpfile( void );
extern  char    *tmpnam( char * );
extern  int     remove( const char * );
extern  int     rename( const char *, const char * );
extern  FILE    *fopen( const char *, const char * );
extern  FILE    *freopen( const char *, const char *, FILE * );
extern  int     fclose( FILE * );
extern  int     fcloseall( void );				// 2014.08.07 N.SAWA ǉ

extern  void    setbuf( FILE *, char * );
extern  int     setvbuf( FILE *, char *, int, size_t );
extern  int     fflush( FILE * );

extern  void    clearerr( FILE * );
extern  int     feof( FILE * );
extern  int     ferror( FILE * );
extern  void    perror( const char * );

extern  int     fseek( FILE *, long, int );
extern  int     fgetpos( FILE *, fpos_t * );
extern  int     fsetpos(  FILE *, const fpos_t * );
extern  long    ftell( FILE * );
extern  void    rewind( FILE * );

#define getchar() getc(stdin)					// 2014.03.10 N.SAWA ύXB}N܂B
extern  int     fgetc( FILE * );
#define getc(s)  fgetc(s)					// 2014.03.10 N.SAWA ύXB}N܂B

extern  char    *gets( char * );
extern  char    *fgets( char *, int, FILE * );

//#if defined(UNIX) && !defined(ANSI)				// 2014.03.10 N.SAWA 폜
//extern  int     scanf( /* va_alist */ );			// 2014.03.10 N.SAWA 폜
//extern  int     fscanf( /* va_alilst */ );			// 2014.03.10 N.SAWA 폜
//extern  int     sscanf( /* va_alilst */ );			// 2014.03.10 N.SAWA 폜
//#else								// 2014.03.10 N.SAWA 폜
extern  int     scanf( const char *, ... );
extern  int     fscanf( FILE *, const char *, ... );
extern  int     sscanf( const char *, const char *, ... );	// 2014.03.10 N.SAWA ύXBconstĂ̂ŏCB
//#endif							// 2014.03.10 N.SAWA 폜

extern  size_t  fread( void *, size_t, size_t, FILE * );

#define putchar(c) putc((c),stdout)				// 2014.03.10 N.SAWA ύXB}N܂B
extern  int     fputc( int, FILE * );
#define putc(c,s) fputc((c),(s))				// 2014.03.10 N.SAWA ύXB}N܂B

extern  int     puts( const char * );
extern  int     fputs( const char *, FILE * );

extern  int     ungetc( int, FILE * );

//#if defined(UNIX) && !defined(ANSI)				// 2014.03.10 N.SAWA 폜
//extern  int     printf( /* char *, ... */ );			// 2014.03.10 N.SAWA 폜
//extern  int     fprintf( /* FILE *, char *, ... */ );		// 2014.03.10 N.SAWA 폜
//extern  int     sprintf( /* char *, char *, ... */ );		// 2014.03.10 N.SAWA 폜
//extern  int     vprintf( /* char *, va_list */ );		// 2014.03.10 N.SAWA 폜
//extern  int     vfprintf( /* FILE *, char *, va_list */ );	// 2014.03.10 N.SAWA 폜
//extern  int     vsprintf( /* char *, char *, va_list */ );	// 2014.03.10 N.SAWA 폜
//#else								// 2014.03.10 N.SAWA 폜
extern  int     printf( const char *, ...  );
extern  int     fprintf( FILE *, const char *, ... );
extern  int     sprintf( char *, const char *, ... );
extern  int     vprintf( const char *, _VA_LIST );
extern  int     vfprintf( FILE *, const char *, _VA_LIST );
extern  int     vsprintf( char *, const char *, _VA_LIST );
//#endif							// 2014.03.10 N.SAWA 폜

extern  size_t  fwrite( const void *, size_t, size_t, FILE * );

//{{2016/05/28ύX:snprintf(),vsnprintf()̈cnť^intsize_tɏC܂Bڍׂ́Aclipprnt.c̓̃RgQƂĉB
////{{2014/10/02ǉ:snprintf(),vsnprintf()̐錾clippce.hinclude/stdio.hֈڂ܂B
//int snprintf(char* out, int cnt, const char* fmt, ...);
//int vsnprintf(char* out, int cnt, const char* fmt, _VA_LIST ap);		//EPSONCũIWistdio.h̎@ɕāA錾va_listłȂ_VA_LISTgpBstdarg.hCN[hstdio.hCN[hɁAG[ɂȂ邱Ƃ邽߂łB
////}}2014/10/02ǉ:snprintf(),vsnprintf()̐錾clippce.hinclude/stdio.hֈڂ܂B
//2016/05/28ύX:snprintf(),vsnprintf()̈cnť^intsize_tɏC܂Bڍׂ́Aclipprnt.c̓̃RgQƂĉB
int snprintf(char* out, size_t cnt, const char* fmt, ...);
int vsnprintf(char* out, size_t cnt, const char* fmt, _VA_LIST ap);		//EPSONCũIWistdio.h̎@ɕāA錾va_listłȂ_VA_LISTgpBstdarg.hCN[hstdio.hCN[hɁAG[ɂȂ邱Ƃ邽߂łB
//}}2016/05/28ύX:snprintf(),vsnprintf()̈cnť^intsize_tɏC܂Bڍׂ́Aclipprnt.c̓̃RgQƂĉB

//{{2014/10/02ǉ:scprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B
int scprintf(const char* fmt, ...);
int vscprintf(const char* fmt, _VA_LIST ap);					//EPSONCũIWistdio.h̎@ɕāA錾va_listłȂ_VA_LISTgpBstdarg.hCN[hstdio.hCN[hɁAG[ɂȂ邱Ƃ邽߂łB
int asprintf(char** strp, const char* fmt, ...);
int vasprintf(char** strp, const char* fmt, _VA_LIST ap);			//EPSONCũIWistdio.h̎@ɕāA錾va_listłȂ_VA_LISTgpBstdarg.hCN[hstdio.hCN[hɁAG[ɂȂ邱Ƃ邽߂łB
//}}2014/10/02ǉ:scprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B

//{{2014/10/23ǉ:vscanf(),vsscanf(),vfscanf()ǉ܂Bclipscan.cɂ܂B
int vscanf(const char* fmt, _VA_LIST ap);					//EPSONCũIWistdio.h̎@ɕāA錾va_listłȂ_VA_LISTgpBstdarg.hCN[hstdio.hCN[hɁAG[ɂȂ邱Ƃ邽߂łB
int vsscanf(const char* str, const char* fmt, _VA_LIST ap);			//EPSONCũIWistdio.h̎@ɕāA錾va_listłȂ_VA_LISTgpBstdarg.hCN[hstdio.hCN[hɁAG[ɂȂ邱Ƃ邽߂łB
int vfscanf(FILE* stream, const char* fmt, _VA_LIST ap);			//EPSONCũIWistdio.h̎@ɕāA錾va_listłȂ_VA_LISTgpBstdarg.hCN[hstdio.hCN[hɁAG[ɂȂ邱Ƃ邽߂łB
//}}2014/10/23ǉ:vscanf(),vsscanf(),vfscanf()ǉ܂Bclipscan.cɂ܂B

//{{2014/11/11ǉ:getline(),getdelim()ǉ܂Bgetline.cɂ܂B
ssize_t getline(char** lineptr, size_t* n, FILE* stream);
ssize_t getdelim(char** lineptr, size_t* n, int delim, FILE* stream);
//}}2014/11/11ǉ:getline(),getdelim()ǉ܂Bgetline.cɂ܂B

//{{2015/01/07ǉ:fileno(),isatty()̐錾Aclippce.hinclude/stdio.hֈړ܂Bclipio.cɂ܂Bisatty()͖{io.hunistd.hŐ錾ׂȂ̂łAP/ECEɂio.hunistd.ĥinclude/stdio.hŐ錾邱Ƃɂ܂B
//{{2015/11/24폜:STDIN_FILENO,STDOUT_FILENO,STDERR_FILENO̒`,y,isatty(),truncate(),ftruncate()̐錾Astdio.hunistd.hֈړ܂B
//#define STDIN_FILENO  0 /* W͂̃t@CLqq */
//#define STDOUT_FILENO 1 /* Wo͂̃t@CLqq */
//#define STDERR_FILENO 2 /* WG[o͂̃t@CLqq */
//}}2015/11/24폜:STDIN_FILENO,STDOUT_FILENO,STDERR_FILENO̒`,y,isatty(),truncate(),ftruncate()̐錾Astdio.hunistd.hֈړ܂B
/* w肳ꂽXg[́At@CLqqԂ܂Bw肳ꂽXg[ALȃXg[łȂ΁A-1 Ԃ܂B */
int fileno(FILE* stream); /* -> clipio.c */
//{{2015/11/24폜:STDIN_FILENO,STDOUT_FILENO,STDERR_FILENO̒`,y,isatty(),truncate(),ftruncate()̐錾Astdio.hunistd.hֈړ܂B
///* w肳ꂽt@CLqqA[QƂt@CLqqȂ΁A1 Ԃ܂BłȂ΁A0 Ԃ܂B */
//int isatty(int fd); /* -> clipio.c */
//}}2015/11/24폜:STDIN_FILENO,STDOUT_FILENO,STDERR_FILENO̒`,y,isatty(),truncate(),ftruncate()̐錾Astdio.hunistd.hֈړ܂B
//}}2015/01/07ǉ:fileno(),isatty()̐錾Aclippce.hinclude/stdio.hֈړ܂Bclipio.cɂ܂Bisatty()͖{io.hunistd.hŐ錾ׂȂ̂łAP/ECEɂio.hunistd.ĥinclude/stdio.hŐ錾邱Ƃɂ܂B

//{{2015/11/24폜:STDIN_FILENO,STDOUT_FILENO,STDERR_FILENO̒`,y,isatty(),truncate(),ftruncate()̐錾Astdio.hunistd.hֈړ܂B
////{{2015/03/11ǉ:truncate(),ftruncate()ǉ܂Bclipio.cɗL܂B{unistd.hŐ錾ׂȂ̂łP/ECEɂunistd.ĥőinclude/stdio.hŐ錾鎖ɂ܂B
//int truncate(const char* path, /*off_t*/long length);
//int ftruncate(int fd, /*off_t*/long length);
////}}2015/03/11ǉ:truncate(),ftruncate()ǉ܂Bclipio.cɗL܂B{unistd.hŐ錾ׂȂ̂łP/ECEɂunistd.ĥőinclude/stdio.hŐ錾鎖ɂ܂B
//}}2015/11/24폜:STDIN_FILENO,STDOUT_FILENO,STDERR_FILENO̒`,y,isatty(),truncate(),ftruncate()̐錾Astdio.hunistd.hֈړ܂B

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif _STDIO_H
