/*
 *	ght_hash_table.h
 *
 *	Generic Hash Table (GHT)
 *
 *	* Sat Jun 06 15:36:36 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- ulibghthash - Generic Hash Table (GHT)v(http://www.bth.se/people/ska/sim_home/libghthash.html)݊W[łB
 *	  ֐dllibghthashƓŁA͓ƎłB
 *	  IWiłlibghthash͑x\dĎĂ悤łA͏ȃD悵ĒPɎ܂B
 *	- ֐dlgṕAIWiłlibghthash̃hLgQƂĂB
 *	  IWiłlibghthashA/clip/tool/libghthash.7z ɕۑĂ܂B
 *	* Sun Jul 12 21:50:47 JST 2015 Naoyuki Sawa
 *	- ght_set_rehash(),ght_rehash()Ή܂B
 *	  x\dȂjł̊֐ɂ͑ΉĂ܂łAP邽߂ɑΉ鎖ɂ܂B
 *	  ܂ł́Aght_create()̈ɗLx傫Ȓlw肷KvLAۂ̗vfȂɖʂĂ܂B
 *	  ́A'ght_create(0);ght_set_rehash(p_ht,1)'ŗǂAvf̑ɉĎIɃe[uTCY܂B
 *	* Tue Oct 06 21:24:18 JST 2015 Naoyuki Sawa
 *	- ght_size()܂B
 *	  ܂łRAMߖŗD悵i_sizetB[hێɁAght_size()ďoxle_iteratorHėvf𐔂Ă܂B
 *	  ̕ύXi_sizetB[hǉāAght_size()i_sizeԂɂč܂B
 *	  ͂RAMʂ܂AP/ECȄꍇ̓vORAMɓWĴŁAght_size()̃R[hTCYጸŎRAMʂ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Thu Apr 28 21:03:22 JST 2016 Naoyuki Sawa
 *	- ght_set_bounded_buckets()Ή܂B
 *	- LbVƂĂ̓ɂGg̎폜ŝ́Aght_insert()ĂяoꂽƂdlłB(IWiŃ\[X̓ɏ܂B)
 *	  ght_set_rehash()ĂяoăoPbg̃GgAght_set_bounded_buckets()ĂяoăoPbg~bgƂɂA
 *	  oPbg̃GgoPbg~bg𒴂ƂĂA̎_ł̓Gg̎폜͍s܂B
 *	  Gg̎폜ŝ́Aȍ~ght_insert()ĂяoA̎ɎQƂoPbgoPbg~bg𒴂Ăł鎖ɒӂĉB
 *	- ܂AϓIɗoƎv܂ALbVƂĂ̓ƁAnbV̓́AłB
 *	  oPbg~bg𒴂ăGg̎폜ŝ҂Ă̂ɁȂOɎnbVăoPbgA
 *	  oPbg̃GgA܂ŌoĂGg̎폜sȂ\łB(oPbg~bg̐ݒlɂ܂c)
 *	- ȏ܂Ƃ߂ƁA_ƂĂ:
 *	  LbVƂĎgpꍇ́A]܂菇
 *	  oPbg𖾎ănbVe[u쐬A̒ɃoPbg~bgw肵ăLbVLA
 *	  ȍ~́AoPbg~bg̕ύXAnbV̗LsȂ̂ǂB
 *	  <>
 *	  ght_hash_table_t* p_ht = ght_create(17);
 *	  ght_set_bounded_buckets(p_ht, 8, fnBucketFree);
 *	  //ȍ~Aght_set_bounded_buckets()ght_set_rehash()ĂяoȂB
 *	- ght_set_bounded_buckets()ĂяoăLbVLƁAght_insert()xቺ鎖ɒӂĉB
 *	  Ŝ̃Ggi_sizetB[hɕێĂ܂AoPbg̃Gg͕ێĂȂ̂ŁAoPbg𔻒肷邽߂ɓsx邩łB
 *	  ght_insert()̑xቺhɂ́AoPbgɃGgێ悤ɂΗǂ̂łA͍sȂɂ܂BŔAȉ̒ʂłB
 *	  ER1. oPbg̃Gg͋ɒ[ɑȂƎv̂ŁAsx삵Ăɒ[ɒx͂ȂƎvB
 *	           XnbVe[ugpړÎ߂łA̃oPbgɋɒ[ɑ̃Ggێ̂͌Ił͂ȂA
 *	           ght_set_bounded_buckets()Ɏw肷pPbg~bg̒ĺA1`2炢̌ł͂łB
 *	           ꂮ炢̐Ȃ΁Aght_insert()̓sxĂAقǑ傫Ȗɂ͂ȂȂƎv܂B
 *	           ۂ̂ƂAght_get()qbgȂɑGgƓłAȂɒx͖͂łB
 *	  ER2. ght_insert()̌Ăяopx́AȂƎvB
 *	           ʓIɁAQƂύX̕ȂƎv̂ŁAght_get()ɔׂght_insert()̌Ăяo񐔂͏ȂƎv܂B
 *	           ]āAght_insert()xቺĂAŜւ̉e͏ȂƎv܂B
 *	  ER3. LbVLȂ΁Aght_insert()̑xቺ͋NȂB
 *	           ght_insert()oPbg𑖍̂́Aght_set_bounded_buckets()ĂяoăLbVLꍇłB
 *	           ۂɂ́ALbVLɎg̕Ǝv̂ŁAght_insert()xቺ鎖͏ȂƎv܂B
 *	  ER4. oPbgɃGgێƁAʂĂ܂B
 *	           RȂAoPbgɃGgێƁÂ߂̕ϐKvɂȂA펞ʂ܂B
 *	           R1,2,3̒ʂAght_insert()̑xቺɂe͏Ȃ̂ɁAP邽߂ɏ펞ʂ͖̂ʂƎv܂B
 *	           ALbVLght_insert()xቺ鎖󂯓AǂƎv܂B
 *	  ȏ̗RɂAght_insert()̑xቺh΍͍sȂɂ܂B
 *	  ΂炭gĂ݂āA肪L΍Č悤Ǝv܂A炭̂܂܂Ŗ薳Ǝv܂B
 *	* Sat Apr 30 21:45:42 JST 2016 Naoyuki Sawa
 *	- ght_set_alloc()Ή܂B
 *	* Fri May 06 21:58:10 JST 2016 Naoyuki Sawa
 *	- Ce[Vp̃Xg̒ǉʒuύXȂRɂāAght_insert()ɃRgǋL܂B
 *	  R[hɂ͕ύXL܂B
 *	* Sun Jun 05 21:20:53 JST 2016 Naoyuki Sawa
 *	- ght_first(),ght_first_keysize(),ght_next(),ght_next_keysize()́App_key_dataNULLƂ܂B
 *	  ύXŔAȉ̒ʂłB
 *	- IWiłlibghthashł́Ap_key_sizeNULLłApp_key_dataNULLsłB
 *	  ۂɎgĂ݂ƁA񋓒ɃL[͕svłP[XApp_key_dataw肷邽߂Ƀ_~[ϐpӂȂ΂ȂL܂B
 *	  pp_key_dataNULLƂ́AL̎ԂȂôŁApp_key_dataNULLƂ鎖ɂ܂B
 *	- ̕ύX́AIWiłlibghthashƎdl݊ɂȂĂ܂L̂łAʌ݊狖eėǂƎv܂B
 *	  AIWiłlibghthash̎dlɎKvLꍇ́AAvP[VApp_key_dataNULLw肵Ȃ悤ɒӂΗǂłB
 *	* Sat Oct 01 21:11:57 JST 2016 Naoyuki Sawa
 *	- Hew͗vf[0]̔zɑΉĂȂ̂ŁAvf[1]ƂĒ܂B
 *	  P/ECEJ(GCC)Windows(VC++6.0)́Avf[0]̔zɑΉĂ̂ŁA֌WL܂B
 */
#ifndef __GHT_HASH_TABLE_H__
#define __GHT_HASH_TABLE_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/****************************************************************************
 *	
 ****************************************************************************/
typedef struct s_hash_entry {
	LIST_ENTRY		le_iterator;
	LIST_ENTRY		le_bucket;
	void*			p_entry_data;			//Entry data.
	int			i_key_size;			//The size in bytes of the key.
#ifndef __RENESAS__
	unsigned char		key_data[0/*i_key_size*/];	//Key data.
#else //__RENESAS__
	unsigned char		key_data[1/*i_key_size*/];	//Key data.		//Hew͗vf[0]̔zɑΉĂȂ̂ŁAvf[1]ƂĒ܂B
#endif//__RENESAS__
} ght_hash_entry_t;
/*--------------------------------------------------------------------------*/
typedef struct {
	LIST_ENTRY*		le_next;			//The current entry.		//Ce[^͎̃m[hwĂ̂ŁACe[V̒œYm[hght_remove()ĂSłBgpght_finalize()̎QƂĂB
} ght_iterator_t;
/*--------------------------------------------------------------------------*/
typedef struct {
	struct {
	  unsigned		b_rehash	:1;		//Automatic rehashing status.
	} flag;
	int			i_size;				//The current number of items in the table.
	LIST_ENTRY		le_iterator;
	int			i_table_size;			//The number of buckets.
	LIST_ENTRY*		le_bucket/*[i_table_size]*/;
	int			bucket_limit;			//The maximum number of items in each bucket. If limit is set to 0, bounded buckets are disabled.
	void  (*fn_bucket_free)(void* data, const void* key);	//The function called when a bucket overflows.
	void* (*fn_alloc)(size_t size);				//The function used for allocating entries.		Set the allocation/freeing functions to use for a hash table. The allocation function will only be called when a new entry is inserted. The allocation size will always be sizeof(ght_hash_entry_t) + sizeof(ght_hash_key_t) + key_size. The actual size varies with the key size. If this function is not called, malloc() and free() will be used for allocation and freeing. Always call this function before any entries are inserted into the table. Otherwise, the new free() might be called on something that were allocated with another allocation function.
	void  (*fn_free)(void* ptr);				//The function used for freeing entries.		//                                                                                                                                                                                                    xxxxxxxxxxxxxxxxxxxxxx IWił̐͏L̒ʂłAł'sizeof(ght_hash_key_t)'͗L܂BmۂTCY͏'sizeof(ght_hash_entry_t) + key_size'ƂȂ܂Bkey_sizeŒȂΊmۂTCYŒȂ̂ŁAv[𗘗pămۂo܂B
} ght_hash_table_t;
/****************************************************************************
 *	
 ****************************************************************************/
ght_hash_table_t* ght_create(int i_table_size);
int ght_size(ght_hash_table_t* p_ht);
int ght_table_size(ght_hash_table_t* p_ht);
int ght_insert(ght_hash_table_t* p_ht, void* p_entry_data, int i_key_size, const void* p_key_data);
void* ght_replace(ght_hash_table_t* p_ht, void* p_entry_data, int i_key_size, const void* p_key_data);
void* ght_get(ght_hash_table_t* p_ht, int i_key_size, const void* p_key_data);
void* ght_remove(ght_hash_table_t* p_ht, int i_key_size, const void* p_key_data);
void* ght_first(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data/*NULL*/);
void* ght_first_keysize(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data/*NULL*/, int* p_key_size/*NULL*/);
void* ght_next(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data/*NULL*/);
void* ght_next_keysize(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data/*NULL*/, int* p_key_size/*NULL*/);
void ght_finalize(ght_hash_table_t* p_ht);
void ght_set_rehash(ght_hash_table_t* p_ht, int b_rehash);
void ght_rehash(ght_hash_table_t* p_ht, int i_table_size);
void ght_set_bounded_buckets(ght_hash_table_t* p_ht, int bucket_limit, void (*fn_bucket_free)(void* data, const void* key));
void ght_set_alloc(ght_hash_table_t* p_ht, void* (*fn_alloc)(size_t size), void (*fn_free)(void* ptr));
/*--------------------------------------------------------------------------*/
//Ή̊֐ƁAΉƂŔAȉ̒ʂł:
//Eght_set_hash		One-at-a-Time HashŒŏ[B
//Eght_set_heuristics		x\͏dȂB
//Eght_one_at_a_time_hash	One-at-a-Time HashŒŏ[B
//Eght_rotating_hash		One-at-a-Time HashŒŏ[B
//Eght_crc_hash		One-at-a-Time HashŒŏ[B
//Eght_print			fobO@\KvȒGł͂ȂB
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__GHT_HASH_TABLE_H__
