
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP

		.code
		.align		1
		.global		TrueSpeech_DecodeFrame
TrueSpeech_DecodeFrame:
		pushn		%r3
		;//-------------------------------------------------------------;//
		ld.w		%r0, %r12					;//%r0  := pWorkV
		ld.w		%r1, %r13					;//%r1  := pWorkN
		ld.w		%r2, %r14					;//%r2  := in
		ld.w		%r3, %r15					;//%r3  := out
		;//%r0  := pWorkV
		;//%r1  := pWorkN
		;//%r2  := in
		;//%r3  := out
		;//-------------------------------------------------------------;//
	ext	0x40		; 		xadd		%r12, %r0, 64					;//%r12 := prevfilt
	add	%r12,%r0
	ext	memcpy@rm	; 		xcall.d		memcpy						;//memcpy( prevfilt, cvector, 8 * sizeof(int16_t))	'%r13=pWorkN=cvector'ł
	call.d	memcpy@rl
		ld.w		%r14, 16					;//%r14 :=                    8 * sizeof(int16_t)	*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=              pWorkV
	call.d	TrueSpeech_ReadFrame	; 		xcall.d		TrueSpeech_ReadFrame				;//TrueSpeech_ReadFrame(pWorkV, in);
		ld.w		%r13, %r2					;//%r13 :=                      in			*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=                    pWorkV
	ext	TrueSpeech_CorrelateFilter@rm	; 		xcall.d		TrueSpeech_CorrelateFilter			;//TrueSpeech_CorrelateFilter(pWorkV, pWorkN);
	call.d	TrueSpeech_CorrelateFilter@rl
		ld.w		%r13, %r1					;//%r13 :=                            pWorkN		*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=                 pWorkV
	ext	TrueSpeech_FiltersMerge@rm	; 		xcall.d		TrueSpeech_FiltersMerge				;//TrueSpeech_FiltersMerge(pWorkV, pWorkN);
	call.d	TrueSpeech_FiltersMerge@rl
		ld.w		%r13, %r1					;//%r13 :=                         pWorkN		*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r3					;//%r12 := out
	ext	0x7		; 		xld.w		%r14, 480					;//%r14 :=         240 * sizeof(int16_t)
	ld.w	%r14,0x20
	ext	memset@rm	; 		xcall.d		memset						;//memset( out, 0, 240 * sizeof(int16_t))
	call.d	memset@rl
		ld.w		%r13, 0						;//%r13 :=      0					*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r4, 0						;//%r4  :=         quart = 0
		ld.h		[%r0], %r4					;//pWorkV->quart = quart
TrueSpeech_DecodeFrame_L1:							;//do {
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=                        pWorkV
	ext	TrueSpeech_ApplyTwopointFilter@rm	; 		xcall.d		TrueSpeech_ApplyTwopointFilter			;//TrueSpeech_ApplyTwopointFilter(pWorkV, pWorkN)
	call.d	TrueSpeech_ApplyTwopointFilter@rl
		ld.w		%r13, %r1					;//%r13 :=                                pWorkN	*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=                pWorkV
	ext	TrueSpeech_PlacePulses@rm	; 		xcall.d		TrueSpeech_PlacePulses				;//TrueSpeech_PlacePulses(pWorkV, out)
	call.d	TrueSpeech_PlacePulses@rl
		ld.w		%r13, %r3					;//%r13 :=                        out			*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=                  pWorkV
		ld.w		%r13, %r1					;//%r13 :=                          pWorkN
	ext	TrueSpeech_UpdateFilters@rm	; 		xcall.d		TrueSpeech_UpdateFilters			;//TrueSpeech_UpdateFilters(pWorkV, pWorkN, out)
	call.d	TrueSpeech_UpdateFilters@rl
		ld.w		%r14, %r3					;//%r14 :=                                  out		*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=          pWorkV
	ext	TrueSpeech_Synth@rm	; 		xcall.d		TrueSpeech_Synth				;//TrueSpeech_Synth(pWorkV, out);
	call.d	TrueSpeech_Synth@rl
		ld.w		%r13, %r3					;//%r13 :=                  out				*delay*
		;//-------------------------------------------------------------;//
;//		xadd		%r3, %r3, 120					;//%r3  := out += 60 * sizeof(int16_t)	
		add		%r3, 60						;// 
		ld.h		%r4, [%r0]					;//%r4  :=         quart = pWorkV->quart	
		add		%r4, 1						;//%r4  :=         quart++			
		ld.h		[%r0], %r4					;//pWorkV->quart = quart			
		cmp		%r4, 4						;//} while(quart < 4)				
		jrlt.d		TrueSpeech_DecodeFrame_L1			;//						
		add		%r3, 60						;// 	*delay*
		;//-------------------------------------------------------------;//
		popn		%r3
		ret


		.code
		.align		1
		.global		TrueSpeech_ReadFrame
TrueSpeech_ReadFrame:
		;//-------------------------------------------------------------;//
		;//%r12 := &quart
		;//%r13 := in
		add		%r12, 2						;//%r12 := &flag
		ld.uh		%r4, [%r13]+					;//%r4  :=           t       = *p++
		ld.uh		%r5, [%r13]+					;//%r5  :=                hi = *p++
	sll	%r5,0x8		; 		xsll		%r5, 16						;//%r5  :=                hi <<= 16
	sll	%r5,0x8
		or		%r4, %r5					;//%r4  :=           t |= hi
	ext	0x1		; 		xand		%r5, %r4, 0x00000001				;//%r5  :=       x = t & 0x00000001
	and	%r5,%r4
		ld.h		[%r12]+, %r5					;//flag       =  x
		srl		%r4, 1						;//%r4  :=           t >>= 1
	ext	0x1f		; 		xand		%r5, %r4, 0x0000001F				;//%r5  :=       x = t & 0x0000001F
	and	%r5,%r4
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook0@ah			;//
		ext		TBL_TrueSpeech_Codebook0@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook0[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 5						;//%r4  :=           t >>= 5					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[0]  =  x				@
;//		srl		%r4, 5						;//%r4  :=           t >>= 5			
	ext	0x1f		; 		xand		%r5, %r4, 0x0000001F				;//%r5  :=       x = t & 0x0000001F
	and	%r5,%r4
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook1@ah			;//
		ext		TBL_TrueSpeech_Codebook1@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook1[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 5						;//%r4  :=           t >>= 5					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[1]  =  x				@
;//		srl		%r4, 5						;//%r4  :=           t >>= 5			
	ext	0xf		; 		xand		%r5, %r4, 0x0000000F				;//%r5  :=       x = t & 0x0000000F
	and	%r5,%r4
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook2@ah			;//
		ext		TBL_TrueSpeech_Codebook2@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook2[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 4						;//%r4  :=           t >>= 4					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[2]  =  x				@
;//		srl		%r4, 4						;//%r4  :=           t >>= 4			
	ext	0xf		; 		xand		%r5, %r4, 0x0000000F				;//%r5  :=       x = t & 0x0000000F
	and	%r5,%r4
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook3@ah			;//
		ext		TBL_TrueSpeech_Codebook3@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook3[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 4						;//%r4  :=           t >>= 4					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[3]  =  x				@
;//		srl		%r4, 4						;//%r4  :=           t >>= 4			
	ext	0xf		; 		xand		%r5, %r4, 0x0000000F				;//%r5  :=       x = t & 0x0000000F
	and	%r5,%r4
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook4@ah			;//
		ext		TBL_TrueSpeech_Codebook4@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook4[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 4						;//%r4  :=           t >>= 4					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[4]  =  x				@
;//		srl		%r4, 4						;//%r4  :=           t >>= 4			
	ext	0x7		; 		xand		%r5, %r4, 0x00000007				;//%r5  :=       x = t & 0x00000007
	and	%r5,%r4
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook5@ah			;//
		ext		TBL_TrueSpeech_Codebook5@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook5[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 3						;//%r4  :=           t >>= 3					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[5]  =  x				@
;//		srl		%r4, 3						;//%r4  :=           t >>= 3			
	ext	0x7		; 		xand		%r5, %r4, 0x00000007				;//%r5  :=       x = t & 0x00000007
	and	%r5,%r4
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook6@ah			;//
		ext		TBL_TrueSpeech_Codebook6@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook6[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 3						;//%r4  :=       x = t >>= 3					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[6]  =  x				@
;//		srl		%r4, 3						;//%r4  :=       x = t >>= 3			
		sll		%r4, 1						;//%r4  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook7@ah			;//
		ext		TBL_TrueSpeech_Codebook7@al			;//%r4  :=       x = TBL_TrueSpeech_Codebook7[x]
		ld.h		%r4, [%r4]					;//
		ld.w		%r7, 0						;//%r7  := z = 0						*anti-interlock*
		ld.h		[%r12]+, %r4					;//vector[7]  =  x				@
		;//-------------------------------------------------------------;//						@
		;//%r12 := &offset1[0]												@
		;//%r13 := in													@
		add		%r12, 4						;//%r12 := &offset2[0]				@
		ld.uh		%r6, [%r13]+					;//%r6  :=           t       = *p++		@
		ld.uh		%r5, [%r13]+					;//%r5  :=                hi = *p++		@
	sll	%r5,0x8		; 		xsll		%r5, 16						;//%r5  :=                hi <<= 16		@
	sll	%r5,0x8
		or		%r6, %r5					;//%r6  :=           t |= hi			@
	ext	0x7f		; 		xand		%r5, %r6, 0x0000007F				;//%r5  :=       y = t & 0x0000007F		@
	and	%r5,%r6
		ld.h		[%r12]+, %r5					;//offset2[0]  = y				@
		srl		%r6, 7						;//%r6  :=           t >>= 7			@
	ext	0x7f		; 		xand		%r5, %r6, 0x0000007F				;//%r5  :=       y = t & 0x0000007F		@
	and	%r5,%r6
		ld.h		[%r12]+, %r5					;//offset2[1]  = y				@
		srl		%r6, 7						;//%r6  :=           t >>= 7			@
	ext	0x7f		; 		xand		%r5, %r6, 0x0000007F				;//%r5  :=       y = t & 0x0000007F		@
	and	%r5,%r6
		ld.h		[%r12]+, %r5					;//offset2[2]  = y				@
		srl		%r6, 7						;//%r6  :=           t >>= 7			@
	ext	0x7f		; 		xand		%r5, %r6, 0x0000007F				;//%r5  :=       y = t & 0x0000007F		@
	and	%r5,%r6
		ld.h		[%r12]+, %r5					;//offset2[3]  = y				@
		srl		%r6, 7						;//%r6  :=       y = t >>= 7			@
		;//%r6  := y =  offset1[0][7:4]											@
		;//-------------------------------------------------------------;//						@
		;//%r6  := y =  offset1[0][7:4]											@
		;//%r12 := &pulseval[0]												@
		;//%r13 := in													@
;//		ld.w		%r7, 0						;//%r7  := z = 0				
		ld.w		%r9, 8						;//%r9  := i = (4*2)
TrueSpeech_ReadFrame_L1:							;//do {
		ld.uh		%r4, [%r13]+					;//%r4  :=           t       = *p++
		ld.uh		%r5, [%r13]+					;//%r5  :=                hi = *p++
	sll	%r5,0x8		; 		xsll		%r5, 16						;//%r5  :=                hi <<= 16
	sll	%r5,0x8
		or		%r4, %r5					;//%r4  :=           t |= hi
	ext	0x1		; 		xand		%r5, %r4, 0x00003FFF				;//%r5  :=       x = t & 0x00003FFF
	ext	0x1fff
	and	%r5,%r4
		ld.h		[%r12]+, %r5					;//pulseval[0] = x						pulseval[2]
	srl	%r4,0x8		; 		xsrl		%r4, 14						;//%r4  :=           t >>= 14
	srl	%r4,0x6
	ext	0x1		; 		xand		%r5, %r4, 0x00003FFF				;//%r5  :=       x = t & 0x00003FFF
	ext	0x1fff
	and	%r5,%r4
		ld.h		[%r12]+, %r5					;//pulseval[1] = x						pulseval[3]
	srl	%r4,0x8		; 		xsrl		%r4, 14						;//%r4  :=           t >>= 14
	srl	%r4,0x6
		rr		%r4, %r9					;//%r4  :=           t >>= i
		sub		%r9, 4						;//%r9  := i -= 4
		jrne.d		TrueSpeech_ReadFrame_L1				;//} while(i)
		or		%r7, %r4					;//%r7  := z  |=     t						*delay*
		;//%r7  := z = (offset1[1] rr 8)
		rl		%r7, 8						;//%r7  := z rl= 8
		;//%r7  := z =  offset1[1]
		;//-------------------------------------------------------------;//
		;//%r6  := y =  offset1[0][7:4]
		;//%r7  := z =  offset1[1]
		;//%r12 := &pulseoff[0]
		;//%r13 := in
	ext	0x8		; 		xadd		%r14, %r12, 8					;//%r14 := &pulsepos[0]
	add	%r14,%r12
		ld.w		%r9, 8						;//%r9  := i = 1<<(4-1)						%psr(C)ωȂ߂ɁA[vJE^ɃVtgpB
TrueSpeech_ReadFrame_L2:							;//do {
		ld.uh		%r4, [%r13]+					;//%r4  :=           t       = *p++
		ld.uh		%r5, [%r13]+					;//%r5  :=                hi = *p++
	sll	%r5,0x8		; 		xsll		%r5, 16						;//%r5  :=                hi <<= 16
	sll	%r5,0x8
		or		%r4, %r5					;//%r4  :=           t |= hi
	ext	0xf		; 		xand		%r5, %r4, 0x0000000F				;//%r5  :=       x = t & 0x0000000F
	and	%r5,%r4
		ld.h		[%r12]+, %r5					;//pulseoff[0] = x						pulseoff[1]	pulseoff[2]	pulseoff[3]
		add		%r4, %r4					;//%r4  :=           t <<=  1, %psr(C) = c	
		srl		%r4, 5						;//%r4  :=           t >>= (1+4)		@
		ld.w		[%r14]+, %r4					;//pulsepos[0] =     t				@		pulsepos[1]	pulsepos[2]	pulsepos[3]
		srl		%r9, 1						;//%r9  := i >>= 1				@		%psr(C)ωȂ߂ɁA[vJE^ɃVtgpB
		jrne.d		TrueSpeech_ReadFrame_L2				;//} while(i)					@
		adc		%r6, %r6					;//%r6  := y =  (y << 1) |               c			*delay*
		;//%r6  := y = (offset1[0][7:4] << 4) | offset1[0][0:3]
		mirror		%r9, %r6					;//%r9 :=                             (offset1[0][3:0] << 4)
		srl		%r9, 4						;//%r9 :=                              offset1[0][3:0]
		and		%r6, -16					;//%r6 := y = (offset1[0][7:4] << 4)
		or		%r6, %r9					;//%r6 := y = (offset1[0][7:4] << 4) | offset1[0][3:0]
		;//%r6  := y =  offset1[0]
		;//-------------------------------------------------------------;//
		;//%r6  := y =  offset1[0]
		;//%r7  := z =  offset1[1]
		;//%r12 := &pulsepos[0]
		sub		%r12, 28					;//%r12 := &offset1[0]
		ld.h		[%r12]+, %r6					;//offset1[0] = y
		ld.h		[%r12]+, %r7					;//offset1[1] = z
		;//-------------------------------------------------------------;//
		ret


		.code
		.align		1
		.global		TrueSpeech_CorrelateFilter
TrueSpeech_CorrelateFilter:
		pushn		%r3
	sub	%sp,0x5		; 		xsub		%sp, %sp, 20
		;//-------------------------------------------------------------;//
	ld.w	[%sp+0x4],%r13	; 		xld.w		[%sp+0x10], %r13					;//[%sp+16] := cvector = pWorkN
	ext	0x4		; 		xadd		%r0, %r12, 4					;//%r0      := pvec    = vector
	add	%r0,%r12
		ld.w		%r1, %r13					;//%r1      := pcvec1  = cvector
		ld.w		%r2, 0						;//%r2      := i = 0
		;//%r0      := pvec
		;//%r1      := pcvec1
		;//%r2      := i
		;//[%sp+ 0] := tmpbuf[8]
		;//[%sp+16] := cvector
TrueSpeech_CorrelateFilter_L1:
		ld.h		%r3, [%r0]+					;//%r3  := vec = *pvec++;
		cmp		%r2, 0						;//if(i) {
		jreq		TrueSpeech_CorrelateFilter_L2			;//
		;//-------------------------------------------------------------;//
		ld.w		%r12, %sp					;//%r12 :=               tmpbuf
	ld.w	%r13,[%sp+0x4]	; 		xld.w		%r13, [%sp+0x10]					;//%r13 :=                       cvector
		ld.w		%r14, %r2					;//%r14 :=                                i
	ext	memcpy@rm	; 		xcall.d		memcpy						;//%r10 := ptmp = memcpy(tmpbuf, cvector, i * sizeof(int16_t))
	call.d	memcpy@rl
		sll		%r14, 1						;//%r14 :=                                i * sizeof(int16_t)	*delay*
		sub		%r10, 2						;//%r10 :=        ptmp + (    - 1) * sizeof(int16_t)
		add		%r10, %r2					;//%r10 :=        ptmp + (i/2 - 1) * sizeof(int16_t)
		add		%r10, %r2					;//%r10 := ptmp = ptmp + (i   - 1) * sizeof(int16_t)
	ld.w	%r4,[%sp+0x4]	; 		xld.w		%r4, [%sp+0x10]					;//%r4  := pcvec2 = cvector
		ld.w		%r5, %r2					;//%r5  := j = i
TrueSpeech_CorrelateFilter_L3:							;//
		ld.h		%r6, [%r10]					;//%r6  := *ptmp
		ld.h		%r7, [%r4]					;//%r7  := *pcvec2						*anti-interlock*
		mlt.h		%r6, %r3					;//%alr :=              *ptmp * vec
		ld.w		%r6, %alr					;//%r6  :=              *ptmp * vec
	sra	%r6,0x8		; 		xsra		%r6, 15						;//%r6  :=             (*ptmp * vec) >> 15
	sra	%r6,0x7
		add		%r7, %r6					;//%r7  := *pcvec2 +  ((*ptmp * vec) >> 15)
		ld.h		[%r4]+, %r7					;//%r7  := *pcvec2 += ((*ptmp * vec) >> 15)
		sub		%r5, 1						;//%r5  := j--
		jrne.d		TrueSpeech_CorrelateFilter_L3			;//} while(j)
		sub		%r10, 2						;//%r10 := ptmp--						*delay*
		;//-------------------------------------------------------------;//
TrueSpeech_CorrelateFilter_L2:							;//
		sra		%r3, 3						;//
		not		%r3, %r3					;//%r3  :=     -(vec >> 3)
		add		%r3, 1						;//
		ld.h		[%r1]+, %r3					;//*pcvec1++ = -(vec >> 3)
		cmp		%r2, 7						;//} while(i < (8 - 1))
		jrlt.d		TrueSpeech_CorrelateFilter_L1			;//
		add		%r2, 1						;//%r2  := i++							*delay*
		;//-------------------------------------------------------------;//
	add	%sp,0x5		; 		xadd		%sp, %sp, 20
		popn		%r3
		ret


		.code
		.align		1
		.global		TrueSpeech_FiltersMerge
TrueSpeech_FiltersMerge:
		;//-------------------------------------------------------------;//
		;//%r12 := pWorkV
		;//%r13 := pcvec = cvector = pWorkN
	ext	0x50		; 		xadd		%r4, %r12, 80					;//%r4  := pflt1 = pWorkV->filters[0]
	add	%r4,%r12
	ext	0x10		; 		xadd		%r5, %r4, 16					;//%r5  := pflt2 = pflt1 + 8 * sizeof(int16_t)
	add	%r5,%r4
	ext	0x40		; 		xadd		%r6, %r12, 64					;//%r6  := pprev = pWorkV->prevfilt
	add	%r6,%r12
	ext	0x2		; 		xbtst		[%r12+0x2], 0x0					;//if(flag) {
	btst	[%r12],0x0
		jreq.d		TrueSpeech_FiltersMerge_L2			;//
		ld.w		%r10, 8						;//%r10 := i = 8					*delay*
		;//-------------------------------------------------------------;//
		;//%r4  := pflt1
		;//%r5  := pflt2
		;//%r6  := pprev
		;//%r13 := pcvec
	ext	0x155		; 		xld.w		%r7, 21846					;//%r7  := 21846
	ld.w	%r7,0x16
	ext	0xaa		; 		xld.w		%r9, 10923					;//%r9  := 10923
	ld.w	%r9,0x2b
TrueSpeech_FiltersMerge_L1:							;//do {
		ld.h		%r11, [%r13]+					;//%r11 :=     cvec = *pcvec++
		ld.h		%r12, [%r6]+					;//%r12 :=                    prev = *pprev++
		mlt.h		%r11, %r7					;//%alr :=     cvec * 21846
		ld.w		%r14, %alr					;//%r14 :=     cvec * 21846
		mlt.h		%r12, %r9					;//%alr :=                    prev * 10923
		ld.w		%r15, %alr					;//%r15 :=                    prev * 10923
		add		%r14, %r15					;//%r14 :=    (cvec * 21846 + prev * 10923)
	sra	%r14,0x8	; 		xsra		%r14, 15					;//%r14 :=    (cvec * 21846 + prev * 10923) >> 15
	sra	%r14,0x7
		ld.h		[%r4]+, %r14					;//*pflt1++ = (cvec * 21846 + prev * 10923) >> 15
		mlt.h		%r11, %r9					;//%alr :=     cvec * 10923
		ld.w		%r14, %alr					;//%r14 :=     cvec * 10923
		mlt.h		%r12, %r7					;//%alr :=                    prev * 21846
		ld.w		%r15, %alr					;//%r15 :=                    prev * 21846
		add		%r14, %r15					;//%r14 :=    (cvec * 10923 + prev * 21846)
	sra	%r14,0x8	; 		xsra		%r14, 15					;//%r14 :=    (cvec * 10923 + prev * 21846) >> 15
	sra	%r14,0x7
		ld.h		[%r5]+, %r14					;//*pflt2++ = (cvec * 10923 + prev * 21846) >> 15
		sub		%r10, 1						;//%r10 := i--
		jrne		TrueSpeech_FiltersMerge_L1			;//} while(i)
		jp.d		TrueSpeech_FiltersMerge_L3			;//
		sub		%r13, 16					;//%r13 := pcvec -= 8 * sizeof(int16_t)			*delay*
		;//-------------------------------------------------------------;//} else {
TrueSpeech_FiltersMerge_L2:							;//
		ld.h		%r11, [%r6]+					;//%r11 :=    prev = *pprev++
		ld.h		[%r4]+, %r11					;//*pflt1++ = prev
		ld.h		[%r5]+, %r11					;//*pflt2++ = prev
		sub		%r10, 1						;//%r10 := i--
		jrne		TrueSpeech_FiltersMerge_L2			;//} while(i)
		;//-------------------------------------------------------------;//
TrueSpeech_FiltersMerge_L3:							;//}
		;//%r5  := pflt1 = pflt2
		;//%r13 := pcvec
	ext	0x10		; 		xadd		%r4, %r5, 16					;//%r4  := pflt2 = pflt1 + 8 * sizeof(int16_t)
	add	%r4,%r5
		ld.w		%r10, 8						;//%r10 := i = 8
		;//-------------------------------------------------------------;//
TrueSpeech_FiltersMerge_L4:
		ld.h		%r11, [%r13]+					;//%r11 :=    cvec = *pcvec++
		ld.h		[%r5]+, %r11					;//*pflt1++ = cvec
		ld.h		[%r4]+, %r11					;//*pflt2++ = cvec
		sub		%r10, 1						;//%r10 := i--
		jrne		TrueSpeech_FiltersMerge_L4			;//} while(i)
		;//-------------------------------------------------------------;//
		ret


		.code
		.align		1
		.global		TrueSpeech_ApplyTwopointFilter
TrueSpeech_ApplyTwopointFilter:
		pushn		%r1
	sub	%sp,0x67	; 		xsub		%sp, %sp, 412
		;//-------------------------------------------------------------;//
		;//%r12    := pWorkV
		;//%r13    := pWorkN
		;//[%sp+0] := tmpbuf[60+86+60]
		ld.h		%r4, [%r12]					;//%r4  :=             quart
		ld.w		%r0, %r12					;//%r0  := pWorkV								*anti-interlock*
		sll		%r4, 1						;//%r4  :=             quart * sizeof(int16_t)
		add		%r4, %r12					;//%r4  :=             quart * sizeof(int16_t) + pWorkV
	ext	0x18		; 		xld.h		%r1, [%r4+0x18]					;//%r1  := t = offset2[quart]
	ld.h	%r1,[%r4]
	ext	0x1		; 		xcmp		%r1, 127					;//if(t == 127) {
	cmp	%r1,0x3f
		jrne		TrueSpeech_ApplyTwopointFilter_L1		;//
	ext	0x2		; 		xadd		%r12, %r12, 144					;//%r12 := newvec
	add	%r12,0x10
	ext	0x1		; 		xld.w		%r14, 120					;//%r14 :=            sizeof(int16_t) * 60
	ld.w	%r14,0x38
	ext	memset@rm	; 		xcall.d		memset						;//memset( newvec, 0, sizeof(int16_t) * 60)
	call.d	memset@rl
		ld.w		%r13, 0						;//%r13 :=         0								*delay*
		jp		TrueSpeech_ApplyTwopointFilter_L2		;//
TrueSpeech_ApplyTwopointFilter_L1:						;//}
		;//-------------------------------------------------------------;//
		;//%r0     := pWorkV
		;//%r1     := t
		;//%r13    := pWorkN
		;//[%sp+0] := tmpbuf[60+86+60]
		ld.w		%r12, %sp					;//%r12 :=               tmpbuf
	ext	0x4		; 		xld.w		%r14, 292					;//%r14 :=                                sizeof(int16_t) * (60 + 86)
	ld.w	%r14,0x24
	ext	memcpy@rm	; 		xcall.d		memcpy						;//%r10 := ptr1 = memcpy(tmpbuf, filtbuf, sizeof(int16_t) * (60 + 86))
	call.d	memcpy@rl
		add		%r13, 16					;//%r13 :=                       filtbuf					*delay*
		ld.h		%r7, [%r0]					;//%r7  :=                        quart
	ext	0x124		; 		xadd		%r4, %r10, 292					;//%r4  := ptr1 += (60 + 86)							*anti-interlock*
	add	%r4,%r10
		and		%r7, -2						;//%r7  :=                       (quart >> 1) * sizeof(int16_t)
		add		%r7, %r0					;//%r7  :=                       (quart >> 1) * sizeof(int16_t) + pWorkV
	ext	0x14		; 		xld.h		%r7, [%r7+0x14]					;//%r7  :=                offset1[quart >> 1]
	ld.h	%r7,[%r7]
		ld.w		%r12, %r1					;//%r12 :=                                       t
	ext	__divsi3@rm	; 		xcall.d		__divsi3					;//%r10 :=                                      (t / 25), %ahr = (t % 25)	__divsi3'%r9,%r10,%alr,%ahr,%psr'ȊÕWX^j󂵂ȂB__divsi3ԂA'%ahr'ɏ]
	call.d	__divsi3@rl
		ld.w		%r13, 25					;//%r13 :=                                           25				*delay*
		add		%r7, %r10					;//%r7  :=                offset1[quart >> 1] + (t / 25)
		add		%r7, 19						;//%r7  :=                offset1[quart >> 1] + (t / 25) + (18 + 1)
		sll		%r7, 1						;//%r7  :=               (offset1[quart >> 1] + (t / 25) + (18 + 1)) * sizeof(int16_t)
		ld.w		%r5, %r4					;//%r5  :=        ptr1
		sub		%r5, %r7					;//%r5  := ptr2 = ptr1 - (offset1[quart >> 1] + (t / 25) + (18 + 1))
		ld.w		%r7, %ahr					;//%r7  :=                                      (t % 25)
		sll		%r7, 2						;//%r7  :=                                      (t % 25) * (sizeof TBL_TrueSpeech_Order2Coeffs[0])
		ext		TBL_TrueSpeech_Order2Coeffs+0x0@ah		;//
		ext		TBL_TrueSpeech_Order2Coeffs+0x0@al		;//%r6  := ptr3[0]
		ld.h		%r6, [%r7]					;//
		ext		TBL_TrueSpeech_Order2Coeffs+0x2@ah		;//
		ext		TBL_TrueSpeech_Order2Coeffs+0x2@al		;//%r7  := ptr3[1]
		ld.h		%r7, [%r7]					;//
	ext	0x2		; 		xadd		%r0, %r0, 144					;//%r0  := pnv  = newvec							*anti-interlock*
	add	%r0,0x10
		;//-------------------------------------------------------------;//
		;//%r0  := pnv
		;//%r4  := ptr1
		;//%r5  := ptr2
		;//%r6  := ptr3[0]
		;//%r7  := ptr3[1]
	ext	0x0		; 		xld.w		%r9, 60						;//%r9  := i = 60
	ld.w	%r9,0x3c
		ld.h		%r12, [%r5]+					;//%r12 :=      ptr2[0]
TrueSpeech_ApplyTwopointFilter_L3:						;//do {
		ld.h		%r13, [%r5]+					;//%r13 :=                            ptr2[1]
		mlt.h		%r12, %r6					;//%alr :=     (ptr2[0] * ptr3[0])				Õ[vptr2[1]Ã[vptr2[0]Ɏg񂵂āAANZX팸B
		ld.w		%r14, %alr					;//%r14 :=     (ptr2[0] * ptr3[0])				@ptr1ptr2(18+1)ȏ㗣ĂAptr1ւ݂̏Ã[vptr2ɉe鎖͖B
		mlt.h		%r13, %r7					;//%alr :=                           (ptr2[1] * ptr3[1])	@
		ld.w		%r15, %alr					;//%r15 :=                           (ptr2[1] * ptr3[1])	@
		add		%r14, %r15					;//%r14 := t = (ptr2[0] * ptr3[0]) + (ptr2[1] * ptr3[1])	@
	sra	%r14,0x8	; 		xsra		%r14, 14					;//%r14 := t >>= 14						@
	sra	%r14,0x6
		ld.h		[%r4]+, %r14					;//*ptr1++ = t							@
		ld.h		[%r0]+, %r14					;//*pnv++  = t							@
		sub		%r9, 1						;//%r9  := i--							@
		jrne.d		TrueSpeech_ApplyTwopointFilter_L3		;//} while(i)							@
		ld.w		%r12, %r13					;//%r12 :=      ptr2[0]             = ptr2[1]					*delay*
		;//-------------------------------------------------------------;//
TrueSpeech_ApplyTwopointFilter_L2:
	add	%sp,0x67	; 		xadd		%sp, %sp, 412
		popn		%r1
		ret


		.code
		.align		1
		.global		TrueSpeech_PlacePulses
TrueSpeech_PlacePulses:
	sub	%sp,0x4		; 		xsub		%sp, %sp, 16
		;//-------------------------------------------------------------;//
		ld.h		%r9, [%r12]					;//%r9  :=                 quart
		ld.w		%r7, 7						;//%r7  := i = 7		*anti-interlock*
		sll		%r9, 1						;//%r9  :=                 quart * sizeof(int16_t)						
		add		%r12, %r9					;//%r12 :=        pWorkV + quart * sizeof(int16_t)						
	ext	0x20		; 		xld.h		%r4, [%r12+0x20]					;//%r4  := pval = pulseval[quart]								
	ld.h	%r4,[%r12]
	ext	0x28		; 		xld.h		%r5, [%r12+0x28]					;//%r5  := poff = pulseoff[quart]									*anti-interlock*
	ld.h	%r5,[%r12]
		add		%r12, %r9					;//%r12 :=        pWorkV + quart * sizeof(int32_t)						
	ext	0x30		; 		xld.w		%r12, [%r12+0x30]					;//%r12 := ppos = pulsepos[quart]								
	ld.w	%r12,[%r12]
		;//%r4        := pval = pulseval[quart]																
		;//%r5        := poff = pulseoff[quart]																
		;//%r12       := ppos = pulsepos[quart]																
		;//%r13       := out																		
		;//[%sp+ 0]   := tmpbuf[7]																	
		;//[%sp+14].h := (pfBO)																	
		sll		%r4, 1						;//%r4  := ( pval      * sizeof(int16_t))								*anti-interlock*
		sll		%r5, 3						;//%r5  :=                                  (poff * sizeof TBL_TrueSpeech_PulseScales[0])	
	ld.w	%r6,%sp		; 		xadd		%r6, %sp, 14					;//%r6  := ptmp = &tmpbuf[7]									
	add	%r6,0xe
;//		ld.w		%r7, 7						;//%r7  := i = 7	
TrueSpeech_PlacePulses_L1:							;//do {
	ext	0x6		; 		xand		%r9, %r4, 6					;//%r9  := ((pval & 3) * sizeof(int16_t))
	and	%r9,%r4
		add		%r9, %r5					;//%r9  := ((pval & 3) * sizeof(int16_t)) + (poff * sizeof TBL_TrueSpeech_PulseScales[0])
		ext		TBL_TrueSpeech_PulseScales@ah			;//
		ext		TBL_TrueSpeech_PulseScales@al			;//%r9  := TBL_TrueSpeech_PulseScales[poff][pval & 3]
		ld.h		%r9, [%r9]					;//
		sub		%r6, 2						;//%r6  := ptmp--											*anti-interlock*
		ld.h		[%r6], %r9					;//       *ptmp = TBL_TrueSpeech_PulseScales[poff][pval & 3]
		sub		%r7, 1						;//%r7  := i--
		jrne.d		TrueSpeech_PlacePulses_L1			;//} while(i)
		sra		%r4, 2						;//%r4  := pval >>= 2											*delay*
		;//-------------------------------------------------------------;//
		;//%r6        := ptmp = &tmpbuf[0]
		;//%r12       := ppos = pulsepos[quart]
		;//%r13       := out
		;//[%sp+ 0]   := tmpbuf[7]
		;//[%sp+14].h := (pfBO)
		ld.w		%r14, %r12					;//%r14 :=        ppos = pulsepos[quart]
	sra	%r14,0x8	; 		xsra		%r14, 15					;//%r14 := coef = ppos >> 15
	sra	%r14,0x7
	ext	TBL_TrueSpeech_PulseValues+0x3c@h	; 		xld.w		%r4, TBL_TrueSpeech_PulseValues+0x3c		;//%r4  := ppv  = TBL_TrueSpeech_PulseValues[1]
	ext	TBL_TrueSpeech_PulseValues+0x3c@m
	ld.w	%r4,TBL_TrueSpeech_PulseValues+0x3c@l
		ld.w		%r5, 3						;//%r5  := ntmp = 3
		ld.w		%r7, 30						;//%r7  := i = 30
TrueSpeech_PlacePulses_L2:							;//do {
		ld.h		%r9, [%r4]+					;//%r9  :=         t = *ppv++
		sub		%r14, %r9					;//%r14 := coef -= t
		jrge		TrueSpeech_PlacePulses_L3			;//if(     coef < 0) {
		add		%r14, %r9					;//%r14 := coef += t
		add		%r4, 60						;//%r4  := ppv  += 30 * sizeof(int16_t)
		ld.h		%r9, [%r6]+					;//%r6  := x = *ptmp++
		ld.h		[%r13], %r9					;//*out  = x
		sub		%r5, 1						;//%r5  := ntmp--
		jreq		TrueSpeech_PlacePulses_L4			;//if(    !ntmp) { break }
TrueSpeech_PlacePulses_L3:							;//}
		sub		%r7, 1						;//%r7  := i--
		jrne.d		TrueSpeech_PlacePulses_L2			;//} while(i)
		add		%r13, 2						;//%r13 := out++											*delay*
TrueSpeech_PlacePulses_L4:							;//
		sll		%r7, 1						;//%r7  :=        i * sizeof(int16_t)
		add		%r13, %r7					;//%r7  := out += i
		;//-------------------------------------------------------------;//
		;//%r12       := ppos = pulsepos[quart]
		;//%r13       := out
		;//[%sp+ 0]   := tmpbuf[7]
		;//[%sp+14].h := (pfBO)
	ext	0x1ff		; 		xand		%r12, %r12, 0x7FFF				;//%r12 := coef = ppos & ((1<<15)-1)
	and	%r12,0x3f
	ext	TBL_TrueSpeech_PulseValues+0x0@h	; 		xld.w		%r4, TBL_TrueSpeech_PulseValues			;//%r4  := ppv  = TBL_TrueSpeech_PulseValues[0]
	ext	TBL_TrueSpeech_PulseValues+0x0@m
	ld.w	%r4,TBL_TrueSpeech_PulseValues+0x0@l
	ld.w	%r6,%sp		; 		xadd		%r6, %sp, 6					;//%r6  := ptmp = &tmpbuf[3]
	add	%r6,0x6
		ld.w		%r5, 4						;//%r5  := ntmp = 4
		ld.w		%r7, 30						;//%r7  := i = 30
TrueSpeech_PlacePulses_L5:							;//do {
		ld.h		%r9, [%r4]+					;//%r9  :=         t = *ppv++
		sub		%r12, %r9					;//%r12 := coef -= t
		jrge		TrueSpeech_PlacePulses_L6			;//if(     coef < 0) {
		add		%r12, %r9					;//%r12 := coef += t
		add		%r4, 60						;//%r4  := ppv  += 30 * sizeof(int16_t)
		ld.h		%r9, [%r6]+					;//%r9  := x = *ptmp++
		ld.h		[%r13], %r9					;//*out  = x
		sub		%r5, 1						;//%r5  := ntmp--
		jreq		TrueSpeech_PlacePulses_L7			;//if(    !ntmp) { break }
TrueSpeech_PlacePulses_L6:							;//}
		sub		%r7, 1						;//%r7  := i--
		jrne.d		TrueSpeech_PlacePulses_L5			;//} while(i)
		add		%r13, 2						;//%r13 := out++											*delay*
TrueSpeech_PlacePulses_L7:							;//
		;//-------------------------------------------------------------;//
	add	%sp,0x4		; 		xadd		%sp, %sp, 16
		ret


		.code
		.align		1
		.global		TrueSpeech_UpdateFilters
TrueSpeech_UpdateFilters:
		pushn		%r1
		;//-------------------------------------------------------------;//
		;//%r12 := pWorkV
		;//%r13 := pWorkN
		;//%r14 := out
		ld.w		%r0, %r12					;//%r0  :=  pWorkV
		ld.w		%r1, %r14					;//%r1  :=  out
		ld.w		%r12, %r13					;//%r12 :=  pWorkV
;//		add		%r12, 16					;//%r12 :=               &filtbuf[0]	
	ext	0x2		; 		xadd		%r13, %r13, 136					;//%r13 :=                            &filtbuf[60]				
	add	%r13,0x8
	ext	0x2		; 		xld.w		%r14, 172					;//%r14 :=                                          sizeof(int16_t) * 86	
	ld.w	%r14,0x2c
	ext	memcpy@rm	; 		xcall.d		memcpy						;//%r10 :=  pfb = memcpy(&filtbuf[0], &filtbuf[60], sizeof(int16_t) * 86)	
	call.d	memcpy@rl
		add		%r12, 16					;//%r12 :=               &filtbuf[0]		*delay*
		;//-------------------------------------------------------------;//
		;//%r0  := pWorkV
		;//%r1  := out
		;//%r10 := pfb
	ext	0x2		; 		xadd		%r10, %r10, 172					;//%r10 :=  pfb += 86
	add	%r10,0x2c
	ext	0x2		; 		xadd		%r0, %r0, 144					;//%r0  :=  pnv = &newvec;
	add	%r0,0x10
	ext	0x0		; 		xld.w		%r4, 60						;//%r4  :=  i = 60
	ld.w	%r4,0x3c
TrueSpeech_UpdateFilters_L1:							;//do {
		ld.h		%r5, [%r1]					;//%r5  :=  x = *out
		ld.h		%r6, [%r0]+					;//%r6  :=       y = *pnv++								*anti-interlock*
		add		%r5, %r6					;//%r5  :=  x += y
		ld.h		[%r1]+, %r5					;//*out++ = x
		sra		%r6, 3						;//%r6  :=       y >> 3
		sub		%r5, %r6					;//%r5  :=  x -= y >> 3
		ld.h		[%r10]+, %r5					;//*pfb++ = x
		sub		%r4, 1						;//%r4  :=  i--
		jrne		TrueSpeech_UpdateFilters_L1			;//} while( i)
		;//-------------------------------------------------------------;//
		popn		%r1
		ret


		.code
		.align		1
		.global		TrueSpeech_Synth
TrueSpeech_Synth:
		pushn		%r1
	sub	%sp,0x22	; 		xsub		%sp, %sp, 136
		;//-------------------------------------------------------------;//
		;//%r12 := pWorkV
		;//%r13 := out
		;//%sp  := tmpbuf
		ld.h		%r4, [%r12]					;//%r4  :=                  quart
		sla		%r4, 4						;//%r4  :=                  quart * (sizeof filters[0])
	ext	0x1		; 		xadd		%r12, %r12, 80					;//%r12 :=          filters
	add	%r12,0x10
		add		%r12, %r4					;//%r12 :=          filters[quart]
		ld.w		%r0, %r12					;//%r0  := filter = filters[quart]
		ld.w		%r1, %r13					;//%r1  := out
	ld.w	%r12,%sp	; 		xadd		%r12, %sp, 120					;//%r12 :=               &tmpbuf[60]
	ext	0x1
	add	%r12,0x38
		ld.w		%r13, 0						;//%r13 :=                            0
	ext	memset@rm	; 		xcall.d		memset						;//%r10 := ptmp = memset(&tmpbuf[60], 0, sizeof(int16_t) * 8)
	call.d	memset@rl
		ld.w		%r14, 16					;//%r14 :=                               sizeof(int16_t) * 8	*delay*
		;//-------------------------------------------------------------;//
		;//%r0  := filter
		;//%r1  := out
		;//%r10 := ptmp
	ext	0x0		; 		xld.w		%r4, 60						;//%r4     := i = 60
	ld.w	%r4,0x3c
	ext	0x1ff		; 		xld.w		%r5, 32767					;//%r5     := SHRT_MAX
	ld.w	%r5,0x3f
		not		%r6, %r5					;//%r6     := SHRT_MIN
TrueSpeech_Synth_L1:								;//do {
		ld.w		%alr, %r8					;//%alr    := sum  =  0
		ld.w		%r9, 8						;//%r9     :=             k
		ld.w		%r11, %r0					;//%r11    :=                                                   filter
		mac		%r9						;//%alr    := sum  =  for(k = 0; k < 8; k++) { sum += *ptmp++ * *filter++ }
		sub		%r10, 18					;//%r10    :=                                          ptmp -= (8+1)
		ld.w		%r7, %alr					;//%r7     :=         sum
		ld.h		%r9, [%r1]					;//%r9     :=                      *out
	sra	%r7,0x8		; 		xsra		%r7, 12						;//%r7     :=        (sum >> 12)
	sra	%r7,0x4
		add		%r7, %r9					;//%r7     := sum  = (sum >> 12) + *out
		;//-------------------------------------------------------------;//
		cmp		%r7, %r5					;//%psr    := sum <=> INT16_MAX
		jrle.d		3						;//if(        sum   > INT16_MAX) {
		 cmp		%r7, %r6					;//%psr    := sum <=> INT16_MIN				*delay*
		 ld.w		%r7, %r5					;//  %r7   := sum  =  INT16_MAX  }	@
		jrge.d		3						;//if(        sum <   INT16_MIN) {	
		 sub		%r4, 1						;//%r4     := i--					*delay*
		 ld.w		%r7, %r6					;//  %r7   := sum  =  INT16_MIN  }	@
		ld.h		[%r1]+, %r7					;//*wbuff++ = sum			@
		ld.h		[%r10], %r7					;//*ptmp = sum				@
		jrne		TrueSpeech_Synth_L1				;//} while(   i)			
		;//-------------------------------------------------------------;//
	add	%sp,0x22	; 		xadd		%sp, %sp, 136
		popn		%r1
		ret


		.code
		.align		1
		.global		TrueSpeech_Mix1
TrueSpeech_Mix1:
		pushn		%r3
	sub	%sp,0x45	; 		xsub		%sp, %sp, 276
		;//-------------------------------------------------------------;//
	ext	0x4		; 		xld.w		[%sp+0x108], %r12					;//[%sp+264] := pCh
	ld.w	[%sp+0x8],%r12
	ext	0x4		; 		xld.w		[%sp+0x10c], %r13					;//[%sp+268] := mixbuf
	ld.w	[%sp+0xc],%r13
		ld.w		%r0, [%r12]+					;//%r0       := iLoop
		ld.h		%r4, [%r12]+					;//%r4       := iVol
		ld.uh		%r1, [%r12]+					;//%r1       := nOutLeft
		ld.w		%r2, [%r12]+					;//%r2       := pData
		ld.w		%r3, [%r12]					;//%r3       := nFrame
	ext	0x4		; 		xld.h		[%sp+0x110], %r4					;//[%sp+272] := iVol
	ld.h	[%sp+0x10],%r4
	ext	0x2		; 		xld.w		%r4, 160					;// %r4      := i = 160
	ld.w	%r4,0x20
	ext	0x4		; 		xld.h		[%sp+0x112], %r4					;//[%sp+274] := i = 160
	ld.h	[%sp+0x12],%r4
TrueSpeech_Mix1_L1:								;//do {
		;//-------------------------------------------------------------;//
	ext	0x4		; 		xld.w		%r15, [%sp+0x108]					;//%r15 := pCh
	ld.w	%r15,[%sp+0x8]
		;//%r0         := iLoop
		;//%r1         := nOutLeft
		;//%r2         := pData
		;//%r3         := nFrame
		;//%r15        := pCh
		;//[%sp+  0].w := WorkV
		;//[%sp+264].w := pCh
		;//[%sp+268].w := mixbuf
		;//[%sp+272].h := iVol
		;//[%sp+274].h := i
		cmp		%r1, 0						;//if(!nOutLeft) {
		jrne		TrueSpeech_Mix1_L2				;//
		cmp		%r3, 0						;//if(!nFrame) {
		jrne		TrueSpeech_Mix1_L3				;//
		cmp		%r0, -1						;//%psr(C) :=            (iLoop != -1)
		sbc		%r0, %r8					;//%r0  :=      iLoop -= (iLoop != -1)
		jreq		TrueSpeech_Mix1_L4				;//if(    !iLoop) { break }
	ext	0x10		; 		xld.w		%r2, [%r15+0x10]					;//%r2  := pData  = pInitData
	ld.w	%r2,[%r15]
	ext	0x14		; 		xld.w		%r3, [%r15+0x14]					;//%r3  := nFrame = nInitFrame
	ld.w	%r3,[%r15]
TrueSpeech_Mix1_L3:								;//}
		ld.w		%r12, %sp					;//%r12 :=                &WorkV
	ext	0x1f8		; 		xadd		%r13, %r15, 504					;//%r13 :=                        &WorkN
	add	%r13,%r15
		ld.w		%r14, %r2					;//%r14 :=                                pData
	ext	TrueSpeech_DecodeFrame@rm	; 		xcall.d		TrueSpeech_DecodeFrame				;//TrueSpeech_DecodeFrame(&WorkV, &WorkN, pData, OutBuf)
	call.d	TrueSpeech_DecodeFrame@rl
		add		%r15, 24					;//%r15 :=                                       OutBuf		*delay*
	ext	0x3		; 		xld.w		%r1, 240					;//%r1  := nOutLeft
	ld.w	%r1,0x30
		add		%r2, 32						;//%r2  := pData += (8 * sizeof(uint32_t))
		sub		%r3, 1						;//%r3  := nFrame--
	ext	0x4		; 		xld.w		%r15, [%sp+0x108]					;//%r15 := pCh
	ld.w	%r15,[%sp+0x8]
TrueSpeech_Mix1_L2:								;//}
		;//-------------------------------------------------------------;//
		;//%r0         := iLoop
		;//%r1         := nOutLeft
		;//%r2         := pData
		;//%r3         := nFrame
		;//%r15        := pCh
		;//[%sp+  0].w := WorkV
		;//[%sp+264].w := pCh
		;//[%sp+268].w := mixbuf
		;//[%sp+272].h := iVol
		;//[%sp+274].h := i
		ld.w		%r4, %r1					;//%r4  :=                    n = nOutLeft
	ext	0x1f8		; 		xadd		%r5, %r15, 504					;//%r5  :=     &OutBuf[240                        ]
	add	%r5,%r15
;//		sub		%r5, %r4					;//%r5  :=     &OutBuf[240 - (n / sizeof(int16_t))]	
;//		sub		%r5, %r4					;//%r5  := p = &OutBuf[240 -  n                   ]	
	ext	0x4		; 		xld.h		%r6, [%sp+0x112]					;//%r6  := i						@
	ld.h	%r6,[%sp+0x12]
		sub		%r5, %r4					;//%r5  :=     &OutBuf[240 - (n / sizeof(int16_t))]		*anti-interlock*
		sub		%r6, %r4					;//%r6  := i -= n					@@
		jrge.d		3						;//if(     i < 0) {					@@
		 sub		%r5, %r4					;//%r5  := p = &OutBuf[240 -  n                   ]		*delay*
		 add		%r4, %r6					;//%r4  := n += i }
		sub		%r1, %r4					;//%r1  := nOutLeft -= n
	ext	0x4		; 		xld.w		%r7, [%sp+0x10c]					;//%r7  := mixbuf
	ld.w	%r7,[%sp+0xc]
	ext	0x4		; 		xld.h		%r9, [%sp+0x110]					;//%r9  := iVol
	ld.h	%r9,[%sp+0x10]
TrueSpeech_Mix1_L5:								;//do {
		ld.w		%r12, [%r7]					;//%r12 := x  = *mixbuf
		ld.h		%r13, [%r5]+					;//%r13 :=      y  = *p++
		mlt.h		%r13, %r9					;//%alr :=      y *= iVol
		ld.w		%r13, %alr					;//%r13 :=      y
		add		%r12, %r13					;//%r12 := x += y
		ld.w		[%r7]+, %r12					;//*mixbuf++ = x
		sub		%r4, 1						;//%r4  := n--
		jrne		TrueSpeech_Mix1_L5				;//} while(n)
		;//-------------------------------------------------------------;//
		;//%r0         := iLoop
		;//%r1         := nOutLeft
		;//%r2         := pData
		;//%r3         := nFrame
		;//%r6         := i		ύX
		;//%r7         := mixbuf	ύX
		;//%r15        := pCh
		;//[%sp+  0].w := WorkV
		;//[%sp+264].w := pCh
		;//[%sp+268].w := mixbuf	ύXO
		;//[%sp+272].h := iVol
		;//[%sp+274].h := i		ύXO
	ext	0x4		; 		xld.w		[%sp+0x10c], %r7					;//[%sp+268] := mixbuf
	ld.w	[%sp+0xc],%r7
	ext	0x4		; 		xld.h		[%sp+0x112], %r6					;//[%sp+274] := i
	ld.h	[%sp+0x12],%r6
		cmp		%r6, 0						;//} while(i > 0)
		jrgt		TrueSpeech_Mix1_L1				;//
TrueSpeech_Mix1_L4:								;//
		;//-------------------------------------------------------------;//
		;//%r0         := iLoop
		;//%r1         := nOutLeft
		;//%r2         := pData
		;//%r3         := nFrame
		;//%r15        := pCh
		ld.w		[%r15], %r0					;//pCh->iLoop    = iLoop
		add		%r15, 6						;//%r15 :=   &pCh->nOutLeft
		ld.h		[%r15]+, %r1					;//pCh->nOutLeft = nOutLeft
		ld.w		[%r15]+, %r2					;//pCh->pData    = pData
		ld.w		[%r15], %r3					;//pCh->nFrame   = nFrame
		;//-------------------------------------------------------------;//
	add	%sp,0x45	; 		xadd		%sp, %sp, 276
		popn		%r3
		ret


		.code
		.align		1
		.global		TrueSpeech_Mix2
TrueSpeech_Mix2:
		;//-------------------------------------------------------------;//
		;//%r12 = wbuff
		;//%r13 = mixbuf
	ext	0x2		; 		xld.w		%r4, 160					;//%r4     := i  = 160
	ld.w	%r4,0x20
	ext	0x1ff		; 		xld.w		%r5, 32767					;//%r5     := SHRT_MAX
	ld.w	%r5,0x3f
		not		%r6, %r5					;//%r6     := SHRT_MIN
TrueSpeech_Mix2_L1:								;//do {
		ld.w		%r7, [%r13]+					;//%r7     := x  =  *mixbuf++
		sra		%r7, 8						;//%r7     := x >>= 8
		cmp		%r7, %r5					;//%psr    := x <=> SHRT_MAX
		jrle.d		3						;//if(        x   > SHRT_MAX) {
		 cmp		%r7, %r6					;//%psr    := x <=> SHRT_MIN				*delay*
		 ld.w		%r7, %r5					;//  %r7   := x  =  SHRT_MAX  }		@
		jrge.d		3						;//if(        x <   SHRT_MIN) {		
		 sub		%r4, 1						;//%r4     := i--					*delay*
		 ld.w		%r7, %r6					;//  %r7   := x  =  SHRT_MIN  }		@
		ld.h		[%r12]+, %r7					;//*wbuff++ = x				@
		ld.h		[%r12]+, %r7					;//*wbuff++ = x				@
		jrne		TrueSpeech_Mix2_L1				;//} while(   i)			
		;//-------------------------------------------------------------;//
		ret

