;
;	frams26a.s
;
;	P/ECE Signetics 2650 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Mon Apr 25 20:42:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clips26a.h"
;
;	clips26a.h
;
;	P/ECE Signetics 2650 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Mon Apr 25 20:42:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;

; clips26a.sAframs26a.sɃCN[hĎg܂B

;****************************************************************************
;	S2650\
;****************************************************************************

				; typedef struct _S2650 {
;#define PSL		 0	; 	unsigned char psl;		// + 0, 1: Program Status Lower
			  	; 					//           psl[1]=COM (logical/arith COMpare)
			  	; 					//           psl[3]=WC  (With/without Carry)
			  	; 					//           psl[4]=RS  (Register bank Select)
			  	; 					//           ̑̃rbg͕słB
;#define PSU		 1	; 	unsigned char psu;		// + 1, 1: Program Status Upper
			  	; 					//           psu[5]=II (Interrupt Inhibit)
			  	; 					//           psu[6]=F  (Flag)
			  	; 					//           psu[7]=S  (Sense)
			  	; 					//           ̑̃rbg͕słB
;#define _CC_		 2	; 	unsigned short cc;		// + 2, 2: Condition Code
			  	; 					//           cc=0x0000         Ȃ CC=0 Ӗ܂B
			  	; 					//           cc=0x0001..0x007f Ȃ CC=1 Ӗ܂B
			  	; 					//           cc=0x0080..0x00ff Ȃ CC=2 Ӗ܂B
			  	; 					//           cc=0x0100..0xffff Ȃ CC=3 Ӗ܂B
;#define C		 4	; 	unsigned short c;		// + 4, 2: Carry
			  	; 					//           c[8]=0 Ȃ C=0 Ӗ܂B
			  	; 					//           c[8]=1 Ȃ C=1 Ӗ܂B
			  	; 					//           ̑̃rbg͕słB
;#define OVF		 6	; 	unsigned char ovf;		// + 6, 1: OVerFlow
			  	; 					//           ovf[7]=0 Ȃ OVF=0 Ӗ܂B
			  	; 					//           ovf[7]=1 Ȃ OVF=1 Ӗ܂B
			  	; 					//           ̑̃rbg͕słB
;#define IDC		 7	; 	unsigned char idc;		// + 7, 1: Inter Digit Carry
			  	; 					//           idc[4]=0 Ȃ IDC=0 Ӗ܂B
			  	; 					//           idc[4]=1 Ȃ IDC=1 Ӗ܂B
			  	; 					//           ̑̃rbg͕słB
;#define REG		 8	;  	unsigned char reg[7];		// + 8, 7: REGister stack
;#define SP		15	; 	unsigned char sp;		// +15, 1: Pointer for the return address Stack
			  	; 					//           sp=0..7
;#define RAS		16	;  	unsigned short ras[8];		// +16,16: Return Address Stack
			  	;  					//           ras[*]=0x0000..0x7fff
;#define _IAR_		32	; 	unsigned short iar;		// +32, 2: Instruction Address Register
			  	; 					//           iar=0x0000..0x7fff
				; 	//------------------------------//
;#define FLAGS		34	; 	unsigned char flags;		// +34, 1: ------hi
			  	; 					//           flg[0]=IRQ (#INTREQ[q̏Ԃɑ܂)
			  	; 					//           flg[1]=HALT
;#define VECTOR		35	; 	unsigned char vector;		// +35, 1: 荞݃xN^
			  	; 					//           IRQ=1 ̏ꍇ̂ݗLłB
;#define _CYCLE_		36	; 	int cycle;			// +36, 4: csTCN
;#define SIZEOF_S2650	40	; } S2650;				// =40

;* S2650.flags */
;#define FLAGS_IRQ	0
;#define FLAGS_HALT	1

;* S2650.psu */
;#define PSU_SP0		0
;#define PSU_SP1		1
;#define PSU_SP2		2
;/ Unused		3
;/ Unused		4
;#define PSU_II		5
;#define PSU_F		6
;#define PSU_S		7

;* S2650.psl */
;#define PSL_C		0
;#define PSL_COM		1
;#define PSL_OVF		2
;#define PSL_WC		3
;#define PSL_RS		4
;#define PSL_IDC		5
;#define PSL_CC0		6
;#define PSL_CC1		7

;****************************************************************************
;	WX^蓖
;****************************************************************************

;#define addr	r0	; ݂̖߂AddressModeAAhXێ܂B
			; AddressMode()ݒ肵AAction()QƂ܂B
			; Operation()Ȃ̃[`́AƂĎgpsłB(O)
			; AddressMode𔺂Ȃ߂ɂẮA[NWX^ƂĎgp\łB
;#define data	r1	; {Iɂ́Aėp̃[NWX^łB
			; ReLXgO̊֐ĂяoꍇɁAۑKv̂li[ĂB
			; AddressMode()ꕔ̓֐(*)ւ̈A߂lێ邽߂̃WX^ƂĂgp܂B
			; ((*)2005/05/04݁As2650_set_psu,s2650_set_pslւ̈As2650_get_psu,s2650_get_psl̖߂l)
			; ֐āA"%data=fn(%addr,%data)"`̂̂ƁA"%r10=fn(%r12,%r13)"`̂̂L̂ŁAӂĂB
;#define seq	r2	; ݂̖߂ɑΉs2650seqGg̑|C^łB
			; s2650_run()As2650_run()Operation()AAddressMode()gp܂B
;#define reg	r3	; ݂̖߂RegisterAWX^tB[hւ̃|C^ێ܂B
			; Register()AOperation()AAddressMode()gp܂B
;#define CPU	r4	; S2650\̂̐擪AhXێ܂B
;#define CC	r5	; s2650.cctB[h̒lێ܂B($00/$01..$7F/$80..$FF/$100..$FFFF)
			; %CCWX^ێĂlƁA{2650PSL(CC)̑ΉɂẮAs2650.cctB[h̐QƂĂB
;#define IAR	r6	; s2650.iartB[h̒lێ܂B($0000..$7FFF)
;#define CYCLE	r7	; csTCNێ܂B

;****************************************************************************
;
;****************************************************************************

;* S2650_TRACEV{`ƁAg[Xo͂s܂B */
;/#define S2650_TRACE

;****************************************************************************
;
;****************************************************************************

; ̂߁AS2650\̂RAMɔzu܂B
; RAM֔zu邽߂ɁA.codeZNVƂ܂B
	.code
	.align	2
	.global	s2650
s2650:
	.space	40

;****************************************************************************
;
;****************************************************************************

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

; sReLXg֓܂B
; [in]
;	܂B
; [out]
;	K̃WX^ݒ肵܂B
; [use]
;	K̃WX^ݒ肷邱ƈȊÓASWX^ۑ܂B
; [note]
;	* sReLXgÔ݌Ăяo\łB
;	  ̃[`ĂяoƁAsReLXg֓܂B
;
	.global	s2650_enter
s2650_enter:
	ext	s2650+0x0@h	; 	xld.w	%r4  , s2650
	ext	s2650+0x0@m
	ld.w	%r4,s2650+0x0@l
	ext	0x2		; 	xld.uh	%r5   , [%r4+0x2   ]
	ld.uh	%r5,[%r4]
	ext	0x20		; 	xld.uh	%r6  , [%r4+0x20  ]
	ld.uh	%r6,[%r4]
	ext	0x24		; 	xld.w	%r7, [%r4+0x24]
	ld.w	%r7,[%r4]
	ret

; sReLXg𔲂܂B
; [in]
;	K̃WX^ݒ肳Ă邱ƁB
; [out]
;	܂B
; [use]
;	SWX^ۑ܂B
; [note]
;	* sReLXĝ݌Ăяo\łB
;	  ̃[`ĂяoƁAsReLXg𔲂܂B
;
	.global	s2650_leave
s2650_leave:
	ext	0x2		; 	xld.h	[%r4+0x2   ], %r5
	ld.h	[%r4],%r5
	ext	0x20		; 	xld.h	[%r4+0x20  ], %r6
	ld.h	[%r4],%r6
	ext	0x24		; 	xld.w	[%r4+0x24], %r7
	ld.w	[%r4],%r7
	ret

;****************************************************************************
;	sReLXgO痘p֐
;****************************************************************************

	.global	s2650_run
s2650_run:
	pushn	%r3
	ext	s2650+0x24@ah	; 	xld.w	[s2650+0x24], %r12		; cTCNi[܂BKv!!
	ext	s2650+0x24@al
	ld.w	[%r8],%r12
	call	s2650_enter	; 	xcall	s2650_enter			; sReLXg֓܂B
	;
	ext	0x22		; 	xbtst	[%r4+0x22], 0x1	; HALTȂ΁AcsTCN0ɂāAɃ[v𔲂܂B
	btst	[%r4],0x1
	jreq	2				; (s2650.cycle=0Ŋ֐𔲂邱ƁBK{!!)
	ld.w	%r7, 0			; (skip?)
	;
	jp	s2650_run_LOOP	; 	xjp	s2650_run_LOOP			; sTCN0w肳ꂽꍇ̂߂ɁA܂肩B
s2650_run_DO:
;----------------------------------------------------------------------------
;#ifdef S2650_TRACE
;	; g[XfobOsꍇ́ÃubNLɂĂB
;	; ̍ہAs2650_trace()́AAvP[VɂĒ`ĂB
;	; s2650_trace()́ACuł͒`Ă܂B
;	xcall  s2650_leave
;	xcall  s2650_trace
;	xcall  s2650_enter
;#endif /*S2650_TRACE*/
;----------------------------------------------------------------------------
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10 = OpCode = [IAR++]
	call.d	s2650_read@rl
	ld.w	%r12, %r6			; *delay*
	add	%r6, 1
	sll	%r10,0x4	; 	xsll	%r10, 4				; %seq = &s2650seq[OpCode].cycle
	ext	s2650seq+0x3@ah
	ext	s2650seq+0x3@al
	add	%r2, %r10
	ld.ub	%r9, [%r2]+			; %r9  = TCN
	ld.w	%r10, [%r2]+			; %r10 = ŏ̊֐
	call.d	%r10				; V[PX́Aŏ̊֐Ăт܂B
	sub	%r7, %r9			; csTCN炵܂B(ߎsOɌ炷!!)
s2650_run_LOOP:
	cmp	%r7,0x0		; 	xcmp	%r7, 0			; csTCN0ȉɂȂ܂ŌJԂ܂B
	jrgt	s2650_run_DO	; 	xjrgt	s2650_run_DO
	;
	call	s2650_leave	; 	xcall	s2650_leave			; sReLXg𔲂܂B
	popn	%r3
	ret

;****************************************************************************
;	sReLXg痘p֐
;****************************************************************************

	.global	s2650_get_psu
s2650_get_psu:
	ext	0x1		; 	xld.ub	%r1, [%r4+0x1]		; %data = S|F|II|-|-|  -|  -|  -
	ld.ub	%r1,[%r4]
	ext	0xf		; 	xld.ub	%r9, [%r4+0xf]			; %r9   = 0|0| 0|0|0| SP| SP| SP
	ld.ub	%r9,[%r4]
	ext	0x3		; 	xand	%r1, %r1, 0xe0		; %data = S|F|II|0|0|  0|  0|  0
	and	%r1,0x20
	ret.d
	or	%r1, %r9			; %data = S|F|II|0|0| SP| SP| SP	*delay*

	.global	s2650_set_psu
s2650_set_psu:
	ext	0x1		; 	xld.ub	%r9, [%r4+0x1]			; %r9   = S|-|--|-|-|---|---|---
	ld.ub	%r9,[%r4]
	ext	0x2		; 	xand	%r9, %r9, 0x80			; %r9   = S|0| 0|0|0|  0|  0|  0
	and	%r9,0x0
	ext	0x1ffd		; 	xand	%r1, %r1, -129		; %data = 0|F|II|-|-|SP2|SP1|SP0
	and	%r1,0x3f
	or	%r1, %r9			; %data = S|F|II|-|-|SP2|SP1|SP0
	ext	0x1		; 	xld.b	[%r4+0x1], %r1
	ld.b	[%r4],%r1
	and	%r1,0x7		; 	xand	%r1, %r1, 7			; %data = 0|0| 0|0|0|SP2|SP1|SP0
	ext	0xf		; 	xld.b	[%r4+0xf], %r1
	ld.b	[%r4],%r1
	ret

	.global	s2650_get_psl
s2650_get_psl:
	ld.ub	%r1,[%r4]	; 	xld.ub	%r1, [%r4+0x0]		; %data = ---|---|---|RS|WC|---|COM|-
	and	%r1,0x1a	; 	xand	%r1, %r1, 0x1a		; %data =   0|  0|  0|RS|WC|  0|COM|0
	ext	0x5		; 	xbtst	[%r4+0x5], 0x0
	btst	[%r4],0x0
	jreq	2
	add	%r1, 0x01			; %data =   0|  0|  0|RS|WC|  0|COM|C	(skip?)
	ext	0x6		; 	xbtst	[%r4+0x6], 0x7
	btst	[%r4],0x7
	jreq	2
	add	%r1, 0x04			; %data =   0|  0|  0|RS|WC|OVF|COM|C	(skip?)
	ext	0x7		; 	xbtst	[%r4+0x7], 0x4
	btst	[%r4],0x4
	jreq	2
	add	%r1, 0x20			; %data =   0|  0|IDC|RS|WC|OVF|COM|C	(skip?)
	cmp	%r5,0x0		; 	xcmp	%r5, 0x00
	jreq	s2650_get_psl_EXIT	; 	xjreq	s2650_get_psl_EXIT
	ext	0x1		; 	xadd	%r1, %r1, 0x40		; %data =   0|CC0|IDC|RS|WC|OVF|COM|C
	add	%r1,0x0
	ext	0x2		; 	xcmp	%r5, 0x80
	cmp	%r5,0x0
	jrlt	s2650_get_psl_EXIT	; 	xjrlt	s2650_get_psl_EXIT
	ext	0x1		; 	xadd	%r1, %r1, 0x40		; %data = CC1|  0|IDC|RS|WC|OVF|COM|C
	add	%r1,0x0
	ext	0x4		; 	xcmp	%r5, 0x100
	cmp	%r5,0x0
	jrlt	s2650_get_psl_EXIT	; 	xjrlt	s2650_get_psl_EXIT
	ext	0x1		; 	xadd	%r1, %r1, 0x40		; %data = CC1|CC0|IDC|RS|WC|OVF|COM|C
	add	%r1,0x0
s2650_get_psl_EXIT:
	ret

	.global	s2650_set_psl
s2650_set_psl:
	ld.b	[%r4],%r1	; 	xld.b	[%r4+0x0], %r1		; PSL   =   ---|---|---|RS|WC|---|COM|-
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; C     =   ---|---|---|--|--|---|---|C|-|-|-|-|-|-|-|-
	ld.b	[%r4],%r1
	sll	%r1,0x5		; 	xsll	%r1, 5			; %data =   CC1|CC0|IDC|RS|WC|OVF|COM|C|0|0|0|0|0
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; OVF   =                     OVF|---|-|-|-|-|-|-
	ld.b	[%r4],%r1
	srl	%r1,0x6		; 	xsrl	%r1, 6			; %data = 0|CC1|CC0|IDC|RS|WC|OVF|COM
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; IDC   = -|---|---|IDC|--|--|---|---
	ld.b	[%r4],%r1
	srl	%r1,0x5		; 	xsrl	%r1, 5			; %data = 0_00000000 or 0_00000001 or 0_00000010 or 0_00000011
	sll	%r1, %r1			; %data = 0_00000000 or 0_00000010 or 0_00001000 or 0_00011000
	sll	%r1, 4			; %data = 0_00000000 or 0_00100000 or 0_10000000 or 1_10000000
	ret.d
	ld.w	%r5, %r1			;					*delay*

;****************************************************************************
;	Register
;****************************************************************************

	.global	s2650_R0
s2650_R0:
	ld.w	%r3, %r4
	ret.d
	add	%r3, 0x8			; *delay*

	.global	s2650_R1
s2650_R1:
	btst	[%r4],0x4	; 	xbtst	[%r4+0x0], 0x4
	jreq.d	3
	ld.w	%r3, %r4			; *delay*
	add	%r3, 3				; (skip?)
	ret.d
	add	%r3, 0x9			; *delay*

	.global	s2650_R2
s2650_R2:
	btst	[%r4],0x4	; 	xbtst	[%r4+0x0], 0x4
	jreq.d	3
	ld.w	%r3, %r4			; *delay*
	add	%r3, 3				; (skip?)
	ret.d
	add	%r3, 0xa			; *delay*

	.global	s2650_R3
s2650_R3:
	btst	[%r4],0x4	; 	xbtst	[%r4+0x0], 0x4
	jreq.d	3
	ld.w	%r3, %r4			; *delay*
	add	%r3, 3				; (skip?)
	ret.d
	add	%r3, 0xb			; *delay*

;****************************************************************************
;	Condition
;****************************************************************************

	.global	s2650_EQ
s2650_EQ:
	ret.d
	cmp	%r5, 0x00			; %psr(Z) = 0 or 1		*delay*

	.global	s2650_GT
s2650_GT:
	cmp	%r5,0x1		; 	xcmp	%r5, 0x01
	jrlt	s2650_GT_EXIT	; 	xjrlt	s2650_GT_EXIT			; %psr(Z) = 0
	ext	0x1		; 	xcmp	%r5, 0x7f
	cmp	%r5,0x3f
	jrgt	s2650_GT_EXIT	; 	xjrgt	s2650_GT_EXIT			; %psr(Z) = 0
	cmp	%r5, %r5			; %psr(Z) = 1
s2650_GT_EXIT:
	ret

	.global	s2650_LT
s2650_LT:
	ext	0x2		; 	xcmp	%r5, 0x80
	cmp	%r5,0x0
	jrlt	s2650_LT_EXIT	; 	xjrlt	s2650_LT_EXIT			; %psr(Z) = 0
	ext	0x3		; 	xcmp	%r5, 0xff
	cmp	%r5,0x3f
	jrgt	s2650_LT_EXIT	; 	xjrgt	s2650_LT_EXIT			; %psr(Z) = 0
	cmp	%r5, %r5			; %psr(Z) = 1
s2650_LT_EXIT:
	ret

	.global	s2650_UN
s2650_UN:
	ret.d
	cmp	%r5, %r5			; %psr(Z) = 1			*delay*

	.global	s2650_IR
s2650_IR:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.ub	%r9, [%r3]			; r++
	add	%r9,0x1		; 	xadd	%r9, %r9, 1
	ld.ub	%r9, %r9			; Kv!!
	ld.b	[%r3], %r9
	ret.d
	cmp	%r9, 0				; %psr(Z) = 0 or 1		*delay*

	.global	s2650_DR
s2650_DR:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.ub	%r9, [%r3]			; r--
	sub	%r9,0x1		; 	xsub	%r9, %r9, 1
	ld.ub	%r9, %r9			; Kv!!
	ld.b	[%r3], %r9
	ret.d
	cmp	%r9, 0				; %psr(Z) = 0 or 1		*delay*

	.global	s2650_NR
s2650_NR:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.ub	%r9, [%r3]
	ret.d
	cmp	%r9, 0				; %psr(Z) = 0 or 1		*delay*

;****************************************************************************
;	AddressMode
;****************************************************************************

	.global	s2650_IND
s2650_IND: ;* INDirect addressing */
	;* ̃AhX[h֐Ă΂܂Bdataj󂵂Ȃ悤!! */
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; tmp  = [addr++]<<8
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;						*delay*
	add	%r0, 1
	ld.w	%r12, %r0
	ld.w	%r0, %r10
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; tmp |= [addr  ]
	call.d	s2650_read@rl
	sll	%r0, 8			;						*delay*
	or	%r0, %r10
	ext	0x1ff		; 	xand	%r0, %r0, 0x7fff		; addr = tmp&0x7fff
	and	%r0,0x3f
	ret.d
	sub	%r7, 6			;						*delay*

	.global	s2650_ABB
s2650_ABB: ;* ABsolute addressing for Branch instructions */
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; data  = [IAR++]<<8
	call.d	s2650_read@rl
	ld.w	%r12, %r6			;						*delay*
	add	%r6, 1
	ld.w	%r1, %r10
	sll	%r1,0x8		; 	xsll	%r1, 8
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; data |= [IAR++]
	call.d	s2650_read@rl
	ld.w	%r12, %r6			;						*delay*
	add	%r6, 1
	or	%r1, %r10
	ext	0x3		; 	xand	%r0, %r1, 0x7fff		; addr  = data&7fff
	ext	0x1fff
	and	%r0,%r1
	ext	0x4		; 	xand	%r9, %r1, 0x8000		; if(data&0x8000) s2650_IND()
	ext	0x0
	and	%r9,%r1
	jrne	s2650_IND	; 	xjrne	s2650_IND
	ret

	.global	s2650_AXB
s2650_AXB: ;* Absolute indeXed addressing for Branch instructions */
	call	s2650_ABB	; 	xcall	s2650_ABB			; AddressMode
	call	s2650_R3	; 	xcall	s2650_R3			; Register
	ld.ub	%r10, [%r3]			; %r10 =                      r
	ext	0x3		; 	xand	%r9, %r0, 0x6000		; %r9  =  addr&0x6000
	ext	0x0
	and	%r9,%r0
	add	%r0, %r10			; addr =                 addr+r
	ext	0x7f		; 	xand	%r0, %r0, 0x1fff		; addr =                (addr+r)&0x1fff
	and	%r0,0x3f
	ret.d
	or	%r0, %r9			; addr = (addr&0x6000)|((addr+r)&0x1fff)	*delay*

	.global	s2650_VEC
s2650_VEC: ;* Relative addressing from Zero Page [in] data=vector */
	ld.w	%r0, %r1			; addr =         data
	sla	%r0,0x1		; 	xsla	%r0, 1			; addr =         data<<1
	ld.b	%r0, %r0			; addr =  (char)(data<<1)
	sra	%r0,0x1		; 	xsra	%r0, 1			; addr =  (char)(data<<1)>>1
	ext	0x7f		; 	xand	%r0, %r0, 0x1fff		; addr = ((char)(data<<1)>>1)&0x1fff
	and	%r0,0x3f
	srl	%r1,0x7		; 	xsrl	%r1, 7			; if(data&0x80) s2650_IND()
	jrne	s2650_IND	; 	xjrne	s2650_IND
	ret

	.global	s2650_ZPR
s2650_ZPR: ;* Relative addressing from Zero Page (vectortFb`) */
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; data = [IAR++]
	call.d	s2650_read@rl
	ld.w	%r12, %r6			;						*delay*
	add	%r6, 1
	jp.d	s2650_VEC	; 	xjp.d	s2650_VEC			; s2650_VEC()
	ld.w	%r1, %r10			;						*delay*

	.global	s2650_IMM
s2650_IMM: ;* IMMediate addressing */
	ld.w	%r0, %r6			; addr = IAR++
	ret.d
	add	%r6, 1				;						*delay*

	.global	s2650_REL
s2650_REL: ;* RELative addressing */
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10 = [IAR++]
	call.d	s2650_read@rl
	ld.w	%r12, %r6			;						*delay*
	add	%r6, 1
	ld.w	%r0, %r10			; addr =        %r10
	sla	%r0,0x1		; 	xsla	%r0, 1			; addr =        %r10<<1
	ld.b	%r0, %r0			; addr = (char)(%r10<<1)
	sra	%r0,0x1		; 	xsra	%r0, 1			; addr = (char)(%r10<<1)>>1 = rel
	ext	0x3		; 	xand	%r9, %r6, 0x6000		; %r9  =  IAR&0x6000
	ext	0x0
	and	%r9,%r6
	add	%r0, %r6			; addr =               IAR+rel
	ext	0x7f		; 	xand	%r0, %r0, 0x1fff		; addr =              (IAR+rel)&0x1fff
	and	%r0,0x3f
	;or	%addr, %r9			; addr = (IAR&0x6000)|(IAR+rel)&0x1fff ------------+
	srl	%r10,0x7	; 	xsrl	%r10, 7				; if(%r10 & 0x80) s2650_IND()                      |
	jrne.d	s2650_IND	; 	xjrne.d	s2650_IND			;                                                  V
	 or	%r0, %r9			; addr = (IAR&0x6000)|(IAR+rel)&0x1fff		*delay*
	ret

	.global	s2650_ABS
s2650_ABS: ;* ABSolute addressing for non-branch instructions */
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; data  = [IAR++]<<8
	call.d	s2650_read@rl
	ld.w	%r12, %r6			;						*delay*
	add	%r6, 1
	ld.w	%r1, %r10
	sll	%r1,0x8		; 	xsll	%r1, 8
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; data |= [IAR++]
	call.d	s2650_read@rl
	ld.w	%r12, %r6			;						*delay*
	add	%r6, 1
	or	%r1, %r10
	ext	0x3		; 	xand	%r10, %r6, 0x6000		; %r10 =  IAR&0x6000
	ext	0x0
	and	%r10,%r6
	ext	0x1fff		; 	xand	%r0, %r1, 0x1fff		; addr =               data&0x1fff
	and	%r0,%r1
	;or	%addr, %r10			; addr = (IAR&0x6000)|(data&0x1fff) ---------------+
	ext	0x4		; 	xand	%r9, %r1, 0x8000		; if(data&0x8000) s2650_IND()                      |
	ext	0x0
	and	%r9,%r1
	jreq.d	s2650_ABS_L10	; 	xjreq.d	s2650_ABS_L10			;                                                  V
	 or	%r0, %r10			; addr = (IAR&0x6000)|(data&0x1fff)		*delay*
	call	s2650_IND	; 	xcall	s2650_IND
s2650_ABS_L10:
	ext	0x3		; 	xand	%r9, %r1, 0x6000		; if(data&0x6000) {
	ext	0x0
	and	%r9,%r1
	jreq	s2650_ABS_L20	; 	xjreq	s2650_ABS_L20
	ld.ub	%r10, [%r3]			;   %r10 = r
	ext	0x1		; 	xand	%r9, %r1, 0x2000		;   if(data&0x2000) {
	ext	0x0
	and	%r9,%r1
	jreq	2				;     r++
	add	%r10, 1				;   }						(skip?)
	ext	0x2		; 	xand	%r9, %r1, 0x4000		;   if(data&0x4000) {
	ext	0x0
	and	%r9,%r1
	jreq	2				;     r--
	sub	%r10, 1				;   }						(skip?)
	ld.ub	%r10, %r10			;   Kv!!
	ld.b	[%r3], %r10			;   r = %r10
	ext	0x3		; 	xand	%r9, %r0, 0x6000		;   %r9  =  addr&0x6000
	ext	0x0
	and	%r9,%r0
	add	%r0, %r10			;   addr =                 addr+r
	ext	0x7f		; 	xand	%r0, %r0, 0x1fff		;   addr =                (addr+r)&0x1fff
	and	%r0,0x3f
	;or	%addr, %r9			;   addr = (addr&0x6000)|((addr+r)&0x1fff) --------+
	ext	s2650_R0@rm	; 	xcall.d	s2650_R0			;   Register                                       V
	call.d	s2650_R0@rl
	 or	%r0, %r9			;   addr = (addr&0x6000)|((addr+r)&0x1fff)	*delay*
s2650_ABS_L20:					; }
	ret

;****************************************************************************
;	Operation
;****************************************************************************

	.global	s2650_LODr
s2650_LODr:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.ub	%r5, [%r3]			; CC = r
	ext	0x8		; 	xld.b	[%r4+0x8], %r5		; R0 = CC
	ld.b	[%r4],%r5
	ret

	.global	s2650_LODm
s2650_LODm:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10 = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	ld.b	[%r3], %r10			; r    = %r10
	ret.d
	ld.w	%r5, %r10			; CC   = %r10			*delay*

	.global	s2650_STRr
s2650_STRr:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ext	0x8		; 	xld.ub	%r5, [%r4+0x8]		; CC = R0
	ld.ub	%r5,[%r4]
	ld.b	[%r3], %r5			; r  = CC
	ret

	.global	s2650_STRm
s2650_STRm:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ld.ub	%r13, [%r3]			; [addr] = r
	ext	s2650_write@rm	; 	xjp.d	s2650_write
	jp.d	s2650_write@rl
	ld.w	%r12, %r0			;				*delay*

;*--------------------------------------------------------------------------*/

	.global	s2650_ADD
s2650_ADD:
	btst	[%r4],0x3	; 	xbtst	[%r4+0x0], 0x3		; if(WC) {
	jreq.d	s2650_ADD_L10	; 	xjreq.d	s2650_ADD_L10
	ld.w	%r14, 0				; %r14 = c = 0			*delay*
	ext	0x5		; 	xld.ub	%r14, [%r4+0x5]		;        c = C[8]
	ld.ub	%r14,[%r4]
	and	%r14,0x1	; 	xand	%r14, %r14, 1
s2650_ADD_L10:					; }
	ld.w	%r5, %r12			; CC   = t = a+b+c
	add	%r5, %r13
	add	%r5, %r14
	ext	0x4		; 	xld.h	[%r4+0x4], %r5			; C    = t
	ld.h	[%r4],%r5
	ld.w	%r10, %r12			; %r10 =   a
	xor	%r10, %r13			; %r10 =   a^b
	not	%r10, %r10			; %r10 = ~(a^b)
	ld.w	%r11, %r12			; %r10 =         a
	xor	%r11, %r5			; %r11 =         a^t
	and	%r10, %r11			; %r10 = ~(a^b)&(a^t)
	ext	0x6		; 	xld.b	[%r4+0x6], %r10		; OVF  = ~(a^b)&(a^t)
	ld.b	[%r4],%r10
	and	%r12,0xf	; 	xand	%r12, %r12, 0xf			; %r12 =  a&0xf
	and	%r13,0xf	; 	xand	%r13, %r13, 0xf			; %r12 =          b&0xf
	add	%r12, %r13			; %r12 = (a&0xf)+(b&0xf)
	add	%r12, %r14			; %r12 = (a&0xf)+(b&0xf)+c
	ext	0x7		; 	xld.b	[%r4+0x7], %r12		; IDC  = (a&0xf)+(b&0xf)+c
	ld.b	[%r4],%r12
	ret.d
	ld.ub	%r5, %r5			; CC   = (unsigned char)t	*delay*

	.global	s2650_ADDr
s2650_ADDr:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ext	0x8		; 	xld.ub	%r12, [%r4+0x8]		; ADD(R0, r)
	ld.ub	%r12,[%r4]
	ld.ub	%r13, [%r3]
	call	s2650_ADD	; 	xcall	s2650_ADD
	ext	0x8		; 	xld.b	[%r4+0x8], %r5		; R0 = CC
	ld.b	[%r4],%r5
	ret

	.global	s2650_ADDm
s2650_ADDm:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10 = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	ld.ub	%r12, [%r3]			; ADD(r, [addr])
	call.d	s2650_ADD	; 	xcall.d	s2650_ADD
	ld.w	%r13, %r10			;				*delay*
	ld.b	[%r3], %r5			; r = CC
	ret

	.global	s2650_SUB
s2650_SUB:
	btst	[%r4],0x3	; 	xbtst	[%r4+0x0], 0x3		; if(WC) {
	jreq.d	s2650_SUB_L10	; 	xjreq.d	s2650_SUB_L10
	ld.w	%r14, 0				; %r14 = c = 0			*delay*
	ext	0x5		; 	xld.ub	%r14, [%r4+0x5]		;        c = ~C[8]
	ld.ub	%r14,[%r4]
	not	%r14, %r14
	and	%r14,0x1	; 	xand	%r14, %r14, 1
s2650_SUB_L10:					; }
	ld.w	%r5, %r12			; CC   = t = a-b-c
	sub	%r5, %r13
	sub	%r5, %r14
	not	%r9, %r5			; C    = ~t
	ext	0x4		; 	xld.h	[%r4+0x4], %r9
	ld.h	[%r4],%r9
	ld.w	%r10, %r12			; %r10 =  a
	xor	%r10, %r13			; %r10 =  a^b
	ld.w	%r11, %r12			; %r10 =        a
	xor	%r11, %r5			; %r11 =        a^t
	and	%r10, %r11			; %r10 = (a^b)&(a^t)
	ext	0x6		; 	xld.b	[%r4+0x6], %r10		; OVF  = (a^b)&(a^t)
	ld.b	[%r4],%r10
	and	%r12,0xf	; 	xand	%r12, %r12, 0xf			; %r12 =    a&0xf
	and	%r13,0xf	; 	xand	%r13, %r13, 0xf			; %r12 =            b&0xf
	sub	%r12, %r13			; %r12 =   (a&0xf)-(b&0xf)
	sub	%r12, %r14			; %r12 =   (a&0xf)-(b&0xf)-c
	not	%r12, %r12			; %r12 = ~((a&0xf)-(b&0xf)-c)
	ext	0x7		; 	xld.b	[%r4+0x7], %r12		; IDC  = ~((a&0xf)-(b&0xf)-c)
	ld.b	[%r4],%r12
	ret.d
	ld.ub	%r5, %r5			; CC   = (unsigned char)t	*delay*

	.global	s2650_SUBr
s2650_SUBr:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ext	0x8		; 	xld.ub	%r12, [%r4+0x8]		; SUB(R0, r)
	ld.ub	%r12,[%r4]
	ld.ub	%r13, [%r3]
	call	s2650_SUB	; 	xcall	s2650_SUB
	ext	0x8		; 	xld.b	[%r4+0x8], %r5		; R0 = CC
	ld.b	[%r4],%r5
	ret

	.global	s2650_SUBm
s2650_SUBm:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10 = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	ld.ub	%r12, [%r3]			; SUB(r, [addr])
	call.d	s2650_SUB	; 	xcall.d	s2650_SUB
	ld.w	%r13, %r10			;				*delay*
	ld.b	[%r3], %r5			; r = CC
	ret

	.global	s2650_ANDr
s2650_ANDr:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ext	0x8		; 	xld.ub	%r5, [%r4+0x8]		; CC = R0 & r
	ld.ub	%r5,[%r4]
	ld.ub	%r9, [%r3]
	and	%r5, %r9
	ext	0x8		; 	xld.b	[%r4+0x8], %r5		; R0 = CC
	ld.b	[%r4],%r5
	ret

	.global	s2650_ANDm
s2650_ANDm:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ld.ub	%r5, [%r3]			; CC = r & [addr]
	ext	s2650_read@rm	; 	xcall.d	s2650_read
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	and	%r5, %r10
	ld.b	[%r3], %r5			; r = CC
	ret

	.global	s2650_IORr
s2650_IORr:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ext	0x8		; 	xld.ub	%r5, [%r4+0x8]		; CC = R0 | r
	ld.ub	%r5,[%r4]
	ld.ub	%r9, [%r3]
	or	%r5, %r9
	ext	0x8		; 	xld.b	[%r4+0x8], %r5		; R0 = CC
	ld.b	[%r4],%r5
	ret

	.global	s2650_IORm
s2650_IORm:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ld.ub	%r5, [%r3]			; CC = r | [addr]
	ext	s2650_read@rm	; 	xcall.d	s2650_read
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	or	%r5, %r10
	ld.b	[%r3], %r5			; r = CC
	ret

	.global	s2650_EORr
s2650_EORr:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ext	0x8		; 	xld.ub	%r5, [%r4+0x8]		; CC = R0 ^ r
	ld.ub	%r5,[%r4]
	ld.ub	%r9, [%r3]
	xor	%r5, %r9
	ext	0x8		; 	xld.b	[%r4+0x8], %r5		; R0 = CC
	ld.b	[%r4],%r5
	ret

	.global	s2650_EORm
s2650_EORm:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ld.ub	%r5, [%r3]			; CC = r ^ [addr]
	ext	s2650_read@rm	; 	xcall.d	s2650_read
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	xor	%r5, %r10
	ld.b	[%r3], %r5			; r = CC
	ret

	.global	s2650_COM
s2650_COM:
	btst	[%r4],0x1	; 	xbtst	[%r4+0x0], 0x1		; if(!COM) {
	jrne	s2650_COM_L10	; 	xjrne	s2650_COM_L10
	ld.b	%r12, %r12			;   a = (char)a
	ld.b	%r13, %r13			;   b = (char)b
s2650_COM_L10:					; }
	cmp	%r12, %r13
	jreq.d	s2650_COM_EXIT	; 	xjreq.d	s2650_COM_EXIT			; if(a=b) CC=0x00
	ld.w	%r5, 0				; 				*delay*
	jrgt.d	s2650_COM_EXIT	; 	xjrgt.d	s2650_COM_EXIT			; if(a>b) CC=0x01
	ld.w	%r5, 1				;				*delay*
	sll	%r5,0x7		; 	xsll	%r5, 7				; if(a<b) CC=0x80
s2650_COM_EXIT:
	ret

	.global	s2650_COMr
s2650_COMr:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ext	0x8		; 	xld.ub	%r12, [%r4+0x8]		; COM(R0, r)
	ld.ub	%r12,[%r4]
	ld.ub	%r13, [%r3]
	jp	s2650_COM	; 	xjp	s2650_COM

	.global	s2650_COMm
s2650_COMm:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10 = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	ld.ub	%r12, [%r3]			; COM(r, [addr])
	jp.d	s2650_COM	; 	xjp.d	s2650_COM
	ld.w	%r13, %r10			;				*delay*

	.global	s2650_RRL
s2650_RRL:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.b	%r5, [%r3]			; CC   = r = ssssssss_ssssssss_ssssssss_srrrrrrr
	btst	[%r4],0x3	; 	xbtst	[%r4+0x0], 0x3		; if(WC) {						*anti-interlock*
	ld.w	%r10, %r5			; %r10 = r
	jreq.d	s2650_RRL_L10	; 	xjreq.d	s2650_RRL_L10
	rl	%r5, 1				; CC   = r = ssssssss_ssssssss_ssssssss_rrrrrrrs	*delay*
	ext	0x5		; 	xld.ub	%r9, [%r4+0x5]			;   %r9    = 00000000_00000000_00000000_???????c
	ld.ub	%r9,[%r4]
	and	%r5,0x3e	; 	xand	%r5, %r5, -2			;   CC     = ssssssss_ssssssss_ssssssss_rrrrrrr0
	and	%r9,0x1		; 	xand	%r9, %r9, 1			;   %r9    = 00000000_00000000_00000000_0000000c
	or	%r5, %r9			;   CC     = ssssssss_ssssssss_ssssssss_rrrrrrrc
	ext	0x4		; 	xld.h	[%r4+0x4], %r5			;   C <-------------------------------+   |
	ld.h	[%r4],%r5
	ld.w	%r9, %r5			;                                         ++
	srl	%r9,0x1		; 	xsrl	%r9, 1				;                                          |
	ext	0x7		; 	xld.b	[%r4+0x7], %r9			;   IDC <----------------------------------+
	ld.b	[%r4],%r9
s2650_RRL_L10:					; } else {
	xor	%r10, %r5			; OVF  = (r^RRL(r))[7]
	ext	0x6		; 	xld.b	[%r4+0x6], %r10
	ld.b	[%r4],%r10
	ld.b	[%r3], %r5			; r    = CC
	ret.d
	ld.ub	%r5, %r5			; CC   = (unsigned char)r				*delay*

	.global	s2650_RRR
s2650_RRR:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.ub	%r5, [%r3]			; CC   = r = 00000000_00000000_00000000_rrrrrrrx
	btst	[%r4],0x3	; 	xbtst	[%r4+0x0], 0x3		; if(WC) {						*anti-interlock*
	jreq.d	s2650_RRR_L10	; 	xjreq.d	s2650_RRR_L10
	ld.w	%r10, %r5			; %r10 = r						*delay*
	ext	0x5		; 	xld.ub	%r9, [%r4+0x5]			;   %r9    = 00000000_00000000_00000000_???????c
	ld.ub	%r9,[%r4]
	sll	%r9,0x8		; 	xsll	%r9, 8				;   %r9    = 00000000_00000000_???????c_00000000
	or	%r5, %r9			;   CC     = 00000000_00000000_???????c_rrrrrrrx
	ld.w	%r9, %r5			;                                        |     |
	srl	%r9,0x2		; 	xsrl	%r9, 2				;                                        +-+   |
	ext	0x7		; 	xld.b	[%r4+0x7], %r9			;   IDC <----------------------------------+   |
	ld.b	[%r4],%r9
	ext	0x5		; 	xld.b	[%r4+0x5], %r5			;   C <----------------------------------------+
	ld.b	[%r4],%r5
	;xsrl	%CC, 1				;   CC     = 00000000_00000000_0???????_crrrrrrr --+
	jp	s2650_RRR_L20	; 	xjp	s2650_RRR_L20			;                                                  |
s2650_RRR_L10:					; } else {                                         |
	ld.w	%r9, %r5			;   %r9    = 00000000_00000000_00000000_rrrrrrrx   |
	sll	%r9,0x8		; 	xsll	%r9, 8				;   %r9    = 00000000_00000000_rrrrrrrx_00000000   |
	or	%r5, %r9			;   %CC    = 00000000_00000000_rrrrrrrx_rrrrrrrx   |
s2650_RRR_L20:					; }                                                |
	srl	%r5,0x1		; 	xsrl	%r5, 1				; CC   =     00000000_00000000_0rrrrrrr_xrrrrrrr <-+
	xor	%r10, %r5			; OVF  = (r^RRR(r))[7]
	ext	0x6		; 	xld.b	[%r4+0x6], %r10
	ld.b	[%r4],%r10
	ld.b	[%r3], %r5			; r    = CC
	ret.d
	ld.ub	%r5, %r5			; CC   = (unsigned char)r				*delay*

;*--------------------------------------------------------------------------*/

	.global	s2650_LPSU
s2650_LPSU:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]
	ld.ub	%r1,[%r4]
	ext	s2650_set_psu@rm	; 	xcall	s2650_set_psu
	call	s2650_set_psu@rl
	ext	s2650_check_pending@rm	; 	xjp	s2650_check_pending
	jp	s2650_check_pending@rl

	.global	s2650_LPSL
s2650_LPSL:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]
	ld.ub	%r1,[%r4]
	ext	s2650_set_psl@rm	; 	xjp	s2650_set_psl
	jp	s2650_set_psl@rl

	.global	s2650_SPSU
s2650_SPSU:
	ext	s2650_get_psu@rm	; 	xcall	s2650_get_psu
	call	s2650_get_psu@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1
	ld.b	[%r4],%r1
	ret.d
	ld.w	%r5, %r1

	.global	s2650_SPSL
s2650_SPSL:
	ext	s2650_get_psl@rm	; 	xcall	s2650_get_psl
	call	s2650_get_psl@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1
	ld.b	[%r4],%r1
	ret.d
	ld.w	%r5, %r1

	.global	s2650_PPSU
s2650_PPSU:
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_get_psu@rm	; 	xcall	s2650_get_psu			; data  = PSU
	call	s2650_get_psu@rl
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10  = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	ext	s2650_set_psu@rm	; 	xjp.d	s2650_set_psu			; PSU   = data
	jp.d	s2650_set_psu@rl
	or	%r1, %r10			; data |= %r10			*delay*

	.global	s2650_PPSL
s2650_PPSL:
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_get_psl@rm	; 	xcall	s2650_get_psl			; data  = PSL
	call	s2650_get_psl@rl
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10  = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	ext	s2650_set_psl@rm	; 	xjp.d	s2650_set_psl			; PSL   = data
	jp.d	s2650_set_psl@rl
	or	%r1, %r10			; data |= %r10			*delay*

	.global	s2650_CPSU
s2650_CPSU:
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_get_psu@rm	; 	xcall	s2650_get_psu			; data  = PSU
	call	s2650_get_psu@rl
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10  = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	not	%r10, %r10			; %r10  = ~%r10
	ext	s2650_set_psu@rm	; 	xcall.d	s2650_set_psu			; PSU   = data
	call.d	s2650_set_psu@rl
	and	%r1, %r10			; data &= %r10			*delay*
	ext	s2650_check_pending@rm	; 	xjp	s2650_check_pending
	jp	s2650_check_pending@rl

	.global	s2650_CPSL
s2650_CPSL:
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_get_psl@rm	; 	xcall	s2650_get_psl			; data  = PSL
	call	s2650_get_psl@rl
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10  = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	not	%r10, %r10			; %r10  = ~%r10
	ext	s2650_set_psl@rm	; 	xjp.d	s2650_set_psl			; PSL   = data
	jp.d	s2650_set_psl@rl
	and	%r1, %r10			; data &= %r10			*delay*

	.global	s2650_TEST
s2650_TEST:
	;* Cs2650_TEST̃RgQƂĂ */
	and	%r12, %r13			; CC = (unsigned char)(((a&b)-b)>>8)
	sub	%r12, %r13
	srl	%r12,0x8	; 	xsrl	%r12, 8
	ret.d
	ld.ub	%r5, %r12			;				*delay*

	.global	s2650_TPSU
s2650_TPSU:
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_get_psu@rm	; 	xcall	s2650_get_psu			; data  = PSU
	call	s2650_get_psu@rl
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10  = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	ld.w	%r12, %r1			; TEST(PSU, [addr])
	jp.d	s2650_TEST	; 	xjp.d	s2650_TEST
	ld.w	%r13, %r10			;				*delay*

	.global	s2650_TPSL
s2650_TPSL:
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_get_psl@rm	; 	xcall	s2650_get_psl			; data  = PSL
	call	s2650_get_psl@rl
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10  = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	ld.w	%r12, %r1			; TEST(PSL, [addr])
	jp.d	s2650_TEST	; 	xjp.d	s2650_TEST
	ld.w	%r13, %r10			;				*delay*

;*--------------------------------------------------------------------------*/

	.global	s2650_BRR
s2650_BRR:
	ext	s2650_REL@rm	; 	xcall	s2650_REL			; AddressMode
	call	s2650_REL@rl
	ret.d
	ld.w	%r6, %r0			;				*delay*

	.global	s2650_BRA
s2650_BRA:
	ext	s2650_ABB@rm	; 	xcall	s2650_ABB			; AddressMode
	call	s2650_ABB@rl
	ret.d
	ld.w	%r6, %r0			;				*delay*

	.global	s2650_BRReq
s2650_BRReq:
	ld.w	%r9, [%r2]+			; Condition
	call	%r9
	jreq	s2650_BRR	; 	xjreq	s2650_BRR
	ret.d
	add	%r6, 1				; IAR += 1			*delay*

	.global	s2650_BRAeq
s2650_BRAeq:
	ld.w	%r9, [%r2]+			; Condition
	call	%r9
	jreq	s2650_BRA	; 	xjreq	s2650_BRA
	ret.d
	add	%r6, 2				; IAR += 2			*delay*

	.global	s2650_BRRne
s2650_BRRne:
	ld.w	%r9, [%r2]+			; Condition
	call	%r9
	jrne	s2650_BRR	; 	xjrne	s2650_BRR
	ret.d
	add	%r6, 1				; IAR += 1			*delay*

	.global	s2650_BRAne
s2650_BRAne:
	ld.w	%r9, [%r2]+			; Condition
	call	%r9
	jrne	s2650_BRA	; 	xjrne	s2650_BRA
	ret.d
	add	%r6, 2				; IAR += 2			*delay*

	.global	s2650_ZBRR
s2650_ZBRR:
	ext	s2650_ZPR@rm	; 	xcall	s2650_ZPR			; AddressMode
	call	s2650_ZPR@rl
	ret.d
	ld.w	%r6, %r0

	.global	s2650_BXA
s2650_BXA:
	ext	s2650_AXB@rm	; 	xcall	s2650_AXB			; AddressMode
	call	s2650_AXB@rl
	ret.d
	ld.w	%r6, %r0

;*--------------------------------------------------------------------------*/

	.global	s2650_BS
s2650_BS:
	ext	0xf		; 	xld.ub	%r9, [%r4+0xf]			; SP = (SP+1)&7
	ld.ub	%r9,[%r4]
	add	%r9,0x1		; 	xadd	%r9, %r9, 1
	and	%r9,0x7		; 	xand	%r9, %r9, 7
	ext	0xf		; 	xld.b	[%r4+0xf], %r9
	ld.b	[%r4],%r9
	sll	%r9,0x1		; 	xsll	%r9, 1				; RAS[SP] = IAR
	ext	s2650+0x10@ah
	ext	s2650+0x10@al
	ld.h	[%r9], %r6
	ret.d
	ld.w	%r6, %r0			; IAR = addr			*delay*

	.global	s2650_BSR
s2650_BSR:
	ext	s2650_REL@rm	; 	xcall	s2650_REL			; AddressMode
	call	s2650_REL@rl
	jp	s2650_BS	; 	xjp	s2650_BS

	.global	s2650_BSA
s2650_BSA:
	ext	s2650_ABB@rm	; 	xcall	s2650_ABB			; AddressMode
	call	s2650_ABB@rl
	jp	s2650_BS	; 	xjp	s2650_BS

	.global	s2650_BSReq
s2650_BSReq:
	ld.w	%r9, [%r2]+			; Condition
	call	%r9
	jreq	s2650_BSR	; 	xjreq	s2650_BSR
	ret.d
	add	%r6, 1				; IAR += 1			*delay*

	.global	s2650_BSAeq
s2650_BSAeq:
	ld.w	%r9, [%r2]+			; Condition
	call	%r9
	jreq	s2650_BSA	; 	xjreq	s2650_BSA
	ret.d
	add	%r6, 2				; IAR += 2			*delay*

	.global	s2650_BSRne
s2650_BSRne:
	ld.w	%r9, [%r2]+			; Condition
	call	%r9
	jrne	s2650_BSR	; 	xjrne	s2650_BSR
	ret.d
	add	%r6, 1				; IAR += 1			*delay*

	.global	s2650_BSAne
s2650_BSAne:
	ld.w	%r9, [%r2]+			; Condition
	call	%r9
	jrne	s2650_BSA	; 	xjrne	s2650_BSA
	ret.d
	add	%r6, 2				; IAR += 2			*delay*

	.global	s2650_ZBSR
s2650_ZBSR:
	ext	s2650_ZPR@rm	; 	xcall	s2650_ZPR			; AddressMode
	call	s2650_ZPR@rl
	jp	s2650_BS	; 	xjp	s2650_BS

	.global	s2650_BSXA
s2650_BSXA:
	ext	s2650_AXB@rm	; 	xcall	s2650_AXB			; AddressMode
	call	s2650_AXB@rl
	jp	s2650_BS	; 	xjp	s2650_BS

;*--------------------------------------------------------------------------*/

	.global	s2650_RET
s2650_RET:
	ext	0xf		; 	xld.ub	%r9, [%r4+0xf]			; IAR = RAS[SP]
	ld.ub	%r9,[%r4]
	sll	%r9,0x1		; 	xsll	%r9, 1
	ext	s2650+0x10@ah
	ext	s2650+0x10@al
	ld.uh	%r6, [%r9]
	srl	%r9,0x1		; 	xsrl	%r9, 1
	sub	%r9,0x1		; 	xsub	%r9, %r9, 1			; SP = (SP-1)&7
	and	%r9,0x7		; 	xand	%r9, %r9, 7
	ext	0xf		; 	xld.b	[%r4+0xf], %r9
	ld.b	[%r4],%r9
	ret

	.global	s2650_RETC
s2650_RETC:
	ld.w	%r9, [%r2]+			; Condition
	call	%r9
	jreq	s2650_RET	; 	xjreq	s2650_RET
	ret

;*--------------------------------------------------------------------------*/

	.global	s2650_TMI
s2650_TMI:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; %r10 = [addr]
	call.d	s2650_read@rl
	ld.w	%r12, %r0			;				*delay*
	ld.ub	%r12, [%r3]			; TEST(r, [addr])
	ext	s2650_TEST@rm	; 	xjp.d	s2650_TEST
	jp.d	s2650_TEST@rl
	ld.w	%r13, %r10			;				*delay*

;****************************************************************************
;
;****************************************************************************
