;
;	framppua.s
;
;	P/ECE PPU (RICOH RP2C02) Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun Jan 30 21:25:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;	* Tue Feb 22 06:43:00 JST 2005 Naoyuki Sawa
;	- ppu_draw_chr̃RgԈĂ̂C܂B
;	  vOɂ͕ω܂B
;
;#include "clipppua.h"
;/
;/	framppua.h
;/
;/	P/ECE PPU (RICOH RP2C02) Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2005 Naoyuki Sawa
;/
;/	* Sun Jan 30 21:25:00 JST 2005 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define PPU_ASM
;#ifdef PPU_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	PPU\
;
;#define PPU_CONTROL1	 0	; + 0, 1
;#define PPU_CONTROL2	 1	; + 1, 1
;#define PPU_STATUS	 2	; + 2, 1
;#define SPRRAM_ADDRESS	 3	; + 3, 1
;#define VRAM_ADDRESS1	 4	; + 4, 2
;#define VRAM_ADDRESS2	 6	; + 6, 2
;#define FLAGS		 8	; + 8, 1
;#define VRAM_BUFFER	 9	; + 9, 1
;#define SCAN_START	10	; +10, 1
;#define SCAN_END	11	; +11, 1
;#define VBUFF		12	; +12, 4
;#define CLUT		16	; +16,32

;****************************************************************************
;
;****************************************************************************

	.global ppu_reduce
ppu_reduce:
	ext	0x8		; 	xld.w	%r14, 0x200			; 2C̃ItZbg (pɂɎĝŃWX^ɕێ)
	ld.w	%r14,0x0
	ext	0x4		; 	xld.w	%r15, 0x100			; 1C̃ItZbg (pɂɎĝŃWX^ɕێ)
	ld.w	%r15,0x0
	;
	ld.w	%r4,0x8		; 	xld.w	%r4, 0x8			; z = 240/30
ppu_reduce_DO_Z:				; do {
	;
	ld.w	%r5,0x3		; 	xld.w	%r5, 3				;   i = 3
	ld.w	%r6,0xb		; 	xld.w	%r6, 11				;   y = 11
ppu_reduce_DO_Y:				;   do {
	;
	ext	0x1		; 	xld.w	%r7, 0x40			;     x = 256/4
	ld.w	%r7,0x0
ppu_reduce_DO_X:				;     do {
	;
	ext	0x200		; 	xld.w	%r9 , [%r13+0x200]		;       v = tmp[0] + tmp[256] + tmp[512]
	ld.w	%r9,[%r13]
	ext	0x100		; 	xld.w	%r10, [%r13+0x100]
	ld.w	%r10,[%r13]
	 ld.w	%r11, [%r13]+			;       tmp += 4
	add	%r10, %r9
	add	%r11, %r10
	;
	ld.w	%r10, %r11			;       c   = v
	srl	%r11,0x8	; 	xsrl	%r11, 8				;       v >>= 8
	add	%r10, %r11			;       c  += v
	ld.ub	%r10, %r10			;       *dst++ = (unsigned char)c >> 4
	srl	%r10,0x4	; 	xsrl	%r10, 4
	ld.b	[%r12]+, %r10
	;
	srl	%r11,0x8	; 	xsrl	%r11, 8				;       v >>= 8
	;
	ld.w	%r10, %r11			;       c   = v
	srl	%r11,0x8	; 	xsrl	%r11, 8				;       v >>= 8
	add	%r10, %r11			;       c  += v
	ld.ub	%r10, %r10			;       *dst++ = (unsigned char)c >> 4
	srl	%r10,0x4	; 	xsrl	%r10, 4
	ld.b	[%r12]+, %r10
	;
	sub	%r7,0x1		; 	xsub	%r7, %r7, 1			;     } while(--x)
	jrne	ppu_reduce_DO_X	; 	xjrne	ppu_reduce_DO_X
	;
	sub	%r5,0x1		; 	xsub	%r5, %r5, 1			;     --i
	jrne.d	4				;             X[vA1C֐ił܂B
	add	%r13, %r14			;     *delay* ܂ŁA2Ci߂܂B(v3C)
	sub	%r13, %r15			;     (skip?) i == 0Ȃ΁A1C߂܂B(v2C)
	ld.w	%r5, 3				;     (skip?) i = 3
	;
	sub	%r6,0x1		; 	xsub	%r6, %r6, 1			;   } while(--y)
	jrne	ppu_reduce_DO_Y	; 	xjrne	ppu_reduce_DO_Y
	;
	sub	%r4,0x1		; 	xsub	%r4, %r4, 1			; } while(--z)
	jrne	ppu_reduce_DO_Z	; 	xjrne	ppu_reduce_DO_Z
	;
	ret

;****************************************************************************
;
;****************************************************************************

;
; [in]
;	%r12	xpos
;	%r13	ypos
;	%r14	code
;	%r15	palno
;
	.global	ppu_draw_chr
ppu_draw_chr:
	ext	ppu+0x0@h	; 	xld.w	%r7, ppu			; %r7 = ppu
	ext	ppu+0x0@m
	ld.w	%r7,ppu+0x0@l
	;
	ext	0xa		; 	xld.ub	%r4, [%r7+0xa]		; %r4 = scan_start
	ld.ub	%r4,[%r7]
	ext	0xb		; 	xld.ub	%r5, [%r7+0xb]		; %r5 = scan_end
	ld.ub	%r5,[%r7]
	;
	sub	%r4, 8				; if(ypos <= scan_start-8) goto EXIT
	cmp	%r13, %r4
	jrle.d	ppu_draw_chr_EXIT	; 	xjrle.d	ppu_draw_chr_EXIT
	add	%r4, 8				; *delay*
	cmp	%r13, %r5			; if(ypos >= scan_end) goto EXIT
	jrge	ppu_draw_chr_EXIT	; 	xjrge	ppu_draw_chr_EXIT
	cmp	%r12,0x38	; 	xcmp	%r12, -8			; if(xpos <= 0-8) goto EXIT
	jrle	ppu_draw_chr_EXIT	; 	xjrle	ppu_draw_chr_EXIT
	ext	0x4		; 	xcmp	%r12, 256			; if(xpos >= 256) goto EXIT
	cmp	%r12,0x0
	jrge	ppu_draw_chr_EXIT	; 	xjrge	ppu_draw_chr_EXIT
	;
	ext	0xc		; 	xld.w	%r6, [%r7+0xc]		; %r6 = vbuff
	ld.w	%r6,[%r7]
	add	%r7,0x10	; 	xadd	%r7, %r7, 16			; %r7 = clut
	;
	sla	%r13,0x8	; 	xsla	%r13, 8				; vbuff += ypos * 256 + xpos
	add	%r6, %r13
	sra	%r13,0x8	; 	xsra	%r13, 8
	add	%r6, %r12
	;
	sll	%r15,0x2	; 	xsll	%r15, 2				; clut += palno << 2
	add	%r7, %r15
	;
	sll	%r14,0x4	; 	xsll	%r14, 4				; %r14 = pattern = &vram[0x0000|code<<4]
	ext	ppu_vram+0x0@ah
	ext	ppu_vram+0x0@al
	add	%r14, %r14
	;
	cmp	%r13, %r4			; if(ypos < scan_start) goto CLIP
	jrlt	ppu_draw_chr_CLIP	; 	xjrlt	ppu_draw_chr_CLIP
	sub	%r5, 8				; if(ypos > scan_end-8) goto CLIP
	cmp	%r13, %r5
	jrgt.d	ppu_draw_chr_CLIP	; 	xjrgt.d	ppu_draw_chr_CLIP
	add	%r5, 8				; *delay*
	ext	0x3		; 	xcmp	%r12, 0xf8			; if(xpos < 0 || xpos > 256-8) goto CLIP
	cmp	%r12,0x38
	jrugt	ppu_draw_chr_CLIP	; 	xjrugt	ppu_draw_chr_CLIP
	;--------------------------------------------------------------------
ppu_draw_chr_FAST:
	ld.w	%r13,0x8	; 	xld.w	%r13, 8				; %r13 = y = 8
ppu_draw_chr_FAST_DO_Y:				; do {
	;
	ld.ub	%r10,[%r14]	; 	xld.ub	%r10, [%r14+0x0]			;   %r10 = pattern[0] (lobit = 00000000 00000000 00000000 abcdefgh)
	ext	0x8		; 	xld.ub	%r11, [%r14+0x8]			;   %r11 = pattern[8] (hibit = 00000000 00000000 00000000 ABCDEFGH)
	ld.ub	%r11,[%r14]
	rr	%r10, 8				;   lobit = abcdefgh 00000000 00000000 00000000
	rr	%r11, 7				;   hibit = BCDEFGH0 00000000 00000000 0000000A
	;
	ld.w	%r12,0x8	; 	xld.w	%r12, 8				;   %r12 = x = 8
ppu_draw_chr_FAST_DO_X:				;   do {
	;
	ext	0x1		; 	xand	%r15, %r11, 1			;     %r15  = 00000000 00000000 00000000 0000000A
	and	%r15,%r11
	add	%r10, %r10			;     lobit = bcdefgh0 00000000 00000000 00000000, %psr(C) = a
	adc	%r15, %r15			;     %r15  = 00000000 00000000 00000000 000000Aa
	jreq.d	ppu_draw_chr_FAST_SKIP_X	; 	xjreq.d	ppu_draw_chr_FAST_SKIP_X	;     if(!v) goto SKIP_X
	rl	%r11, 1				;     hibit = CDEFGH00 00000000 00000000 0000000B  *delay*
	;
	add	%r15, %r7			;     *vbuff = clut[v]
	ld.ub	%r15, [%r15]
	ld.b	[%r6], %r15
	;
ppu_draw_chr_FAST_SKIP_X:
	sub	%r12,0x1	; 	xsub	%r12, %r12, 1
	jrne.d	ppu_draw_chr_FAST_DO_X	; 	xjrne.d	ppu_draw_chr_FAST_DO_X		;   } while(--x)
	add	%r6, 1				;   vbuff++ *delay*
	;
	ext	0x3		; 	xadd	%r6, %r6, 0xf8			;   vbuff += 256-8
	add	%r6,0x38
	;
	sub	%r13,0x1	; 	xsub	%r13, %r13, 1
	jrne.d	ppu_draw_chr_FAST_DO_Y	; 	xjrne.d	ppu_draw_chr_FAST_DO_Y		; } while(--y)
	add	%r14, 1				; pattern++ *delay*
	;
	jp	ppu_draw_chr_EXIT	; 	xjp	ppu_draw_chr_EXIT
	;--------------------------------------------------------------------
ppu_draw_chr_CLIP:
	pushn	%r1
	;
	ld.w	%r1,0x8		; 	xld.w	%r1, 8				; %r1 = y = 8
ppu_draw_chr_CLIP_DO_Y:				; do {
	;
	cmp	%r13, %r4			;   if(ypos < scan_start) goto SKIP_Y
	jrlt	ppu_draw_chr_CLIP_SKIP_Y	; 	xjrlt	ppu_draw_chr_CLIP_SKIP_Y
	cmp	%r13, %r5			;   if(ypos >= scan_end) goto SKIP_Y
	jrge	ppu_draw_chr_CLIP_SKIP_Y	; 	xjrge	ppu_draw_chr_CLIP_SKIP_Y
	;
	ld.ub	%r10,[%r14]	; 	xld.ub	%r10, [%r14+0x0]			;   %r10 = pattern[0] (lobit = 00000000 00000000 00000000 abcdefgh)
	ext	0x8		; 	xld.ub	%r11, [%r14+0x8]			;   %r11 = pattern[8] (hibit = 00000000 00000000 00000000 ABCDEFGH)
	ld.ub	%r11,[%r14]
	rr	%r10, 8				;   lobit = abcdefgh 00000000 00000000 00000000
	rr	%r11, 7				;   hibit = BCDEFGH0 00000000 00000000 0000000A
	;
	ld.w	%r0,0x8		; 	xld.w	%r0, 8				;   %r0 = x = 8
ppu_draw_chr_CLIP_DO_X:				;   do {
	;
	ext	0x1		; 	xand	%r15, %r11, 1			;     %r15  = 00000000 00000000 00000000 0000000A
	and	%r15,%r11
	add	%r10, %r10			;     lobit = bcdefgh0 00000000 00000000 00000000, %psr(C) = a
	adc	%r15, %r15			;     %r15  = 00000000 00000000 00000000 000000Aa
	jreq.d	ppu_draw_chr_CLIP_SKIP_X	; 	xjreq.d	ppu_draw_chr_CLIP_SKIP_X	;     if(!v) goto SKIP_X
	rl	%r11, 1				;     hibit = CDEFGH00 00000000 00000000 0000000B  *delay*
	;
	ext	0x4		; 	xcmp	%r12, 256			;     if(x < 0 || x >= 256) goto SKIP_X
	cmp	%r12,0x0
	jruge	ppu_draw_chr_CLIP_SKIP_X	; 	xjruge	ppu_draw_chr_CLIP_SKIP_X
	;
	add	%r15, %r7			;     *vbuff = clut[v]
	ld.ub	%r15, [%r15]
	ld.b	[%r6], %r15
	;
ppu_draw_chr_CLIP_SKIP_X:
	add	%r12,0x1	; 	xadd	%r12, %r12, 1			;     xpos++
	;
	sub	%r0,0x1		; 	xsub	%r0, %r0, 1
	jrne.d	ppu_draw_chr_CLIP_DO_X	; 	xjrne.d	ppu_draw_chr_CLIP_DO_X		;   } while(--x)
	add	%r6, 1				;   vbuff++ *delay*
	;
	sub	%r12,0x8	; 	xsub	%r12, %r12, 8			;   xpos -= 8
	sub	%r6,0x8		; 	xsub	%r6, %r6, 8			;   vbuff -= 8
ppu_draw_chr_CLIP_SKIP_Y:
	add	%r13,0x1	; 	xadd	%r13, %r13, 1			;   ypos++
	ext	0x4		; 	xadd	%r6, %r6, 256			;   vbuff += 256
	add	%r6,0x0
	;
	sub	%r1,0x1		; 	xsub	%r1, %r1, 1
	jrne.d	ppu_draw_chr_CLIP_DO_Y	; 	xjrne.d	ppu_draw_chr_CLIP_DO_Y		; } while(--y)
	add	%r14, 1				; pattern++ *delay*
	;
	popn	%r1
	;--------------------------------------------------------------------
ppu_draw_chr_EXIT:
	ret

;****************************************************************************
;
;****************************************************************************

;#endif /*PPU_ASM*/
