/*
 *	cliptsp.h
 *
 *	DSP Group TrueSpeech Decoder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Mon Jul 07 01:54:09 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_TSP_H__
#define __CLIP_TSP_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

//
//W[gp̒ӎ@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//W[̍Đ[`́AX^bN̎gpʂ⑽߂łB(800oCg) @@@@@@@@@@@@
//@W[̋@\gpAvP[V́AX^bN𑽂߂ɊmۂĂB@@@@@@@@@
//@ڈƂẮAW[gpȂꍇA1LoCg炢mۂĂB @@@@@
//̓Iɂ́AL̎Oނ̃X^bNA߂ɊmۂĂ: @@@@@@@@@@@@@@@@@@@
//@@VXeX^bN@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@AvP[VMakefileSYSSTACKŒ`X^bNTCYłB@@@@@@@@@@@@@@@@@
//@A[U[X^bN@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@AvP[VMakefileUSRSTACKŒ`X^bNTCYłB@@@@@@@@@@@@@@@@@
//@@USRSTACK`Ȃꍇ́ARAM̎ceʂ[ł邱ƂmFĂB @@@@@@@@
//@B^XNX^bN@@!!v!!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@task_create()̈Ŏw肷X^bNTCYłB(^XN@\gpAvP[V̂) @@@
//@@ɂ̃X^bNꂽꍇɁA肵Â炢oOƂȂ̂ŁAӂĂB@@@@@@@
//@@X^bNꂽꍇ̏Ǐ̗ƂẮAtask_select()̒ŃAhXG[A @@@@@
//@@^XNXg𑀍삷ۂInsertTailList()̊֐̒ŃAhXG[܂B@@@@@@@
//W[̋@\gpAvP[V́Astack_switch_FRAM4gpȂłB@@@@@
//@FRAM4̃TCY512łAW[̍Đ[`̃X^bNgpʂłB@@@@@
//@X^bNFRAM4֐؂ւĂԂɁA荞݂Đ[`sƁAX^bN܂B 
//@A荞݂֎~ɂăX^bNFRAM4֐؂ւ邱Ƃ́A肠܂B @@@@@@@@@@
//

/****************************************************************************
 *	萔A\
 ****************************************************************************/
//PCEWAVEINFO.type̓Ǝg
#define PW_TYPE_TRUESPEECH 4
/*--------------------------------------------------------------------------*/
//[NGABt[fR[hJn̏l͕sō\ȂBt[ԂňێKvB
typedef struct _ST_TrueSpeechWorkV {													//@ABCDEFG
	int16_t quart;			//+  0,  2: Tut[ԍ: 0`3								//v@@@qq@q
	int16_t flag;			//+  2,  2: 1-bit flag, shows how to choose filters						//@v@q@@@@
	int16_t vector[8];		//+  4, 16: input vector: 5/5/4/4/4/3/3/3							//@vq@@@@@
	int16_t offset1[2];		//+ 20,  4: 8-bit value, used in one copying offset						//@v@@q@@@
	int16_t offset2[4];		//+ 24,  8: 7-bit value, encodes offsets for copying and for two-point filter			//@v@@q@@@
	int16_t pulseval[4];		//+ 32,  8: 7x2-bit pulse values								//@v@@@q@@
	int16_t pulseoff[4];		//+ 40,  8: 4-bit offset of pulse values block							//@v@@@q@@
	int32_t pulsepos[4];		//+ 48, 16: 27-bit variable, encodes 7 pulse positions						//@v@@@q@@
	int16_t prevfilt[8];		//+ 64, 16: filter from previous frame								//v@@q@@@@
	int16_t filters[4][8];		//+ 80, 64: filters for every subframe								//@@@v@@@q
	int16_t newvec[60];		//+144,120: tmp vector										//@@@@v@q@
} ST_TrueSpeechWorkV;			//=264
/*--------------------------------------------------------------------------*/
//s[NGABĐJnɃNABt[ԂňێKvLB
typedef struct _ST_TrueSpeechWorkN {													//@ABCDEFG
	int16_t cvector[8];		//+  0, 16: correlated input vector								//q@lq@@@@
	int16_t filtbuf[60 + 86];	//+ 16,292: some big vector used for storing filters						//@@@@q@l@
} ST_TrueSpeechWorkN;			//=308
/*--------------------------------------------------------------------------*/
//`l[NGA
typedef struct _ST_TrueSpeechCh {
	       int32_t  iLoop;		//+  0,  4: 0=~,1`=c胋[v,-1=[v
	       int16_t  iVol;		//+  4,  2: 0=,1`256=
	      uint16_t  nOutLeft;	//+  6,  2: 0`240=OutBuf[]̎cTv
	const uint32_t* pData;		//+  8,  4: f[^ʒu
	      uint32_t  nFrame;		//+ 12,  4: ct[
	const uint32_t* pInitData;	//+ 16,  4: f[^ʒũZbgl
	      uint32_t  nInitFrame;	//+ 20,  4: ct[̃Zbgl
	       int16_t  OutBuf[240];	//+ 24,480: t[fR[ho̓obt@
	ST_TrueSpeechWorkN WorkN;	//+504,308: s[NGA
} ST_TrueSpeechCh;			//=812
/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/
void TrueSpeech_Init(int nCh);
void TrueSpeech_Exit();
void TrueSpeech_PlayCh(int iCh, const void* pData, int iLoop);
void TrueSpeech_StopCh(int iCh);
void TrueSpeech_StopAll();
int TrueSpeech_GetChStat(int iCh);
void TrueSpeech_SetChAtt(int iCh, int iAtt);
/****************************************************************************
 *	֐
 ****************************************************************************/
void TrueSpeech_DecodeFrame(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pCh, const uint32_t in[/*8*/], int16_t out[/*240*/]);	//@
void TrueSpeech_ReadFrame(ST_TrueSpeechWorkV* pWorkV, const uint32_t in[/*8*/]);							//A
void TrueSpeech_CorrelateFilter(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pCh);							//B
void TrueSpeech_FiltersMerge(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pCh);							//C
void TrueSpeech_ApplyTwopointFilter(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pCh);						//D
void TrueSpeech_PlacePulses(ST_TrueSpeechWorkV* pWorkV, int16_t out[/*60*/]);								//E
void TrueSpeech_UpdateFilters(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pCh, int16_t out[/*60*/]);				//F
void TrueSpeech_Synth(ST_TrueSpeechWorkV* pWorkV, int16_t out[/*60*/]);									//G
void TrueSpeech_Mix1(ST_TrueSpeechCh* pCh, int mixbuf[/*160*/]);
void TrueSpeech_Mix2(short wbuff[/*320*/], int mixbuf[/*160*/]);
/*--------------------------------------------------------------------------*/
extern const int16_t TBL_TrueSpeech_Codebook0[32];
extern const int16_t TBL_TrueSpeech_Codebook1[32];
extern const int16_t TBL_TrueSpeech_Codebook2[16];
extern const int16_t TBL_TrueSpeech_Codebook3[16];
extern const int16_t TBL_TrueSpeech_Codebook4[16];
extern const int16_t TBL_TrueSpeech_Codebook5[8];
extern const int16_t TBL_TrueSpeech_Codebook6[8];
extern const int16_t TBL_TrueSpeech_Codebook7[8];
extern const int16_t TBL_TrueSpeech_Order2Coeffs[25][2];
extern const int16_t TBL_TrueSpeech_PulseScales[16][4];
extern const int16_t TBL_TrueSpeech_PulseValues[4][30];

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_TSP_H__*/
