/*	
 *	clipscan.c
 *
 *	R[obNpscanf̎
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Thu Oct 23 20:43:59 JST 2014 Naoyuki Sawa
 *	- VK쐬B
 *	  http://www.cise.ufl.edu/~cop4600/cgi-bin/lxr/http/source.cgi/lib/stdio/doscan.cɉ܂B
 *	- sscanf()n֐́AP/ECEJEPSONCuɂ܂܂Ă܂AōĎ܂B
 *	  ōĎŔAȉ̒ʂł:
 *	  EEPSONCusscanf()n֐́A'%n'ɑΉĂ܂B
 *	    '%n'͕͂ŎgƂ\Ǝv̂ŁA'%n'ɑΉsscanf()n֐KvƎv܂B
 *	  EPOSIXW'm'tO֗łB擾obt@CɂȂčςނłB
 *	    EPSONCusscanf()n֐́A'm'ɂΉĂȂ̂ŁAŎ邱Ƃɂ܂B
 *	  EEPSONCuɌ炸AC^v^̎sscanf()n֐gÂ炢܂B
 *	    w蕶[U[̃XNvgw肷ꍇȀw蕶񂩂瓾lA
 *	    XNvg֕Ԃɂ́AǁAC^v^gw蕶͂Ȃ΂Ȃ܂B
 *	    w蕶񂩂瓾ꂽlR[obNŒʒm悤ɏo΁AL̖͉܂B
 *	    sscanf()n֐̎𒲂ׂ܂AǂႪ炸AŎ邱Ƃɂ܂B
 *	- EPSONCuł́Adoscan()̓[J֐ƂȂĂ܂Ał́AO[o֐Ƃ܂B
 *	  O[o֐ƂŔAȉ̒ʂł:
 *	  EOq̂悤ɁAw蕶񂩂瓾ꂽlR[obNŒʒmoƁA֗Ȏ܂B
 *	    Wsscanf()n֐̃C^[tFCXɂ́Â悤Ȏdĝ݂ŁA
 *	    {͓֐łdoscan()JāAR[obNŒʒmC^[tFCXƂ܂B
 *	    C^v^̎ɁAdoscan()𒼐ڎgƁA֗ƎvłB
 *	* Sun May 29 21:54:56 JST 2016 Naoyuki Sawa
 *	- Visual C++ .NETŃRpCɁAscanf()ŌxC4028\܂B
 *	  ڍׂ́Aȉ̒ʂłB
 *	- VC++2015œCuRpCĂ݂ACu̎Œu邽߂́Ascanf()ŌxC4028\܂B
 *	  ́AVC++2015ł́Å֐̃vg^CvAWIȃvg^CvƈقȂĂ鎖łB
 *	  ȉɁAVC++2015ł́Ascanf()̐錾܂B(̊֐lł)
 *	  c:\Program Files (x86)\Windows Kits\10\Include\10.0.10240.0\ucrt\stdio.h
 *	  _CRT_STDIO_INLINE int __CRTDECL scanf(
 *	      _In_z_ _Scanf_format_string_ char const* const _Format,
 *	      ...)
 *	  WIȃvg^Cvł́A'char const*'łAVC++2015ł͑'char const* const'ɂȂĂ܂B
 *	  (Ȃ݂ɁAMSDN̊֐t@Xł͑O҂ɂȂĂAVC++2015̃wb_t@C҂̐錾ł悤łB)
 *	- Ώ@́Aލl܂B
 *	  E́AVisual C++ .NETȂ΁AW[̊֐̈^ύXāAVisual C++ .NET̊֐vg^Cvɍ킹鎖łB
 *	  E́AVisual C++ .NETȂ΁Ax𖳎@łB
 *	  {͑O҂̕SȂ̂ł傤ǁA͌҂̕@gɂ܂B
 *	  ̖͖炩Visual C++ .NET̖łA̖ɑΏ邽߂ɑ̊֐̒`RpC肵āAR[hGɂȂ̂͗ǂȂƎvłB
 *	- {Aclipprnt.cclipscan.cɁA@őΏs܂B
 *	  AΏ@ύXꍇ́AɂāAύXKvL邩ĉB
 *	* Sun Sep 04 21:41:17 JST 2016 Naoyuki Sawa
 *	- u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
 *	  ڍׂ́Aclipstd.h ̓̃RgQƂĉB
 */
#include "clip.h"
/****************************************************************************
 *
 ****************************************************************************/
int doscan(const char* str, const char* fmt, void (*callback)(struct doscan_store*, void*), void* param) {
	const char* const org = fmt;
	int bConv = 0;		/* ȂƂ̕ϊZbgB'*''%n'łZbgB */	//uLinux Programmer's Manual - SCANFv(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/scanf.3.html)p:
	int nStore = 0;		/* ϊƑ'͗vf'̐𐔂B'*''%n'̐͊܂߂ȂB */	//C̕WKił́us̊ɕԂ̉񐔂%n߂̎sł͑ȂvƂȂĂ邪A\̓e͂Ɩ悤łB炭A%nϊԂlɗ^eɂĂ͂ǂ̂悤ȉȂ̂ł낤B
	char* tmp = NULL;	/* ꎞIȕ */
	for(;;) {
		/* ɖIȋ󔒂L΁c */
		if(isspace(*fmt)) {
			/* ̋󔒂ǂݔ΂B */
			fmt += strspn(fmt, "\t\n\v\f\r ");
			/* ͕̋󔒂ǂݔ΂B */
			str += strspn(str, "\t\n\v\f\r ");
		}
		/* wȂ΁c */
		if(*fmt == '%') {
			/* '%'̎֐i߂B */
			fmt++;
			/* '%%'ȊOȂ΁c */
			if(*fmt != '%') {
				struct doscan_store store;
				char* endp;
				int len;
				int aster = 0;	/* }w肳ꂽZbgB */
				int width = 0;	/* widthtB[hw肳ꂽύXB */
				if(*fmt == '*') {
					aster = *fmt++;
				}
				/* widthtB[h擾B */
				if(isdigit(*fmt)) {
					width = strtol(fmt, (char**)&fmt, 10);
				}
				/* flagtB[h擾B */
				if((*fmt == 'h') || (*fmt == 'l') || (*fmt == 'm')) {	//'m'POSIX.1-2008ŕWĂB
					store.flag = *fmt++;
				}
				/* typetB[h擾B */
				store.type = *fmt++;
				/* '%c','%[...]','%n'ȊOȂ΁c */
				if((store.type != 'c') && (store.type != '[') && (store.type != 'n')) {
					/* Öقœ͕̋󔒂ǂݔ΂B */
					str += strspn(str, "\t\n\v\f\r ");
				}
				switch(store.type) {
				case 'n':
					store.value.i = str - org;
					break;
				case 'i':
				case 'd':
				case 'o':
				case 'u':
				case 'x':
				case 'X':
				case 'e':
				case 'E':
				case 'f':
				case 'g':
				case 'G':
					if(!width) { width = INT_MAX; }	/* widthw薳Ȃ΁AƂB */
					tmp = strndup(str, width);
					if(!tmp) { DIE(); }
					switch(store.type) {
					case 'i':
					case 'd':
						store.value.i = strtoul(tmp, &endp, (store.type == 'i') ? 0 : 10);
						break;
					case 'o':
					case 'u':
					case 'x':
					case 'X':
						store.value.i = strtoul(tmp, &endp, (store.type == 'o') ? 8 : (store.type == 'u') ? 10 : 16);
						break;
					default:
						store.value.f = strtod(tmp, &endp);
						break;
					}
					len = endp - tmp;
					if(!len) { goto L_EXIT; }
					str += len;
					break;
				case 's':
				case 'c':
					if(store.type == 's') {
						len = strcspn(str, "\t\n\v\f\r ");
						if(!width || (len < width)) { width = len; }	/* '%s'̏ꍇAwidthw薳,,w肳ꂽwidth󔒂܂ł̕Ȃ΁A󔒂܂ł̕ƂB */
					} else {
						if(!width) { width = 1; }			/* '%c'̏ꍇAwidthw薳Ȃ΁A1ƂB */
					}
					tmp = strndup(str, width);
					if(!tmp) { DIE(); }
					len = strlen(tmp);
					if(!len) { goto L_EXIT; }
					store.value.s = tmp;
					str += len;
					break;
				case '[':
					{
						int circum = 0;	/* ے蕶NXw肳ꂽZbgB */
						if(*fmt == '^') {	/* '['̎'^'L΁c */
							circum = 1;	/* ے蕶NXłB */
							fmt++;		/* '^'̎֐i߂B */
						}
						if(!width) { width = INT_MAX; }	/* widthw薳Ȃ΁AƂB */
						{
							const char* class_start = fmt;
							for(len = 0; (len < width) && str[len]; len++) {
								int lo, hi, match = 0;
								fmt = class_start;
								lo = *fmt++;				/* ̉擾B */
								do {					/* '['̒']','[^'̒']'́AeƌȂNXȂB */
									if(!lo) { DIE(); }		/* NXĂȂB */
									hi = lo;			/* ƓɂĂB */
									if(*fmt == '-') {		/* ̕'-'Ȃ΁c */
										fmt++;			/* '-'̎֐i߂B */
										hi = *fmt++;		/* 擾B */
										if(!hi) { DIE(); }	/* NXĂȂB */
									}
									if((str[len] >= lo) && (str[len] <= hi)) { match = 1; }
									if((str[len] >= hi) && (str[len] <= lo)) { match = 1; }	/* twƂB */
									lo = *fmt++;			/* ̉擾B */
								} while(lo != ']');			/* NX甲B */
								/* fmt']'̎wĂB */
								if(!(match ^ circum)) { break; }
							}
						}
						if(!len) { goto L_EXIT; }
						/* (len!=0)Ȃ΁Afmt']'̎wĂB */
						tmp = strndup(str, len);
						if(!tmp) { DIE(); }
						store.value.s = tmp;
						str += len;
					}
					break;
				default:
					DIE();	/* sȏw */
				}
				/* ȂƂ̕ϊZbgB'*''%n'łZbgB */
				bConv = 1;
				/* '*'w肳ĂȂ΁c */
				if(!aster) {
					/* R[obNw肳Ă΁AĂяoB */
					if(callback) { (*callback)(&store, param); }
					/* ϊƑ'͗vf'̐𐔂B'*''%n'̐͊܂߂ȂB */
					if(store.type != 'n') { nStore++; }
				}
			/* '%%'Ȃ΁c */
			} else {
				/* '%'Ɠ͕rB */
				goto L_LITERAL;
			}
		/* włȂ΁c */
		} else {
L_LITERAL:		/* 񂪏I[ÁA͕ƈvȂ΁AB */
			if(!*fmt || (*fmt++ != *str++)) { break; }
		}
		/* ꎞIȕ񂪊mۂĂÃ[vJnOɊJB */
		if(tmp) {
			free(tmp);
			tmp = NULL;
		}
	}
L_EXIT:	/* ꎞIȕ񂪖JȂ΁AJB */
	if(tmp) { free(tmp); }
	/* ŏ̕ϊÁȀ͕I[ȊOŕsvNꍇ́AϊƑ͗vf̐ԂB
	 * ŏ̕ϊOɓ͕̏I[ɒBĈv̎sNꍇ́AEOFԂB */
	return (bConv || *str) ? nStore : EOF;
}
/****************************************************************************
 *
 ****************************************************************************/
static void vsscanf_callback(struct doscan_store* storePtr, void* param) {
	va_list* apPtr = param;
	switch(storePtr->type) {
	case 'n':
	case 'i':
	case 'd':
	case 'o':
	case 'u':
	case 'x':
	case 'X':
		if(storePtr->flag == 'h') {
			*va_arg(*apPtr, short*) = storePtr->value.i;
		} else {
			*va_arg(*apPtr,   int*) = storePtr->value.i;
		}
		break;
	case 'e':
	case 'E':
	case 'f':
	case 'g':
	case 'G':
		if(storePtr->flag == 'l') {
			*va_arg(*apPtr, double*) = storePtr->value.f;
		} else {
			*va_arg(*apPtr,  float*) = storePtr->value.f;
		}
		break;
	case 's':
	case 'c':
	case '[':
		       if(storePtr->flag == 'm') {								//'m'POSIX.1-2008ŕWĂB
			      *va_arg(*apPtr, char**) = strdup(storePtr->value.s);
		} else if(storePtr->type == 'c') {
			memcpy(va_arg(*apPtr, char*),          storePtr->value.s, strlen(storePtr->value.s));	//'%c'͏I[nuli[ȂdlłB
		} else {
			strcpy(va_arg(*apPtr, char* ),         storePtr->value.s);
		}
		break;
	default:
		DIE();
	}
}
/****************************************************************************
 *
 ****************************************************************************/
//{{2016/05/29ǉ:Visual C++ .NETŃRpCɁAxC4028\܂B
// * Sun May 29 21:54:56 JST 2016 Naoyuki Sawa
// - Visual C++ .NETŃRpCɁAscanf()ŌxC4028\܂B
//   ڍׂ́Aȉ̒ʂłB
// - VC++2015œCuRpCĂ݂ACu̎Œu邽߂́Ascanf()ŌxC4028\܂B
//   ́AVC++2015ł́Å֐̃vg^CvAWIȃvg^CvƈقȂĂ鎖łB
//   ȉɁAVC++2015ł́Ascanf()̐錾܂B(̊֐lł)
//   c:\Program Files (x86)\Windows Kits\10\Include\10.0.10240.0\ucrt\stdio.h
//   _CRT_STDIO_INLINE int __CRTDECL scanf(
//       _In_z_ _Scanf_format_string_ char const* const _Format,
//       ...)
//   WIȃvg^Cvł́A'char const*'łAVC++2015ł͑'char const* const'ɂȂĂ܂B
//   (Ȃ݂ɁAMSDN̊֐t@Xł͑O҂ɂȂĂAVC++2015̃wb_t@C҂̐錾ł悤łB)
// - Ώ@́Aލl܂B
//   E́AVisual C++ .NETȂ΁AW[̊֐̈^ύXāAVisual C++ .NET̊֐vg^Cvɍ킹鎖łB
//   E́AVisual C++ .NETȂ΁Ax𖳎@łB
//   {͑O҂̕SȂ̂ł傤ǁA͌҂̕@gɂ܂B
//   ̖͖炩Visual C++ .NET̖łA̖ɑΏ邽߂ɑ̊֐̒`RpC肵āAR[hGɂȂ̂͗ǂȂƎvłB
// - {Aclipprnt.cclipscan.cɁA@őΏs܂B
//   AΏ@ύXꍇ́AɂāAύXKvL邩ĉB
#if     (defined(_MSC_VER) && (_MSC_VER > 1200))
//{{2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
//#pragma warning(disable: 4028)	//Visual C++ .NETȂ΁A͈̔͂ŌxC4028}܂B
//2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#pragma warning(push)
#pragma warning(disable: 4028)		//Visual C++ .NETȂ΁A͈̔͂ŌxC4028}܂B
//}}2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#endif//(defined(_MSC_VER) && (_MSC_VER > 1200))
//}}2016/05/29ǉ:Visual C++ .NETŃRpCɁAxC4028\܂B
/****************************************************************************
 *
 ****************************************************************************/
int scanf(const char* fmt, ...) {
	int retval;
	va_list ap;
	va_start(ap, fmt);
	retval = vscanf(fmt, ap);
	va_end(ap);
	return retval;
}
int vscanf(const char* fmt, va_list ap) {
	return vfscanf(stdin, fmt, ap);
}
/*--------------------------------------------------------------------------*/
int sscanf(const char* str, const char* fmt, ...) {
	int retval;
	va_list ap;
	va_start(ap, fmt);
	retval = vsscanf(str, fmt, ap);
	va_end(ap);
	return retval;
}
int vsscanf(const char* str, const char* fmt, va_list ap) {
	return doscan(str, fmt, vsscanf_callback, &ap);
}
/*--------------------------------------------------------------------------*/
int fscanf(FILE* stream, const char* fmt, ...) {
	int retval;
	va_list ap;
	va_start(ap, fmt);
	retval = vfscanf(stream, fmt, ap);
	va_end(ap);
	return retval;
}
int vfscanf(FILE* stream, const char* fmt, va_list ap) {
	DIE();	//
}
/****************************************************************************
 *
 ****************************************************************************/
//{{2016/05/29ǉ:Visual C++ .NETŃRpCɁAxC4028\܂B
#if     (defined(_MSC_VER) && (_MSC_VER > 1200))
//{{2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
//#pragma warning(default: 4028)	//Visual C++ .NETȂ΁A͈̔͂ŌxC4028}܂B
//2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#pragma warning(pop)			//Visual C++ .NETȂ΁A͈̔͂ŌxC4028}܂B
//}}2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#endif//(defined(_MSC_VER) && (_MSC_VER > 1200))
//}}2016/05/29ǉ:Visual C++ .NETŃRpCɁAxC4028\܂B
/****************************************************************************
 *
 ****************************************************************************/
