;
;	clips26a.s
;
;	P/ECE Signetics 2650 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Mon Apr 25 20:42:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clips26a.h"
;
;	clips26a.h
;
;	P/ECE Signetics 2650 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Mon Apr 25 20:42:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;

; clips26a.sAframs26a.sɃCN[hĎg܂B

;****************************************************************************
;	S2650\
;****************************************************************************

				; typedef struct _S2650 {
;#define PSL		 0	; 	unsigned char psl;		// + 0, 1: Program Status Lower
			  	; 					//           psl[1]=COM (logical/arith COMpare)
			  	; 					//           psl[3]=WC  (With/without Carry)
			  	; 					//           psl[4]=RS  (Register bank Select)
			  	; 					//           ̑̃rbg͕słB
;#define PSU		 1	; 	unsigned char psu;		// + 1, 1: Program Status Upper
			  	; 					//           psu[5]=II (Interrupt Inhibit)
			  	; 					//           psu[6]=F  (Flag)
			  	; 					//           psu[7]=S  (Sense)
			  	; 					//           ̑̃rbg͕słB
;#define _CC_		 2	; 	unsigned short cc;		// + 2, 2: Condition Code
			  	; 					//           cc=0x0000         Ȃ CC=0 Ӗ܂B
			  	; 					//           cc=0x0001..0x007f Ȃ CC=1 Ӗ܂B
			  	; 					//           cc=0x0080..0x00ff Ȃ CC=2 Ӗ܂B
			  	; 					//           cc=0x0100..0xffff Ȃ CC=3 Ӗ܂B
;#define C		 4	; 	unsigned short c;		// + 4, 2: Carry
			  	; 					//           c[8]=0 Ȃ C=0 Ӗ܂B
			  	; 					//           c[8]=1 Ȃ C=1 Ӗ܂B
			  	; 					//           ̑̃rbg͕słB
;#define OVF		 6	; 	unsigned char ovf;		// + 6, 1: OVerFlow
			  	; 					//           ovf[7]=0 Ȃ OVF=0 Ӗ܂B
			  	; 					//           ovf[7]=1 Ȃ OVF=1 Ӗ܂B
			  	; 					//           ̑̃rbg͕słB
;#define IDC		 7	; 	unsigned char idc;		// + 7, 1: Inter Digit Carry
			  	; 					//           idc[4]=0 Ȃ IDC=0 Ӗ܂B
			  	; 					//           idc[4]=1 Ȃ IDC=1 Ӗ܂B
			  	; 					//           ̑̃rbg͕słB
;#define REG		 8	;  	unsigned char reg[7];		// + 8, 7: REGister stack
;#define SP		15	; 	unsigned char sp;		// +15, 1: Pointer for the return address Stack
			  	; 					//           sp=0..7
;#define RAS		16	;  	unsigned short ras[8];		// +16,16: Return Address Stack
			  	;  					//           ras[*]=0x0000..0x7fff
;#define _IAR_		32	; 	unsigned short iar;		// +32, 2: Instruction Address Register
			  	; 					//           iar=0x0000..0x7fff
				; 	//------------------------------//
;#define FLAGS		34	; 	unsigned char flags;		// +34, 1: ------hi
			  	; 					//           flg[0]=IRQ (#INTREQ[q̏Ԃɑ܂)
			  	; 					//           flg[1]=HALT
;#define VECTOR		35	; 	unsigned char vector;		// +35, 1: 荞݃xN^
			  	; 					//           IRQ=1 ̏ꍇ̂ݗLłB
;#define _CYCLE_		36	; 	int cycle;			// +36, 4: csTCN
;#define SIZEOF_S2650	40	; } S2650;				// =40

;* S2650.flags */
;#define FLAGS_IRQ	0
;#define FLAGS_HALT	1

;* S2650.psu */
;#define PSU_SP0		0
;#define PSU_SP1		1
;#define PSU_SP2		2
;/ Unused		3
;/ Unused		4
;#define PSU_II		5
;#define PSU_F		6
;#define PSU_S		7

;* S2650.psl */
;#define PSL_C		0
;#define PSL_COM		1
;#define PSL_OVF		2
;#define PSL_WC		3
;#define PSL_RS		4
;#define PSL_IDC		5
;#define PSL_CC0		6
;#define PSL_CC1		7

;****************************************************************************
;	WX^蓖
;****************************************************************************

;#define addr	r0	; ݂̖߂AddressModeAAhXێ܂B
			; AddressMode()ݒ肵AAction()QƂ܂B
			; Operation()Ȃ̃[`́AƂĎgpsłB(O)
			; AddressMode𔺂Ȃ߂ɂẮA[NWX^ƂĎgp\łB
;#define data	r1	; {Iɂ́Aėp̃[NWX^łB
			; ReLXgO̊֐ĂяoꍇɁAۑKv̂li[ĂB
			; AddressMode()ꕔ̓֐(*)ւ̈A߂lێ邽߂̃WX^ƂĂgp܂B
			; ((*)2005/05/04݁As2650_set_psu,s2650_set_pslւ̈As2650_get_psu,s2650_get_psl̖߂l)
			; ֐āA"%data=fn(%addr,%data)"`̂̂ƁA"%r10=fn(%r12,%r13)"`̂̂L̂ŁAӂĂB
;#define seq	r2	; ݂̖߂ɑΉs2650seqGg̑|C^łB
			; s2650_run()As2650_run()Operation()AAddressMode()gp܂B
;#define reg	r3	; ݂̖߂RegisterAWX^tB[hւ̃|C^ێ܂B
			; Register()AOperation()AAddressMode()gp܂B
;#define CPU	r4	; S2650\̂̐擪AhXێ܂B
;#define CC	r5	; s2650.cctB[h̒lێ܂B($00/$01..$7F/$80..$FF/$100..$FFFF)
			; %CCWX^ێĂlƁA{2650PSL(CC)̑ΉɂẮAs2650.cctB[h̐QƂĂB
;#define IAR	r6	; s2650.iartB[h̒lێ܂B($0000..$7FFF)
;#define CYCLE	r7	; csTCNێ܂B

;****************************************************************************
;
;****************************************************************************

;****************************************************************************
;
;****************************************************************************

	.code
	.align 1

;****************************************************************************
;	sReLXgO痘p֐
;****************************************************************************

	.global	s2650_irq
s2650_irq:
	pushn	%r3
	ext	s2650_enter@rm	; 	xcall	s2650_enter			; sReLXg֓܂B
	call	s2650_enter@rl
	;
	ext	0x22		; 	xbset	[%r4+0x22], 0x0		; 荞ݗvZbg܂B
	bset	[%r4],0x0
	ext	0x23		; 	xld.b	[%r4+0x23], %r12		; 荞݃xN^i[܂B
	ld.b	[%r4],%r12
	call	s2650_check_pending	; 	xcall	s2650_check_pending		; Ɋ荞ݎs\ׂ܂B
	;
	ext	s2650_leave@rm	; 	xcall	s2650_leave			; sReLXg𔲂܂B
	call	s2650_leave@rl
	popn	%r3
	ret

;****************************************************************************
;	sReLXg痘p֐
;****************************************************************************

	.global	s2650_check_pending
s2650_check_pending:
	ext	0x22		; 	xbtst	[%r4+0x22], 0x0		; 荞ݗvZbgĂȂ΁A܂B
	btst	[%r4],0x0
	jreq	s2650_check_pending_EXIT	; 	xjreq	s2650_check_pending_EXIT
	ext	0x1		; 	xbtst	[%r4+0x1], 0x5		; 荞݋֎~(II=1)Ȃ΁A܂B
	btst	[%r4],0x5
	jrne	s2650_check_pending_EXIT	; 	xjrne	s2650_check_pending_EXIT
	;
	ext	0x22		; 	xbclr	[%r4+0x22], 0x0		; 荞ݗvNABHALTȂHALT܂B
	bclr	[%r4],0x0
	ext	0x22		; 	xbclr	[%r4+0x22], 0x1
	bclr	[%r4],0x1
	ext	0x1		; 	xbset	[%r4+0x1], 0x5		; 荞݋֎~(II=1)܂B
	bset	[%r4],0x5
	;
	ext	0x23		; 	xld.ub	%r1, [%r4+0x23]		; "ZBSR vector"̏s܂B
	ld.ub	%r1,[%r4]
	ext	s2650_VEC@rm	; 	xcall	s2650_VEC			; AddressMode
	call	s2650_VEC@rl
	ext	s2650_BS@rm	; 	xcall	s2650_BS
	call	s2650_BS@rl
s2650_check_pending_EXIT:
	ret

;****************************************************************************
;	AddressMode (gppxႢ)
;****************************************************************************

	.global	s2650_CTL
s2650_CTL: ;* M/#IO=#IO, D/#C=#C(Control), E/#NE=#NE(Non-extended) */
	ext	0x4		; 	xld.w	%r0, 0x100			; addr = 0x100
	ld.w	%r0,0x0
	ret

	.global	s2650_DAT
s2650_DAT: ;* M/#IO=#IO, D/#C=D(Data), E/#NE=#NE(Non-extended) */
	ext	0x4		; 	xld.w	%r0, 0x101			; addr = 0x101
	ld.w	%r0,0x1
	ret

	.global	s2650_EXT
s2650_EXT: ;* M/#IO=#IO, E/#NE=E(Extended), A7:0=2nd byte of the instruction */
	ext	s2650_read@rm	; 	xcall.d	s2650_read			; addr = [IAR++]
	call.d	s2650_read@rl
	ld.w	%r12, %r6			;						*delay*
	add	%r6, 1
	ret.d
	ld.w	%r0, %r10			;						*delay*

;****************************************************************************
;	Operation (gppxႢ)
;****************************************************************************

	.global	s2650_ERR
s2650_ERR:
	ext	s2650_leave@rm	; 	xcall	s2650_leave			; sReLXg𔲂܂B
	call	s2650_leave@rl
	ext	s2650_err@rm	; 	xjp	s2650_err			; Cł̃G[[`ցB
	jp	s2650_err@rl

;*--------------------------------------------------------------------------*/

	.global	s2650_RETE
s2650_RETE:
	ld.w	%r9, [%r2]+			; Condition
	call	%r9
	jrne	s2650_RETE_EXIT	; 	xjrne	s2650_RETE_EXIT
	ext	s2650_RET@rm	; 	xcall	s2650_RET
	call	s2650_RET@rl
	ext	0x1		; 	xbclr	[%r4+0x1], 0x5		; II=0:荞݋
	bclr	[%r4],0x5
	call	s2650_check_pending	; 	xcall	s2650_check_pending
s2650_RETE_EXIT:
	ret

;*--------------------------------------------------------------------------*/

	.global	s2650_REDp
s2650_REDp:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ext	s2650_read_io@rm	; 	xcall.d	s2650_read_io			; %r10 = [port]
	call.d	s2650_read_io@rl
	ld.w	%r12, %r0			;				*delay*
	ld.b	[%r3], %r10			; r    = %r10
	ret.d
	ld.w	%r5, %r10			; CC   = %r10			*delay*

	.global	s2650_WRTp
s2650_WRTp:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.w	%r9, [%r2]+			; AddressMode
	call	%r9
	ld.ub	%r13, [%r3]			; [port] = r
	ext	s2650_write_io@rm	; 	xjp.d	s2650_write_io
	jp.d	s2650_write_io@rl
	ld.w	%r12, %r0

;*--------------------------------------------------------------------------*/

	.global	s2650_NOP
s2650_NOP:
	;** no job **/
	ret

	.global	s2650_DAR
s2650_DAR:
	ld.w	%r9, [%r2]+			; Register
	call	%r9
	ld.ub	%r10, [%r3]			; %r10 = hi = r
	ld.w	%r11, %r10			; %r11 = lo = r
	ext	0x5		; 	xbtst	[%r4+0x5], 0x0			; if(!C) {
	btst	[%r4],0x0
	jrne	s2650_DAR_L10	; 	xjrne	s2650_DAR_L10
	ext	0x2		; 	xadd	%r10, %r10, 0xa0		;   hi += 0xa0
	add	%r10,0x20
s2650_DAR_L10:					; }
	ext	0x7		; 	xbtst	[%r4+0x7], 0x4			; if(!IDC) {
	btst	[%r4],0x4
	jrne	s2650_DAR_L20	; 	xjrne	s2650_DAR_L20
	add	%r11,0xa	; 	xadd	%r11, %r11, 0x0a		;   lo += 0x0a
s2650_DAR_L20:					; }
	ext	0x3		; 	xand	%r10, %r10, 0xf0		; r = (hi&0xf0)|(lo&0x0f)
	and	%r10,0x30
	and	%r11,0xf	; 	xand	%r11, %r11, 0x0f
	or	%r10, %r11
	ld.b	[%r3], %r10
	ret

	.global	s2650_HALT
s2650_HALT:
	ext	0x22		; 	xbset	[%r4+0x22], 0x1
	bset	[%r4],0x1
	ret.d
	ld.w	%r7, 0			;				*delay*

;****************************************************************************
;
;****************************************************************************
