/*
 *	clipncss.c
 *
 *	Xe[gXNCSԃV[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Mon Mar 21 21:34:20 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- clipncs.cNCS_new()x[XɁAȉ̕ύXsč쐬܂B
 *	  ENCS_new()͑ŜʂfloatZłB
 *	    W[͎uint16_t,Wint16_t,Zdouble,ԌW̊i[1ȏ̐fp16,0̐(=W)int16_tƂ܂B
 *	    ̂悤ɁAꂼ̉ӏɓK؂Ȍ^I鎖ɂāAZx̌ƃf[^eʂጸ悤ɂ܂B(ʂ͖؂łB)
 *	  ENCS_new()͎sɕԌW߂@L܂łB
 *	    W[NCS_new()ƓlɎsɕԌW߂鎖o܂AsOɃc[gĕԌW߂Ăo܂B
 *	    ߓ_\ȏギ炢ɂȂƁAԌW̌vZɂ͐b`\bȏ㎞Ԃ|̂ŁAsɕԌW߂͓̂łB
 *	    W[̕@Ȃ΁ArhԂ葽̐ߓ_̕ԃf[^쐬ĂƂ\łB(ROMlꍇLłB)
 *	    Ԃ|̂͂܂łԌW߂鏈łAߓ_̐Ăs̕ԏ̎Ԃɂ͉eL܂B
 *	  ENCS_new()͈̍\̂ƂɈ̎ԏo܂łB
 *	    ̎Ԃ邽߂ɂ͕̍\̂쐬KvLA̖ʂĂ܂B
 *	    W[͈̍\̂ŕ̎ǗoAm[hɈ̎L镡̎̕ԂŝŁAeʂƑxPo܂B
 *	- ȏ̂悤ȉPŝłAƂ͌AASŶclipncs.cNCS_new()ƑSłB
 *	  ASY̏ڍׂɂẮAclipncs.cNCS_new()QƂĉB
 *	* Thu Mar 24 21:04:15 JST 2016 Naoyuki Sawa
 *	- NcsSeq_GetVal_subr()̊ۂߏA+ɕ΂ĂC܂B
 *	  P0.5𑫂Đ؂̂Ă̂͊ԈႢŁAlĊۂ߂ŝłB
 *	* Mon Mar 28 21:40:28 JST 2016 Naoyuki Sawa
 *	- NcsSeq_GetVal_subr()̒ŁAϘaZfma()g悤ɕύX܂B
 *	  R[hTCY͂Ɍ܂Bʂ͕ύXOƓłB
 *	* Thu Mar 31 21:48:20 JST 2016 Naoyuki Sawa
 *	- ST_NcsSeq\̂tEndtB[hǉ܂B
 *	- NcsSeq_GetLen(),NcsSeqNo_GetLen()ǉ܂B
 *	* Tue Sep 06 21:06:46 JST 2016 Naoyuki Sawa
 *	- (int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
 *	  ڍׂ́ANcsSeg_compar(),NcsSeq_GetVal_subr()̃RgQƂĉB
 */
#include "clip.h"
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
//_~[̎擾֐
//_~[̎擾֐(iNode=0)ɑ΂Ď0,(iNode=1)ɑ΂Ď1ԂB
//قȂ鎞łΉłǂB
static int fnGetTim_1node(int iNode, void* arg) {
	return iNode;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//_~[̍W擾֐
//_~[̍W擾֐͌̍W擾֐(iNode=0)ŒŌĂяolԂB
static int fnGetPos_1node( int iNode, int iAxs, void* arg) {
	                    void** arg_1node/*[2]*/ = arg;
	   int (*fnGetPos)(int iNode, int iAxs, void* arg) = arg_1node[0];
	                       iNode = 0;             arg  = arg_1node[1];
	return (*fnGetPos)(    iNode,     iAxs,       arg);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int call_fnGetTim(int (*fnGetTim)(int iNode, void* arg), int iNode, void* arg) {
	int iTim = (*fnGetTim)(iNode, arg);
	if((unsigned)iTim > UINT16_MAX) { DIE(); }
	return iTim;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int call_fnGetPos(int (*fnGetPos)(int iNode, int iAxs, void* arg), int iNode, int iAxs, void* arg) {
	int iPos = (*fnGetPos)(iNode, iAxs, arg);
	if((iPos < INT16_MIN) || (iPos > INT16_MAX)) { DIE(); }
	return iPos;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_NcsSeq* NcsSeq_New(int (*fnGetTim)(int iNode, void* arg), int (*fnGetPos)(int iNode, int iAxs, void* arg), int nNode, int nAxs, void* arg) {
	void* arg_1node[2];
	int nSeg, SegBytes, iAxs, i;
	ST_NcsSeq* pNcsSeq;
	ST_NcsSeg* pNcsSeg;
	double* A/*[nSeg-1][nSeg-1]*/;						//IɊi[Ȃvf0.0̂܂܂ƂB
	double* b/*[nSeg-1]*/;							//SĂ̗vf𖾎IɊi[B
	double* x/*[nSeg+1]*/;							//(x[0]=x[nSeg]=0.0)ŒƂB
	//ߓ_̐́A(1`(UINT8_MAX+1))͈̔͂łȂĂ͂ȂȂB
	if((nNode < 1) || (nNode > (UINT8_MAX+1))) { DIE(); }
	//̐́A(1`(UINT8_MAX+1))͈̔͂łȂĂ͂ȂȂB
	if((nAxs < 1) || (nAxs > (UINT8_MAX+1))) { DIE(); }
	//ߓ_łꍇÂ܂܂ł͕ԏoȂ̂ŁA[IɈقȂ鎞ԁEW̐ߓ_̕ԂƌȂB
	if(nNode == 1) {
		arg_1node[0] = fnGetPos;					//_~[̍W擾֐(fnGetPos_1node())ւ̃p[^i[B
		arg_1node[1] = arg;						//
		fnGetTim = fnGetTim_1node;					//_~[̎擾֐ɒuB_~[̎擾֐(iNode=0)ɑ΂Ď0,(iNode=1)ɑ΂Ď1ԂBقȂ鎞łΉłǂB
		fnGetPos = fnGetPos_1node;					//_~[̍W擾֐ɒuB_~[̍W擾֐͌̍W擾֐(iNode=0)ŒŌĂяolԂB
		nNode = 2;							//ߓ_̐12ɒuB
		arg = arg_1node;						//_~[̍W擾֐(fnGetPos_1node())ւ̃p[^ɒuB
	}
	//Ԃ̐=(ߓ_̐-1)߂B
	nSeg = nNode - 1;
	//ST_NcsSeg\̂̃oCg߂B
	SegBytes = sizeof(ST_NcsSeg) -
	           sizeof(ST_NcsAxs)/*ST_NcsSeg.TBL_Axs[0]̕*/ +
	          (sizeof(ST_NcsAxs) * nAxs);
	//\̂̃mۂB
	pNcsSeq = malloc(sizeof(ST_NcsSeq) -					//SĂ̗vf𖾎IɊi[̂malloc()ō\܂B
	                 sizeof(ST_NcsSeg)/*ST_NcsSeq.TBL_Seg[0]̕*/ +
	                 (SegBytes * nSeg));
	if(!pNcsSeq) { DIE(); }
	//Ō̐ߓ_̎(=Ō̋Ԃ̍ŏI+1)i[B
	pNcsSeq->tEnd = call_fnGetTim(fnGetTim, nSeg/*=(nNode-1)*/, arg);
	//(Ԃ̐-1)i[B
	pNcsSeq->nSeg_1 = nSeg - 1;
	//(̐-1)i[B
	pNcsSeq->nAxs_1 = nAxs - 1;
	//A߂̃mۂB
	A = calloc(sizeof(double) * (nSeg-1) * (nSeg-1), 1);			//IɊi[Ȃvf0.0̂܂܂Ƃ邽߂calloc()K{łB
	if(!A) { DIE(); }
	b = malloc(sizeof(double) * (nSeg-1));					//SĂ̗vf𖾎IɊi[̂malloc()ō\܂B
	if(!b) { DIE(); }
	x = calloc(sizeof(double) * (nSeg+1), 1);				//(x[0]=x[nSeg]=0.0)ŒƂ邽߂calloc()K{łB
	if(!x) { DIE(); }
	//eɂāc
	for(iAxs = 0; iAxs < nAxs; iAxs++) {
#define T(iNode) call_fnGetTim(fnGetTim,(iNode)     ,arg)
#define P(iNode) call_fnGetPos(fnGetPos,(iNode),iAxs,arg)
		//ߓ_ȏȂ΁c
		if(nSeg >= 2) {
			//AB
			for(i = 0; i < (nSeg-1); i++) {			//@AvP[V`fnGetTim()֐Ԃ̒ĺAɂȂĂȂ΂ȂȂBŒ~Ãm[h̎Õm[h̎ƓtsĂBAvP[Ṽf[^oOAAvP[V`fnGetTim()֐̃oO낤B
				const int t01 = T(i+1) - T(i+0);	//	//
				const int t12 = T(i+2) - T(i+1);	//	//
				const int p01 = P(i+1) - P(i+0);	//@	//
				const int p12 = P(i+2) - P(i+1);	//@	//
				if((t01 <= 0) || (t12 <= 0)) { DIE(); }	//	//
				A[(i * (nSeg-1)) + i] = (t01 + t12) * 2;	//͈̔͂͌vZlSĐŏẐŐZőB
				if(i < (nSeg-2)) {				//
					A[((i+0) * (nSeg-1)) + (i+1)] = t12;	//
					A[((i+1) * (nSeg-1)) + (i+0)] = t12;	//
				}						//
				b[i] = (((double)p12 / (double)t12) -		//ZL̂ŎZȂB
				        ((double)p01 / (double)t01)) * 6.0;	//
			}
			solve(A, b, (x+1), (nSeg-1));				//x[0]=x[nSeg]=0.0
		}
		//eԂ̕ԌWi[B
		pNcsSeg = pNcsSeq->TBL_Seg;
		for(i = 0; i < nSeg; i++) {
			const double t01 =   T(i+1) - T(i+0);
			const double a   = ((x[i+1] - x[i+0]) / t01) / 6.0;
			const double b   =            x[i+0]         / 2.0;
			const double c   = ((P(i+1) - P(i+0)) / t01) - ((((x[i+0] * 2.0) + x[i+1]) * t01) / 6.0);
			pNcsSeg->t               = T(i+0);			//uint16_t	㏑Ŋi[Ă܂lȂ̂Ŗ薳B
			pNcsSeg->TBL_Axs[iAxs].a = truncdfhf2(a);		//  fp16
			pNcsSeg->TBL_Axs[iAxs].b = truncdfhf2(b);		//  fp16
			pNcsSeg->TBL_Axs[iAxs].c = truncdfhf2(c);		//  fp16
			pNcsSeg->TBL_Axs[iAxs].d = P(i+0);			// int16_t
			pNcsSeg = (ST_NcsSeg*)((char*)pNcsSeg + SegBytes);
		}
#undef  T
#undef  P
	}
	//A߂̃JB
	free(A);
	free(b);
	free(x);
	return pNcsSeq;
}
/*--------------------------------------------------------------------------*/
void NcsSeq_Free(ST_NcsSeq* pNcsSeq) {
	free(pNcsSeq);
}
/*--------------------------------------------------------------------------*/
static int NcsSeg_compar(const void* x, const void* y) {
//{{2016/09/06ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
//	int t = (int)x;
//2016/09/06ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
#ifndef _WIN64
	int t = (int)x;		//32rbgł́A܂łƕύXL܂B32rbgł64rbgłƓɂĂ͕ςȂ̂łAȌD悵Ă܂ł̂܂܂Ƃ鎖ɂ܂B
#else //_WIN64
	int t = (intptr_t)x;	//64rbgł́A(void*)(64rbg)(int)(32rbg)ɃLXg悤Ƃƌxo܂B̒l32rbg̐p[^Ȃ̂(int)ɃLXgĂSł͂̂łAx邽߂(void*)(64rbg)(intptr_t)(64rbg)ˈÖق(int)(32rbg)ւ̃LXgAƂ菇鎖ɂ܂B
#endif//_WIN64
//}}2016/09/06ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
	const ST_NcsSeg* pNcsSeg = y;
	if(t < pNcsSeg->t) { return -1; }
	if(t > pNcsSeg->t) { return  1; }
	                   { return  0; }
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void NcsSeq_GetVal_subr(const ST_NcsSeq* pNcsSeq, int t, int iAxs, int nVal, int* aVal/*[nVal]*/) {
	int nSeg, nAxs, SegBytes;
	ST_NcsSeg* pNcsSeg;
	ST_NcsAxs* pNcsAxs;
	double a, b, c, dt;
	//Ԃ̐擾B
	nSeg = pNcsSeq->nSeg_1 + 1;
	//̐擾B
	nAxs = pNcsSeq->nAxs_1 + 1;
	//ST_NcsSeg\̂̃oCg߂B
	SegBytes = sizeof(ST_NcsSeg) -
	           sizeof(ST_NcsAxs)/*ST_NcsSeg.TBL_Axs[0]̕*/ +
	          (sizeof(ST_NcsAxs) * nAxs);
	//̎܂ދԂ擾B
	//ŏ̋ԂOȂ΁Aŏ̋ԂɊ܂܂̂ƂB
	//Ō̋ԂȂ΁AŌ̋ԂɊ܂܂̂ƂB
//{{2016/09/06ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
//	pNcsSeg = upper_bound(
//		(void*)t,
//		pNcsSeq->TBL_Seg,
//		nSeg,
//		SegBytes,
//		NcsSeg_compar);
//2016/09/06ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
#ifndef _WIN64
	pNcsSeg = upper_bound(		//32rbgł́A܂łƕύXL܂B32rbgł64rbgłƓɂĂ͕ςȂ̂łAȌD悵Ă܂ł̂܂܂Ƃ鎖ɂ܂B
		(void*)t,
		pNcsSeq->TBL_Seg,
		nSeg,
		SegBytes,
		NcsSeg_compar);
#else //_WIN64
	pNcsSeg = upper_bound(		//64rbgł́A(int)(32rbg)(void*)(64rbg)ɒڃLXg悤Ƃƌxo܂B(int)(32rbg)(intptr_t)(64rbg)(void*)(64rbg)̏ŃLXgΌx͏o܂B
		(void*)(intptr_t)t,
		pNcsSeq->TBL_Seg,
		nSeg,
		SegBytes,
		NcsSeg_compar);
#endif//_WIN64
//}}2016/09/06ύX:(int)l(void*)ɃLXgĐL[ƂĎgpӏŁA64rbgłł̓RpČxoĂ܂B
	if(pNcsSeg > pNcsSeq->TBL_Seg) {
		pNcsSeg = (ST_NcsSeg*)((char*)pNcsSeg - SegBytes);
	}
	//̋Ԃ̊JnAw肳ꂽ܂ł́AΎԂ߂B
	dt = (double)(t - pNcsSeg->t);
	//̋Ԃ́Ae̕ԌWgāANCSԂsB
	if((unsigned)iAxs >= (unsigned)nAxs) { DIE(); }		//(iAxsnAxs)Ȃ΃G[ƂBAvP[VvOsiAxsw肵NcsSeq_GetVal()ĂяoꍇɁAG[Ƃ邽߂̔łB
	nVal = min((unsigned)nVal, (unsigned)(nAxs - iAxs));	//(iAxs+nValnAxs)̓G[ƂnAxs؂l߂BNcsSeq_GetValAll()(nVal=-1)ŌĂяoꂽꍇA(nVal=̐)ɒuď邽߂łB
	pNcsAxs = &pNcsSeg->TBL_Axs[iAxs];
	do {
		a = extendhfdf2(pNcsAxs->a);	//  fp16
		b = extendhfdf2(pNcsAxs->b);	//  fp16
		c = extendhfdf2(pNcsAxs->c);	//  fp16
//{{2016/03/24C:NcsSeq_GetVal_subr()̊ۂߏA+ɕ΂ĂC܂BP0.5𑫂Đ؂̂Ă̂͊ԈႢŁAlĊۂ߂ŝłB
//		*aVal++ = (int)((((a * dt + b) * dt + c) * dt) + 0.5) + pNcsAxs->d;
//		//                                                      ~~~~~~~~~~int16_t
//		//              Z 
//		//        - Z 
//2016/03/24C:NcsSeq_GetVal_subr()̊ۂߏA+ɕ΂ĂC܂BP0.5𑫂Đ؂̂Ă̂͊ԈႢŁAlĊۂ߂ŝłB
//		*aVal++ = lround(((a * dt + b) * dt + c) * dt) + pNcsAxs->d;
//		//                                               ~~~~~~~~~~int16_t
//		//              Z
//		//        Z
//2016/03/28ύX:NcsSeq_GetVal_subr()̒ŁAϘaZfma()g悤ɕύX܂BR[hTCY͂Ɍ܂Bʂ͕ύXOƓłB
		*aVal++ = lround(fma(fma(a, dt, b), dt, c) * dt) + pNcsAxs->d;
		//                                                 ~~~~~~~~~~int16_t
		//              Z
		//        Z
//}}2016/03/28ύX:NcsSeq_GetVal_subr()̒ŁAϘaZfma()g悤ɕύX܂BR[hTCY͂Ɍ܂Bʂ͕ύXOƓłB
		pNcsAxs++;
	} while(--nVal);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int NcsSeq_GetVal(const ST_NcsSeq* pNcsSeq, int t, int iAxs) {
	int iVal;
	NcsSeq_GetVal_subr(pNcsSeq, t, iAxs, 1, &iVal);
	return iVal;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void NcsSeq_GetValAll(const ST_NcsSeq* pNcsSeq, int t, int* aVal/*[nAxs]*/) {
	NcsSeq_GetVal_subr(pNcsSeq, t, 0, -1, aVal);
}
/*--------------------------------------------------------------------------*/
int NcsSeq_GetLen(const ST_NcsSeq* pNcsSeq) {
	return pNcsSeq->tEnd;
}
/****************************************************************************
 *	dNcsSeqC.exeo͂oCi`߂̃[eBeB֐
 ****************************************************************************/
#ifdef  USE_NCSSEQ_BIN
static const ST_NcsSeq* NcsSeqNo_GetNcsSeq(const void* pNcsSeqBin, int iNcsSeqNo) {
	const int* const TBL_NcsSeqNo = pNcsSeqBin;							//oCi̐擪ɃAhXe[uLBAhX̓f[^{(HALFz)̃CfNXłB
	const int nNcsSeqNo = TBL_NcsSeqNo[0];								//AhXe[u̐擪[0]ɗvfĂBvf͂ꎩg([0])܂ށB
	const unsigned short* const TBL_NcsSeq = (const unsigned short*)&TBL_NcsSeqNo[nNcsSeqNo];	//AhXe[u̒ォf[^{(HALFz)JnB
	if((iNcsSeqNo <= 0) || (iNcsSeqNo >= nNcsSeqNo)) { DIE(); }
	return (const ST_NcsSeq*)&TBL_NcsSeq[TBL_NcsSeqNo[iNcsSeqNo]];
}
int NcsSeqNo_GetVal(const void* pNcsSeqBin, int iNcsSeqNo, int t, int iAxs) {
	const ST_NcsSeq* pNcsSeq = NcsSeqNo_GetNcsSeq(pNcsSeqBin, iNcsSeqNo);
	return NcsSeq_GetVal(pNcsSeq, t, iAxs);
}
void NcsSeqNo_GetValAll(const void* pNcsSeqBin, int iNcsSeqNo, int t, int* aVal/*[nAxs]*/) {
	const ST_NcsSeq* pNcsSeq = NcsSeqNo_GetNcsSeq(pNcsSeqBin, iNcsSeqNo);
	NcsSeq_GetValAll(pNcsSeq, t, aVal);
}
int NcsSeqNo_GetLen(const void* pNcsSeqBin, int iNcsSeqNo) {
	const ST_NcsSeq* pNcsSeq = NcsSeqNo_GetNcsSeq(pNcsSeqBin, iNcsSeqNo);
	return NcsSeq_GetLen(pNcsSeq);
}
#endif//USE_NCSSEQ_BIN
