/*
 *	clipht2.h
 *
 *	2D蔻胋[``܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2006 Naoyuki Sawa
 *
 *	* Sun Oct 08 13:37:42 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Oct 17 03:32:53 JST 2006 Naoyuki Sawa
 *	- SRT\̂ƁAht2_srt_pgn()ǉ܂B
 *	- ht2_pt_pgn()ht2_pgn_pgn()ɂāAp`̒_0Ȃ΁A蔻薳ƌȂ悤ύX܂B
 *	  ܂ł́Ap`̒_1ȏłȂ΂Ȃ炸A_0w肷Ɛ삵ȂdlłB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_HT2_H__
#define __CLIP_HT2_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/*****************************************************************************
 *	
 *****************************************************************************/

/* gkE]Esړʂi[邽߂̍\̂łB
 * - ht2_srt_pgn()ɑ΂AgkE]Esړʂw邽߂ɗpӂ܂A
 *   Ɍ炸AgkE]Esړʂi[Aʗprɗp邱Ƃł܂B
 * - Q[LN^Ȃǂ̍\̂ɂāAgkE]EsړʂSRT\̂Ɋi[Ă΁A
 *   ̂܂ht2_srt_pgn()ɈnƂłASRT\̂쐬KvAIłB
 */
typedef struct _SRT {
	fixed x;	/* Translate X */
	fixed y;	/* Translate Y */
	fixed r;	/* Rotate */
	fixed s;	/* Scale */
} SRT;

/*****************************************************************************
 *	
 *****************************************************************************/

/* ABƐCĎs܂B
 * [in]
 *	(ax,ay)		AB̎n_WB
 *	(bx,by)		AB̏I_WB
 *	(cx,cy)		CD̎n_WB
 *	(dx,dy)		CD̏I_WB
 * [out]
 *	߂l		Ă΁A0ȊOԂ܂B
 *			ĂȂ΁A0Ԃ܂B
 * [note]
 *	* ̐̒[_A̐̂傤ǐɗLꍇAƔf܂B
 *	* _AƓ_BWłĂA삵܂B
 *	  _CƓ_DWłĂA삵܂B
 *	  ̏ꍇA_ƐA܂́A_Ɠ_̏dȂ蔻ƂȂ܂B(ASY͓ł)
 */
int ht2_seg_seg(fixed ax, fixed ay, fixed bx, fixed by, fixed cx, fixed cy, fixed dx, fixed dy);

/* _p`̓ɂ邩s܂B
 * [in]
 *	(px,py)		_̍WB
 *	pgn[n][2]	p`̒_WzB
 *	n		p`̒_B(n>=0)
 *			p`̒_0Ȃ΁A蔻薳ƌȂ܂B(2006/10/17ǉ)
 * [out]
 *	߂l		Ȃ΁A0ȊOԂ܂B
 *			OȂ΁A0Ԃ܂B
 * [note]
 *	* _p`̂傤ǕӏA܂́A傤ǒ_ɗLꍇAƔf܂B
 *	* p`A_(n=1)(n=2)łĂA삵܂B
 */
int ht2_pt_pgn(fixed px, fixed py, const fixed pgn[/*n*/][2/*x,y*/], int n);

/* p`m̌s܂B
 * [in]
 *	a[n][2]		p`A̒_WzB
 *	na		p`A̒_B(na>=0)
 *			p`̒_0Ȃ΁A蔻薳ƌȂ܂B(2006/10/17ǉ)
 *	b[n][2]		p`B̒_WzB
 *	nb		p`B̒_B(nb>=0)
 *			p`̒_0Ȃ΁A蔻薳ƌȂ܂B(2006/10/17ǉ)
 * [out]
 *	߂l		Ă΁A0ȊOԂ܂B
 *			ĂȂ΁A0Ԃ܂B
 * [note]
 *	* p`mAӂƕӁAӂƒ_A_ƒ_ŐڐGĂꍇAƔf܂B
 *	* p`A_(n=1)(n=2)łĂA삵܂B
 */
int ht2_pgn_pgn(const fixed a[/*na*/][2/*x,y*/], int na, const fixed b[/*nb*/][2/*x,y*/], int nb);

/* p`AgkE]Esړ܂B
 * [in]
 *	srt		gkE]EsړʁB
 *	pgn_in		ό`̑p`B
 *	pgn_out		ό`̑p`i[obt@B
 *	n		p`̒_B(n>=0)
 * [note]
 *	* 蔻p̑p`ALN^̊gkE]Esړɍ킹ĕό`邽߂ɗpӂ܂A
 *	  蔻pȊÖʓIȗprŁAp`gkE]Esړ邽߂ɗp邱Ƃł܂B
 *	* pgn_in==pgn_outłĂ삵܂B(GCAXZ[t)
 *	  ۂɂ́Apgn_in͒萔̈̑p``wApgn_out͕ϐ̈̃obt@wł傤A
 *	  pgn_in==pgn_outƂȂ邱Ƃ́A܂AƎv܂B
 */
void ht2_srt_pgn(const SRT* srt, const fixed pgn_in[/*n*/][2/*x,y*/], fixed pgn_out[/*n*/][2/*x,y*/], int n);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_HT2_H__*/
