/*	
 *	clipeth.h
 *
 *	P/ECE USB Ethernet (DIX Ethernet Ver2.0)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Tue Aug 23 04:43:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_ETH_H__
#define __CLIP_ETH_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/*****************************************************************************
 *	
 *****************************************************************************/

/*  ==================[ DIX Ethernet Ver2.0 ڰэ\ ]====================
 *
 *           |<---- NDIS߰ײނ (60-1514 byte) ---->|
 *           |                                                     |
 *  +--------+-------------+-------------+--------+----------------+-----+
 *  | 8 byte |    6 byte   |    6 byte   | 2 byte |  46-1500 byte  |4byte|
 *  +--------+-------------+-------------+--------+----------------+-----+
 *  |        |Đ       |M       |        |                |     |
 *  |ر|Ethernetڽ|Ethernetڽ|ڰ|      ް      | FCS |
 *  +--------+-------------+-------------+--------+----------------+-----+
 *       A                                                            A
 *       |                                                            |
 *       +- NICʰ޳t/̂Ťײ޿ĳł͍lȂ -+
 */

/****************************************************************************
 *	
 ****************************************************************************/

#define ETHERNET_PRODUCT_ID	(PCE_PRODUCT_ID+0x16)	/* d֎~!! */

/* AhX
 * * "Null Address"̖̂́AToken-Ringpꂩؗp܂B[http://www.techfest.com/networking/lan/token.htm] (2005/08/26)
 *   -----------------------------------------------------------------------------------------------------------------------
 *   2.6.4 Null Address
 *     The Individual Address x'00 00 00 00 00 00' is known as a "Null Address".
 *     No station shall be assigned the Null Address and frames addressed to the Null Address are not expected to be copied.
 *   -----------------------------------------------------------------------------------------------------------------------
 */
extern const unsigned char ethernet_null_address[6];		/* 00-00-00-00-00-00 */

/* u[hLXgAhX */
extern const unsigned char ethernet_broadcast_address[6];	/* FF-FF-FF-FF-FF-FF */

/****************************************************************************
 *	
 ****************************************************************************/

typedef struct _ETHERNETCLIENT ETHERNETCLIENT;

/* ETHERNETCLIENT.recv : MR[obÑvg^Cv */
typedef void ETHERNETRECV(ETHERNETCLIENT* client,
	const unsigned char* address/*[6]*/,	/* MEthernetAhX       (       6oCg) */
	const unsigned char* data/*[length]*/,	/* Ethernett[̃f[^ (46..1500oCg) */
	int length);				/* Ethernett[̃f[^   (46..1500      ) */

/* ETHERNETCLIENT.conf : ݒύXR[obÑvg^Cv */
typedef void ETHERNETCONF(ETHERNETCLIENT* client);

/* NCAgo^p̍\ */
/*typedef*/ struct _ETHERNETCLIENT {

	/*--------------------------------------------------------------------------------------*
	 *	ethernet_open()ĂяoOɁAAvP[VɂĐݒ肵ĂtB[hB	*
	 *	ethernet_open()ĂяóAύXĂ͂ȂB				*
	 *--------------------------------------------------------------------------------------*/

	int type;		/* t[^Cv  (0x0600..0xffff) */
	ETHERNETRECV* recv;	/* MR[obN (NULL:) */
	ETHERNETCONF* conf;	/* ݒύXR[obN (NULL:) */

	/*--------------------------------------------------------------------------------------*
	 *	EthernethCoAŎgptB[hB					*
	 *	AvP[V́Aȉ̃tB[hɃANZXĂ͂ȂB			*
	 *--------------------------------------------------------------------------------------*/

	LIST_ENTRY list_entry;	/* NCAgXg */

} /*ETHERNETCLIENT*/;

/****************************************************************************
 *	
 ****************************************************************************/

/* USB EthernetJn܂B
 * [in]
 *	txque_capacity	ML[̋eʁB
 *			//őEthernett[1i[邽߂ɕKvȃL[̋eʂ́A(sizeof(int)+1514)łB
 *			//txque_capacity(sizeof(int)+1514)w肵ꍇ́A(sizeof(int)+1514)֐؂グĊmۂ܂B
 *			//2005/09/16 create_queue()Öقsizeof(int)Z悤dlύXƂɒǏ]܂B
 *			őEthernett[1i[邽߂ɕKvȃL[̋eʂ́A1514łB
 *			txque_capacity1514w肵ꍇ́A1514֐؂グĊmۂ܂B
 * [note]
 *	* ethernet_start()ĂяoAvP[V́AIOɕKAethernet_stop()ĂяoĂB
 *	  ethernet_stop()ĂяoɃAvP[VIƁAP/ECEVXeُ퓮N܂B
 *	* ethernet_open()ĂяoăNCAgo^OɁAKAethernet_start()ĂяoĂB
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	~
 */
void ethernet_start(int txque_capacity);

/* USB Ethernet~܂B
 * [note]
 *	* ethernet_stop()́AɈSɌĂяo\łB
 *	  ethernet_start()ĂяoĂȂĂAłAłAethernet_stop()Ăяoč\܂B
 *	* ethernet_stop()ĂяoƁAo^ĂNCAǵAIɂׂēo^܂B
 *	  ethernet_stop()ĂяoOɁAX̃NCAgAIɓo^Kv͂܂B
 *	  ܂Aethernet_stop()ĂяoɁAethernet_close()ĂяoĂ͂܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	~
 */
void ethernet_stop();

/* ̃t[^CvANCAgo^܂B
 * [in]
 *	client		ĂяoɂĊmۂANCAgo^p̍\́B
 *			etB[hA炩ߓK؂ɏĂĂB
 * [note]
 *	* t[^Cv̒ĺA0x0600ȏƒ߂Ă܂B(DIX Ethernet Ver2.0dl)
 *	  ETHERNETCLIENT.typeɁA0x0600̒lw肵ČĂяoƁAG[I܂B
 *	* t[^CvNCAgAɓȏo^悤ƂƁAG[I܂B
 *	* NCAgo^p̍\̂́AEthernethCõXgɃN܂B
 *	  ethernet_close()Ăяoēo^܂ŁA\̂JĂ͂܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	@\AȂ
 */
void ethernet_open(ETHERNETCLIENT* client);

/* o^ς݃NCAgAo^܂B
 * [in]
 *	client		o^ς݃NCAg̍\́B
 * [note]
 *	* o^̃NCAgo^悤ƂƁAG[I܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	@\AȂ
 */
void ethernet_close(ETHERNETCLIENT* client);

/* Ethernett[𑗐M܂B
 * [in]
 *	client		o^ς݃NCAg̍\́B
 *	address		ĐEthernetAhXB      (      6oCg)
 *	data		Ethernett[̃f[^B(0..1500oCg)
 *	length		Ethernett[̃f[^B  (0..1500      )
 * [out]
 *	߂l		Ȃ΁Af[^(length̒l)̂܂ܕԂ܂B(0A܂́A)
 *			ML[ςőMłȂꍇAԂ܂B
 * [note]
 *	* Ethernet̍őt[́A1514ȉ(f[^1500ȉ)łB
 *	  1500oCg𒴂f[^𑗐M悤ƂƁAG[I܂B
 *	* Ethernet̍ŏt[́A60ȏ(f[^46ȏ)łB
 *	  f[^46̒lw肵ꍇAIɍŏf[^܂ŃpfBOđo܂B
 *	  ĂяoɂāAIȃpfBOsKv͂܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
int ethernet_send(ETHERNETCLIENT* client, const unsigned char* address/*[6]*/, const void* data/*[length]*/, int length);

/* EthernetAhXݒ肵܂B(gp)
 * [in]
 *	address		EthernetAhXB
 * [note]
 *	* P/ECEEthernetAhX́APCfoCXhCoAVendorRequestɂĎIɐݒ肳܂B
 *	  ̊֐́A{IɁAVendorRequest̂ݗp܂B
 *	  AvP[VvOAʃvgRhCoڗp邱Ƃ́AʏA͂łB
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
void ethernet_set_address(const unsigned char* address/*[6]*/);

/* EthernetAhX擾܂B
 * [in]
 *	address		EthernetAhX󂯎A6oCg̃obt@B
 * [note]
 *	* P/ECEEthernetAhX́APCfoCXhCoAVendorRequestɂĎIɐݒ肳܂B
 *	  ethernet_start()́A^COɂA܂VendorRequestsĂ܂B
 *	  ethernet_start()́AEthernetAhXȂƂɒӂĂB
 *	* PCfoCXhCo̒~EĊJɂACӂ̃^C~OEthernetAhXĐݒ肳܂B
 *	  P/ECEEthernetAhX͌ŒłȂACӂ̃^C~Oŕω̂ƍlĂB
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
void ethernet_get_address(unsigned char* address/*[6]*/);

/* USB Ethernet̏Ԃ擾܂B
 * [in]
 *	stat		ʂi[ETHERNETSTAT\̂ւ̃|C^B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
typedef struct _ETHERNETSTAT {
	int reset;	/* oXZbg */
	int rxok;	/* Mt[ */
	int rxerr;	/* MG[̃t[ */
	int txok;	/* Mt[ */
	int txerr;	/* MG[̃t[ (ethernet_send()̑MI[o[񐔂ł) */
} ETHERNETSTAT;
void ethernet_stat(ETHERNETSTAT* stat);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_ETH_H__*/
