#include <clip.h>

/***************************************************************************/
/* DO change */

#define BUFLEN		320
#define INIT()		ym2612_init(&ym2612, (53693100 / 7));

/***************************************************************************/
/* do NOT change */

#define NWHDR		8	/* ȏ㑝₷waveOutWriteŃG[ɂȂ݂ */
HWAVEOUT g_wout;
WAVEFORMATEX g_fmt;
WAVEHDR g_whdr[NWHDR];
short g_wbuff[NWHDR][BUFLEN];
YM2612 ym2612;

/***************************************************************************/

void CALLBACK
waveOutProc(HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2)
{
	static int I;
	int retval;

	if(uMsg != WOM_DONE) return;

	ym2612_mix(&ym2612, g_wbuff[I], BUFLEN);
	retval = waveOutWrite(hwo, &g_whdr[I], sizeof g_whdr[I]);
	if(retval != 0) {
		memset(g_wbuff[I], 0, sizeof(short) * BUFLEN);
	}
	assert(retval == 0);

	I = (I + 1) % NWHDR;
}

int
main()
{
	int retval;
	int i;

	/* init YM2612 */
	INIT();

	/* init stream */
	memset(&g_fmt, 0, sizeof g_fmt);
	g_fmt.wFormatTag = WAVE_FORMAT_PCM;
	g_fmt.nChannels = 1;
	g_fmt.nSamplesPerSec = 16000;
	g_fmt.nAvgBytesPerSec = 16000 * 2;
	g_fmt.nBlockAlign = 2;
	g_fmt.wBitsPerSample = 16;
	retval = waveOutOpen(&g_wout, WAVE_MAPPER, &g_fmt, (DWORD)waveOutProc, 0, CALLBACK_FUNCTION);
	assert(retval == 0);
	for(i = 0; i < NWHDR; i++) {
		memset(&g_whdr[i], 0, sizeof g_whdr[i]);
		g_whdr[i].lpData = (char*)g_wbuff[i];
		g_whdr[i].dwBufferLength = sizeof g_wbuff[i];
		retval = waveOutPrepareHeader(g_wout, &g_whdr[i], sizeof g_whdr[i]);
		assert(retval == 0);
	}

#define B	4
#define TONE1	617
#define TONE2	777
#define TONE3	924
#define TONE4	1164
#define AR	10
#define DR	12
#define SR	12
#define TL	0
#define SL	8
#define FB	1
#define ALG	1

#if 1
	ym2612_write_reg(&ym2612, 0, 0x30, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x34, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x38, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x3c, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x40, TL);				// TL
	ym2612_write_reg(&ym2612, 0, 0x44, TL);				// TL
	ym2612_write_reg(&ym2612, 0, 0x48, TL);				// TL
	ym2612_write_reg(&ym2612, 0, 0x4c, 0);				// TL
	ym2612_write_reg(&ym2612, 0, 0x50, AR);				// AR
	ym2612_write_reg(&ym2612, 0, 0x54, AR);				// AR
	ym2612_write_reg(&ym2612, 0, 0x58, AR);				// AR
	ym2612_write_reg(&ym2612, 0, 0x5c, 15);				// AR
	ym2612_write_reg(&ym2612, 0, 0x60, DR);				// DR
	ym2612_write_reg(&ym2612, 0, 0x64, DR);				// DR
	ym2612_write_reg(&ym2612, 0, 0x68, DR);				// DR
	ym2612_write_reg(&ym2612, 0, 0x6c, 0);				// DR
	ym2612_write_reg(&ym2612, 0, 0x70, SR);				// SR
	ym2612_write_reg(&ym2612, 0, 0x74, SR);				// SR
	ym2612_write_reg(&ym2612, 0, 0x78, SR);				// SR
	ym2612_write_reg(&ym2612, 0, 0x7c, 0);				// SR
	ym2612_write_reg(&ym2612, 0, 0x80, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 0, 0x84, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 0, 0x88, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 0, 0x8c, 0);				// SL
	ym2612_write_reg(&ym2612, 0, 0xa0, LOBYTE(TONE1));		// F-number
	ym2612_write_reg(&ym2612, 0, 0xa4, HIBYTE(TONE1) | (B << 3));	// F-number, Block
	ym2612_write_reg(&ym2612, 0, 0xb0, (FB << 3) | ALG);		// Feedback, Algorithm */
	ym2612_write_reg(&ym2612, 0, 0x28, 0xf0);			// Key on
#if 0
	ym2612_write_reg(&ym2612, 0, 0x31, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x35, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x39, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x3d, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x41, TL);				// TL
	ym2612_write_reg(&ym2612, 0, 0x45, TL);				// TL
	ym2612_write_reg(&ym2612, 0, 0x49, TL);				// TL
	ym2612_write_reg(&ym2612, 0, 0x4d, 0);				// TL
	ym2612_write_reg(&ym2612, 0, 0x81, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 0, 0x85, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 0, 0x89, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 0, 0x8d, 0);				// SL
	ym2612_write_reg(&ym2612, 0, 0xa1, LOBYTE(TONE2));		// F-number
	ym2612_write_reg(&ym2612, 0, 0xa5, HIBYTE(TONE2) | (B << 3));	// F-number, Block
	ym2612_write_reg(&ym2612, 0, 0xb1, (FB << 3) | ALG);		// Feedback, Algorithm */
	ym2612_write_reg(&ym2612, 0, 0x28, 0xf1);			// Key on

	ym2612_write_reg(&ym2612, 0, 0x32, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x36, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x3a, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x3e, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x42, TL);				// TL
	ym2612_write_reg(&ym2612, 0, 0x46, TL);				// TL
	ym2612_write_reg(&ym2612, 0, 0x4a, TL);				// TL
	ym2612_write_reg(&ym2612, 0, 0x4e, 0);				// TL
	ym2612_write_reg(&ym2612, 0, 0x82, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 0, 0x86, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 0, 0x8a, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 0, 0x8e, 0);				// SL
	ym2612_write_reg(&ym2612, 0, 0xa2, LOBYTE(TONE3));		// F-number
	ym2612_write_reg(&ym2612, 0, 0xa6, HIBYTE(TONE3) | (B << 3));	// F-number, Block
	ym2612_write_reg(&ym2612, 0, 0xb2, (FB << 3) | ALG);		// Feedback, Algorithm */
	ym2612_write_reg(&ym2612, 0, 0x28, 0xf2);			// Key on

	ym2612_write_reg(&ym2612, 1, 0x30, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x34, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x38, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x3c, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x40, TL);				// TL
	ym2612_write_reg(&ym2612, 1, 0x44, TL);				// TL
	ym2612_write_reg(&ym2612, 1, 0x48, TL);				// TL
	ym2612_write_reg(&ym2612, 1, 0x4c, 0);				// TL
	ym2612_write_reg(&ym2612, 1, 0x80, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 1, 0x84, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 1, 0x88, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 1, 0x8c, 0);				// SL
	ym2612_write_reg(&ym2612, 1, 0xa0, LOBYTE(TONE1));		// F-number
	ym2612_write_reg(&ym2612, 1, 0xa4, HIBYTE(TONE1) | (B << 3));	// F-number, Block
	ym2612_write_reg(&ym2612, 1, 0xb0, (FB << 3) | ALG);		// Feedback, Algorithm */
	ym2612_write_reg(&ym2612, 0, 0x28, 0xf4);			// Key on

	ym2612_write_reg(&ym2612, 1, 0x31, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x35, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x39, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x3d, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x41, TL);				// TL
	ym2612_write_reg(&ym2612, 1, 0x45, TL);				// TL
	ym2612_write_reg(&ym2612, 1, 0x49, TL);				// TL
	ym2612_write_reg(&ym2612, 1, 0x4d, 0);				// TL
	ym2612_write_reg(&ym2612, 1, 0x81, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 1, 0x85, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 1, 0x89, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 1, 0x8d, 0);				// SL
	ym2612_write_reg(&ym2612, 1, 0xa1, LOBYTE(TONE2));		// F-number
	ym2612_write_reg(&ym2612, 1, 0xa5, HIBYTE(TONE2) | (B << 3));	// F-number, Block
	ym2612_write_reg(&ym2612, 1, 0xb1, (FB << 3) | ALG);		// Feedback, Algorithm */
	ym2612_write_reg(&ym2612, 0, 0x28, 0xf5);			// Key on

	ym2612_write_reg(&ym2612, 1, 0x32, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x36, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x3a, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x3e, 1);				// MUL
	ym2612_write_reg(&ym2612, 1, 0x42, TL);				// TL
	ym2612_write_reg(&ym2612, 1, 0x46, TL);				// TL
	ym2612_write_reg(&ym2612, 1, 0x4a, TL);				// TL
	ym2612_write_reg(&ym2612, 1, 0x4e, 0);				// TL
	ym2612_write_reg(&ym2612, 1, 0x82, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 1, 0x86, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 1, 0x8a, SL << 4);			// SL
	ym2612_write_reg(&ym2612, 1, 0x8e, 0);				// SL
	ym2612_write_reg(&ym2612, 1, 0xa2, LOBYTE(TONE3));		// F-number
	ym2612_write_reg(&ym2612, 1, 0xa6, HIBYTE(TONE3) | (B << 3));	// F-number, Block
	ym2612_write_reg(&ym2612, 1, 0xb2, (FB << 3) | ALG);		// Feedback, Algorithm */
	ym2612_write_reg(&ym2612, 0, 0x28, 0xf6);			// Key on
#endif
#else
	ym2612_write_reg(&ym2612, 0, 0x27, 0x40);			// Ch3 mode
	ym2612_write_reg(&ym2612, 0, 0x32, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x36, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x3a, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x3e, 1);				// MUL
	ym2612_write_reg(&ym2612, 0, 0x42, 0);				// TL
	ym2612_write_reg(&ym2612, 0, 0x46, 0);				// TL
	ym2612_write_reg(&ym2612, 0, 0x4a, 0);				// TL
	ym2612_write_reg(&ym2612, 0, 0x4e, 0);				// TL
	ym2612_write_reg(&ym2612, 0, 0x82, 0);				// SL
	ym2612_write_reg(&ym2612, 0, 0x86, 0);				// SL
	ym2612_write_reg(&ym2612, 0, 0x8a, 0);				// SL
	ym2612_write_reg(&ym2612, 0, 0x8e, 0);				// SL
	ym2612_write_reg(&ym2612, 0, 0xa2, LOBYTE(TONE3));		// F-number
	ym2612_write_reg(&ym2612, 0, 0xa6, HIBYTE(TONE3) | (B << 3));	// F-number, Block
	ym2612_write_reg(&ym2612, 0, 0xa8, LOBYTE(TONE1));		// F-number
	ym2612_write_reg(&ym2612, 0, 0xac, HIBYTE(TONE1) | (B << 3));	// F-number, Block
	ym2612_write_reg(&ym2612, 0, 0xa9, LOBYTE(TONE2));		// F-number
	ym2612_write_reg(&ym2612, 0, 0xad, HIBYTE(TONE2) | (B << 3));	// F-number, Block
	ym2612_write_reg(&ym2612, 0, 0xaa, LOBYTE(TONE4));		// F-number
	ym2612_write_reg(&ym2612, 0, 0xae, HIBYTE(TONE4) | (B << 3));	// F-number, Block
	ym2612_write_reg(&ym2612, 0, 0xb2, (FB << 3) | /*ALG*/7);	// Feedback, Algorithm */
	ym2612_write_reg(&ym2612, 0, 0x28, 0xf2);			// Key on
#endif


	/* start playing */
	for(i = 0; i < NWHDR; i++) {
		retval = waveOutWrite(g_wout, &g_whdr[i], sizeof g_whdr[i]);
		assert(retval == 0);
	}
	Sleep(INFINITE);

	return 0;
}

