#include <stdio.h>
#include <stdlib.h>

void make_table(int bits, int tap1, int tap2);

int
main()
{
	make_table( 4, 0, 3);
	make_table( 5, 0, 3);
	make_table( 9, 0, 4);
	make_table(17, 0, 5);
}

void
make_table(int bits, int tap1, int tap2)
{
	int count = (1 << bits) - 1;
	int size  = (count + 7) / 8;
	int v = 1;
	int i = 0;
	unsigned char* table;

	table = (unsigned char*)calloc(size, 1);
	if(!table) abort();

	printf("/* [%dbit tap=%#x] */\n", bits, (1 << tap1) | (1 << tap2));
	printf("const unsigned char pokey_lfsr_table%d[%#x/*output=%#x[bits],padding=%d[bits]*/] = {\n", bits, size, count, size * 8 - count);

	for(;;) {
		table[i / 8] |= (v & 1) << (i & 7);
		i++;
		//
		v = (v >> 1) |
		    ((v >> tap1 & 1) ^ (v >> tap2 & 1)) << (bits - 1);
		if(v == 1) break;
	}
	if(i != count) abort(); /* ^bvʒus */

	for(i = 0; i < size; i++) {
		printf("'\\x%02x',", table[i]);
		if((i & 15) == 15) printf("\n");
	}

	if(i & 15) printf("\n");
	printf("};\n");

	free(table);
}
