/*	
 *	clipz80.c
 *
 *	P/ECE Z80 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Thu Nov 27 06:00:00 JST 2003 Naoyuki Sawa
 *	- 荞݃[h0ɑΉ܂B
 *	* Fri Jan 07 18:20:00 JST 2005 Naoyuki Sawa
 *	- INTvۗ̕ɑΉ܂B
 *	  IFF=0̊ԂINTv𔭍sƂۗAIFF=1ɂȂƂɎs܂B
 *	  pɂDI/EIJԂvOŁA܂łINTṽ^C~O킸ɖĂ悤ȏ󋵂łA
 *	  ̕ύXɂAINTv󂯕t悤ɂȂ܂B
 *	- 2005/01/07݁A}XJu荞ݗvۗ̕ĂCPUG~[VW[́A̒ʂłB
 *		Z80
 *		M6800
 *		M6809
 *		HuC6280
 *	- 2005/01/07݁AȉCPUG~[VW[̓}XJu荞ݗvۗ̕܂Ă܂B
 *		MOS6502
 *		S-SMP(SPC700) ()
 *		DMG-CPU(LR35902)
 *	  MOS6502 G~[VW[͍pƎv̂ŁA܂݂Ċ荞ݗvۗ̕@\ǉ\łB
 *	  S-SMPJX^CPÚASPC700RA犄荞݋@\ȗĂ̂ŁA荞ݗvۗ̕Kv͂܂B
 *	  DMG-CPÚAGBSG~[Vɂ͊荞ݕsvȂ̂œʕKv܂񂪁Aǂm܂B
 *	  2005/02/15ǋL:DMG-CPŮ荞ݕۗɑΉ܂B
 */
#include "clip.h"
#include "clipz80i.h"	/*Z80G~[^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	IyR[h}bv
 */
const Z80OP z80_op_table[256/*XX*/] = {
#include "z80/xx.h" /* [z80.xls]XX */
};
const Z80OP z80_op_table_CB[256/*XX*/] = {
#include "z80/cb.h" /* [z80.xls]CB */
};
const Z80OP z80_op_table_ED[256/*XX*/] = {
#include "z80/ed.h" /* [z80.xls]ED */
};
const Z80OP z80_op_table_DD[256/*XX*/] = {
#include "z80/dd.h" /* [z80.xls]DD */
};
const Z80OP z80_op_table_FD[256/*XX*/] = {
#include "z80/fd.h" /* [z80.xls]FD */
};
const Z80OP z80_op_table_DDCB[256/*XX*/] = {
#include "z80/ddcb.h" /* [z80.xls]DDCB */
};
const Z80OP z80_op_table_FDCB[256/*XX*/] = {
#include "z80/fdcb.h" /* [z80.xls]FDCB */
};

/*
 *	j[jbNe[u
 */
#undef Z80FN_
#define Z80FN_(OP, FN)	OP "\0"
const char z80_op_name_table[] = {
	"\0" /* ItZbg0̓k */
#include "z80/list.h" /* [z80.xls]List!C10 */
};
#undef Z80FN_

/****************************************************************************
 *	
 ****************************************************************************/

/*
 *	lpeBtOϊe[u
 */
const unsigned char z80_PARITY[256] = { /* Z80͋peBł */
	4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,
	0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,
	0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,
	4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,
	0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,
	4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,
	4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,
	0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,
};

/****************************************************************************
 *	
 ****************************************************************************/

unsigned char
z80_internal_in(Z80* z80, unsigned short addr)
{
	return -1;
}

void
z80_internal_out(Z80* z80, unsigned short addr, unsigned char data)
{
	/** no job **/
}

void
z80_check_pending(Z80* z80)
{
	/* 荞݋֎~ȂΉ܂B */
	if(!IFF1) return;

	/* INTvۗĂȂΉ܂B */
	if(!PENDING) return;

	/* INTvۗ̕NA܂B */
	PENDING = 0;

	/* }XJu荞݂֎~܂B */
	IFF1 = IFF2/*dl*/ = 0;

	/* 荞ݔɂAHALT܂B */
	HALT = 0;

	/* 荞݂s܂B */
	PUSH(PC);
	switch(IM) {
	case 0: /* IM 0 */
		switch(PENDING_NO) {
		case 0xc7: PC = 0x00; break; /* RST 00H */
		case 0xcf: PC = 0x08; break; /* RST 08H */
		case 0xd7: PC = 0x10; break; /* RST 10H */
		case 0xdf: PC = 0x18; break; /* RST 18H */
		case 0xe7: PC = 0x20; break; /* RST 20H */
		case 0xef: PC = 0x28; break; /* RST 28H */
		case 0xf7: PC = 0x30; break; /* RST 30H */
		case 0xff: PC = 0x38; break; /* RST 38H */
		default: DIE();
		}
		break;
	case 1: /*  */
		DIE();
	case 2: /* IM 1 */
		PC = 0x38;
		break;
	case 3: /* IM 2 */
		DIE(); /* TODO:Ή */
	default:
		DIE();
	}
}

/****************************************************************************
 *
 ****************************************************************************/

void
z80_reset(Z80* z80, Z80READPROC* read, Z80WRITEPROC* write, Z80INPROC* in, Z80OUTPROC* out)
{
	memset(z80, 0, sizeof(Z80));
	z80->read  = read  ? read  : z80_internal_read;
	z80->write = write ? write : z80_internal_write;
	z80->in    = in    ? in    : z80_internal_in;
	z80->out   = out   ? out   : z80_internal_out;
}

void
z80_int(Z80* z80, unsigned char no)
{
	/* AINTvۗĂ܂B */
	PENDING = 1;
	PENDING_NO = no;

	/* 荞݋Ȃ΁AɎ󂯕t܂B */
	z80_check_pending(z80);
}

void
z80_nmi(Z80* z80)
{
	/* }XJu荞݂̋Ԃޔ܂B */
	IFF2 = IFF1;

	/* }XJu荞݂֎~܂B */
	IFF1 = 0;

	/* 荞ݔɂAHALT܂B */
	HALT = 0;

	/* 荞݂s܂B */
	PUSH(PC);
	PC = 0x66;
}

void
z80_dump(Z80* z80)
{
#define INDENT	40
	TRACE("%*s", INDENT, "");
	TRACE("F :%c%c%c%c%c%c%c%c A :%02x BC :%04x DE :%04x HL :%04x IX:%04x IY:%04x SP:%04x PC:%04x\n",
		F & (1 << 7) ? 'S' : '-',
		F & (1 << 6) ? 'Z' : '-',
		F & (1 << 5) ? 'X' : '-',
		F & (1 << 4) ? 'H' : '-',
		F & (1 << 3) ? 'X' : '-',
		F & (1 << 2) ? 'V' : '-',
		F & (1 << 1) ? 'N' : '-',
		F & (1 << 0) ? 'C' : '-',
		A, BC, DE, HL, IX, IY, SP, PC);
	TRACE("%*s", INDENT, "");
	TRACE("F':%c%c%c%c%c%c%c%c A':%02x BC':%04x DE':%04x HL':%04x R:%02x I:%02x IFF1:%02x IFF2:%02x IM:%02x\n",
		F2 & (1 << 7) ? 'S' : '-',
		F2 & (1 << 6) ? 'Z' : '-',
		F2 & (1 << 5) ? 'X' : '-',
		F2 & (1 << 4) ? 'H' : '-',
		F2 & (1 << 3) ? 'X' : '-',
		F2 & (1 << 2) ? 'V' : '-',
		F2 & (1 << 1) ? 'N' : '-',
		F2 & (1 << 0) ? 'C' : '-',
		A2, BC2, DE2, HL2, I, R, IFF1, IFF2, IM);
#undef INDENT
}

/****************************************************************************
 *
 ****************************************************************************/

#ifdef PIECE

asm("
	.code
	.global z80_run2
z80_run2:
	pushn %r0
	ld.w %r0, %sp		; X^bNޔ
	xld.w %r10, 0x1000	; 0x0e00`0x1000ɃX^bNؑ
	ld.w %sp, %r10
	xcall z80_run
	ld.w %sp, %r0		; X^bN
	popn %r0
	ret
");

#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

