/*	
 *	clipsp2.h
 *
 *	P/ECE SPC Driver V2
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Oct 07 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_SP2_H__
#define __CLIP_SP2_H__

/* * ֘At@Cꗗ
 * - clipsp2.h	Cwb_t@CłB(̃t@C)
 * - clipsp2a.h	bEAZuɃCN[hwb_t@CłB
 * - clipsp2b.h	AZu\[XCN[hwb_t@CłB
 * - clipsp2.c	SPC Driver V2 CłB
 * - clipsp2c.c	S-CPU(TEhCPUESPC700JX^)CłB
 * - clipsp2d.c	S-DSP(TEhDSP)CłB
 * - clipsp2a.s	RAMɓ]ȂAAZułB
 * - framsp2a.s	RAMɓ]AAZułB
 * - (ȉAKvɉĒǉ\ł)
 */

// SPC2_DEBUGV{`ƁAfobO[`𐶐܂B
// SPC2_TRACEV{`ƁAg[X[`𐶐܂B
// !! AZupvvZbT(pp33.exe)ł̓lXg#ifdefgȂ߁A
//        AZu\[X̃g[X[`͎蓮ŗL/ĂB
//        AZu\[X̃g[X[`;;{{SPC2_TRACE`;;}}SPC2_TRACEň͂Ă܂B
//        ȂA2004/10/18݁AAZu\[XɃfobO[`͂܂B
///#define SPC2_DEBUG
///#define SPC2_TRACE

/* SPC2_ASMV{`ǂݍ݂܂B
 * SPC2_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipsp2a.h"

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef SPC2_ASM
#endif /*PIECE*/

/****************************************************************************
 *	SPC2CPU
 ****************************************************************************/

/* * ΂gppxƎvPSW_P1߂ŃANZXł悤APSW_P擪ɂ܂B
 *   PC̕gppxłAspc2cpu_run()̊ԃWX^ɕێ̂ŁAō\܂B
 */
typedef struct _SPC2CPU {
	unsigned short psw_p;	/* + 0,2: 0x000 / 0x100 */
	unsigned char psw_nz;	/* + 2,1: [7]=N,[7:0]=Z */	// +10,2: [8]=C,[7]=N,[7:0]=Z
	unsigned char psw_c;	/* + 3,1: [0]=C */		//
	unsigned char psw_v;	/* + 4,1: [8]=V */
	unsigned char x;	/* + 5,1: X */
	unsigned char a;	/* + 6,1: A */			// +14,2: YA
	unsigned char y;	/* + 7,1: Y */			//
	unsigned char* sp;	/* + 8,4: &spc2ram[0x100|SP] */
	unsigned char* pc;	/* +12,4: &spc2ram[      PC] */
} SPC2CPU;			/* =16 */

/* SPC2CPU\̂܂B
 * [in]
 *	pc		PCWX^̒lB
 *	a		AWX^̒lB
 *	x		XWX^̒lB
 *	y		YWX^̒lB
 *	psw		PSWWX^̒lB
 *	sp		SPWX^̒lB
 * [note]
 *	* ̏́ASPCt@C̃WX^tB[h̕тɍ킹܂B
 */
void spc2cpu_init(int pc, int a, int x, int y, int psw, int sp);

/* CPUs܂B
 * [in]
 *	count		s閽ߐB
 */
void spc2cpu_run(int count);

/****************************************************************************
 *	SPC2DSP
 ****************************************************************************/

/* Gx[ve[u */
extern const int spc2dsp_attack_rate_table[16/*AR*/];
extern const int spc2dsp_decay_rate_table[8/*SL*/][8/*DR*/];
extern const int spc2dsp_sustain_rate_table[32/*SR*/];
extern const int spc2dsp_sustain_level_table[8/*SL*/];
extern const int spc2dsp_increase_linear_table[32];
extern const int spc2dsp_increase_bentline_table[32];
#define spc2dsp_decrease_linear_table spc2dsp_increase_linear_table
#define spc2dsp_decrease_exponential_table spc2dsp_sustain_rate_table

/* BRRptB^We[u */
extern const short spc2dsp_filter_table[4][2];

typedef struct _SPC2VCE {
	int state;		/* + 0, 4: {SPC2VCE_*} */
	int vol;		/* + 4, 4: Volume : max(|VOL(L)|,|VOL(R)|)=>0`127 */
	int p;			/* + 8, 4: Pitch  : 0`0x3fff */
	int ar;			/* +12, 4: Attack Rate   (64Tvenvxω) */
	int dr;			/* +16, 4: Decay Rate    (64Tvenvxω) */
	int sr;			/* +20, 4: Sustain Rate  (64Tvenvxω) */
	int sl;			/* +24, 4: Sustain Level (0`127~Œ菬16bit) */
	int gain;		/* +28, 4: Gain (0`127~Œ菬16bit ܂ 64Tvenvxω) */
	int envx;		/* +32, 4: Envelope (0`127~Œ菬16bit) */
	int lsa;		/* +36, 4: Source Loop Start Address */
	int brr_addr;		/* +40, 4: BRRubNAhX */
	int last_loop;		/* +44, 4: bit0=0:r̃ubN or 1:ŏIubN */
				/*         bit1=0:[vȂF or 1:[vF */
	int progress;		/* +48, 4: g`isJE^ */
	short sample[16];	/* +52,32: BRRubNWJobt@ */
} SPC2VCE;			/* =84 */

/* SPC2DSP.kon */
#define SPC2VCE_ATTACK		1	/* ADSR      */
#define SPC2VCE_DECAY		2	/* ADSR      */
#define SPC2VCE_SUSTAIN		3	/* ADSR      */
#define SPC2VCE_RELEASE		4	/* ADSR/GAIN */
#define SPC2VCE_DIRECT		5	/*      GAIN */
#define SPC2VCE_INCREASE	6	/*      GAIN */
#define SPC2VCE_DECREASE	7	/*      GAIN */

typedef struct _SPC2DSP {
	int mvol;			/* +  0,  4: Main Volume : max(|MVOL(L)|,|MVOL(R)|)=>0`127 */
	SPC2VCE vce[8];			/* +  4,672: Voice~8`l */
	unsigned char reg[0x80];	/* +676,128: WX^f[^ */
} SPC2DSP;				/* =804 */

/* SPC2DSP\̂܂B
 */
void spc2dsp_init();

/* DSPWX^ǂݏo܂B
 * [in]
 *	addr		ǂݏoWX^AhXB
 * [out]
 *	߂l		ǂݏoWX^f[^B
 */
int spc2dsp_read(int addr);

/* DSPWX^֏݂܂B
 * [in]
 *	addr		ރWX^AhXB
 *	data		ރWX^f[^B([32:8]͕K0ƂĂ)
 */
void spc2dsp_write(int addr, int data);

/* 64Tṽ~LVOs܂B
 * [in]
 *	wbuff		o̓obt@B
 */
void spc2dsp_mix(short wbuff[/*64*/]);

/* w肳ꂽVoice64TṽGx[vXVs܂B
 * [in]
 *	vce		SPC2VCE\́B
 * [out]
 *	߂l		vce->stateԂ܂B
 */
int spc2vce_env(SPC2VCE* vce);

/* w肳ꂽVoice64Tv𐶐AZ܂B
 * [in]
 *	vce		SPC2VCE\́B
 *	mixbuf		~LVOobt@B
 */
void spc2vce_mix(SPC2VCE* vce, int mixbuf[/*64*/]);

/* kTvf[^(BRR:Bit Rate Reduction)𕜍܂B
 * [in]
 *	vce		SPC2VCE\́B
 */
void spc2vce_decode_brr(SPC2VCE* vce);

/****************************************************************************
 *	SPC2HDR
 ****************************************************************************/

/* * SPC2HDRESPC2ID666\̂ǂAgGfBAłB
 *
 * * SPC2HDRESPC2ID666\̂ǂAtB[hACgȂŃpbNĂ܂B
 *   ̂shortintgȂ̂ŁA2oCgȏ̃tB[hchar[]ƂĒ`܂B
 *
 * * SPCt@CɊ܂܂ĂID666 Tag text format / binary format ǂ炩@słB
 *   Ƃ肠ɋʂ song_title,game_title,dumper,comments tB[hĝSłB
 *
 * * 2004/10/22ǋL: ID666 Tag text format / binary format ǂ炩@ɂ
 *   wb_擪̃ItZbg[0xd2]0Ȃ΃oCi`A0ȊOȂ΃eLXg`łB
 *   (:gwb_擪́hItZbgłBgID666擪́hItZbgȂ!!)
 *   eLXg`Ȃ΃ItZbg[0xd2]Emulator used to dump SPCłALN^R[h'0'ȏ̒lĂ܂B
 *   oCi`Ȃ΃ItZbg[0xd2]͖gp̈łA[NAĂ܂B
 *   ̕@́ASSDLabo(http://www.ssdlabo.jp/)̃eLXguSPC t@C ID666 dlv
 *   (http://www.ssdlabo.jp/win/spcplay/ID666.txt)QlɂĂ܂B肪Ƃ܂B
 */

/* ID666 Tag (text format) */
typedef struct _SPC2ID666TXT {
	         char song_title[32];		/* +0x0002e, 32: Song title */
	         char game_title[32];		/* +0x0004e, 32: Game title */
	         char dumper[16];		/* +0x0006e, 16: Name of dumper */
	         char comments[32];		/* +0x0007e, 32: Comments */
	         char date[11];			/* +0x0009e, 11: Date SPC was dumped (MM/DD/YYYY) */
	         char play_time[3];		/* +0x000a9,  3: Number of seconds to play song before fading out */
	         char fade_time[5];		/* +0x000ac,  5: Length of face in milliseconds */
	         char artist[32];		/* +0x000b1, 32: Artist of song */
	unsigned char channel_disable;		/* +0x000d1,  1: Default channel disables (0:enable/1:disable) */
	unsigned char emulator;			/* +0x000d2,  1: Emulator used to dump SPC ('0':unknown/'1':ZSNES/'2':Snes9x) */
	unsigned char resv000d3[45];		/* +0x000d3, 45: (\) */
} SPC2ID666TXT;					/* =0x00100,210 */

/* ID666 Tag (binary format) */
typedef struct _SPC2ID666BIN {
	         char song_title[32];		/* +0x0002e, 32: Song title */
	         char game_title[32];		/* +0x0004e, 32: Game title */
	         char dumper[16];		/* +0x0006e, 16: Name of dumper */
	         char comments[32];		/* +0x0007e, 32: Comments */
	unsigned char date[4];			/* +0x0009e,  4: Date SPC was dumped (YYYYMMDD) */
	unsigned char resv000a2[7];		/* +0x000a2,  7: (\) */
	unsigned char play_time[3];		/* +0x000a9,  3: Number of seconds to play song before fading out */
	unsigned char fade_time[4];		/* +0x000ac,  4: Length of face in milliseconds */
	         char artist[32];		/* +0x000b0, 32: Artist of song */
	unsigned char channel_disable;		/* +0x000d0,  1: Default channel disables (0:enable/1:disable) */
	unsigned char emulator;			/* +0x000d1,  1: Emulator used to dump SPC (0:unknown/1:ZSNES/2:Snes9x) */
	unsigned char resv000d2[46];		/* +0x000d2, 46: (\) */
} SPC2ID666BIN;					/* =0x00100,210 */

/* ID666 Tag */
typedef union _SPC2ID666 {
	SPC2ID666TXT txt;			/* text format */
	SPC2ID666BIN bin;			/* binary format */
} SPC2ID666;

typedef struct _SPC2HDR {
	         char signature[33];		/* +0x00000, 33: "SNES-SPC700 Sound File Data v0.30" Œ */
	unsigned char resv00021[2];		/* +0x00021,  2: {26,26} Œ */
	unsigned char has_id666;		/* +0x00023,  1: ID666 TagL/ (26:L/27:) */
	unsigned char minor_ver;		/* +0x00024,  1: }Ci[o[W (30Œ?) */
	/*===== SPC700 Registers =====*/
	unsigned char pc[2];			/* +0x00025,  1: PC */
	unsigned char a;			/* +0x00027,  1: A */
	unsigned char x;			/* +0x00028,  1: X */
	unsigned char y;			/* +0x00029,  1: Y */
	unsigned char psw;			/* +0x0002a,  1: PSW */
	unsigned char sp;			/* +0x0002b,  1: SP */
	unsigned char resv0002c[2];		/* +0x0002c,  2: (\) uSPC File Format v0.30v(spc_file_format.txt)ɂ3oCgƏĂ܂BA? */
	/*===== ID666 Tag =====*/
	        SPC2ID666 id666;		/* +0x0002e,210: ID666 Tag (text or binary format) */
	/*===== Memory Image =====*/
	unsigned char main_ram[0x10000];	/* +0x00100,64K: CRAM */
	unsigned char dsp_regs[128];		/* +0x10100,128: DSPWX^ */
	unsigned char resv10180[64];		/* +0x10180, 64: (\) */
	unsigned char extra_ram[64];		/* +0x101c0, 64: Extra RAM (IPL ROM̗RAM?) */
} SPC2HDR;					/* =0x10200 */
						/* ̌Extended ID666 Itemsꍇ܂B(Ή) */

/* SPCwb_̃VOl`s܂B
 * [in]
 *	romp		SPCt@CC[W̐擪AhXB(==SPCwb_̐擪AhX)
 * [out]
 *	߂l		SPCwb_Ȃ0Ԃ܂B
 *			ȂSPCwb_ȂΕlԂ܂B
 */
int spc2hdr_test(const void* romp);

/****************************************************************************
 *	SPC2DRV
 ****************************************************************************/

#define SPC2BUFLEN	320	/* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

typedef struct _SPC2DRV {
	int timer[3];	/* ^C}JE^ (0-1:8KHz,2:64KHz) */
} SPC2DRV;

/* SPC2DRV\̂܂B
 * [in]
 *	romp		SPCt@CC[W̐擪AhXB
 * [out]
 *	߂l		Ȃ0Ԃ܂B
 *			sȂΕlԂ܂B
 */
int spc2drv_init(const void* romp);

/* I/O(0x00f0`0x00ff)̓ǂݏołB
 * [in]
 *	addr		ǂݏoAhXB
 * [out]
 *	߂l		ǂݏof[^B
 * [note]
 *	* spc2cpu_run()̎ŝݎgp܂B
 *	  ȊȌꏊĂяoȂłB
 *	* P/ECESPC2_ASM`ĂꍇÂ߁AȃAZułɒu܂B
 *	  ȃAZułspc2cpu_ruñWX^蓖ĂɈˑĂ邽߁A
 *	  spc2cpu_runȊOĂ΂ƌ듮̊댯܂B
 *	  CꂩĂ΂Ȃ悤AAZuł͊֐spc2drv_read_asmɕύXĂ܂B
 *	  P/ECESPC2_ASM`ĂꍇACłspc2drv_read̓N܂B
 *	  ڂ́Aclipsp2.cspc2drv_read_asmQƂĂB
 */
int spc2drv_read(int addr);

/* I/O(0x00f0`0x00ff)ւ̏ݏłB
 * [in]
 *	addr		ރAhXB
 *	߂l		ރf[^B([32:8]͕K0ƂĂ)
 */
void spc2drv_write(int addr, int data);

/* 1[tick](=1/50[sec])̃~LVOs܂B
 * [in]
 *	wbuff		o̓obt@B
 */
void spc2drv_mix(short wbuff[/*SPC2BUFLEN*/]);

/* stream_play()̂߂̃R[obN֐łB
 * [in]
 *	wbuff		o̓obt@B
 *	param		(gp)
 * [out]
 *	߂l		Ȃ0Ԃ܂B
 *			sȂΕlԂ܂B
 */
int spc2drv_stream_callback(short* wbuff, int param);

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

extern SPC2CPU spc2cpu;
extern SPC2DSP spc2dsp;
extern SPC2DRV spc2drv;
extern unsigned char spc2ram[0x10000];	/* 0x0000`0xffff */
extern unsigned char spc2ext[64];	/* 0xffc0`0xffff̗RAM? */

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* ID666^O̕tB[h́A32(dumper̂16)ς܂Ŏgp邱Ƃ܂B
 * ς܂ŎgpĂꍇAnulI[Ă܂B
 * mnulI[邽߂ɁASPC2INF\̂̕tB[h͒+1邱Ƃɂ܂B
 * ȂAID666 text format datetB[h́AƂƊmnulI[Ă̂ŁA+1svłB
 */
typedef struct _SPC2INF {
	char song_title[32 + 1];	/* Song title     (mnulI[) */
	char game_title[32 + 1];	/* Game title     (mnulI[) */
	char dumper[16 + 1];		/* Name of dumper (mnulI[) */
	char comments[32 + 1];		/* Comments       (mnulI[) */
	char date[11/*+1sv*/];	/* Date SPC was dumped (MM/DD/YYYY) (mnulI[) */
	int  play_time;			/* Number of seconds to play song before fading out (0:unknown) */
	int  fade_time;			/* Length of face in milliseconds */
	char artist[32 + 1];		/* Artist of song (mnulI[) */
	int  channel_disable;		/* Default channel disables (0:enable/1:disable) */
	int  emulator;			/* Emulator used to dump SPC (0:unknown/1:ZSNES/2:Snes9x) */
} SPC2INF;

/* SPCt@C̍ĐJn܂B
 * [in]
 *	data		SPCt@CC[W̐擪AhXB
 * [out]
 *	߂l		Ȃ0Ԃ܂B
 *			sȂΕlԂ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKspc2_stop()ĂŁAxN^𕜌ĂB
 */
int spc2_play(const void* romp);

/* SPCt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void spc2_stop();

/* SPCt@C擾܂B
 * [in]
 *	data		SPCt@CC[W̐擪AhXB
 *	inf		SPCt@Ci[SPC2INF\́B(NULL\)
 * [out]
 *	߂l		Ȃ0Ԃ܂B
 *			sȂΕlԂ܂B
 * [note]
 *	* SPCt@CC[WID666^OĂȂ(hdr->has_id666!=26)ꍇA
 *	  SPC2INF\̂̑StB[hNAA(0)Ԃ܂B
 *	* infNULLȂ΁ASPCt@CC[Wۂ𔻒fA
 *	  SPCt@CC[WłĂSPCt@Ci[܂B
 */
int spc2_inf(const void* romp, SPC2INF* inf);

#endif /*__CLIP_SP2_H__*/
