/*	
 *	clipm69.c
 *
 *	P/ECE M6809 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Wed Feb 11 17:45:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipm69i.h"	/*M6809G~[^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	IyR[h}bv
 */
const M6809OP m6809_op_table[256/*XX*/] = {
#include "m6809/xx.h" /* [m6809.xls]XX */
};
const M6809OP m6809_op_table_10[256/*XX*/] = {
#include "m6809/10.h" /* [m6809.xls]Table10 */
};
const M6809OP m6809_op_table_11[256/*XX*/] = {
#include "m6809/11.h" /* [m6809.xls]Table11 */
};

/*
 *	CXgNVe[u
 */
#undef M6809FN_
#define M6809FN_(OP, FN)	OP "\0"
const char m6809_op_name_table[] = {
	"\0" /* ItZbg0̓k */
#include "m6809/list.h" /* [m6809.xls]List */
};
#undef M6809FN_

/****************************************************************************
 *	֐
 ****************************************************************************/

void
m6809_check_pending(M6809* m6809)
{
	if(!(CC & 0x40) && (PENDING & M6809_FIRQ_PENDING)) {
		PENDING &= ~M6809_FIRQ_PENDING;
		m6809_int(m6809, M6809_FIRQ_VECTOR, 0);
		CC |= 0x50;	/* CC(F,I)=1:֎~ */
		WAIT = 0;	/* WAIT */
		return;
	}
	if(!(CC & 0x10) && (PENDING & M6809_IRQ_PENDING)) {
		PENDING &= ~M6809_IRQ_PENDING;
		m6809_int(m6809, M6809_IRQ_VECTOR, 1);
		CC |= 0x10;	/* CC(I)=1:֎~ */
		WAIT = 0;	/* WAIT */
		return;
	}
}

void
m6809_int(M6809* m6809, int vector, int entire)
{
	PUSHW(S, PC);
	if(entire) {
		CC |= 0x80;
		PUSHW(S, U);
		PUSHW(S, Y);
		PUSHW(S, X);
		PUSH(S, DP);
		PUSH(S, B);
		PUSH(S, A);
		PUSH(S, CC);
	}
	PC = READW(vector);
}

void
m6809_rti(M6809* m6809)
{
	PULL(S, CC);			/* CC(F,I)ω\... */
	if(CC & 0x80) {
		PULL(S, A);
		PULL(S, B);
		PULL(S, DP);
		PULLW(S, X);
		PULLW(S, Y);
		PULLW(S, U);
	}
	PULLW(S, PC);
	m6809_check_pending(m6809);	/* ...犄荞݃`FbNKv */
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
m6809_reset(M6809* m6809, M6809READPROC* read, M6809WRITEPROC* write)
{
	memset(m6809, 0, sizeof(M6809));
	m6809->read  = read  ? read  : m6809_internal_read;
	m6809->write = write ? write : m6809_internal_write;

	CC = 0x50;	/* CC(F,I)=1:֎~ */
	PC = READW(M6809_RESET_VECTOR);
}

void
m6809_nmi(M6809* m6809)
{
	m6809_int(m6809, M6809_NMI_VECTOR, 1);
	CC |= 0x50;	/* CC(F,I)=1:֎~ */
	WAIT = 0;	/* WAIT */
}

void
m6809_firq(M6809* m6809)
{
	PENDING |= M6809_FIRQ_PENDING;
	m6809_check_pending(m6809);
}

void
m6809_irq(M6809* m6809)
{
	PENDING |= M6809_IRQ_PENDING;
	m6809_check_pending(m6809);
}

void
m6809_dump(M6809* m6809)
{
#define INDENT	40
	TRACE("%*s", INDENT, "");
	TRACE("CC:%c%c%c%c%c%c%c%c DP:%02x A:%02x B:%02x X:%04x Y:%04x U:%04x S:%04x PC:%04x\n",
		CC & (1 << 7) ? 'E' : '-',	/* Entire */
		CC & (1 << 6) ? 'F' : '-',	/* FIRQ Mask */
		CC & (1 << 5) ? 'H' : '-',	/* Half Carry */
		CC & (1 << 4) ? 'I' : '-',	/* IRQ Mask */
		CC & (1 << 3) ? 'N' : '-',	/* Negative */
		CC & (1 << 2) ? 'Z' : '-',	/* Zero */
		CC & (1 << 1) ? 'V' : '-',	/* Overflow */
		CC & (1 << 0) ? 'C' : '-',	/* Carray */
		DP, A, B, X, Y, U, S, PC);
#undef INDENT
}

/****************************************************************************
 *
 ****************************************************************************/

#ifdef PIECE

asm("
	.code
	.global m6809_run2
m6809_run2:
	pushn %r0
	ld.w %r0, %sp		; X^bNޔ
	xld.w %r10, 0x1000	; 0x0e00`0x1000ɃX^bNؑ
	ld.w %sp, %r10
	xcall m6809_run
	ld.w %sp, %r0		; X^bN
	popn %r0
	ret
");

#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

