/*	
 *	clipldir.c
 *
 *	ؑցE16K\
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2007 Naoyuki Sawa
 *
 *	* Sun Jun 6 14:11:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Jun 7 09:00:00 JST 2004 Naoyuki Sawa
 *	- X^oCɑΉ܂B
 *	* Tue Jun 8 19:00:00 JST 2004 Naoyuki Sawa
 *	- 4bit`̂߂̃JX^pceLCDDrawObject()̃W[Ɋ܂߂܂B
 *	* Wed Jun 9 20:45:00 JST 2004 Naoyuki Sawa
 *	- ̂߁A16K4KϊA2sNZÂ܂Ƃ߂ď悤ɕύX܂B
 *	* Thu Jun 10 19:00:00 JST 2004 Naoyuki Sawa
 *	- new_pceLCDTrans()̏{̂RAMֈڂAldirect_mkbuf()Ƃ܂B
 *	* Tue Oct 23 23:02:28 JST 2007 Naoyuki Sawa
 *	- new_pceLCDDrawObject()ASM܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

/*
 *	LDIRECThCo\
 */
typedef struct _LDIRECT {
	void (*old_pceLCDTrans)();			/* {pceLCDTrans()ۑBNULLȂΖłB */
	int (*old_pceLCDDrawObject)(DRAW_OBJECT obj);	/* {pceLCDDrawObjectۑB */
	int (*old_pceAppNotify)(int type, int param);	/* {pceAppNotify()ۑB   */
	//
	int multiplier;					/* 8-bit timer̊荞ݎgpłB          */
	int counter;					/* 荞ݖ+1AmultiplyɒBXVsB */
	//
	int phase;					/* ؑւ̑ԍBldirect_cvttbl[]̃RgQƁB  */
	int timer;					/* fobOpBʍXV+1܂B                */
	//
	unsigned char wbuff[DISP_X / 2 * DISP_Y];	/* pceLCDTrans()ɉʃobt@̓eRs[܂B
							 * 8sNZPʂŁAs4sNZ4bitA㑱4sNZ4bitɏd˂Ċi[܂B
							 * ŏ16sNZɂƂĎƁÂ悤ɂȂ܂B
							 *	wbuff[0] = pixel( 0,0)<<4|pixel( 4,0)
							 *	wbuff[1] = pixel( 1,0)<<4|pixel( 5,0)
							 *	wbuff[2] = pixel( 2,0)<<4|pixel( 6,0)
							 *	wbuff[3] = pixel( 3,0)<<4|pixel( 7,0)
							 *	wbuff[4] = pixel( 8,0)<<4|pixel(12,0)
							 *	wbuff[5] = pixel( 9,0)<<4|pixel(13,0)
							 *	wbuff[6] = pixel(10,0)<<4|pixel(14,0)
							 *	wbuff[7] = pixel(11,0)<<4|pixel(15,0)
							 */
} LDIRECT;
static LDIRECT _ldirect;

// * 4sNZꂽ2̃sNZ̑gA16K4Kɕϊe[ułB
//   ȉ̃vOɂĐ܂B
//
//	#define C(c) (((c) & 1) << 15 | ((c) & 2) << 6) /* C[15]=c[0], C[7]=c[1] */
//	const unsigned short ctbl[16 + (5 - 1)] = {
//		C(0),C(0),C(0),C(0),C(0), C(1),C(1),C(1),C(1),C(1), C(2),C(2),C(2),C(2),C(2), C(3),C(3),C(3),C(3),C(3)
//	/*	|<----------------------------------- phase0 ----------------------------------->|			*/
//	/*	          |<----------------------------------- phase2 ----------------------------------->|		*/
//	/*	                    |<----------------------------------- phase4 ----------------------------------->|	*/
//	/*	     |<----------------------------------- phase1 ----------------------------------->|			*/
//	/*	               |<----------------------------------- phase3 ----------------------------------->|	*/
//	};
//	#undef C
//	void make_cvttbl() {
//		int phase, pixel0, pixel4;
//		printf("static const unsigned short ldirect_cvttbl[5][256] = {\n");
//		for(phase = 0; phase < 5; phase++) {
//			for(pixel0 = 0; pixel0 < 16; pixel0++) {
//				if(pixel0 == 0) printf("{"); else printf(" ");
//				for(pixel4 = 0; pixel4 < 16; pixel4++) {
//					/* C[15]=pixel4[0],C[11]=pixel0[0],C[7]=pixel4[1],C[3]=pixel0[1] */
//					printf("0x%04x", ctbl[phase + pixel4] | ctbl[phase + pixel0] >> 4);
//					if(pixel0 == 15 && pixel4 == 15) printf("}"); printf(",");
//				}
//				if(pixel0 & 1) printf("\n");
//			}
//		}
//		printf("};\n");
//	}
//
static const unsigned short ldirect_cvttbl[5][256] = {
{0x0000,0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080, 0x0000,0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,
 0x0000,0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080, 0x0000,0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,
 0x0000,0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080, 0x0800,0x0800,0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,
 0x0800,0x0800,0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880, 0x0800,0x0800,0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,
 0x0800,0x0800,0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880, 0x0800,0x0800,0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,
 0x0008,0x0008,0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088, 0x0008,0x0008,0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,
 0x0008,0x0008,0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088, 0x0008,0x0008,0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,
 0x0008,0x0008,0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088, 0x0808,0x0808,0x0808,0x0808,0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888},
{0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,0x8080, 0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,0x8080,
 0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,0x8080, 0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,0x8080,
 0x0800,0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880, 0x0800,0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,
 0x0800,0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880, 0x0800,0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,
 0x0800,0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880, 0x0008,0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,
 0x0008,0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088, 0x0008,0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,
 0x0008,0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088, 0x0008,0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,
 0x0808,0x0808,0x0808,0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888, 0x0808,0x0808,0x0808,0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888},
{0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,0x8080,0x8080, 0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,0x8080,0x8080,
 0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,0x8080,0x8080, 0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,
 0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880, 0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,
 0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880, 0x0800,0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,
 0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088, 0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,
 0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088, 0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,
 0x0008,0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088, 0x0808,0x0808,0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888,
 0x0808,0x0808,0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888, 0x0808,0x0808,0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888},
{0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,0x8080,0x8080,0x8080, 0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,0x8080,0x8080,0x8080,
 0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,0x8880, 0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,0x8880,
 0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,0x8880, 0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,0x8880,
 0x0800,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,0x8880, 0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,0x8088,
 0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,0x8088, 0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,0x8088,
 0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,0x8088, 0x0008,0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,0x8088,
 0x0808,0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888,0x8888, 0x0808,0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888,0x8888,
 0x0808,0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888,0x8888, 0x0808,0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888,0x8888},
{0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0080,0x0080,0x0080,0x0080,0x0080,0x8080,0x8080,0x8080,0x8080,0x8080, 0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,0x8880,0x8880,
 0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,0x8880,0x8880, 0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,0x8880,0x8880,
 0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,0x8880,0x8880, 0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0880,0x0880,0x0880,0x0880,0x0880,0x8880,0x8880,0x8880,0x8880,0x8880,
 0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,0x8088,0x8088, 0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,0x8088,0x8088,
 0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,0x8088,0x8088, 0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,0x8088,0x8088,
 0x0008,0x8008,0x8008,0x8008,0x8008,0x8008,0x0088,0x0088,0x0088,0x0088,0x0088,0x8088,0x8088,0x8088,0x8088,0x8088, 0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888,0x8888,0x8888,
 0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888,0x8888,0x8888, 0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888,0x8888,0x8888,
 0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888,0x8888,0x8888, 0x0808,0x8808,0x8808,0x8808,0x8808,0x8808,0x0888,0x0888,0x0888,0x0888,0x0888,0x8888,0x8888,0x8888,0x8888,0x8888},
};

static void new_pceLCDTrans();
/*static*/ int new_pceLCDDrawObject(DRAW_OBJECT obj);	/*{{2007/10/23:ASMɔAx}̂߂static錾폜Bۂɂstatiĉ܂܂łB}}*/
static int new_pceAppNotify(int type, int param);
static void _ldirect_isr() __attribute__((unused));
       void  ldirect_isr();

/****************************************************************************
 *	O[o֐
 ****************************************************************************/

void
ldirect_init(int interval)
{
	LDIRECT* ldirect = &_ldirect;
	//
	int clock_division_ratio;
	pceAPPHEAD* pceAppHead;

	/* ܂Amɉ܂B */
	ldirect_free();

	/* hCo\̂NA܂B */
	memset(ldirect, 0, sizeof(LDIRECT));

	/* 8-bit timer̕߂܂B
	 * * vXP[fPSCIN^4096ŒƂ܂B
	 * * fPSCIN24MHz܂48MHzłB
	 *   24MHzƉ肵Đݒ肵ĂA48MHz_ldirect_isr()֐ɂĔɊԈ܂B
	 */
	//clock_division_ratio = (interval/*[ms]*/ / 1e3) / (4096 / 24e6[Hz]);
	//ό`...
	//clock_division_ratio =  interval                / (4096 / 24e3    );
	//ό`...
	clock_division_ratio = interval * 24000 / 4096;

	/* 8-bit timer̊荞ݎg܂B */
	ldirect->multiplier = 1;
	while(clock_division_ratio > 256) {
		clock_division_ratio >>= 1;
		ldirect->multiplier  <<= 1;
	}
	clock_division_ratio--; /* 8-bit timer̎dl */

	/* pceLCDTrans()tbN܂B */
	ldirect->old_pceLCDTrans = pceVectorSetKs(KSNO_LCDTrans, new_pceLCDTrans);
	/* ȍ~`܂ł̕sȏԂpceLCDTrans()ĂԂƊ댯łBDIE()Ȃ!! */

	/* pceLCDDrawObject()tbN܂B */
	ldirect->old_pceLCDDrawObject = pceVectorSetKs(KSNO_LCDDrawObject, new_pceLCDDrawObject);

	/* pceAppNotify()tbN܂B
	 * 2004/11/05ǋL
	 * * pceAppNotify()Cuɒ`̂ŁA̓Cu(clippce.c)Œ`ĂpceAppNotify()tbN邱ƂɂȂ܂B
	 *   ̃W[̎ɕῶ܂B
	 *   CuW[ŁAatnotify()gĂ͂܂!!
	 *   ݂̎łatnotify()͈xgȂ߁Aatnotify()gƃAvP[Vatnotify()gȂȂĂ܂łB
	 */
	pceAppHead = (pceAPPHEAD*)pceSystemGetInfo()->sram_top;
	ldirect->old_pceAppNotify = pceAppHead->notify_proc;
	pceAppHead->notify_proc = new_pceAppNotify;

	/*** 8-bit timer 2 ݒ  ***/

	/* ^C}~܂B */
	pT8_CTL2 = 0;

	/* vXP[~܂B */
	bCLKCTL_T8_23_P8TON2 = 0;

	/* 荞݃T[rX[`CXg[܂B */
	pceVectorSetTrap(TRAP_8TU2, ldirect_isr);

	/* 荞݃vCIeBŒ჌xɐݒ肵܂B
	 * * 荞݃vCIeB0͕KubN̂ŁA荞݃vCIeB1Œ჌xƂȂ܂B
	 * * 8-bit timer 0`3͑Sē荞݃vCIeBݒL܂B
	 *   A8-bit timer荞݂𗘗pvOƂ͋ł܂B
	 *   P/ECEJ[l(PieceSystem Ver1.20)8-bit timer荞݂𗘗pĂȂ̂ŖɂȂ܂񂪁A
	 *   AvP[VvO8-bit timer荞݂𗘗pꍇ͉炩̑΍􂪕KvƂȂ܂B
	 */
	bINT_P8T_PSIO0_P8TM = 1;

	/* Ô߁AԂ̊荞ݗvtONA܂B
	 * * 8-bit timer 0/1/3̊荞ݗvtONAĂ܂\܂B
	 *   ڂ́A_ldirect_isr()̃RgQƂĂB
	 */
	bINT_F8T_F8TU2 = 0;

	/* vXP[ݒ肵܂B */
	bCLKSEL_T8_P8TPCK2 = 0;			/* NbN */
	bCLKCTL_T8_23_P8TS2 = CLKDIV_8T2_4096;	/* fPSCIN^4096 */

	/* ^C}ݒ肵܂B */
	pT8_RLD2 = clock_division_ratio;

	/* vXP[Jn܂B */
	bCLKCTL_T8_23_P8TON2 = 1;

	/* ^C}Jn܂B */
	pT8_CTL2 = 3; /* RUN & PRESETANbNo͕͂sv */

	/* 荞݂܂B */
	bINT_E8T_E8TU2 = 1;

	/*** 8-bit timer 2 ݒ ܂ ***/
}

void
ldirect_free()
{
	LDIRECT* ldirect = &_ldirect;
	//
	pceAPPHEAD* pceAppHead;

	/* ĂȂΉ܂B */
	if(!ldirect->old_pceLCDTrans) return;

	/*** 8-bit timer 2 ݒ  ***/

	/* 荞݂֎~܂B */
	bINT_E8T_E8TU2 = 0;

	/* ^C}~܂B */
	pT8_CTL2 = 0;

	/* vXP[~܂B */
	bCLKCTL_T8_23_P8TON2 = 0;

	/*** 8-bit timer 2 ݒ ܂ ***/

	/* pceAppNotify()̃tbN܂B */
	pceAppHead = (pceAPPHEAD*)pceSystemGetInfo()->sram_top;
	pceAppHead->notify_proc = ldirect->old_pceAppNotify;

	/* pceLCDDrawObject()̃tbN܂B */
	pceVectorSetKs(KSNO_LCDDrawObject, ldirect->old_pceLCDDrawObject);

	/* pceLCDTrans()̃tbN܂B */
	pceVectorSetKs(KSNO_LCDTrans, ldirect->old_pceLCDTrans);

	/* hCo\̂NA܂B */
	memset(ldirect, 0, sizeof(LDIRECT));
}

int
ldirect_timer()
{
	return _ldirect.timer;
}

/****************************************************************************
 *	[J֐
 ****************************************************************************/

static void
new_pceLCDTrans()
{
	ldirect_mkbuf(_ldirect.wbuff, pceLCDSetBuffer(INVALIDPTR));
}

static int
new_pceAppNotify(int type, int param)
{
	LDIRECT* ldirect = &_ldirect;
	//
	int retval;

	switch(type) {
	case APPNF_SMSTART:
		/* VXej[JnɁAؑւ~܂B */
		retval = ldirect->old_pceAppNotify(type, param);
		if(retval == APPNR_ACCEPT) { /* SMSTART̍m艞ACCEPT݂̂ł */
			bINT_E8T_E8TU2 = 0; /* 8-bit timer 2 荞݋֎~ */
		}
		return retval;

	case APPNF_SMRESUME:
		/* VXej[IɁAؑւĊJ܂B */
		retval = ldirect->old_pceAppNotify(type, param);
		bINT_E8T_E8TU2 = 1; /* 8-bit timer 2 荞݋ */
		return retval;

	case APPNF_STANDBY:
		/* X^oC֎~Ƃ܂B
		 * * {́AX^oCؑւ~̂łA
		 *   pceAppNotify()ɂ̓X^oCAʒmȂ̂ŁAĊJ^C~O܂B
		 *   ނAؑ֎gp̓X^oC֎~Ƃ܂B
		 * 2004/06/07 ύX
		 * X^oCɑΉ܂B
		 * * VXeɑ΂Ă̓X^oCۂAgŃX^oC邱Ƃŉ\łB
		 */
		retval = ldirect->old_pceAppNotify(type, param);
		if(retval == APPNR_ACCEPT || retval == APPNR_IGNORE) { /* STANDBY̍m艞ACCEPTIGNOREł */
			bINT_E8T_E8TU2 = 0; /* 8-bit timer 2 荞݋֎~ */
			pcePowerEnterStandby(0);
			bINT_E8T_E8TU2 = 1; /* 8-bit timer 2 荞݋ */
		}
		return APPNR_REJECT; /* VXeɑ΂Ă̓X^oCۂƂɂ */

	case APPNF_EXITREQ:
		/* AvP[VIɁAؑւ܂B */
		retval = ldirect->old_pceAppNotify(type, param);
		if(retval == APPNR_ACCEPT || retval == APPNR_IGNORE) { /* EXITREQ̍m艞ACCEPTIGNOREł */
			ldirect_free();
		}
		return retval;
	}

	return ldirect->old_pceAppNotify(type, param);
}

/* void ldirect_isr() */
asm("
	.code
	.align 1
ldirect_isr:
	pushn %r15
	ld.w %r0, %alr
	ld.w %r1, %ahr
	pushn %r1
	call _ldirect_isr
	popn %r1
	ld.w %ahr, %r1
	ld.w %alr, %r0
	popn %r15
	reti
");

static void
_ldirect_isr()
{
	LDIRECT* ldirect = &_ldirect;
	//
	const unsigned short* cvttbl;

	/* 8-bit timer 2 荞ݗvtONA܂B
	 * * Read/Modify/Writê߁A8-bit timer 0/1/3̊荞ݗvtONAĂ܂\܂B
	 *   ̖́AP/ECEJ[lReadWrite̊荞݃NA@IĂ邱ƂɋNAs\łB
	 *   P/ECEJ[l(PieceSystem Ver1.20)8-bit timer荞݂𗘗pĂȂ̂ŖɂȂ܂񂪁A
	 *   AvP[VvO8-bit timer荞݂𗘗pꍇ͉炩̑΍􂪕KvƂȂ܂B
	 */
	bINT_F8T_F8TU2 = 0;

	/* ʃvCIeB̑d荞݂󂯕t܂B */
	ENABLE;

	/* 8-bit timer̊荞ݎg܂B */
	ldirect->counter++;
	if(bP0_P0D_P07D) { /* 24MHz */
		if(ldirect->counter < ldirect->multiplier * 1) return;
	} else {           /* 48MHz */
		if(ldirect->counter < ldirect->multiplier * 2) return;
	}
	ldirect->counter = 0;

	/* ϊe[u̐擪AhX߂܂B */
	cvttbl = &ldirect_cvttbl[ldirect->phase][0];

	/* ʓ]̃C[`Ăяo܂B */
	ldirect_trans(ldirect->wbuff, cvttbl);

	/* ̂߂ɁAtF[Yi߂܂B */
	if((ldirect->phase += 2) >= 5) ldirect->phase -= 5;

	/* fobOp^C}JEgAbv܂B */
	ldirect->timer++;
}

/****************************************************************************
 *	pceLCDDrawObject() 4bit`T|[g
 ****************************************************************************/

/*{{2007/10/23:ASMɔ폜B܂ň蓮삵Ă̂ŁAQlɎcĂ܂B*/
//static int
//new_pceLCDDrawObject(DRAW_OBJECT obj)
//{
//	PIECE_VRAM dest;
//	int n;
//
//	/* 4bit(}XNt/}XN)`̕`̂ݏ܂B
//	 * ȊǑ`́A{pceLCDDrawObject()ɔC܂B
//	 */
//	if(obj.src->header.bpp != 4) {
//		return _ldirect.old_pceLCDDrawObject(obj);
//	}
//
//	/* ]VRAM񂪐ݒ肳ĂȂ΁Alݒ肵܂B
//	 * * pceLCDSetObject()gꍇ́A]VRAM񂪐ݒ肳ĂȂ̂ŁAlg܂B
//	 *   render_object()gꍇ́A]VRAM񂪐ݒ肳Ă܂B
//	 */
//	if(obj.dest != NULL) {
//		dest = *obj.dest;
//	} else {
//		dest.w = DISP_X;
//		dest.h = DISP_Y;
//		dest.buf = pceLCDSetBuffer(INVALIDPTR);
//		obj.dest = &dest; /* YȂ!! */
//	}
//
//	/* ]NbsOB */
//	if(!(obj.param & DRW_REVX)) {
//		if(obj.dx < obj.clip.left) {
//			n = obj.clip.left - obj.dx; /* ɂ͂ݏosNZ */
//			obj.dx = obj.clip.left;
//			obj.dw -= n;
//			obj.sx += n;
//		}
//		if(obj.dx + obj.dw > obj.clip.right) {
//			obj.dw = obj.clip.right - obj.dx;
//		}
//	} else {
//		if(obj.dx < obj.clip.left) {
//			n = obj.clip.left - obj.dx; /* ɂ͂ݏosNZ */
//			obj.dx = obj.clip.left;
//			obj.dw -= n;
//		}
//		if(obj.dx + obj.dw > obj.clip.right) {
//			n = obj.dx + obj.dw - obj.clip.right; /* Eɂ͂ݏosNZ */
//			obj.dw -= n;
//			obj.sx += n;
//		}
//	}
//	if(obj.dw <= 0) return 0; /* ʊO */
//	if(!(obj.param & DRW_REVY)) {
//		if(obj.dy < obj.clip.top) {
//			n = obj.clip.top - obj.dy; /* ɂ͂ݏosNZ */
//			obj.dy = obj.clip.top;
//			obj.dh -= n;
//			obj.sy += n;
//		}
//		if(obj.dy + obj.dh > obj.clip.bottom) {
//			obj.dh = obj.clip.bottom - obj.dy;
//		}
//	} else {
//		if(obj.dy < obj.clip.top) {
//			n = obj.clip.top - obj.dy; /* ɂ͂ݏosNZ */
//			obj.dy = obj.clip.top;
//			obj.dh -= n;
//		}
//		if(obj.dy + obj.dh > obj.clip.bottom) {
//			n = obj.dy + obj.dh - obj.clip.bottom; /* ɂ͂ݏosNZ */
//			obj.dh -= n;
//			obj.sy += n;
//		}
//	}
//	if(obj.dh <= 0) return 0; /* ʊO */
//
//	/* ]NbsO͍s܂B
//	 * Xw肳ꂽ]`]rbg}bvɎ܂ĂȂ΁A
//	 * ]NbsOɂē]͂ݏoƂ͂肦ȂłB
//	 * {͓]NbsOsĂ̂ŁA̓_͔݊łB
//	 */
//
//	/* 4bit`惋[`̖{̂Ăяo܂B */
//	PDW_Draw_4BN(obj);
//
//	return 1; /* ȂƂꕔʓ */
//}
/*}}2007/10/23:ASMɔ폜B܂ň蓮삵Ă̂ŁAQlɎcĂ܂B*/

/* * Tue Oct 23 23:02:28 JST 2007 Naoyuki Sawa
 * - new_pceLCDDrawObject()ASM܂B
 *   ȍ́Aȉ̂ƂłB
 * - ASMł́ACłNbsOAgpWX^ƏXebv炵܂B
 *   掩^łAƂĂǂoƎv܂B(^^)
 *   ACŃNbsOꍇɂA͎̎QlɂȂƎv܂B
 * - ͂DRAW_OBJECT(in)NbsOAo͂DRAW_OBJECT(out)Ɋi[Ă鏈AꌩʂɌ܂AKvłB
 *   new_pceLCDDrawObject()͖߂l(0or1)Ԃ̂ɑ΂AŌɌĂяoPDW_Draw_4BN()void֐Ȃ̂ŁA
 *   ͂DRAW_OBJECT(in)NbsOāÂ܂PDW_Draw_4BN()փWvŗƂłȂłB
 *   ADRAW_OBJECT(in)NbsOāAo͂DRAW_OBJECT(out)Ɋi[鏈́Ał邾ǂ쐬̂ŁA
 *   ASMłł́AقƂǖʂ͂ȂƎv܂B
 *   Cł̃RpCo̓R[hł́Ȁmemcpy()ĂяoĂāA傫ȃI[o[wbhĂ܂B
 * - CłɂAȉ͖̏ʂ̂ŁA폜܂B
 *	if(obj.dest != NULL) {
 *		dest = *obj.dest; ͖̏
 *	} else {
 *		...
 */
/*static*/ int new_pceLCDDrawObject(DRAW_OBJECT obj);
asm("
	.code
	.align	1
new_pceLCDDrawObject:
	;//-----------------------------;
	;// [%sp+0]  := ret addr
	;//-----------------------------;
	;// [%sp+4]  := in.dest
	;// [%sp+8]  := in.dx
	;// [%sp+10] := in.dy
	;// [%sp+12] := in.dw
	;// [%sp+14] := in.dh
	;// [%sp+16] := in.src
	;// [%sp+20] := in.sx
	;// [%sp+22] := in.sy
	;// [%sp+24] := in.clip.left
	;// [%sp+25] := in.clip.top
	;// [%sp+26] := in.clip.right
	;// [%sp+27] := in.clip.bottom
	;// [%sp+28] := in.disp
	;// [%sp+29] := in.param
	;// [%sp+30] := in.type
	;// [%sp+31] := in.layer
	;//-----------------------------;
	xld.w	%r4, [%sp+16]				; %r4  := src = in.src ----+
	xld.ub	%r5, [%r4+8]				; %r5  := src->header.bpp  |
	xld.w	%r10, 0					; %r10 := 0 (߂l)       |				*anti-interlock*
	xcmp	%r5, 4					; if(src->header.bpp != 4) |
	xjrne	new_pceLCDDrawObject_OLD		;                          |
	;-----------------------------------------------;                          |
	xsub	%sp, %sp, 36				;                          |
	xld.w	[%sp+12], %r4				; store out.src <----------+
	;//-----------------------------;
	;// [%sp+0]  := out.dest
	;// [%sp+4]  := out.dx
	;// [%sp+6]  := out.dy
	;// [%sp+8]  := out.dw
	;// [%sp+10] := out.dh
	;// [%sp+12] := out.src
	;// [%sp+16] := out.sx
	;// [%sp+18] := out.sy
	;// [%sp+20] := out.clip.left
	;// [%sp+21] := out.clip.top
	;// [%sp+22] := out.clip.right
	;// [%sp+23] := out.clip.bottom
	;// [%sp+24] := out.disp
	;// [%sp+25] := out.param
	;// [%sp+26] := out.type
	;// [%sp+27] := out.layer
	;//-----------------------------;
	;// [%sp+28] := tmp.w
	;// [%sp+30] := tmp.h
	;// [%sp+32] := tmp.buf
	;//-----------------------------;
	;// [%sp+36] := ret addr
	;//-----------------------------;
	;// [%sp+40] := in.dest
	;// [%sp+44] := in.dx
	;// [%sp+46] := in.dy
	;// [%sp+48] := in.dw
	;// [%sp+50] := in.dh
	;// [%sp+52] := in.src
	;// [%sp+56] := in.sx
	;// [%sp+58] := in.sy
	;// [%sp+60] := in.clip.left
	;// [%sp+61] := in.clip.top
	;// [%sp+62] := in.clip.right
	;// [%sp+63] := in.clip.bottom
	;// [%sp+64] := in.disp
	;// [%sp+65] := in.param
	;// [%sp+66] := in.type
	;// [%sp+67] := in.layer
	;//-----------------------------;
	xld.w	%r4, [%sp+64]				; %r4  := in.disp,param,type,layer
	xld.h	%r5, [%sp+44]				; <--------------------------------+			*anti-interlock*
	xld.w	[%sp+24], %r4				; store  out.disp,param,type,layer |
	;-----------------------------------------------;                                  |
;//	xld.h	%r5, [%sp+44]				; %r5  := dx    = in.dx -----------+
	xld.h	%r6, [%sp+48]				; %r6  := dw    = in.dw
	xld.h	%r7, [%sp+56]				; %r7  := sx    = in.sx
	xld.ub	%r11, [%sp+60]				; %r11 := left  = in.clip.left
	xld.ub	%r12, [%sp+62]				; %r12 := right = in.clip.right
	xld.b	[%sp+20], %r11				; store out.clip.left
	xld.b	[%sp+22], %r12				; store out.clip.right
	xand	%r9, %r4, 0x8000			; if(!(param & DRW_REVX))
	xjrne.d	new_pceLCDDrawObject_REVX
	 sub	%r11, %r5				;   %r11 := n = left - dx <----------------------+	*delay*
	 jrle	4					;   if(n > 0) // if(dx < left)                   |
	  add	%r5, %r11				;     %r5  := dx += n // dx + (left - dx) = left |
	  sub	%r6, %r11				;     %r6  := dw -= n                            |
	  add	%r7, %r11				;     %r7  := sx += n                            |
	 sub	%r12, %r5				;   %r12 := right - dx                           |
	 cmp	%r6, %r12				;   if(dw > right - dx) // if(dx + dw > right)   |
	 xjrle	new_pceLCDDrawObject_X_STORE		;                                                |
	  xjp.d	new_pceLCDDrawObject_X_STORE		;                                                |
	  ld.w	%r6, %r12				;     %r6  := dw = right - dx                    |	*delay*
new_pceLCDDrawObject_REVX:				; else                                           |
;//	 sub	%r11, %r5				;   %r11 := n = left - dx -----------------------+
	 jrle	3					;   if(n > 0) // if(dx < left)
	  add	%r5, %r11				;     %r5  := dx += n // dx + (left - dx) = left
	  sub	%r6, %r11				;     %r6  := dw -= n
	 sub	%r12, %r5				;   %r12 := right - dx
	 cmp	%r6, %r12				;   if(dw > right - dx) // if(dx + dw > right)
	 jrle	4
	  sub	%r12, %r6				;     %r12 := -n = -(dx + dw - right) = right - dx - dw
	  add	%r6, %r12				;     %r6  := dw += -n // dw -= n
	  sub	%r7, %r12				;     %r7  := sx -= -n // sx += n
new_pceLCDDrawObject_X_STORE:
	xcmp	%r6, 0					; if(dw <= 0) return 0
	xjrle	new_pceLCDDrawObject_RET0
	xld.h	[%sp+4], %r5				; store out.dx
	xld.h	[%sp+8], %r6				; store out.dw
	xld.h	[%sp+16], %r7				; store out.sx
	;-----------------------------------------------;
	xld.h	%r5, [%sp+46]				; %r5  := dy     = in.dy
	xld.h	%r6, [%sp+50]				; %r6  := dh     = in.dh
	xld.h	%r7, [%sp+58]				; %r7  := sy     = in.sy
	xld.ub	%r11, [%sp+61]				; %r11 := top    = in.clip.top
	xld.ub	%r12, [%sp+63]				; %r12 := bottom = in.clip.bottom
	xld.b	[%sp+21], %r11				; store out.clip.top
	xld.b	[%sp+23], %r12				; store out.clip.bottom
	xand	%r9, %r4, 0x4000			; if(!(param & DRW_REVY))
	xjrne.d	new_pceLCDDrawObject_REVY
	 sub	%r11, %r5				;   %r11 := n = top - dy <-----------------------+	*delay*
	 jrle	4					;   if(n > 0) // if(dy < top)                    |
	  add	%r5, %r11				;     %r5  := dy += n // dy + (top - dy) = top   |
	  sub	%r6, %r11				;     %r6  := dh -= n                            |
	  add	%r7, %r11				;     %r7  := sy += n                            |
	 sub	%r12, %r5				;   %r12 := bottom - dy                          |
	 cmp	%r6, %r12				;   if(dh > bottom - dy) // if(dy + dh > bottom) |
	 xjrle	new_pceLCDDrawObject_Y_STORE		;                                                |
	  xjp.d	new_pceLCDDrawObject_Y_STORE		;                                                |
	  ld.w	%r6, %r12				;     %r6  := dh = bottom - dy                   |	*delay*
new_pceLCDDrawObject_REVY:				; else                                           |
;//	 sub	%r11, %r5				;   %r11 := n = top - dy ------------------------+
	 jrle	3					;   if(n > 0) // if(dy < top)
	  add	%r5, %r11				;     %r5  := dy += n // dy + (top - dy) = top
	  sub	%r6, %r11				;     %r6  := dh -= n
	 sub	%r12, %r5				;   %r12 := bottom - dy
	 cmp	%r6, %r12				;   if(dh > bottom - dy) // if(dy + dh > bottom)
	 jrle	4
	  sub	%r12, %r6				;     %r12 := -n = -(dy + dh - bottom) = bottom - dy - dh
	  add	%r6, %r12				;     %r6  := dh += -n // dh -= n
	  sub	%r7, %r12				;     %r7  := sy -= -n // sy += n
new_pceLCDDrawObject_Y_STORE:
	xcmp	%r6, 0					; if(dh <= 0) return 0
	xjrle	new_pceLCDDrawObject_RET0
	xld.h	[%sp+6], %r5				; store out.dy
	xld.h	[%sp+10], %r6				; store out.dh
;//	xld.h	[%sp+18], %r7				; store out.sy ----------+
	;-----------------------------------------------;                        |
	xld.w	%r4, [%sp+40]				; %r4  := dest = in.dest |
	xld.h	[%sp+18], %r7				; <----------------------+				*anti-interlock*
	xcmp	%r4, 0					; if(!dest)
	xjrne	new_pceLCDDrawObject_DEST
	 xcall.d pceLCDSetBuffer			;   %r10 := pceLCDSetBuffer(INVALIDPTR)
	 ld.w	%r12, -1				;							*delay*
	 xld.w	%r4, 0x00580080				;   %r4  := DISP_X,DISP_Y
	 xld.w	[%sp+28], %r4				;   store tmp.w,h
	 xld.w	[%sp+32], %r10				;   store tmp.buf
	 xadd	%r4, %sp, 28				;   %r4  := dest = &tmp
new_pceLCDDrawObject_DEST:
	xld.w	[%sp+0], %r4				; store out.dest
	;-----------------------------------------------;
	xcall	PDW_Draw_4BN
	xld.w	%r10, 1					; %r10 := 1 (߂l)
new_pceLCDDrawObject_RET0:
	xadd	%sp, %sp, 36
	ret
	;-----------------------------------------------;
new_pceLCDDrawObject_OLD:
	xld.w	%r4, [_ldirect+4]			; %r4 := _ldirect.old_pceLCDDrawObject
	jp	%r4					; return _ldirect.old_pceLCDDrawObject(obj)		!INTERLOCK!
");
