/*	
 *	clipc62.h
 *
 *	P/ECE HuC6280 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_C62_H__
#define __CLIP_C62_H__

/****************************************************************************
 *
 ****************************************************************************/

/* HUC6280_ASMV{`ǂݍ݂܂B
 * HUC6280_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipc62a.h"

/* ̃V{`ƁASĂ̖ߎsg[Xo͂܂B
 * ̃V{`Ȃ΁Aeߎs̓g[Xo͂܂B
 * SĂ̖ߎsg[XƂƂĂxȂ̂ŁAʏ͒`ȂłB
 * ȂÃV{`ĂAŜ̃g[XONwgTRACE_ON=1hȂ΁A
 * g[Xo͍͂s܂B
 */
//#define HUC6280_TRACE

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef HUC6280_ASM
#endif /*PIECE*/

/* AZuR[h͑S߃g[XɑΉĂȂ̂ŁA
 * AZuR[hgp͊mɑS߃g[XOFFɂ܂B
 */
#ifdef HUC6280_ASM
#undef HUC6280_TRACE
#endif /*HUC6280_ASM*/ 

#ifdef HUC6280_TRACE
#define HUC6280TRACE	TRACE
#else /*HUC6280_TRACE*/
#define HUC6280TRACE	1 ? ((void)0) : TRACE
#endif /*HUC6280_TRACE*/

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _HUC6280 HUC6280;

/*
 *	HuC6280RAO֐̌^`
 */
typedef unsigned char HUC6280READPROC  (HUC6280* huc6280, unsigned short addr);
typedef          void HUC6280WRITEPROC (HUC6280* huc6280, unsigned short addr, unsigned char data);
typedef          void HUC6280MPRSETPROC(HUC6280* huc6280, int addr/*0`7*/, unsigned char data);
typedef          void HUC6280VDCOUTPROC(HUC6280* huc6280, int addr/*0`2*/, unsigned char data);

/*
 *	HuC6280RA
 *
 *	* mpr_enɂ
 *	- {G~[VvOƎdlŁA{HuC6280ɂ͂܂B
 *	- mpr_enbit0`7MPR0`7ɑΉA0:ݒ/1:ݒς \܂B
 *	  Zbg 0:ݒ ŁAMPRiݒ肳 1:ݒς ɂȂ܂B
 *	  1:ݒς => 0:ݒ ɕω邱Ƃ͂܂B
 *	- ̃tB[hKvƂȂŔA̒ʂłB
 *	  MPRi̒lɂ́Al܂B
 *	  (PC-Engineł͐΂ɎgȂl͂܂AHuC6280̎dlł͂܂)
 *	  AMPRi̓[NAĂ܂B
 *	  MPRi0ݒ肵ĂA0 => 0 ŕωAO֐Ă΂ȂƂɂȂĂ܂܂B
 *	  ŁAMPRi̒l̕ω̗LɊ֌WȂAmpr_en̑Ήrbg0Ȃ΁A
 *	  Zbg͂߂ĂMPRiݒƌȂāAO֐ĂԂƂɂ܂B
 *	  ̌Ampr_en̑Ήrbg1ɂ܂B
 *	  񂩂́AMPRiωꍇ̂݁AO֐Ă΂܂B
 */
/*typedef*/ struct _HUC6280 {
	/*===== WX^ =====*/
	unsigned char p;		/* + 0, 1 */
	unsigned char a;		/* + 1, 1 */
	unsigned char x;		/* + 2, 1 */
	unsigned char y;		/* + 3, 1 */
	unsigned short pc;		/* + 4, 2 */
	unsigned char s;		/* + 6, 1 */
	unsigned char mpr_en;		/* + 7, 1 */
	unsigned char mpr[8];		/* + 8, 8 */
	/*=====  =====*/
	int cycle;			/* +16, 4 */
	unsigned char halt;		/* +20, 1 */
	unsigned char pending;		/* +21, 1 */
	unsigned char resv2[2];		/* +22, 2 */
	/*===== O֐ =====*/
	HUC6280READPROC* read;		/* +24, 4 */
	HUC6280WRITEPROC* write;	/* +28, 4 */
	HUC6280MPRSETPROC* mprset;	/* +32, 4 */
	HUC6280VDCOUTPROC* vdcout;	/* +36, 4 */
} /*HUC6280*/;				/* =40    */

/* HUC6280.pending */
#define HUC6280_IRQ1_PENDING	(1 << 0)	/* IRQ1 ۗ (Dx) */
#define HUC6280_IRQ2_PENDING	(1 << 1)	/* IRQ2 ۗ (Dx) */

/*
 *	荞݃xN^AhX
 */
#define HUC6280_RESET_VECTOR	0xfffe		/* RESET    P(I)ɂ}XNs */
#define HUC6280_NMI_VECTOR	0xfffc		/* NMI      P(I)ɂ}XNs */
#define HUC6280_TIMER_VECTOR	0xfffa		/* TIMER    P(I)ɂ}XNs <<v!!>> */
#define HUC6280_IRQ1_VECTOR	0xfff8		/* IRQ1/VDC P(I)ɂ}XN\ */
#define HUC6280_IRQ2_VECTOR	0xfff6		/* IRQ2/BRK P(I)ɂ}XN\ */

/*
 *	CXgNV֐錾
 */
typedef                    void HUC6280OPPROC (HUC6280* huc6280, unsigned char code, int arg1, int arg2, int arg3);
#define HUC6280FN_(OP, FN) void huc6280op_##FN(HUC6280* huc6280, unsigned char code, int arg1, int arg2, int arg3);	/* 錾p */
#include "huc6280/list.h" /* [huc6280.xls]List */
HUC6280FN_("ILL_IMP", ILL_IMP)
#undef  HUC6280FN_
#define HUC6280FN_(    FN) void huc6280op_##FN(HUC6280* huc6280, unsigned char code, int arg1, int arg2, int arg3)	/* `p */

/*
 *	IyR[h}bvEj[jbNe[u
 */
typedef struct _HUC6280OP {
	HUC6280OPPROC* proc;	/* + 0, 4 */
	unsigned char addr;	/* + 4, 1 */
	unsigned char cycle;	/* + 5, 1 */
	unsigned short name;	/* + 6, 2 huc6280_op_name_table[]̕ւ̃ItZbgł */
} HUC6280OP;			/* = 8    */
#define HUC6280OP_(CODE, MNEMONIC, ADDRMODE, FUNCTYPE, CYCLE, NAME)	{ huc6280op_##MNEMONIC##_##FUNCTYPE, HUC6280_##ADDRMODE, CYCLE, 0x##NAME },
extern const HUC6280OP huc6280_op_table[256/*opcode*/];
extern const char huc6280_op_name_table[];	/* j[jbNe[u */

//***** HUC6280OP.addr  *****	// Name                           | Syntax
//===== operand bytes=0 =====	//                                |
#define HUC6280_ACC	 0	// accumulator                    | a
#define HUC6280_IMP	 1	// implied                        |
//===== operand bytes=1 =====	//                                |
#define HUC6280_IMM	 2	// immediate                      | #$nn
#define HUC6280_ZPG	 3	// zero page                      | <$nn
#define HUC6280_ZPX	 4	// zero page, x-indexed           | <$nn,x
#define HUC6280_ZPY	 5	// zero page, y-indexed           | <$nn,y
#define HUC6280_ZPI	 6	// zero page indirect             | [$nn]
#define HUC6280_IDX	 7	// zero page pre-indexed          | [$nn,x]
#define HUC6280_IDY	 8	// zero page post-indexed         | [$nn],y
#define HUC6280_REL	 9	// relative offset                | *
//===== operand bytes=2 =====	//                                |
#define HUC6280_ABS	10	// absolute                       | $nnnn
#define HUC6280_ABX	11	// absolute x-indexed             | $nnnn,x
#define HUC6280_ABY	12	// absolute y-indexed             | $nnnn,y
#define HUC6280_IND	13	// indirect                       | [$nnnn]
#define HUC6280_IAX	14	// indirect, x-indexed            | [$nnnn,x]
#define HUC6280_IMZ	15	// immediate zero page            | #$nn,<$nn
#define HUC6280_IZX	16	// immediate zero page, x-indexed | #$nn,<$nn,x
#define HUC6280_ZRL	17	// zero page, relative offset     | <$nn,*
//===== operand bytes=3 =====	//                                |
#define HUC6280_IMA	18	// immediate absolute             | #$nn,$nnnn
#define HUC6280_IMX	19	// immediate absolute, x-indexed  | #$nn,$nnnn,x
//===== operand bytes=6 =====	//                                |
#define HUC6280_BLK	20	// block transfer                 | $nnnn,$nnnn,$nnnn

/****************************************************************************
 *	֐
 ****************************************************************************/

/* HuC6280Zbgɐݒ肳AHuC6280RÅO֐łB
 * AvP[V璼ڌĂяoƂ͂܂B
 */
unsigned char huc6280_internal_read  (HUC6280* huc6280, unsigned short addr);
         void huc6280_internal_write (HUC6280* huc6280, unsigned short addr, unsigned char data);
         void huc6280_internal_mprset(HUC6280* huc6280, int addr/*0`7*/, unsigned char data);
         void huc6280_internal_vdcout(HUC6280* huc6280, int addr/*0`2*/, unsigned char data);

/* MPR[addr]ɒlݒ肵AωMPRݒO֐Ăяo܂B
 */
void huc6280_mpr_set(HUC6280* huc6280, int addr/*0`7*/, unsigned char data);

/* ۗĂ}XN\荞݂AĂ犄荞݂s܂B
 * CC(I,F)܂PENDINGω\̂鏈sɁAKĂяoĂB
 */
void huc6280_check_pending(HUC6280* huc6280);

/* 荞݂s܂B
 */
void huc6280_int(HUC6280* huc6280, int vector, int brk);

/* 荞݂畜A܂B
 */
void huc6280_rti(HUC6280* huc6280);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* HuC6280Zbg܂B
 * [in]
 *	huc6280		HUC6280\́B
 *	read		CREAD O֐ (NULL:RA֐gp)
 *	write		CWRITEO֐ (NULL:RA֐gp)
 *	mprset		MPRXVO֐           (NULL:RA֐gp)
 *	vdcout		VDCo͊O֐           (NULL:RA֐gp)
 * [note]
 *	* read,write,mprset,vdcoutNULLw肷ƁARÅO֐gp܂B
 *	  RÅO֐́Â悤ȓs܂B
 *	  Eread	HUC6280\̂̒64KB̃CzuĂƉ肵ACǂݍ݂܂B
 *	  Ewrite	HUC6280\̂̒64KB̃CzuĂƉ肵ACɏ݂܂B
 *	  Emprset	܂B
 *	  Evdcout	܂B
 */
void huc6280_reset(HUC6280* huc6280, HUC6280READPROC* read, HUC6280WRITEPROC* write, HUC6280MPRSETPROC* mprset, HUC6280VDCOUTPROC* vdcout);

/* HuC6280s܂B
 * [in]
 *	huc6280		HUC6280\́B
 *	cycle		sTCNB
 * [note]
 *	* sTCNcycleɒB邩A܂HALTԂɂȂ܂Ŏs܂B
 *	  O҂̏ꍇAۂ̎sTCŃAcycleȂ\܂B
 *	  ҂̏ꍇAۂ̎sTCŃAcycleȂȂ\܂B
 *	* ̊֐߂ƂAhuc6280->cycleɎcsTCNi[Ă܂B
 *	  Ⴆ cycle=100 ŌĂяoAۂɂ 105 TCNsꍇAhuc6280->cycle=-5 ƂȂ܂B
 *	* {HuC6280HALTɑ閽߂ĂȂ߁AHALTԂ݂܂B
 *	  HALTԂ́A{G~[VvOƎɒ`̂łB
 *	* HuC6280HALT߂ĂȂ̂ŁAʂ̕@gHALTԂւ̈ڍswKv܂B
 *	  Ⴆ΁ACԋ󂫗̈̓AhXւ̃}WbNio[o͂HALTƉ߂A
 *	  AvP[V`WRITEO֐HUC6280.halt1ɃZbgA̕@̂ĂB
 */
void huc6280_run(HUC6280* huc6280, int cycle);

/* }XNs荞݃NGXg𔭍s܂B
 * [in]
 *	huc6280		HUC6280\́B
 * [note]
 *	* 荞݃NGXg͑Ɏ󂯕t܂B
 *	  P(I)=1ɂă}XN邱Ƃ͂܂B
 */
void huc6280_nmi(HUC6280* huc6280);
void huc6280_timer(HUC6280* huc6280);

/* }XN\荞݃NGXg𔭍s܂B
 * [in]
 *	huc6280		HUC6280\́B
 * [note]
 *	* P(I)=1̏ꍇA荞݃NGXg͕ۗ܂B
 *	  P(I)=0ɂȂɁA荞݂s܂B
 */
void huc6280_irq1(HUC6280* huc6280);
void huc6280_irq2(HUC6280* huc6280);

/* WG[o͂ɁAWX^_vs܂B
 * [in]
 *	huc6280		HUC6280\́B
 */
void huc6280_dump(HUC6280* huc6280);

#ifdef PIECE
/* HuC6280s܂B(X^bNؑցE)
 * [in]
 *	huc6280		HUC6280\́B
 *	cycle		sTCNB
 * [note]
 *	* huc6280_run()Ƃ̈Ⴂ́Å֐̎ŝ݁AX^bN0x0e00`0x1000̍RAMɐ؂芷邱ƂłB
 *	- 0x0e00`0x1000́AP/ECEJ[lIɍRAM[`]ĎgpGAłB
 *	  Ⴆ΁ApceLCDTrans()pceFileWriteSct()ÃGAɍRAM[`]܂B
 *	  IɎgp邽߁AAPIɂ0x0e00`0x1000j󂳂邱Ƃ𗯈ӂĂ΁A
 *	  AvP[VvÖ̗gƂ\łB
 *	- huc6280_run()̎́Acallgp񐔂ɑ߁AX^bNRAMɈڂƂɂ͈Ӗ܂B
 *	  huc6280_run2()̓X^bN0x1000ɈڂAhuc6280_run()ĂяoAX^bNɖ߂ďԂ܂B
 *	- X^bNGA0x0e00`0x1000512oCgȂ̂ŁAhuc6280_run2()̎gpɂ͏܂B
 *	  Ehuc6280_run()ƂĂ΂閽ߏ֐́A傫ȃX^bNt[mۂĂ͂܂B
 *	    eߏ̎ύXꍇ́AӂĂB
 *	  Ehuc6280_run()Ă΂O֐(READ/WRITE)ł́A傫ȃX^bNt[mۂĂ͂܂B
 *	  EX^bN悤Ȋ荞݃[`Ƃ̕p͕słB
 *	    X^bN0x0e00`0x1000ɐ؂ւĂƂɊ荞݂ƁAX^bNӂ鋰ꂪ邩łB
 *	  Ehuc6280_run2()荞݃[`ŌĂяoĂ͂܂B
 *	    OʂŁApceLCDTrans()0x0e00`0x1000GAgpł\邩łB
 *	- ȏ̂悤Ȑ񂪂̂ŁAhuc6280_run2()̎gpɂ͏[ȒӂKvłB
 *	  huc6280_run()gꍇɊrׂāAhuc6280_run2()gꍇ̌ʂ́A20%̍ƂȂ܂B
 */
void huc6280_run2(HUC6280* huc6280, int cycle);
#endif /*PIECE*/

#endif /*__CLIP_C62_H__*/
