/*	
 *	clipapu.h
 *
 *	P/ECE APU (RICOH RP2A03) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun Feb 06 18:39:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_APU_H__
#define __CLIP_APU_H__

/****************************************************************************
 *
 ****************************************************************************/

/* APU_ASMV{`ǂݍ݂܂B
 * APU_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipapua.h"

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef APU_ASM
#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

#define APUBUFLEN 320 /* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

#define APU_CLOCK (NTSC_COLOR_SUBCARRIER / 2) /* APU̓NbN(t@~R) */

/*  */
/* AZu[`璼ڎQƂĂ̂ŁAtH[}bgŒłB */
/* tH[}bgύXƂ́Aframapua.s̒`Ǐ]ĂB */
/*  */

/* OXJE^ (60Hz) */
typedef struct _APULENGTH {
	unsigned char flags;		/* + 0,1: D0: 0 = OXJE^ */
					/*            1 = OXJE^L */
	unsigned char count;		/* + 1,1: OXJE^ (0..127) */
} APULENGTH;				/* = 2 */

/* jAJE^ (240Hz) */
typedef struct _APULINEAR {
	unsigned char flags;		/* + 0,1: D0: 0 = jAJE^ */
					/*            1 = jAJE^L */
	unsigned char count;		/* + 1,1: jAJE^ (0..127) */
} APULINEAR;				/* = 2 */

/* Gx[v (240Hz) */
typedef struct _APUENVELOPE {
	unsigned char flags;		/* + 0,1: D0: 0 = Gx[v */
					/*            1 = Gx[vL */
					/*        D1: 0 = [v */
					/*            1 = [vL */
	unsigned char period;		/* + 1,1: XV (1..16) */
	unsigned char count;		/* + 2,1: isJE^ (0..16) */
	unsigned char volume;		/* + 3,1: {[ (0..15) */
} APUENVELOPE;				/* = 4 */

/* XC[v (120Hz) */
typedef struct _APUSWEEP {
	unsigned char flags;		/* + 0,1: D0: 0 = XC[v */
					/*            1 = XC[vL */
					/*        D1: 0 =  */
					/*            1 =  */
	unsigned char shift;		/* + 1,1: gʂ̃Vtg */
	unsigned char period;		/* + 2,1: XV (1..8) */
	unsigned char count;		/* + 3,1: isJE^ (0..8) */
	short wavelength;		/* + 4,2: g ($000..$800) */
} APUSWEEP;				/* = 6 */

/* `g (Ch0,Ch1) */
typedef struct _APUSQUARE {
	APULENGTH length;		/* + 0,2: OXJE^ */
	APUENVELOPE envelope;		/* + 2,4: Gx[v */
	APUSWEEP sweep;			/* + 6,6: XC[v */
	unsigned char duty;		/* +12,1: f[eBTCN (2,4,8,12) */
	unsigned char waveindex;	/* +13,1: g`CfNX (0..15) */
					/* +14,2: (pfBO) */
	int wavecount;			/* +16,4: g`isJE^ */
} APUSQUARE;				/* =20 */

/* Opg (Ch2) */
typedef struct _APUTRIANGLE {
	APULENGTH length;		/* + 0,2: OXJE^ */
	APULINEAR linear;		/* + 2,2: jAJE^ */
	short wavelength;		/* + 4,2: g ($000..$7ff) */
	unsigned char waveindex;	/* + 6,1: g`CfNX (0..31) */
					/* + 7,1: (pfBO) */
	int wavecount;			/* + 8,4: g`isJE^ */
} APUTRIANGLE;				/* =12 */

/* mCY (Ch3) */
typedef struct _APUNOISE {
	APULENGTH length;		/* + 0,2: OXJE^ */
	APUENVELOPE envelope;		/* + 2,4: Gx[v */
	unsigned char mode;		/* + 6,1: 1 = long mode, 6 = short mode */
					/* + 7,1: (pfBO) */
	unsigned short lfsr;		/* + 8,2: LFSR (Linear Feedback Shift Register) */
	short wavelength;		/* +10,2: g ($004..$fe4) */
	int wavecount;			/* +12,4: g`isJE^ */
} APUNOISE;				/* =16 */

/* f^PCM (Ch4) */
typedef struct _APUDMC {
	unsigned char flags;		/* + 0,1: D0: 0 = [v */
					/*            1 = [vL */
					/*        D7: JnɁAapu_write()  Zbg(1)܂B */
					/*            ɁAapu_dmc_mix()NA(0)܂B */
	char init_output;		/* + 1,1: o͏l (-64..63) */
	unsigned short init_address;	/* + 2,2: TvAhXl ($C000..$FFC0) */
	short init_length;		/* + 4,2: Tvf[^l ($001..$FF1) o͏l1JEgƌȂ */
	short wavelength;		/* + 6,2: g ($036..$1ac) */
	//
					/* + 8,1: (pfBO) */
	char output;			/* + 9,1: ݂̏o͒l (-64..63) */
	unsigned short address;		/* +10,2: TvAhX (init_address->$FFFF->$8000->$FFFF) */
	short length;			/* +12,2: cTvf[^ (init_length->$000) */
	unsigned short sample;		/* +14,2: Tvobt@ */
					/*        Tv擾 (0x100|data) Zbg܂B */
					/*        ŉʃrbg邽тɁAEVtg܂B */
					/*        (sample<=1) Ȃ΁ATvobt@łB */
	int wavecount;			/* +16,4: g`isJE^ */
	//
	const unsigned char* memory;	/* +20,4: Tvf[^̐擪AhX */
} APUDMC;				/* =24 */

typedef struct _APU {
	unsigned char regs[0x20];	/* WX^ ($4000-$401F) */
	//
	APUSQUARE square[2];		/* Ch1-2: `g */
	APUTRIANGLE triangle;		/*   Ch3: Opg */
	APUNOISE noise;			/*   Ch4: mCY */
	APUDMC dmc;			/*   Ch5: f^PCM */
	//
	unsigned char irq;		/*   D7: f^PCM IRQ */
					/*   D6: Frame IRQ     */
					/* D5-0: 0             */
	unsigned char fc_250_240;	/* 250Hz->240HzϊpJE^ */
	unsigned char framecount;	/* 240HzJE^[4->]3->2->1->0 */
} APU;

extern APU apu;

/****************************************************************************
 *
 ****************************************************************************/

extern const unsigned char apu_square_duty_table[4];
extern const char apu_triangle_waveform_table[32];
extern const short apu_noise_wavelength_table[16];
extern const short apu_dmc_wavelength_table[16];
extern const unsigned char apu_length_count_table[32];

void apu_do_length(APULENGTH* length);
void apu_do_linear(APULINEAR* linear);
void apu_do_envelope(APUENVELOPE* envelope);
void apu_do_sweep(APUSWEEP* sweep);

void apu_square_mix(APUSQUARE* square, short wbuff[/*64*/]);
void apu_triangle_mix(APUTRIANGLE* triangle, short wbuff[/*64*/]);
void apu_noise_mix(APUNOISE* noise, short wbuff[/*64*/]);
void apu_dmc_mix(APUDMC* dmc, short wbuff[/*64*/]);
void apu_volume_shift(short wbuff[/*APUBUFLEN*/]);

/****************************************************************************
 *
 ****************************************************************************/

/* APURAZbg܂B
 * [in]
 *	memory		Tvf[^̐擪AhXB
 *			f^PCM`lAmemory[$8000..$FFFF]QƂ܂B
 *			t@~R̃C擪AhXw肵ĂB
 * [note]
 *	* ̓NbŃA1.79MHzɌߌłB
 *	  AvP[VA̓NbNw肷邱Ƃ͂ł܂B
 */
void apu_reset(const void* memory);

/* APU1oCg݂܂B
 * [in]
 *	addr		ރAhXB($4000..$4017)
 *			D4:0ȊO̓}XN̂ŁA0x00..0x17ł\܂B
 *	data		ރf[^B
 */
void apu_write(int addr, int data);

/* APU1oCgǂݏo܂B
 * [in]
 *	addr		ǂݏoAhXB($4000..$4017)
 *			D4:0ȊO̓}XN̂ŁA0x00..0x17ł\܂B
 */
int apu_read();

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁA320Tṽ~LVOs܂B
 * [in]
 *	wbuff		o̓Tvobt@B
 */
void apu_mix(short wbuff[/*APUBUFLEN*/]);

#endif /*__CLIP_APU_H__*/
