#include "app.h"

static const LIST_INFO ptrListInfo = {
	ptr_copy,	/* val_copy */
	ptr_delete,	/* val_delete */
};

LIST* bullet_list;

static BulletMLUserFunc userFunc;
static void createBullet(void* userData, fixed direction, fixed speed, BulletMLNode* bulletNode, const fixed params[/*BULLETML_MAX_PARAMS*/]) {
	static int id;
	// <bullet><direction><speed>D悷Ȃ΁Adirection,speedi[B
	list_add(bullet_list, BulletMLBullet_new(&userFunc, (void*)id++, bulletNode, params));
	// <fire><direction><speed>D悷Ȃ΁Adirection,speedi[B
}
static BulletMLUserFunc userFunc = {
	createBullet,
};

POOL file_pool = { sizeof(FILE) };

int
main(int argc, char* argv[])
{
	int t = 0;
	int i;
	const char* fname = argc == 1 ? "simple1.xml" : argv[1];

	BulletMLNode* bulletml;

	DEBUG_INIT();

	bulletml = BulletML_load(fname);
	BulletMLNode_dump(bulletml, 0);

	bullet_list = list_create(&ptrListInfo);
	createBullet(NULL, 0, 0, bulletml, NULL);

	while(!list_empty(bullet_list)) {
		printf("----------------------------------- %d -----------------------------------\n", t++);
		for(i = list_size(bullet_list) - 1; i >= 0; i--) {
			BulletMLBullet* bullet = list_get(bullet_list, i);
			if(!BulletMLBullet_run(bullet)) {
				list_remove(bullet_list, i);
				BulletMLBullet_delete(bullet);
			}
		}
	}
	printf("OK\n");

	BulletMLNode_delete(bulletml);
	list_delete(bullet_list);

	if(argc == 1) {
		getchar(); /* simple1.xmlǂ񂾌AmF̂߂ɉʒ~ */
	}

	return 0;
}

/*{{clipfix.c,framfix.c*/
fixed frnd(int* seed) {
	return (fixed)(rnd32(seed) & FRACT_MASK);
}
fixed fmul(fixed a, fixed b) {
	__int64 aa, bb, cc;
	aa = (int)a;
	bb = (int)b;
	cc = (aa * bb) >> FRACT_BITS;
	return (fixed)(int)cc;
}
fixed fdiv(fixed a, fixed b) {
	__int64 aa, bb, cc;
	aa = (int)a;
	bb = (int)b;
	cc = (aa << FRACT_BITS) / bb;
	return (fixed)(int)cc;
}
/*}}clipfix.c,framfix.c*/
