/*
 *	app.c
 *
 *	Luaxv
 *
 *	* Sun Feb 05 22:56:09 JST 2012 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jan 24 19:25:38 JST 2015 Naoyuki Sawa
 *	- uLua 5.3.0vōČv܂B
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_SOUND
const void* sound_table[SOUND_COUNT];
#endif /*USE_SOUND*/

#ifdef USE_TEXTURE
TEXTURE texture_table[TEXTURE_COUNT];
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
#define SPRITE_ SPRITE_INIT2
const SPRITE sprite_table[SPRITE_COUNT] = {
#include "sprite.h"
};
#undef SPRITE_
#endif /*USE_SPRITE*/

#define extern
#include "work.h"
#undef extern

/****************************************************************************
 *	main
 ****************************************************************************/

int
main()
{
	/* B */
	app_init();

	/* C[vB */
	app_main();

	return 0;
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

#ifdef  USE_SOUND_MANAGER
static void sound_play_stub(int iCh, int iData, int iLoop) {
	if((unsigned)iData >= SOUND_COUNT) { DIE(); }
	sound_play(iCh, sound_table[iData], iLoop);
}
#endif/*USE_SOUND_MANAGER*/

#ifdef  USE_SOUND_MIXER
static void SndMxr_Update() {
	int i;
	unsigned char AttSum[32];
	SndMxr_GetSndChAttAll(pSndMxr,-1,AttSum); //Sق̌ʂ擾
	for(i=0;i<SOUND_MAXCH;i++) {sound_att(i,AttSum[i]);} //Sق̌ʂݒ肷
}
static void SndMxr_TimerProc(void* context) { //Sound Mixerpϊ
	if(sound_stat(1)) {SndMxr_SetMxrChAtt(pSndMxr,4,64, 0,0);} //1ŉoBGMĐȂΤðBGM𑦏          
	else              {SndMxr_SetMxrChAtt(pSndMxr,4, 0,64,5);} //1ŉoBGM~ȂΤðBGM0.5bŕA     {{TODO:عݒ}}
	if(sound_stat(3)) {SndMxr_SetMxrChAtt(pSndMxr,5,64, 0,0);} //3ŴװĐȂΤðBGM,oBGM,SE𑦏 
	else              {SndMxr_SetMxrChAtt(pSndMxr,5, 0, 0,0);} //3Ŵװ~ȂΤðBGM,oBGM,SE𑦕A 
	SndMxr_Exec(pSndMxr); //Sound Mixers
	SndMxr_Update(); //Sق̌ʂݒ肷
}
#endif/*USE_SOUND_MIXER*/

#ifdef  USE_SOUND_SEQUENCER
static int SndSeq_fnLen(int iPhr) {
	return ppd_playback_time(sound_table[iPhr]);
}
static int SndSeq_fnNext(int iPhr) {
	return (iPhr == SND_BGM_1G) || (iPhr == SND_BGM_ST) ? iPhr : -1;
}
static int SndSeq_fnPrev(int iPhr) {
	return (iPhr == SND_BGM_1G) || (iPhr == SND_BGM_ST) ? iPhr : -1;
}
static void SndSeq_fnPan(int iTrk, int iPan) {
	//P/ECEɂ̓XeIĐ͖̂ŁA{֐͎gpȂB
}
static void SndSeq_fnVol(int iTrk, int iVol) {
	SndMxr_SetMxrChAtt(pSndMxr, iTrk, 64-(iVol*64/SndVol_Max), 0, 0);
	SndMxr_Update();
}
static void SndSeq_fnStop(int iTrk) {
	sound_stop(iTrk);
}
static void SndSeq_fnPlay(int iTrk, int iPhr, int iVol, int iPan) {
	sound_play(iTrk, sound_table[iPhr], -1);
	SndMxr_SetMxrChAtt(pSndMxr, iTrk, 64-(iVol*64/SndVol_Max), 0, 0);
	SndMxr_Update();
}
static int SndSeq_fnTime() {
	return pceTimerGetCount(); //ݎ[ms]PʂŕԂB
}
#endif/*USE_SOUND_SEQUENCER*/

#ifdef  USE_EVENT_TIMER
static void EvtTmr_onEvent(int iEvtTmrCh, int iEvent) { //ϗpď֐
	TRACE("%d:%d:%d\n", now / FPS, iEvtTmrCh, iEvent);
}
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_LOG_BUFFER
static int LogBuf_fnDraw(int x, int y, const char* Str) { //عݒ`̕`֐
	render_reduced_string(&render, x, y, Str, 3);
	return 10;
}
#endif/*USE_LOG_BUFFER*/

void
app_init()
{
#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈ݒ肵܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_init();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND

	/* ʓIȏB */
	pceAppSetProcPeriod(1000 / FPS);
#ifdef V_SCREEN
	pceLCDSetBuffer(_def_vbuff);
#else /*V_SCREEN*/
	pceLCDSetBuffer(vbuff);
#endif /*V_SCREEN*/
//sv	pceLCDDispStart();	//{{2014/12/31폜:cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B}}
#ifdef USE_REPEAT
	pad_set_repeat(REPEAT_PAD, REPEAT_DELAY, REPEAT_INTERVAL);
#endif /*USE_REPEAT*/

	/* `B */
	surface.w = DISP_X;
	surface.h = DISP_Y;
	surface.vbuff = vbuff;
#ifdef USE_3D
	surface.zbuff = zbuff;
	render_init_3d(&render, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#else /*USE_3D*/
	render_init_2d(&render, &surface, 0, 0, 0, 0);
#endif /*USE_3D*/
#ifdef USE_RENDF
	surface.zbuff = zbuff;
	rendf_init(&rendf, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#endif /*USE_RENDF*/

#if defined(TRACE_ON) && (TRACE_ON)
	/* WG[o͂J܂B */
	stderr_open(9/*WG[o̓j^ڑ҂()*/);
#endif /*TRACE_ON*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VJn܂B */
	ufe_setup(9/*PCt@CT[oڑ҂()*/);
#endif /*USE_UFE*/

#ifdef USE_RESOURCE
	/* pext@CYt\[X擾܂B */
	resource = resource_address(PRESCAN_STRINGIFY(PROJECT) ".pex");
#endif /*USE_RESOURCE*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

#ifdef USE_DBG
	/* DBGjbgݒ肵܂B */
	dbg_init();
#endif /*USE_DBG*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_init(GC_LEVEL);
#endif /*GC_LEVEL*/

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Init(BITMAP_GC_UNIT);
#endif /*BITMAP_GC_UNIT*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_init(LDIRECT_INTERVAL);
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_MUSIC
	/* yCu܂B */
	InitMusic();
#if defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)
	/* - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderƁAyCu𕹗pꍇ́AyCu̎gp`l炷Ƃɂ܂B
	 *   ̑΍sȂƁA`l0gp悤ƂāAnOAbvĂ܂܂B
	 * - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderɌ炸Astream_play()𗘗p@\ƁAyCuƕpꍇ́Al̑΍􂪕KvłB
	 * //{{2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B
	 * //- music_wchύX鏈́AInitMusic()ōsKv܂B
	 * //  InitMusic()Aumusic_wch = 0;vsĂ邩łBInitMusic()ɕύXƁA0ɖ߂Ă܂܂B
	 * //- Amusic_loudness()̋@\music_wchQƂĂ܂A
	 * //  Al擾Ă̂ŁAmusic_loudness()Ăяomusic_wchύXĂA͂܂B
	 * //}}2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B */
	music_wch = 3; /* `l0=2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderA`l1-2=AvP[VgpA`l3=yCuƂ */
#endif /*defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)*/
#endif /*USE_MUSIC*/

	/* N[Abv֐o^B */
	atexit(app_exit);

#ifdef USE_2BIT_ADPCM
	/* 2-bit ADPCM DecoderN܂B */
	adpcm_init(SOUND_MAXCH);
#endif /*USE_2BIT_ADPCM*/

#ifdef USE_TRUESPEECH
	/* DSP Group TrueSpeech DecoderN܂B */
	TrueSpeech_Init(SOUND_MAXCH);
#endif /*USE_TRUESPEECH*/

	/* TEh܂B */
#ifdef USE_SOUND
	{
#define SOUND_(name) { extern const unsigned char name[]; sound_table[SND_##name] = name; }
#define SOUND_RESOURCE_(name,fname) { sound_table[SND_##name] = fpk_address(resource, fname, NULL); }
#include "sound.h"
#undef SOUND_
#undef SOUND_RESOURCE_
	}
#endif /*USE_SOUND*/

	/* Sound Manager܂B */
#ifdef  USE_SOUND_MANAGER
	{
		static const ST_SndMgrInfo stSndMgrInfo = { sound_play_stub, sound_stop, sound_stat, sound_att };
		pSndMgrBgm = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_BGM_MINCH, SOUND_MANAGER_BGM_MAXCH); /* BGM Sound Manager */
		pSndMgrSe1 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE1_MINCH, SOUND_MANAGER_SE1_MAXCH); /* SE1 Sound Manager */
		pSndMgrSe2 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE2_MINCH, SOUND_MANAGER_SE2_MAXCH); /* SE2 Sound Manager */
	}
#endif/*USE_SOUND_MANAGER*/

	/* Sound Mixer܂B */
#ifdef  USE_SOUND_MIXER
	{
		static const int TBL_SndMxr_SndChMask[] = { //Ͻz
			(1<<0),               //Sound Mixer0:ׯ0(޼ݻɂحюw)         
			(1<<1),               //Sound Mixer1:ׯ1(޼ݻɂحюw)         
			(1<<2),               //Sound Mixer2:ׯ2(޼ݻɂحюw)         
			(1<<3),               //Sound Mixer3:ׯ3(޼ݻɂحюw)         {{TODO:عݒ}}
			(1<<0),               //Sound Mixer4:oBGMĐΏ:ðBGM            
			(1<<0)|(1<<1)|(1<<2), //Sound Mixer5:װĐΏ  :ðBGM,oBGM,SE 
			-1};                  //Sound Mixer6:İح           :S         
		pSndMxr = SndMxr_Init(ARRAY_SIZE(TBL_SndMxr_SndChMask), TBL_SndMxr_SndChMask); //Sound Mixer쐬
		timer_start(100, SndMxr_TimerProc, NULL); //Sound MixerpϊJn
	}
#endif/*USE_SOUND_MIXER*/

	/* TEhV[PT܂B */
#ifdef  USE_SOUND_SEQUENCER
	{
		static const ST_SndSeqInfo stSndSeqInfo = { &SndSeq_fnTime, &SndSeq_fnPlay, &SndSeq_fnStop, &SndSeq_fnVol, &SndSeq_fnPan, &SndSeq_fnLen, &SndSeq_fnNext, &SndSeq_fnPrev };
		SndSeq_Init(&stSndSeqInfo);
		timer_start(10, SndSeq_Exec, NULL); //޼ݻpϊJn
	}
#endif/*USE_SOUND_SEQUENCER*/

	/* Cxg^C}܂B */
#ifdef  USE_EVENT_TIMER
	{
		static const uint16_t TBL_EvtTmr_Data0[]={//#0ް
			SEC(0),10, //Jnɤޔԍ(10)s
			SEC(2),11, // 2b҂Ĥޔԍ(11)s
			SEC(1),12, // 1b҂Ĥޔԍ(12)s
			SEC(0),13, //̌シޔԍ(13)s
			SEC(3),-1};// 3b҂Ĥ擪ٰ߂
		static const uint16_t TBL_EvtTmr_Data1[]={//#1ް
			SEC(9),20, // 9b҂Ĥޔԍ(20)s
			SEC(0), 0};//̌シI
		static const uint16_t* const TBL_EvtTmr_Data[]={//eقް
			TBL_EvtTmr_Data0, //#0ް
			TBL_EvtTmr_Data1};//#1ް
		pEvtTmr=EvtTmr_Init(ARRAY_SIZE(TBL_EvtTmr_Data),TBL_EvtTmr_Data,EvtTmr_onEvent);//ς
	}
#endif/*USE_EVENT_TIMER*/

	/* ėpJE^Ǘ܂B */
#ifdef  USE_COUNTER_MANAGER
	pCntMgr = CntMgr_Init(COUNTER_MAXCH);
#endif/*USE_COUNTER_MANAGER*/

	/* Oobt@܂B */
#ifdef  USE_LOG_BUFFER
	pLogBuf = LogBuf_Init((DISP_Y+9)/10, LogBuf_fnDraw);
#endif/*USE_LOG_BUFFER*/

	/* eNX`܂B */
#ifdef USE_TEXTURE
	{
#define TEXTURE_(name) extern const unsigned char name[];
#define TEXTURE_RESOURCE_(name,fname) const void* const name = fpk_address(resource, fname, NULL);
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		texture_table_init(texture_table, TEXTURE_COUNT,
#define TEXTURE_(name) name,
#define TEXTURE_RESOURCE_(name,fname) name,
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		NULL/*Ō','z邽߂̃_~[Btexture_table_init()ɑ΂Ă͖ӖłB*/);
	}
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
	/* ȈՃXvCghCo܂B */
	sprite_init(&render, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
#endif /*USE_SPRITE*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gJn܂B */
	tcpip_start(0/*EthernethCoMobt@TCY()*/);
#endif /*USE_TCPIP*/

#ifdef USE_VIDREC
	/* ʏo͂܂B */
	yield(); /* runŎsꍇ̎smFɉ邽߁AUSB@\̐؂ւ͂ɒx点 */
#ifdef LDIRECT_INTERVAL
	cdcacm_start(0, sizeof vbuff / 2, NULL, NULL);
#else /*LDIRECT_INTERVAL*/
	cdcacm_start(0, sizeof vbuff / 4, NULL, NULL);
#endif /*LDIRECT_INTERVAL*/
#endif /*USE_VIDREC*/

#ifdef  USE_TASK
	/* ^XNXPW[܂B
	 * - AChXbhƕpꍇ́Aidle_proc()̒ŏĂB
	 *   AChXbhƕp@́Atask_yield()[note]QƂĂB */
	task_init(INT_MIN);//{{TODO:ѱ̎sDxͱعݒ}}
#endif/*USE_TASK*/

/*{{AvP[VL̏*/
	srand(pceTimerGetCount());
/*}}AvP[VL̏*/
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void
app_exit()
{
/*{{AvP[VL̃N[Abv*/
	/** no job **/
/*}}AvP[VL̃N[Abv*/

#ifdef USE_VIDREC
	/* ʏo͂I܂B */
	cdcacm_stop();
#endif /*USE_VIDREC*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gI܂B */
	tcpip_stop();
#endif /*USE_TCPIP*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_free();
#endif /*LDIRECT_INTERVAL*/

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Free();
#endif /*BITMAP_GC_UNIT*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_free();
#endif /*GC_LEVEL*/

#ifdef USE_DBG
	/* DBGjbg̐ݒ܂B */
	dbg_free();
#endif /*USE_DBG*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VI܂B */
	ufe_stop();
#endif /*USE_UFE*/

#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_free();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* * Mon Mar 10 13:29:56 JST 2008 Naoyuki Sawa
 * - update()AʍXV𕪗A܂B
 */
#ifdef V_SCREEN
/* vbuff(c)_def_vbuff()ϊ */
//static void rotate_screen() {
//	unsigned char *src = &vbuff[88 - 1];	/* ]̉ʂ͍ォ瑖Jn܂ */
//	unsigned char *dst = &_def_vbuff[0];	/* ]̏cʂ͉Eォ瑖Jn܂ */
//	int x = 88;
//	do {
//		int y = 128;
//		do {
//			*dst++ = *src;		/* ʂEɑ܂ */
//			src += 88;		/* cʂɑ܂ */
//		} while(--y);
//						/* ʂ͊Ɏ̍sֈړĂ܂ */
//		src -= 88 * 128 + 1;		/* cʂ̗̈ԏֈړ܂ */
//	} while(--x);
//}
// (C = 9.2ms/1call  ASM = 3.2ms/1call)
/*static*/ void rotate_screen();
asm("
	.code
	.align	1
rotate_screen:
	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	xld.w	%r13, rotate_screen_DOX		; %r13 := DOY
	xld.w	%r14, rotate_screen_END		; %r14 := END
	xcall.d	memcpy				; %r10 := FRAM4_START = memcpy(FRAM4_START, DOX, END - DOX)
	sub	%r14, %r13			; %r14 := END - DOY			*delay*
	xld.w	%r4, vbuff+87			; %r4  := src = &vbuff[88 - 1]
	xld.w	%r5, _def_vbuff			; %r5  := dst = &_def_vbuff[0]
	xld.w	%r6, 88				; %r6  := 88
	xld.w	%r7, 128			; %r7  := 128
	xld.w	%r11, 11265			; %r11 := 88 * 128 + 1
	ld.w	%r12, %r6			; %r12 := x = 88
	jp	%r10				; goto FRAM4_START			(jp.d͕s!!)
;//{{FRAM4̈֓]
rotate_screen_DOX:				; do {
	ld.w	%r13, %r7			;   %r13 := y = 128
rotate_screen_DOY:				;   do {
	ld.ub	%r9, [%r4]			;     %r9  := c = *src
	sub	%r13, 1				;     %r13 := --y			*anti-interlock*
	ld.b	[%r5]+, %r9			;     %r5  := *dst++ = c
	jrne.d	rotate_screen_DOY		;   } while(--y)
	add	%r4, %r6			;     %r4  := src += 88			*delay*
	sub	%r12, 1				;   %r12 := --x
	jrne.d	rotate_screen_DOX		; } while(--x)
	sub	%r4, %r11			;   %r4  := src -= 88 * 128 + 1		*delay*
	ret
rotate_screen_END:
;//}}܂FRAM4̈֓]
");
#endif /*V_SCREEN*/

/* * Mon Nov 06 17:37:17 JST 2006 Naoyuki Sawa
 * - schedule()AʍXV𕪗܂B
 *   t[҂ʍXVsꍇ́Å֐ĂяoĂB
 * * Thu Dec 21 21:17:56 JST 2014 Naoyuki Sawa
 * - Oobt@`A܂łschedule()ōsĂ܂Aupdate()ōs悤ɕύX܂B
 *   ɉāAOobt@`OŁAzVRAMۑ悤ɂ܂B
 *   ̕ύXɂāAAvP[V́AOobt@`̉e𖳎āAI[o[CƌȂ悤ɂȂ܂B
 *   ȉ̂悤ȏ\ƂȂ܂B
 *   1
 *   void app_main(){
 *     surface_clear(&surface,0);
 *     render_ellipse(&render,0,0,DISP_X,DISP_Y,3);//~`悷
 *     for(;;){
 *       schedule();//~j󂹂۸ޯ̧`݂̂۰قł
 *       LogBuf_Printf(pLogBuf,"%d",now);
 *   } }
 *   2
 *   void test(){
 *     //``
 *     LogBuf_Printf(pLogBuf,"some message");
 *     update();//۸ޯ̧`݂̂XV
 *     //``
 *   } }
 * - ̕ύXɔAOobt@`悪A^ƁAPC̉ʃLv`Ɋ܂܂ȂȂƂɁAӂĂB
 *   ^schedule()̒vidrec()ŁCLv`schedule()̒yield()ōs鏈łB
 *   vidrec()yield()Ă΂鎞_ł́AzVRAM͕ĂAOobt@`͎cĂȂłB
 *   Oobt@`́AɃeXĝ߂̕\ł̂ŁA^Lv`Ɋ܂܂ĂȂĂ肪Ǝv܂A
 *   Kvłꍇ́A֐̍ṒAzVRAM𕜌鏈폜΁AύXOƓlɊ܂܂悤ɂł܂B
 */
void
update()
{
#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɉzVRAMޔB */
    #ifdef  V_SCREEN
	static unsigned char tmpbuf[sizeof vbuff];	//Oobt@Əcʂ𕹗pꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgȂBrotate_screen()_def_vbuffj󂷂邩łBtmpbuf[]̕gpʂ邱ƂɒӂB
	memcpy(tmpbuf, vbuff, sizeof vbuff);
    #else //V_SCREEN
	memcpy(_def_vbuff, vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgB
    #endif//V_SCREEN
	/* Oobt@`B */
	LogBuf_Draw(pLogBuf, 0, 0);
#endif/*USE_LOG_BUFFER*/

#ifdef V_SCREEN
	rotate_screen();
#endif /*V_SCREEN*/

	/* ʓ] */
	pceLCDTrans();

#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɑޔzVRAM𕜌B */
    #ifdef  V_SCREEN
	memcpy(vbuff, tmpbuf, sizeof vbuff);		//Oobt@Əcʂ𕹗pꍇ
    #else //V_SCREEN
	memcpy(vbuff, _def_vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ
    #endif//V_SCREEN
#endif/*USE_LOG_BUFFER*/
}

/****************************************************************************
 *	vidrec
 ****************************************************************************/

#ifdef USE_VIDREC
static void
vidrec()
{
#ifdef LDIRECT_INTERVAL
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,4/*[bpp]*/,FPS };
#else /*LDIRECT_INTERVAL*/
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,2/*[bpp]*/,FPS };
#endif /*LDIRECT_INTERVAL*/
	static int active;
	//
	unsigned char buf[128/**/]; /* (sizeof vbuff)/ÑTCYƂ邱 */
	const unsigned char* src;
	unsigned char* dst;

	if(cdcacm_recv(buf, 1) > 0) {
		switch(buf[0]) {
		case 0:
			active = 0; /* ʏo͒~ */
			break;
		case 1:
			active = 1; /* ʏo͊Jn */
			src = hdr;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				src += cdcacm_send(src, &hdr[sizeof hdr] - src);
			} while(src < &hdr[sizeof hdr]);
			break;
		}
	}
	if(active) {
		src = vbuff;
		do {
			dst = buf;
			do {
#ifdef LDIRECT_INTERVAL
				*dst++ = src[0]|(src[1]<<4); 
				src += 2;
#else /*LDIRECT_INTERVAL*/
				*dst++ = src[0]|(src[1]<<2)|(src[2]<<4)|(src[3]<<6);
				src += 4;
#endif /*LDIRECT_INTERVAL*/
			} while(dst < &buf[sizeof buf]);
			dst = buf;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				dst += cdcacm_send(dst, &buf[sizeof buf] - dst);
			} while(dst < &buf[sizeof buf]);
		} while(src < &vbuff[sizeof vbuff]);
	}
}
#endif /*USE_VIDREC*/

/****************************************************************************
 *	schedule
 ****************************************************************************/

/* * Fri Dec 15 00:49:15 JST 2006 Naoyuki Sawa
 * - schedule()֐ɁATEh|[YΉR[hǉ܂B
 *   ł͏肭삵Ă悤łAX[v̕Aɖ肪NȂmFłB
 * - A|[YԂ̂܂܁AȂ킿ATEh|[YԂ̂܂܂ŃAvP[VIĂ܂ꍇɂA
 *   CLiPCupceAppExit()pceWaveStop(1)ĂяoĂATEhԂZbĝŁAvłB
 */

void
schedule()
{
#ifdef  USE_EVENT_TIMER
	/* Cxg^C}B */
	EvtTmr_Exec(pEvtTmr);
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_COUNTER_MANAGER
	/* ėpJE^ǗB */
	CntMgr_Exec(pCntMgr);
#endif/*USE_COUNTER_MANAGER*/

#ifdef USE_PAUSE
	{
		/* PAUSEbZ[Ẅ̃C[Wޔpobt@́A324oCgKvłB
		 * X^bNɎ̂͊댯łAstaticɎ̖̂ʂłB
		 * ŁAPAUSEɂ̂݃q[vmۂ邱Ƃɂ܂B
		 */
		//unsigned char save[PAUSE_H][PAUSE_W];
		unsigned char (*save)[PAUSE_W] = NULL/*x}*/;
		int pause = 0;
		/*{{2006/12/15:TEh|[YΉ*/
		int sound_pause = 0/*x}*/;
		/*}}2006/12/15:TEh|[YΉ*/
		int x, y;
		for(;;) {
#endif /*USE_PAUSE*/

			/* ʍXVB */
			update();

#ifdef USE_VIDREC
			/* ʏóB */
			vidrec();
#endif /*USE_VIDREC*/

#ifdef  USE_SOUND_MANAGER
			/* Sound ManagerB */
			SndMgr_Exec(pSndMgrBgm); /* BGM Sound Manager */
			SndMgr_Exec(pSndMgrSe1); /* SE1 Sound Manager */
			SndMgr_Exec(pSndMgrSe2); /* SE2 Sound Manager */
#endif/*USE_SOUND_MANAGER*/

#ifdef USE_IDLE
			/* ACh+VXeB */
			idle_yield();
#else /*USE_IDLE*/
			/* VXeB */
			yield();
#endif /*USE_IDLE*/

			/* pbhԍXVB */
			joy = pad_get();
#ifdef V_SCREEN
			joy = (joy & ~(PAD_LF | PAD_RI | PAD_UP | PAD_DN | /* cʗp͕ϊ */
				       TRG_LF | TRG_RI | TRG_UP | TRG_DN))
				| (joy & PAD_LF ? PAD_UP : 0)
				| (joy & PAD_RI ? PAD_DN : 0)
				| (joy & PAD_UP ? PAD_RI : 0)
				| (joy & PAD_DN ? PAD_LF : 0)
				| (joy & TRG_LF ? TRG_UP : 0)
				| (joy & TRG_RI ? TRG_DN : 0)
				| (joy & TRG_UP ? TRG_RI : 0)
				| (joy & TRG_DN ? TRG_LF : 0);
#endif /*V_SCREEN*/

			/* SELECT{^ꂽIB */ /* AvP[VɂĕsvȂ΁A2s폜ĂB */
			if(joy & TRG_SELECT) exit(EXIT_SUCCESS); /* AvP[VɂĕsvȂ΁A2s폜ĂB */

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause;	/* PAUSEԐ؂ւ */
				if(pause) {	/* PAUSE IN */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					sound_pause = fINT_EDMA.EHDM1;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 0;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[WޔB */
					save = (unsigned char (*)[PAUSE_W])malloc(PAUSE_W * PAUSE_H); /* C[Wޔpobt@m */
					if(save == NULL) DIE();
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							save[y][x] = vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)];
						}
					}
				} else {	/* PAUSE OUT */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 1;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[W𕜋AB */
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
						}
					}
					free(save); /* C[Wޔpobt@J */
				}
			}
			if(!pause) break;
			/* PAUSEbZ[W_ŕ\B */
			if(pceTimerGetCount() % 1000 < 750) {
				render_string_framed(&render, PAUSE_X, PAUSE_Y, PAUSE_STR, PAUSE_FONT, PAUSE_COLOR);
			} else {
				for(y = 0; y < PAUSE_H; y++) {
					for(x = 0; x < PAUSE_W; x++) {
						vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
					}
				}
			}
		}
	}
#endif /*USE_PAUSE*/

	now++;	/* O[o^C}XV */
}

/****************************************************************************
 *	delay
 ****************************************************************************/

void
delay(int frame)
{
	while(frame > 0) {
		schedule();
		frame--;
	}
}

/****************************************************************************
 *	app_main
 ****************************************************************************/

/*--- C(int) ---*/
static int is_prime1(int n) {
	int i;
	for(i = 2; i < n; i++) {
		if(n % i == 0) {
			return 0;
		}
	}
	return 1;
}
static int c_prog1() {
	int c = 0;
	int i;
	for(i = 2; i <= 1000; i++) {
		if(is_prime1(i)) {
			c = c + 1;
		}
	}
	return c;
}

/*--- C(float) ---*/
static float is_prime2(float n) {
	float i;
	for(i = 2; i < n; i++) {
		if(fmodf(n, i) == 0) {
			return 0;
		}
	}
	return 1;
}
static float c_prog2() {
	float c = 0;
	float i;
	for(i = 2; i <= 1000; i++) {
		if(is_prime2(i)) {
			c = c + 1;
		}
	}
	return c;
}

/*--- C(double) ---*/
static double is_prime3(double n) {
	double i;
	for(i = 2; i < n; i++) {
		if(fmod(n, i) == 0) {
			return 0;
		}
	}
	return 1;
}
static double c_prog3() {
	double c = 0;
	double i;
	for(i = 2; i <= 1000; i++) {
		if(is_prime3(i)) {
			c = c + 1;
		}
	}
	return c;
}

/*--- Lua ---*/
static lua_State* L;
static int panic(lua_State* L) {
	DIE();
}
static const char l_prog[] = "
-- nfȂtrueAfłȂfalseԂ܂B
function is_prime(n)
	local i
	for i = 2, (n - 1) do
		if (n % i) == 0 then
			return false
		end
	end
	return true
end
-- 2`1000͈̔͂ɂf̐AϐcɊi[܂B
c = 0
for i = 2, 1000 do
	if is_prime(i) then
		c = c + 1
	end
end
";

/*--------------------------------------------------------------------------*/

void
app_main()
{
	int y, t, c;

	/* delay()͕KvłB
	 * sȂƁAx߂PCŊJɁAsrfrun.batŎsɁAP/ECEnOAbv邱Ƃ܂B
	 * ̓Iɂ́APentium4 3GHz+Intel 915`bvZbgPCŊJɁAL̖肪A΍ŉł܂B
	 * run.bat́Asrf]sw𑗂AP/ECEsԂɂȂmF邽߂ɁAēxʐMs܂B
	 * delay()sȂƁAP/ECEԂ̌vɒʐMAsȏԂɂȂ̂Ǝv܂B(܂ڍׂ͒łĂ܂)
	 * ApexCXg[P/ECẼj[sꍇ́AUSBڑłĂA΍łȂ삵܂B
	 * ܂ŁAJsrfrun.batŎŝ݂́A邽߂̑΍łB */
	delay(SEC(0.5));

	surface_clear(&surface, 0);	//  01234567890123456789012345
	y = 0;
	render_printf(&render, 0, y, 0, 3, "       []  [ms]"); y += 10;
	render_printf(&render, 0, y, 0, 3, "-------------------------"); y += 10;
	render_printf(&render, 0, y, 0, 3, "C(int)                   "); y += 10;
	render_printf(&render, 0, y, 0, 3, "C(flt)                   "); y += 10;
	render_printf(&render, 0, y, 0, 3, "C(dbl)                   "); y += 10;
	render_printf(&render, 0, y, 0, 3, "Lua                      "); y += 10;
	render_printf(&render, 0, y, 0, 3, "-------------------------"); y += 10;
	schedule();
	y = 20;

	/*--- C(int) ---*/
	/* sԂv܂B */
	t = pceTimerGetCount();
	c = c_prog1();
	t = pceTimerGetCount() - t;
	/* sԂƌʂ\܂B */
	render_printf(&render, 35, y, 0, 3, "%8d  %8d", c, t); y += 10;
	schedule();

	/*--- C(float) ---*/
	/* sԂv܂B */
	t = pceTimerGetCount();
	c = c_prog2();
	t = pceTimerGetCount() - t;
	/* sԂƌʂ\܂B */
	render_printf(&render, 35, y, 0, 3, "%8d  %8d", c, t); y += 10;
	schedule();

	/*--- C(double) ---*/
	/* sԂv܂B */
	t = pceTimerGetCount();
	c = c_prog3();
	t = pceTimerGetCount() - t;
	/* sԂƌʂ\܂B */
	render_printf(&render, 35, y, 0, 3, "%8d  %8d", c, t); y += 10;
	schedule();

	/*--- Lua ---*/
	/* Lua܂B */
	L = luaL_newstate();
	lua_atpanic(L, panic);
	luaL_openlibs(L);
	/* LuaXNvg[h܂B */
	luaL_loadstring(L, l_prog);
	/* sԂv܂B */
	t = pceTimerGetCount();
	lua_call(L, 0, 0);
	t = pceTimerGetCount() - t;
	/* ʂ擾܂B */
	lua_getglobal(L, "c");
	c = lua_tointeger(L, -1);
	/* LuaI܂B */
	lua_close(L);
	/* sԂƌʂ\܂B */
	render_printf(&render, 35, y, 0, 3, "%8d  %8d", c, t); y += 10;
	schedule();

	y += 10;
	render_printf(&render, 0, y, 0, 3, "ƏI܂");
	for(;;) {
		schedule();
		if(joy & TRG_MASK) {
			break;
		}
	}
}
