/*
 *	mml.c
 *
 *	dpmucc - ~[WbNEf[^ERo[^[
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Thu Jan 22 00:43:59 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jan 24 05:36:54 JST 2015 Naoyuki Sawa
 *	- mmlEnd()̃[vԈĂ̂C܂B
 *	  mucc.exẽ\[X(\usr\PIECE\tools\mucc\mmlcv.c)͐āAōĎۂ̃GoOłB
 */
#include "app.h"
/****************************************************************************
 *	[Jϐ
 ****************************************************************************/
#define MAXPART		6		//őp[g			hCoŏ̂ŕύXsB(\usr\PIECE\sysdev\music\musdef.hMAXCHɑ)
#define MAXREPLEV	(8-1)		//[]̍őlXg		hCoŏ̂ŕύXsB(\usr\PIECE\sysdev\music\musdef.h((MAXNESTD/3)-1)ɑ)	-1闝ŔAp[ǧĂяoŏ1xĂ邩B
#define MAXMACLEV	1024		//MML}N̍őlXg	Ro[^[(vO)̂ŒB
#define MAXLABEL	1024		//p[g̃x̍ő`	B
#define MAXMMLMAC	1024		//MML}N̍ő`		B
#define MAXDRUMMAC	(0xE0-0x80)	//h}N̍ő`	hCoŏ̂ŕύXsB(\usr\PIECE\sysdev\music\seq.cProcSeq()SeqDrums()Ăяȏɑ)
/*--------------------------------------------------------------------------*/
static int		repLev;				//s[g̃lXgx
static int		TBL_RepStk[MAXREPLEV];		//s[gX^bN		//']l'鎞ɁA'['̏ɏo͂R}hɌJԂ񐔂i[ʒuL܂B
/*--------------------------------------------------------------------------*/
static int		macLev;				//MML}ÑlXgx
static char*		TBL_MacStk[MAXMACLEV];		//MML}NX^bN		//MML}NI[ɒBɕAsobt@̑ʒu(linePtr)L܂B
/*--------------------------------------------------------------------------*/
//MML}N
typedef struct _ST_MmlMac {
	char*		name;		//}N
	char*		mmlStr;		//MML
} ST_MmlMac;
static int		nMmlMac;			//MML}N̓o^
static ST_MmlMac	TBL_MmlMac[MAXMMLMAC];		//MML}Ne[u
//MML}NB
static char* getMmlMac(const char* name) {
	int iMmlMac;
	for(iMmlMac = 0; iMmlMac < nMmlMac; iMmlMac++) {
		if(!strcmp(TBL_MmlMac[iMmlMac].name, name)) {
			return TBL_MmlMac[iMmlMac].mmlStr;	//AMMLԂB
		}
	}
	return NULL;	//Ȃ΁ANULLԂB
}
/*--------------------------------------------------------------------------*/
//h}N
typedef struct _ST_DrumMac {
	char*		name;		//}N
	int		addr;		//AhX
} ST_DrumMac;
static int		nDrumMac;			//h}N̓o^
static ST_DrumMac	TBL_DrumMac[MAXDRUMMAC];	//h}Ne[u
//h}NB
static int getDrumMac(const char* name) {
	int iDrumMac;
	for(iDrumMac = 0; iDrumMac < nDrumMac; iDrumMac++) {
		if(!strcmp(TBL_DrumMac[iDrumMac].name, name)) {
			return iDrumMac;			//Ah}Nԍ(0`)ԂB
		}
	}
	return -1;	//Ȃ΁A-1ԂB
}
/*--------------------------------------------------------------------------*/
//p[g(A`F)
typedef struct _ST_Part {
	int		nLabel;			//̃p[gɑ΂ăx𐶐Bxłw肳ꂽp[gȂdoPart()setLabel()ɂďȂƂȏ̃xB](nLabel=0)ȂΕsgpp[głB
	int		labelAddr[MAXLABEL];	//xɑΉAhXB
	int		loopLabel;		//-1=[v,0=[v߂ʒuxB
	//
	int		trackAttr;		//gbN		bit0=hp[g,bit1=~p[g(Undoc'd)
	int		lastNote;		//Ōɏo͂K
	int		lastLen;		//Ōɏo͂(JEg)	0=
	//
	int		oct1, oct2;		//IN^[u
	int		len1, len2;		//()
	int		vol1, vol2;		//{[
	int		det1, det2;		//f`[
	int		trs1, trs2;		//gX|[Y
	//
	int		legSw;			//K[g(0=Off,1=On)
	int		porSw;			//|^g		'{ab}''{'o1ɂB'}'o2ɂāAgenNote()Ă0ɖ߂B
	int		porNote1;		//|^gJn
	int		porNote2;		//|^gI
} ST_Part;
static ST_Part		TBL_Part[MAXPART];	//ep[g̏Ԓǐ՗p[NGA
/*--------------------------------------------------------------------------*/
static char*		linePtr;		//sobt@̑ʒu
static int		partMask;		//ݎw肳Ăp[g̃rbg}XNB(bit0=A,bit1=B,c,bit5=F)	//h}N͒́Aݎw肳Ăp[g̃rbg}XN0ɂB(doMacro()Q)
static int		tempo1, tempo2;		//e|
/****************************************************************************
 *	endSection
 ****************************************************************************/
//ŐԂ̍Ō'I'uB
static void endSection() {
	if(getAddr() > 20) {		//ŐԂL΁c(ŐԂƂ́A^Cg,,xԂ̎łB)	//'20'̈Ӗ́AmmlSetup()QƂB
		addByte(SEQ_END);	//ŐԂ̍ŌɁA^Cg̏I[k,,'I'R}huB
	}
}
/****************************************************************************
 *	doTitle
 ****************************************************************************/
//^CgsB
static void doTitle() {
	int addr;
	       if(!strncmp(linePtr, "Title2", 6)) {				//
		linePtr += 6;	//  "Title2"΂B				//@̔菇K{B
		addr = 18;	//^Cg|C^̃AhX(mmlSetup()Q)	//@tɂTitle2TitleɈvĂ܂B
	} else if(!strncmp(linePtr, "Title" , 5)) {				//
		linePtr += 5;	//  "Title" ΂B
		addr = 16;	//^Cg|C^̃AhX(mmlSetup()Q)
	} else {
		die("%s(%d): ^Cgw肪słB", srcName, srcLine);
	}
	if(getWord(addr)) {	//Ɏw肳Ăc
		die("%s(%d): ^Cgw肪dĂ܂B", srcName, srcLine);
	}
	endSection();		//ŐԂ̍Ō'I'uB
	putWord(addr, getAddr());			//^Cg|C^i[B
	linePtr = strtrim(linePtr, 0, NULL);		//^Cg{̑Ő󔒂폜B
	while(*linePtr) { addByte(*linePtr++); }	//^Cgo͂BI[nul͏o͂ȂėǂB̌̊eŁuŐԂ̍Ō'I'uvƂďo͂邩B
}
/****************************************************************************
 *	getMacroName
 ****************************************************************************/
//}N擾B
static char* getMacroName() {
	char name[1024];	//[ȃTCYƂ鎖Bȉ̏Ńobt@̓`FbNĂ܂B
	//At@xbgԂA}NƌȂĎ擾B	//l̓}NƂĎgpłȂBhp[g̒'!bg4'̂悤Ƀ}Ňɉw肷ꍇL邩B
	int i = 0;
	while(isalpha(*linePtr)) { name[i++] = *linePtr++; }
	if(!i) { die("%s(%d): }NsłB", srcName, srcLine); }	//0̃}N͕s
	name[i] = '\0';
	//𕡐ĕԂB	//ĂяoA߂l̃|C^̂܂܃e[uɊi[̂ŁAK{łB
	return strdup(name);
}
/****************************************************************************
 *	convLen
 ****************************************************************************/
//A496̃JEg`ɕϊB
static int convLen(int len) {
	if((len < 1) || (len > 96)) {
		die("%s(%d): ͈͊OłB(%d)", srcName, srcLine, len);
	}
	return 96 / len;	//len1`96ł邱ƂmFς݂Ȃ̂ŁA߂l96`1͈̔͂ɂȂB
}
/****************************************************************************
 *	getLen
 ****************************************************************************/
static int getLen(int len) {
	int f = 0;
	if((linePtr[0] == '%') && isdigit(linePtr[1])) {	//'%l'ŁłȂJEg̒ڎwɂȂBmucc.exeUndoc'dȓ삾ƎvAdemucc.exeΉĂ̂őΉKvB
		linePtr++;	//'%'̎֐i߂B
		f = 1;
	}
	//lLȂ΁A擾Blen͎gpȂB
	if(isdigit(*linePtr)) {
		len = 0;
		do {
			len = (len * 10) + (*linePtr - '0');
		} while(isdigit(*++linePtr));
		if(!f) { len = convLen(len); }	//˃JEgϊB
	//lȂ΁AlengpB
	} else {
		/** no job **/
	}
	//t_̏B
	if(*linePtr == '.') {
		int x = len;
		do {
			len += (x >>= 1);
		} while(*++linePtr == '.');
	}
	return len;
}
/****************************************************************************
 *	genNote
 ****************************************************************************/
static void genNote(ST_Part* pPart, int note) {		//note0:,,h}NԍAnote=-1:x
	int len;
	//K,,,,'}'̌̉w肩AJEgvZĎ擾B
	//K,,,,'}'̌ɉw肪΁AgetLen()fāAftHgvZJEgԂB
	len = getLen(pPart->len1 + pPart->len2);
	//̌'&'w肳Ăc
	if(*linePtr == '&') {
		linePtr++;			//'&'̎֐i߂B
		if(!pPart->legSw) {		//ɃK[gOnłȂ΁c
			pPart->legSw = 1;	//K[gOnɂB
			addByte(SEQ_LEG);	//K[gOnR}h𐶐B
		}
	//̌'&'w肳ĂȂ΁c
	} else {
		if( pPart->legSw) {		//ɃK[gOffłȂ΁c
			pPart->legSw = 0;	//K[gOffɂB
			addByte(SEQ_LOF);	//K[gOffR}h𐶐B	K[gԂ̍Ō̔̒OOffR}h𐶐邱ƂɂȂ邪AŗǂBK[gԂ̍Ō̔̒OOffR}h邱ƂOƂāAhCo삷dlłB
		}
	}
	//|^gԂ̏Iʒu'}'Ȃ΁c
	if(pPart->porSw == 2) {
		int x = pPart->porNote2 - pPart->porNote1;			//
		int y = (int)(log((double)abs(x) / (double)len) / log(2.0));	//̎́u\usr\PIECE\tools\mucc\mmlcv.cvpB̈Ӗ͂܂łĂȂB
		y <<=  4;							//
		y += 128;							//
		addByte(SEQ_PPA);	//|^gp[^		//
		addByte(x);							//|^gR}h̃p[^̌`́u\usr\PIECE\tools\mucc\mmlcv.cvpBp[^̈Ӗ͂܂łĂȂB
		addByte(y);							//
		addByte(SEQ_PON);	//|^gOn
		//̉̏ŁAR}h𐶐A|^gOff,y,|^gԂNAB
	}
	//|^gԒ('{'A'}'̒O܂)Ȃ΁c
	if(pPart->porSw == 1) {
		pPart->porNote2 = pPart->porNote1;		//Õ|^gJnAV|^gIɊi[B
		                  pPart->porNote1 = note;	//@@@@@񔭐鉹AV|^gJnɊi[B
	//|^gԒłȂ,,|^gԂ̏Iʒu'}'Ȃ΁c
	} else {
		if(pPart->lastLen != len) {			//ωc
			addLen((pPart->lastLen = len));		//Vi[AR}h𐶐B
		}
		if((unsigned)note < (unsigned)(0xE0 - 0x80)) {	//,,h}NԍȂ΁c
			addByte(0x80 + note);			//R}h𐶐B
			pPart->lastNote = note;			//Ōɔm[gԍLĂB('x',y,݂̂ŔMML̂߂)
		} else {					//xȂ΁c
			addByte(SEQ_RRR);			//xR}h𐶐B
		}
	}
	//|^gԂ̏Iʒu'}'Ȃ΁c
	if(pPart->porSw == 2) {
		addByte(SEQ_POF);	//|^gOff
		pPart->porSw = 0;	//|^gԂNA
	}
}
/****************************************************************************
 *	getVal
 ****************************************************************************/
//l擾Bl0ԂB
static int getVal() {
	int ans, sgn;
	       if(linePtr[0] == '+') {
		if(!isdigit(linePtr[1])) { return 0; }	//'+'̌ɐl'+'0ԂBMMLR}hG[o邾낤B
		sgn =  1;
		linePtr++;	//'+'̎֐i߂B
	} else if(linePtr[0] == '-') {
		if(!isdigit(linePtr[1])) { return 0; }	//'-'̌ɐl'-'0ԂBMMLR}hG[o邾낤B
		sgn = -1;
		linePtr++;	//'-'̎֐i߂B
	} else {
		if(!isdigit(linePtr[0])) { return 0; }	//l0ԂB
		sgn =  1;
	}
	ans = 0;
	do {
		ans = (ans * 10) + (*linePtr++ - '0');
	} while(isdigit(*linePtr));
	return ans * sgn;
}
/****************************************************************************
 *	genRepeat
 ****************************************************************************/
static void genRepeat() {
	addByte(SEQ_RPT);
	if((unsigned)repLev >= (unsigned)MAXREPLEV) { DIE(); }		//G[:s[g̃lXgx߂B܂ȂƎv̂ŁAJȃG[bZ[W͕sv낤B
	TBL_RepStk[repLev++] = getAddr();	//']l'鎞ɁA'['̏ɏo͂R}hɌJԂ񐔂i[ʒuL܂B
	addByte(0);				//v[Xz_ƂāAJԂ0i[ĂB
}
/****************************************************************************
 *	genNext
 ****************************************************************************/
static void genNext(int cnt) {
	//ۂɂ͐ĂG[ƌȂĂ܂\LB(mucc.exełl)
	//<>
	//AB [cde
	//A  ]1
	//B  ]1
	//̗̂悤ȏeɂ́AԂǐՂ鏈̂ŁAΉȂƂɂB
	//mucc.exe肪L̂ŁAvOΉȂč\Ȃ낤B
	if(!repLev) { die("%s(%d): '['`']'ΉĂ܂B", srcName, srcLine); }
	putByte(TBL_RepStk[--repLev], cnt);
	addByte(SEQ_NXT);
}
/****************************************************************************
 *	extMacro
 ****************************************************************************/
static void extMacro(ST_Part* pPart) {
	char *name, *mmlStr;
	int iDrumMac;
	//}N擾B
	name = getMacroName();
	//MML}NH
	if((mmlStr = getMmlMac(name))) {
		if((unsigned)macLev >= (unsigned)MAXMACLEV) { DIE(); }		//G[:MML}ÑlXgx߂B܂ȂƎv̂ŁAJȃG[bZ[W͕sv낤B
		TBL_MacStk[macLev++] = linePtr;		//MML}NI[ɒBɕAsobt@̑ʒu(linePtr)L܂B
		linePtr = mmlStr;			//ʒuAMML}N̕ɐ؂ւ܂B
	//h}NH
	} else if((iDrumMac = getDrumMac(name)) >= 0) {
		genNote(pPart, iDrumMac);		//h}N̔R}h𐶐Bhp[g̒ł͒ʏ̔R}h(0x80`0xDF)h}ŇĂяoƉ߂B
	} else {
		die("%s(%d): }N'%s'`Ă܂B", srcName, srcLine, name);
	}
}
/****************************************************************************
 *	setLabel
 ****************************************************************************/
//ݎw肳ĂX̃p[gɑ΂āÃ݂AhXɑΉx𐶐B
static void setLabel() {
	static int lastLabelAddr;	//ŌɃxo͂AhXB(AhX0`19)mmlSetup()o͍ς݂Ȃ̂ŁAgetAddr()0ɂ͐蓾AlabelAddȑl0ɋRvSz͖B
	static int lastPartMask;	//Ō̃x̋Ԃ̑Ώۃp[gB(ꂪĂAhXłx𐶐Ȃ΂ȂȂB'A l4'̂悤ȃR}h̖s̐擪xƁA̍s̐擪xʒuwƂ邽߁B)
	int iPart;
	if((lastLabelAddr != getAddr()) ||	//Õxo͂łȂ΁c(Ⴆ'A Lcde'̂悤ɐ擪'L'LꍇɁA擪'L'̊ԂɋԂĂ܂ʂȂ߂̔łB)
	   (lastPartMask  != partMask )) {	//́AŌ̃xԂ̑Ώۃp[gƈقȂp[gΏ̂Ƃ郉xȂ΁c
		endSection();			//ŐԂ̍Ō'I'uB
		lastLabelAddr = getAddr();	//̏'I'uƁAgetAddr()̖߂lω̂ŁAgetAddr()Ď擾KvLB
		lastPartMask  = partMask;
		for(iPart = 0; iPart < MAXPART; iPart++) {	//doPart()Ŏw肳ꂽX̃p[gɑ΂āAx𐶐B
			if(partMask & (1 << iPart)) {
				ST_Part* pPart = &TBL_Part[iPart];
				if((unsigned)pPart->nLabel >= (unsigned)MAXLABEL) { DIE(); }	//G[:x߂B܂ȂƎv̂ŁAJȃG[bZ[W͕sv낤B
				pPart->labelAddr[pPart->nLabel++] = lastLabelAddr;		//xɑΉAhXi[Ãp[gɑ΂ăx𐶐𑝂₷B
			}
		}
	}
}
/****************************************************************************
 *	genCtrl
 ****************************************************************************/
//w肳ꂽ̌̃R}h𐶐AėpB
static void genCtrl(int c, int cmd, int nArg/*1*/) {
	addByte(cmd);
	do {
		addByte(getVal());	//擾o͂B
		nArg--;
	} while(*linePtr++ == ',');	//̌','LΌpB
	linePtr--;
	if(nArg) { die("%s(%d): MMLR}h'%c'̈słB", srcName, srcLine, c); }	//w肳ꂽ̌ƁA擾̌vƂmFB
}
/****************************************************************************
 *	doBody
 ****************************************************************************/
//MML{̂͂B
static void doBody() {
	ST_Part *pPart, dummyPart;
	int c;
	//p[g`MML͒Ȃ΁Aݎw肳Ăp[ĝAŏ̃p[gԍ̏Ԓǐ՗p[NGAgpB	//!!!MMLp[gƃhp[g݂Ďw肳ꂽꍇ͖̓`łB!!!
	if(partMask) {
		pPart = &TBL_Part[ffs(partMask) - 1];	//(ffs()̖߂l=1`MAXPART)(ffs()̖߂l-1=0`(MAXPART-1))
	//h}N͒Ȃ΁A_~[̏Ԓǐ՗p[NGAgpB
	} else {
		memset(&dummyPart, 0, sizeof dummyPart);
	  //~	dummyPart.trackAttr = (1<<0);	//hp[g	//ZbgĂ͂ȂBʂł΂łȂQłB̓Iɂ̓h}N̉͒Ɉȉwhile()[v̒'K'̓̕ᏈɈ'?o4c'̂悤Ȏw̉Kj'?o0c'ɂȂĂ܂Bh}N͉̉͒KjĂ͂ȂB
		pPart = &dummyPart;
	}
L_REDO:	//MML}NĂяoȎʒu֖߂MML{̂̉͂pꍇ́AJԂB֐̐擪JԂĂx͖ȀsĂʂ͓Ȃ̂ŖʂłB
	while((c = *linePtr++)) {
		if(isspace(c)) { continue; }	//󔒕͏ɔ΂B
		switch(c) {
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
			{//K
				//                                        a  b  c  d  e  f  g
				static const unsigned char TBL_Note[] = { 9,11, 0, 2, 4, 5, 7 };
				int note = TBL_Note[c - 'a'] + (pPart->oct1 + pPart->oct2) * 12;
				for(;;) {
					if(*linePtr == '+') { note++; linePtr++; continue; }
					if(*linePtr == '-') { note--; linePtr++; continue; }
					break;
				}
				if(pPart->trackAttr & (1<<0)) { note = pPart->lastNote; }	//hp[g̒Œʏ̔R}hgpꍇA擾K͔jāAŌɔh}Nԍ𔭐Bmucc.exeUndoc'dȓ삾ƎvA\usr\PIECE\data\music\c350.mml̓ɈˑĂ̂őΉ𓾂ȂB
				genNote(pPart, note);
				break;
			}
		case 'r':
			{//x
				genNote(pPart, -1);
				break;
			}
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case '.':
			{//݂̂̎wőOƓm[g𔭐B						//mucc.exeUndoc'dȓ	''
				linePtr--;	//('0'`'9',,'.')̈ʒu֖߂B
				genNote(pPart, pPart->lastNote);
				break;
			}
		case 'x':
			{//Ỏ										//C:\usr\PIECE\docs\muslib\mml.htḿu̕vɐLB
				genNote(pPart, pPart->lastNote);
				break;
			}
		case 'l':
			{//
				if((*linePtr == '+') || (*linePtr == '-')) {
					pPart->len2 = convLen(getVal());	//΃ftHgw	//mucc.exeUndoc'dȓ	'l}l'
				} else {
					pPart->len1 = convLen(getVal());	//ftHgw
				}
				break;
			}
		case 'o':
			{//IN^[u
				if((*linePtr == '+') || (*linePtr == '-')) {
					pPart->oct2 = getVal();			//΃IN^[uݒ
				} else {
					pPart->oct1 = getVal();			//IN^[uݒ
				}
				break;
			}
		case 't':
		case 'T':
			{//e|
				if((*linePtr == '+') || (*linePtr == '-')) {
					tempo2 = getVal();
				} else {
					tempo1 = getVal();
				}
				addByte(SEQ_TMP);
				addByte(tempo1 + tempo2);
				break;
			}
		case 'v':
			{//ʒ
				if((*linePtr == '+') || (*linePtr == '-')) {
					addByte(SEQ_EXR);
					addByte(getVal());
				} else {
					addByte(SEQ_EXP);
					addByte(getVal());
				}
				break;
			}
		case 'V':
			{//ʐݒ
				if((*linePtr == '+') || (*linePtr == '-')) {
					pPart->vol2 = getVal();							//mucc.exeUndoc'dȓ	'V}l'
				} else {
					pPart->vol1 = getVal();
				}
				addByte(SEQ_VOL);
				addByte(pPart->vol1 + pPart->vol2);
				break;
			}
		case 'D':
			{//f`[
				if(*linePtr =='D') {
					linePtr++;	//ڂ'D'̎֐i߂B
					pPart->det2 = getVal();							//mucc.exeUndoc'dȓ	'DD[}]l'
				} else {
					pPart->det1 = getVal();
				}
				addByte(SEQ_DTN);
				addByte(pPart->det1 + pPart->det2);
				break;
			}
		case '[':
			{//Ǐ[vݒ(Jn)
				pPart->lastLen = 0;	//s[gԂ̍ŏɊmɉR}ho͂邽߂ɁAŌɏo͂𖳌B
				genRepeat();		//s[gJnR}h𐶐B
				break;
			}
		case ']':
			{//Ǐ[vݒ(I[)
				genNext(getVal());	//s[gI[R}h𐶐B
				pPart->lastLen = 0;	//s[gԂ̒ɊmɉR}ho͂邽߂ɁAŌɏo͂𖳌B	s[gԂ':'Ŕꍇ̂߂ɕK{łB
				break;
			}
		case ':':
			{//Ǐ[vݒ(Eo)
				addByte(SEQ_BRK);	//s[gEoR}h𐶐B
				break;
			}
		case '<':
			{//IN^[u_E
				pPart->oct1--;
				break;
			}
		case '>':
			{//IN^[uAbv
				pPart->oct1++;
				break;
			}
		case '_':
			{//gX|[Yݒ
				if(*linePtr == '_') {
					linePtr++;	//ڂ'_'̎֐i߂B
					pPart->trs2 = getVal();							//C:\usr\PIECE\docs\muslib\mml.htḿugX|[YݒvɐLB
				} else {
					pPart->trs1 = getVal();
				}
				addByte(SEQ_TRS);
				addByte(pPart->trs1 + pPart->trs2);
				break;
			}
		case '!':
			{//}N
				extMacro(pPart);	//MML}Nh}Np[g`s̒ł͓̏'!}N'łBextMacro()̒łǂ̎ނfďĂ܂B
				break;
			}
		case 'L':
			{//S̃[vݒ
				int iPart;
				setLabel();		//ep[gɁA݈ʒũx쐬B
				for(iPart = 0; iPart < MAXPART; iPart++) {
					if(partMask & (1 << iPart)) {
						ST_Part* pPart = &TBL_Part[iPart];
						if(pPart->loopLabel != -1) {
							die("%s(%d): [vw肪dĂ܂B", srcName, srcLine);
						}
						pPart->loopLabel = pPart->nLabel - 1;	//(x𐶐-1)ŌɐxԍłB
					}
				}
				break;
			}
		case '=':
			{//gbN
				addByte(SEQ_TAT);
				addByte((pPart->trackAttr = getVal()));
				break;
			}
		case '@':
			{//Fݒ
				genCtrl(c, SEQ_INO, 1);
				break;
			}
		case 'E':
			{//Gx[v
				genCtrl(c, SEQ_ENV, 4);
				break;
			}
		case 'Y':
			{//ru[g
				genCtrl(c, SEQ_VIB, 4);
				break;
			}
		case 'Z':
			{//|^gp[^
				// - |^gp[^́AgenNote()vẐɔĈK؂łAMMLŖIɎw肷̂ł͂ȂƎvB
				//   MMLŖIɎw肵ĂǍgenNote()|^gp[^̕LɂȂ̂ŁAӖƎvB
				// - {͂Undoc'dȃR}h폜̂A\usr\PIECE\data\music\free_001.mml,free_002.mml,free_003.mmlgpĂ̂ō폜łȂB
				//   free_001.mml,free_002.mml,free_003.mmlAǂړIłUndoc'dȃR}hgpĂ̂A܂łĂȂB
				//   ƁÂgenNote()vZMMLŖIɎw肷Kv̂mȂBÂdl̖cmȂB
				genCtrl(c, SEQ_PPA, 2);								//mucc.exeUndoc'dȓ	'Zl,l'
				break;
			}
		case '?':
			{//h}Nł̔R}hBhp[g̒ł͒ʏ̔R}h(0x80`0xDF)h}ŇĂяoƉ߂Bh}N̒Œʏ̔R}hgƃh}NĂяo̖[vɂȂĂ܂̂ŁAȂȂ悤'?'gKvLBAhp[g̒ȊOł'?'gpĂ͖ȂӖłB
				addByte(SEQ_NOT);
				break;
			}
		case '{':
			{//|^g(Jn)
				pPart->porSw = 1;
				break;
			}
		case '}':
			{//|^g(I[)
				pPart->porSw = 2;
				genNote(pPart, pPart->porNote1);	//|^g֘ÃR}h,y,|^ge锭R}h́ASĂ̒ŐB
				break;
			}
		case 'q':
		case 'Q':
			{//̐؂
				//uo/dbd@llk@t@Xvyz̐؂ Q(file:///C:/usr/PIECE/docs/muslib/mml.htm#mml14)ɂ́A
				//qs0`100tl̎ԕA납特Jbg܂B
				//ƏĂ܂Al͈̔͂ԈĂ܂B
				//mucc.exẽ\[X(\usr\PIECE\tools\mucc\mmlcv.c)ana_body()'q'̏ƁA
				//qs0`24tl̎ԕA납特Jbg܂B
				//ƍl̂łBۂmucc.exegĎĂ݂āA0`24̋łv܂B
				//c[dpmucc.exe(clip/tool/dpmucc/mml.c)A0`24͈̔͂Ŏw肷悤ɂ܂B
				int gate = getVal();
				if(c == 'q') {
					gate = ((24 - gate) * 99) / 24;		//̐؂2
				} else {
					gate = (      gate  * 99) /  8;		//̐؂1
				}
				if(gate <  1) { gate =  1; }
				if(gate > 99) { gate = 99; }
				addByte(SEQ_GAT);
				addByte(gate);
				break;
			}
		case '(':
		case ')':
			{//ʑΕω
				int expr = 1;
				if(isdigit(*linePtr)) { expr = getVal(); }
				if(c == '(') { expr = -expr; }
				addByte(SEQ_EXR);
				addByte(expr);
				break;
			}
		default:
			die("%s(%d): MMLR}h'%c'słB", srcName, srcLine, c);
		}
	}
	//MML{̂̉͒MML}NĂяosĂAMML}NĂяoȎʒu֖߂MML{̂̉͂pB
	if(macLev) {
		linePtr = TBL_MacStk[--macLev];
		goto L_REDO;
	}
}
/****************************************************************************
 *	doMacro
 ****************************************************************************/
//}NsB
static void doMacro() {
	int drum = 0;
	char* name;
	//mmlParse()Ŕ΂'!'̒ɓڂ'!'L΁A'!!`'łh}NłB
	if(*linePtr == '!') {
		linePtr++;	//ڂ'!'΂B
		drum = 1;
	}
	//}N擾B
	name = getMacroName();
	//̃}NAMML}NƂĂh}NƂĂo^ĂȂƂmFB
	// - }N`̏MML}N(!name)ƃh}N(!!name)ŕʂA}NĂяȍ͓(!name)Ȃ̂ŁAŜʂă}Nj[NłȂ΂ȂȂB
	if((getMmlMac(name) != NULL) || (getDrumMac(name) >= 0)) {
		die("%s(%d): }N'%s'dĂ܂B", srcName, srcLine, name);
	}
	//MML}NȂ΁c
	if(!drum) {
		if((unsigned)nMmlMac >= (unsigned)MAXMMLMAC) { DIE(); }		//G[:MML}N߂B܂ȂƎv̂ŁAJȃG[bZ[W͕sv낤B
		//MML}No^B
		TBL_MmlMac[nMmlMac].name	= name;			//getMacroName()ς݂Ȃ̂łł͕svB
		TBL_MmlMac[nMmlMac].mmlStr	= strdup(linePtr);	//K{B
		nMmlMac++;
		//MML}NMML{̂͒`ɉ͂ȂBĂяoꂽœsx͂B
	//h}NȂ΁c
	} else {
		if((unsigned)nDrumMac >= (unsigned)MAXDRUMMAC) { DIE(); }	//G[:h}N߂B܂ȂƎv̂ŁAJȃG[bZ[W͕sv낤B
		endSection();		//ŐԂ̍Ō'I'uB	//Kv!!YȂ!!
		//h}No^B
		TBL_DrumMac[nDrumMac].name	= name;			//getMacroName()ς݂Ȃ̂łł͕svB
		TBL_DrumMac[nDrumMac].addr	= getAddr();
		nDrumMac++;
		//h}N͂B
		partMask = 0;		//h}N͒́Aݎw肳Ăp[g̃rbg}XN0ɂB
		doBody();		//MML{̂͂B
	}
}
/****************************************************************************
 *	doPart
 ****************************************************************************/
//p[g`s͂BsłĂяo܂B
static void doPart() {
	int iPart, fPart = 0;
	//s擪啶̃At@xbgAp[gwłB
	while(isupper(*linePtr)) {
		//A`Fp[g0`5ɑΉBG`Z͑Săp[g6ɑΉB
		//\usr\PIECE\data\music\c350.mmlJgĂ̂Gȍ~G[ɏoȂB
		iPart = *linePtr++ - 'A';
		if((unsigned)iPart > (unsigned)(MAXPART - 1)) { iPart = MAXPART - 1; }
		//ݎw肳Ăp[g̃rbg}XN쐬B
		fPart |= (1 << iPart);
	}
	//p[gȏw肳,,ȎgƕωAVԂJnB
	//<>
	//AB cde
	//CD fg	;鎞
	//<>
	//AB cde
	//A  fg	;鎞
	if(fPart && (fPart != partMask)) {
		partMask = fPart;	//VԂ́Ap[g̑gi[B	//setLabel()partMaskQƂ̂ŁAsetLabel()ĂяoOɍsKvLB
		setLabel();		//ep[gɁA݈ʒũx쐬B
	//p[gw肳ĂȂ,,ȎgƓȂ΁AŐԂpB
	//<1>
	//AB cde
	//   fg	;鎞
	//<2>
	//AB cde
	//AB fg	;鎞
	//<3>
	//AB cde
	//BA fg	;鎞
	} else {
		/** no job **/
	}
	//p[g`sMML{̂͂B
	doBody();		//MML{̂͂B
}
/****************************************************************************
 *	mmlSetup
 ****************************************************************************/
void mmlSetup() {
	int iPart;
	//+ 0, 1
	//t@C̐擪(ItZbg=0)'I'uĂBR͈ȉ̒ʂ:
	//Epmdf[^̃p[ge[uŁA@(ItZbg=0)̃p[g@R'I'@w悤ɂ邽߁B
	//Epmdf[^̃^Cg|C^ŁA(ItZbg=0)̃^CgRɋ󕶎w悤ɂ邽߁B
	addByte(SEQ_END);
	//+ 1, 1
	addByte(MAXPART);
	//+ 2,12
	for(iPart = 0; iPart < MAXPART; iPart++) {
		addWord(0);	//p[ge[ũv[Xz_BmmlEnd()Ŏۂ̃ItZbgi[B
		TBL_Part[iPart].loopLabel = -1;	//[vƂĂB
	}
	//+14, 2
	addWord(0);		//h}Ne[ũv[Xz_BmmlEnd()Ŏۂ̃ItZbgi[B
	//+16, 2
	addWord(0);		//Title ̃v[Xz_BdoTitle()Ŏۂ̃ItZbgi[B
	//+18, 2
	addWord(0);		//Title2̃v[Xz_BdoTitle()Ŏۂ̃ItZbgi[B
	//=20
}
/****************************************************************************
 *	mmlParse
 ****************************************************************************/
void mmlParse() {
	char buf[1024], *p;
	//sǂݍށB
	while((linePtr = fgets(buf, sizeof buf, fp))) {
		//sԍi߂B
		srcLine++;
		//';'ȍ~RgƂĐ؂̂ĂB
		if((p = strchr(linePtr, ';'))) { *p = '\0'; }
		//擪'#'Ȃ΁A^Cg`słB
		if(*linePtr == '#') {
			linePtr++;	//'#'΂B
			doTitle();
		//擪'#'ȊOȂ΁c
		} else {
			//擪'!'Ȃ΁AMML}N`s,,h}N`słB
			if(*linePtr == '!') {
				linePtr++;	//'!'΂B
				doMacro();	//}N͂B
			//擪ȊOȂ΁Ap[g`słB(p[gwL,,p[gw薳)
			} else {
				doPart();	//p[g`s͂BsłĂяoĈSłB
			}
		}
	}
}
/****************************************************************************
 *	mmlEnd
 ****************************************************************************/
void mmlEnd() {
	int iPart, iLabel, iDrumMac, addr;
	endSection();		//ŐԂ̍Ō'I'uB
	//ep[gɂāc
	for(iPart = 0; iPart < MAXPART; iPart++) {
		ST_Part* pPart = &TBL_Part[iPart];
		if(pPart->nLabel) {	//sgpp[głȂ΁c
//{{2015/01/24C:mmlEnd()̃[vԈĂ̂C܂Bmucc.exẽ\[X(\usr\PIECE\tools\mucc\mmlcv.c)͐āAōĎۂ̃GoOłB
//			putWord(2 + (iPart * 2), getAddr());	//p[ge[ũAhXi[B		//'2'̈Ӗ́AmmlSetup()QƂB
//			for(iLabel = 0; iLabel < pPart->nLabel; iLabel++) {
//				addByte(SEQ_CAL);
//				addWord(pPart->labelAddr[iLabel]);
//				addByte(1);	//JԂ1Œ		R[߂̃R}hdl͌JԂ񐔂wo邪Amucc.exe̓R[߂̌JԂ񐔂1ŒłȂB
//			}
//			if(pPart->loopLabel != -1) {	//[vLȂ΁c
//				addByte(SEQ_JMP);	//[vʒuփWvB
//				addWord(pPart->labelAddr[pPart->loopLabel]);
//			} else {			//[vȂ΁c
//				addByte(SEQ_END);	//IB
//			}
//2015/01/24C:mmlEnd()̃[vԈĂ̂C܂Bmucc.exẽ\[X(\usr\PIECE\tools\mucc\mmlcv.c)͐āAōĎۂ̃GoOłB
// * Sat Jan 24 05:33:00 JST 2015 Naoyuki Sawa
// - [v́A'[vԂ̃xʒu'֖߂̂ł͂ȂA'[vԂĂяoSEQ_CAL̈ʒu'֖߂Ȃ΂ȂB
//   '[vԂ̃xʒu'֖߂Ă܂ƁA̋ԂSEQ_ENDȑŜ̏IƌȂĂ܂A[vɂȂȂB
			int loopAddr = 0;		//[vƂĂB
			putWord(2 + (iPart * 2), getAddr());	//p[ge[ũAhXi[B		//'2'̈Ӗ́AmmlSetup()QƂB
			for(iLabel = 0; iLabel < pPart->nLabel; iLabel++) {
				if(iLabel == pPart->loopLabel) {	//[vxĂяoʒuȂ΁c
					loopAddr = getAddr();		//[vxĂяoʒũAhXLB
				}
				addByte(SEQ_CAL);
				addWord(pPart->labelAddr[iLabel]);
				addByte(1);	//JԂ1Œ		R[߂̃R}hdl͌JԂ񐔂wo邪Amucc.exe̓R[߂̌JԂ񐔂1ŒłȂB
			}
			if(loopAddr) {			//[vLȂ΁c
				addByte(SEQ_JMP);	//[vxĂяoʒuփWvB
				addWord(loopAddr);
			} else {			//[vȂ΁c
				addByte(SEQ_END);	//IB
			}
//}}2015/01/24C:mmlEnd()̃[vԈĂ̂C܂Bmucc.exẽ\[X(\usr\PIECE\tools\mucc\mmlcv.c)͐āAōĎۂ̃GoOłB
		}
	}
	//h}Nȏ`ĂAh}Ne[uo͂B
	if(nDrumMac) {
		putWord(14, getAddr());				//h}Ne[ũAhXi[B	//'14'̈Ӗ́AmmlSetup()QƂB
		for(iDrumMac = 0; iDrumMac < nDrumMac; iDrumMac++) {
			addWord(TBL_DrumMac[iDrumMac].addr);
		}
	}
	//R[ht@Cɏo͂B
	for(addr = 0; addr < getAddr(); addr++) {
		fputc(getByte(addr), fp);
	}
}
