/*	
 *	clipwsg.h
 *
 *	P/ECE Namco WSG Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Feb 15 04:29:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_WSG_H__
#define __CLIP_WSG_H__

/****************************************************************************
 *
 ****************************************************************************/

#define WSGBUFLEN 320 /* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

/* [ȉAMAME 0.67 NAMCO sound driver (src/sound/namco.c) ]
 *
 * =======================
 * Xevious type (C15 chip)
 * =======================
 *
 *	0x05:	?????www	w = Ch0 Wavetable Select (O8F̂ݎgp)
 *	0x0a:	?????www	w = Ch1 Wavetable Select (O8F̂ݎgp)
 *	0x0f:	?????www	w = Ch2 Wavetable Select (O8F̂ݎgp)
 *
 *	0x10:	????ffff	f = Ch0 Frequency[ 3: 0]
 *	0x11:	????ffff	f = Ch0 Frequency[ 7: 4]
 *	0x12:	????ffff	f = Ch0 Frequency[11: 8]
 *	0x13:	????ffff	f = Ch0 Frequency[15:12]
 *	0x14:	????ffff	f = Ch0 Frequency[19:16]
 *	0x15:	????vvvv	v = Ch0 Volume
 *
 *				    Ch1 Frequency[ 3: 0]0Œ
 *	0x16:	????ffff	f = Ch1 Frequency[ 7: 4]
 *	0x17:	????ffff	f = Ch1 Frequency[11: 8]
 *	0x18:	????ffff	f = Ch1 Frequency[15:12]
 *	0x19:	????ffff	f = Ch1 Frequency[19:16]
 *	0x1a:	????vvvv	v = Ch1 Volume
 *
 *				    Ch2 Frequency[ 3: 0]0Œ
 *	0x1b:	????ffff	f = Ch2 Frequency[ 7: 4]
 *	0x1c:	????ffff	f = Ch2 Frequency[11: 8]
 *	0x1d:	????ffff	f = Ch2 Frequency[15:12]
 *	0x1e:	????ffff	f = Ch2 Frequency[19:16]
 *	0x1f:	????vvvv	v = Ch2 Volume
 *
 *	g`e[uROMłB
 *	1Tv1oCgA4bit̂ݎgp(0`15)A8FAS256oCgłB
 *
 * =====================
 * Mappy type (C30 chip)
 * =====================
 *
 *	0x03:	????vvvv	v = Ch0 Volume
 *	0x04:	ffffffff	f = Ch0 Frequency[ 7: 0]
 *	0x05:	ffffffff	f = Ch0 Frequency[15: 8]
 *	0x06:	?wwwffff	f = Ch0 Frequency[19:16]
 *				w = Ch0 Wavetable Select (O8F̂ݎgp)
 *
 *	0x0b:	????vvvv	v = Ch1 Volume
 *	0x0c:	ffffffff	f = Ch1 Frequency[ 7: 0]
 *	0x0d:	ffffffff	f = Ch1 Frequency[15: 8]
 *	0x0e:	?wwwffff	f = Ch1 Frequency[19:16]
 *				w = Ch1 Wavetable Select (O8F̂ݎgp)
 *
 *	0x13:	????vvvv	v = Ch2 Volume
 *	0x14:	ffffffff	f = Ch2 Frequency[ 7: 0]
 *	0x15:	ffffffff	f = Ch2 Frequency[15: 8]
 *	0x16:	?wwwffff	f = Ch2 Frequency[19:16]
 *				w = Ch2 Wavetable Select (O8F̂ݎgp)
 *
 *	0x1b:	????vvvv	v = Ch3 Volume
 *	0x1c:	ffffffff	f = Ch3 Frequency[ 7: 0]
 *	0x1d:	ffffffff	f = Ch3 Frequency[15: 8]
 *	0x1e:	?wwwffff	f = Ch3 Frequency[19:16]
 *				w = Ch3 Wavetable Select (O8F̂ݎgp)
 *
 *	0x23:	????vvvv	v = Ch4 Volume
 *	0x24:	ffffffff	f = Ch4 Frequency[ 7: 0]
 *	0x25:	ffffffff	f = Ch4 Frequency[15: 8]
 *	0x26:	?wwwffff	f = Ch4 Frequency[19:16]
 *				w = Ch4 Wavetable Select (O8F̂ݎgp)
 *
 *	0x2b:	????vvvv	v = Ch5 Volume
 *	0x2c:	ffffffff	f = Ch5 Frequency[ 7: 0]
 *	0x2d:	ffffffff	f = Ch5 Frequency[15: 8]
 *	0x2e:	?wwwffff	f = Ch5 Frequency[19:16]
 *				w = Ch5 Wavetable Select (O8F̂ݎgp)
 *
 *	0x33:	????vvvv	v = Ch6 Volume
 *	0x34:	ffffffff	f = Ch6 Frequency[ 7: 0]
 *	0x35:	ffffffff	f = Ch6 Frequency[15: 8]
 *	0x36:	?wwwffff	f = Ch6 Frequency[19:16]
 *				w = Ch6 Wavetable Select (O8F̂ݎgp)
 *
 *	0x3b:	????vvvv	v = Ch7 Volume
 *	0x3c:	ffffffff	f = Ch7 Frequency[ 7: 0]
 *	0x3d:	ffffffff	f = Ch7 Frequency[15: 8]
 *	0x3e:	?wwwffff	f = Ch7 Frequency[19:16]
 *				w = Ch7 Wavetable Select (O8F̂ݎgp)
 *
 *	g`e[uROMłB
 *	1Tv1oCgA4bit̂ݎgp(0`15)A8FAS256oCgłB
 *
 * =========================
 * System1 type (C30 chip?)
 * =========================
 *
 *	0x000:	aaaabbbb	a = Waveform 0 Sample 0
 *				b = Waveform 0 Sample 1
 *	0x001:	ccccdddd	c = Waveform 0 Sample 2
 *				d = Waveform 0 Sample 3
 *	...
 *	0x00f:	yyyyzzzz	y = Waveform 0 Sample30
 *				z = Waveform 0 Sample31
 *
 *	0x010:	aaaabbbb	a = Waveform 1 Sample 0
 *				b = Waveform 1 Sample 1
 *	...
 *	0x0ff:	yyyyzzzz	y = Waveform15 Sample30
 *				z = Waveform15 Sample31
 *
 *	0x100:	????vvvv	v = Ch0 Volume Left
 *	0x101	wwwwffff	w = Ch0 Wavetable Select (S16Fgp)
 *				f = Ch0 Frequency[19:16]
 *	0x102:	ffffffff	f = Ch0 Frequency[15: 8]
 *	0x103:	ffffffff	f = Ch0 Frequency[ 7: 0]
 *	0x104:	n???vvvv	v = Ch0 Right Volume
 *				n = Ch1 Noise Switch (̃`lpł)
 *
 *	0x108:	????vvvv	v = Ch1 Volume Left
 *	0x109	wwwwffff	w = Ch1 Wavetable Select (S16Fgp)
 *				f = Ch1 Frequency[19:16]
 *	0x10a:	ffffffff	f = Ch1 Frequency[15: 8]
 *	0x10b:	ffffffff	f = Ch1 Frequency[ 7: 0]
 *	0x10c:	n???vvvv	v = Ch1 Right Volume
 *				n = Ch2 Noise Switch (̃`lpł)
 *
 *	0x110:	????vvvv	v = Ch2 Volume Left
 *	0x111	wwwwffff	w = Ch2 Wavetable Select (S16Fgp)
 *				f = Ch2 Frequency[19:16]
 *	0x112:	ffffffff	f = Ch2 Frequency[15: 8]
 *	0x113:	ffffffff	f = Ch2 Frequency[ 7: 0]
 *	0x114:	n???vvvv	v = Ch2 Right Volume
 *				n = Ch3 Noise Switch (̃`lpł)
 *
 *	0x118:	????vvvv	v = Ch3 Volume Left
 *	0x119	wwwwffff	w = Ch3 Wavetable Select (S16Fgp)
 *				f = Ch3 Frequency[19:16]
 *	0x11a:	ffffffff	f = Ch3 Frequency[15: 8]
 *	0x11b:	ffffffff	f = Ch3 Frequency[ 7: 0]
 *	0x11c:	n???vvvv	v = Ch3 Right Volume
 *				n = Ch4 Noise Switch (̃`lpł)
 *
 *	0x120:	????vvvv	v = Ch4 Volume Left
 *	0x121	wwwwffff	w = Ch4 Wavetable Select (S16Fgp)
 *				f = Ch4 Frequency[19:16]
 *	0x122:	ffffffff	f = Ch4 Frequency[15: 8]
 *	0x123:	ffffffff	f = Ch4 Frequency[ 7: 0]
 *	0x124:	n???vvvv	v = Ch4 Right Volume
 *				n = Ch5 Noise Switch (̃`lpł)
 *
 *	0x128:	????vvvv	v = Ch5 Volume Left
 *	0x129	wwwwffff	w = Ch5 Wavetable Select (S16Fgp)
 *				f = Ch5 Frequency[19:16]
 *	0x12a:	ffffffff	f = Ch5 Frequency[15: 8]
 *	0x12b:	ffffffff	f = Ch5 Frequency[ 7: 0]
 *	0x12c:	n???vvvv	v = Ch5 Right Volume
 *				n = Ch6 Noise Switch (̃`lpł)
 *
 *	0x130:	????vvvv	v = Ch6 Volume Left
 *	0x131	wwwwffff	w = Ch6 Wavetable Select (S16Fgp)
 *				f = Ch6 Frequency[19:16]
 *	0x132:	ffffffff	f = Ch6 Frequency[15: 8]
 *	0x133:	ffffffff	f = Ch6 Frequency[ 7: 0]
 *	0x134:	n???vvvv	v = Ch6 Right Volume
 *				n = Ch7 Noise Switch (̃`lpł)
 *
 *	0x138:	????vvvv	v = Ch7 Volume Left
 *	0x139	wwwwffff	w = Ch7 Wavetable Select (S16Fgp)
 *				f = Ch7 Frequency[19:16]
 *	0x13a:	ffffffff	f = Ch7 Frequency[15: 8]
 *	0x13b:	ffffffff	f = Ch7 Frequency[ 7: 0]
 *	0x13c:	n???vvvv	v = Ch7 Right Volume
 *				n = Ch0 Noise Switch (ŏ̃`lpł)
 *
 *	g`e[uRAMłB
 *	2Tv1oCgA4bit4bit̏A16FAS256oCgłB
 */
#define WSG_NUM_REGS	0x140	/* ő僌WX^ */

/* * {[lȂ΁Ao̓Tṽrbg
 *	t4bit ~ 8`l  t7bit
 *   łB
 *   {[lƁA
 *	t7bit ~ 4bit  t11bit
 *   łB
 *   ŏIo͕͂t16bitȂ̂ŁAKvȃXP[O
 *	16bit | 11bit { ()  5 { ()
 *   ƂȂ܂B
 *   ۂɂ͑S`lɖ邱Ƃ͏ȂA2bit(=4{)炢߂ɃXP[OĂ̂悤łB
 *   ~LVO1TvÂXP[OA炩߃{[XP[OĂIłB
 *   ]āA{[ݒ莞ɍ7bitVtgĂi[܂B
 *   {[i[pϐɂ́At4bit { 7bit  11bitȏKvłB
 *   Ȃ킿A{[i[pϐshortƂĂB
 * * ʂ̕@ƂāAg`f[^XP[OĂ@܂A͍̗p܂łB
 *   g`f[^͕t4bitłA7bitVtg11bitKvƂȂ܂B
 *   ݂͔g`f[^1Tv1oCgŊmۂĂ܂AshortɕύXȂ΂ȂȂĂ܂܂B
 *   {[Ȃ΃`l̑ōς݂܂Ag`f[^ƐSoCg̑ɂȂĂ܂܂B
 *   ܂Ag`f[^2oCgPʂɂȂƁA~LVOɂItZbgvZ̎ԂĂ܂܂B
 *   č́Ag`f[^ł͂ȂA{[XP[O@̗p邱Ƃɂ܂B
 */
#define WSG_VOLUME_SHIFT	(16 - 11 + 2)
				//         +-

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _WSG WSG;

/*
 *	WSG`l
 */
typedef struct _WSGCHANNEL {
	unsigned short volume;		/* + 0,2: {[ (0`15)<<WSG_VOLUME_SHIFT */
	unsigned short noise;		/* + 1,2: 0:g[ / 0ȊO:mCYLFSR */
	int frequency;			/* + 4,4: g           (17.15bitŒ菬) */
	int progress;			/* + 8,4: g`isJE^ (17.15bitŒ菬) */
	char* wave/*[0x20]*/;		/* +12,4: g`f[^̐擪AhX */
} WSGCHANNEL;				/* =16 */

/*
 *	WSGRA
 */
/*typedef*/ struct _WSG {
	unsigned char reg[WSG_NUM_REGS];/* WX^l */
	char wavetable[16][0x20];	/* g`e[u (Tvl:-8`+7) */
					/* g`e[uROMgp(Xevious,Mappy type)́AO8F̂ݎgp܂B */
					/* g`e[uRAMgp(System1 type)́AS16Fgp܂B */
	//
	WSGCHANNEL channel[8];		/* `l */
	//
	DDA clock_progress;		/* NbNisDDA */
} /*WSG*/;

/****************************************************************************
 *	֐
 ****************************************************************************/

//int wsg_process(WSG* wsg, int cycle);̂߁Awsg_mix()̒Ɋ܂߂܂B
int wsg_channel_process(WSG* wsg, WSGCHANNEL* channel, int cycle);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* WSGRAZbg܂B
 * [in]
 *	wsg		WSG\́B
 *	clock		TvONbNB
 *	wavetable	g`e[uROMC[Wւ̃|C^B
 *			g`e[uROMȂꍇ́ANULLw肵ĂB
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́AWSGZbgsꍇɁAKvɉČĂяoĂB
 *	* g`e[uROMC[W̌`́A̒ʂłB
 *	  E1Tv1oCgA4bit̂ݎgpBTvl0`15B
 *	  E1g`32TvB8g`̃e[uB(WSG.wavetable[16][0x20]̑O8F̂ݎgp܂)
 *	  E]āAg`e[uŜ̃TCY32~8=256oCgłB
 *	* wsg_reset()̒Ŕg`e[ũRs[쐬܂B
 *	  wsg_reset()ԂAĂяo͔g`e[ujč\܂B
 */
void wsg_reset(WSG* wsg, int clock, const void* wavetable/*[8][0x20]*/);

/* WX^l݂܂B
 * [in]
 *	wsg		WSG\́B
 *	addr		WX^AhXB
 *	data		WX^lB
 */
void wsg_write_xevious(WSG* wsg, int addr, unsigned char data);	/* Xevious type */
void wsg_write_mappy(WSG* wsg, int addr, unsigned char data);	/* Mappy type */
void wsg_write_system1(WSG* wsg, int addr, unsigned char data);	/* System1 type */

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁAw肳ꂽTṽ~LVOs܂B
 * [in]
 *	wsg		WSG\́B
 *	wbuff		o̓Tvobt@B
 *	count		o̓TvB
 */
void wsg_mix(WSG* wsg, short wbuff[/*count*/], int count);

#endif /*__CLIP_WSG_H__*/
