
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP
	
		.code
		.align		1
		.global		InitializeListHead
		.global		IsListEmpty
		.global		RemoveHeadList
		.global		RemoveTailList
		.global		RemoveEntryList
		.global		InsertHeadList
		.global		InsertTailList
		;//-------------------------------------;//
InitializeListHead:
	ext	0x4		; 		xld.w		[%r12+4], %r12		;//ListHead->Blink = ListHead
	ld.w	[%r12],%r12
		ld.w		[%r12], %r12		;//ListHead->Flink = ListHead
		ret
		;//-------------------------------------;//
IsListEmpty:
		ld.w		%r10, [%r12]		;//%r10    :=  ListHead->Flink
		cmp		%r10, %r12		;//%psr(Z) := (ListHead->Flink == ListHead)	!INTERLOCK!
		ld.w		%r10, %psr		;//%r10[1] := (ListHead->Flink == ListHead)
		ret.d					;//
		and		%r10, 2			;//return     (ListHead->Flink == ListHead)	*delay*		//Cł͔0lƂ1ԂAAsmł͔0lƂ2ԂB0lɈˑȂ悤ӂB
		;//-------------------------------------;//
RemoveHeadList:
		ld.w		%r12, [%r12]		;//%r12 := Head = ListHead->Flink
		jp		RemoveEntryList		;//return RemoveEntryList(Head)					//AsmRemoveEntryList()̉B߂lɈˑ
		;//-------------------------------------;//
RemoveTailList:
	ext	0x4		; 		xld.w		%r12, [%r12+4]		;//%r12 := Tail = ListHead->Blink
	ld.w	%r12,[%r12]
	;//sv	jp		RemoveEntryList		;//return RemoveEntryList(Tail)					//AsmRemoveEntryList()̉B߂lɈˑ
		;//-------------------------------------;//
RemoveEntryList:
	;//{{C^[bN
	;//	ld.w		%r10, %r12		;//%r10 := Entry
	;//	ld.w		%r11, [%r12]+		;//%r11 := Flink = Entry->Flink
	;//	ld.w		%r12, [%r12]		;//%r12 := Blink = Entry->Blink
	;//	ld.w		[%r12] %r11		;// Blink->Flink = Flink			!INTERLOCK!
	;//	xld.w		[%r11+4], %r12		;// Flink->Blink = Blink
	;//	ret					;//return  Entry						//AsmRemoveEntryList()̉B߂l %r10 := Entry
	;//C^[bN
		ld.w		%r10, %r12		;//%r10 := Entry
		ld.w		%r11, [%r12]+		;//%r11 := Flink = Entry->Flink
		ld.w		%r12, [%r12]		;//%r12 := Blink = Entry->Blink
	ext	0x4		; 		xld.w		[%r11+4], %r12		;// Flink->Blink = Blink
	ld.w	[%r11],%r12
		ld.w		[%r12] %r11		;// Blink->Flink = Flink
		ret					;//return  Entry						//AsmRemoveEntryList()̉B߂l %r10 := Entry
	;//}}C^[bN
		;//-------------------------------------;//
InsertHeadList:
	;//{{C^[bN,1ߐߖ
	;//	ld.w		%r9, [%r12]		;//%r9  :=    Head = ListHead->Flink
	;//	ld.w		[%r13], %r9		;//   Entry->Flink = Head			!INTERLOCK!
	;//	xld.w		[%r13+4], %r12		;//   Entry->Blink = ListHead
	;//	xld.w		[%r9+4], %r13		;//    Head->Blink = Entry
	;//	ld.w		[%r12], %r13		;//ListHead->Flink = Entry
	;//	ret
	;//C^[bN,1ߐߖ
		ld.w		%r9, [%r12]		;//%r9  :=    Head = ListHead->Flink
	ext	0x4		; 		xld.w		[%r9+4], %r13		;//    Head->Blink = Entry
	ld.w	[%r9],%r13
		ld.w		[%r12], %r13		;//ListHead->Flink = Entry
		ld.w		[%r13]+, %r9		;//   Entry->Flink = Head, %r13 := &Entry->Blink
		ld.w		[%r13], %r12		;//   Entry->Blink = ListHead
		ret
	;//}}C^[bN,1ߐߖ
		;//-------------------------------------;//
InsertTailList:
	;//{{1ߐߖ
	;//	xld.w		%r9, [%r12+4]		;//%r9  :=    Tail = ListHead->Blink
	;//	ld.w		[%r13], %r12		;//   Entry->Flink = ListHead
	;//	xld.w		[%r13+4], %r9		;//   Entry->Blink = Tail
	;//	xld.w		[%r12+4], %r13		;//ListHead->Blink = Entry
	;//	ld.w		[%r9], %r13		;//    Tail->Flink = Entry
	;//	ret
	;//1ߐߖ
		ld.w		[%r13], %r12		;//   Entry->Flink = ListHead
		add		%r12, 4			;//%r12 :=          &ListHead->Blink
		ld.w		%r9, [%r12]		;//%r9  :=    Tail = ListHead->Blink
	ext	0x4		; 		xld.w		[%r13+4], %r9		;//   Entry->Blink = Tail
	ld.w	[%r13],%r9
		ld.w		[%r12], %r13		;//ListHead->Blink = Entry
		ld.w		[%r9], %r13		;//    Tail->Flink = Entry
		ret
	;//}}1ߐߖ

