/*	
 *	framuvi.c
 *
 *	P/ECE Signetics 2637 UVI(Universal Video Interface) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sat Apr 30 13:14:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

#ifndef UVI_ASM

/****************************************************************************
 *
 ****************************************************************************/

/*
 * (] 16sNZ -> ] 11sNZ) x  8
 * (] c13C   -> ] c 8C  ) x 16
 *
 * 16sNZ -> 11sNZ̈kp^[́ÂƂłB
 *
 *			]Pixel#	]Pixel#
 *			------------	------------
 *			 0 		 0
 *			 1 + 2		 1
 *			 3 		 2
 *			------------	------------
 *			 4 + 5		 3
 *			 6 		 4
 *			   +--------	------------
 *			 7 + 8		 5
 *			---+
 *			 9 		 6
 *			10 +11		 7
 *			------------	------------
 *			12 		 8
 *			13 +14		 9
 *			15 		10
 *			------------	------------
 *
 * 13C -> 8C̈kp^[́ÂƂłB
 *
 *			]Line#	]Line#
 *	i=1		-----------	-----------
 *	i=1->0->3	 0 		 0
 *	i=3->2		 1 + 2		 1
 *	i=2->1		 3 + 4  	 2
 *	i=1->0->3	 5 		 3
 *	i=3->2		 6 + 7		 4
 *	i=2->1		 8 + 9		 5
 *	i=1->0->3	10 		 6
 *	i=3->2		11 +12		 7
 *			------------	------------
 */
void
uvi_reduce(unsigned char dst[/*88*128*/], const unsigned char src[/*128*208*/])
{
	const unsigned int* tmp = (const unsigned int*)src;
	//
	int i;
	int x;
	int y;
	int z;
	unsigned int s;
	unsigned int t;

	z = 8;
	do {
		y = 16;
		i = 1;
		do {
			x = 8;
			if(!--i) {
				do {
					s      = *tmp++;			// s = [3][2][1][0]
					*dst++ =                s    ; s >>= 8;	// s =    [3][2][1], out =  [0]
					t      =                s    ; s >>= 8;	// s =       [3][2], t   =  [1]
					t     +=                s    ; s >>= 8;	// s =          [3], t   =  [1]+[2]
					*dst++ = (unsigned char)t / 2;		//                   out = ([1]+[2])/2
					*dst++ =                s    ;		//                   out =  [3]
					//
					s      = *tmp++;			// s = [7][6][5][4]
					t      =                s    ; s >>= 8;	// s =    [7][6][5], t   =  [4]
					t     +=                s    ; s >>= 8;	// s =       [7][6], t   =  [4]+[5]
					*dst++ = (unsigned char)t / 2;		//                   out = ([4]+[5])/2
					*dst++ =                s    ; s >>= 8;	// s =          [7], out =  [6]
					t      =                s    ;		//                   t   =  [7]
					//
					s      = *tmp++;			// s = [B][A][9][8]
					t     +=                s    ; s >>= 8;	// s =    [B][A][9], t   =  [7]+[8]
					*dst++ = (unsigned char)t / 2;		//                   out = ([7]+[8])/2
					*dst++ =                s    ; s >>= 8;	// s =       [B][A], out =  [9]
					t      =                s    ; s >>= 8;	// s =          [B], t   =  [A]
					t     +=                s    ;		//                   t   =  [A]+[B]
					*dst++ = (unsigned char)t / 2;		//                   out = ([A]+[B])/2
					//
					s      = *tmp++;			// s = [F][E][D][C]
					*dst++ =                s    ; s >>= 8;	// s =    [F][E][D], out =  [C]
					t      =                s    ; s >>= 8;	// s =       [F][E], t   =  [D]
					t     +=                s    ; s >>= 8;	// s =          [F], t   =  [D]+[E]
					*dst++ = (unsigned char)t / 2;		//                   out = ([D]+[E])/2
					*dst++ =                s    ;		//                   out =  [F]
				} while(--x);
				i = 3;
			} else {
				do {
					s      = tmp[128 / 4];
					s     += *tmp++;			// s = [3][2][1][0]
					*dst++ = (unsigned char)s / 2; s >>= 8;	// s =    [3][2][1], out = ([0]    )/2
					t      =                s    ; s >>= 8;	// s =       [3][2], t   =  [1]
					t     +=                s    ; s >>= 8;	// s =          [3], t   =  [1]+[2]
					*dst++ = (unsigned char)t / 4;		//                   out = ([1]+[2])/4
					*dst++ = (unsigned char)s / 2;		//                   out = ([3]    )/2
					//
					s      = tmp[128 / 4];
					s     += *tmp++;			// s = [7][6][5][4]
					t      =                s    ; s >>= 8;	// s =    [7][6][5], t   =  [4]
					t     +=                s    ; s >>= 8;	// s =       [7][6], t   =  [4]+[5]
					*dst++ = (unsigned char)t / 4;		//                   out = ([4]+[5])/4
					*dst++ = (unsigned char)s / 2; s >>= 8;	// s =          [7], out = ([6]    )/2
					t      =                s    ;		//                   t   =  [7]
					//
					s      = tmp[128 / 4];
					s     += *tmp++;			// s = [B][A][9][8]
					t     +=                s    ; s >>= 8;	// s =    [B][A][9], t   =  [7]+[8]
					*dst++ = (unsigned char)t / 4;		//                   out = ([7]+[8])/4
					*dst++ = (unsigned char)s / 2; s >>= 8;	// s =       [B][A], out = ([9]    )/2
					t      =                s    ; s >>= 8;	// s =          [B], t   =  [A]
					t     +=                s    ;		//                   t   =  [A]+[B]
					*dst++ = (unsigned char)t / 4;		//                   out = ([A]+[B])/4
					//
					s      = tmp[128 / 4];
					s     += *tmp++;			// s = [F][E][D][C]
					*dst++ = (unsigned char)s / 2; s >>= 8;	// s =    [F][E][D], out = ([C]    )/2
					t      =                s    ; s >>= 8;	// s =       [F][E], t   =  [D]
					t     +=                s    ; s >>= 8;	// s =          [F], t   =  [D]+[E]
					*dst++ = (unsigned char)t / 4;		//                   out = ([D]+[E])/4
					*dst++ = (unsigned char)s / 2;		//                   out = ([F]    )/2
				} while(--x);
				tmp += 128 / 4;
			}
		} while(--y);
	} while(--z);
}

/*--------------------------------------------------------------------------*/

void
uvi_draw_chr_8x8(int x, int y, int code, int color)
{
	unsigned char* vbuff;
	unsigned char* font;
	int y_min;
	int y_max;
	int cs;
	int cc;
	int ix;
	int iy;
	int v;

	y_min = uvi.scan_start;
	y_max = uvi.scan_end;

	/* Sɕ`̈OȂ΁A܂B */
	if((y <= y_min - 8) || (y >= y_max) ||
	   (x <=     0 - 8) || (x >=   128)) {
		return;
	}

	vbuff = &uvi.vbuff[y * 128 + x];
	font = &uvi_font[code * 8];
	cs = uvi.color[color][0];
	cc = uvi.color[color][1];

	/* Sɕ`̈Ȃ΁ANbsOsvłB */
	if((y >= y_min) && (y <= y_max - 8) &&
	   (x >=     0) && (x <=   128 - 8)) {
		iy = 8;
		do {
			v = *font++;
			ix = 8;
			do {
				*vbuff++ = (v & 0x80) ? cc : cs;
				v <<= 1;
			} while(--ix);
			vbuff += 128 - 8;
		} while(--iy);

	/* `̈͂ݏoꍇANbsOKvłB */
	} else {
		iy = 8;
		do {
			if((y >= y_min) && (y < y_max)) {
				v = *font;
				ix = 8;
				do {
					if((x >= 0) && (x < 128)) {
						*vbuff = (v & 0x80) ? cc : cs;
					}
					vbuff++;
					v <<= 1;
					x++;
				} while(--ix);
				vbuff -= 8;
				x -= 8;
			}
			vbuff += 128;
			y += 1;
			font++;
		} while(--iy);
	}
}

/*--------------------------------------------------------------------------*/

void
uvi_draw_obj_8x8(UVIOBJ* obj)
{
	unsigned char* vbuff;
	unsigned char* font;
	int y_min;
	int y_max;
	int cc;
	int ix;
	int iy;
	int x;
	int y;
	int v;

	x = obj->x;
	y = obj->y;
	y_min = uvi.scan_start;
	y_max = uvi.scan_end;

	/* Sɕ`̈OȂ΁A܂B */
	if((y <= y_min - 8) || (y >= y_max) ||
	   (x <=     0 - 8) || (x >=   128)) {
		return;
	}

	vbuff = &uvi.vbuff[y * 128 + x];
	font = obj->font;
	cc = obj->color;

	/* Sɕ`̈Ȃ΁ANbsOsvłB */
	if((y >= y_min) && (y <= y_max - 8) &&
	   (x >=     0) && (x <=   128 - 8)) {
		iy = 8;
		do {
			v = *font++;
			ix = 8;
			do {
				if(v & 0x80) {
					*vbuff = cc;
				}
				vbuff++;
				v <<= 1;
			} while(--ix);
			vbuff += 128 - 8;
		} while(--iy);

	/* `̈͂ݏoꍇANbsOKvłB */
	} else {
		iy = 8;
		do {
			if((y >= y_min) && (y < y_max)) {
				v = *font;
				ix = 8;
				do {
					if(v & 0x80) {
						if((x >= 0) && (x < 128)) {
							*vbuff = cc;
						}
					}
					vbuff++;
					v <<= 1;
					x++;
				} while(--ix);
				vbuff -= 8;
				x -= 8;
			}
			vbuff += 128;
			y += 1;
			font++;
		} while(--iy);
	}
}

/****************************************************************************
 *
 ****************************************************************************/

#endif /*UVI_ASM*/
