/*	
 *	framspc.c
 *
 *	P/ECE SPC Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Jan 06 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	SSMPG~[VpO֐
 ****************************************************************************/

unsigned char
spc_ssmp_read(SSMP* ssmp, unsigned short addr)
{
	SPCDRIVER* spc = (SPCDRIVER*)ssmp;
	unsigned char* mem = spc->mem;

	/* $00F0`$00FF: I/O Area */
	if(addr >= 0xf0 && addr <= 0xff) {
		return spc_ssmp_in(ssmp, addr);
	}

	/* Main Memory */
	return mem[addr];
}

void
spc_ssmp_write(SSMP* ssmp, unsigned short addr, unsigned char data)
{
	SPCDRIVER* spc = (SPCDRIVER*)ssmp;
	unsigned char* mem = spc->mem;

	/* $00F0`$00FF: I/O Area */
	if(addr >= 0xf0 && addr <= 0xff) {
		spc_ssmp_out(ssmp, addr, data);
		return;
	}

	/* Main Memory */
	mem[addr] = data;
}

