/*	
 *	framsn7.c
 *
 *	P/ECE SN76489/SN76496(DCSG) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Mon Jan 24 18:30:00 JST 2005 Naoyuki Sawa
 *	- ̂߂ɑ啝ȉs܂B
 *	  VGM PlayerŜ2.5{xȂ̂ŁAP̂ł͂ƑȂĂƎv܂B
 *	- т̂鋌R[h keep/SN76489Oۑ-20050124.zip ɕۑĂ܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

/* Ŝ߁A1Tv̏o͋ɐ]񐔁ALFSRVtg񐔂𐧌܂B
 * ɒ[ɎZƁA1Tv̔]񐔂Ȃ肷āA
 * TEh荞݂ɊԂɍ킸AnOAbv댯邩łB
 * 1Tv̔]񐔂 (2^SN76489_SAFETY_SHIFT) ȉɐ܂B
 * Ȃ킿 ōg16000[Hz]~(2^SN76489_SAFETY_SHIFT) ƂȂ܂B
 */
#define SN76489_SAFETY_SHIFT	4/**/

/* e`l̏o͂-15..15(t5bit)łB
 * S4`lȂ̂ŁAt5bit~4=t7bitƂȂ܂B
 * t16bitփXP[O邽߂ɁA(16-7)bitVtg܂B
 * ʑ̂߂ɁA+1bitVtg܂B()
 */
#define SN76489_VOLUME_SHIFT	((16 - 7) + 1/**/)

/****************************************************************************
 *	
 ****************************************************************************/

void
sn76489_tone_mix(SN76489* sn, SN76489TONE* tone, short wbuff[/*count*/], int count)
{
	int clock;
	int volume;
	int period;
	int progress;

	ASSERT(count > 0);

	/* {[擾܂B */
	volume = tone->volume;
	if(!volume) {
		return;
	}

	/* ݂̏o͋ɐ𔽉f܂B */
	if(tone->polarity) {
		volume = -volume;
	}

	/* 擾܂B */
	period = tone->period;

	/* ͓̓NbN~16PʂłB */
	period *= SPEAKER_FREQUENCY * 16;

	/* ̓NbN擾܂B */
	clock = sn->clock;

	/* Ŝ߁A1Tv̏o͋ɐ]񐔂𐧌܂B */
	if(period < (clock >> SN76489_SAFETY_SHIFT)) {
		period = clock >> SN76489_SAFETY_SHIFT;
	}

	/* ̂߁AisJE^oĂ܂B */
	progress = tone->progress;

	/* o͔g`[vB */
	do {
		if((progress += clock) >= 0) {
			do {
				volume = -volume;
			} while((progress -= period) >= 0);
		}
		*wbuff++ += volume;
	} while(--count);

	/* isJE^߂܂B */
	tone->progress = progress;

	/* Ō̏o͋ɐ߂܂B */
	tone->polarity = volume < 0;
}

/****************************************************************************
 *	
 ****************************************************************************/

void
sn76489_noise_mix(SN76489* sn, SN76489NOISE* noise, short wbuff[/*count*/], int count)
{
	int clock;
	int volume;
	int period;
	int progress;
	int lfsr;
	int fbtype;
	int parity;

	ASSERT(count > 0);

	/* {[擾܂B */
	volume = noise->volume;
	if(!volume) {
		return;
	}

	/* 擾܂B */
	period = noise->period;
	if(!period) {
		period = sn->tone[2].period; /* Tone2̎gp */
	}

	/* ͓̓NbN~16PʂłB */
	period *= SPEAKER_FREQUENCY * 16;

	/* ̓NbN擾܂B */
	clock = sn->clock;

	/* Ŝ߁A1TvLFSRVtg񐔂𐧌܂B */
	if(period < (clock >> SN76489_SAFETY_SHIFT)) {
		period = clock >> SN76489_SAFETY_SHIFT;
	}

	/* tB[hobN^Cv擾܂B */
	fbtype = noise->fbtype;

	/* ̂߁AisJE^LFSRoĂ܂B */
	progress = noise->progress;
	lfsr = noise->lfsr;

	/* o͔g`[vB */
	do {
		if((progress += clock) >= 0) {
			do {
				/* ^bvrbg̊peB߂܂B
				 *   0=mCY     (^bvrbg=0x1)
				 *   1=zCgmCY (^bvrbg=0x9)
				 */
				parity = lfsr;
				if(fbtype) {
					parity ^= lfsr >> 3;
				}
				parity &= 1;
				/* LFSRVtgAtB[hobN܂B */
				lfsr = (lfsr >> 1) | (parity << 15);
			} while((progress -= period) >= 0);
		}
		*wbuff++ += (lfsr & 1) ? -volume : volume;
	} while(--count);

	/* isJE^LFSR߂܂B */
	noise->progress = progress;
	noise->lfsr = lfsr;
}

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef PIECE

void
sn76489_volume_shift(short wbuff[/*count*/], int count)
{
	int v;

	ASSERT(count > 0);

	do {
		v = *wbuff;
		v <<= SN76489_VOLUME_SHIFT;
		if(v >  32767) v =  32767;
		if(v < -32768) v = -32768;
		*wbuff++ = v;
	} while(--count);
}

#else /*PIECE*/

asm("
	.code
	.align 1
	.global sn76489_volume_shift
sn76489_volume_shift:
	; %r12 = wbuff
	; %r13 = count
	xld.w %r4, 32767
	not %r5, %r4			; -32768
sn76489_volume_shift_DO:
	ld.h %r6, [%r12]
	xsll %r6, 10			; SN76489_VOLUME_SHIFT = (16-7)+1 = 10
	cmp %r6, %r4
	jrle.d 3
	cmp %r6, %r5			; *delay*
	ld.w %r6, %r4			; (skip?)
	jrge.d 3
	sub %r13, 1			; *delay*
	ld.w %r6, %r5			; (skip?)
	ld.h [%r12]+, %r6
	xjrne sn76489_volume_shift_DO
	ret
");

#endif /*PIECE*/
