
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP
	
		.code
		.align		1
		.global		s1c17_cpu_exec
s1c17_cpu_exec:
	ext	s1c17_cpu+0x28@h	; 		Xld.w		%r4, s1c17_cpu+40		;// %r4  := &s1c17_cpu.pc
	ext	s1c17_cpu+0x28@m
	ld.w	%r4,s1c17_cpu+0x28@l
		ld.w		%r5, [%r4]			;// %r5  := pc = s1c17_cpu.pc
		ld.w		%r13, %r5			;// %r13 := pc					!INTERLOCK!
		add		%r5, 2				;// %r5  := pc + 2
		sll		%r5, 8				;// %r5  := (pc + 2) << 8
		srl		%r5, 8				;// %r5  := ((pc + 2) << 8) >> 8
		ld.w		[%r4], %r5			;// s1c17_cpu.pc = ((pc + 2) << 8) >> 8
	ext	s1c17_bcu_read@rm	; 		Xcall.d		s1c17_bcu_read			;// %r10 := x16 = s1c17_bcu_read(2, pc)
	call.d	s1c17_bcu_read@rl
		ld.w		%r12, 2				;// %r12 := 2					*delay*
		;//
	ext	s1c17_op_root+0x0@h	; 		Xld.w		%r11, s1c17_op_root		;// %r11 := &s1c17_op_root
	ext	s1c17_op_root+0x0@m
	ld.w	%r11,s1c17_op_root+0x0@l
		ld.w		%r4, %r11			;// %r4  := next = &s1c17_op_root
s1c17_cpu_exec_LOOP:
		ld.w		%r5, [%r4]			;// %r5  := op = *next
		cmp		%r5, 0				;// if(!op)					!INTERLOCK!
		jreq		s1c17_cpu_exec_RET		;//   return
		;//
		ld.uh		%r6, [%r5]+			;// %r6  := mask = op->mask
		ld.uh		%r7, [%r5]+			;// %r7  := code = op->code
		and		%r6, %r10			;// %r6  := x16 & mask
		cmp		%r6, %r7			;// if((x16 & mask) == code)
		jreq		s1c17_cpu_exec_HIT		;//   goto HIT
		;//
		add		%r5, 8				;// %r5  := &op->next
		jp.d		s1c17_cpu_exec_LOOP		;// goto LOOP
		ld.w		%r4, %r5			;// %r4  := next = &op->next			*delay*
		;//---------------------------------------------;//
s1c17_cpu_exec_HIT:
		ld.w		%r6, [%r5]+			;// %r6  := op->fn1
		ld.w		%r13, [%r5]+			;// %r13 := op->fn2, %r5  := &op->next
		;//{{LRU
		ld.w		%r7, [%r5]			;// %r7  := op->next
		ld.w		[%r4], %r7			;// *next = op->next				!INTERLOCK!
		ld.w		%r7, [%r11]			;// %r7  := s1c17_op_root
		ld.w		[%r5], %r7			;// op->next = s1c17_op_root			!INTERLOCK!
		sub		%r5, 12				;// %r5  := op
		ld.w		[%r11], %r5			;// s1c17_op_root = op
		;//}}LRU
		ld.w		%r12, %r10			;// %r12 := x16
		jp		%r6				;// op->fn1(x16, op->fn2)			(jp.d %rb͕s)
		;//---------------------------------------------;//
s1c17_cpu_exec_RET:
		ret

	
		.code
		.align		1
		.global		s1c17_x16
		.global		s1c17_x9_imm7
		.global		s1c17_x3_imm13
		.global		s1c17_x9_imm5_x2
		.global		s1c17_x6_imm3_imm5_x2
		.global		s1c17_x8_d_x7
		.global		s1c17_x8_d_imm7
		.global		s1c17_x8_d_sign7
		.global		s1c17_x5_d_sign10
		.global		s1c17_x8_d_x4_rb
		.global		s1c17_x13_rs
		.global		s1c17_x6_rd_x7
		.global		s1c17_x6_rs_x7
		.global		s1c17_x6_rd_imm7
		.global		s1c17_x6_rs_imm7
		.global		s1c17_x6_rd_sign7
		.global		s1c17_x6_rd_x4_rs
		.global		s1c17_x6_rd_x4_rb
		.global		s1c17_x6_rs_x4_rb
s1c17_x16:
		jp		%r13
s1c17_x9_imm7:							;// %r12 := 00000000 00000000 ???????? 0xxxxxxx
	ext	0x1		; 		Xand		%r12, %r12, 0x7F		;// %r12 := 00000000 00000000 00000000 0xxxxxxx
	and	%r12,0x3f
		jp		%r13
s1c17_x3_imm13:							;// %r12 := 00000000 00000000 ???xxxxx xxxxxxxx
	ext	0x7f		; 		Xand		%r12, %r12, 0x1FFF		;// %r12 := 00000000 00000000 000xxxxx xxxxxxxx
	and	%r12,0x3f
		jp		%r13
s1c17_x9_imm5_x2:						;// %r12 := 00000000 00000000 ???????? ?xxxxx??
		sra		%r12, 2				;// %r12 := 00000000 00000000 00?????? ???xxxxx
		and		%r12, 0x1F			;// %r12 := 00000000 00000000 00000000 000xxxxx
		jp		%r13
s1c17_x6_imm3_imm5_x2:						;// %r12 := 00000000 00000000 ??????xx xyyyyy??
		ld.w		%r4, %r13
		sra		%r12, 2				;// %r12 := 00000000 00000000 00?????? xxxyyyyy
	ext	0x1f		; 		Xand		%r13, %r12, 0x1F		;// %r13 := 00000000 00000000 00000000 000yyyyy
	and	%r13,%r12
		sra		%r12, 5				;// %r12 := 00000000 00000000 0000000? ?????xxx
		and		%r12, 7				;// %r12 := 00000000 00000000 00000000 00000xxx
		jp		%r4
s1c17_x8_d_x7:							;// %r12 := 00000000 00000000 ???????? x???????
		sra		%r12, 7				;// %r12 := 00000000 00000000 0000000? ???????x
		and		%r12, 1				;// %r12 := 00000000 00000000 00000000 0000000x
		jp		%r13
s1c17_x8_d_imm7:						;// %r12 := 00000000 00000000 ???????? xyyyyyyy
		ld.w		%r4, %r13
	ext	0x7f		; 		Xand		%r13, %r12, 0x7F		;// %r13 := 00000000 00000000 00000000 0yyyyyyy
	and	%r13,%r12
		sra		%r12, 7				;// %r12 := 00000000 00000000 0000000? ???????x
		and		%r12, 1				;// %r12 := 00000000 00000000 00000000 0000000x
		jp		%r4
s1c17_x8_d_sign7:						;// %r12 := 00000000 00000000 ???????? xyyyyyyy
		ld.w		%r4, %r13
		sla		%r12, 1				;// %r12 := 00000000 0000000? ???????x yyyyyyy0
		ld.b		%r13, %r12			;// %r13 := ssssssss ssssssss ssssssss yyyyyyy0
		sra		%r13, 1				;// %r13 := ssssssss ssssssss ssssssss syyyyyyy
		sra		%r12, 8				;// %r12 := 00000000 00000000 0000000? ???????x
		and		%r12, 1				;// %r12 := 00000000 00000000 00000000 0000000x
		jp		%r4
s1c17_x5_d_sign10:						;// %r12 := 00000000 00000000 ?????xyy yyyyyyyy
		ld.w		%r4, %r13
		sla		%r12, 6				;// %r12 := 00000000 00?????x yyyyyyyy yy000000
		ld.h		%r13, %r12			;// %r13 := ssssssss ssssssss yyyyyyyy yy000000
		sra		%r13, 6				;// %r13 := ssssssss ssssssss ssssssyy yyyyyyyy
	sra	%r12,0x8	; 		Xsra		%r12, 16			;// %r12 := 00000000 00000000 00000000 00?????x
	sra	%r12,0x8
		and		%r12, 1				;// %r12 := 00000000 00000000 00000000 0000000x
		jp		%r4
s1c17_x8_d_x4_rb:						;// %r12 := 00000000 00000000 ???????? x????yyy
		ld.w		%r4, %r13
	ext	0x7		; 		Xand		%r13, %r12, 7			;// %r13 := 00000000 00000000 00000000 00000yyy
	and	%r13,%r12
		sla		%r13, 2				;// %r13 := 00000000 00000000 00000000 000yyy00
		ext		s1c17_cpu@ah
		ext		s1c17_cpu@al
		add		%r13, %r13			;// %r13 := 00000000 00000000 00000000 000yyy00 + s1c17_cpu.r
		sra		%r12, 7				;// %r12 := 00000000 00000000 0000000? ???????x
		and		%r12, 1				;// %r12 := 00000000 00000000 00000000 0000000x
		jp		%r4
s1c17_x13_rs:							;// %r12 := 00000000 00000000 ???????? ?????xxx
		and		%r12, 7				;// %r12 := 00000000 00000000 00000000 00000xxx
		sla		%r12, 2				;// %r12 := 00000000 00000000 00000000 000xxx00
		ext		s1c17_cpu@ah
		ext		s1c17_cpu@al
		add		%r12, %r12			;// %r12 := 00000000 00000000 00000000 000xxx00 + s1c17_cpu.r
		jp		%r13
s1c17_x6_rd_x7:
s1c17_x6_rs_x7:							;// %r12 := 00000000 00000000 ??????xx x???????
		sra		%r12, 5				;// %r12 := 00000000 00000000 00000??? ???xxx??
		and		%r12, 0x1C			;// %r12 := 00000000 00000000 00000000 000xxx00
		ext		s1c17_cpu@ah
		ext		s1c17_cpu@al
		add		%r12, %r12			;// %r12 := 00000000 00000000 00000000 000xxx00 + s1c17_cpu.r
		jp		%r13
s1c17_x6_rd_imm7:
s1c17_x6_rs_imm7:						;// %r12 := 00000000 00000000 ??????xx xyyyyyyy
		ld.w		%r4, %r13
	ext	0x7f		; 		Xand		%r13, %r12, 0x7F		;// %r13 := 00000000 00000000 00000000 0yyyyyyy
	and	%r13,%r12
		sra		%r12, 5				;// %r12 := 00000000 00000000 00000??? ???xxxyy
		and		%r12, 0x1C			;// %r12 := 00000000 00000000 00000000 000xxx00
		ext		s1c17_cpu@ah
		ext		s1c17_cpu@al
		add		%r12, %r12			;// %r12 := 00000000 00000000 00000000 000xxx00 + s1c17_cpu.r
		jp		%r4
s1c17_x6_rd_sign7:						;// %r12 := 00000000 00000000 ??????xx xyyyyyyy
		ld.w		%r4, %r13
		sla		%r12, 1				;// %r12 := 00000000 0000000? ?????xxx yyyyyyy0
		ld.b		%r13, %r12			;// %r13 := ssssssss ssssssss ssssssss yyyyyyy0
		sra		%r13, 1				;// %r13 := ssssssss ssssssss ssssssss syyyyyyy
		sra		%r12, 6				;// %r12 := 00000000 00000000 00000??? ???xxxyy
		and		%r12, 0x1C			;// %r12 := 00000000 00000000 00000000 000xxx00
		ext		s1c17_cpu@ah
		ext		s1c17_cpu@al
		add		%r12, %r12			;// %r12 := 00000000 00000000 00000000 000xxx00 + s1c17_cpu.r
		jp		%r4
s1c17_x6_rd_x4_rs:
s1c17_x6_rd_x4_rb:
s1c17_x6_rs_x4_rb:						;// %r12 := 00000000 00000000 ??????xx x????yyy
		ld.w		%r4, %r13
	ext	s1c17_cpu+0x0@h	; 		Xld.w		%r5, s1c17_cpu
	ext	s1c17_cpu+0x0@m
	ld.w	%r5,s1c17_cpu+0x0@l
	ext	0x7		; 		Xand		%r13, %r12, 7			;// %r13 := 00000000 00000000 00000000 00000yyy
	and	%r13,%r12
		sla		%r13, 2				;// %r13 := 00000000 00000000 00000000 000yyy00
		add		%r13, %r5			;// %r13 := 00000000 00000000 00000000 000yyy00 + s1c17_cpu.r
		sra		%r12, 5				;// %r12 := 00000000 00000000 00000??? ???xxx??
		and		%r12, 0x1C			;// %r12 := 00000000 00000000 00000000 000xxx00
		add		%r12, %r5			;// %r12 := 00000000 00000000 00000000 000xxx00 + s1c17_cpu.r
		jp		%r4

	
		.code
		.align		1
		.global		s1c17_0_imm13_imm24
		.global		s1c17_0_imm13_imm16
		.global		s1c17_rb_rb_imm13_rb_imm24
		.global		s1c17_sp_sp_imm13_sp_imm24
		.global		s1c17_increment_rb_x_imm13_imm24
		.global		s1c17_decrement_rb_x_imm13_imm24
		.global		s1c17_increment_sp_4_imm13_imm24
		.global		s1c17_decrement_sp_4_imm13_imm24
		;//-----------------------------------------------------;//
s1c17_0_imm13_imm24:
	ext	s1c17_cpu+0x2c@h	; 		Xld.w		%r4, s1c17_cpu+44			;// %r4  := &s1c17_cpu.ext1
	ext	s1c17_cpu+0x2c@m
	ld.w	%r4,s1c17_cpu+0x2c@l
		ld.h		%r10, [%r4]+				;// %r10 := ext1
		cmp		%r10, -1				;// if(ext1 != -1)
		jrne		s1c17_0_imm13_imm24_EXT1		;//   goto EXT1
		ret.d							;// return 0
		ld.w		%r10, 0					;//						*delay*
s1c17_0_imm13_imm24_EXT1:
		ld.h		%r5, [%r4]				;// %r5  := ext2
		cmp		%r5, -1					;// if(ext2 != -1)				!INTERLOCK!
		jrne		s1c17_0_imm13_imm24_EXT2		;//   goto EXT2
		ret							;// return ext1
s1c17_0_imm13_imm24_EXT2:
	sla	%r5,0x8		; 		Xsla		%r5, 13					;// %r5  :=           ext2 << 13
	sla	%r5,0x5
		or		%r10, %r5				;// %r10 :=   ext1 | (ext2 << 13)
		sll		%r10, 8					;// %r10 :=  (ext1 | (ext2 << 13)) << 8
		ret.d							;// return  ((ext1 | (ext2 << 13)) << 8) >> 8
		srl		%r10, 8					;// %r10 := ((ext1 | (ext2 << 13)) << 8) >> 8	*delay*
		;//-----------------------------------------------------;//
s1c17_0_imm13_imm16:
		call		s1c17_0_imm13_imm24			;// %r10 := x = s1c17_0_imm13_imm24()
		ret.d
		ld.uh		%r10, %r10				;// %r10 := (unsigned short)x			*delay*
		;//-----------------------------------------------------;//
s1c17_rb_rb_imm13_rb_imm24:
		pushn		%r0
		ld.w		%r0, [%r12]				;// %r0  := *rb
		call		s1c17_0_imm13_imm24			;// %r10 := x = s1c17_0_imm13_imm24()
		add		%r10, %r0				;// %r10 := x += *rb
		popn		%r0
		sll		%r10, 8					;// %r10 := x <<= 8
		ret.d
		srl		%r10, 8					;// %r10 := x >>= 8				*delay*
		;//-----------------------------------------------------;//
s1c17_sp_sp_imm13_sp_imm24:
	ext	s1c17_cpu+0x24@h	; 		Xld.w		%r12, s1c17_cpu+36			;// %r12 := rb = &s1c17_cpu.sp
	ext	s1c17_cpu+0x24@m
	ld.w	%r12,s1c17_cpu+0x24@l
		jp		s1c17_rb_rb_imm13_rb_imm24		;// return s1c17_rb_rb_imm13_rb_imm24(rb)
		;//-----------------------------------------------------;//
s1c17_increment_rb_x_imm13_imm24:
	ext	s1c17_cpu+0x2d@ah	; 		Xbtst		[s1c17_cpu+45], 7			;// if(ext1 < 0) {
	ext	s1c17_cpu+0x2d@al
	btst	[%r8],0x7
		jrne		s1c17_increment_rb_x_imm13_imm24_L10	;//   
		 pushn		%r0					;//   
		 call.d		s1c17_0_imm13_imm24			;//   %r10 := x = s1c17_0_imm13_imm24()
		 ld.w		%r0, %r12				;//   %r0  := rb				*delay*
		 ld.w		%r12, %r0				;//   %r12 := rb
		 popn		%r0					;//   
		 ld.w		%r13, %r10				;//   %r13 := x
s1c17_increment_rb_x_imm13_imm24_L10:					;// }
		ld.w		%r10, [%r12]				;// %r10 :=      *rb
		add		%r10, %r13				;// %r10 := x += *rb				!INTERLOCK!
		sll		%r10, 8					;// %r10 := x <<= 8
		srl		%r10, 8					;// %r10 := x >>= 8
		ld.w		[%r12], %r10				;// *rb  := x
		ret
		;//-----------------------------------------------------;//
s1c17_decrement_rb_x_imm13_imm24:
	ext	s1c17_cpu+0x2d@ah	; 		Xbtst		[s1c17_cpu+45], 7			;// if(ext1 < 0) {
	ext	s1c17_cpu+0x2d@al
	btst	[%r8],0x7
		jrne		s1c17_decrement_rb_x_imm13_imm24_L10	;//   
		 pushn		%r0					;//   
		 call.d		s1c17_0_imm13_imm24			;//   %r10 := x = s1c17_0_imm13_imm24()
		 ld.w		%r0, %r12				;//   %r0  := rb				*delay*
		 ld.w		%r12, %r0				;//   %r12 := rb
		 popn		%r0					;//   
		 ld.w		%r13, %r10				;//   %r13 := x
s1c17_decrement_rb_x_imm13_imm24_L10:					;// }
		ld.w		%r10, [%r12]				;// %r10 :=      *rb
		sub		%r10, %r13				;// %r10 := x -= *rb				!INTERLOCK!
		sll		%r10, 8					;// %r10 := x <<= 8
		srl		%r10, 8					;// %r10 := x >>= 8
		ld.w		[%r12], %r10				;// *rb  := x
		ret
		;//-----------------------------------------------------;//
s1c17_increment_sp_4_imm13_imm24:
	ext	s1c17_cpu+0x24@h	; 		Xld.w		%r12, s1c17_cpu+36			;// %r12 := rb = &s1c17_cpu.sp
	ext	s1c17_cpu+0x24@m
	ld.w	%r12,s1c17_cpu+0x24@l
		jp.d		s1c17_increment_rb_x_imm13_imm24	;// s1c17_increment_rb_x_imm13_imm24(rb, 4)
		ld.w		%r13, 4					;// %r13 := 4					*delay*
		;//-----------------------------------------------------;//
s1c17_decrement_sp_4_imm13_imm24:
	ext	s1c17_cpu+0x24@h	; 		Xld.w		%r12, s1c17_cpu+36			;// %r12 := rb = &s1c17_cpu.sp
	ext	s1c17_cpu+0x24@m
	ld.w	%r12,s1c17_cpu+0x24@l
		jp.d		s1c17_decrement_rb_x_imm13_imm24	;// s1c17_decrement_rb_x_imm13_imm24(rb, 4)
		ld.w		%r13, 4					;// %r13 := 4					*delay*

	
		.code
		.align		1
		.global		s1c17_imm7_imm20_imm24
		.global		s1c17_imm7_imm16
		.global		s1c17_sp_imm7_sp_imm20_sp_imm24
		;//---------------------------------------------;//
s1c17_imm7_imm20_imm24:
	ext	s1c17_cpu+0x2c@h	; 		Xld.w		%r4, s1c17_cpu+44		;// %r4  := &s1c17_cpu.ext1
	ext	s1c17_cpu+0x2c@m
	ld.w	%r4,s1c17_cpu+0x2c@l
		ld.h		%r5, [%r4]+			;// %r5  := ext1
		cmp		%r5, -1				;// if(ext1 != -1)
		jrne.d		s1c17_imm7_imm20_imm24_EXT1	;//   goto EXT1
		ld.w		%r10, %r12			;// %r10 := x = imm7				*delay*
		ret						;// return x
s1c17_imm7_imm20_imm24_EXT1:
		ld.h		%r6, [%r4]			;// %r6  := ext2
		sla		%r5, 7				;// %r5  := ext1 << 7				*anti-interlock*
		cmp		%r6, -1				;// if(ext2 != -1)
		jrne.d		s1c17_imm7_imm20_imm24_EXT2	;//   goto EXT2
		or		%r10, %r5			;// %r10 := x |= ext1 << 7			*delay*
		ret						;// return x
s1c17_imm7_imm20_imm24_EXT2:
	sla	%r6,0x8		; 		Xsla		%r6, 20				;// %r6  := ext2 << 20
	sla	%r6,0x8
	sla	%r6,0x4
		or		%r10, %r6			;// %r10 := x |= ext2 << 20
		sll		%r10, 8				;// %r10 := x <<= 8
		ret.d						;// return x
		srl		%r10, 8				;// %r10 := x >>= 8				*delay*
		;//---------------------------------------------;//
s1c17_imm7_imm16:
		call		s1c17_imm7_imm20_imm24		;// %r10 := x = s1c17_imm7_imm20_imm24(imm7)
		ret.d						;// return x
		ld.uh		%r10, %r10			;// %r10 := (unsigned short)x			*delay*
		;//---------------------------------------------;//
s1c17_sp_imm7_sp_imm20_sp_imm24:
		call		s1c17_imm7_imm20_imm24		;// %r10 := x = s1c17_imm7_imm20_imm24(imm7)
	ext	s1c17_cpu+0x24@ah	; 		Xld.w		%r4, [s1c17_cpu+36]		;// %r4  := sp
	ext	s1c17_cpu+0x24@al
	ld.w	%r4,[%r8]
		add		%r10, %r4			;// %r10 := x += sp				!INTERLOCK!
		sll		%r10, 8				;// %r10 := x <<= 8
		ret.d						;// return x
		srl		%r10, 8				;// %r10 := x >>= 8				*delay*

	
		.code
		.align		1
		.global		s1c17_sign7_sign16
s1c17_sign7_sign16:
	ext	s1c17_cpu+0x2c@ah	; 		Xld.h		%r4, [s1c17_cpu+44]		;// %r4  := ext1
	ext	s1c17_cpu+0x2c@al
	ld.h	%r4,[%r8]
		cmp		%r4, -1				;// if(ext1 != -1)
		jrne		s1c17_sign7_sign16_EXT1		;//   goto EXT1
		ret.d						;// return x
		ld.w		%r10, %r12			;// %r10 := x = sign7		*delay*
s1c17_sign7_sign16_EXT1:
	ext	0x7f		; 		Xand		%r10, %r12, 0x7F		;// %r10 := x = sign7 & 0x7F
	and	%r10,%r12
		sla		%r4, 7				;// %r4  :=      ext1 << 7
		or		%r10, %r4			;// %r10 := x |= ext1 << 7
		ret.d						;// return x
		ld.h		%r10, %r10			;// %r10 := (short)x		*delay*

	
		.code
		.align		1
		.global		s1c17_sign11_sign24
s1c17_sign11_sign24:
	ext	s1c17_cpu+0x2c@ah	; 		Xld.h		%r4, [s1c17_cpu+44]		;// %r4  := ext1
	ext	s1c17_cpu+0x2c@al
	ld.h	%r4,[%r8]
		cmp		%r4, -1				;// if(ext1 != -1)
		jrne.d		s1c17_sign11_sign24_EXT1	;//   goto EXT1
		sla		%r12, 1				;// %r12 := x = sign10 << 1	*delay*
		ret.d						;// return x
		ld.w		%r10, %r12			;// %r10 := x			*delay*
s1c17_sign11_sign24_EXT1:
	ext	0x7ff		; 		Xand		%r10, %r12, 0x7FF		;// %r10 := x &= 0x7FF
	and	%r10,%r12
	sla	%r4,0x8		; 		Xsla		%r4, 11				;// %r4  :=      ext1 << 11
	sla	%r4,0x3
		or		%r10, %r4			;// %r10 := x |= ext1 << 11
		sla		%r10, 8				;// %r10 := x <<= 8
		ret.d						;// return x
		sra		%r10, 8				;// %r10 := x >>= 8		*delay*

	
		.code
		.align		1
		.global		s1c17_sign8_sign21_sign24
s1c17_sign8_sign21_sign24:
	ext	s1c17_cpu+0x2c@h	; 		Xld.w		%r4, s1c17_cpu+44		;// %r4  := &s1c17_cpu.ext1
	ext	s1c17_cpu+0x2c@m
	ld.w	%r4,s1c17_cpu+0x2c@l
		ld.h		%r5, [%r4]+			;// %r5  := ext1
		cmp		%r5, -1				;// if(ext1 != -1)
		jrne.d		s1c17_sign8_sign21_sign24_EXT1	;//   goto EXT1
		sla		%r12, 1				;// %r12 := x = sign7 << 1	*delay*
		ret.d						;// return x
		ld.w		%r10, %r12			;// %r10 := x			*delay*
s1c17_sign8_sign21_sign24_EXT1:
		ld.ub		%r10, %r12			;// %r10 := x = (unsigned char)x
		ld.h		%r6, [%r4]			;// %r6  := ext2
		sla		%r5, 8				;// %r5  := ext1 << 8		*anti-interlock*
		cmp		%r6, -1				;// if(ext2 != -1)
		jrne.d		s1c17_sign8_sign21_sign24_EXT2	;//   goto EXT2
		or		%r10, %r5			;// %r10 := x |= ext1 << 8	*delay*
	sla	%r10,0x8	; 		Xsla		%r10, 11			;// %r10 := x <<= 11
	sla	%r10,0x3
		sra		%r10, 8				;// %r10 := x >>= 8
		ret.d						;// return x
		sra		%r10, 3				;// %r10 := x >>= 3		*delay*
s1c17_sign8_sign21_sign24_EXT2:
	sla	%r6,0x8		; 		Xsla		%r6, 21				;// %r6  := ext2 << 21
	sla	%r6,0x8
	sla	%r6,0x5
		or		%r10, %r6			;// %r10 := x |= ext2 << 21
		sla		%r10, 8				;// %r10 := x <<= 8
		ret.d						;// return x
		sra		%r10, 8				;// %r10 := x >>= 8		*delay*

	
		.code
		.align		1
		.global		s1c17_add
		.global		s1c17_adc
		.global		s1c17_sub
		.global		s1c17_sbc
s1c17_add:
	ext	s1c17_cpu+0x20@ah	; 		Xbclr		[s1c17_cpu+32], 3		;// s1c17_cpu.psr.c = 0
	ext	s1c17_cpu+0x20@al
	bclr	[%r8],0x3
s1c17_adc:	;//---------------------------------------------;//
	ext	s1c17_cpu+0x20@h	; 		Xld.w		%r4, s1c17_cpu+32		;// %r4  := &s1c17_cpu.psr
	ext	s1c17_cpu+0x20@m
	ld.w	%r4,s1c17_cpu+0x20@l
		ld.ub		%r5, [%r4]			;// %r5  := old_psr
	ext	0xf0		; 		Xand		%r6, %r5, 0xF0			;// %r6  := old_psr &= ~CVZN
	and	%r6,%r5
		;//
	sll	%r12,0x8	; 		Xsll		%r12, 16			;// %r12[31:16] := x
	sll	%r12,0x8
	sll	%r13,0x8	; 		Xsll		%r13, 16			;// %r13[31:16] := y
	sll	%r13,0x8
	ext	0x3ff		; 		Xoor		%r13, %r13, 0xFFFF		;// %r13[15: 0] := 0xFFFF
	or	%r13,0x3f
		rr		%r5, 4				;// %r5[31]     := C
		add		%r5, %r5			;// %psr[C]     := C
		jp.d		s1c17_adc_sbc
		adc		%r12, %r13			;// %r12[31:16] := z = x + y + C	*delay*
s1c17_sub:	;//---------------------------------------------;//
	ext	s1c17_cpu+0x20@ah	; 		Xbclr		[s1c17_cpu+32], 3		;// s1c17_cpu.psr.c = 0
	ext	s1c17_cpu+0x20@al
	bclr	[%r8],0x3
s1c17_sbc:	;//---------------------------------------------;//
	ext	s1c17_cpu+0x20@h	; 		Xld.w		%r4, s1c17_cpu+32		;// %r4  := &s1c17_cpu.psr
	ext	s1c17_cpu+0x20@m
	ld.w	%r4,s1c17_cpu+0x20@l
		ld.ub		%r5, [%r4]			;// %r5  := old_psr
	ext	0xf0		; 		Xand		%r6, %r5, 0xF0			;// %r6  := old_psr &= ~CVZN
	and	%r6,%r5
		;//
	sll	%r12,0x8	; 		Xsll		%r12, 16			;// %r12[31:16] := x
	sll	%r12,0x8
	sll	%r13,0x8	; 		Xsll		%r13, 16			;// %r13[31:16] := y
	sll	%r13,0x8
		rr		%r5, 4				;// %r5[31]     := C
		add		%r5, %r5			;// %psr[C]     := C
		sbc		%r12, %r13			;// %r12[31:16] := z = x - y - C
s1c17_adc_sbc:	;//---------------------------------------------;//
		ld.w		%r5, %psr			;// %r5  := new_psr
	srl	%r12,0x8	; 		Xsrl		%r12, 16			;// %r12 := z
	srl	%r12,0x8
		jrne.d		3				;// if(!z)
		 and		%r5, 0x0D			;// %r5  := new_psr &= CV0N		*delay*
		 or		%r5, 0x02			;//   %r5  := new_psr |= 00Z0
		or		%r5, %r6			;// %r5  := new_psr |= old_psr
		ld.b		[%r4], %r5			;// s1c17_cpu.psr := new_psr
		ret.d
		ld.w		%r10, %r12			;// %r10 := z				*delay*

	
		.code
		.align		1
		.global		s1c17_add_a
		.global		s1c17_sub_a
		.global		s1c17_cmp_a
s1c17_sub_a:
		not		%r13, %r13			;// %r13 := y = -y
		add		%r13, 1
s1c17_add_a:
		add		%r12, %r13			;// %r12 := x += y
		sll		%r12, 8				;// %r12 := x <<= 8
		srl		%r12, 8				;// %r12 := x >>= 8
		ret.d
		ld.w		%r10, %r12			;// %r10 := x			*delay*
s1c17_cmp_a:
	ext	s1c17_cpu+0x20@h	; 		Xld.w		%r4, s1c17_cpu+32		;// %r4  := &s1c17_cpu.psr
	ext	s1c17_cpu+0x20@m
	ld.w	%r4,s1c17_cpu+0x20@l
		cmp		%r12, %r13			;// %psr := new_psr = x - y
		ld.w		%r5, %psr			;// %r5  := new_psr
		ld.ub		%r6, [%r4]			;// %r6  := old_psr
		and		%r5, 0x0000000A			;// %r5  := new_psr &=  C0Z0	*anti-interlock*
		and		%r6, 0xFFFFFFF5			;// %r6  := old_psr &= ~C0Z0
		or		%r5, %r6			;// %r5  := new_psr |= old_psr
		ld.b		[%r4], %r5			;// s1c17_cpu.psr := new_psr
		ret

	
		.code
		.align		1
		.global		s1c17_and
		.global		s1c17_or
		.global		s1c17_xor
		.global		s1c17_not
s1c17_and:	;//---------------------------------------------;//
		ld.h		%r12, %r12			;// %r12 := x = (short)x
		ld.h		%r13, %r13			;// %r13 := y = (short)y
		jp.d		s1c17_and_or_xor_not
		and		%r12, %r13			;// %r12 := x &= y				*delay*
s1c17_or:	;//---------------------------------------------;//
		ld.h		%r12, %r12			;// %r12 := x = (short)x
		ld.h		%r13, %r13			;// %r13 := y = (short)y
		jp.d		s1c17_and_or_xor_not
		or		%r12, %r13			;// %r12 := x |= y				*delay*
s1c17_xor:	;//---------------------------------------------;//
		ld.h		%r12, %r12			;// %r12 := x = (short)x
		ld.h		%r13, %r13			;// %r13 := y = (short)y
		jp.d		s1c17_and_or_xor_not
		xor		%r12, %r13			;// %r12 := x ^= y				*delay*
s1c17_not:	;//---------------------------------------------;//
		ld.h		%r12, %r12			;// %r12 := x = (short)x
		not		%r12, %r12			;// %r12 := x = ~x
		;//---------------------------------------------;//
s1c17_and_or_xor_not:
	ext	s1c17_cpu+0x20@h	; 		Xld.w		%r4, s1c17_cpu+32		;// %r4  :=                     &s1c17_cpu.psr
	ext	s1c17_cpu+0x20@m
	ld.w	%r4,s1c17_cpu+0x20@l
		ld.w		%r5, %psr			;// %r5  := new_psr
		ld.ub		%r6, [%r4]			;// %r6  :=            old_psr = s1c17_cpu.psr
		and		%r5, 0x0000000B			;// %r5  := new_psr &= C0ZN
		and		%r6, 0xFFFFFFF0			;// %r6  :=            old_psr &= ~CVZN
		or		%r5, %r6			;// %r5  := new_psr |= old_psr
		ld.b		[%r4], %r5			;// s1c17_cpu.psr := new_psr
		ret.d
		ld.uh		%r10, %r12			;// %r10 := (unsigned short)x			*delay*

	
		.code
		.align		1
		.global		s1c17_jpa
		.global		s1c17_jpr
		;//---------------------------------------------;//
s1c17_jpa:
		cmp		%r13, 0				;// if(!d)
		jreq.d		s1c17_jpa_NO_DELAY		;//   goto NO_DELAY
		and		%r12, 0xFFFFFFFE		;// %r12 := x &= ~1		*delay*
		;//{{DELAY
		pushn		%r0
		ld.w		%r4, -1				;// %r4  := -1
	ext	s1c17_cpu+0x2c@ah	; 		Xld.w		[s1c17_cpu+44], %r4		;// s1c17_cpu.ext1 = s1c17_cpu.ext2 = -1
	ext	s1c17_cpu+0x2c@al
	ld.w	[%r8],%r4
	ext	s1c17_cpu_exec@rm	; 		Xcall.d		s1c17_cpu_exec			;// s1c17_cpu_exec()
	call.d	s1c17_cpu_exec@rl
		ld.w		%r0, %r12			;// %r0  := x			*delay*
		ld.w		%r12, %r0			;// %r12 := x
		popn		%r0
		;//}}DELAY
s1c17_jpa_NO_DELAY:
	ext	s1c17_cpu+0x28@ah	; 		Xld.w		[s1c17_cpu+40], %r12		;// s1c17_cpu.pc := x
	ext	s1c17_cpu+0x28@al
	ld.w	[%r8],%r12
		ret
		;//---------------------------------------------;//
s1c17_jpr:
	ext	s1c17_cpu+0x28@ah	; 		Xld.w		%r4, [s1c17_cpu+40]		;// %r4  := s1c17_cpu.pc
	ext	s1c17_cpu+0x28@al
	ld.w	%r4,[%r8]
		add		%r12, %r4			;// %r12 := x += s1c17_cpu.pc	!INTERLOCK!
		sll		%r12, 8				;// %r12 := x <<= 8
		jp.d		s1c17_jpa			;// s1c17_jpa(x, d)
		srl		%r12, 8				;// %r12 := x >>= 8		*delay*

	
		.code
		.align		1
		.global		s1c17_calla
		.global		s1c17_call
		;//---------------------------------------------;//
s1c17_calla:
		pushn		%r1
	ext	s1c17_cpu+0x24@h	; 		Xld.w		%r0, s1c17_cpu+36		;// %r0  := &s1c17_cpu.sp
	ext	s1c17_cpu+0x24@m
	ld.w	%r0,s1c17_cpu+0x24@l
		ld.w		%r4, [%r0]			;// %r4  := sp
		ld.w		%r1, %r12			;// %r1  := x			*anti-interlock*
		sub		%r4, 4				;// %r4  := sp -= 4
		ld.w		[%r0], %r4			;// s1c17_cpu.sp := sp
		cmp		%r13, 0				;// if(!d)
		jreq.d		s1c17_calla_NO_DELAY		;//   goto NO_DELAY
		and		%r1, 0xFFFFFFFE			;// %r1  := x &= ~1		*delay*
		;//{{DELAY
		ld.w		%r4, -1				;// %r4  := -1
	ext	0x8		; 		Xld.w		[%r0+8], %r4			;// s1c17_cpu.ext1 = s1c17_cpu.ext2 = -1
	ld.w	[%r0],%r4
	ext	s1c17_cpu_exec@rm	; 		Xcall		s1c17_cpu_exec			;// s1c17_cpu_exec()
	call	s1c17_cpu_exec@rl
		;//}}DELAY
s1c17_calla_NO_DELAY:
		ld.w		%r13, [%r0]+			;// %r13 := sp
		ld.w		%r14, [%r0]			;// %r14 := pc
		ld.w		[%r0], %r1			;// s1c17_cpu.pc := x
		popn		%r1
	ext	s1c17_bcu_write@rm	; 		Xjp.d		s1c17_bcu_write			;// s1c17_bcu_write(4, sp, pc)
	jp.d	s1c17_bcu_write@rl
		ld.w		%r12, 4				;// %r12 := 4			*delay*
		;//---------------------------------------------;//
s1c17_call:
	ext	s1c17_cpu+0x28@ah	; 		Xld.w		%r4, [s1c17_cpu+40]		;// %r4  := s1c17_cpu.pc
	ext	s1c17_cpu+0x28@al
	ld.w	%r4,[%r8]
		add		%r12, %r4			;// %r12 := x += s1c17_cpu.pc	!INTERLOCK!
		sll		%r12, 8				;// %r12 := x <<= 8
		jp.d		s1c17_calla			;// s1c17_calla(x, d)
		srl		%r12, 8				;// %r12 := x >>= 8		*delay*

; NO_APP
	.code
	.align	1
	.global	s1c17_int
s1c17_int:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r1,%r12
	ext	s1c17_cpu+0x24@h	; 	xld.w	%r0,s1c17_cpu+36
	ext	s1c17_cpu+0x24@m
	ld.w	%r0,s1c17_cpu+0x24@l
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	sub	%r13,0x4	; 	xsub	%r13,%r13,4
	ld.w	[%r0],%r13	; 	xld.w	[%r0],%r13
	ext	0x4		; 	xadd	%r2,%r0,4
	add	%r2,%r0
	sub	%r0,0x4		; 	xsub	%r0,%r0,4
	ld.ub	%r10,[%r0]	; 	xld.ub	%r10,[%r0]
	sll	%r10,0x8	; 	xsll	%r10,24
	sll	%r10,0x8
	sll	%r10,0x8
	ld.w	%r14,[%r2]	; 	xld.w	%r14,[%r2]
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	or	%r14,%r10
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	0x1f		; 	xld.w	%r13,0x00ffff80		; 16777088
	ext	0x1ffe
	ld.w	%r13,0x0
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	sll	%r1,0x2		; 	xsll	%r1,2
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r10
	add	%r13,%r1
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00fffffe
	ext	0x1fff
	and	%r10,0x3e
	ld.w	[%r2],%r10	; 	xld.w	[%r2],%r10
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x2f	; 	xand	%r10,%r10,0xffffffef
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r2
	ret
	.align	1
	.global	s1c17_sr
s1c17_sr:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	cmp	%r13,0x3	; 	xcmp	%r13,3
	jrle	__LX72		; 	xjrle	__L72
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	cmp	%r13,0x7	; 	xcmp	%r13,7
	jrgt	__LX73		; 	xjrgt	__L73
	ld.w	%r14,0x4	; 	xld.w	%r14,0x00000004		; 4
	jp	__LX73		; 	xjp	__L73
__LX72:				; __L72:
	ld.w	%r14,%r13
__LX73:				; __L73:
	ld.w	%r11,%r12
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r15,s1c17_cpu+32
	ext	s1c17_cpu+0x20@m
	ld.w	%r15,s1c17_cpu+0x20@l
	sll	%r11,0x3	; 	xsll	%r11,3
	ld.w	%r10,[%r15]	; 	xld.w	%r10,[%r15]
	ld.w	%r13,%r10
	and	%r13,0x37	; 	xand	%r13,%r13,0xfffffff7
	or	%r13,%r11
	ld.w	[%r15],%r13	; 	xld.w	[%r15],%r13
	ld.uh	%r12,%r12
	ld.w	%r9,%r14	; 	xsra	%r12,%r14
	and	%r9,0x1f
	cmp	%r9,0x8
	jrle	4
	sra	%r12,0x8
	jp.d	-3
	sub	%r9,0x8
	sra	%r12,%r9
	ld.w	%r10,0x0
	cmp	%r12,0x0
	jrne	__LX76		; 	xjrne	__L76
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
__LX76:				; __L76:
	sll	%r10,0x1	; 	xsll	%r10,1
	ld.w	%r11,%r13
	and	%r11,0x3d	; 	xand	%r11,%r11,0xfffffffd
	or	%r11,%r10
	ld.w	%r10,%r12
	srl	%r10,0x8	; 	xsrl	%r10,15
	srl	%r10,0x7
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	and	%r11,0x3e	; 	xand	%r11,%r11,0xfffffffe
	or	%r11,%r10
	ld.w	[%r15],%r11	; 	xld.w	[%r15],%r11
	ld.w	%r10,%r12
	ret
	.align	1
	.global	s1c17_sa
s1c17_sa:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	cmp	%r13,0x3	; 	xcmp	%r13,3
	jrle	__LX78		; 	xjrle	__L78
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	cmp	%r13,0x7	; 	xcmp	%r13,7
	jrgt	__LX79		; 	xjrgt	__L79
	ld.w	%r14,0x4	; 	xld.w	%r14,0x00000004		; 4
	jp	__LX79		; 	xjp	__L79
__LX78:				; __L78:
	ld.w	%r14,%r13
__LX79:				; __L79:
	ld.w	%r11,%r12
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r15,s1c17_cpu+32
	ext	s1c17_cpu+0x20@m
	ld.w	%r15,s1c17_cpu+0x20@l
	sll	%r11,0x3	; 	xsll	%r11,3
	ld.w	%r10,[%r15]	; 	xld.w	%r10,[%r15]
	ld.w	%r13,%r10
	and	%r13,0x37	; 	xand	%r13,%r13,0xfffffff7
	or	%r13,%r11
	ld.w	[%r15],%r13	; 	xld.w	[%r15],%r13
	ld.h	%r12,%r12
	ld.w	%r9,%r14	; 	xsra	%r12,%r14
	and	%r9,0x1f
	cmp	%r9,0x8
	jrle	4
	sra	%r12,0x8
	jp.d	-3
	sub	%r9,0x8
	sra	%r12,%r9
	ld.uh	%r12,%r12
	ld.w	%r10,0x0
	cmp	%r12,0x0
	jrne	__LX82		; 	xjrne	__L82
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
__LX82:				; __L82:
	sll	%r10,0x1	; 	xsll	%r10,1
	ld.w	%r11,%r13
	and	%r11,0x3d	; 	xand	%r11,%r11,0xfffffffd
	or	%r11,%r10
	ld.w	%r10,%r12
	srl	%r10,0x8	; 	xsrl	%r10,15
	srl	%r10,0x7
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	and	%r11,0x3e	; 	xand	%r11,%r11,0xfffffffe
	or	%r11,%r10
	ld.w	[%r15],%r11	; 	xld.w	[%r15],%r11
	ld.w	%r10,%r12
	ret
	.align	1
	.global	s1c17_sl
s1c17_sl:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	cmp	%r13,0x3	; 	xcmp	%r13,3
	jrle	__LX84		; 	xjrle	__L84
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	cmp	%r13,0x7	; 	xcmp	%r13,7
	jrgt	__LX85		; 	xjrgt	__L85
	ld.w	%r14,0x4	; 	xld.w	%r14,0x00000004		; 4
	jp	__LX85		; 	xjp	__L85
__LX84:				; __L84:
	ld.w	%r14,%r13
__LX85:				; __L85:
	ld.w	%r11,%r12
	srl	%r11,0x8	; 	xsrl	%r11,12
	srl	%r11,0x4
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r15,s1c17_cpu+32
	ext	s1c17_cpu+0x20@m
	ld.w	%r15,s1c17_cpu+0x20@l
	and	%r11,0x8	; 	xand	%r11,%r11,0x00000008
	ld.w	%r10,[%r15]	; 	xld.w	%r10,[%r15]
	ld.w	%r13,%r10
	and	%r13,0x37	; 	xand	%r13,%r13,0xfffffff7
	or	%r13,%r11
	ld.w	[%r15],%r13	; 	xld.w	[%r15],%r13
	ld.w	%r9,%r14	; 	xsll	%r12,%r14
	and	%r9,0x1f
	cmp	%r9,0x8
	jrle	4
	sll	%r12,0x8
	jp.d	-3
	sub	%r9,0x8
	sll	%r12,%r9
	ld.uh	%r12,%r12
	ld.w	%r10,0x0
	cmp	%r12,0x0
	jrne	__LX88		; 	xjrne	__L88
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
__LX88:				; __L88:
	sll	%r10,0x1	; 	xsll	%r10,1
	ld.w	%r11,%r13
	and	%r11,0x3d	; 	xand	%r11,%r11,0xfffffffd
	or	%r11,%r10
	ld.w	%r10,%r12
	srl	%r10,0x8	; 	xsrl	%r10,15
	srl	%r10,0x7
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	and	%r11,0x3e	; 	xand	%r11,%r11,0xfffffffe
	or	%r11,%r10
	ld.w	[%r15],%r11	; 	xld.w	[%r15],%r11
	ld.w	%r10,%r12
	ret
; APP
	
		.code
		.align		1
		.global		s1c17_bcu_read
s1c17_bcu_read:
		pushn		%r2
		ld.w		%r0, %r12			;// %r0  := size
	ext	s1c17_device_select@rm	; 		Xcall.d		s1c17_device_select		;// %r10 := device = s1c17_device_select(size, addr)
	call.d	s1c17_device_select@rl
		ld.w		%r1, %r13			;// %r1  := addr					*delay*
		;//
		ld.w		%r4, [%r10]			;// %r4  := device->top
	ext	0x8		; 		Xld.w		%r5, [%r10+8]			;// %r5  := device->size
	ld.w	%r5,[%r10]
	ext	0xc		; 		Xld.w		%r2, [%r10+12]			;// %r2  := device->read
	ld.w	%r2,[%r10]
		;//
		cmp		%r0, %r5			;// if(size > device->size)
		jrgt.d		s1c17_bcu_read_SPLIT		;//   goto SPLIT
		sub		%r1, %r4			;// %r1  := ofs = addr - device->top			*delay*
		;//
		ld.w		%r12, %r0			;// %r12 := size
		call.d		%r2				;// %r10 := data = device->read(size, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
s1c17_bcu_read_RET:
		popn		%r2
		ret						;// return data
		;//---------------------------------------------;//
s1c17_bcu_read_SPLIT:
		cmp		%r5, 1				;// if(device->size != 1)
		jrne		s1c17_bcu_read_SPLIT_2_4	;//   goto SPLIT_2_4
		cmp		%r0, 2				;// if(size != 2)
		jrne		s1c17_bcu_read_SPLIT_1_4	;//   goto SPLIT_1_4
		;//---------------------------------------------;//
		;// foCXTCY = 8rbg, CPUANZXTCY = 16rbg
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		ld.w		%r0, %r10			;// %r0  := data = device->read(1, ofs)
		add		%r1, 1				;// %r1  := ofs += 1
		;//
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		sla		%r10, 8				;// %r10 := device->read(1, ofs) << 8
		jp.d		s1c17_bcu_read_RET		;// return data
		or		%r10, %r0			;// %r10 := data |= device->read(1, ofs) << 8		*delay*
		;//---------------------------------------------;//
s1c17_bcu_read_SPLIT_1_4:
		;// foCXTCY = 8rbg, CPUANZXTCY = 32rbg
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		ld.w		%r0, %r10			;// %r0  := data = device->read(1, ofs)
		add		%r1, 1				;// %r1  := ofs += 1
		;//
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		sla		%r10, 8				;// %r10 := device->read(1, ofs) << 8
		or		%r0, %r10			;// %r0  := data |= device->read(1, ofs) << 8
		add		%r1, 1				;// %r1  := ofs += 1
		;//
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
	sla	%r10,0x8	; 		Xsla		%r10, 16			;// %r10 := device->read(1, ofs) << 16
	sla	%r10,0x8
		or		%r0, %r10			;// %r0  := data |= device->read(1, ofs) << 16
		add		%r1, 1				;// %r1  := ofs += 1
		;//
		ld.w		%r12, 1				;// %r12 := 1
		call.d		%r2				;// %r10 := device->read(1, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
	sla	%r10,0x8	; 		Xsla		%r10, 24			;// %r10 := device->read(1, ofs) << 24
	sla	%r10,0x8
	sla	%r10,0x8
		jp.d		s1c17_bcu_read_RET		;// return data
		or		%r10, %r0			;// %r10 := data |= device->read(1, ofs) << 24		*delay*
		;//---------------------------------------------;//
s1c17_bcu_read_SPLIT_2_4:
		;// foCXTCY = 16rbg, CPUANZXTCY = 32rbg
		ld.w		%r12, 2				;// %r12 := 2
		call.d		%r2				;// %r10 := device->read(2, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
		ld.w		%r0, %r10			;// %r0  := data = device->read(2, ofs)
		add		%r1, 2				;// %r1  := ofs += 2
		;//
		ld.w		%r12, 2				;// %r12 := 2
		call.d		%r2				;// %r10 := device->read(2, ofs)
		ld.w		%r13, %r1			;// %r13 := ofs						*delay*
		;//
	sla	%r10,0x8	; 		Xsla		%r10, 16			;// %r10 := device->read(2, ofs) << 16
	sla	%r10,0x8
		jp.d		s1c17_bcu_read_RET		;// return data
		or		%r10, %r0			;// %r10 := data |= device->read(2, ofs) << 16		*delay*

	
		.code
		.align		1
		.global		s1c17_bcu_write
s1c17_bcu_write:
		pushn		%r3
		ld.w		%r0, %r12			;// %r0  := size
		ld.w		%r1, %r13			;// %r1  := addr
	call.d	s1c17_device_select	; 		Xcall.d		s1c17_device_select		;// %r10 := device = s1c17_device_select(size, addr)
		ld.w		%r2, %r14			;// %r2  := data					*delay*
		;//
		ld.w		%r4, [%r10]			;// %r4  := device->top
	ext	0x8		; 		Xld.w		%r5, [%r10+8]			;// %r5  := device->size
	ld.w	%r5,[%r10]
	ext	0x10		; 		Xld.w		%r3, [%r10+16]			;// %r3  := device->write
	ld.w	%r3,[%r10]
		;//
		cmp		%r0, %r5			;// if(size > device->size)
		jrgt.d		s1c17_bcu_write_SPLIT		;//   goto SPLIT
		sub		%r1, %r4			;// %r1  := ofs = addr - device->top			*delay*
		;//
		ld.w		%r12, %r0			;// %r12 := size
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(size, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
s1c17_bcu_write_RET:
		popn		%r3
		ret
		;//---------------------------------------------;//
s1c17_bcu_write_SPLIT:
		cmp		%r5, 1				;// if(device->size != 1)
		jrne		s1c17_bcu_write_SPLIT_2_4	;//   goto SPLIT_2_4
		cmp		%r0, 2				;// if(size != 2)
		jrne		s1c17_bcu_write_SPLIT_1_4	;//   goto SPLIT_1_4
		;//---------------------------------------------;//
		;// foCXTCY = 8rbg, CPUANZXTCY = 16rbg
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		add		%r1, 1				;// %r1  := ofs += 1
		sra		%r2, 8				;// %r2  := data >>= 8
		;//
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		jp		s1c17_bcu_write_RET
		;//---------------------------------------------;//
s1c17_bcu_write_SPLIT_1_4:
		;// foCXTCY = 8rbg, CPUANZXTCY = 32rbg
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		add		%r1, 1				;// %r1  := ofs += 1
		sra		%r2, 8				;// %r2  := data >>= 8
		;//
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		add		%r1, 1				;// %r1  := ofs += 1
		sra		%r2, 8				;// %r2  := data >>= 8
		;//
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		add		%r1, 1				;// %r1  := ofs += 1
		sra		%r2, 8				;// %r2  := data >>= 8
		;//
		ld.w		%r12, 1				;// %r12 := 1
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(1, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		jp		s1c17_bcu_write_RET
		;//---------------------------------------------;//
s1c17_bcu_write_SPLIT_2_4:
		;// foCXTCY = 16rbg, CPUANZXTCY = 32rbg
		ld.w		%r12, 2				;// %r12 := 2
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(2, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		add		%r1, 2				;// %r1  := ofs += 2
	sra	%r2,0x8		; 		Xsra		%r2, 16				;// %r2  := data >>= 16
	sra	%r2,0x8
		;//
		ld.w		%r12, 2				;// %r12 := 2
		ld.w		%r13, %r1			;// %r13 := ofs
		call.d		%r3				;// device->write(2, ofs, data)
		ld.w		%r14, %r2			;// %r14 := data					*delay*
		;//
		jp		s1c17_bcu_write_RET

	
		.code
		.align		1
		.global		s1c17_device_select
s1c17_device_select:
		;// GAւ̃ANZXAꍇ̂ŁALRU̐擪GgƂ̔rœK܂B
		;// LRU̐擪GgŃqbgꍇ́ALRU̓ւsKv܂B
		;// %r12 := size -> gȂ
		;// %r13 := addr
	ext	s1c17_device_root+0x0@h	; 		Xld.w		%r4, s1c17_device_root		;// %r4  := &s1c17_device_root
	ext	s1c17_device_root+0x0@m
	ld.w	%r4,s1c17_device_root+0x0@l
		ld.w		%r10, [%r4]			;// %r10 := device = s1c17_device_root
		ld.w		%r5, [%r10]			;// %r5  := device->top
	ext	0x4		; 		Xld.w		%r6, [%r10+4]			;// %r6  := device->end
	ld.w	%r6,[%r10]
		cmp		%r13, %r5			;// if(addr < device->top)
		jrlt		s1c17_device_select_SEARCH	;//   goto SEARCH
		cmp		%r13, %r6			;// if(addr > device->end)
		jrgt		s1c17_device_select_SEARCH	;//   goto SEARCH
		ret						;// 
		;//---------------------------------------------;//
s1c17_device_select_SEARCH:
		;// ȍ~́ALRU̐擪GgƂ̔r~Xꍇ́Aʏ̌łB
		;// %r4  := &s1c17_device_root
		;// %r13 := addr
		add		%r10, 20			;// %r10 := next = &device->next
s1c17_device_select_LOOP:
		;// %r4  := &s1c17_device_root
		;// %r10 := next
		;// %r13 := addr
		ld.w		%r7, %r10			;// %r7  := next
		ld.w		%r10, [%r7]			;// %r10 := device = *next
		cmp		%r10, 0				;// if(!device)							!INTERLOCK!
		jreq		s1c17_device_select_DUMMY	;//   return &s1c17_device_dummy
		;// %r4  := &s1c17_device_root
		;// %r7  := next
		;// %r10 := device
		;// %r13 := addr
		ld.w		%r5, [%r10]+			;// %r5  := device->top
		ld.w		%r6, [%r10]			;// %r6  := device->end
;//		add		%r10, 16			;// %r10 := &device->next ------------------------------+
		;// %r4  := &s1c17_device_root										|
		;// %r5  := device->top											|
		;// %r6  := device->end											|
		;// %r7  := next											|
		;// %r10 := &device->next										|
		;// %r13 := addr											|
		cmp		%r13, %r5			;// if(addr < device->top)				|
		jrlt.d		s1c17_device_select_LOOP	;//   { %r10 := next = &device->next; goto LOOP; }	|
		add		%r10, 16			;// %r10 := &device->next <-----------------------------+	*delay*
		cmp		%r13, %r6			;// if(addr > device->end)
		jrgt		s1c17_device_select_LOOP	;//   { %r10 := next = &device->next; goto LOOP; }
		;//{{LRU
		;// LRUւ́AdeviceLRU̐擪GgłȂ(next!=&s1c17_device_root)ƂOƂłB
		ld.w		%r5, [%r10]			;// %r5  := device->next
		ld.w		%r6, [%r4]			;// %r6  := s1c17_device_root					*anti-interlock*
		ld.w		[%r7], %r5			;// *next = device->next					*anti-interlock*
		ld.w		[%r10], %r6			;// device->next = s1c17_device_root
		sub		%r10, 20			;// %r10 := device
		ld.w		[%r4], %r10			;// s1c17_device_root = device
		;//}}LRU
		ret						;// return device
		;//---------------------------------------------;//
s1c17_device_select_DUMMY:
	ext	s1c17_device_dummy+0x0@h	; 		Xld.w		%r10, s1c17_device_dummy	;// return &s1c17_device_dummy
	ext	s1c17_device_dummy+0x0@m
	ld.w	%r10,s1c17_device_dummy+0x0@l
		ret


