/*	
 *	cliptime.c
 *
 *	S1C33 Family CRpCpbP[W̎֐u܂B
 *	S1C33 Family CRpCpbP[W̎֐͂قƂǃ_~[łB
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2011 Naoyuki Sawa
 *
 *	* Tue May 11 21:10:00 JST 2004 Naoyuki Sawa
 *	- 1st[XB
 *	* Wed Feb 22 00:00:00 JST 2006 Naoyuki Sawa
 *	- include/time.hɂANSI`̊֐錾ŝŁÃW[łANSI`֐錾͕svƂȂ܂B
 *	* Wed Jan 05 01:40:25 JST 2011 Naoyuki Sawa
 *	- clock()̎ǉAсAstrftime()̃_~[ǉ܂B
 *	  L̒ǉŔAuLua 5.1.4vRpC邽߂ɁAKvɂȂ߂łB
 *	- ǉstrftime()́AJʂ߂̃_~[łAۂɌĂяoꂽꍇG[I܂B
 *	  A{strftime()̏KvɂȂۂɁA\łB
 *	* Tue Jan 11 02:21:51 JST 2011 Naoyuki Sawa
 *	- strftime()܂B
 *	- asctime()̎Astrftime()𗘗p悤ɕύX܂B
 */
#include "clip.h"

/*****************************************************************************
 *	
 *****************************************************************************/

/*{{2006/02/22 include/time.hɂANSI`̊֐錾ŝŁÃW[łANSI`֐錾͕svƂȂ܂B*/
//clock_t clock() { DIE(); }                     // ĂяovZXgCPUԂԂ܂BP/ECEł͈ӖȂ̂ŖłB{{2011/01/05 ܂}}
//time_t time(time_t* timer);                    // GMT1970/1/1 00:00:00̌oߕbԂ܂B
//time_t mktime(struct tm* timeptr);             // tm\̂GMT1970/1/1 00:00:00̌oߕbɕϊ܂BGMT<=>JSTϊ͍s܂B
//struct tm* gmtime(const time_t* timer);        // GMT1970/1/1 00:00:00̌oߕbtm\̂ɕϊ܂BGMT<=>JSTϊ͍s܂B
//struct tm* localtime(const time_t* timer);     // GMT1970/1/1 00:00:00̌oߕbJSTɕϊAtm\̂ɕϊ܂B
//char* asctime(const struct tm* timeptr);       // tm\̂𕶎ɕϊAsR[ht܂BGMT<=>JSTϊ͍s܂B
//char* ctime(const time_t* timer);              // GMT1970/1/1 00:00:00̌oߕbJSTɕϊAɕɕϊ܂B
//double difftime(time_t timer1, time_t timer0); // ̎Ԃ̍bPʂŕԂ܂B
/*}}2006/02/22 include/time.hɂANSI`̊֐錾ŝŁÃW[łANSI`֐錾͕svƂȂ܂B*/

/*****************************************************************************
 *	
 *****************************************************************************/

#define TZ_BIAS (9 * 60 * 60)	/* OjbWW(GMT)ƖΕW(JST)̎ԍ[] JST=GMT+TZ_BIAS */

static const short mtbl[2/*0:ʏ/1:邤N*/][12] = {{
	/*1/1` 1/1*/0,
	/*1/1` 2/1*/31,
	/*1/1` 3/1*/31+28,
	/*1/1` 4/1*/31+28+31,
	/*1/1` 5/1*/31+28+31+30,
	/*1/1` 6/1*/31+28+31+30+31,
	/*1/1` 7/1*/31+28+31+30+31+30,
	/*1/1` 8/1*/31+28+31+30+31+30+31,
	/*1/1` 9/1*/31+28+31+30+31+30+31+31,
	/*1/1`10/1*/31+28+31+30+31+30+31+31+30,
	/*1/1`11/1*/31+28+31+30+31+30+31+31+30+31,
	/*1/1`12/1*/31+28+31+30+31+30+31+31+30+31+30,
},{
	/*1/1` 1/1*/0,
	/*1/1` 2/1*/31,
	/*1/1` 3/1*/31+29,
	/*1/1` 4/1*/31+29+31,
	/*1/1` 5/1*/31+29+31+30,
	/*1/1` 6/1*/31+29+31+30+31,
	/*1/1` 7/1*/31+29+31+30+31+30,
	/*1/1` 8/1*/31+29+31+30+31+30+31,
	/*1/1` 9/1*/31+29+31+30+31+30+31+31,
	/*1/1`10/1*/31+29+31+30+31+30+31+31+30,
	/*1/1`11/1*/31+29+31+30+31+30+31+31+30+31,
	/*1/1`12/1*/31+29+31+30+31+30+31+31+30+31+30,
}};

static const char* const wday_table[7] = { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" };
static const char* const mon_table[12] = { "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" };

static void
tm_test(const struct tm* timeptr)
{
	if(timeptr->tm_year < 1970 - 1900 || timeptr->tm_year > 2038 - 1900) DIE(); /* 1970`2038NAi[l70`138 */
	if(timeptr->tm_mon  <    1 -    1 || timeptr->tm_mon  >   12 -    1) DIE(); /*    1`  12Ai[l 0` 11 */
	if(timeptr->tm_mday <    1        || timeptr->tm_mday >   31       ) DIE(); /*    1`  31Ai[l 1` 31 */
	if(timeptr->tm_hour <    0        || timeptr->tm_hour >   23       ) DIE(); /*    0`  23Ai[l 0` 23 */
	if(timeptr->tm_min  <    0        || timeptr->tm_min  >   59       ) DIE(); /*    0`  59Ai[l 0` 59 */
	if(timeptr->tm_sec  <    0        || timeptr->tm_sec  >   59       ) DIE(); /*    0`  59bAi[l 0` 59 */
}

/* T̒ʂԍ𐔂܂B
 * - N̍ŏ̓j(܂͌j)n܂TA1TƐ܂B
 *   N̂ȑO̓́A0TƌȂ܂B
 * - 11j(܂͌j)̏ꍇA̔Nɂ͑0TL܂B
 *   ςƈقȂ܂Astrftime()%U(%W)̎dlłB
 */
static int
tm_wnum(const struct tm* timeptr, int wstart/*T̍ŏ̗j:0=j,1=j*/)
{
	/* T̒ʂԍA0TƂĂ܂B */
	int wnum = 0;

	/* ̗jƒʎZ擾܂B */
	int wday = timeptr->tm_wday;
	int yday = timeptr->tm_yday;
	if((unsigned)wday >   6) DIE(); /* sȗj */
	if((unsigned)yday > 365) DIE(); /* sȒʎZ */

	/* N̊eʎZɂČJԂc */
	do {
		/* T̍ŏ̗jc */
		if(wday == wstart) {
			/* T̒ʂԍ𑝂₵܂B */
			wnum++;
		}
		/* O̗jֈړ܂B */
		if(--wday < 0) {
			wday += 7;
		}
	/* ʎZ炵AONɂȂ甲܂B */
	} while(--yday >= 0);

	return wnum;
}

/*****************************************************************************
 *	
 *****************************************************************************/

clock_t
clock()
{
	/* * Wed Jan 05 01:34:52 JST 2011 Naoyuki Sawa
	 * - ʓIɂ́Aclock()́AĂяovZXgCPUԂvZ܂B
	 *   ̂߂ɂ́A݂P/ECEAvP[VNLĂKv܂B
	 *   ݂CLiPCuɂ́AP/ECEAvP[VNLĂϐL܂B
	 *   {֐̂߂ɁAP/ECEAvP[VNLϐǉ̂A璷łB
	 * - ׂĂ݂ƁAclock()͕KAAvP[VN̎ԂԂȂĂǂ悤łB
	 *   Linux Programmer's Manual (3) - CLOCK p
	 *   (http://archive.linux.or.jp/JM/html/LDP_man-pages/man3/clock.3.html)
	 *   C̕WKił̓vO̊Jn̎_ł͂ǂȒlԂĂĂ܂ȂB
	 *   ڐAőmۂ邽߂ɂ́AvO̊Jnclock()ĂяoĂ̒lƁB
	 *   ŁA{́A1msPʂ̓JEglACLOCKS_PER_SECPʂɕϊĕԂƂɂ܂B
	 * - L̃y[Wɂ́Aȉ̂悤Ȑ܂B
	 *   gpvZbTԂȂꍇA̒l\łȂꍇÅ֐(clock_t)-1ԂB
	 *   (clock_t)-1łǂƎv܂AӖ̂lԂ֗ƍlAOq̂悤Ɏ܂B
	 */
	return pceTimerGetCount() * 1000;
}

time_t
time(time_t* timer)
{
	PCETIME ptime;
	struct tm tm;
	time_t t;

	/* VXe(JST)擾܂B */
	pceTimeGet(&ptime);

	/* 1970/1/1 00:00:00̌oߕb擾܂B */
	memset(&tm, 0, sizeof tm);
	tm.tm_year = ptime.yy - 1900;
	tm.tm_mon  = ptime.mm -    1;
	tm.tm_mday = ptime.dd;
	tm.tm_hour = ptime.hh;
	tm.tm_min  = ptime.mi;
	tm.tm_sec  = ptime.ss;
	t = mktime(&tm);
	if(t < 0) return t; /* G[ */

	/* JSTGMTɕϊ܂B */
	t -= TZ_BIAS;

	/* KvɉČʂi[܂B */
	if(timer) *timer = t;

	return t;
}

time_t
mktime(struct tm* timeptr)
{
	int days;
	time_t t;

	/* ܂B */
	tm_test(timeptr);

	/* 1970/1/1year/mon/mday܂ł̓B */
	days  = (timeptr->tm_year - 70) * 365;			/* 1970/1/1year/1/1܂ł̓ (b) */
	days += (timeptr->tm_year - 1) / 4;			/* 1900/1/1year/1/1܂ł̂邤N (b) 1901`2099N̊Oł͊ԈʂɂȂ܂ */
	days -= 17;						/* 1900/1/11970/1/1܂ł̂邤N {1904,08,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68} */
	days += mtbl[!(timeptr->tm_year % 4)][timeptr->tm_mon];	/* year/1/1year/mon/1܂ł̓ 1901`2099N̊Oł͊ԈʂɂȂ܂ */
	days += timeptr->tm_mday - 1;				/* year/mon/1year/mon/mday܂ł̓ */

	/* 1970/1/1year/mon/mday hour:min:sec܂ł̕bB */
	t  = (((days * 24) + timeptr->tm_hour) * 60 + timeptr->tm_min) * 60 + timeptr->tm_sec;

	return t;
}

struct tm*
gmtime(const time_t* timer)
{
	static struct tm tm;
	//
	time_t t;
	int leap;
	int days;

	/* ܂NAB */
	memset(&tm, 0, sizeof tm);

	/* AAb߂܂B */
	t = *timer;		/* t = 1970/1/1̌oߕb */
	tm.tm_sec  = t % 60;	/* bm */
	t /= 60;		/* t = 1970/1/1̌oߕ */
	tm.tm_min  = t % 60;	/* m */
	t /= 60;		/* t = 1970/1/1̌oߎ */
	tm.tm_hour = t % 24;	/* m */
	t /= 24;		/* t = 1970/1/1̌oߓ */

	/* NAAAjAŇoߓ߂܂B */
	tm.tm_wday = (t + 4/*1970/1/1͖ؗj*/) % 7;
	for(tm.tm_year = 1970 - 1900; tm.tm_year < 2038 - 1900; tm.tm_year++) {
		leap = !(tm.tm_year % 4); /* 邤N 1901`2099N̊Oł͊ԈʂɂȂ܂ */
		days = 365 + leap;
		if(t < days) break;
		t -= days;
	}
	tm.tm_yday = t; /* year/1/1̌oߓ */
	for(tm.tm_mon = 1 - 1; tm.tm_mon < 12 - 1; tm.tm_mon++) {
		if(t < mtbl[leap][tm.tm_mon + 1]) break;
	}
	t -= mtbl[leap][tm.tm_mon];
	tm.tm_mday = t + 1;

	return &tm;
}

struct tm*
localtime(const time_t* timer)
{
	time_t t = *timer + TZ_BIAS; /* GMTJSTɕϊ܂ */
	return gmtime(&t);
}

char*
asctime(const struct tm* timeptr)
{
	/*  000000000011111111112222QQ  */
	/*  012345678901234567890123ST  */
	/* "Wed Jan 02 02:03:55 1980\n\0" */
	static char buf[26];

	/* ܂B */
	tm_test(timeptr);

	/* 𕶎ɕϊ܂B */
	strftime(buf, sizeof buf, "%a %b %d %X %Y\n", timeptr);

	return buf;
}

char*
ctime(const time_t* timer)
{
	return asctime(localtime(timer));
}

double
difftime(time_t timer1, time_t timer0)
{
	return timer1 - timer0;
}

size_t
strftime(char* string, size_t maxsize, const char* format, const struct tm* timeptr)
{
	char* string0 = string;
	int f;
	int n;

	/* ܂B */
	tm_test(timeptr);

	/* format󕶎񂾂ꍇ̂߂ɁAo͕̐擪ɏI[nulłB
	 * format󕶎łȂ΁Aȍ~́Asnprintf()I[nulłB
	 */
	if(maxsize) *string = '\0';

	while((f = *format++) != '\0') {
		if(f == '%') {
			switch(f = *format++) {
			case 'a': /* j̏ȗ */
				n = snprintf(string, maxsize, "%.3s", wday_table[timeptr->tm_wday]);
				break;
			case 'A': /* j̐ */
				n = snprintf(string, maxsize, "%s", wday_table[timeptr->tm_wday]);
				break;
			case 'b': /* ̏ȗ */
				n = snprintf(string, maxsize, "%.3s", mon_table[timeptr->tm_mon]);
				break;
			case 'B': /* ̐ */
				n = snprintf(string, maxsize, "%s", mon_table[timeptr->tm_mon]);
				break;
			case 'c': /* P[ɉtƎԂ̕\ */
				if(!(n = strftime(string, maxsize, "%x %X", timeptr))) n = -1;
				break;
			case 'd': /* 10iŕ\̓t(01`31) */
				n = snprintf(string, maxsize, "%02d", timeptr->tm_mday);
				break;
			case 'H': /* 24ԕ\L̎(00`23) */
				n = snprintf(string, maxsize, "%02d", timeptr->tm_hour);
				break;
			case 'I': /* 12ԕ\L̎(01`12) */
				n = snprintf(string, maxsize, "%02d", (timeptr->tm_hour + 11) % 12 + 1);
				break;
			case 'j': /* 10iŕ\N̓(001`366) */
				n = snprintf(string, maxsize, "%03d", timeptr->tm_yday + 1);
				break;
			case 'm': /* 10iŕ\(01`12) */
				n = snprintf(string, maxsize, "%02d", timeptr->tm_mon + 1);
				break;
			case 'M': /* 10iŕ\(00`59) */
				n = snprintf(string, maxsize, "%02d", timeptr->tm_min);
				break;
			case 'p': /* ݂̃P[AM/PM */
				n = snprintf(string, maxsize, "%s", (timeptr->tm_hour < 12) ? "AM" : "PM");
				break;
			case 'S': /* 10iŕ\b(00`59) */
				n = snprintf(string, maxsize, "%02d", timeptr->tm_sec);
				break;
			case 'U': /* 10iŕ\T̒ʂԍBjT̍ŏ̓Ƃ(00`53)B */
				n = snprintf(string, maxsize, "%02d", tm_wnum(timeptr, 0/*j*/));
				break;
			case 'w': /* 10iŕ\jBj0Ƃ(0`6)B */
				n = snprintf(string, maxsize, "%d", timeptr->tm_wday);
				break;
			case 'W': /* 10iŕ\T̒ʂԍBjT̍ŏ̓Ƃ(00`53)B */
				n = snprintf(string, maxsize, "%02d", tm_wnum(timeptr, 1/*j*/));
				break;
			case 'x': /* ݂̃P[̓t\ */
				if(!(n = strftime(string, maxsize, "%m/%d/%y", timeptr))) n = -1;
				break;
			case 'X': /* ݂̃P[̎\ */
				if(!(n = strftime(string, maxsize, "%H:%M:%S", timeptr))) n = -1;
				break;
			case 'y': /* 10iŕ\̉2(00`99) */
				n = snprintf(string, maxsize, "%02d", timeptr->tm_year % 100);
				break;
			case 'Y': /* 10iŕ\4̐ */
				n = snprintf(string, maxsize, "%d", timeptr->tm_year + 1900);
				break;
			case 'z': /* ԑт̖O܂͂̏ȗBԑт킩Ȃꍇɂ͕ȂB */
			case 'Z': /* ԑт̖O܂͂̏ȗBԑт킩Ȃꍇɂ͕ȂB */
				n = snprintf(string, maxsize, "%s", "JST");
				break;
			case '%': /* p[ZgL */
			default:
				if(f) {
					n = snprintf(string, maxsize, "%c", f);
				} else {
					n = 0, format--;
				}
				break;
			}
		} else {
			n = snprintf(string, maxsize, "%c", f);
		}
		if(n < 0) return 0;
		string  += n;
		maxsize -= n;
	}

	return string - string0;
}

