/*	
 *	clipswf.c
 *
 *	Flash SWF Player
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Mon Jun 08 00:15:20 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 *	- ݂́ASWF4(Flash Lite)́Aꕔ̋@\ɑΉĂ܂B
 *	  ΉĂ@\ɂẮA\[XR[hQƂĂB
 *	* Sun Jun 14 16:50:39 JST 2009 Naoyuki Sawa
 *	- SWF_BIT_STREAM_get_RECT,MATRIX,CXFORMWITHALPHA̓ǂݏoJnɁAoCgǉ܂B
 *	  ܂ł́AǂݏoJnɂ̓oCgs킸AǂݏoIɂ̂݃oCgsĂ܂B
 *	  ݑΉĂ^O\͈̔͂ł́ArbgtB[h̒RECT,MATRIX,CXFORMWITHALPHÂŁA
 *	  SWF_BIT_STREAM_get_RECT,MATRIX,CXFORMWITHALPHA̓ǂݏoJnɁAoCgsȂĂłB
 *	  Ô߂ɁAuSWF File Format Specificationvɏ]āAoCgǉĂƂɂ܂B
 *	- SWF_OBJECT_DefineShape_2_3()ɁAShapeRecords̃oCg񂪕svł邱Ƃ̃RgǋL܂B
 *	  ̓_ɂāAvO̕ύX͂܂B
 *	- SWF_OBJECT_exec()ɁA^O̓ǂݏoI[𒴉߂ꍇɒ~悤AR[hǉ܂B
 *	* Fri Aug 21 16:48:57 JST 2009 Naoyuki Sawa
 *	- SWF_OBJECT_PlaceObject2()CAOtBbNV{̍ւ@\ɑΉ܂B
 *	  ܂ł́A{PlaceFlagMove=1,PlaceFlagHasCharacter=1}̃P[XAłĂ܂łB
 *	* Sat Aug 22 02:06:31 JST 2009 Naoyuki Sawa
 *	- e^CCEndŃ[vƂAq[r[NbvZbgɌp悤C܂B
 *	  Ƃ΁A10t[̃[r[Nbv쐬A1t[̃C^CCɒuꍇɁA
 *	  C^CC1t[Ƀ[vĂA[r[Nbv͓Ɨ10t[Ԍp܂B
 *	  ܂ł́AC^CC[vxɁA[r[NbvZbgĂ܂B
 *	- Ĉ߂ɁASWF_OBJECT_STATE_ENDASWF_DISPLAY_LIST_end1()ASWF_DISPLAY_LIST_end2()ǉ܂B
 *	  Cȅڍׂ́ÃtO֐gpĂӂ́ARgQƂĂB
 *	* Fri Aug 28 02:03:40 JST 2009 Naoyuki Sawa
 *	- ANVXNvg̎sC܂B
 *	  ANVXNvg͂ɎsAׂẴIuWFNg̏ShowFrameɓBŁA܂Ƃ߂ĎsdlłB
 *	  ȂƁA^[QbgƂ̏ɂāAANVXNvǧʂ1t[Ȃǂ̖肪邩łB
 *	* Wed Sep 02 17:21:17 JST 2009 Naoyuki Sawa
 *	- Î~eLXg̕\Ή܂B
 *	- FontFlagsShiftJISɂ10hbg{tHg6hbgptHg؂ւĂAƎdlp~܂B
 *	  Flash MX́AÎ~eLXgDefineText,DefineFont,DefineFontInfȏgݍ킹Ő܂A
 *	  ptHgł{tHgłDefineFontInfoFontFlagsShiftJIS1ɂȂĂ܂悤ŁAAeɂȂ܂B
 *	  SuzukáAÎ~eLXgDefineText2,DefineFont2̑gݍ킹Ő܂A
 *	  ptHgł{tHgłDefineFontInfoFontFlagsShiftJIS0ɂȂĂ܂悤ŁAAeɂȂ܂B
 *	  邽߂ɁA10hbg{tHĝ݂gƂɂ܂B
 *	- _Ci~bNeLXgɑ΂FontFlagsShiftJIS͐킩mȂ̂łA10hbg{tHgɓꂷ邱Ƃɂ܂B
 *	* Thu Sep 03 14:21:33 JST 2009 Naoyuki Sawa
 *	- jpeg_decode()componentǉƂɒǏ]AY擾悤Acomponent=0̎wǉ܂B
 *	* Fri Sep 04 01:09:48 JST 2009 Naoyuki Sawa
 *	- swf_init()̃RgǋLBvOɂ͕ύXL܂B
 *	* Tue Sep 08 23:06:41 JST 2009 Naoyuki Sawa
 *	- _Ci~bNeLXg̍WYC܂B
 *	  ̓Iɂ́ASWF_EDIT_TEXT_draw()֐̃RgQƂĂB
 *	* Wed Sep 09 00:29:21 JST 2009 Naoyuki Sawa
 *	- swf_set_text_drawing_method()֐ǉ܂B
 *	  ܂ł́AÎ~eLXg𕶎Ƃĕ`Ă܂A}`Ƃĕ`Ił悤ɂ܂B
 *	  ݂́AWindowspR[hubNŃeXgo͂ŝ݂łAƂP/ECEpR[hΉ\łB
 *	* Wed Sep 09 05:19:23 JST 2009 Naoyuki Sawa
 *	- SWF_TEXT_dump_using_GlyphShapeTable()֐𒲐܂B
 *	  WindowspR[hubNŃeXgo͂sȂۂ́Ap`tB[h̒łB
 *	* Fri Sep 11 03:15:56 JST 2009 Naoyuki Sawa
 *	- P/ECEłAÎ~eLXg}`Ƃĕ`܂B
 *	  swf_set_text_drawing_method()֐ɂݒ肪AP/ECEłf悤ɂȂ܂B
 *	* Sat Sep 12 05:08:07 JST 2009 Naoyuki Sawa
 *	- SWF_TEXT_draw_using_GlyphShapeTable()ɁAsNZԂʂďĂ܂Ȃ悤ɂ邽߂̒ǉ܂B
 *	* Sat Sep 12 13:36:28 JST 2009 Naoyuki Sawa
 *	- SWF_TEXT_draw_using_GlyphShapeTable()̒ŁAԈfloor()gĂAfloorf()ɏC܂B
 *	* Sat Sep 12 19:50:46 JST 2009 Naoyuki Sawa
 *	- SWF_TEXT_draw_using_CodeTable()ɁAs̕sړłȂAgk]e悤AC܂B
 *	  ̂̂̊gk]͖ΉłA̍㌴_A{̊gk]ꂽ̍㌴_ʒuɈv悤ɂȂ܂B
 *	* Sat Sep 12 21:17:14 JST 2009 Naoyuki Sawa
 *	- SWF_TEXT_draw_using_GlyphShapeTable()Arender_vec2f_alternate_concaves()łȂrender_vec2i_alternate_concaves()g悤ύXA܂B
 *	  ̕ύXɔAL Sat Sep 12 05:08:07 JST 2009 Rg̏Cӏ͖Ȃ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	uSWF File Format Specificationvɒ`Ă郌R[h
 *****************************************************************************/

typedef struct _SWF_RGB { /* RGBR[hɑ */
	unsigned char Red;
	unsigned char Green;
	unsigned char Blue;
} SWF_RGB;

typedef struct _SWF_RGBA { /* RGBAR[hɑ */
	unsigned char Red;
	unsigned char Green;
	unsigned char Blue;
	unsigned char Alpha;
} SWF_RGBA;

typedef struct _SWF_RECT { /* RECTR[hɑ */
	float Xmin;
	float Xmax;
	float Ymin;
	float Ymax;
} SWF_RECT;

typedef struct _SWF_MATRIX { /* MATRIXR[hɑ */
	float ScaleX;
	float ScaleY;
	float RotateSkew0;
	float RotateSkew1;
	float TranslateX;
	float TranslateY;
} SWF_MATRIX;

static const SWF_MATRIX SWF_MATRIX_1 = { /* ϊ */
	1.0f, /* ScaleX */
	1.0f, /* ScaleY */
	0.0f, /* RotateSkew0 */
	0.0f, /* RotateSkew1 */
	0.0f, /* TranslateX */
	0.0f, /* TranslateY */
};

typedef struct _SWF_CXFORMWITHALPHA { /* CXFORMWITHALPHAR[hɑ */
	float RedMultTerm;
	float GreenMultTerm;
	float BlueMultTerm;
	float AlphaMultTerm;
	float RedAddTerm;
	float GreenAddTerm;
	float BlueAddTerm;
	float AlphaAddTerm;
} SWF_CXFORMWITHALPHA;

static const SWF_CXFORMWITHALPHA SWF_CXFORMWITHALPHA_1 = { /* ϊ */
	1.0f, /* RedMultTerm */
	1.0f, /* GreenMultTerm */
	1.0f, /* BlueMultTerm */
	1.0f, /* AlphaMultTerm */
	0.0f, /* RedAddTerm */
	0.0f, /* GreenAddTerm */
	0.0f, /* BlueAddTerm */
	0.0f, /* AlphaAddTerm */
};

/*****************************************************************************
 *	SWF_BIT_STREAM
 *****************************************************************************/

typedef struct _SWF_BIT_STREAM {
	const unsigned char* data;
	int bit_pos;
} SWF_BIT_STREAM;

static int SWF_BIT_STREAM_get_UB(SWF_BIT_STREAM* self, int nBits);
static int SWF_BIT_STREAM_get_SB(SWF_BIT_STREAM* self, int nBits);
static float SWF_BIT_STREAM_get_FB(SWF_BIT_STREAM* self, int nBits);
static const void* SWF_BIT_STREAM_get_data(SWF_BIT_STREAM* self, int n);
static int SWF_BIT_STREAM_get_UI8(SWF_BIT_STREAM* self);
static int SWF_BIT_STREAM_get_UI16(SWF_BIT_STREAM* self);
static int SWF_BIT_STREAM_get_SI16(SWF_BIT_STREAM* self);
static int SWF_BIT_STREAM_get_SI32(SWF_BIT_STREAM* self);
static const char* SWF_BIT_STREAM_get_STRING(SWF_BIT_STREAM* self);
static void SWF_BIT_STREAM_get_RGB(SWF_BIT_STREAM* self, SWF_RGB* out/*nullok*/);
static void SWF_BIT_STREAM_get_RGBA(SWF_BIT_STREAM* self, SWF_RGBA* out/*nullok*/);
static void SWF_BIT_STREAM_get_RECT(SWF_BIT_STREAM* self, SWF_RECT* out/*nullok*/);
static void SWF_BIT_STREAM_get_MATRIX(SWF_BIT_STREAM* self, SWF_MATRIX* out/*nullok*/);
static void SWF_BIT_STREAM_get_CXFORMWITHALPHA(SWF_BIT_STREAM* self, SWF_CXFORMWITHALPHA* out/*nullok*/);

/*---------------------------------------------------------------------------*/

static int SWF_BIT_STREAM_get_UB(SWF_BIT_STREAM* self, int nBits) {
	int value = 0;
	while(nBits--) {
		value = (value << 1) | ((self->data[self->bit_pos >> 3] >> (~self->bit_pos & 7)) & 1);
		self->bit_pos++;
	}
	return value;
}

static int SWF_BIT_STREAM_get_SB(SWF_BIT_STREAM* self, int nBits) {
	return (SWF_BIT_STREAM_get_UB(self, nBits) << (32 - nBits)) >> (32 - nBits);
}

static float SWF_BIT_STREAM_get_FB(SWF_BIT_STREAM* self, int nBits) {
	return SWF_BIT_STREAM_get_SB(self, nBits) / 65536.0f;
}

static const void* SWF_BIT_STREAM_get_data(SWF_BIT_STREAM* self, int n) {
	int byte_pos = (self->bit_pos + 7) >> 3;
	const void* data = &self->data[byte_pos];
	self->bit_pos = (byte_pos + n) << 3;
	return data;
}

static int SWF_BIT_STREAM_get_UI8(SWF_BIT_STREAM* self) {
	const unsigned char* data = SWF_BIT_STREAM_get_data(self, 1);
	return data[0];
}

static int SWF_BIT_STREAM_get_UI16(SWF_BIT_STREAM* self) {
	const unsigned char* data = SWF_BIT_STREAM_get_data(self, 2);
	return data[0] | (data[1] << 8);
}

static int SWF_BIT_STREAM_get_SI16(SWF_BIT_STREAM* self) {
	return (short)SWF_BIT_STREAM_get_UI16(self);
}

static int SWF_BIT_STREAM_get_SI32(SWF_BIT_STREAM* self) {
	const unsigned char* data = SWF_BIT_STREAM_get_data(self, 4);
	return data[0] | (data[1] << 8) | (data[2] << 16) | (data[3] << 24);
}

static const char* SWF_BIT_STREAM_get_STRING(SWF_BIT_STREAM* self) {
	const char* string = SWF_BIT_STREAM_get_data(self, 0);
	while(SWF_BIT_STREAM_get_UI8(self)) { /** no job **/ }
	return string;
}

static void SWF_BIT_STREAM_get_RGB(SWF_BIT_STREAM* self, SWF_RGB* out/*nullok*/) {
	SWF_RGB tmp;
	tmp.Red   = SWF_BIT_STREAM_get_UI8(self);
	tmp.Green = SWF_BIT_STREAM_get_UI8(self);
	tmp.Blue  = SWF_BIT_STREAM_get_UI8(self);
	if(out) {
		*out = tmp;
	}
}

static void SWF_BIT_STREAM_get_RGBA(SWF_BIT_STREAM* self, SWF_RGBA* out/*nullok*/) {
	SWF_RGBA tmp;
	tmp.Red   = SWF_BIT_STREAM_get_UI8(self);
	tmp.Green = SWF_BIT_STREAM_get_UI8(self);
	tmp.Blue  = SWF_BIT_STREAM_get_UI8(self);
	tmp.Alpha = SWF_BIT_STREAM_get_UI8(self);
	if(out) {
		*out = tmp;
	}
}

static void SWF_BIT_STREAM_get_RECT(SWF_BIT_STREAM* self, SWF_RECT* out/*nullok*/) {
	/* The RECT record must be byte aligned. */
	SWF_BIT_STREAM_get_data(self, 0); /* oCg */
	{
		SWF_RECT tmp;
		int Nbits = SWF_BIT_STREAM_get_UB(self, 5);
		tmp.Xmin  = SWF_BIT_STREAM_get_SB(self, Nbits) / 20.0f;
		tmp.Xmax  = SWF_BIT_STREAM_get_SB(self, Nbits) / 20.0f;
		tmp.Ymin  = SWF_BIT_STREAM_get_SB(self, Nbits) / 20.0f;
		tmp.Ymax  = SWF_BIT_STREAM_get_SB(self, Nbits) / 20.0f;
		if(out) {
			*out = tmp;
		}
	}
	SWF_BIT_STREAM_get_data(self, 0); /* oCg */
}

static void SWF_BIT_STREAM_get_MATRIX(SWF_BIT_STREAM* self, SWF_MATRIX* out/*nullok*/) {
	/* The MATRIX record must be byte aligned. */
	SWF_BIT_STREAM_get_data(self, 0); /* oCg */
	{
		SWF_MATRIX tmp = SWF_MATRIX_1;
		if(SWF_BIT_STREAM_get_UB(self, 1)) { /* HasScale */
			int NScaleBits = SWF_BIT_STREAM_get_UB(self, 5);
			tmp.ScaleX     = SWF_BIT_STREAM_get_FB(self, NScaleBits);
			tmp.ScaleY     = SWF_BIT_STREAM_get_FB(self, NScaleBits);
		}
		if(SWF_BIT_STREAM_get_UB(self, 1)) { /* HasRotate */
			int NRotateBits = SWF_BIT_STREAM_get_UB(self, 5);
			tmp.RotateSkew0 = SWF_BIT_STREAM_get_FB(self, NRotateBits);
			tmp.RotateSkew1 = SWF_BIT_STREAM_get_FB(self, NRotateBits);
		}
		{
			int NTranslateBits = SWF_BIT_STREAM_get_UB(self, 5);
			tmp.TranslateX     = SWF_BIT_STREAM_get_SB(self, NTranslateBits) / 20.0f;
			tmp.TranslateY     = SWF_BIT_STREAM_get_SB(self, NTranslateBits) / 20.0f;
		}
		if(out) {
			*out = tmp;
		}
	}
	SWF_BIT_STREAM_get_data(self, 0); /* oCg */
}

static void SWF_BIT_STREAM_get_CXFORMWITHALPHA(SWF_BIT_STREAM* self, SWF_CXFORMWITHALPHA* out/*nullok*/) {
	/* The CXFORM record must be byte aligned. */
	SWF_BIT_STREAM_get_data(self, 0); /* oCg */
	{
		SWF_CXFORMWITHALPHA tmp = SWF_CXFORMWITHALPHA_1;
		int HasAddTerms  = SWF_BIT_STREAM_get_UB(self, 1);
		int HasMultTerms = SWF_BIT_STREAM_get_UB(self, 1);
		int Nbits        = SWF_BIT_STREAM_get_UB(self, 4);
		if(HasMultTerms) {
			tmp.RedMultTerm   = SWF_BIT_STREAM_get_UB(self, Nbits) / 256.0f;
			tmp.GreenMultTerm = SWF_BIT_STREAM_get_UB(self, Nbits) / 256.0f;
			tmp.BlueMultTerm  = SWF_BIT_STREAM_get_UB(self, Nbits) / 256.0f;
			tmp.AlphaMultTerm = SWF_BIT_STREAM_get_UB(self, Nbits) / 256.0f;
		}
		if(HasAddTerms) {
			tmp.RedAddTerm   = SWF_BIT_STREAM_get_UB(self, Nbits);
			tmp.GreenAddTerm = SWF_BIT_STREAM_get_UB(self, Nbits);
			tmp.BlueAddTerm  = SWF_BIT_STREAM_get_UB(self, Nbits);
			tmp.AlphaAddTerm = SWF_BIT_STREAM_get_UB(self, Nbits);
		}
		if(out) {
			*out = tmp;
		}
	}
	SWF_BIT_STREAM_get_data(self, 0); /* oCg */
}

/*****************************************************************************
 *	SWF_CHARACTER
 *****************************************************************************/

/* SWF_CHARACTER.character_type */
//#define SWF_CHARACTER_TYPE_ROOT	0
#define SWF_CHARACTER_TYPE_BITMAP	1
#define SWF_CHARACTER_TYPE_SHAPE	2
#define SWF_CHARACTER_TYPE_FONT		3
#define SWF_CHARACTER_TYPE_TEXT		4
#define SWF_CHARACTER_TYPE_EDIT_TEXT	5
#define SWF_CHARACTER_TYPE_SPRITE	6

typedef struct _SWF_CHARACTER {
	LIST_ENTRY list_entry;
	int character_type;
	int CharacterId;
} SWF_CHARACTER;

typedef struct _SWF_BITMAP {
	SWF_CHARACTER character; /* NX */
	TEXTURE texture;
	/* unsigned char  buf[texture->header.w * texture->header.h / 4] */
	/* unsigned char mask[texture->header.w * texture->header.h / 8] */
} SWF_BITMAP;

typedef struct _SWF_SHAPE {
	SWF_CHARACTER character; /* NX */
	SWF_BITMAP* bitmap;
	SWF_MATRIX BitmapMatrix;
	struct _SWF_SHAPE* next;
} SWF_SHAPE;

typedef struct _SWF_FONT {
	SWF_CHARACTER character; /* NX */
	int FontFlagsWideOffsets;		/* DefineFont2 */
	const unsigned char* OffsetTable;	/* DefineFont,DefineFont2 */
	int FontFlagsWideCodes;			/* DefineFontInfo,DefineFont2 */
	const unsigned char* CodeTable;		/* DefineFontInfo,DefineFont2 */
	int FontFlagsHasLayout;			/* DefineFont2 */
	float FontDescent;			/* DefineFont2 */
	int FontFlagsBold;			/* DefineFontInfo,DefineFont2 */
#ifndef PIECE
	int FontNameLen;			/* DefineFontInfo,DefineFont2 */
	const char* FontName;			/* DefineFontInfo,DefineFont2 */
	int FontFlagsItalic;			/* DefineFontInfo,DefineFont2 */
#endif /*PIECE*/
} SWF_FONT;

typedef struct _SWF_TEXT {
	SWF_CHARACTER character; /* NX */
	SWF_MATRIX TextMatrix;
	int GlyphBits;
	int AdvanceBits;
	const unsigned char* TextRecords;
	int has_alpha;
#ifndef PIECE
	SWF_RECT TextBounds;
#endif /*PIECE*/
} SWF_TEXT;

typedef struct _SWF_EDIT_TEXT {
	SWF_CHARACTER character; /* NX */
	SWF_RECT Bounds;
	SWF_FONT* font;
	int color;
	const char* InitialText;
} SWF_EDIT_TEXT;

typedef struct _SWF_SPRITE {
	SWF_CHARACTER character; /* NX */
	const unsigned char* ControlTags;
} SWF_SPRITE;

/*****************************************************************************
 *	SWF
 *****************************************************************************/

typedef struct _SWF {
	SWF_INFO swf_info;
	LIST_ENTRY dictionary;
	LIST_ENTRY display_list;
	const unsigned char* JPEGData; /* JPEGTables */
	int text_drawing_method; /* 0 = using CodeTable, 1 = using GlyphShapeTable */
} SWF;

static SWF swf;

static void SWF_DICTIONARY_new_bitmap(int CharacterId, SURFACE* surface);
static SWF_CHARACTER* SWF_DICTIONARY_get_character(int CharacterId);
static void SWF_DICTIONARY_free();

/*---------------------------------------------------------------------------*/

static void SWF_DICTIONARY_new_bitmap(int CharacterId, SURFACE* surface) {
	SWF_BITMAP* bitmap = calloc(1, sizeof(SWF_BITMAP) + (surface->w * surface->h / 4)/*buf*/ + (surface->w * surface->h / 8)/*mask*/);
	if(!bitmap) {
		DIE(); /* s */
	}
	/*{{*/
	bitmap->character.character_type = SWF_CHARACTER_TYPE_BITMAP;
	bitmap->character.CharacterId    = CharacterId;
	bitmap->texture.header.bpp       = 2;
	bitmap->texture.header.mask      = 1;
	bitmap->texture.header.w         = surface->w;
	bitmap->texture.header.h         = surface->h;
	bitmap->texture.buf              = (unsigned char*)(&bitmap->texture + 1);
	bitmap->texture.mask             = bitmap->texture.buf + (surface->w * surface->h / 4);
	texture_copy(&bitmap->texture, surface, 0, 0);
	/*}}*/
	InsertTailList(&swf.dictionary, &bitmap->character.list_entry);
}

static SWF_CHARACTER* SWF_DICTIONARY_get_character(int CharacterId) {
	LIST_ENTRY* list_head = &swf.dictionary;
	LIST_ENTRY* list_entry = list_head->Flink;
	while(list_entry != list_head) {
		SWF_CHARACTER* character = CONTAINING_RECORD(list_entry, SWF_CHARACTER, list_entry);
		list_entry = list_entry->Flink;
		if(character->CharacterId == CharacterId) {
			return character;
		}
	}
	return NULL;
}

static void SWF_DICTIONARY_free() {
	while(!IsListEmpty(&swf.dictionary)) {
		LIST_ENTRY* list_entry = RemoveHeadList(&swf.dictionary);
		SWF_CHARACTER* character = CONTAINING_RECORD(list_entry, SWF_CHARACTER, list_entry);
		free(character); /* character_typeɂ炸AubN1ŊmۂĂ */
	}
}

/*****************************************************************************
 *	SWF_OBJECT
 *****************************************************************************/

/* SWF_OBJECT.object_state */
#define SWF_OBJECT_STATE_PLAY	(1 << 0)	/* 0 = XvCg~A܂́AXvCg, 1 = XvCgĐ */
#define SWF_OBJECT_STATE_END	(1 << 1)	/* 0 = ʏ, 1 = EndŃ[vォAŏShowFrame܂ł̊ */

typedef struct _SWF_OBJECT SWF_OBJECT;
/*typedef*/ struct _SWF_OBJECT {
	LIST_ENTRY list_entry;
	int object_state;
	int Depth;
	const char* Name;
	SWF_MATRIX Matrix;
	SWF_OBJECT* parent;
	SWF_CHARACTER* character;
	SWF_BIT_STREAM bit_stream;
	LIST_ENTRY display_list;
	LIST_ENTRY action_list;
} /*SWF_OBJECT*/;

typedef struct _SWF_ACTION {
	LIST_ENTRY list_entry;
	const unsigned char* Actions;
} SWF_ACTION;

static SWF_OBJECT* SWF_DISPLAY_LIST_new_object(LIST_ENTRY* display_list, int Depth);
static SWF_OBJECT* SWF_DISPLAY_LIST_get_object(LIST_ENTRY* display_list, int Depth);
static void SWF_DISPLAY_LIST_free(LIST_ENTRY* display_list);
static void SWF_DISPLAY_LIST_exec(LIST_ENTRY* display_list);
static void SWF_DISPLAY_LIST_exec_action(LIST_ENTRY* display_list);
static void SWF_DISPLAY_LIST_end1(LIST_ENTRY* display_list);
static void SWF_DISPLAY_LIST_end2(LIST_ENTRY* display_list);
#ifdef PIECE
static void SWF_DISPLAY_LIST_draw(LIST_ENTRY* display_list, RENDER* render, const mat2f* m);
#endif /*PIECE*/

static void SWF_ACTION_LIST_add_action(LIST_ENTRY* action_list, const unsigned char* Actions);
static const unsigned char* SWF_ACTION_LIST_get_action(LIST_ENTRY* action_list);
static void SWF_ACTION_LIST_free(LIST_ENTRY* action_list);

static void SWF_OBJECT_free(SWF_OBJECT* self);
static void SWF_OBJECT_exec(SWF_OBJECT* self);
static void SWF_OBJECT_exec_action(SWF_OBJECT* self);
#ifdef PIECE
static void SWF_OBJECT_draw(SWF_OBJECT* self, RENDER* render, const mat2f* m);
#endif /*PIECE*/

static void SWF_OBJECT_DefineShape(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);         //  2 DefineShape
static void SWF_OBJECT_DefineBits(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);          //  6 DefineBits
static void SWF_OBJECT_JPEGTables(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);          //  8 JPEGTables
static void SWF_OBJECT_SetBackgroundColor(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);  //  9 SetBackgroundColor
static void SWF_OBJECT_DefineFont(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);          // 10 DefineFont
static void SWF_OBJECT_DefineText(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);          // 11 DefineText
static void SWF_OBJECT_DoAction(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);            // 12 DoAction
static void SWF_OBJECT_DefineFontInfo(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);      // 13 DefineFontInfo
static void SWF_OBJECT_DefineBitsLossless(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);  // 20 DefineBitsLossless
static void SWF_OBJECT_DefineBitsJPEG2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);     // 21 DefineBitsJPEG2
static void SWF_OBJECT_DefineShape2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);        // 22 DefineShape2
static void SWF_OBJECT_PlaceObject2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);        // 26 PlaceObject2
static void SWF_OBJECT_RemoveObject2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);       // 28 RemoveObject2
static void SWF_OBJECT_DefineShape3(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);        // 32 DefineShape3
static void SWF_OBJECT_DefineText2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);         // 33 DefineText2
static void SWF_OBJECT_DefineBitsJPEG3(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);     // 35 DefineBitsJPEG3
static void SWF_OBJECT_DefineBitsLossless2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream); // 36 DefineBitsLossless2
static void SWF_OBJECT_DefineEditText(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);      // 37 DefineEditText
static void SWF_OBJECT_DefineSprite(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);        // 39 DefineSprite
static void SWF_OBJECT_DefineFont2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream);         // 48 DefineFont2

/*---------------------------------------------------------------------------*/

static SWF_OBJECT* SWF_DISPLAY_LIST_new_object(LIST_ENTRY* display_list, int Depth) {
	SWF_OBJECT* object;
	LIST_ENTRY* list_entry = display_list->Flink;
	while(list_entry != display_list) {
		object = CONTAINING_RECORD(list_entry, SWF_OBJECT, list_entry);
		/*{{̏ԕK{*/
		if(object->Depth >= Depth) {
			break;
		}
		list_entry = list_entry->Flink;
		/*}}̏ԕK{*/
	}
	object = calloc(1, sizeof(SWF_OBJECT));
	if(!object) {
		DIE(); /* s */
	}
	/*{{*/
	object->Depth  = Depth;
	object->Name   = "";
	object->Matrix = SWF_MATRIX_1;
	InitializeListHead(&object->display_list);
	InitializeListHead(&object->action_list);
	/*}}*/
	InsertTailList(list_entry, &object->list_entry);
	return object;
}

static SWF_OBJECT* SWF_DISPLAY_LIST_get_object(LIST_ENTRY* display_list, int Depth) {
	LIST_ENTRY* list_entry = display_list->Flink;
	while(list_entry != display_list) {
		SWF_OBJECT* object = CONTAINING_RECORD(list_entry, SWF_OBJECT, list_entry);
		list_entry = list_entry->Flink;
		if(object->Depth == Depth) {
			return object;
		}
	}
	return NULL;
}

static void SWF_DISPLAY_LIST_free(LIST_ENTRY* display_list) {
	while(!IsListEmpty(display_list)) {
		LIST_ENTRY* list_entry = display_list->Flink;
		SWF_OBJECT* object = CONTAINING_RECORD(list_entry, SWF_OBJECT, list_entry);
		SWF_OBJECT_free(object); /* ̒RemoveEntryList(&object->list_entry)Ă΂ */
	}
}

static void SWF_DISPLAY_LIST_exec(LIST_ENTRY* display_list) {
	LIST_ENTRY* list_entry = display_list->Flink;
	while(list_entry != display_list) {
		SWF_OBJECT* object = CONTAINING_RECORD(list_entry, SWF_OBJECT, list_entry);
		list_entry = list_entry->Flink;
		SWF_OBJECT_exec(object);
	}
}

static void SWF_DISPLAY_LIST_exec_action(LIST_ENTRY* display_list) {
	LIST_ENTRY* list_entry = display_list->Flink;
	while(list_entry != display_list) {
		SWF_OBJECT* object = CONTAINING_RECORD(list_entry, SWF_OBJECT, list_entry);
		list_entry = list_entry->Flink;
		SWF_OBJECT_exec_action(object);
	}
}

static void SWF_DISPLAY_LIST_end1(LIST_ENTRY* display_list) {
	LIST_ENTRY* list_entry = display_list->Flink;
	while(list_entry != display_list) {
		SWF_OBJECT* object = CONTAINING_RECORD(list_entry, SWF_OBJECT, list_entry);
		list_entry = list_entry->Flink;
		object->object_state |= SWF_OBJECT_STATE_END;
	}
}

static void SWF_DISPLAY_LIST_end2(LIST_ENTRY* display_list) {
	LIST_ENTRY* list_entry = display_list->Flink;
	while(list_entry != display_list) {
		SWF_OBJECT* object = CONTAINING_RECORD(list_entry, SWF_OBJECT, list_entry);
		list_entry = list_entry->Flink;
		if(object->object_state & SWF_OBJECT_STATE_END) {
			SWF_OBJECT_free(object); /* ̒RemoveEntryList(&object->list_entry)Ă΂ */
		}
	}
}

#ifdef PIECE
static void SWF_DISPLAY_LIST_draw(LIST_ENTRY* display_list, RENDER* render, const mat2f* m) {
	LIST_ENTRY* list_entry = display_list->Flink;
	while(list_entry != display_list) {
		SWF_OBJECT* object = CONTAINING_RECORD(list_entry, SWF_OBJECT, list_entry);
		list_entry = list_entry->Flink;
		SWF_OBJECT_draw(object, render, m);
	}
}
#endif /*PIECE*/

/*---------------------------------------------------------------------------*/

static void SWF_ACTION_LIST_add_action(LIST_ENTRY* action_list, const unsigned char* Actions) {
	SWF_ACTION* action = calloc(1, sizeof(SWF_ACTION));
	if(!action) {
		DIE(); /* s */
	}
	action->Actions = Actions;
	InsertTailList(action_list, &action->list_entry);
}

static const unsigned char* SWF_ACTION_LIST_get_action(LIST_ENTRY* action_list) {
	const unsigned char* Actions;
	if(!IsListEmpty(action_list)) {
		LIST_ENTRY* list_entry = RemoveHeadList(action_list);
		SWF_ACTION* action = CONTAINING_RECORD(list_entry, SWF_ACTION, list_entry);
		Actions = action->Actions;
		free(action);
	} else {
		Actions = NULL;
	}
	return Actions;
}

static void SWF_ACTION_LIST_free(LIST_ENTRY* action_list) {
	while(SWF_ACTION_LIST_get_action(action_list)) {
		/** no job **/
	}
}

/*---------------------------------------------------------------------------*/

static void SWF_OBJECT_free(SWF_OBJECT* self) {
	SWF_DISPLAY_LIST_free(&self->display_list);
	SWF_ACTION_LIST_free(&self->action_list);
	RemoveEntryList(&self->list_entry);
	free(self);
}

static void SWF_OBJECT_exec(SWF_OBJECT* self) {
	if(self->object_state & SWF_OBJECT_STATE_PLAY) {
		int TagCodeAndLength;
		int tag_type;
		int tag_length;
		const void* tag_data;
		do {
			void (*fn)(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) = NULL;
			TagCodeAndLength = SWF_BIT_STREAM_get_UI16(&self->bit_stream);
			tag_type   = TagCodeAndLength >> 6;
			tag_length = TagCodeAndLength & 63;
			if(tag_length == 63) {
				tag_length = SWF_BIT_STREAM_get_SI32(&self->bit_stream); /* Length */
			}
			tag_data = SWF_BIT_STREAM_get_data(&self->bit_stream, tag_length);
			switch(tag_type) {
			case  0: //  0 End
				/* EndŃ[v鎞AfBXvCXgJɁASWF_OBJECT_STATE_END}[NĂ܂B */
				SWF_DISPLAY_LIST_end1(&self->display_list);
				self->bit_stream.bit_pos = 0; /* [v */
				if(!self->character->character_type) { /* B̃[gIuWFNgc */
					swf.swf_info.loop_count++;     /* [v񐔂JEgAbv܂B */
				}
				break;
			case  2: //  2 DefineShape
				fn = SWF_OBJECT_DefineShape;
				break;
			case  6: //  6 DefineBits
				fn = SWF_OBJECT_DefineBits;
				break;
			case  8: //  8 JPEGTables
				fn = SWF_OBJECT_JPEGTables;
				break;
			case  9: //  9 SetBackgroundColor
				fn = SWF_OBJECT_SetBackgroundColor;
				break;
			case 10: // 10 DefineFont
				fn = SWF_OBJECT_DefineFont;
				break;
			case 11: // 11 DefineText
				fn = SWF_OBJECT_DefineText;
				break;
			case 12: // 12 DoAction
				fn = SWF_OBJECT_DoAction;
				break;
			case 13: // 13 DefineFontInfo
				fn = SWF_OBJECT_DefineFontInfo;
				break;
			case 20: // 20 DefineBitsLossless
				fn = SWF_OBJECT_DefineBitsLossless;
				break;
			case 21: // 21 DefineBitsJPEG2
				fn = SWF_OBJECT_DefineBitsJPEG2;
				break;
			case 22: // 22 DefineShape2
				fn = SWF_OBJECT_DefineShape2;
				break;
			case 26: // 26 PlaceObject2
				fn = SWF_OBJECT_PlaceObject2;
				break;
			case 28: // 28 RemoveObject2
				fn = SWF_OBJECT_RemoveObject2;
				break;
			case 32: // 32 DefineShape3
				fn = SWF_OBJECT_DefineShape3;
				break;
			case 33: // 33 DefineText2
				fn = SWF_OBJECT_DefineText2;
				break;
			case 35: // 35 DefineBitsJPEG3
				fn = SWF_OBJECT_DefineBitsJPEG3;
				break;
			case 36: // 36 DefineBitsLossless2
				fn = SWF_OBJECT_DefineBitsLossless2;
				break;
			case 37: // 37 DefineEditText
				fn = SWF_OBJECT_DefineEditText;
				break;
			case 39: // 39 DefineSprite
				fn = SWF_OBJECT_DefineSprite;
				break;
			case 48: // 48 DefineFont2
				fn = SWF_OBJECT_DefineFont2;
				break;
			}
			if(fn) {
				SWF_BIT_STREAM tag_bit_stream = { tag_data };
				(*fn)(self, &tag_bit_stream);
				if(tag_bit_stream.bit_pos > tag_length << 3) {
					DIE(); /* ^O̓ǂݏoI[𒴉߂BŎ~܂炽Ԃ񂱂̃vÕoO?ł */
				}
			}
		} while(tag_type != 1); //  1 ShowFrame
		/* EndŃ[vAuŏShowFrame܂ł̊ԂɁA^CCpXvCgv*ȊO*AۂɊJ܂B
		 * EndŃ[vłȂ΁ASWF_OBJECT_STATE_END}[NIuWFNĝŁAʂłxႠ܂B
		 */
		SWF_DISPLAY_LIST_end2(&self->display_list);
	}
	SWF_DISPLAY_LIST_exec(&self->display_list);
}

static void SWF_OBJECT_exec_action(SWF_OBJECT* self) {
	const unsigned char* Actions;
	while((Actions = SWF_ACTION_LIST_get_action(&self->action_list)) != NULL) {
		//{{ 12 DoAction
		SWF_BIT_STREAM bit_stream = { Actions };
		SWF_OBJECT* target = self;
		for(;;) {
			int ActionCode = SWF_BIT_STREAM_get_UI8(&bit_stream);
			if(!ActionCode) { // 0 ActionEndFlag
				break;
			} else {
				int Length = (ActionCode >= 0x80) ? SWF_BIT_STREAM_get_UI16(&bit_stream) : 0;
				const void* action_data = SWF_BIT_STREAM_get_data(&bit_stream, Length);
				SWF_BIT_STREAM action_bit_stream = { action_data };
				switch(ActionCode) {
				//case 0x81: // 0x81 ActionGotoFrame
				//case 0x83: // 0x83 ActionGetURL
				//case 0x04: // 0x04 ActionNextFrame
				//case 0x05: // 0x05 ActionPreviousFrame
				case 0x06: // 0x06 ActionPlay
					{
						target->object_state |= SWF_OBJECT_STATE_PLAY;
					}
					break;
				case 0x07: // 0x07 ActionStop
					{
						target->object_state &= ~SWF_OBJECT_STATE_PLAY;
					}
					break;
				//case 0x08: // 0x08 ActionToggleQuality
				//case 0x09: // 0x09 ActionStopSounds
				//case 0x8A: // 0x8A ActionWaitForFrame
				case 0x8B: // 0x8B ActionSetTarget
					{
						const char* TargetName = SWF_BIT_STREAM_get_STRING(&action_bit_stream);
						char str[256]; /* [Ȓ */
						char* p;
						target = self;
						if(strlen(TargetName) > sizeof str - 1) {
							DIE(); /* pX */
						}
						p = strncpy(str, TargetName, sizeof str);
						if(*p == '/') {
							while(target->parent) {
								target = target->parent;
							}
							//p++; ŏstrtok()ŎIɃXLbv̂ŁȀ͕sv
						}
						p = strtok(p, "/");
						while(p) {
							if(!strcmp(p, "..")) {
								if(!target->parent) {
									DIE(); /* sȃpX */
								}
								target = target->parent;
							} else {
								LIST_ENTRY* list_head = &target->display_list;
								LIST_ENTRY* list_entry = list_head->Flink;
								SWF_OBJECT* object;
								for(;;) {
									if(list_entry == list_head) {
										DIE(); /* sȃpX */
									}
									object = CONTAINING_RECORD(list_entry, SWF_OBJECT, list_entry);
									list_entry = list_entry->Flink;
									if(!strcmp(object->Name, p)) {
										target = object;
										break;
									}
								}
							}
							p = strtok(NULL, "/");
						}
					}
					break;
				//case 0x8C: // 0x8C ActionGoToLabel
				}
			}
		}
		//}} 12 DoAction
	}
	SWF_DISPLAY_LIST_exec_action(&self->display_list);
}

#ifdef PIECE
static void SWF_SHAPE_draw(SWF_SHAPE* self, RENDER* render, const mat2f* m) {
	do {
		mat2f m1 = *m;
		mat2f m2 = {
			self->BitmapMatrix.ScaleX, self->BitmapMatrix.RotateSkew1, self->BitmapMatrix.TranslateX,
			self->BitmapMatrix.RotateSkew0, self->BitmapMatrix.ScaleY, self->BitmapMatrix.TranslateY,
		};
		mat2f_xform(&m1, &m2);
		if(m1.a00 == 1.0f && m1.a01 == 0.0f &&
		   m1.a10 == 0.0f && m1.a11 == 1.0f) {
			/* gk]ŁAsړ̏ꍇ́A{`gƂɂ܂B
			 * sړ̏ꍇ̕Ǝv̂ŁAƌĥ߂łB
			 */
			TEXTURE* texture = &self->bitmap->texture;
			int x = floorf(m1.a02 + 0.5f);
			int y = floorf(m1.a12 + 0.5f);
			int w = texture->header.w;
			int h = texture->header.h;
			render->context->texture = texture;
			render_object(render, x, y, 0, 0, w, h, DRW_NOMAL);
		} else {
			TEXTURE* texture = &self->bitmap->texture;
			int w = texture->header.w;
			int h = texture->header.h;
			VERTEX vertex[4] = {
				{ 0, 0,     0,     0 },
				{ w, 0, w - 1,     0 },
				{ w, h, w - 1, h - 1 },
				{ 0, h,     0, h - 1 },
			};
			int i;
			for(i = 0; i < 4; i++) {
				vec2f v;
				v.x = vertex[i].x;
				v.y = vertex[i].y;
				vec2f_xform(&m1, &v);
				vertex[i].x = floorf(v.x + 0.5f);
				vertex[i].y = floorf(v.y + 0.5f);
			}
			render->context->texture = texture;
			render_polygon(render, vertex, 4, 0);
		}
		self = self->next;
	} while(self);
}

static void SWF_TEXT_draw_using_CodeTable(SWF_TEXT* self, RENDER* render, const mat2f* m) {
	SWF_BIT_STREAM bit_stream = { self->TextRecords };
	int StyleFlagsHasFont;
	int StyleFlagsHasColor;
	int StyleFlagsHasYOffset;
	int StyleFlagsHasXOffset;
	int FontId;
	SWF_FONT* font = NULL; /*x}*/
	SWF_RGBA TextColor;
	float XOffset = 0.0f; /*x}*/
	float YOffset = 0.0f; /*x}*/
	float TextHeight = 0.0f; /*x}*/
	int GlyphCount;
	int GlyphIndex;
	float GlyphAdvance;
	int i;
	int code;
	int x;
	int y;
	int color;
	unsigned short (*fn)(RENDER* render, int x, int y, unsigned short code, int type, int color);
	mat2f m1 = *m;
	mat2f m2 = {
		self->TextMatrix.ScaleX, self->TextMatrix.RotateSkew1, self->TextMatrix.TranslateX,
		self->TextMatrix.RotateSkew0, self->TextMatrix.ScaleY, self->TextMatrix.TranslateY,
	};
	mat2f_xform(&m1, &m2);

	for(;;) {
		if(!SWF_BIT_STREAM_get_UB(&bit_stream, 1)) { /* TextRecordType */
			break;
		}
		SWF_BIT_STREAM_get_UB(&bit_stream, 3); /* StyleFlagsReserved */
		StyleFlagsHasFont    = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasColor   = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasYOffset = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasXOffset = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		if(StyleFlagsHasFont) {
			FontId = SWF_BIT_STREAM_get_UI16(&bit_stream);
			font = (SWF_FONT*)SWF_DICTIONARY_get_character(FontId);
			if(font && (font->character.character_type != SWF_CHARACTER_TYPE_FONT)) {
				DIE(); /* sȃf[^ */
			}
		}
		if(StyleFlagsHasColor) {
			if(self->has_alpha) {
				SWF_BIT_STREAM_get_RGBA(&bit_stream, &TextColor);
			} else {
				SWF_BIT_STREAM_get_RGB(&bit_stream, (SWF_RGB*)&TextColor);
			}
		}
		if(StyleFlagsHasXOffset) {
			XOffset = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		if(StyleFlagsHasYOffset) {
			YOffset = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		if(StyleFlagsHasFont) {
			TextHeight = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		GlyphCount = SWF_BIT_STREAM_get_UI8(&bit_stream);
		/* GlyphEntries */
		for(i = 0; i < GlyphCount; i++) {
			GlyphIndex   = SWF_BIT_STREAM_get_UB(&bit_stream, self->GlyphBits);
			GlyphAdvance = SWF_BIT_STREAM_get_UB(&bit_stream, self->AdvanceBits) / 20.0f;
			if(font && font->CodeTable) {
				/* * Wed Sep 02 13:41:37 JST 2009 Naoyuki Sawa
				 * - uSWF File Format Specification Version 10v191y[WiɁAȉ̐܂B
				 *   The XOffset field defines the offset from the left of the TextBounds rectangle to the reference point of the glyph.
				 *   The YOffset field defines the offset from the top of the TextBounds rectangle to the reference point of the glyph.
				 *   XOffset,YOffsetTextBoundsɑ΂ƂȂĂ܂Aۂ̃f[^𒲂ׂƂAIuWFNg_ɑ΂Ǝv܂B
				 *   TextBoundśAPɕ`͈͂qgłATextBounds̒lłĂAXOffset,YOffset̒l͉e󂯂܂B
				 *   TextBoundsPȂqgłƎdǵ݂ADefineShapeɂShapeBound̖ƎʂĂ܂B
				 *   炭A̗ŊԈĂȂƎv܂B
				 */
				vec2f v = { XOffset, YOffset - TextHeight };
				//                           ~~~~~~~~~~~~
				// {̓AZ_ׂȂ̂łAP/ECEłTEXTMETRIC擾łȂ߁A~ނ𓾂eLXg̍܂B
				// fBZ_߂ɂȂ܂̂ŁAP/ECEł̓eLXgTCY傫قǏɂĂ܂܂AdL܂B
				if(font->FontFlagsHasLayout) { /* CAEgL */
					v.y += TextHeight * font->FontDescent;
				}
				vec2f_xform(&m1, &v);
				x = floorf(v.x + 0.5f);
				y = floorf(v.y + 0.5f);
				color = ((((TextColor.Red * 30) + (TextColor.Green * 59) + (TextColor.Blue * 11)) / 100) >> 6) ^ 3;
				if(font->FontFlagsBold) {
					fn = render_font_framed;
					if(color <= 1) {
						color |= 0x330; /* {[h̑ɁAt̐Fŉ */
					}
				} else {
					fn = render_font;
				}
				if(font->FontFlagsWideCodes) {
					code = font->CodeTable[(GlyphIndex * 2) + 0] | font->CodeTable[(GlyphIndex * 2) + 1] << 8;
				} else {
					code = font->CodeTable[GlyphIndex];
				}
				(*fn)(render, x, y, code, 0, color);
			}
			XOffset += GlyphAdvance;
		}
		SWF_BIT_STREAM_get_data(&bit_stream, 0); /* oCg */
	}
}

static void SWF_TEXT_draw_using_GlyphShapeTable(SWF_TEXT* self, RENDER* render, const mat2f* m) {
	SWF_BIT_STREAM bit_stream = { self->TextRecords };
	int StyleFlagsHasFont;
	int StyleFlagsHasColor;
	int StyleFlagsHasYOffset;
	int StyleFlagsHasXOffset;
	int FontId;
	SWF_FONT* font = NULL; /*x}*/
	SWF_RGBA TextColor;
	float XOffset = 0.0f; /*x}*/
	float YOffset = 0.0f; /*x}*/
	float TextHeight = 0.0f; /*x}*/
	int GlyphCount;
	int GlyphIndex;
	float GlyphAdvance;
	int i;
	int offset;
	int NumFillBits;
	int NumLineBits;
	int StraightFlag;
	int NumBits;
	float DeltaX;
	float DeltaY;
	float ControlDeltaX;
	float ControlDeltaY;
	float AnchorDeltaX;
	float AnchorDeltaY;
	int StateNewStyles;
	int StateLineStyle;
	int StateFillStyle1;
	int StateFillStyle0;
	int StateMoveTo;
	int MoveBits;
	float MoveDeltaX;
	float MoveDeltaY;
	float x = 0.0f; /*x}*/
	float y = 0.0f; /*x}*/
	int n_point;				/* _̒ʎZ */
	int n_polygon;				/* p`̐ */
	struct work {				/* _def_vbuff[]Ɋmۂ郏[NGA̍\ */
		vec2i point[1024/**/];	/* 8*1024=8192 ׂĂ̑p`̒_z */
		int polygon[256/**/];	/* 4* 256=1024 ep`̒_̐z */
	};					/* (v)=9216 _def_vbuff[11264]𒴂Ȃ */
	#define point	(((struct work*)_def_vbuff)->point)
	#define polygon	(((struct work*)_def_vbuff)->polygon)
	mat2f m1 = *m;
	mat2f m2 = {
		self->TextMatrix.ScaleX, self->TextMatrix.RotateSkew1, self->TextMatrix.TranslateX,
		self->TextMatrix.RotateSkew0, self->TextMatrix.ScaleY, self->TextMatrix.TranslateY,
	};
	mat2f_xform(&m1, &m2);

	for(;;) {
		if(!SWF_BIT_STREAM_get_UB(&bit_stream, 1)) { /* TextRecordType */
			break;
		}
		SWF_BIT_STREAM_get_UB(&bit_stream, 3); /* StyleFlagsReserved */
		StyleFlagsHasFont    = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasColor   = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasYOffset = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasXOffset = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		if(StyleFlagsHasFont) {
			FontId = SWF_BIT_STREAM_get_UI16(&bit_stream);
			font = (SWF_FONT*)SWF_DICTIONARY_get_character(FontId);
			if(font && (font->character.character_type != SWF_CHARACTER_TYPE_FONT)) {
				DIE(); /* sȃf[^ */
			}
		}
		if(StyleFlagsHasColor) {
			if(self->has_alpha) {
				SWF_BIT_STREAM_get_RGBA(&bit_stream, &TextColor);
			} else {
				SWF_BIT_STREAM_get_RGB(&bit_stream, (SWF_RGB*)&TextColor);
			}
		}
		if(StyleFlagsHasXOffset) {
			XOffset = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		if(StyleFlagsHasYOffset) {
			YOffset = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		if(StyleFlagsHasFont) {
			TextHeight = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		GlyphCount = SWF_BIT_STREAM_get_UI8(&bit_stream);
		/* GlyphEntries */
		for(i = 0; i < GlyphCount; i++) {
			GlyphIndex   = SWF_BIT_STREAM_get_UB(&bit_stream, self->GlyphBits);
			GlyphAdvance = SWF_BIT_STREAM_get_UB(&bit_stream, self->AdvanceBits) / 20.0f;
			if(font && font->OffsetTable) {
				if(font->FontFlagsWideOffsets) {
					offset = font->OffsetTable[(GlyphIndex * 4) + 0]
					       | font->OffsetTable[(GlyphIndex * 4) + 1] <<  8
					       | font->OffsetTable[(GlyphIndex * 4) + 2] << 16
					       | font->OffsetTable[(GlyphIndex * 4) + 3] << 24;
				} else {
					offset = font->OffsetTable[(GlyphIndex * 2) + 0]
					       | font->OffsetTable[(GlyphIndex * 2) + 1] <<  8;
				}
				{
					SWF_BIT_STREAM shape_bit_stream = { font->OffsetTable + offset };
					n_point = 0;
					n_polygon = 0;
					/* SHAPE */
					NumFillBits = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 4);
					NumLineBits = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 4);
					for(;;) {
						if(SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1)) { /* TypeFlag */
							StraightFlag = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							NumBits      = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 4) + 2;
							if(StraightFlag) {
								/* STRAIGHTEDGERECORD */
								if(SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1)) {          /* GeneralLineFlag */
									DeltaX = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
									DeltaY = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
								} else {
									if(SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1)) { /* VertLineFlag */
										DeltaY = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
										DeltaX = 0.0f;
									} else {
										DeltaX = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
										DeltaY = 0.0f;
									}
								}
								x += DeltaX * TextHeight;
								y += DeltaY * TextHeight;
							} else {
								/* CURVEDEDGERECORD */
								ControlDeltaX = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
								ControlDeltaY = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
								x += ControlDeltaX * TextHeight;
								y += ControlDeltaY * TextHeight;
								/* {̓xWFȐȂ̂łA蔲āA_𔲂Ďn_-I_𒼐Ōł܂Ƃɂ܂B
								 * n_-_-I_𒼐Ōԕ@܂An_-I__CNgɌԕY^H^H}VɌ悤łB
								 */
								AnchorDeltaX  = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
								AnchorDeltaY  = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
								x += AnchorDeltaX * TextHeight;
								y += AnchorDeltaY * TextHeight;
							}
							/* ݂̑p`ɒ_ǉ */
							if(n_polygon) {
								if(n_point < ARRAY_SIZE(point)) {
									vec2f v = { x, y };
									vec2f_xform(&m1, &v);
									point[n_point].x = floorf(v.x + 0.5f);
									point[n_point].y = floorf(v.y + 0.5f);
									n_point++;
									polygon[n_polygon - 1]++;
								}
							}
						} else {
							/* ݂̑p`I */
							if(n_polygon) {
								/* tHg̃VFCv́AI_n_ƓWɖ߂AIɕpXƂăf[^i[ĂB
								 * `揈ɂĂ͖ʂȂ̂ŁA(n_ƓWł͂)I_폜B
								 */
								if(polygon[n_polygon - 1]) {
									n_point--; /* YȂ!! */
									polygon[n_polygon - 1]--;
								}
								/* L̏̌ʁA_3Ȃ΁Ap`ƂĖӖȂ̂ŁȂp`LZB */
								if(polygon[n_polygon - 1] < 3) {
									n_point -= polygon[n_polygon - 1]; /* ̑p`gĂ_SĔjBYȂ!! */
									n_polygon--;
								}
							}
							StateNewStyles  = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							StateLineStyle  = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							StateFillStyle1 = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							StateFillStyle0 = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							StateMoveTo     = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							if(StateNewStyles || StateLineStyle || StateFillStyle1 || StateFillStyle0 || StateMoveTo) {
								/* STYLECHANGERECORD */
								if(StateMoveTo) {
									MoveBits   = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 5);
									MoveDeltaX = SWF_BIT_STREAM_get_SB(&shape_bit_stream, MoveBits) / 1024.0f;
									MoveDeltaY = SWF_BIT_STREAM_get_SB(&shape_bit_stream, MoveBits) / 1024.0f;
									/* - uSWF File Format Specification Version 10v136y[WfɁAȉ̐܂B
									 *   b In the first shape record MoveDeltaX and MoveDeltaY are relative to the shape origin.
									 *   b In subsequent shape records, MoveDeltaX and MoveDeltaY are relative to the current drawing position.
									 *   ̐͊ԈĂAMoveDeltaXMoveDeltaÝAɁAVFCv_̑΍WłB
									 */
									x = XOffset + MoveDeltaX * TextHeight;
									y = YOffset + MoveDeltaY * TextHeight;
								}
								if(StateFillStyle0) {
									SWF_BIT_STREAM_get_UB(&shape_bit_stream, NumFillBits); /* FillStyle0 */
								}
								if(StateFillStyle1) {
									SWF_BIT_STREAM_get_UB(&shape_bit_stream, NumFillBits); /* FillStyle1 */
								}
								if(StateLineStyle) {
									SWF_BIT_STREAM_get_UB(&shape_bit_stream, NumLineBits); /* LineStyle */
								}
								if(StateNewStyles) {
									DIE(); /* L蓾Ȃ */
								}
							} else {
								/* ENDSHAPERECORD */
								break;
							}
							/* Vp`JnB */
							if(n_polygon == ARRAY_SIZE(polygon)) {
								break;
							}
							polygon[n_polygon++] = 0;
							/* ݂̑p`ɒ_ǉ */
							if(n_point < ARRAY_SIZE(point)) {
								vec2f v = { x, y };
								vec2f_xform(&m1, &v);
								point[n_point].x = floorf(v.x + 0.5f);
								point[n_point].y = floorf(v.y + 0.5f);
								n_point++;
								polygon[n_polygon - 1]++;
							}
						}
					}
					/* ALTERNATE[hPolyPolygonƂāA` */
					if(n_polygon) { /* (' ')tHgA}`ƂĊi[悤łBXLbv܂B */
						int color = ((((TextColor.Red * 30) + (TextColor.Green * 59) + (TextColor.Blue * 11)) / 100) >> 6) ^ 3;
						render_vec2i_alternate_concaves(render, point, polygon, n_polygon, color); /* n_polygon=0ł̊֐ĂԂƃnOAbv̂Œ!! */
					}
				}
			}
			XOffset += GlyphAdvance;
		}
		SWF_BIT_STREAM_get_data(&bit_stream, 0); /* oCg */
	}

	#undef point
	#undef polygon
}

static void SWF_EDIT_TEXT_draw(SWF_EDIT_TEXT* self, RENDER* render, const mat2f* m) {
	/* * Tue Sep 08 23:06:41 JST 2009 Naoyuki Sawa
	 * - VFCvShapeBoundsAÎ~eLXgTextBoundśA`͈͂qg̖A邱Ƃł܂A
	 *   _Ci~bNeLXgBoundśAWItZbgĂA邱Ƃ͂łȂ悤łB
	 *   VFCvÎ~eLXgƈāA_Ci~bNeLXg͍sȂɁABoundsWItZbgĂ悤łB
	 * - Flash MXŃf[^ĂƁABounds.XminPlaceObjectXWꂼ傫ȒlAE悤ȃf[^邱Ƃ܂B
	 *   Bounds𖳎ƁÂ悤ȃf[^`ł܂B
	 * - Ƃ΁AFlash MXňȉ̂悤ȕҏWƂsƁAq̂悤ȃf[^܂B
	 *   1. Xe[WɁA50hbg̃tHgŁA1̃_Ci~bNeLXgzuBeLXg`́A1҂̃TCYƂB
	 *   2. EɕύXBeLXg`1҂Ȃ̂ŁAڂ͕ωȂB
	 *   3. 100hbg̃tHgɕύXBeLXg`́AɊg傳B
	 *   4. ɖ߂B
	 *   5. _Ci~bNeLXg̍WAX = 0.0, Y = 0.0 Ɠ͂B
	 *   ȏ̕ҏWsApubVƁAȉ̂悤ȃf[^܂B
	 *     DefineEditText : Rectangle = { Xmin = -1040, Xmax = 1044, Ymin = -40, Ymax = 2040 }
	 *     PlaceObject2   : Matrix    = { TranslateX = 1040, TranslateY = 40 }
	 */
	int x = floorf(self->Bounds.Xmin + m->a02 + 0.5f);
	int y = floorf(self->Bounds.Ymin + m->a12 + 0.5f);
	int color = self->color;
	unsigned int (*fn)(RENDER* render, int x, int y, const char* str, int type, int color);
	if(self->font->FontFlagsBold) {
		fn = render_string_framed;
		if(color <= 1) {
			color |= 0x330; /* {[h̑ɁAt̐Fŉ */
		}
	} else {
		fn = render_string;
	}
	(*fn)(render, x, y, self->InitialText, 0, color);
}

static void SWF_OBJECT_draw(SWF_OBJECT* self, RENDER* render, const mat2f* m) {
	mat2f m1 = *m;
	mat2f m2 = {
		self->Matrix.ScaleX, self->Matrix.RotateSkew1, self->Matrix.TranslateX,
		self->Matrix.RotateSkew0, self->Matrix.ScaleY, self->Matrix.TranslateY,
	};
	mat2f_xform(&m1, &m2);
	switch(self->character->character_type) {
	case SWF_CHARACTER_TYPE_SHAPE:
		SWF_SHAPE_draw((SWF_SHAPE*)self->character, render, &m1);
		break;
	case SWF_CHARACTER_TYPE_TEXT:
		switch(swf.text_drawing_method) {
		case 0: /* using CodeTable */
			SWF_TEXT_draw_using_CodeTable((SWF_TEXT*)self->character, render, &m1);
			break;
		case 1: /* using GlyphShapeTable */
			SWF_TEXT_draw_using_GlyphShapeTable((SWF_TEXT*)self->character, render, &m1);
			break;
		default:
			DIE(); /* swf_set_text_drawing_method()̌Ăяos */
		}
		break;
	case SWF_CHARACTER_TYPE_EDIT_TEXT:
		SWF_EDIT_TEXT_draw((SWF_EDIT_TEXT*)self->character, render, &m1);
		break;
	}
	SWF_DISPLAY_LIST_draw(&self->display_list, render, &m1);
}
#endif /*PIECE*/

/*---------------------------------------------------------------------------*/

static void SWF_OBJECT_SetBackgroundColor(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { //  9 SetBackgroundColor
	SWF_BIT_STREAM_get_RGB(bit_stream, (SWF_RGB*)&swf.swf_info.BackgroundColor);
}

static void SWF_OBJECT_DoAction(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 12 DoAction
	/* ANVXNvg͂ɎsAׂẴIuWFNg̏ShowFrameɓBŁA܂Ƃ߂ĎsdlłB
	 * ȂƁA^[QbgƂ̏ɂāAANVXNvǧʂ1t[Ȃǂ̖肪邩łB
	 */
	const unsigned char* Actions = SWF_BIT_STREAM_get_data(bit_stream, 0);
	SWF_ACTION_LIST_add_action(&self->action_list, Actions);
}

static void SWF_OBJECT_DefineShape_2_3(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream, int has_alpha) {
	int CharacterId;
	int FillStyleCount;
	int FillStyleType;
	int BitmapId;
	SWF_MATRIX BitmapMatrix;
	int LineStyleCount;
	int NumFillBits;
	int NumLineBits;
	int StraightFlag;
	int NumBits;
	int StateNewStyles;
	int StateLineStyle;
	int StateFillStyle1;
	int StateFillStyle0;
	int StateMoveTo;
	int MoveBits;
	int i;
	SWF_BITMAP* bitmap;
	SWF_SHAPE* shape;
	SWF_SHAPE* prev = NULL;

	CharacterId = SWF_BIT_STREAM_get_UI16(bit_stream);
	if(SWF_DICTIONARY_get_character(CharacterId)) {
		return; /* 1[vڂŒ`ς */
	}
	SWF_BIT_STREAM_get_RECT(bit_stream, NULL); /* ShapeBounds */
	/* Shapes */
	for(;;) {
		/* FillStyles */
		FillStyleCount = SWF_BIT_STREAM_get_UI8(bit_stream);
		if(FillStyleCount == 255) {
			FillStyleCount = SWF_BIT_STREAM_get_UI16(bit_stream); /* FillStyleCountExtended */
		}
		for(i = 0; i < FillStyleCount; i++) {
			FillStyleType = SWF_BIT_STREAM_get_UI8(bit_stream);
			switch(FillStyleType >> 4) {
			case 0: // 0x00 = solid fill
				if(has_alpha) {
					SWF_BIT_STREAM_get_RGBA(bit_stream, NULL); /* Color */
				} else {
					SWF_BIT_STREAM_get_RGB(bit_stream, NULL); /* Color */
				}
				break;
			case 1: // 0x10 = linear gradient fill, 0x12 = radial gradient fill, 0x13 = focal radial gradient fill
				return; /* Ή */
			case 4: // 0x40 = repeating bitmap fill, 0x41 = clipped bitmap fill, 0x42 = non-smoothed repeating bitmap, 0x43 = non-smoothed clipped bitmap
				BitmapId = SWF_BIT_STREAM_get_UI16(bit_stream);
				SWF_BIT_STREAM_get_MATRIX(bit_stream, &BitmapMatrix);
				BitmapMatrix.ScaleX      /= 20.0f;
				BitmapMatrix.ScaleY      /= 20.0f;
				BitmapMatrix.RotateSkew0 /= 20.0f;
				BitmapMatrix.RotateSkew1 /= 20.0f;
				bitmap = (SWF_BITMAP*)SWF_DICTIONARY_get_character(BitmapId);
				if(bitmap) {
					if(bitmap->character.character_type != SWF_CHARACTER_TYPE_BITMAP) {
						DIE(); /* sȃf[^ */
					}
					shape = calloc(1, sizeof(SWF_SHAPE));
					if(!shape) {
						DIE(); /* s */
					}
					/*{{*/
					shape->character.character_type = SWF_CHARACTER_TYPE_SHAPE;
					shape->character.CharacterId    = CharacterId;
					shape->bitmap                   = bitmap;
					shape->BitmapMatrix             = BitmapMatrix;
					/*}}*/
					InsertTailList(&swf.dictionary, &shape->character.list_entry);
					if(prev) {
						prev->next = shape;
					}
					prev = shape;
				}
				break;
			default:
				return; /* sFillStyleType */
			}
		}
		/* LineStyles */
		LineStyleCount = SWF_BIT_STREAM_get_UI8(bit_stream);
		if(LineStyleCount == 255) {
			LineStyleCount = SWF_BIT_STREAM_get_UI16(bit_stream); /* LineStyleCountExtended */
		}
		for(i = 0; i < LineStyleCount; i++) {
			SWF_BIT_STREAM_get_UI16(bit_stream); /* Width */
			if(has_alpha) {
				SWF_BIT_STREAM_get_RGBA(bit_stream, NULL); /* Color */
			} else {
				SWF_BIT_STREAM_get_RGB(bit_stream, NULL); /* Color */
			}
		}
		/* NumFillBits */
		NumFillBits = SWF_BIT_STREAM_get_UB(bit_stream, 4);
		/* NumLineBits */
		NumLineBits = SWF_BIT_STREAM_get_UB(bit_stream, 4);
		/* ShapeRecords */
		for(;;) {
			/* * Sun Jun 14 16:50:39 JST 2009 Naoyuki Sawa
			 * - uSWF File Format Specification Version 10v134y[WiɁAȉ̐܂B
			 *   b Each individual shape record is byte-aligned within an array of shape records;
			 *   b one shape record is padded to a byte boundary before the next shape record begins.
			 *   ̐ǂނƁAeShapeRecordsɑ΂ăoCg񂪕KvɎv̂łAۂɂƁAf[^ǂݍ߂܂łB
			 *   oCgsȂ΁A傤ǃ^Of[^TCYɈvēǂݍ݂ł̂ŁAoCgsȂ̂̂悤łB
			 * - u#afunikki(http://afunishi.blog69.fc2.com/)v́A2008/11/20̋L(http://afunishi.blog69.fc2.com/blog-entry-360.html)ɁA
			 *   ̌Ă܂BpĂ܂B
			 *   b swfdlShape Records̐
			 *   b   Each individual shape record is byte-aligned within an array of shape records;
			 *   b   one shape record is padded to a byte boundary before the next shape record begins. 
			 *   b ƏĂ܂Aۂ̂ƂAR[h[ȂƂŏIĂÂ܂ܑĎ̃R[h̃rbguĂāA
			 *   b Ō end R[ȟゾʂbyte-aligned ɂOKłB
			 *   b swf version7̎dlɂ͓̋LqȂ̂łÃ~XȂ̂ȁH
			 *   ͂AeShapeRecordsɑ΂ăoCgsȂ̂̂悤łB
			 */
			//SWF_BIT_STREAM_get_data(bit_stream, 0);  eShapeRecordsɑ΂ăoCgsĂ͂ȂBLRgQƁB
			{
				if(SWF_BIT_STREAM_get_UB(bit_stream, 1)) { /* TypeFlag */
					StraightFlag = SWF_BIT_STREAM_get_UB(bit_stream, 1);
					NumBits      = SWF_BIT_STREAM_get_UB(bit_stream, 4) + 2;
					if(StraightFlag) {
						/* STRAIGHTEDGERECORD */
						if(SWF_BIT_STREAM_get_UB(bit_stream, 1)) {          /* GeneralLineFlag */
							SWF_BIT_STREAM_get_SB(bit_stream, NumBits); /* DeltaX */
							SWF_BIT_STREAM_get_SB(bit_stream, NumBits); /* DeltaY */
						} else {
							SWF_BIT_STREAM_get_UB(bit_stream, 1);       /* VertLineFlag */
							SWF_BIT_STREAM_get_SB(bit_stream, NumBits); /* DeltaX or DeltaY */
						}
					} else {
						/* CURVEDEDGERECORD */
						SWF_BIT_STREAM_get_SB(bit_stream, NumBits); /* ControlDeltaX */
						SWF_BIT_STREAM_get_SB(bit_stream, NumBits); /* ControlDeltaY */
						SWF_BIT_STREAM_get_SB(bit_stream, NumBits); /* AnchorDeltaX */
						SWF_BIT_STREAM_get_SB(bit_stream, NumBits); /* AnchorDeltaY */
					}
				} else {
					StateNewStyles  = SWF_BIT_STREAM_get_UB(bit_stream, 1);
					StateLineStyle  = SWF_BIT_STREAM_get_UB(bit_stream, 1);
					StateFillStyle1 = SWF_BIT_STREAM_get_UB(bit_stream, 1);
					StateFillStyle0 = SWF_BIT_STREAM_get_UB(bit_stream, 1);
					StateMoveTo     = SWF_BIT_STREAM_get_UB(bit_stream, 1);
					if(StateNewStyles || StateLineStyle || StateFillStyle1 || StateFillStyle0 || StateMoveTo) {
						/* STYLECHANGERECORD */
						if(StateMoveTo) {
							MoveBits = SWF_BIT_STREAM_get_UB(bit_stream, 5);
							SWF_BIT_STREAM_get_SB(bit_stream, MoveBits); /* MoveDeltaX */
							SWF_BIT_STREAM_get_SB(bit_stream, MoveBits); /* MoveDeltaY */
						}
						if(StateFillStyle0) {
							SWF_BIT_STREAM_get_UB(bit_stream, NumFillBits); /* FillStyle0 */
						}
						if(StateFillStyle1) {
							SWF_BIT_STREAM_get_UB(bit_stream, NumFillBits); /* FillStyle1 */
						}
						if(StateLineStyle) {
							SWF_BIT_STREAM_get_UB(bit_stream, NumLineBits); /* LineStyle */
						}
						if(StateNewStyles) {
							break; /* FillStyles,LineStyles,NumFillBits,NumLineBits */
						}
					} else {
						/* ENDSHAPERECORD */
						return;
					}
				}
			}
			//SWF_BIT_STREAM_get_data(bit_stream, 0);  eShapeRecordsɑ΂ăoCgsĂ͂ȂBLRgQƁB
		}
	}
}

static void SWF_OBJECT_DefineShape(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { //  2 DefineShape
	SWF_OBJECT_DefineShape_2_3(self, bit_stream, 0/*has_alpha*/);
}

static void SWF_OBJECT_DefineShape2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 22 DefineShape2
	SWF_OBJECT_DefineShape_2_3(self, bit_stream, 0/*has_alpha*/);
}

static void SWF_OBJECT_DefineShape3(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 32 DefineShape3
	SWF_OBJECT_DefineShape_2_3(self, bit_stream, 1/*has_alpha*/);
}

static void SWF_OBJECT_DefineBitsLossless_2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream, int has_alpha) {
	int CharacterId;
	int BitmapFormat;
	int BitmapWidth;
	int BitmapHeight;
	int BitmapColorTableSize;
	const unsigned char* ZlibBitmapData;
	unsigned char* ColorTableRGB;   /*  RGB or RGBA */
	unsigned char* BitmapPixelData; /* xRGB or ARGB */
	int BitmapWidth4;
	int BitmapWidth8;
	int x;
	int y;
	int c;
	int len;
	int outlen;
	int components;
	SURFACE* surface;
	unsigned char* dst;
	unsigned char* src;

	CharacterId = SWF_BIT_STREAM_get_UI16(bit_stream);
	if(SWF_DICTIONARY_get_character(CharacterId)) {
		return; /* 1[vڂŒ`ς */
	}
	BitmapFormat = SWF_BIT_STREAM_get_UI8(bit_stream);
	BitmapWidth  = SWF_BIT_STREAM_get_UI16(bit_stream);
	BitmapHeight = SWF_BIT_STREAM_get_UI16(bit_stream);
	BitmapWidth8 = (BitmapWidth + 7) & ~7; /* PIECE_BMP̎dl̂߁A8sNZ̔{ɐ؂グ */
	surface = malloc(sizeof(SURFACE) + (BitmapWidth8 * BitmapHeight)/*vbuff*/);
	if(!surface) {
		DIE(); /* s */
	}
	surface->w = BitmapWidth8;
	surface->h = BitmapHeight;
	surface->vbuff = (unsigned char*)(surface + 1);

	switch(BitmapFormat) {
	case 3: // 8-bit colormapped image
		BitmapColorTableSize = SWF_BIT_STREAM_get_UI8(bit_stream) + 1;
		ZlibBitmapData       = SWF_BIT_STREAM_get_data(bit_stream, 0);
		BitmapWidth4 = (BitmapWidth + 3) & ~3; /* DefineBitsLossless(2)̎dl̂߁A4oCg̔{ɐ؂グ */
		components = has_alpha ? 4/*RGBA*/ : 3/*RGB*/;
		len = (components * BitmapColorTableSize)/*ColorTableRGB*/ + (BitmapWidth4 * BitmapHeight)/*ColormapPixelData*/;
		ColorTableRGB = malloc(len);
		if(!ColorTableRGB) {
			DIE(); /* s */
		}
		outlen = zlib_uncompress(ColorTableRGB, len, ZlibBitmapData, (INT_MAX / 8 - 1)/*don't care*/);
		if(outlen != len) {
			DIE(); /* sȃf[^ */
		}
		src = ColorTableRGB + (components * BitmapColorTableSize); /* ColormapPixelData */
		dst = surface->vbuff;
		for(y = 0; y < BitmapHeight; y++) {
			for(x = 0; x < BitmapWidth8; x++) {
				c = 4/**/;
				if(x < BitmapWidth4) {
					int i = *src++;
					if(x < BitmapWidth) {
						unsigned char* p = &ColorTableRGB[components * i];
						int Red   = *p++;
						int Green = *p++;
						int Blue  = *p++;
						if(!has_alpha || *p/*Alpha*/) {
							c = ((((Red * 30) + (Green * 59) + (Blue * 11)) / 100) >> 6) ^ 3;
						}
					}
				}
				*dst++ = c;
			}
		}
		free(ColorTableRGB); /* YȂ!! */
		break;
	case 4: // 15-bit RGB image
		DIE(); /* Ή */
	case 5: // 24-bit RGB image or 32-bit ARGB image
		ZlibBitmapData = SWF_BIT_STREAM_get_data(bit_stream, 0);
		len = 4/*xRGB or ARGB*/ * (BitmapWidth * BitmapHeight); /* BitmapPixelData */
		BitmapPixelData = malloc(len);
		if(!BitmapPixelData) {
			DIE(); /* s */
		}
		outlen = zlib_uncompress(BitmapPixelData, len, ZlibBitmapData, (INT_MAX / 8 - 1)/*don't care*/);
		if(outlen != len) {
			DIE(); /* sȃf[^ */
		}
		src = BitmapPixelData;
		dst = surface->vbuff;
		for(y = 0; y < BitmapHeight; y++) {
			for(x = 0; x < BitmapWidth8; x++) {
				c = 4/**/;
				if(x < BitmapWidth) {
					int Alpha = *src++; /* or Pix24Reserved (Always 0) */
					int Red   = *src++;
					int Green = *src++;
					int Blue  = *src++;
					if(!has_alpha || Alpha) {
						c = ((((Red * 30) + (Green * 59) + (Blue * 11)) / 100) >> 6) ^ 3;
					}
				}
				*dst++ = c;
			}
		}
		free(BitmapPixelData); /* YȂ!! */
		break;
	default:
		DIE(); /* sȃf[^ */
	}

	SWF_DICTIONARY_new_bitmap(CharacterId, surface);
	free(surface); /* YȂ!! */
}

static void SWF_OBJECT_DefineBitsLossless(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 20 DefineBitsLossless
	SWF_OBJECT_DefineBitsLossless_2(self, bit_stream, 0/*has_alpha*/);
}

static void SWF_OBJECT_DefineBitsLossless2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 36 DefineBitsLossless2
	SWF_OBJECT_DefineBitsLossless_2(self, bit_stream, 1/*has_alpha*/);
}

typedef struct _SWF_OBJECT_DefineBits_JPEG2_3_USER_DATA {
	SURFACE* surface;
	const unsigned char* ImageData;
	const unsigned char* BitmapAlphaData;
} SWF_OBJECT_DefineBits_JPEG2_3_USER_DATA;

static void SWF_OBJECT_DefineBits_JPEG2_3_size_proc(int w, int h, void* _user_data) {
	SWF_OBJECT_DefineBits_JPEG2_3_USER_DATA* user_data = _user_data;
	int w8 = (w + 7) & ~7; /* PIECE_BMP̎dl̂߁A8sNZ̔{ɐ؂グ */
	int x;
	int y;
	int c;
	int outlen;
	unsigned char* dst;
	unsigned char* src;

	if(user_data->surface) {
		DIE(); /* sȃf[^ */
	}
	user_data->surface = malloc(sizeof(SURFACE) + (w8 * h)/*vbuff*/);
	if(!user_data->surface) {
		DIE(); /* s */
	}
	user_data->surface->w = w8;
	user_data->surface->h = h;
	user_data->surface->vbuff = (unsigned char*)(user_data->surface + 1);

	dst = user_data->surface->vbuff;
	if(user_data->BitmapAlphaData) { // 35 DefineBitsJPEG3
		src = &user_data->surface->vbuff[(w8 - w) * h]; /* l߂œWJ */
		outlen = zlib_uncompress(src, w * h, user_data->BitmapAlphaData, (INT_MAX / 8 - 1)/*don't care*/);
		if(outlen != w * h) {
			DIE(); /* sȃf[^ */
		}
		for(y = 0; y < h; y++) {
			for(x = 0; x < w8; x++) {
				if(x < w) {
					c = *src++;
					c = c ? 0/*s*/ : 4/**/;
				} else {
					c = 4/**/;
				}
				*dst++ = c;
			}
		}
	} else { // 21 DefineBitsJPEG2
		for(y = 0; y < h; y++) {
			for(x = 0; x < w8; x++) {
				*dst++ = (x < w) ? 0/*s*/ : 4/**/;
			}
		}
	}
}

static void SWF_OBJECT_DefineBits_JPEG2_3_draw_proc(int x, int y, int c, void* _user_data) {
	SWF_OBJECT_DefineBits_JPEG2_3_USER_DATA* user_data = _user_data;
	unsigned char* p = &user_data->surface->vbuff[user_data->surface->w * y + x];
	if(*p == 0/*s*/) {
		*p = (c >> 6) ^ 3;
	}
}

static const void* SWF_OBJECT_DefineBits_JPEG2_3_data_proc(const void* data_ptr, void* _user_data) {
	SWF_OBJECT_DefineBits_JPEG2_3_USER_DATA* user_data = _user_data;
	/* 摜WJĂAf[^pȂB
	 * VSWFt@CDefineBitsJPEG2(3)̏ꍇ́Axf[^pɁA摜WJ͂łB
	 * DefineBitsA܂́AÂSWFt@CDefineBitsJPEG2(3)̏ꍇ́Axf[^pƂɁA摜WJ͂łB
	 */
	if(user_data->surface) {
		return NULL;
	}
	/* DefineBits̏ꍇAJPEGTablesJPEGData(SOI`DQT`DHT`EOI)ADefineBitsImageData(SOI`SOF0`SOS`EOI)֐؂ւB */
	if(user_data->ImageData) {
		return user_data->ImageData;
	}
	/* ÂDefineBitsJPEG2(3)̏ꍇ́AImageDatȃOSOI`DQT`DHT`EOI܂܂Ă炸A摜WJŃR[obNB
	 * ̏ꍇ́AImageDatǎ㔼SOI`SOF0`SOS`EOIȂ̂ŁAImageDatȃOI|C^̂܂܎gāAf[^pB
	 */
	return data_ptr;
}

static void SWF_OBJECT_DefineBits_JPEG2_3(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream, int has_alpha, const unsigned char* JPEGData) {
	int CharacterId;
	int AlphaDataOffset;
	const unsigned char* ImageData;
	const unsigned char* BitmapAlphaData;
	SWF_OBJECT_DefineBits_JPEG2_3_USER_DATA user_data;

	CharacterId = SWF_BIT_STREAM_get_UI16(bit_stream);
	if(SWF_DICTIONARY_get_character(CharacterId)) {
		return; /* 1[vڂŒ`ς */
	}
	AlphaDataOffset = has_alpha ? SWF_BIT_STREAM_get_SI32(bit_stream) : 0;
	ImageData       =             SWF_BIT_STREAM_get_data(bit_stream, AlphaDataOffset);
	BitmapAlphaData = has_alpha ? SWF_BIT_STREAM_get_data(bit_stream, 0) : NULL;

	/* SWF́Am̕sBJPEG SOI}[J[̑OɁA]EOI}[J[ĂꍇB */
	if((ImageData[0] == 0xFF) && (ImageData[1] == 0xD9)) { /* EOI */
		ImageData += 2;
	}
	if((ImageData[0] != 0xFF) || (ImageData[1] != 0xD8)) { /* SOI */
		DIE(); /* sȃf[^ */
	}

	memset(&user_data, 0, sizeof user_data);
	user_data.BitmapAlphaData = BitmapAlphaData;
	if(JPEGData) {
		/* DefineBits̏ꍇAJPEGDataImageDataփf[^pB */
		user_data.ImageData = ImageData;
		jpeg_decode(JPEGData, 0/*Y component*/,
			SWF_OBJECT_DefineBits_JPEG2_3_size_proc,
			SWF_OBJECT_DefineBits_JPEG2_3_draw_proc,
			SWF_OBJECT_DefineBits_JPEG2_3_data_proc, &user_data);
	} else {
		/* DefineBitsJPEG2(3)̏ꍇAImageDatȃO㔼փf[^pB(Kvɉ) */
		jpeg_decode(ImageData, 0/*Y component*/,
			SWF_OBJECT_DefineBits_JPEG2_3_size_proc,
			SWF_OBJECT_DefineBits_JPEG2_3_draw_proc,
			SWF_OBJECT_DefineBits_JPEG2_3_data_proc, &user_data);
	}
	if(!user_data.surface) {
		DIE(); /* sȃf[^ */
	}

	SWF_DICTIONARY_new_bitmap(CharacterId, user_data.surface);
	free(user_data.surface); /* YȂ!! */
}

static void SWF_OBJECT_JPEGTables(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { //  8 JPEGTables
	const unsigned char* JPEGData = SWF_BIT_STREAM_get_data(bit_stream, 0);
	/* SWF́Am̕sBJPEG SOI}[J[̑OɁA]EOI}[J[ĂꍇB */
	if((JPEGData[0] == 0xFF) && (JPEGData[1] == 0xD9)) { /* EOI */
		JPEGData += 2;
	}
	if((JPEGData[0] != 0xFF) || (JPEGData[1] != 0xD8)) { /* SOI */
		DIE(); /* sȃf[^ */
	}
	swf.JPEGData = JPEGData;
}

static void SWF_OBJECT_DefineBits(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { //  6 DefineBits
	SWF_OBJECT_DefineBits_JPEG2_3(self, bit_stream, 0/*has_alpha*/, swf.JPEGData);
}

static void SWF_OBJECT_DefineBitsJPEG2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 21 DefineBitsJPEG2
	SWF_OBJECT_DefineBits_JPEG2_3(self, bit_stream, 0/*has_alpha*/, NULL/*JPEGData*/);
}

static void SWF_OBJECT_DefineBitsJPEG3(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 35 DefineBitsJPEG3
	SWF_OBJECT_DefineBits_JPEG2_3(self, bit_stream, 1/*has_alpha*/, NULL/*JPEGData*/);
}

static void SWF_OBJECT_PlaceObject2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 26 PlaceObject2
	int PlaceFlagHasName;
	int PlaceFlagHasRatio;
	int PlaceFlagHasColorTransform;
	int PlaceFlagHasMatrix;
	int PlaceFlagHasCharacter;
	int PlaceFlagMove;
	int Depth;
	SWF_CHARACTER* character;
	SWF_OBJECT* object;

	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* PlaceFlagHasClipActions */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* PlaceFlagHasClipDepth */
	PlaceFlagHasName           = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	PlaceFlagHasRatio          = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	PlaceFlagHasColorTransform = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	PlaceFlagHasMatrix         = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	PlaceFlagHasCharacter      = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	PlaceFlagMove              = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	Depth                      = SWF_BIT_STREAM_get_UI16(bit_stream);

	if(PlaceFlagHasCharacter) {
		int CharacterId = SWF_BIT_STREAM_get_UI16(bit_stream);
		character = SWF_DICTIONARY_get_character(CharacterId);
		if(!character) {
			return; /* ` */
		}
	} else {
		character = NULL;
	}
	object = SWF_DISPLAY_LIST_get_object(&self->display_list, Depth);

	/* Xe[WɃV{uuԂ̏ꍇ */
	if(!PlaceFlagMove) {
		/* uƂ́ALN^K{łB{PlaceFlagMove=0,PlaceFlagHasCharacter=0}́ASWF̎dlᔽłB */
		if(!character) {
			return; /* sȃf[^ */
		}
		/* EndŃ[vɁADepthœXvCguAEnd̃^CCƃfBXvCXgp܂B */
		if(object && (object->object_state & SWF_OBJECT_STATE_END) &&
		  (object->character == character) && (character->character_type == SWF_CHARACTER_TYPE_SPRITE)) {
			object->object_state &= ~SWF_OBJECT_STATE_END;
		/* ȊO̒ʏ펞́AɂDepth̃IuWFNgL邩ɂ炸ADepth̃IuWFNgVK쐬܂B
		 * ɂDepth̃IuWFNgLꍇAfBXvCXgɓDepth̃IuWFNgł܂A\܂B
		 * {̃tbVvC[AłB
		 */
		} else {
			object = SWF_DISPLAY_LIST_new_object(&self->display_list, Depth);
			object->parent    = self;
			object->character = character;
			if(character->character_type == SWF_CHARACTER_TYPE_SPRITE) {
				object->object_state      |= SWF_OBJECT_STATE_PLAY;
				object->bit_stream.data    = ((SWF_SPRITE*)character)->ControlTags;
				object->bit_stream.bit_pos = 0; /* 0Ȃ̂ŏȗĂ\Ȃ */
			}
		}
	/* ɒuĂV{ړAOtBbNV{ŃLN^̍ւꍇ */
	} else {
		/* ɂDepth̃IuWFNgL͂łB
		 * t[WvɑΉꍇ́AȂꍇ͐VK쐬ׂm܂B
		 */
		if(!object) {
			return; /* ` */
		}
		/* OtBbNV{ŃLN^̍ւꍇ */
		if(character) {
			/* ݂̃LN^ƕωĂAւ܂B */
			if(object->character != character) {
				object->character = character;
				if(character->character_type == SWF_CHARACTER_TYPE_SPRITE) {
					object->object_state      |= SWF_OBJECT_STATE_PLAY;
					object->bit_stream.data    = ((SWF_SPRITE*)character)->ControlTags;
					object->bit_stream.bit_pos = 0;    /* ͕Kvł!! */
				} else {
					object->object_state      &= ~SWF_OBJECT_STATE_PLAY;
					object->bit_stream.data    = NULL; /* ӖȂ̂ŏȗĂ\Ȃ */
					object->bit_stream.bit_pos = 0;    /* ӖȂ̂ŏȗĂ\Ȃ */
				}
				/* ǂ̍ւp^[łAւ̃IuWFNg̃fBXvCXg͋Ƃ܂B
				 * EXvCgʂ̃XvCg
				 * EXvCgXvCg
				 * EXvCgXvCg  (ɋȂ̂Ń_~[)
				 * EXvCgXvCg(ɋȂ̂Ń_~[)
				 * AXvCg̍ւL蓾̂ǂAvmFłB
				 * ȂƂAOtBbNV{̍ւ@\́AXvCgɑΉĂ܂B
				 * AXvCg̍ւL蓾Ȃꍇ́ÃXvCgR[hsvłB
				 */
				SWF_DISPLAY_LIST_free(&object->display_list);
			}
		}
	}

	if(PlaceFlagHasMatrix) {
		SWF_BIT_STREAM_get_MATRIX(bit_stream, &object->Matrix);
	}
	if(PlaceFlagHasColorTransform) {
		SWF_BIT_STREAM_get_CXFORMWITHALPHA(bit_stream, NULL); /* ColorTransform */
	}
	if(PlaceFlagHasRatio) {
		SWF_BIT_STREAM_get_UI16(bit_stream); /* Ratio */
	}
	if(PlaceFlagHasName) {
		object->Name = SWF_BIT_STREAM_get_STRING(bit_stream);
	}
}

static void SWF_OBJECT_RemoveObject2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 28 RemoveObject2
	int Depth = SWF_BIT_STREAM_get_UI16(bit_stream);
	SWF_OBJECT* object = SWF_DISPLAY_LIST_get_object(&self->display_list, Depth);
	if(object) {
		SWF_OBJECT_free(object);
	}
}

#ifndef PIECE
static void SWF_TEXT_dump_using_CodeTable(SWF_TEXT* self) {
	SWF_BIT_STREAM bit_stream = { self->TextRecords };
	int StyleFlagsHasFont;
	int StyleFlagsHasColor;
	int StyleFlagsHasYOffset;
	int StyleFlagsHasXOffset;
	int FontId;
	SWF_FONT* font = NULL; /*x}*/
	SWF_RGBA TextColor;
	float XOffset = 0.0f; /*x}*/
	float YOffset = 0.0f; /*x}*/
	float TextHeight = 0.0f; /*x}*/
	int GlyphCount;
	int GlyphIndex;
	float GlyphAdvance;
	int i;
	int code;

	/*---------------------------------------------------------------------------*/
	HDC hDC;
	int ImageWidth;
	int ImageHeight;
	unsigned char (*ImageData)[4/*BGRA*/];
	LOGFONT lf;
	HFONT hFont;
	/* DC쐬 */
	hDC = CreateCompatibleDC(NULL);
	if(!hDC) {
		DIE();
	}
	/* C[Wf[^m */
	ImageWidth  = ceil(self->TextBounds.Xmax - self->TextBounds.Xmin);
	ImageHeight = ceil(self->TextBounds.Ymax - self->TextBounds.Ymin);
	ImageData = calloc(1, ImageWidth * ImageHeight * 4/*BGRA*/);
	if(!ImageData) {
		DIE();
	}
	/*---------------------------------------------------------------------------*/
	for(;;) {
		if(!SWF_BIT_STREAM_get_UB(&bit_stream, 1)) { /* TextRecordType */
			break;
		}
		SWF_BIT_STREAM_get_UB(&bit_stream, 3); /* StyleFlagsReserved */
		StyleFlagsHasFont    = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasColor   = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasYOffset = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasXOffset = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		if(StyleFlagsHasFont) {
			FontId = SWF_BIT_STREAM_get_UI16(&bit_stream);
			font = (SWF_FONT*)SWF_DICTIONARY_get_character(FontId);
			if(font && (font->character.character_type != SWF_CHARACTER_TYPE_FONT)) {
				DIE(); /* sȃf[^ */
			}
		}
		if(StyleFlagsHasColor) {
			if(self->has_alpha) {
				SWF_BIT_STREAM_get_RGBA(&bit_stream, &TextColor);
			} else {
				SWF_BIT_STREAM_get_RGB(&bit_stream, (SWF_RGB*)&TextColor);
				TextColor.Alpha = 255;
			}
		}
		if(StyleFlagsHasXOffset) {
			XOffset = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		if(StyleFlagsHasYOffset) {
			YOffset = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		if(StyleFlagsHasFont) {
			TextHeight = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		GlyphCount = SWF_BIT_STREAM_get_UI8(&bit_stream);
		/*---------------------------------------------------------------------------*/
		if(font) {
			/* tHg쐬 */
			memset(&lf, 0, sizeof lf);
			lf.lfHeight = TextHeight;
			if(font->FontFlagsBold) {
				lf.lfWeight = FW_BOLD;
			}
			if(font->FontFlagsItalic) {
				lf.lfItalic = TRUE;
			}
			lf.lfCharSet = DEFAULT_CHARSET; /* tHgŌBDEFAULT_CHARSET0ł͂Ȃ1Ȃ̂ŖK{! */
			//lf.lfQuality = ANTIALIASED_QUALITY;  GetGlyphOutline()gꍇ́AɃA`GAX̂ŕsv
			memcpy(lf.lfFaceName, font->FontName, font->FontNameLen);
			hFont = CreateFontIndirect(&lf);
			if(!hFont) {
				DIE();
			}
			/* tHgI */
			hFont = SelectObject(hDC, hFont);
			if(!hFont) {
				DIE();
			}
		}
		/*---------------------------------------------------------------------------*/
		/* GlyphEntries */
		for(i = 0; i < GlyphCount; i++) {
			GlyphIndex   = SWF_BIT_STREAM_get_UB(&bit_stream, self->GlyphBits);
			GlyphAdvance = SWF_BIT_STREAM_get_UB(&bit_stream, self->AdvanceBits) / 20.0f;
			if(font && font->CodeTable) {
				if(font->FontFlagsWideCodes) {
					code = font->CodeTable[(GlyphIndex * 2) + 0] | font->CodeTable[(GlyphIndex * 2) + 1] << 8;
				} else {
					code = font->CodeTable[GlyphIndex];
				}
				/*---------------------------------------------------------------------------*/
				{
					static const MAT2 mat2 = {{0,1},{0,0},{0,0},{0,1}}; /* Pʍs */
					TEXTMETRIC tm;
					GLYPHMETRICS gm;
					int size;
					unsigned char* buffer;
					int pitch;
					int sx;
					int sy;
					int dx;
					int dy;
					/* tHg̏擾 */
					GetTextMetrics(hDC, &tm);
					/* obt@TCY擾 */
					size = GetGlyphOutline(hDC, code, GGO_GRAY8_BITMAP, &gm, 0, NULL, &mat2);
					/* obt@m */
					buffer = calloc(size, 1);
					if(!buffer) {
						DIE();
					}
					/* rbg}bv擾 */
					GetGlyphOutline(hDC, code, GGO_GRAY8_BITMAP, &gm, size, buffer, &mat2);
					/* CTCY߂ */
					pitch = (gm.gmBlackBoxX + 3) & ~3;
					/* rbg}bv̊esNZɂāc */
					for(sy = 0; sy < (int)gm.gmBlackBoxY; sy++) {
						for(sx = 0; sx < (int)gm.gmBlackBoxX; sx++) {
							/* rbg}bṽAt@l擾 */
							int a = buffer[sy * pitch + sx];
							/* [0`64][0`255]ɕϊ */
							a = a * 255 / 64/*GGO_GRAY8_BITMAP̍ől*/;
							/* eLXgJ[̃At@l|킹 */
							a = a * TextColor.Alpha / 255;
							/* SłȂ΁c */
							if(a) {
								/* rbg}bṽsNZʒuɑΉAC[W̃sNZʒu߂B
								 * - Flash MXswfƁACAEg񖳂ŁAx[XCYWɂȂ̂ŁAɓ_͂܂B
								 *   Ƃ낪ASuzukaswfƁACAEgLŁAFontDescent=1024A܂A[YWɂȂ܂B
								 *   Suzukaōswf̐Î~eLXg\邽߂ɁADefineFont2̃CAEgɑΉ𓾂܂łB
								 * - ȉ̌vŹAsŒ̂łBԈĂ邩m܂B
								 */
								dx = floor(XOffset + gm.gmptGlyphOrigin.x + sx - self->TextBounds.Xmin + self->TextMatrix.TranslateX + 0.5f); /* TextMatrix̊gk]͖Ή */
								dy = floor(YOffset - gm.gmptGlyphOrigin.y + sy - self->TextBounds.Ymin + self->TextMatrix.TranslateY + 0.5f); /* TextMatrix̊gk]͖Ή */
								if(font->FontFlagsHasLayout) { /* CAEgL */
									dy += tm.tmHeight * font->FontDescent - tm.tmDescent;
								}
								/* C[W͈͓̔Ȃ΁AeLXgJ[Ńvbg */
								if((dx >= 0) && (dx <= ImageWidth  - 1) && (dy >= 0) && (dy <= ImageHeight - 1)) {
									int j = (ImageHeight - 1 - dy)/*TGA͉オW*/ * ImageWidth + dx;
									ImageData[j][0] = TextColor.Blue;
									ImageData[j][1] = TextColor.Green;
									ImageData[j][2] = TextColor.Red;
									ImageData[j][3] = a;
								}
							}
						}
					}
					/* obt@J */
					free(buffer);
				}
				/*---------------------------------------------------------------------------*/
			}
			XOffset += GlyphAdvance;
		}
		SWF_BIT_STREAM_get_data(&bit_stream, 0); /* oCg */
		/*---------------------------------------------------------------------------*/
		if(font) {
			/* tHgI */
			hFont = SelectObject(hDC, hFont);
			if(!hFont) {
				DIE();
			}
			/* tHg폜 */
			DeleteObject(hFont);
		}
		/*---------------------------------------------------------------------------*/
	}
	/*---------------------------------------------------------------------------*/
	/* C[WZ[u */
	{
		FILE* fp;
		char fname[_MAX_FNAME];
		unsigned char TGAFileHeader[18] = {
			0x00,		// + 0,1 ID Length
			0x00,		// + 1,1 Color Map Type
			0x02,		// + 2,1 Image Type
			0x00, 0x00,	// + 3,2 First Entry Index
			0x00, 0x00,	// + 5,2 Color map Length
			0x00,		// + 7,1 Color map Entry Size
			0x00, 0x00,	// + 8,2 X origin of Image
			0x00, 0x00,	// +10,2 Y origin of Image
			0x80, 0x02,	// +12,2 Image Width
			0x90, 0x01,	// +14,2 Image Height
			0x20,		// +16,1 Pixel Depth
			0x08,		// +17,1 Image Descriptor
		};			// =18
		sprintf(fname, "text%04x.tga", self->character.CharacterId);
		fp = fopen(fname, "wb");
		if(!fp) {
			DIE();
		}
		*(short*)&TGAFileHeader[12] = ImageWidth;
		*(short*)&TGAFileHeader[14] = ImageHeight;
		fwrite(TGAFileHeader, 1, sizeof TGAFileHeader, fp);
		fwrite(ImageData, 1, ImageWidth * ImageHeight * 4/*BGRA*/, fp);
		fclose(fp);
	}
	/* C[Wf[^J */
	free(ImageData);
	/* DC폜 */
	DeleteDC(hDC);
	/*---------------------------------------------------------------------------*/
}
static void SWF_TEXT_dump_using_GlyphShapeTable(SWF_TEXT* self) {
	SWF_BIT_STREAM bit_stream = { self->TextRecords };
	int StyleFlagsHasFont;
	int StyleFlagsHasColor;
	int StyleFlagsHasYOffset;
	int StyleFlagsHasXOffset;
	int FontId;
	SWF_FONT* font = NULL; /*x}*/
	SWF_RGBA TextColor;
	float XOffset = 0.0f; /*x}*/
	float YOffset = 0.0f; /*x}*/
	float TextHeight;
	int GlyphCount;
	int GlyphIndex;
	float GlyphAdvance;
	int i;
	int offset;
	int NumFillBits;
	int NumLineBits;
	int StraightFlag;
	int NumBits;
	float DeltaX;
	float DeltaY;
	float ControlDeltaX;
	float ControlDeltaY;
	float AnchorDeltaX;
	float AnchorDeltaY;
	int StateNewStyles;
	int StateLineStyle;
	int StateFillStyle1;
	int StateFillStyle0;
	int StateMoveTo;
	int MoveBits;
	float MoveDeltaX;
	float MoveDeltaY;
	float x = 0.0f; /*x}*/
	float y = 0.0f; /*x}*/
	int n_point;			/* _̒ʎZ */
	int n_polygon;			/* p`̐ */
	POINT point[1024/**/];	/* ׂĂ̑p`̒_z */
	int polygon[256/**/];	/* ep`̒_̐z */

	/*---------------------------------------------------------------------------*/
	HDC hDC;
	BITMAPINFOHEADER bi;
	unsigned char (*ImageData)[4/*BGRA*/];
	HBITMAP hBitmap;
	HPEN hPen;
	HBRUSH hBrush;
	/* DC쐬 */
	hDC = CreateCompatibleDC(NULL);
	if(!hDC) {
		DIE();
	}
	/* DIBZNV쐬 */
	memset(&bi, 0, sizeof bi);
	bi.biSize     = sizeof(BITMAPINFOHEADER);
	bi.biWidth    = ceil(self->TextBounds.Xmax - self->TextBounds.Xmin);
	bi.biHeight   = ceil(self->TextBounds.Ymax - self->TextBounds.Ymin);
	bi.biPlanes   = 1;
	bi.biBitCount = 32;
	hBitmap = CreateDIBSection(hDC, (BITMAPINFO*)&bi, DIB_RGB_COLORS, (void**)&ImageData, NULL, 0);
	if(!hBitmap) {
		DIE();
	}
	/* DIBZNVI */
	SelectObject(hDC, hBitmap);
	/* 32rbgDIB̊esNZ4oCgڂ́ÃsNZ`悳ꂽƂɁA0ݒ肳悤łB(Undoc'd)
	 * ̐𗘗pA炩0ȊO̒lłƂŁAǂ̃sNZ`悳ꂽoł܂B
	 */
	memset(ImageData, -1, bi.biWidth * bi.biHeight * 4/*BGRA*/);
	/* hׂ[h݃[hɐݒ
	 * * Wed Sep 09 04:15:45 JST 2009 Naoyuki Sawa
	 * - DefineFont(2)̃VFCv́Ah[ic^̏ꍇAȎp`EȂp`ŏo͂悤łB
	 *   OƓ̉tł邽߁ASetPolyFillMode()ALTERNATEɂĂWINDINGɂĂA`挋ʂƂȂ܂B
	 *   WINDINǴAt̑p`dȂĂ镔AhׂȂłB
	 *   AqDefineFont(2)̃VFCv̏o͎dlmFłȂ߁AALTERNATEŕ`mƎv܂B
	 */
	//SetPolyFillMode(hDC, ALTERNATE);  ݒALTERNATEɂȂĂ̂Őݒsv
	/*---------------------------------------------------------------------------*/
	for(;;) {
		if(!SWF_BIT_STREAM_get_UB(&bit_stream, 1)) { /* TextRecordType */
			break;
		}
		SWF_BIT_STREAM_get_UB(&bit_stream, 3); /* StyleFlagsReserved */
		StyleFlagsHasFont    = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasColor   = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasYOffset = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		StyleFlagsHasXOffset = SWF_BIT_STREAM_get_UB(&bit_stream, 1);
		if(StyleFlagsHasFont) {
			FontId = SWF_BIT_STREAM_get_UI16(&bit_stream);
			font = (SWF_FONT*)SWF_DICTIONARY_get_character(FontId);
			if(font && (font->character.character_type != SWF_CHARACTER_TYPE_FONT)) {
				DIE(); /* sȃf[^ */
			}
		}
		if(StyleFlagsHasColor) {
			if(self->has_alpha) {
				SWF_BIT_STREAM_get_RGBA(&bit_stream, &TextColor);
			} else {
				SWF_BIT_STREAM_get_RGB(&bit_stream, (SWF_RGB*)&TextColor);
				TextColor.Alpha = 255;
			}
		}
		if(StyleFlagsHasXOffset) {
			XOffset = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		if(StyleFlagsHasYOffset) {
			YOffset = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		if(StyleFlagsHasFont) {
			TextHeight = SWF_BIT_STREAM_get_SI16(&bit_stream) / 20.0f;
		}
		GlyphCount = SWF_BIT_STREAM_get_UI8(&bit_stream);
		/*---------------------------------------------------------------------------*/
		/* * Sat Sep 12 05:03:25 JST 2009 Naoyuki Sawa
		 * - ȕ́AyƃuV𗼕gĕ`ȂƁAĂ܂܂B
		 *   傫ȕ́Ayg킸AuV̕Yɕ`܂B
		 *   ́Aȕ̐ȂƂD悵āAgƂɂ܂B
		 */
		/* y쐬 */
		hPen = CreatePen(PS_SOLID, 0, RGB(TextColor.Red, TextColor.Green, TextColor.Blue));
		if(!hPen) {
			DIE();
		}
		/* yI */
		hPen = SelectObject(hDC, hPen);
		if(!hPen) {
			DIE();
		}
		/* uV쐬 */
		hBrush = CreateSolidBrush(RGB(TextColor.Red, TextColor.Green, TextColor.Blue));
		if(!hBrush) {
			DIE();
		}
		/* uVI */
		hBrush = SelectObject(hDC, hBrush);
		if(!hBrush) {
			DIE();
		}
		/*---------------------------------------------------------------------------*/
		/* GlyphEntries */
		for(i = 0; i < GlyphCount; i++) {
			GlyphIndex   = SWF_BIT_STREAM_get_UB(&bit_stream, self->GlyphBits);
			GlyphAdvance = SWF_BIT_STREAM_get_UB(&bit_stream, self->AdvanceBits) / 20.0f;
			if(font && font->OffsetTable) {
				if(font->FontFlagsWideOffsets) {
					offset = font->OffsetTable[(GlyphIndex * 4) + 0]
					       | font->OffsetTable[(GlyphIndex * 4) + 1] <<  8
					       | font->OffsetTable[(GlyphIndex * 4) + 2] << 16
					       | font->OffsetTable[(GlyphIndex * 4) + 3] << 24;
				} else {
					offset = font->OffsetTable[(GlyphIndex * 2) + 0]
					       | font->OffsetTable[(GlyphIndex * 2) + 1] <<  8;
				}
				{
					SWF_BIT_STREAM shape_bit_stream = { font->OffsetTable + offset };
					n_point = 0;
					n_polygon = 0;
					/* SHAPE */
					NumFillBits = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 4);
					NumLineBits = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 4);
					for(;;) {
						if(SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1)) { /* TypeFlag */
							StraightFlag = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							NumBits      = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 4) + 2;
							if(StraightFlag) {
								/* STRAIGHTEDGERECORD */
								if(SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1)) {          /* GeneralLineFlag */
									DeltaX = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
									DeltaY = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
								} else {
									if(SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1)) { /* VertLineFlag */
										DeltaY = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
										DeltaX = 0.0f;
									} else {
										DeltaX = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
										DeltaY = 0.0f;
									}
								}
								x += DeltaX * TextHeight;
								y += DeltaY * TextHeight;
							} else {
								/* CURVEDEDGERECORD */
								ControlDeltaX = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
								ControlDeltaY = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
								x += ControlDeltaX * TextHeight;
								y += ControlDeltaY * TextHeight;
								/* {̓xWFȐȂ̂łA蔲āA_𔲂Ďn_-I_𒼐Ōł܂Ƃɂ܂B
								 * n_-_-I_𒼐Ōԕ@܂An_-I__CNgɌԕY^H^H}VɌ悤łB
								 */
								AnchorDeltaX  = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
								AnchorDeltaY  = SWF_BIT_STREAM_get_SB(&shape_bit_stream, NumBits) / 1024.0f;
								x += AnchorDeltaX * TextHeight;
								y += AnchorDeltaY * TextHeight;
							}
							/* ݂̑p`ɒ_ǉ */
							if(n_polygon) {
								if(n_point < ARRAY_SIZE(point)) {
									point[n_point].x = x;
									point[n_point].y = y;
									n_point++;
									polygon[n_polygon - 1]++;
								}
							}
						} else {
							/* ݂̑p`I */
							if(n_polygon) {
								/* tHg̃VFCv́AI_n_ƓWɖ߂AIɕpXƂăf[^i[ĂB
								 * `揈ɂĂ͖ʂȂ̂ŁA(n_ƓWł͂)I_폜B
								 */
								if(polygon[n_polygon - 1]) {
									n_point--; /* YȂ!! */
									polygon[n_polygon - 1]--;
								}
								/* L̏̌ʁA_3Ȃ΁Ap`ƂĖӖȂ̂ŁȂp`LZB */
								if(polygon[n_polygon - 1] < 3) {
									n_point -= polygon[n_polygon - 1]; /* ̑p`gĂ_SĔjBYȂ!! */
									n_polygon--;
								}
							}
							StateNewStyles  = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							StateLineStyle  = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							StateFillStyle1 = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							StateFillStyle0 = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							StateMoveTo     = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 1);
							if(StateNewStyles || StateLineStyle || StateFillStyle1 || StateFillStyle0 || StateMoveTo) {
								/* STYLECHANGERECORD */
								if(StateMoveTo) {
									MoveBits   = SWF_BIT_STREAM_get_UB(&shape_bit_stream, 5);
									MoveDeltaX = SWF_BIT_STREAM_get_SB(&shape_bit_stream, MoveBits) / 1024.0f;
									MoveDeltaY = SWF_BIT_STREAM_get_SB(&shape_bit_stream, MoveBits) / 1024.0f;
									/* - uSWF File Format Specification Version 10v136y[WfɁAȉ̐܂B
									 *   b In the first shape record MoveDeltaX and MoveDeltaY are relative to the shape origin.
									 *   b In subsequent shape records, MoveDeltaX and MoveDeltaY are relative to the current drawing position.
									 *   ̐͊ԈĂAMoveDeltaXMoveDeltaÝAɁAVFCv_̑΍WłB
									 */
									x = XOffset + MoveDeltaX * TextHeight - self->TextBounds.Xmin + self->TextMatrix.TranslateX; /* TextMatrix̊gk]͖Ή */
									y = YOffset + MoveDeltaY * TextHeight - self->TextBounds.Ymin + self->TextMatrix.TranslateY; /* TextMatrix̊gk]͖Ή */
								}
								if(StateFillStyle0) {
									SWF_BIT_STREAM_get_UB(&shape_bit_stream, NumFillBits); /* FillStyle0 */
								}
								if(StateFillStyle1) {
									SWF_BIT_STREAM_get_UB(&shape_bit_stream, NumFillBits); /* FillStyle1 */
								}
								if(StateLineStyle) {
									SWF_BIT_STREAM_get_UB(&shape_bit_stream, NumLineBits); /* LineStyle */
								}
								if(StateNewStyles) {
									DIE(); /* L蓾Ȃ */
								}
							} else {
								/* ENDSHAPERECORD */
								break;
							}
							/* Vp`JnB */
							if(n_polygon == ARRAY_SIZE(polygon)) {
								break;
							}
							polygon[n_polygon++] = 0;
							/* ݂̑p`ɒ_ǉ */
							if(n_point < ARRAY_SIZE(point)) {
								point[n_point].x = x;
								point[n_point].y = y;
								n_point++;
								polygon[n_polygon - 1]++;
							}
						}
					}
					/*---------------------------------------------------------------------------*/
					/* ALTERNATE[hPolyPolygonƂāA` */
					if(n_polygon) { /* (' ')tHgA}`ƂĊi[悤łBXLbv܂B */
						PolyPolygon(hDC, point, polygon, n_polygon);
					}
					/*---------------------------------------------------------------------------*/
				}
			}
			XOffset += GlyphAdvance;
		}
		SWF_BIT_STREAM_get_data(&bit_stream, 0); /* oCg */
		/*---------------------------------------------------------------------------*/
		/* uVI */
		hBrush = SelectObject(hDC, hBrush);
		if(!hBrush) {
			DIE();
		}
		/* uV폜 */
		DeleteObject(hBrush);
		/* yI */
		hPen = SelectObject(hDC, hPen);
		if(!hPen) {
			DIE();
		}
		/* y폜 */
		DeleteObject(hPen);
		/*---------------------------------------------------------------------------*/
	}
	/*---------------------------------------------------------------------------*/
	/* C[WZ[u */
	{
		FILE* fp;
		char fname[_MAX_FNAME];
		unsigned char TGAFileHeader[18] = {
			0x00,		// + 0,1 ID Length
			0x00,		// + 1,1 Color Map Type
			0x02,		// + 2,1 Image Type
			0x00, 0x00,	// + 3,2 First Entry Index
			0x00, 0x00,	// + 5,2 Color map Length
			0x00,		// + 7,1 Color map Entry Size
			0x00, 0x00,	// + 8,2 X origin of Image
			0x00, 0x00,	// +10,2 Y origin of Image
			0x80, 0x02,	// +12,2 Image Width
			0x90, 0x01,	// +14,2 Image Height
			0x20,		// +16,1 Pixel Depth
			0x08,		// +17,1 Image Descriptor
		};			// =18
		sprintf(fname, "text%04x.tga", self->character.CharacterId);
		fp = fopen(fname, "wb");
		if(!fp) {
			DIE();
		}
		*(short*)&TGAFileHeader[12] = bi.biWidth;
		*(short*)&TGAFileHeader[14] = bi.biHeight;
		fwrite(TGAFileHeader, 1, sizeof TGAFileHeader, fp);
		for(i = 0; i < bi.biWidth * bi.biHeight; i++) {
			if(ImageData[i][3] == 255) {	/* `斳 */
				ImageData[i][0] = 0;	/* Blue */
				ImageData[i][1] = 0;	/* Green */
				ImageData[i][2] = 0;	/* Red */
				ImageData[i][3] = 0;	/* Alpha */
			} else {			/* `L */
				ImageData[i][3] = 255;	/* Alpha */
			}
		}
		fwrite(ImageData, 1, bi.biWidth * bi.biHeight * 4/*BGRA*/, fp);
		fclose(fp);
	}
	/* DC폜BIDIBZNVI */
	DeleteDC(hDC);
	/* DIBZNV폜 */
	DeleteObject(hBitmap);
	/*---------------------------------------------------------------------------*/
}
#endif /*PIECE*/

static void SWF_OBJECT_DefineText_2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream, int has_alpha) {
	int CharacterId;
	SWF_RECT TextBounds;
	SWF_MATRIX TextMatrix;
	int GlyphBits;
	int AdvanceBits;
	const unsigned char* TextRecords;
	SWF_TEXT* text;

	CharacterId = SWF_BIT_STREAM_get_UI16(bit_stream);
	if(SWF_DICTIONARY_get_character(CharacterId)) {
		return; /* 1[vڂŒ`ς */
	}
	SWF_BIT_STREAM_get_RECT(bit_stream, &TextBounds);
	SWF_BIT_STREAM_get_MATRIX(bit_stream, &TextMatrix);
	GlyphBits = SWF_BIT_STREAM_get_UI8(bit_stream);
	AdvanceBits = SWF_BIT_STREAM_get_UI8(bit_stream);
	TextRecords = SWF_BIT_STREAM_get_data(bit_stream, 0);

	text = calloc(1, sizeof(SWF_TEXT));
	if(!text) {
		DIE(); /* s */
	}
	/*{{*/
	text->character.character_type = SWF_CHARACTER_TYPE_TEXT;
	text->character.CharacterId    = CharacterId;
	text->TextMatrix               = TextMatrix;
	text->GlyphBits                = GlyphBits;
	text->AdvanceBits              = AdvanceBits;
	text->TextRecords              = TextRecords;
	text->has_alpha                = has_alpha;
#ifndef PIECE
	text->TextBounds               = TextBounds;
#endif /*PIECE*/
	/*}}*/
	InsertTailList(&swf.dictionary, &text->character.list_entry);

#ifndef PIECE
	switch(swf.text_drawing_method) {
	case 0: /* using CodeTable */
		SWF_TEXT_dump_using_CodeTable(text);
		break;
	case 1: /* using GlyphShapeTable */
		SWF_TEXT_dump_using_GlyphShapeTable(text);
		break;
	default:
		DIE(); /* swf_set_text_drawing_method()̌Ăяos */
	}
#endif /*PIECE*/
}

static void SWF_OBJECT_DefineText(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 11 DefineText
	SWF_OBJECT_DefineText_2(self, bit_stream, 0/*has_alpha*/);
}

static void SWF_OBJECT_DefineText2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 33 DefineText2
	SWF_OBJECT_DefineText_2(self, bit_stream, 1/*has_alpha*/);
}

static void SWF_OBJECT_DefineEditText(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 37 DefineEditText
	int CharacterId;
	SWF_RECT Bounds;
	int HasText;
	int HasTextColor;
	int HasMaxLength;
	int HasFont;
	int HasFontClass;
	int HasLayout;
	int FontId;
	SWF_FONT* font;
	SWF_RGBA TextColor;
	const char* InitialText;
	SWF_EDIT_TEXT* edit_text;

	CharacterId = SWF_BIT_STREAM_get_UI16(bit_stream);
	if(SWF_DICTIONARY_get_character(CharacterId)) {
		return; /* 1[vڂŒ`ς */
	}
	SWF_BIT_STREAM_get_RECT(bit_stream, &Bounds); /* Bounds */
	HasText = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* WordWrap */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* Multiline */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* Password */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* ReadOnly */
	HasTextColor = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	HasMaxLength = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	HasFont = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	HasFontClass = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* AutoSize */
	HasLayout = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* NoSelect */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* Border */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* WasStatic */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* HTML */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* UseOutlines */

	if(HasFont) {
		FontId = SWF_BIT_STREAM_get_UI16(bit_stream);
		font = (SWF_FONT*)SWF_DICTIONARY_get_character(FontId);
		if(!font) {
			return; /* ` */
		}
		if(font->character.character_type != SWF_CHARACTER_TYPE_FONT) {
			DIE(); /* sȃf[^ */
		}
	} else {
		return; /* Ή */
	}
	if(HasFontClass) {
		SWF_BIT_STREAM_get_STRING(bit_stream); /* FontClass */
	}
	if(HasFont) {
		SWF_BIT_STREAM_get_UI16(bit_stream); /* FontHeight */
	}
	if(HasTextColor) {
		SWF_BIT_STREAM_get_RGBA(bit_stream, &TextColor);
	} else {
		memset(&TextColor, 0, sizeof TextColor);
	}
	if(HasMaxLength) {
		SWF_BIT_STREAM_get_UI16(bit_stream); /* MaxLength */
	}
	if(HasLayout) {
		SWF_BIT_STREAM_get_UI8(bit_stream); /* Align */
		SWF_BIT_STREAM_get_UI16(bit_stream); /* LeftMargin */
		SWF_BIT_STREAM_get_UI16(bit_stream); /* RightMargin */
		SWF_BIT_STREAM_get_UI16(bit_stream); /* Indent */
		SWF_BIT_STREAM_get_UI16(bit_stream); /* Leading */
	}
	SWF_BIT_STREAM_get_STRING(bit_stream); /* VariableName */
	if(HasText) {
		InitialText = SWF_BIT_STREAM_get_STRING(bit_stream);
	} else {
		return; /* Ή */
	}

	edit_text = calloc(1, sizeof(SWF_EDIT_TEXT));
	if(!edit_text) {
		DIE(); /* s */
	}
	/*{{*/
	edit_text->character.character_type = SWF_CHARACTER_TYPE_EDIT_TEXT;
	edit_text->character.CharacterId    = CharacterId;
	edit_text->Bounds                   = Bounds;
	edit_text->font                     = font;
	edit_text->color                    = ((((TextColor.Red * 30) + (TextColor.Green * 59) + (TextColor.Blue * 11)) / 100) >> 6) ^ 3;
	edit_text->InitialText              = InitialText;
	/*}}*/
	InsertTailList(&swf.dictionary, &edit_text->character.list_entry);
}

static void SWF_OBJECT_DefineSprite(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 39 DefineSprite
	int CharacterId;
	const unsigned char* ControlTags;
	SWF_SPRITE* sprite;

	CharacterId = SWF_BIT_STREAM_get_UI16(bit_stream);
	if(SWF_DICTIONARY_get_character(CharacterId)) {
		return; /* 1[vڂŒ`ς */
	}
	SWF_BIT_STREAM_get_UI16(bit_stream); /* FrameCount */
	ControlTags = SWF_BIT_STREAM_get_data(bit_stream, 0);

	sprite = calloc(1, sizeof(SWF_SPRITE));
	if(!sprite) {
		DIE(); /* s */
	}
	/*{{*/
	sprite->character.character_type = SWF_CHARACTER_TYPE_SPRITE;
	sprite->character.CharacterId    = CharacterId;
	sprite->ControlTags              = ControlTags;
	/*}}*/
	InsertTailList(&swf.dictionary, &sprite->character.list_entry);
}

static void SWF_OBJECT_DefineFont(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 10 DefineFont
	int CharacterId;
	const unsigned char* OffsetTable;
	SWF_FONT* font;

	CharacterId = SWF_BIT_STREAM_get_UI16(bit_stream);
	if(SWF_DICTIONARY_get_character(CharacterId)) {
		return; /* 1[vڂŒ`ς */
	}
	OffsetTable = SWF_BIT_STREAM_get_data(bit_stream, 0);

	font = calloc(1, sizeof(SWF_FONT));
	if(!font) {
		DIE(); /* s */
	}
	/*{{*/
	font->character.character_type = SWF_CHARACTER_TYPE_FONT;
	font->character.CharacterId    = CharacterId;
//	font->FontFlagsWideOffsets     = 0;
	font->OffsetTable              = OffsetTable;
//	font->FontFlagsWideCodes       = 0;
//	font->CodeTable                = NULL;
//	font->FontFlagsHasLayout       = 0;
//	font->FontDescent              = 0.0f;
//	font->FontFlagsBold            = 0;
#ifndef PIECE
//	font->FontNameLen              = 0;
//	font->FontName                 = NULL;
//	font->FontFlagsItalic          = 0;
#endif /*PIECE*/
	/*}}*/
	InsertTailList(&swf.dictionary, &font->character.list_entry);
}

static void SWF_OBJECT_DefineFontInfo(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 13 DefineFontInfo
	int FontId;
	int FontNameLen;
	const char* FontName;
	int FontFlagsItalic;
	int FontFlagsBold;
	int FontFlagsWideCodes;
	const unsigned char* CodeTable;
	SWF_FONT* font;

	FontId = SWF_BIT_STREAM_get_UI16(bit_stream);
	font = (SWF_FONT*)SWF_DICTIONARY_get_character(FontId);
	if(!font) {
		return; /* ` */
	}
	if(font->character.character_type != SWF_CHARACTER_TYPE_FONT) {
		DIE(); /* sȃf[^ */
	}
	FontNameLen = SWF_BIT_STREAM_get_UI8(bit_stream);
	FontName = SWF_BIT_STREAM_get_data(bit_stream, FontNameLen);
	SWF_BIT_STREAM_get_UB(bit_stream, 2); /* FontFlagsReserved */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* FontFlagsSmallText */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* FontFlagsShiftJIS */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* FontFlagsANSI */
	FontFlagsItalic = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	FontFlagsBold = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	FontFlagsWideCodes = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	CodeTable = SWF_BIT_STREAM_get_data(bit_stream, 0);

	/*{{*/
//	font->character.character_type = DefineFontŐݒς;
//	font->character.CharacterId    = DefineFontŐݒς;
//	font->FontFlagsWideOffsets     = DefineFontŐݒς;
//	font->OffsetTable              = DefineFontŐݒς;
	font->FontFlagsWideCodes       = FontFlagsWideCodes;
	font->CodeTable                = CodeTable;
//	font->FontFlagsHasLayout       = DefineFontŐݒς;
//	font->FontDescent              = DefineFontŐݒς;
	font->FontFlagsBold            = FontFlagsBold;
#ifndef PIECE
	font->FontNameLen              = FontNameLen;
	font->FontName                 = FontName;
	font->FontFlagsItalic          = FontFlagsItalic;
#endif /*PIECE*/
	/*}}*/
}

static void SWF_OBJECT_DefineFont2(SWF_OBJECT* self, SWF_BIT_STREAM* bit_stream) { // 48 DefineFont2
	int CharacterId;
	int FontFlagsHasLayout;
	int FontFlagsWideOffsets;
	int FontFlagsWideCodes;
	int FontFlagsItalic;
	int FontFlagsBold;
	int FontNameLen;
	const char* FontName;
	int NumGlyphs;
	const unsigned char* OffsetTable;
	int CodeTableOffset;
	const unsigned char* CodeTable;
	float FontDescent;
	SWF_FONT* font;

	CharacterId = SWF_BIT_STREAM_get_UI16(bit_stream);
	if(SWF_DICTIONARY_get_character(CharacterId)) {
		return; /* 1[vڂŒ`ς */
	}
	FontFlagsHasLayout = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* FontFlagsShiftJIS */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* FontFlagsSmallText */
	SWF_BIT_STREAM_get_UB(bit_stream, 1); /* FontFlagsANSI */
	FontFlagsWideOffsets = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	FontFlagsWideCodes = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	FontFlagsItalic = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	FontFlagsBold = SWF_BIT_STREAM_get_UB(bit_stream, 1);
	SWF_BIT_STREAM_get_UI8(bit_stream); /* LanguageCode */
	FontNameLen = SWF_BIT_STREAM_get_UI8(bit_stream);
	FontName = SWF_BIT_STREAM_get_data(bit_stream, FontNameLen);
	NumGlyphs = SWF_BIT_STREAM_get_UI16(bit_stream);
	if(FontFlagsWideOffsets) {
		OffsetTable = SWF_BIT_STREAM_get_data(bit_stream, NumGlyphs * 4);
		CodeTableOffset = SWF_BIT_STREAM_get_SI32(bit_stream);
		SWF_BIT_STREAM_get_data(bit_stream, CodeTableOffset - (NumGlyphs * 4)/*OffsetTable*/ - 4/*CodeTableOffset*/);
	} else {
		OffsetTable = SWF_BIT_STREAM_get_data(bit_stream, NumGlyphs * 2);
		CodeTableOffset = SWF_BIT_STREAM_get_UI16(bit_stream);
		SWF_BIT_STREAM_get_data(bit_stream, CodeTableOffset - (NumGlyphs * 2)/*OffsetTable*/ - 2/*CodeTableOffset*/);
	}
	if(FontFlagsWideCodes) {
		CodeTable = SWF_BIT_STREAM_get_data(bit_stream, NumGlyphs * 2);
	} else {
		CodeTable = SWF_BIT_STREAM_get_data(bit_stream, NumGlyphs * 1);
	}
	if(FontFlagsHasLayout) {
		SWF_BIT_STREAM_get_SI16(bit_stream); /* FontAscent */
		FontDescent = SWF_BIT_STREAM_get_SI16(bit_stream) / 1024.0f;
		SWF_BIT_STREAM_get_SI16(bit_stream); /* FontLeading */
	} else {
		FontDescent = 0.0f;
	}

	font = calloc(1, sizeof(SWF_FONT));
	if(!font) {
		DIE(); /* s */
	}
	/*{{*/
	font->character.character_type = SWF_CHARACTER_TYPE_FONT;
	font->character.CharacterId    = CharacterId;
	font->FontFlagsWideOffsets     = FontFlagsWideOffsets;
	font->OffsetTable              = OffsetTable;
	font->FontFlagsWideCodes       = FontFlagsWideCodes;
	font->CodeTable                = CodeTable;
	font->FontFlagsHasLayout       = FontFlagsHasLayout;
	font->FontDescent              = FontDescent;
	font->FontFlagsBold            = FontFlagsBold;
#ifndef PIECE
	font->FontNameLen              = FontNameLen;
	font->FontName                 = FontName;
	font->FontFlagsItalic          = FontFlagsItalic;
#endif /*PIECE*/
	/*}}*/
	InsertTailList(&swf.dictionary, &font->character.list_entry);
}

/*****************************************************************************
 *	O[o֐
 *****************************************************************************/

void
swf_init(const void* data)
{
	static const SWF_CHARACTER character; /* B̃[gIuWFNgp̃_~[LN^ */
	SWF_BIT_STREAM bit_stream = { data }; /* SWF File Headerǂނ߂̃rbgXg[ */
	SWF_OBJECT* object;

	/* ܂Amɖɖ߂܂B */
	swf_free();

	/* SWF File Header܂B */
	if(memcmp(SWF_BIT_STREAM_get_data(&bit_stream, 3), "FWS", 3)) { /* Signature */
		DIE(); /* sȃf[^ */
	}
	if(SWF_BIT_STREAM_get_UI8(&bit_stream) > 4) { /* Version */
		//DIE(); /* Ή */
		//^OȂ΁Ał\̂ŁAsĂ݂܂B
	}
	SWF_BIT_STREAM_get_SI32(&bit_stream); /* FileLength */
	SWF_BIT_STREAM_get_RECT(&bit_stream, (SWF_RECT*)&swf.swf_info.FrameSize);
	swf.swf_info.FrameRate  = SWF_BIT_STREAM_get_UI16(&bit_stream) / 256.0f;
	swf.swf_info.FrameCount = SWF_BIT_STREAM_get_UI16(&bit_stream);

	/* B̃[gIuWFNg쐬܂B */
	//memset(&swf, 0, sizeof swf);  swf_free()memset()ς݂svBmemset()swf_infoĂ܂̂ŕsB*/
	InitializeListHead(&swf.dictionary); /* fBNVi */
	InitializeListHead(&swf.display_list); /* B̃[gIuWFNgo^邽߂́AfBXvCXg */
	object = SWF_DISPLAY_LIST_new_object(&swf.display_list, 0);
	object->character       = (SWF_CHARACTER*)&character; /* B̃[gIuWFNgp̃_~[LN^ */
	object->object_state   |= SWF_OBJECT_STATE_PLAY;
	object->bit_stream.data = SWF_BIT_STREAM_get_data(&bit_stream, 0); /* [v̂߂ɁAŏ̃^Öʒubit_pos=0Ƃ */
}

void
swf_free()
{
	/* łȂ΁A[gIuWFNgJ܂B */
	if(swf.display_list.Flink) {
		SWF_DISPLAY_LIST_free(&swf.display_list);
	}

	/* łȂ΁AfBNViJ܂B */
	if(swf.dictionary.Flink) {
		SWF_DICTIONARY_free();
	}

	/* ɖ߂܂B */
	memset(&swf, 0, sizeof swf);
}

const SWF_INFO*
swf_info()
{
	/* SWF̍\̂̃AhXԂ܂B */
	return &swf.swf_info;
}

void
swf_exec()
{
	/* B̃[gIuWFNgs܂B
	 * ɂAB̃[gIuWFNgAKw\ċAIɎs܂B
	 */
	SWF_DISPLAY_LIST_exec(&swf.display_list);

	/* B̃[gIuWFNg̃ANVs܂B
	 * ɂAB̃[gIuWFNgAKw\ċAIɎs܂B
	 */
	SWF_DISPLAY_LIST_exec_action(&swf.display_list);
}

void
swf_set_text_drawing_method(int text_drawing_method)
{
	/* Î~eLXg̕`@i[܂B */
	swf.text_drawing_method = text_drawing_method;
}

#ifdef PIECE
void
swf_draw(RENDER* render)
{
	/* B̃[gIuWFNg`悵܂B
	 * ɂAB̃[gIuWFNgAKw\ċAIɕ`悵܂B
	 */
	SWF_DISPLAY_LIST_draw(&swf.display_list, render, &mat2f_1);
}
#endif /*PIECE*/

