/*	
 *	clipip.h
 *
 *	IPvgRhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Wed Aug 25 05:43:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 */
#ifndef __CLIP_IP_H__
#define __CLIP_IP_H__

/****************************************************************************
 *	IPvgRhCo
 ****************************************************************************/

typedef struct _IPCLIENT IPCLIENT;

/* IPCLIENT.recv : MR[obÑvg^Cv
 * - ʏAĐIPAhX̓foCXIPAhXł͂łA
 *   MR[obNɓ`Kv͖悤Ɏv܂B
 *   ۂɂ́Au[hLXgAhXł\܂B
 * - TCPUDPhCo̎ḾAĐAhX܂ދ^wb_쐬āA
 *   MpPbg̃`FbNTvZAMpPbg̃G[os܂B
 *   ]āAMR[obNɈĐIPAhX𖾎Kv܂B
 */
typedef void IPRECV(IPCLIENT* client,
	int source_ip_address,			/* MIPAhX */
	int destination_ip_address,		/* ĐIPAhX */
	const unsigned char* data/*[length]*/,	/* IPf[^Õf[^ */
	int length);				/* IPf[^Õf[^ */

/* IPCLIENT.conf : ݒύXR[obÑvg^Cv */
typedef void IPCONF(IPCLIENT* client);

/* NCAgo^p̍\ */
/*typedef*/ struct _IPCLIENT {

	/*------------------------------------------------------------------------------*
	 *	ip_open()ĂяoOɁAAvP[VɂĐݒ肵ĂtB[hB	*
	 *	ip_open()ĂяóAύXĂ͂ȂB				*
	 *------------------------------------------------------------------------------*/

	int protocol;		/* vgRID */
	IPRECV* recv;		/* MR[obN (NULL:) */
	IPCONF* conf;		/* ݒύXR[obN (NULL:) */

	/*------------------------------------------------------------------------------*
	 *	IPvgRhCoAŎgptB[hB			*
	 *	AvP[V́Aȉ̃tB[hɃANZXĂ͂ȂB		*
	 *------------------------------------------------------------------------------*/

	LIST_ENTRY list_entry;	/* NCAgXg */

} /*IPCLIENT*/;

/* lbg[Nݒ */
typedef struct _IPCONFIG {
	int ip_address;		/* IPAhX */
	int subnet_mask;	/* Tulbg}XN */
	int default_gateway;	/* ftHgQ[gEFC */
} IPCONFIG;

/*--------------------------------------------------------------------------*/

/* IPvgRhCoJn܂B
 * [note]
 *	* ip_start()ĂяoAvP[V́AIOɕKAip_stop()ĂяoĂB
 *	  ip_stop()ĂяoɃAvP[VIƁAP/ECEVXeُ퓮N܂B
 *	* ip_open()ĂяoăNCAgo^OɁAKAip_start()ĂяoĂB
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	~
 */
void ip_start();

/* IPvgRhCo~܂B
 * [note]
 *	* ip_stop()́AɈSɌĂяo\łB
 *	  ip_start()ĂяoĂȂĂAłAłAip_stop()Ăяoč\܂B
 *	* ip_stop()ĂяoƁAo^ĂNCAǵAIɂׂēo^܂B
 *	  ip_stop()ĂяoOɁAX̃NCAgAIɓo^Kv͂܂B
 *	  ܂Aip_stop()ĂяoɁAip_close()ĂяoĂ͂܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	~
 */
void ip_stop();

/* ̏ʃvgRANCAgo^܂B
 * [in]
 *	client		ĂяoɂĊmۂANCAgo^p̍\́B
 *			etB[hA炩ߓK؂ɏĂĂB
 * [note]
 *	* ʃvgRNCAgAɓȏo^悤ƂƁAG[I܂B
 *	* NCAgo^p̍\̂́AIPvgRhCõXgɃN܂B
 *	  ip_close()Ăяoēo^܂ŁA\̂JĂ͂܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	@\AȂ
 */
void ip_open(IPCLIENT* client);

/* o^ς݃NCAgAo^܂B
 * [in]
 *	client		o^ς݃NCAg̍\́B
 * [note]
 *	* o^̃NCAgo^悤ƂƁAG[I܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	@\AȂ
 */
void ip_close(IPCLIENT* client);

/* IPf[^O𑗐M܂B
 * [in]
 *	client		o^ς݃NCAg̍\́B
 *	address		ĐIPAhXB          (      6oCg)
 *	data		IPf[^Õf[^B(0..1480oCg) 2005/09/06݂̎́AIPtOgΉłB
 *	length		IPf[^Õf[^B  (0..1480      )   ̑ΉɂA1480oCgȏ\ƂȂ\łB
 * [out]
 *	߂l		Ȃ΁Af[^(length̒l)̂܂ܕԂ܂B(0A܂́A)
 *			ML[ςőMłȂꍇAԂ܂B
 * [note]
 *	* 2005/09/06݂̎́AIPtOgΉłB
 *	  ʃvgR(Ethernet)MTU1500łA{hCo̐IPf[^Õwb_TCY20oCgŒȂ̂ŁA
 *	  IPf[^Õf[^̍ő咷́A1480oCgƂȂ܂B
 *	  2005/09/06݂̎́Alength1480𒴂lw肷ƁAĂяoethernet_send()ɂăG[I܂B
 *	* ip_send()́Aarp_request()ĂяoāAĐIPAhXɑΉEthernetAhX擾Ă܂B
 *	- ip_send()荞݋ԂŌĂяoꍇAĐIPAhXARPe[uɖo^Ȃ΁A
 *	  ip_send()Ăяoꂽarp_request()́AARPv𔭍sÃ^CAEg(1b)AARP҂܂B
 *	  Ȃ킿A荞݋Ԃip_send()ĂяoꍇAip_send()Ԃ܂łɖ1bԂ\܂B
 *	- ip_send()荞݋֎~ԂŌĂяoꍇAĐIPAhXARPe[uɖo^Ȃ΁A
 *	  ip_send()Ăяoꂽarp_request()́AARPv𔭍sAɃ^CAEg܂B
 *	  荞݋Ԃip_send()ĂяoꍇAĐIPAhXARPe[uɖo^Ȃ΁Aip_send()͎s܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	@(AhXłȂ΁AubN)
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	@(AhXłȂ΁AubNɎs)
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	@(AhXłȂ΁AubNɎs)
 */
int ip_send(IPCLIENT* client, int address, const void* data/*[length]*/, int length);

/* lbg[NݒύX܂B
 * [in]
 *	config		IPCONFIG\̂ւ̃|C^B(ĂяoɂēK؂ɐݒ肵Ă)
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
void ip_set_config(const IPCONFIG* config);

/* lbg[Nݒ擾܂B
 * [in]
 *	config		ʂi[IPCONFIG\̂ւ̃|C^B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
void ip_get_config(IPCONFIG* config);

/****************************************************************************
 *	ARPvgRhCo
 ****************************************************************************/

/* ARPe[u̗vf */
typedef struct _ARPENTRY {
	int ip_address;				/* IPAhX */
	unsigned char ethernet_address[6];	/* EthernetAhX */
} ARPENTRY;

/*--------------------------------------------------------------------------*/

/* ARPe[uAIPAhXɑΉEthernetAhX擾܂B
 * ARPe[uɓo^ĂȂ΁AARPv𑗐MAARP҂܂B
 * [in]
 *	ip_address	IPAhXB
 *	ethernet_address IPAhXɑΉEthernetAhXi[邽߂̃obt@B
 *	timeout		^CAEgԁB(Ȃ΁Ã^CAEgԂgp)
 * [out]
 *	߂l		擾ɐA0Ԃ܂B
 *			擾ɎsA0ȊO̒lԂ܂B
 * [note]
 *	* IPAhXARPe[uɓo^ĂꍇAarp_request()͑ɊAԂ܂B
 *	* IPAhXARPe[uɓo^ĂȂꍇAarp_request()ARPv𑗐M܂B
 *	- 荞݋ԂŌĂ΂ꂽꍇAtimeoutɂĎw肳ꂽ^CAEgԂ̊ԁAARP҂܂B
 *	  ^CAEgԓARPꂽꍇAarp_request()͐Ԃ܂B
 *	  ^CAEgԓARPȂꍇAarp_request()͎sԂ܂B
 *	- 荞݋֎~ԂŌĂ΂ꂽꍇAarp_request()ARPv𑗐MAɊAɎsԂ܂B
 *	  荞݋֎~ԂłARPv𑗐M邱ƂɂŔAarp_request()Ă΂܂ł̊ԂARPMA
 *	  ARPe[uɓo^āAarp_request()ɐ邱Ƃ҂āÂ悤ȎdlƂ܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	@ubLO
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	@mubLO (timeout=0ƌȂ)
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	@mubLO (timeout=0ƌȂ)
 */
int arp_request(int ip_address, unsigned char* ethernet_address/*[6]*/, int timeout);

/* Gratuitous ARP𑗏o܂B
 * [out]
 *	߂l		ۂɁAGratuitous ARP𑗏oꍇ́A0Ԃ܂B
 *			EthernetAhXA܂́AIPAhXݒ肳ĂȂꍇ́A-1Ԃ܂B
 * [note]
 *	* ethernet_set_address()A܂́AVendorRequestɂEthernetAhX̕ύXAсA
 *	  ip_set_config()ɂIPAhX̕ύX́AIGratuitous ARP𑗏o܂B
 *	  {AAvP[VvOIGratuitous ARPovKv͖̂łA
 *	  ȉ̂悤ȗRɂA{֐AvP[VvOɌJ܂B
 *	* Windows XP̃lbg[NubW@\gꍇAC^[tFCX̏A
 *	  ubWC^[tFCX̏܂łɁA^CO݂łB
 *	  ̊ԁAC^[tFCXMu[hLXgt[́AubWO܂B
 *	  P/ECE USB LANC^[tFCXɁAP/ECEGratuitous ARPu[hLXĝłA
 *	  ̃bZ[WubWOꂸALANփu[hLXg܂B
 *	  ̂߁ALAÑzXgGratuitous ARPMAP/ECEMACAhXωFł܂B
 *	  ubWC^[tFCX̏҂߂ɁAGratuitous ARP̑ox点Ηǂ̂łA
 *	  ^C~OmłȂ߁AARPvgRhCoɂĒŝ͗ǂȂƍl܂B
 *	* q̂悤ɁAł̖͉͂Ă܂B
 *	  AvP[VɂĒIarp_gratuitous()ĂяoAGratuitous ARP𑗏o邱ƂőΏĂB
 *	    <> pceTimerSetCallback(0, PCE_TT_PERIODIC, 10*1000, (void*)arp_gratuitous); // 
 *	         pceTimerSetCallback(0, PCE_TT_NONE,           0,                  NULL); // I
 *	* arp_gratuitous()́AEthernetAhXIPAhXωǂfɁAos܂B
 *	  ܂pɂɌĂяoƁAlbg[Nш𖳑ʂɏ̂ŁA10`30bԊuxǂƎv܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
int arp_gratuitous();

/* ARPe[u̗vf擾܂B
 * [in]
 *	table		ARPe[u̗vfi[obt@B
 *	table_size	obt@̗vfB
 * [out]
 *	߂l		ۂɊi[ꂽARPe[u̗vfB
 * [note]
 *	* obt@ɂ́AARPe[uMRU擪vf`table_sizevf܂łRs[܂B
 *	  ARPe[ȗSvf擾ɂ́A߂ltable_sizeȂ܂ŁA
 *	  obt@gAtable_size𑝂₵ȂAJԂAĂяoĂB
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
int arp_table(ARPENTRY* table/*[table_size]*/, int table_size);

/****************************************************************************
 *	ICMPvgRhCo
 ****************************************************************************/

/* ICMPʐMԎ擾p */
typedef struct _ICMPSTAT {
	int echo_reply;		/* GR[bZ[WM */
	int echo_request;	/* GR[vbZ[WM */
} ICMPSTAT;

/*--------------------------------------------------------------------------*/

/* ICMPGR[v𑗐MAICMPGR[҂܂B
 * [in]
 *	address		ĐIPAhXB
 *	timeout		ICMPGR[҂Aő厞[~b]B(Ȃ΁Ã^CAEgԂgp)
 * [out]
 *	߂l		ICMPGR[MꍇAo`M܂ł̒x[~b]Ԃ܂B(0A܂́A)
 *			ICMPGR[MOɃ^CAEgꍇAԂ܂B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	~
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	~
 */
int icmp_echo_request(int address, int timeout);

/* ICMPʐMԂ擾܂B
 * [in]
 *	stat		ʂi[ICMPSTAT\̂ւ̃|C^B
 * [interrupt]
 *	ʏ폈	荞݋Ԃł̌Ăяo	
 *	ʏ폈	荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ	荞݋֎~Ԃł̌Ăяo	
 */
void icmp_stat(ICMPSTAT* stat);

#endif /*__CLIP_IP_H__*/
