/*	
 *	clipgc.c
 *
 *	P/ECEpK[x[WRN^[
 *
 *	uK.Sasada's Home Pagev(http://www.namikilab.tuat.ac.jp/~sasada/)
 *	wPiGC : P/ECE pKx[WRN^[x(http://www.namikilab.tuat.ac.jp/~sasada/prog/pigc.html)
 *	̎QlɂĒ܂B肪Ƃ܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Tue Jul 22 07:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jul 22 20:04:00 JST 2004 Naoyuki Sawa
 *	- WX^QƂĂ郁ubNĊJĂ܂̂h߁A
 *	  K[x[WRN^[{̂ĂяoO%r0-3X^bNɐςނ悤ɕύX܂B
 *	* Sat Nov 04 12:30:26 JST 2006 Naoyuki Sawa
 *	- ̂߁A啝ɉ܂B
 *	  Ö蓮삵ĂR[h́Akeep/06_GCÖŕۑ.20061104ɕۑ܂B
 *	- ̂߂̎ȕύX_́Aȉ̒ʂłB(ڂ́AύXÕR[hƔrĂB)
 *	  EO_gc_run()ɂāAVQƃubN𔭌邽тɃ[v𒆒fčŏ瑖Ă܂A
 *	    _gc_run()ł́A[v𒆒fɍŌ܂őAxł΂x邱Ƃɂ܂B
 *	    ύXÓA񐔂Ɠ񐔂̃[vĊJsĂ܂AύX́A̔x̍ĊJɂ܂Ƃ߂܂B
 *	  EύXO_gc_run()ł́AxubNA[vĊJ̓xɍđsĂAʂ܂B
 *	    ύX_gc_run()́AQƂĂ邪łubNƁAς݃ubNʂĈAʂȑȂ܂B
 *	  EOgc_mark()ɂāAQƃubNւ̐VQƂ𔭌JEgĂ܂A
 *	    JEg͖ӖȂ̂ŁAgc_scan()ɂẮA̗LP0or1tOƂ܂B
 *	- ɍł\邪Ač̗pȂîŁAL^Ă܂B
 *	  Egc_scan()ɂāAݑ̃ubÑubNւ̐VQƂ̔ł́Aresult1ɂȂƂ肪܂B
 *	    ȂȂAݑ̃ubÑubŃÃ݂q[v[vɑ̂ŁA[vĊJsvłB
 *	    ̎iɂAŏĨ[vĊJȗł\Ał\܂B
 *	    A܂ɂCAEgɈˑĂ邵AR[h킩Â炭Ȃ鋰ꂪ܂B
 *	    ɁAq[vŜɑ΂̑[vʂɔƂĂAقǑ傫ȕׂł͂܂B
 *	    R[h킩Ղۂ߂ɁA̎i͍̗pȂƂɂ܂B
 *	* Sat Jun 20 01:31:13 JST 2009 Naoyuki Sawa
 *	- 荞݃[`pceHeap*()gƂGCAIgc_run()ĂяoĂSȂ悤A
 *	  _gc_run()֐ENTER_CS`LEAVE_CSǉA荞݋֎~Ƃ܂B
 *	- gc_run()͎Ԃ̂鏈Ȃ̂ŁA荞݋֎~ɂ̂͋ĈłA͂芄荞݋֎~ɂ邱Ƃɂ܂B
 *	  clippce.cW[pceHeap*()荞݋֎~ɕύXA荞݃[`Ŏgp\ƂĂȏA
 *	  K[x[WRN^[荞ݓňSɗp\łȂ΁AЎ藎łƍlłB
 *	  mgc_run()͎Ԃ̂łApɂɔ鏈ł͂Ȃ̂ŁA傫ȉe͖Ǝv܂B
 *	  gc_run()ƂɁAԊ荞݂֎~āATEhɃmCYA16K\ƂĂA
 *	  ܂Ɉu邾łāAقǋCɂȂȂƎv܂B(TODO:2009/06/20݁A܂ۂɎĂ܂)
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

typedef struct _GC {
	void* (*old_pceHeapAlloc)(unsigned long size);	/* {pceHeapAlloc()ۑB(NULL:) */
	unsigned int sram_top;				/* SRAM擪AhX     */
	unsigned int sram_end;				/* SRAMI[AhX(+1) */
	unsigned int stack_top;				/* X^bN̈擪AhX     */
	unsigned int stack_end;				/* X^bN̈I[AhX(+1) */
	HEAPMEM* heaptop;				/* ŏ̃ubNǗ\̃AhX */
} GC;
static GC _gc;

/* HEAPMEM.ownergBPieceSystemK̒lƏdĂ̓_!! */
#define HMO_NOREF_USER	0x1111	/* ǂQƂĂȂHMO_DEFAULT_USER */
#define HMO_NOSCAN_USER	0x2222	/* QƂĂ邪AHMO_DEFAULT_USER */

static void _gc_run() __attribute__((unused));
static int gc_scan(void* top, void* end);
static void* new_pceHeapAlloc(unsigned long size);

extern unsigned int __START_FRAM_ADDR[];
extern unsigned int __END_FRAM_ADDR[];
extern unsigned int __START_DEFAULT_CODE[];
extern unsigned int __END_DEFAULT_CODE[];
extern unsigned int __START_DEFAULT_DATA[];
extern unsigned int __END_DEFAULT_DATA[];
extern unsigned int __START_DEFAULT_BSS[];
extern unsigned int __END_DEFAULT_BSS[];

/****************************************************************************
 *	
 ****************************************************************************/

void
gc_init()
{
	GC* gc = &_gc;
	//
	const SYSTEMINFO* sysinfo;
	const pceAPPHEAD* apphead;

	/* ܂mɖԂɖ߂܂B */
	gc_free();

	/* SRAM̐擪EI[AhX擾܂B */
	sysinfo = pceSystemGetInfo();
	gc->sram_top = (unsigned int)sysinfo->sram_top;
	gc->sram_end = (unsigned int)sysinfo->sram_end;

	/* X^bN̈ƁAŏ̃ubNǗ\̃AhX擾܂B */
	apphead = (const pceAPPHEAD*)__START_DEFAULT_CODE;
	if(apphead->stack_size) {
		/* * X^bNSRAMɔzuꍇ̃CAEǵAȉ̒ʂłB
		 *
		 *	0000000	+-------------+
		 *		|WORK     |
		 *	0001000	+-------------+	__START_FRAM_ADDR
		 *		|RAM]  |
		 *	0001???	+-------------+	__END_FRAM_ADDR
		 *		|         |
		 *	0002000	+-------------+
		 *
		 *	0100000	+-------------+	__START_DEFAULT_CODE
		 *		|۸ѥ萔 |
		 *	01?????	+-------------+	__END_DEFAULT_CODE == __START_DEFAULT_DATA
		 *		|ϕϐ |
		 *	01?????	+-------------+	__END_DEFAULT_DATA == __START_DEFAULT_BSS
		 *		|ۏϐ|
		 *	01?????	+-------------+	__END_DEFAULT_BSS == apphead->bss_end
		 *		|̈     |
		 *	01?????	+-------------+	(apphead->bss_end + apphead->stack_size) == heaptop
		 *		|˰ߗ̈     |
		 *	0140000	+-------------+
		 */
		gc->stack_top = (unsigned int)apphead->bss_end;
		gc->stack_end = gc->stack_top + apphead->stack_size;
		gc->heaptop = (HEAPMEM*)gc->stack_end;
	} else {
		/* * X^bNRAMɔzuꍇ̃CAEǵAȉ̒ʂłB
		 *
		 *	0000000	+-------------+
		 *		|WORK     |
		 *	0001000	+-------------+	__START_FRAM_ADDR
		 *		|(RAM])|	... ʏ͎g܂B__START_FRAM_ADDR == __END_FRAM_ADDR == 0x1000 łB
		 *	0001???	+-------------+	__END_FRAM_ADDR
		 *		|̈     |
		 *	0002000	+-------------+
		 *
		 *	0100000	+-------------+	__START_DEFAULT_CODE
		 *		|۸ѥ萔 |
		 *	01?????	+-------------+	__END_DEFAULT_CODE == __START_DEFAULT_DATA
		 *		|ϕϐ |
		 *	01?????	+-------------+	__END_DEFAULT_DATA == __START_DEFAULT_BSS
		 *		|ۏϐ|
		 *	01?????	+-------------+	__END_DEFAULT_BSS == apphead->bss_end == heaptop
		 *		|˰ߗ̈     |
		 *	0140000	+-------------+
		 */
		gc->stack_top = (unsigned int)__END_FRAM_ADDR;
		gc->stack_end = 0x2000;
		gc->heaptop = (HEAPMEM*)apphead->bss_end;
	}
	if(gc->heaptop->mark != HEAPMEMMK) DIE();

	/* pceHeapAlloc()tbN܂B(old_pceHeapAlloc!=NULL:) */
	gc->old_pceHeapAlloc = pceVectorSetKs(KSNO_HeapAlloc, new_pceHeapAlloc);
}

void
gc_free()
{
	GC* gc = &_gc;

	/* ĂȂΉ܂B */
	if(!gc->old_pceHeapAlloc) return;

	/* pceHeapAlloc()̃tbN܂B */
	pceVectorSetKs(KSNO_HeapAlloc, gc->old_pceHeapAlloc);

	/* NA܂B(old_pceHeapAlloc==NULL:) */
	memset(gc, 0, sizeof(GC));
}

/* void gc_run() */
asm("
	.code
	.global gc_run
gc_run:
	; Ăяo֐ALȃubNւ̃|C^%r0-3ɕێĂ\܂B
	; K[x[WRN^[̓WX^̃ubNQƂȂ̂ŁA
	; ̂܂܂ł́AWX^QƂĂ郁ubNĊJĂ܂\܂B
	; ̖邽߁A%r0-3X^bNɐςłAK[x[WRN^[{̂ĂяoƂɂ܂B
	pushn %r3
	call _gc_run
	popn %r3
	ret
");

static void
_gc_run()
{
	GC* gc = &_gc;
	//
	int retval;
	HEAPMEM* phm;

	/* ɌĂł͂܂B */
	if(!gc->old_pceHeapAlloc) DIE();

ENTER_CS; /*{{2009/06/20:ǉ}}*/

	/* 蓖čς݃[U[ubNAɖQƃubNƂĂ܂B */
	for(phm = gc->heaptop; phm; phm = phm->chain) {
		if(phm->mark != HEAPMEMMK) DIE();
		switch(phm->owner) {
		/* 󂫃ubN */
		case 0:
			/** no job **/
			break;
		/* 蓖čς݃VXeubN */
		case HMO_SYSTEM:
			if(phm->chain) DIE();		/* PieceSystem 1.20 ɂẮAHMO_SYSTEḾAq[v[̋ubNƂĂ̂ݗpĂ܂ */
			break;
		/* 蓖čς݃[U[ubN */
		case HMO_DEFAULT_USER:
			phm->owner = HMO_NOREF_USER;	/* ɖQƃubNƂĂAQƂoHMO_NOSCAN_USERHMO_DEFAULT_USERƑJڂ܂ */
			break;
		/* \ȂubN */
		default:
			DIE();
		}
	}

	/* QƃubN̂AX^bN̈orf[^̈悩QƂĂ̂AvubNƂ܂B */
	gc_scan((void*)gc->stack_top, (void*)gc->stack_end);
	gc_scan(__START_DEFAULT_DATA, __END_DEFAULT_DATA);
	gc_scan(__START_DEFAULT_BSS, __END_DEFAULT_BSS);

	/* vubN𑖍āAQƐubNvubNƂAg͑ς݃ubNɖ߂܂B */
	do {
		retval = 0;
		for(phm = gc->heaptop; phm; phm = phm->chain) {
			if(phm->mark != HEAPMEMMK) DIE();
			if(phm->owner == HMO_NOSCAN_USER) {
				retval |= gc_scan(phm + 1/*Kv!!*/, phm->chain);
				phm->owner = HMO_DEFAULT_USER; /* ς݂ɖ߂ */
			}
		}
	} while(retval); /* VvubNǉꂽAxŏ */

	/* QƃubN̂܂܎cubNAׂĊJ܂B */
	do {
		for(phm = gc->heaptop; phm; phm = phm->chain) {
			if(phm->mark != HEAPMEMMK) DIE();
			if(phm->owner == HMO_NOREF_USER) {
				retval = pceHeapFree(phm + 1/*Kv!!*/);
				if(retval != 0) DIE();
				break; /* phm->chain͖ɂȂ̂ŁAforpłȂBxŏ */
			}
		}
	} while(phm); /* breakŔꍇAxŏ */

LEAVE_CS; /*{{2009/06/20:ǉ}}*/
}

/* w͈͂̑S[h𑖍āAQƃubNւ̐VQƂo܂B
 * QƃubNւ̐VQƂoAvubNƃ}[N܂B
 */
static int
gc_scan(void* top, void* end)
{
	int result = 0;
	GC* gc = &_gc;
	//
	unsigned int* pos;
	unsigned int addr;
	HEAPMEM* phm;

	for(pos = (unsigned int*)top; pos < (unsigned int*)end; pos++) {
		addr = *pos - sizeof(HEAPMEM)/*Kv!!*/;
		if(!(addr & 3) && (addr >= gc->sram_top) && (addr < gc->sram_end)) {
			for(phm = gc->heaptop; phm; phm = phm->chain) {
				if(phm->mark != HEAPMEMMK) DIE();
				if(phm == (HEAPMEM*)addr) {
					if(phm->owner == HMO_NOREF_USER) {	/* QƃubNւ̐VQƂoc */
						phm->owner = HMO_NOSCAN_USER;	/* vubNƂă}[N܂B() */
						result = 1;
					}
					break;
				}
			}
		}
	}

	return result;
}

static void*
new_pceHeapAlloc(unsigned long size)
{
	GC* gc = &_gc;
	//
	void* ptr;

	ptr = gc->old_pceHeapAlloc(size); /* 1st try */
	if(!ptr) {
		gc_run();
		ptr = gc->old_pceHeapAlloc(size); /* 2nd try */
		if(!ptr) DIE();
	}

	return ptr;
}

