/*	
 *	clipfp16.c
 *
 *	16bit_`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Mon Jul 27 18:33:57 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef PIECE
float
fp16_read(const fp16* p)
{
	FLT_INT fi;
	if(!p->e) {
		return 0.0f;
	}
	fi.i.s = p->s;
	fi.i.e = p->e + (127 - 15);
	fi.i.m = p->m << (23 - 10);
	return fi.f;
}
#else /*PIECE*/
float fp16_read(const fp16* p);
asm("
		.code
		.align		1
		.global		fp16_read
fp16_read:
		ld.h		%r11, [%r12]			;// %r11 := ssssssss ssssssss seeeeemm mmmmmmmm
		xand		%r10, %r11, 0x00007C00		;// %r10 := 00000000 00000000 0eeeee00 00000000
		jreq		fp16_read_RET			;// if(!e) { return 0.0f }
		xand		%r11, %r11, 0xFFFC03FF		;// %r11 := ssssssss ssssss00 000000mm mmmmmmmm
		xadd		%r10, %r10, 0x0001C000		;// %r10 := 00000000 000000ee eeeeee00 00000000 (e += (127-15)<<10)
		or		%r10, %r11			;// %r10 := ssssssss ssssssee eeeeeemm mmmmmmmm
		sla		%r10, 8				;// %r10 := ssssssee eeeeeemm mmmmmmmm 00000000
fp16_read_RET:
		ret.d
		sla		%r10, 5				;// %r10 := seeeeeee emmmmmmm mmm00000 00000000		*delay*
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/

#ifndef PIECE
void
fp16_write(fp16* p, float f)
{
	FLT_INT fi = { .f = f };
	int e = fi.i.e - (127 - 15);
	if(e <= 0) {
		p->s = p->e = p->m = 0;
	} else if(e <= 31) {
		p->s = fi.i.s;
		p->e = e;
		p->m = fi.i.m >> (23 - 10);
	} else {
		DIE(); /* overflow */
	}
}
#else /*PIECE*/
void fp16_write(fp16* p, float f);
asm("
		.code
		.align		1
		.global		fp16_write
fp16_write:
		rl		%r13, 6				;// %r13 := eeemmmmm mmmmmmmm mmmmmmmm mmseeeee
		xand		%r10, %r13, 0x00000020		;// %r10 := 00000000 00000000 00000000 00s00000
		rl		%r13, 3				;// %r13 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee
		ld.ub		%r11, %r13			;// %r11 := 00000000 00000000 00000000 eeeeeeee
		xor		%r13, %r11			;// %r13 := mmmmmmmm mmmmmmmm mmmmmmms 00000000
		xsub		%r11, %r11, 112			;// %r11 := 00000000 00000000 00000000 000eeeee (e -= (127-15))
		jrle		fp16_write_RET0			;// if(e <= 0) { p->s = p->e = p->m = 0 }
		cmp		%r11, 31			;// if(e > 31) { overflow }
		jrgt		fp16_write_DIE
		or		%r10, %r11			;// %r10 := 00000000 00000000 00000000 00seeeee
		or		%r10, %r13			;// %r10 := mmmmmmmm mmmmmmmm mmmmmmms 00seeeee
		xrl		%r10, 10			;// %r10 := mmmmmmmm mmmmms00 seeeeemm mmmmmmmm
		ld.h		[%r12], %r10			;// *p   :=                   seeeeemm mmmmmmmm
		ret
fp16_write_RET0:
		ld.h		[%r12], %r8			;// *p   :=                   00000000 00000000
		ret
");
static void __attribute__((noreturn,unused)) fp16_write_DIE() { DIE(); /* overflow */ }
#endif /*PIECE*/

