#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
void setup() {
	GameCore_initialize();
	TitleMenu_initialize();
	GameLevel_initialize();
	NameEntry_initialize();
	Ranking_initialize();
	//
	TitleMenu_onEntry();
	scene = SCENE_TITLE;
}
/*--------------------------------------------------------------------------*/
void loop() {
#ifndef LOW_FLASH_MEMORY
	GameCore_updateQuake();
#endif//LOW_FLASH_MEMORY
	switch(scene) {
	default:DIE();
	case SCENE_TITLE:
		{
			//SELECT{^ꂽAvOIB
			if(joy & TRG_SELECT) {
				GameCore_stopScore();
				exit(EXIT_SUCCESS);
			}
			switch(TitleMenu_loop()) {
			case TITLE_START_GAME:
#ifdef  PIECE
				while(pcePadGetDirect()) { schedule(); }
#endif//PIECE
				GameLevel_onEntry();
				scene = SCENE_GAME;
				break;
			case TITLE_DISP_RANKING:
				Ranking_onEntry();
				scene = SCENE_RANKING;
				break;
			}
		}
		break;
	case SCENE_GAME:
		{
			int score, rank;
			//SELECT{^ꂽA^Cgj[֖߂B
			if(joy & TRG_SELECT) {
				GameCore_stopScore();
				TitleMenu_onEntry();
				scene = SCENE_TITLE;
				break;	//܂
			}
			if(GameLevel_loop()) {
				GameCore_stopScore();
				//check high score
				score = GameLevel_getScore();
				rank = Ranking_getRank(score);
				if(score && (rank < RANKING_ENTRY_MAX)) {
					NameEntry_onEntry(rank, score);
					scene = SCENE_NAME_ENTRY;
				} else {
					Ranking_onEntry();
					scene = SCENE_TITLE;	//didnt rank in
				}
			}
		}
		break;
	case SCENE_NAME_ENTRY:
		{
			if(NameEntry_loop()) {
				Ranking_enterScore(NameEntry_getScore(), NameEntry_getName());
				TitleMenu_onEntry();
				scene = SCENE_TITLE;
			}
		}
		break;
	case SCENE_RANKING:
		{
			if(Ranking_loop()) {
				TitleMenu_onEntry();
				scene = SCENE_TITLE;
			}
		}
		break;
	}
}
