#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
int Collision(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
	if((x1 > (x2 + w2)) || (x2 > (x1 + w1))) { return 0; }
	if((y1 > (y2 + h2)) || (y2 > (y1 + h1))) { return 0; }
	return 1;
}
/*--------------------------------------------------------------------------*/
int Clamp(int value, int min, int max) {
	return clamp(value, min, max);
}
/*--------------------------------------------------------------------------*/
void DrawWave(int beginX, int frameCount) {
	int w = sprite_width(SPR_WAVE);
	int d = beginX % w;
	int x = (w * 2 + d - (frameCount / 20 % 4) * (w / 4)) % w;	//̈Ӗǂ܂łB
	GameCore_drawBitmap(x - w, 0, SPR_WAVE, 1);
	GameCore_drawBitmap(x    , 0, SPR_WAVE, 1);
	GameCore_drawBitmap(x + w, 0, SPR_WAVE, 1);
}
/*--------------------------------------------------------------------------*/
void DrawBottom(int beginX) {
	int w = sprite_width( SPR_BOTTOM);
	int h = sprite_height(SPR_BOTTOM);
	int y = SCREEN_HEIGHT - h;
	int x = beginX % w;
	GameCore_drawBitmap(x,         y, SPR_BOTTOM, 1);
	GameCore_drawBitmap(x + w,     y, SPR_BOTTOM, 1);
	GameCore_drawBitmap(x + w * 2, y, SPR_BOTTOM, 1);
}
