#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
#define ACC			(1<<7)		//0.5
/****************************************************************************
 *	
 ****************************************************************************/
int Torpedo_launch(int x, int y) {
	if(!Torpedo_exist()) {
		torpedo.x	= x;
		torpedo.y	= y;
		torpedo.vx	= 0;
		return 1;
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
void Torpedo_move() {
	if(!Torpedo_exist()) { return; }
	torpedo.vx += ACC - (torpedo.vx >> 4);
	torpedo.x  += torpedo.vx >> 8;
	if(torpedo.x >= FIELD_WIDTH) {
		Torpedo_inactivate();
	}
}
/*--------------------------------------------------------------------------*/
void Torpedo_draw() {
	if(!Torpedo_exist()) { return; }
	//body
	GameCore_drawBitmap(
		torpedo.x,
		torpedo.y - 1,
		SPR_TORPEDO,
		2);
	//shockwave
	if(torpedo.vx > (4 << 8)) {	//well accelerated
		int h = sprite_height(SPR_SHOCKWAVE0);
		GameCore_drawBitmap(torpedo.x -  8, torpedo.y - h / 2, SPR_SHOCKWAVE0, 2);
		GameCore_drawBitmap(torpedo.x - 16, torpedo.y - h / 2, SPR_SHOCKWAVE1, 2);
		GameCore_drawBitmap(torpedo.x - 24, torpedo.y - h / 2, SPR_SHOCKWAVE2, 2);
	}
}
/*--------------------------------------------------------------------------*/
void Torpedo_onHit() {
	Torpedo_inactivate();
}
/*--------------------------------------------------------------------------*/
void Torpedo_inactivate() {
	torpedo.x = EXIST_THRESHOLD;
}
/*--------------------------------------------------------------------------*/
int Torpedo_exist() {
	return torpedo.x > EXIST_THRESHOLD;
}
