#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
void TitleMenu_initialize() {
	titleMenu.cursor = TITLE_START_GAME;
}
/*--------------------------------------------------------------------------*/
void TitleMenu_onEntry() {
	titleMenu.waitTimer = SCENE_ENTRY_WAIT;	//for disabling input for a while
}
/*--------------------------------------------------------------------------*/
int TitleMenu_loop() {
	//controls
	//up
	if(joy & TRG_UP) {
		titleMenu.cursor--;
		if(titleMenu.cursor < TITLE_START_GAME) { titleMenu.cursor = TITLE_DISP_RANKING; }
	}
	//down
	if(joy & TRG_DN) {
		titleMenu.cursor++;
		if(titleMenu.cursor > TITLE_DISP_RANKING) { titleMenu.cursor = TITLE_START_GAME; }
	}
	//enter
	if((joy & TRG_AB) && !titleMenu.waitTimer) {
		if(titleMenu.cursor == TITLE_TOGGLE_SOUND) {
			gameCore.soundOn = !gameCore.soundOn;
		} else {
			return titleMenu.cursor;
		}
	}
	//=== drawing ===
	//logo and background
	GameCore_drawBitmap(
		10,
		(SCREEN_HEIGHT / 2) - (sprite_height(SPR_LOGO) / 2) - 1,
		SPR_LOGO,
		1);
	DrawWave(0, GameCore_frameCount());
	DrawBottom(0);
	//START
	GameCore_setCursor(70, 15);
	GameCore_print("START");
	//SOUND ON/OFF
	GameCore_setCursor(70, 28);
	GameCore_print("SOUND");
	GameCore_setCursor(105, 28);
	GameCore_print(gameCore.soundOn ? "ON" : "OFF");
	//RANKING
	GameCore_setCursor(70, 41);
	GameCore_print("RANKING");
	//cursor
	GameCore_setCursor(63, (titleMenu.cursor - 1) * 13 + 15);
	GameCore_print(">");
	//
	if(titleMenu.waitTimer) { titleMenu.waitTimer--; }
	return TITLE_NOINPUT;
}
