#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
#define SPD			(1<<7)
#define R2			90		//0.5/sqrt(2)/(1/256)
#define MARGIN			6
/****************************************************************************
 *	
 ****************************************************************************/
void Submarine_initialize() {
	submarine.x		= SUBMARINE_W << 8;
	submarine.y		= (SCREEN_HEIGHT / 2) << 8;
	submarine.extraLives	= START_LIVES;
	submarine.armor		= ARMOR_FRAMES;
}
/*--------------------------------------------------------------------------*/
void Submarine_move() {
	if(GameLevel_isGameover()) { return; }
	//control
	switch(joy & PAD_LRUD) {
	case PAD_LF|PAD_UP:	submarine.x -= R2;	submarine.y -= R2;	break;
	case PAD_RI|PAD_UP:	submarine.x += R2;	submarine.y -= R2;	break;
	case PAD_LF|PAD_DN:	submarine.x -= R2;	submarine.y += R2;	break;
	case PAD_RI|PAD_DN:	submarine.x += R2;	submarine.y += R2;	break;
	case PAD_LF:		submarine.x -= SPD;				break;
	case PAD_RI:		submarine.x += SPD;				break;
	case PAD_UP:					submarine.y -= SPD;	break;
	case PAD_DN:					submarine.y += SPD;	break;
	}
	//clamping into field
	submarine.x = Clamp(submarine.x, 0, (SCREEN_WIDTH - MARGIN) << 8);
	submarine.y = Clamp(submarine.y, (MARGIN - SUBMARINE_H) << 8, (SCREEN_HEIGHT - MARGIN) << 8);
	//launching torpedo
	if((submarine.extraLives >= 0) && (joy & PAD_AB)) {
		GameLevel_launchTorpedo(Submarine_fieldX() + 10, Submarine_fieldY() + 1);
	}
	//firing auto shot
#ifdef  LOW_FLASH_MEMORY
	if(!(GameLevel_frameCount() % 5)) {
		GameLevel_fireAutoShot(Submarine_fieldX() + 3, Submarine_fieldY() - 3);
	}
#else //LOW_FLASH_MEMORY
	if(!(GameLevel_frameCount() % 5) && GameLevel_lookForEnemy()) {
		GameLevel_fireAutoShot(Submarine_fieldX() + 3, Submarine_fieldY() - 3);
	}
#endif//LOW_FLASH_MEMORY
	//updating armor timer
	if(submarine.armor) { submarine.armor--; }
}
/*--------------------------------------------------------------------------*/
void Submarine_draw() {
	if(!submarine.armor || ((submarine.extraLives >= 0) && !(GameLevel_frameCount() / 3 % 2))) {
		GameCore_drawBitmap(
			Submarine_fieldX() - 1,
			Submarine_fieldY() - 2,
			SPR_SUBMARINE,
			2);
		if((GameLevel_frameCount() % ECHO_CYCLE) > 30) {	//sustain: 30 frames
			GameCore_drawPixel(
				Submarine_fieldX() + 6,
				Submarine_fieldY() - 1,
				1);
		}
	}
}
/*--------------------------------------------------------------------------*/
void Submarine_onHit() {
	if(!submarine.armor) {
		if(submarine.extraLives >= 0) {
			GameLevel_spawnParticle(
				Submarine_fieldX() - 2,
				Submarine_fieldY() - 4,
				PARTICLE_EXPLOSION);
				GameCore_tone(185, 250);
		}
		submarine.extraLives--;
		if(submarine.extraLives < 0) {
			GameLevel_setGameover();
			//ToDo: add gameover sfx
			Submarine_inactivate();
		}
		submarine.armor = ARMOR_FRAMES;
	}
}
/*--------------------------------------------------------------------------*/
void Submarine_inactivate() {
	submarine.x = FIXED_EXIST_THRESHOLD;
}
/*--------------------------------------------------------------------------*/
int Submarine_exist() {
	return submarine.x > FIXED_EXIST_THRESHOLD;
}
/*--------------------------------------------------------------------------*/
int Submarine_fieldX() {
	return submarine.x >> 8;
}
/*--------------------------------------------------------------------------*/
int Submarine_fieldY() {
	return submarine.y >> 8;
}
