#ifndef __STRUCT_H__
#define __STRUCT_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
//-----------------------------------------------------------------------------
typedef struct _GameCore {
	int		soundOn;
	double		quakeForce;
	int		qx, qy;
	int		cx, cy;		//cx,cyǉ܂BGameCore_setCursor(),GameCore_print()Ŏgp܂B
	int		tone_f;		//
	int		tone_d;		//tone_f,tone_d,tone_eǉ܂BGameCore_tone(),GameCore_stream_callback()Ŏgp܂B
	int		tone_e;		//
} GameCore;
//-----------------------------------------------------------------------------
typedef struct _TitleMenu {
	int		cursor;
	int		waitTimer;
} TitleMenu;
//-----------------------------------------------------------------------------
typedef struct _GameLevel {
	int		frames;
	int		score;
	double		prevSubmarineX, prevSubmarineY;
	int		gameoverCount;
} GameLevel;
//-----------------------------------------------------------------------------
typedef struct _NameEntry {
	char		name[RANKING_NAME_LEN];
	int		nameCursor;
	int		kbCursor;
	int		rank;
	int		score;
	int		exitCount;
	int		waitTimer;
} NameEntry;
//-----------------------------------------------------------------------------
typedef struct _Ranking {
	int		scores[RANKING_ENTRY_MAX];
	char		names[ RANKING_ENTRY_MAX][RANKING_NAME_LEN];
	int		waitTimer;
} Ranking;
//-----------------------------------------------------------------------------
typedef struct _Echo {
	int		intensities[ECHO_VERT_RESO];
	int		submarineX;
	int		acceptFlag;
} Echo;
//-----------------------------------------------------------------------------
typedef struct _Platoons {
	int		spawnYs[PLATOON_MAX];
	int		types[  PLATOON_MAX];
	int		timers[ PLATOON_MAX];
	int		status[ PLATOON_MAX];
} Platoons;
//-----------------------------------------------------------------------------
typedef struct _Generator {
	int		difficulty;
	int		zone;
	int		waveCount;
	int		waveIndex;
	int		progCount;
	int		delayTimer;
	int		dispTimer;
} Generator;
//-----------------------------------------------------------------------------
typedef struct _Submarine {
	int		x, y;		//fixed
	int		extraLives;
	int		armor;
} Submarine;
//-----------------------------------------------------------------------------
typedef struct _Torpedo {
	int		x, y;
	int		vx;		//fixed
} Torpedo;
//-----------------------------------------------------------------------------
typedef struct _AutoShot {
	int		x, y;
} AutoShot;
//-----------------------------------------------------------------------------
typedef struct _BigEnemy {
	int		x, y;
	int		state;
	int		timer;
} BigEnemy;
//-----------------------------------------------------------------------------
typedef struct _SmallEnemy {
	int		x, y;
	int		type;
	int		timer;
} SmallEnemy;
//-----------------------------------------------------------------------------
typedef struct _Bullet {
	int		x, y, vx, vy;	//fixed
	int		type;
} Bullet;
//-----------------------------------------------------------------------------
typedef struct _Particle {
	int		x, y;
	int		type;
	int		limit;
} Particle;
//-----------------------------------------------------------------------------
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__STRUCT_H__
