#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
#define ZIG_PERIOD		96
#define TRI_PERIOD		128
/****************************************************************************
 *	
 ****************************************************************************/
void SmallEnemy_initialize(SmallEnemy* smallEnemy, int y, int type) {
	smallEnemy->x		= FIELD_WIDTH;
	smallEnemy->y		= y;
	smallEnemy->type	= type;
	smallEnemy->timer	= 0;
}
/*--------------------------------------------------------------------------*/
void SmallEnemy_move(SmallEnemy* smallEnemy) {
	int period = !SmallEnemy_getType(smallEnemy) ? ZIG_PERIOD : TRI_PERIOD;
	switch(SmallEnemy_getType(smallEnemy)) {
	//zigzag
	case 0:
		{
			int d, typeCond, bulletType;
			double subAngle;
			//moving
			//x -= 1.5, y -= 0.5
			if(!(smallEnemy->timer % 2)) {
				smallEnemy->x -= 2;
				smallEnemy->y += !(smallEnemy->timer / (ZIG_PERIOD / 4) % 2) ? 1 : -1;
			} else {
				smallEnemy->x--;
			}
			//firing bullet
			d = GameLevel_difficulty();
			typeCond = SmallEnemy_canFire(smallEnemy) ||
				   (((d >= 70) && (d < 80)) || (d >= 100));		//[70,80) or 100
			if((smallEnemy->timer == 80) && typeCond &&			//time / type
			   (smallEnemy->x < (SCREEN_WIDTH - SMALLENEMY_W / 2)) &&	//position
			   (d >= 20)) {							//dont fire less than 20
				bulletType = (d >= 80) ? 3 : 1;				//rapid when 80 and over
				subAngle = GameLevel_getSubmarineAngle(
					smallEnemy->x,
					smallEnemy->y);
				GameLevel_fireBullet(
					smallEnemy->x,
					smallEnemy->y,
					subAngle,
					bulletType);
				//3way
				if(((d >= 50) && (d < 70)) || (d >= 90)) {
					GameLevel_fireBullet(
						smallEnemy->x,
						smallEnemy->y,
						subAngle - radians(10),
						1);
					GameLevel_fireBullet(
						smallEnemy->x,
						smallEnemy->y,
						subAngle + radians(10),
						1);
				}
			}
		}
		break;
	//triangle
	default:
		{
			int half, tmp, timeCond;
			//moving
			if(!(smallEnemy->timer % 6)) { smallEnemy->x--; }
			half = period / 2;
			tmp = half - smallEnemy->timer % half;
			tmp = (tmp * tmp) / (half * half / 4) - 1;
			if(tmp < 0) { tmp = 0; }
			smallEnemy->x -= tmp;
			//firing bullet
			timeCond = (smallEnemy->timer == 64) || 
				((GameLevel_difficulty() >= 25) && (smallEnemy->timer == 32)) || 
				((GameLevel_difficulty() >= 75) && (smallEnemy->timer == 96));
			if(timeCond && SmallEnemy_canFire(smallEnemy) &&				//time / type
			   ((smallEnemy->x < SCREEN_WIDTH) && (smallEnemy->x > SCREEN_WIDTH / 2)) &&	//position
			   (GameLevel_difficulty() >= 20)) {						//difficulty
				GameLevel_fireBullet(
					smallEnemy->x,
					smallEnemy->y,
					GameLevel_getSubmarineAngle(
						smallEnemy->x,
						smallEnemy->y),
						1);
			}
		}
		break;
	}
	//frame out
	if((smallEnemy->x + 12) < 0) {
		Platoons_checkBonus(SmallEnemy_getPlatoon(smallEnemy), 0);
		SmallEnemy_inactivate(smallEnemy);
	}
	//setting sonar reaction
	Echo_add(
		smallEnemy->x,
		smallEnemy->y,
		smallEnemy->y + SMALLENEMY_H);
	//updating timer
	smallEnemy->timer = (smallEnemy->timer + 1) % period;
}
/*--------------------------------------------------------------------------*/
void SmallEnemy_draw(SmallEnemy* smallEnemy) {
	if((smallEnemy->x - 4) > SCREEN_WIDTH) { return; }
	switch(SmallEnemy_getType(smallEnemy)) {
	//zigzag
	case 0:
		{
			static const int bitmaps[]={SPR_ZIGENEMY0,SPR_ZIGENEMY1};
			int frame = smallEnemy->timer / (ZIG_PERIOD / 4) % 2;
			GameCore_drawBitmap(
				smallEnemy->x - 3,
				smallEnemy->y - 3,
				bitmaps[frame],
				2);
		}
		break;
	//triangle
	default:
		{
			static const int bitmaps[]={SPR_TRIENEMY0,SPR_TRIENEMY1};
			int frame = (smallEnemy->timer % (TRI_PERIOD / 2)) < 24;
			GameCore_drawBitmap(
				smallEnemy->x - 3,
				smallEnemy->y - 4,
				bitmaps[frame],
				2);
			if(frame) {
				GameCore_drawBitmap(
					smallEnemy->x + 7,
					smallEnemy->y - 2,
					SPR_BOOSTEFFECT,
					2);
			}
		}
		break;
	}
}
/*--------------------------------------------------------------------------*/
void SmallEnemy_onHit(SmallEnemy* smallEnemy) {
	GameLevel_addScore(1);
	if(smallEnemy->x < (SCREEN_WIDTH + 20)) {	//near
		GameLevel_spawnParticle(
			smallEnemy->x - 5,
			smallEnemy->y - 4,
			PARTICLE_EXPLOSION);
			GameCore_tone(880, 62);
	}
	//platoon elimination
	if(Platoons_checkBonus(SmallEnemy_getPlatoon(smallEnemy), 1)) {
		if(smallEnemy->x < (SCREEN_WIDTH + 20)) {	//near
			GameLevel_spawnParticle(
				smallEnemy->x - 2,
				smallEnemy->y - 2,
				PARTICLE_TEN_POINT);
		}
		GameLevel_addScore(10);
	}
	SmallEnemy_inactivate(smallEnemy);
}
/*--------------------------------------------------------------------------*/
void SmallEnemy_inactivate(SmallEnemy* smallEnemy) {
	smallEnemy->x = EXIST_THRESHOLD;
}
/*--------------------------------------------------------------------------*/
int SmallEnemy_exist(SmallEnemy* smallEnemy) {
	return smallEnemy->x > EXIST_THRESHOLD;
}
/*--------------------------------------------------------------------------*/
int SmallEnemy_getType(SmallEnemy* smallEnemy) {
	return (smallEnemy->type >> 1) & 7;
}
/*--------------------------------------------------------------------------*/
int SmallEnemy_canFire(SmallEnemy* smallEnemy) {
	return !(smallEnemy->type & 1);
}
/*--------------------------------------------------------------------------*/
int SmallEnemy_getPlatoon(SmallEnemy* smallEnemy) {
	return smallEnemy->type >> 4;
}
