#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
static void fnReadFile(uint32_t Buffer[/*BakMgr_FileWords*/]) {
	FILE* fp = fopen(RANKING_FILENAME, "rb");
	if(!fp) { return; }
	fread(Buffer, 4, BakMgr_FileWords, fp);
	fclose(fp);
}
/*--------------------------------------------------------------------------*/
static void fnWriteFile(const uint32_t Buffer[/*BakMgr_FileWords*/]) {
	FILE* fp = fopen(RANKING_FILENAME, "wb");
	if(!fp) { return; }
	fwrite(Buffer, 4, BakMgr_FileWords, fp);
	fclose(fp);
}
/****************************************************************************
 *	
 ****************************************************************************/
void Ranking_initialize() {
	//obNAbvt@CǂݍށB
	extern uint8_t __START_DEFAULT_CODE[];	//R[ḧ̃nbVl߂āAMagicNumberƂB
	extern uint8_t __SIZEOF_DEFAULT_CODE[];	//
	BakMgr_Init(fnReadFile,
		    one_at_a_time_hash(__START_DEFAULT_CODE,	//R[ḧ̃nbVl߂āAMagicNumberƂB
			          (int)__SIZEOF_DEFAULT_CODE));	//
	//obNAbv̈o^B
	if(!BakMgr_Alloc(&ranking,
		         (sizeof ranking + 3) / 4, 1)) {	//VramWords[hPʂŎw肷鎖ɒӂB
		int i;
		for(i = 0; i < RANKING_ENTRY_MAX; i++) {
			ranking.scores[i] = (RANKING_ENTRY_MAX - i) * 100;	//500,400,300,200,100
			memset(ranking.names[i], 'A' + i, RANKING_NAME_LEN);	//AAA,BBB,CCC,DDD,EEE
		}
	}
}
/*--------------------------------------------------------------------------*/
void Ranking_onEntry() {
	ranking.waitTimer = SCENE_ENTRY_WAIT;	//for disabling input for a while
}
/*--------------------------------------------------------------------------*/
int Ranking_loop() {
	int i;
	//return title menu
	if((joy & (TRG_AB|TRG_SELECT)) && !ranking.waitTimer) {
		return 1;
	}
	//draw
	//background
	DrawWave(0, GameCore_frameCount());
	DrawBottom(0);
	//entries
	for(i = 0; i < RANKING_ENTRY_MAX; i++) {
		GameCore_setCursor(32, i * 10 + 9);
		GameCore_print("%1d  %.3s  %05d",
			i + 1,
			ranking.names[i],
			ranking.scores[i]);
	}
	//
	if(ranking.waitTimer) { ranking.waitTimer--; }
	return 0;
}
/*--------------------------------------------------------------------------*/
//as scoring manager
//returns 0-4. +1 when display
int Ranking_getRank(int score) {
	int rank;
	for(rank = 0; rank < RANKING_ENTRY_MAX; rank++) {
		if(score > ranking.scores[rank]) { break; }
	}
	return rank;
}
/*--------------------------------------------------------------------------*/
void Ranking_enterScore(int score, const char* name) {
	int i;
	int rank = Ranking_getRank(score);
	if(rank >= RANKING_ENTRY_MAX) { return; }
	//slide entry
	for(i = RANKING_ENTRY_MAX - 1; i > rank; i--) {
		       ranking.scores[i] = ranking.scores[i - 1];
		memcpy(ranking.names[ i],  ranking.names[ i - 1], RANKING_NAME_LEN);
	}
	//enter
	       ranking.scores[i] = score;
	memcpy(ranking.names[ i],  name, RANKING_NAME_LEN);
	//obNAbvt@CXVB
	BakMgr_Exec();	//YȂ!!
	BakMgr_Commit(fnWriteFile);
}
